/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.client.PoiEventUserModelCellAddress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PoiEventUserModelXlsxReader {
    private static final Logger logger = CoreUIObject.getLogger(PoiEventUserModelXlsxReader.class);
    private static Map<String, SimpleDateFormat> dateFormats = new HashMap<String, SimpleDateFormat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, List<List<String>>> read(File file) throws OpenXML4JException, IOException, SAXException {
        LinkedHashMap<String, List<List<String>>> result = new LinkedHashMap<String, List<List<String>>>();
        OPCPackage pk = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pk);
        XSSFReader reader = new XSSFReader(pk);
        StylesTable styles = reader.getStylesTable();
        XSSFReader.SheetIterator it = (XSSFReader.SheetIterator)reader.getSheetsData();
        while (it.hasNext()) {
            InputStream stream = it.next();
            try {
                String sheetName = it.getSheetName();
                SheetHandler sheetHandler = new SheetHandler();
                PoiEventUserModelXlsxReader.processSheet(styles, strings, sheetHandler, stream);
                List<List<String>> rows = sheetHandler.getRows();
                if (rows == null || rows.size() <= 0) continue;
                result.put(sheetName, rows);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        pk.close();
        return result;
    }

    public static void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        CustomDataFormatter formatter = new CustomDataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = XMLHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, null, (SharedStrings)strings, sheetHandler, (DataFormatter)formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    private static SimpleDateFormat getDateFormat(String pattern) {
        if (dateFormats.containsKey(pattern)) {
            return dateFormats.get(pattern);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormats.put(pattern, dateFormat);
        return dateFormat;
    }

    public static void main(String[] arsg) throws IOException, OpenXML4JException, SAXException {
        LinkedHashMap<String, List<List<String>>> datas = PoiEventUserModelXlsxReader.read(new File("sax2.xlsx"));
        for (String name : datas.keySet()) {
            List<List<String>> lines = datas.get(name);
            System.out.println(name + ":");
            for (List<String> line : lines) {
                System.out.println(line);
            }
            System.out.println(lines.size());
        }
    }

    private static class CustomDataFormatter
    extends DataFormatter {
        private CustomDataFormatter() {
        }

        public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
            if (DateUtil.isADateFormat((int)formatIndex, (String)formatString) && DateUtil.isValidExcelDate((double)value)) {
                Date d = DateUtil.getJavaDate((double)value, (boolean)use1904Windowing);
                String fs = formatString.toLowerCase();
                String pattern = "yyyy";
                if (fs.indexOf(47) >= 0) {
                    pattern = pattern + '/';
                    pattern = fs.indexOf("dd") >= 0 ? pattern + "MM/dd" : pattern + "M/d";
                } else {
                    pattern = pattern + '-';
                    pattern = fs.indexOf("dd") >= 0 ? pattern + "MM-dd" : pattern + "M-d";
                }
                if (fs.indexOf(104) >= 0) {
                    pattern = pattern + " HH:mm:ss";
                }
                try {
                    return PoiEventUserModelXlsxReader.getDateFormat(pattern).format(d);
                }
                catch (Exception e) {
                    logger.error((Object)("Bad date value in Excel: " + d), (Throwable)e);
                }
            }
            return super.formatRawCellContents(value, formatIndex, formatString, use1904Windowing);
        }
    }

    private static class SheetHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private int currentRow = -1;
        private int currentCol = -1;
        private List<List<String>> rows = new LinkedList<List<String>>();
        private List<String> hRow = null;
        private List<String> row;

        private SheetHandler() {
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        private void outputMissingRows(int number) {
            for (int i = 0; i < number; ++i) {
                this.addRow(new ArrayList<String>());
            }
        }

        public void startRow(int rowNum) {
            this.outputMissingRows(rowNum - this.currentRow - 1);
            this.row = new ArrayList<String>();
            this.currentRow = rowNum;
            this.currentCol = -1;
        }

        public void endRow(int rowNum) {
            this.addRow(this.row);
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            if (cellReference == null) {
                cellReference = new PoiEventUserModelCellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            int missedCols = thisCol - this.currentCol - 1;
            for (int i = 0; i < missedCols; ++i) {
                this.row.add("");
            }
            this.currentCol = thisCol;
            this.row.add(formattedValue);
        }

        private void addRow(List<String> row) {
            if (this.hRow == null) {
                if (row.size() == 0) {
                    // empty if block
                }
                this.hRow = row;
            }
            this.rows.add(row);
        }

        public void headerFooter(String arg0, boolean arg1, String arg2) {
        }
    }
}

