/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.PostVoucherCheckReturn;
import com.kingdee.eas.fi.gl.client.AbstractPostVoucherBatchUI;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.client.ReqCheckUIHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class PostVoucherBatchUI
extends AbstractPostVoucherBatchUI {
    protected CompanyOrgUnitInfo curCompany;
    protected UserInfo curUser;
    protected PeriodInfo curPeriod;
    private IGLPeriodEndFacade periodEndCtrl;
    private GLPeriodEndFilter filter;
    private int iSuccess = 0;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchInitData();
        this.initHeaderStyle();
        this.loadFields();
        HelpUtils.addCSHelp((JComponent)((Object)this));
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        ActionMap actionMap = this.getActionMap();
        Action act = actionMap.get("EASHelp");
        act.actionPerformed(e);
    }

    private void initHeaderStyle() {
        this.kdlblPic.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.rbAllUnPosted.setSelected(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.dtpVchDate.setValue((Object)this.curPeriod.getEndDate());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.iSuccess == 0) {
            this.doOK();
        } else {
            this.destroyWindow();
        }
    }

    private void doOK() throws Exception {
        this.txtaResult.setText("");
        if (this.checkDataObject()) {
            Date dtVchDate;
            boolean isAllUnPosted = this.rbAllUnPosted.isSelected();
            this.filter.setFilterPostBatchIsAllUnPosted(isAllUnPosted);
            if (!isAllUnPosted) {
                dtVchDate = this.dtpVchDate.getSqlDate();
                this.filter.setFilterVchDate((java.util.Date)dtVchDate);
            } else {
                dtVchDate = new Date(this.curPeriod.getEndDate().getTime());
                this.filter.setFilterVchDate((java.util.Date)dtVchDate);
            }
            if (this.filter.isParamUseAC() && this.filter.isReqCheckOnPost()) {
                ReqCheckCondition condition = new ReqCheckCondition();
                condition.setCompany(this.filter.getCurCompany());
                condition.setPeriodID(this.filter.getCurPeriod().getId().toString());
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put("condition", condition);
                ReqCheckUIHelper.checkRequisition((Map)uiContext);
            }
            PostVoucherCheckReturn[] checkReturn = null;
            checkReturn = this.getBizInterface().postVoucherBatch(this.filter);
            if (checkReturn == null) {
                this.txtaResult.append(EASResource.getString((String)RESOURCE_PATH, (String)"succPostVoucherBatch"));
                this.setBtnOKOK();
            } else if (checkReturn.length > 0) {
                int iLenth = checkReturn.length;
                StringBuffer errStr = new StringBuffer();
                errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"checkPostVoucherErr"));
                errStr.append("\r\n");
                for (int i = 0; i < iLenth; ++i) {
                    errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"VoucherNumber"));
                    errStr.append(":");
                    errStr.append(checkReturn[i].getVoucherNumber().toString());
                    errStr.append("; ");
                    if (checkReturn[i].getVeSeq() != -1) {
                        errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"VoucherEntrySeq"));
                        errStr.append(":");
                        errStr.append(checkReturn[i].getVeSeq());
                        errStr.append("; ");
                        if (checkReturn[i].getAsstSeq() != -1) {
                            errStr.append(EASResource.getString((String)RESOURCE_PATH, (String)"VoucherAssistSeq"));
                            errStr.append(":");
                            errStr.append(checkReturn[i].getAsstSeq());
                            errStr.append("; ");
                        }
                    }
                    errStr.append(checkReturn[0].getErrorTip());
                    errStr.append("\r\n");
                }
                this.txtaResult.append(errStr.toString());
            } else {
                this.txtaResult.append(EASResource.getString((String)RESOURCE_PATH, (String)"errPostVoucherBatch"));
            }
        }
    }

    protected boolean checkDataObject() {
        if (this.rbByDate.isSelected()) {
            java.util.Date dtVchDate = (java.util.Date)this.dtpVchDate.getValue();
            if (dtVchDate == null) {
                String postInvalidVchDate = EASResource.getString((String)RESOURCE_PATH, (String)"postInvalidVchDate");
                this.txtaResult.append(postInvalidVchDate);
                this.dtpVchDate.requestFocus();
                return false;
            }
            if (dtVchDate.compareTo(this.curPeriod.getBeginDate()) < 0 || dtVchDate.compareTo(this.curPeriod.getEndDate()) > 0) {
                String postInvalidVchDate = EASResource.getString((String)RESOURCE_PATH, (String)"postInvalidVchDate");
                this.txtaResult.append(postInvalidVchDate);
                this.dtpVchDate.requestFocus();
                return false;
            }
        }
        return true;
    }

    protected IGLPeriodEndFacade getBizInterface() throws Exception {
        this.periodEndCtrl = GLPeriodEndFacadeFactory.getRemoteInstance();
        return this.periodEndCtrl;
    }

    private void fetchInitData() throws Exception {
        this.filter = new GLPeriodEndFilter();
        this.filter = this.getBizInterface().fetchInitData();
        this.curUser = this.filter.getCurUser();
        this.curCompany = this.filter.getCurCompany();
        this.curPeriod = this.filter.getCurPeriod();
    }

    private void setBtnOKOK() {
        this.iSuccess = 1;
        this.btnOK.setText(EASResource.getString((String)RESOURCE_PATH, (String)"btnOKText"));
    }
}

