/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.HGRepairData;
import com.kingdee.eas.fi.gl.HGRepairToolFacadeFactory;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.RepairData;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractRepairlUI;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RepairlUI
extends AbstractRepairlUI {
    private static final Logger logger = CoreUIObject.getLogger(RepairlUI.class);
    private ICellEditor numberEditor = null;
    protected ObjectValueRender normalObjectRender;
    protected CellTextRender dateRender;
    private RepairData repairData = null;
    private DateFormat df;
    private CellTextRender numRender;
    protected IBasicRender textRender;
    static final String ASSITEM_PREFIX = "#";
    private AccountViewInfo aview;
    private CurrencyInfo currencyInfo;

    public void onLoad() throws Exception {
        this.repairData = (RepairData)this.getUIContext().get("param");
        this.df = DateFormat.getDateInstance(1, Locale.CHINA);
        BizDataFormat format = null;
        format = new BizDataFormat("$number$ $name$");
        this.normalObjectRender = new ObjectValueRender();
        this.normalObjectRender.setFormat((IDataFormat)format);
        this.dateRender = new CellTextRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null) {
                    super.draw(graphics, clip, (Object)RepairlUI.this.df.format(object), cellStyle);
                }
            }
        };
        this.numRender = new CellTextRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null) {
                    if (object instanceof BigDecimal) {
                        BigDecimal val = (BigDecimal)object;
                        super.draw(graphics, clip, (Object)GlUtils.withComma(val, val.scale()), cellStyle);
                    } else if (object instanceof String) {
                        BigDecimal val = new BigDecimal((String)object);
                        super.draw(graphics, clip, (Object)GlUtils.withComma(val, val.scale()), cellStyle);
                    } else {
                        super.draw(graphics, clip, object, cellStyle);
                    }
                }
            }
        };
        this.aview = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(this.repairData.getColumn11()));
        this.currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.repairData.getColumn12()));
        this.textRender = this.tbl.getDefaultRenderer(String.class);
        super.onLoad();
        this.setUICom();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"89_RepairlUI"));
    }

    private void setUICom() throws Exception {
        this.setTxtMsg();
        this.setTable();
    }

    @Override
    public void actionRepair_actionPerformed(ActionEvent e) throws Exception {
        HGRepairData hd = new HGRepairData();
        int rowCount = this.tbl.getRowCount();
        int columnCount = this.tbl.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                String column = this.tbl.getColumnKey(col);
                Object value = this.tbl.getRow(row).getCell(column).getValue();
                if (value == null) {
                    MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"90_RepairlUI"));
                    SysUtil.abort();
                }
                hd.put(column, value);
            }
        }
        hd.setAv(this.aview);
        hd.setAssID(this.repairData.getVarid());
        HGRepairToolFacadeFactory.getRemoteInstance().repair(hd);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void setTable() throws Exception {
        String colKey;
        Object[] info = this.getFacadeInterface().fetchAssColumnInfo(this.repairData.getColumn11(), this.aview.getCAA().getId().toString(), null);
        VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        int beginIndexOfAssItem = 0;
        for (int i = 0; i < assItemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
            if (colInfo == null || colInfo.getColName() == null || colInfo.getColName().length() == 0) continue;
            IColumn col = this.tbl.addColumn(beginIndexOfAssItem);
            col.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
            colKey = ASSITEM_PREFIX + colInfo.getMappingPropName();
            col.setWidth(200);
            col.setEditor(this.getCellEditor(colInfo, this.aview, this.currencyInfo));
            col.setRenderer(this.getCellRender(colInfo));
            col.setKey(colKey);
            col.setUserObject((Object)colInfo);
            this.tbl.getHeadMergeManager().mergeBlock(0, beginIndexOfAssItem, 1, beginIndexOfAssItem);
            ++beginIndexOfAssItem;
        }
        IRow headRow = this.tbl.addHeadRow();
        for (int i = 0; i < assItemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
            colKey = ASSITEM_PREFIX + colInfo.getMappingPropName();
            headRow.getCell(colKey).setValue((Object)colInfo.getColName());
        }
        this.tbl.addRow();
    }

    private void setTxtMsg() {
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI"));
        sb.append(this.repairData.getVoucherNumber()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"92_RepairlUI"));
        sb.append(this.repairData.getAccountViewName()).append("(").append(this.repairData.getAccountViewNumber());
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"93_RepairlUI"));
        String msg = sb.toString();
        this.txtMsg.setText(msg);
    }

    protected IVoucherFacade getFacadeInterface() throws Exception {
        return VoucherFacadeFactory.getRemoteInstance();
    }

    protected ICellEditor getCellEditor(VoucherInfo.DynamicColumnInfo colInfo, AccountViewInfo acc, CurrencyInfo cur) {
        AssistCustomizedDataTypeEnum dataType = colInfo.getDataType();
        if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)dataType)) {
            KDBizPromptBox bizPromptBox = null;
            if (bizPromptBox == null) {
                SelectorItemCollection sic;
                bizPromptBox = new KDBizPromptBox();
                bizPromptBox.setEditable(true);
                bizPromptBox.setEditFormat("$number$");
                bizPromptBox.setDisplayFormat("$number$;$name$");
                bizPromptBox.setCommitFormat("$number$;$name$");
                bizPromptBox.setQueryInfo(colInfo.getDefaultQueryName());
                bizPromptBox.setDefaultF7UIName(colInfo.getDefaultF7UI());
                if (cur != null) {
                    GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)colInfo.getGrp(), (String)colInfo.getMappingPropName(), (boolean)colInfo.getIsForCompany(), (boolean)true, (String)acc.getId().toString(), (CoreUIObject)this, (boolean)true);
                } else {
                    GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)colInfo.getGrp(), (String)colInfo.getMappingPropName(), (boolean)colInfo.getIsForCompany(), (boolean)true, (String)acc.getId().toString(), (CoreUIObject)this, (boolean)true);
                }
                if (colInfo.isMultilevel() && colInfo.getGroupTableName() == null && (sic = bizPromptBox.getSelectorCollection()) != null) {
                    sic.add(new SelectorItemInfo("longNumber"));
                }
            }
            return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        }
        if (AssistCustomizedDataTypeEnum.ENUM.equals((Object)dataType)) {
            return GLEditor.getComboBox(colInfo.getDefaultQueryName());
        }
        if (AssistCustomizedDataTypeEnum.DATE.equals((Object)dataType)) {
            KDDatePicker kddate = new KDDatePicker();
            kddate.setValue((Object)new Date());
            kddate.setSupportedEmpty(false);
            return new KDTDefaultCellEditor(kddate);
        }
        if (AssistCustomizedDataTypeEnum.FLOAT.equals((Object)dataType) || AssistCustomizedDataTypeEnum.INTEGER.equals((Object)dataType)) {
            return this.numberEditor;
        }
        return this.getTextEditor();
    }

    protected IBasicRender getCellRender(VoucherInfo.DynamicColumnInfo colInfo) {
        AssistCustomizedDataTypeEnum dataType = colInfo.getDataType();
        if (AssistCustomizedDataTypeEnum.BUSINESSOBJECT.equals((Object)dataType)) {
            return this.normalObjectRender;
        }
        if (AssistCustomizedDataTypeEnum.DATE.equals((Object)dataType)) {
            return this.dateRender;
        }
        if (AssistCustomizedDataTypeEnum.FLOAT.equals((Object)dataType) || AssistCustomizedDataTypeEnum.INTEGER.equals((Object)dataType)) {
            return this.numRender;
        }
        return this.textRender;
    }

    protected ICellEditor getTextEditor() {
        KDTDefaultCellEditor textEditor = new KDTDefaultCellEditor((JTextField)new KDTextField());
        textEditor.setClickCountToStart(1);
        return textEditor;
    }
}

