/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryHelper;
import com.kingdee.eas.base.commonquery.client.CommonQueryParam;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportExchangeRateAdjustCondition;
import com.kingdee.eas.fi.gl.client.AbstractReportAdjustExchangeRateUI;
import com.kingdee.eas.fi.gl.client.ReportExchangeRateAdjustConditionUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class ReportAdjustExchangeRateUI
extends AbstractReportAdjustExchangeRateUI {
    CommonQueryParam commonQueryParam = null;
    ReportExchangeRateAdjustConditionUI conditionPanel = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String strFormat = this.getNumberFormat();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getGroupManager().setGroup(true);
        int indexYear = this.tblMain.getColumnIndex("periodYear");
        int indexNumber = this.tblMain.getColumnIndex("periodNumber");
        this.tblMain.getColumn(indexYear).setGroup(true);
        this.tblMain.getColumn(indexNumber).setGroup(true);
        this.tblMain.getGroupManager().setTotalize(true);
        this.tblMain.getColumn(indexYear).setStat(false);
        this.tblMain.getColumn(indexNumber).setStat(true);
        this.tblMain.getGroupManager().setOrientation(1);
        int indexBalanceBefore = this.tblMain.getColumnIndex("balanceBefore");
        int indexBalanceAfter = this.tblMain.getColumnIndex("balanceAfter");
        int indexBalanceAdjust = this.tblMain.getColumnIndex("balanceAdjust");
        IRow row0 = this.tblMain.getGroupManager().getStatRowTemplate(-1);
        row0.getStyleAttributes().setBackground(Color.YELLOW);
        int intAccountName = this.tblMain.getColumnIndex("accountname");
        String strTotal = this.getResx(this.getResourceName(), "TOTAL");
        row0.getCell(intAccountName).setValue((Object)strTotal);
        row0.getCell(indexBalanceBefore).setExpressions("SUM");
        row0.getCell(indexBalanceBefore).getFormattedStyleAttributes().setNumberFormat(strFormat);
        row0.getCell(indexBalanceAfter).setExpressions("SUM");
        row0.getCell(indexBalanceAfter).getFormattedStyleAttributes().setNumberFormat(strFormat);
        row0.getCell(indexBalanceAdjust).setExpressions("SUM");
        row0.getCell(indexBalanceAdjust).getFormattedStyleAttributes().setNumberFormat(strFormat);
        row0 = this.tblMain.getGroupManager().getStatRowTemplate(1);
        row0.getStyleAttributes().setBackground(Color.YELLOW);
        String strSubTotal = this.getResx(this.getResourceName(), "SUBTOTAL");
        row0.getCell(intAccountName).setValue((Object)strSubTotal);
        row0.getCell(indexBalanceBefore).setExpressions("SUM");
        row0.getCell(indexBalanceBefore).getFormattedStyleAttributes().setNumberFormat(strFormat);
        row0.getCell(indexBalanceAfter).setExpressions("SUM");
        row0.getCell(indexBalanceAfter).getFormattedStyleAttributes().setNumberFormat(strFormat);
        row0.getCell(indexBalanceAdjust).setExpressions("SUM");
        row0.getCell(indexBalanceAdjust).getFormattedStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexYear).setMergeable(false);
        this.tblMain.getColumn(indexNumber).setMergeable(false);
        int indexBalanceFor = this.tblMain.getColumnIndex("balanceFor");
        int indexExchageRateBefore = this.tblMain.getColumnIndex("exchRateBefore");
        int indexExchageRateAfter = this.tblMain.getColumnIndex("exchRateAfter");
        this.tblMain.getColumn(indexBalanceFor).getStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexExchageRateBefore).getStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexBalanceBefore).getStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexExchageRateAfter).getStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexBalanceAfter).getStyleAttributes().setNumberFormat(strFormat);
        this.tblMain.getColumn(indexBalanceAdjust).getStyleAttributes().setNumberFormat(strFormat);
        this.setColumnWidth();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnView.setVisible(false);
        this.btnRemove.setVisible(false);
    }

    public String getNumberFormat() {
        String strFormat = "%r-[0]{#,###";
        int iPrecision = 2;
        for (int i = 0; i < iPrecision; ++i) {
            if (i == 0) {
                strFormat = strFormat + ".";
            }
            strFormat = strFormat + "#";
        }
        strFormat = strFormat + "}f";
        return strFormat;
    }

    public void setColumnWidth() {
        int indexYear = this.tblMain.getColumnIndex("periodYear");
        int indexNumber = this.tblMain.getColumnIndex("periodNumber");
        int indexAccountCode = this.tblMain.getColumnIndex("number");
        int indexAccountName = this.tblMain.getColumnIndex("accountname");
        int indexCurrencyName = this.tblMain.getColumnIndex("currencyname");
        int indexDC = this.tblMain.getColumnIndex("DC");
        int indexBalanceFor = this.tblMain.getColumnIndex("balanceFor");
        int indexBalanceBefore = this.tblMain.getColumnIndex("balanceBefore");
        int indexExchageRateBefore = this.tblMain.getColumnIndex("exchRateBefore");
        int indexBalanceAfter = this.tblMain.getColumnIndex("balanceAfter");
        int indexExchageRateAfter = this.tblMain.getColumnIndex("exchRateAfter");
        int indexBalanceAdjust = this.tblMain.getColumnIndex("balanceAdjust");
        this.tblMain.getColumn(indexYear).setWidth(80);
        this.tblMain.getColumn(indexNumber).setWidth(80);
        this.tblMain.getColumn(indexAccountCode).setWidth(80);
        this.tblMain.getColumn(indexAccountName).setWidth(150);
        this.tblMain.getColumn(indexCurrencyName).setWidth(150);
        this.tblMain.getColumn(indexDC).setWidth(60);
        this.tblMain.getColumn(indexBalanceFor).setWidth(120);
        this.tblMain.getColumn(indexBalanceBefore).setWidth(120);
        this.tblMain.getColumn(indexExchageRateBefore).setWidth(110);
        this.tblMain.getColumn(indexBalanceAfter).setWidth(120);
        this.tblMain.getColumn(indexExchageRateAfter).setWidth(110);
        this.tblMain.getColumn(indexBalanceAdjust).setWidth(120);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.openConditionDialog();
    }

    protected void openConditionDialog() throws Exception {
        CommonQueryHelper commonQueryHelper = new CommonQueryHelper();
        if (commonQueryHelper.showDialog(this.getCommonQueryParam(), (Component)((Object)this))) {
            EntityViewInfo queryInfo = commonQueryHelper.getEntityViewInfoResult();
            ReportExchangeRateAdjustCondition condition = this.getConditionPanel().getCustomCondition();
            this.mainQuery = queryInfo;
            this.setReportExtraTitle(condition);
            this.tblMain.removeRows();
        }
    }

    public CommonQueryParam getCommonQueryParam() throws Exception {
        EntityViewInfo mainQuery = new EntityViewInfo();
        this.commonQueryParam = new CommonQueryParam();
        this.commonQueryParam.setEntityViewInfo(mainQuery);
        this.commonQueryParam.setQueryObjectPK(this.mainQueryPK);
        this.commonQueryParam.setShowFilter(false);
        this.commonQueryParam.setShowSorter(false);
        this.commonQueryParam.addPanel((KDPanel)this.getConditionPanel());
        return this.commonQueryParam;
    }

    public ReportExchangeRateAdjustConditionUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ReportExchangeRateAdjustConditionUI();
            this.conditionPanel.setInitData(this.getInitData());
            this.conditionPanel.setPanelName(this.conditionPanel.getUITitle());
        }
        return this.conditionPanel;
    }

    private Map getInitData() throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllCurrency", this.getAllCurrency());
        map.put("PeriodRange", this.getPeriodRange());
        map.put("DefaultCurrency", this.getDefaultCurrency());
        map.put("CurrentPeriod", this.getCurrentPeriod());
        return map;
    }

    protected CurrencyInfo getDefaultCurrency() throws BOSException {
        String strCompanyId = (String)SysContext.getSysContext().getProperty((Object)"CurCompanyId");
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(strCompanyId);
        CompanyOrgUnitInfo company = null;
        try {
            company = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        CurrencyInfo defaultCurrecy = null;
        if (company != null) {
            defaultCurrecy = company.getBaseCurrency();
        }
        return defaultCurrecy;
    }

    private CurrencyCollection getAllCurrency() throws BOSException {
        ICurrency currency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyCollection = currency.getCurrencyCollection();
        return currencyCollection;
    }

    protected Map getPeriodRange() throws BOSException {
        HashMap<Object, int[]> map = new HashMap<Object, int[]>();
        IPeriod period = PeriodFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("periodYear"));
        sorters.add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodCollection = period.getPeriodCollection(view);
        Vector<Integer> vecYear = new Vector<Integer>();
        if (periodCollection != null && periodCollection.size() != 0) {
            int firstNumber;
            int firstYear;
            int lastYear = firstYear = periodCollection.get(0).getPeriodYear();
            int lastNumber = firstNumber = periodCollection.get(0).getPeriodNumber();
            for (int i = 1; i < periodCollection.size() - 1; ++i) {
                int currentYear = periodCollection.get(i).getPeriodYear();
                int currentNumber = periodCollection.get(i).getPeriodNumber();
                if (currentYear != lastYear) {
                    vecYear.add(new Integer(lastYear));
                    int[] periodRange = new int[]{firstNumber, lastNumber};
                    map.put(new Integer(lastYear), periodRange);
                }
                lastYear = currentYear;
                lastNumber = currentNumber;
            }
            int[] periodRange = new int[]{firstNumber, lastNumber};
            map.put(new Integer(lastYear), periodRange);
            int[] periodYearRange = new int[]{firstYear, lastYear};
            map.put("YearRange", periodYearRange);
        }
        return map;
    }

    protected PeriodInfo getCurrentPeriod() throws BOSException {
        PeriodInfo periodInfo = new PeriodInfo();
        periodInfo.setPeriodYear(2004);
        periodInfo.setPeriodNumber(5);
        return periodInfo;
    }

    public void setReportExtraTitle(ReportExchangeRateAdjustCondition condition) {
        if (condition == null) {
            return;
        }
        String strPrePeriod = this.getResx("PREPERIOD");
        String strPreCurrency = this.getResx("PRECURRENCY");
        int yearBegin = condition.getPeriodYearStart();
        int numberBegin = condition.getPeriodNumberStart();
        int yearEnd = condition.getPeriodYearEnd();
        int numberEnd = condition.getPeriodNumberEnd();
        String txtPeriod = strPrePeriod + RptClientUtil.getPeriodTitle(yearBegin, numberBegin, yearEnd, numberEnd);
        this.lblPeriod.setText(txtPeriod);
        this.lblCurrency.setText(strPreCurrency + condition.getCurrencyName());
    }

    private String getResx(String resxItemName) {
        Locale locale = this.getCurrentLocale();
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    private String getResx(String strResName, String resxItemName) {
        Locale locale = this.getCurrentLocale();
        return ResourceBase.getString((String)strResName, (String)resxItemName, (Locale)locale);
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportAdjustExchangeRateUI";
    }
}

