/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.IGLReportAssistTree;
import com.kingdee.eas.fi.gl.IReportConditionAssist;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.client.AbstractReportAssistBaseUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.common.print.MultiPrint;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ReportAssistBaseUI
extends AbstractReportAssistBaseUI
implements KDTDataRequestListener,
IRequestTableData {
    private static final long serialVersionUID = 4598372556842299184L;
    private static final Logger logger = CoreUIObject.getLogger(ReportAssistBaseUI.class);
    protected boolean requesting = false;
    protected DefaultKingdeeTreeNode selectAccountNode = null;
    public static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    public static final Color DAY_SUM_COLOR = new Color(16119270);
    public static final Color DAY_TOTAL_COLOR = new Color(15789529);
    public static final Color PERIOD_TOTAL_COLOR = new Color(15262923);
    public static final Color YEAR_TOTAL_COLOR = new Color(15327928);
    public static final Color TOTAL_COLOR = new Color(0xF6F6BF);
    public static final String ENTITY_VIEW = "EntityView";
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    EntityViewInfo condition = null;
    AccountViewInfo accountViewInfo = null;
    ReportTableHeadInfo currentTableHeadInfo = null;
    ReportResultInfo result = null;
    private String tempTableName = null;
    protected String titleAssistItem = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportAssistBaseUI", (String)"PreAssist");
    boolean assitemShowNumber = false;
    boolean assitemShowLongName = false;
    private boolean initPrint = false;
    private CompanyOrgUnitInfo currentCompany = null;
    protected String assistItemName = null;
    private String accountName = null;
    private boolean isNeedInitHead = true;
    ExtVarProvider evp = new ExtVarProvider(){

        public Variant requestVarData(String varName) {
            return ReportAssistBaseUI.this.tableRequestPrintData(varName);
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        ReportConditionBase glCondition = this.getConditionFromUIContext();
        this.lblPeriod.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportAssistBaseUI", (String)"PrePeriod") + this.getPeriodTitle(glCondition.getPeriodYearStart(), glCondition.getPeriodNumberStart(), glCondition.getPeriodYearEnd(), glCondition.getPeriodNumberEnd()));
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportAssistBaseUI", (String)"PreCurrency"));
        sb.append(glCondition.getCurrencyName());
        this.lblCurrency.setText(sb.toString());
        this.lblAssist.setText(this.titleAssistItem);
        this.initTable(this.getTable());
        this.initTree(this.getTree());
        this.splpMain.setDividerLocation(240);
        this.initTableHead(this.getDefalutTableHead(), this.getTable());
        this.refreshAssistTree();
        this.displayNoLinkForRpt();
        this.checkTableCommonMenu(this.table);
    }

    private void displayNoLinkForRpt() {
        KDPopupMenu pop = this.getMenuManager(this.table).getMenu();
        int count = pop.getComponentCount();
        block0: for (int i = 0; i < count; ++i) {
            Component menu = pop.getComponent(i);
            if (!(menu instanceof KDMenu) || menu == null || menu.getName() == null) continue;
            KDMenu m = (KDMenu)menu;
            Component[] menuComponents = m.getMenuComponents();
            for (int j = 0; menuComponents != null && j < menuComponents.length; ++j) {
                if (!menuComponents[j].getName().equalsIgnoreCase("menuItemToLinkForRpt")) continue;
                menuComponents[j].setVisible(false);
                if (j - 1 <= -1 || !(menuComponents[j - 1] instanceof JSeparator)) continue block0;
                menuComponents[j - 1].setVisible(false);
                continue block0;
            }
        }
    }

    protected ReportConditionBase getConditionFromUIContext() throws Exception {
        Map uiContext = this.getUIContext();
        Object entityView = uiContext.get(ENTITY_VIEW);
        if (entityView == null || !EntityViewInfo.class.isInstance(entityView)) {
            throw new ReportException(ReportException.ENTITY_EMPTY);
        }
        this.condition = (EntityViewInfo)entityView;
        Object glCondition = this.condition.get("GLFixCondition");
        if (glCondition == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        if (!ReportConditionBase.class.isInstance(glCondition)) {
            throw new ReportException(ReportException.NOT_EXTEND_CONDITIONBASE);
        }
        if (!IReportConditionAssist.class.isInstance(glCondition)) {
            throw new ReportException(ReportException.NOT_IMPLEMENTS_INTERFACE);
        }
        return (ReportConditionBase)glCondition;
    }

    protected ReportTableHeadInfo getDefalutTableHead() throws ReportException {
        throw new ReportException(ReportException.TABLEHEAD_EMPTY);
    }

    protected KDTable getTable() {
        return this.table;
    }

    protected KDTree getTree() {
        return this.tree;
    }

    public void setCondition(EntityViewInfo condition) {
        this.condition = condition;
    }

    public EntityViewInfo getCondition() {
        return this.condition;
    }

    public ReportTableHeadInfo getCurrentTableHeadInfo() {
        return this.currentTableHeadInfo;
    }

    public void setCurrentTableHeadInfo(ReportTableHeadInfo info) {
        this.currentTableHeadInfo = info;
    }

    protected void showResult(ReportResultInfo result, KDTable tableForShowResult, int startRow) {
        if (result == null || tableForShowResult == null) {
            return;
        }
        if (result.getTableHeadInfo() != null && result.getRowCount() >= 0) {
            this.initTableHead(result.getTableHeadInfo(), tableForShowResult);
            tableForShowResult.setRowCount(result.getRowCount());
        }
        this.showData(result.getData(), tableForShowResult, startRow);
    }

    public String getPeriodTitle(ReportConditionBase condition) {
        return this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd());
    }

    public String getPeriodTitle(int periodYearStart, int periodNumberStart, int periodYearEnd, int periodNumberEnd) {
        return InitClientHelp.getPeriodTitle(periodYearStart, periodNumberStart, periodYearEnd, periodNumberEnd);
    }

    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        ReportTableHeadInfo headInfo = this.getCurrentTableHeadInfo();
        if (data == null || tableForShowData == null || headInfo == null) {
            return;
        }
        int[] numberFormatTypes = headInfo.getNumberStyleTypes();
        if (numberFormatTypes == null) {
            numberFormatTypes = new int[headInfo.getColumnCount()];
            for (int i = 0; i < numberFormatTypes.length; ++i) {
                numberFormatTypes[i] = 0;
            }
        }
        int index = startRow;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            for (int i = 0; i < headInfo.getColumnCount(); ++i) {
                ICell cell = row.getCell(headInfo.getColumnNames()[i]);
                if (cell == null || lineObjects[i] == null) continue;
                if (!BigDecimal.class.isInstance(lineObjects[i])) {
                    cell.setValue(lineObjects[i]);
                    continue;
                }
                if (ZERO.compareTo((BigDecimal)lineObjects[i]) == 0) continue;
                if (numberFormatTypes[i] == 2) {
                    cell.getFormattedStyleAttributes().setNumberFormat(this.getNumberFormat(((BigDecimal)lineObjects[i]).scale(), headInfo.getNeedKilobits()[i]));
                }
                cell.setValue(lineObjects[i]);
            }
            row.getStyleAttributes().setBackground(ReportAssistBaseUI.getColor((Integer)lineObjects[lineObjects.length - 2]));
            row.setUserObject(lineObjects[lineObjects.length - 1]);
        }
    }

    protected void initTableHead(ReportTableHeadInfo tableHeadInfo, KDTable tableForInit) {
        IColumn column;
        if (tableHeadInfo == null || tableForInit == null || !this.isNeedInitHead()) {
            return;
        }
        if (this.getCurrentTableHeadInfo() == null || this.isNeedUpdateTableHead()) {
            tableForInit.removeColumns();
            for (int i = 0; i < tableHeadInfo.getColumnCount(); ++i) {
                int numberStyleType;
                column = tableForInit.addColumn();
                column.setWidth(tableHeadInfo.getWidths()[i]);
                column.setKey(tableHeadInfo.getColumnNames()[i]);
                int alignInt = tableHeadInfo.getAlignments()[i];
                Styles.HorizontalAlignment align = alignInt == 1 ? Styles.HorizontalAlignment.CENTER : (alignInt == 2 ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT);
                column.getStyleAttributes().setHorizontalAlign(align);
                if (tableHeadInfo.getWidths()[i] == -1 || tableHeadInfo.getVisibles() != null && !tableHeadInfo.getVisibles()[i]) {
                    column.getStyleAttributes().setHided(true);
                }
                if (tableHeadInfo.getMerges() != null) {
                    column.setMergeable(tableHeadInfo.getMerges()[i]);
                }
                if (tableHeadInfo.getNumberStyleTypes() == null || (numberStyleType = tableHeadInfo.getNumberStyleTypes()[i]) != 1) continue;
                int scale = tableHeadInfo.getNumberScales()[i];
                boolean needKilobit = tableHeadInfo.getNeedKilobits()[i];
                column.getStyleAttributes().setNumberFormat(this.getNumberFormat(scale, needKilobit));
            }
            String resourceName = this.getResourceName();
            IRow row = null;
            for (int i = 0; i < tableHeadInfo.getTitles().length; ++i) {
                row = tableForInit.addHeadRow();
                for (int j = 0; j < tableHeadInfo.getColumnCount(); ++j) {
                    String titleLocal = tableHeadInfo.getTitles()[i][j];
                    if (tableHeadInfo.getTitleNeedResource() == null || tableHeadInfo.getTitleNeedResource()[i][j]) {
                        titleLocal = EASResource.getString((String)resourceName, (String)titleLocal);
                    }
                    row.getCell(j).setValue((Object)titleLocal);
                }
            }
            if (tableHeadInfo.isHeadMerge()) {
                tableForInit.getHeadMergeManager().mergeBlock(0, 0, tableHeadInfo.getTitles().length - 1, tableHeadInfo.getColumnCount() - 1, 3);
            }
            this.setCurrentTableHeadInfo(tableHeadInfo);
        }
        if (tableHeadInfo.getVisibles() != null && this.isNeedUpdateTableColumnVisible()) {
            for (int i = 0; i < tableHeadInfo.getColumnCount(); ++i) {
                column = tableForInit.getColumn(tableHeadInfo.getColumnNames()[i]);
                if (tableHeadInfo.getVisibles() == null || column == null) continue;
                column.getStyleAttributes().setHided(!tableHeadInfo.getVisibles()[i]);
            }
        }
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportBase";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.requesting = true;
            this.setCursorOfWair();
            IGLReport report = null;
            try {
                EntityViewInfo evi = this.getCondition();
                ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
                customCondition.setNewQuery(e.getFirstRow() == 0);
                report = this.getRemoteInstance();
                int rowIndex = e.getFirstRow() - this.getTable().getDataRequestManager().getPageRowCount();
                if (rowIndex > 0) {
                    this.getTable().getRow(rowIndex);
                }
                this.result = report.findData(this.getCondition(), e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
                this.setTempTableName(this.result.getTempTableName());
                this.showResult(this.result, this.getTable(), e.getFirstRow());
            }
            catch (Exception err) {
                this.getTable().setRowCount(0);
                this.setTempTableName(null);
                this.handUIException(err);
            }
            Object var2_2 = null;
        }
        finally {
            this.setCursorOfDefault();
            this.requesting = false;
        }
        if (this.isNeedInitHead()) {
            this.tHelper.init();
        }
    }

    public void initTable(KDTable tableForInit) {
        tableForInit.getDataRequestManager().setPageRowCount(100);
        tableForInit.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        tableForInit.getDataRequestManager().setDataRequestMode(1);
        tableForInit.getStyleAttributes().setLocked(true);
        tableForInit.getSelectManager().setSelectMode(2);
        this.enableExportExcel(tableForInit);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)tableForInit, (int)2);
        KDTableHelper.setTabKeyJumpOrientation((KDTable)tableForInit, (int)2);
    }

    protected boolean isNeedUpdateTableHead() {
        return false;
    }

    protected boolean isNeedUpdateTableColumnVisible() {
        return false;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public void setTempTableName(String string) {
        this.tempTableName = string;
    }

    protected void disposeUIWindow() {
        if (this.tempTableName != null) {
            try {
                RptBaseFactory.getRemoteInstance().dropTable(this.tempTableName);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        super.disposeUIWindow();
    }

    public ReportAssistBaseUI() throws Exception {
        this.treeView.setPreferredSize(new Dimension(160, 475));
        this.setPreferredSize(new Dimension(792, 566));
    }

    private void setDefaultButton(JButton bt) {
        if (bt != null && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(bt);
        }
    }

    public void onShow() throws Exception {
        this.initListener();
        this.setDefaultButton(this.getDefaultButton());
        UserMonitorClientTool.monitor((CoreUIObject)this);
        this.tree.requestFocus();
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        if (this.tree.getSelectionPaths() != null && this.tree.getSelectionPaths().length == 1) {
            this.requestTableData(e.getPath());
        }
    }

    @Override
    public void confirmEnd() {
        try {
            while (this.requesting) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void requestTableData(Object thepath) throws Exception {
        TreePath path = null;
        if (!(thepath instanceof TreePath)) {
            return;
        }
        path = (TreePath)thepath;
        HashMap<RptTreeNodeInfo, String> childAssistItem = new HashMap<RptTreeNodeInfo, String>();
        String asstAccountID = null;
        String assistTypeID = null;
        String assistItemID = null;
        if (path != null) {
            DefaultKingdeeTreeNode node;
            this.selectAccountNode = node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node != null) {
                Object upNodeInfo = node.getUserObject();
                RptTreeNodeInfo upTreeNodeInfo = (RptTreeNodeInfo)upNodeInfo;
                String[] array = upTreeNodeInfo.getId().split("','");
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < array.length; ++i) {
                    set.add(array[i]);
                }
                Enumeration enumer = node.children();
                while (enumer.hasMoreElements()) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)enumer.nextElement();
                    Object nodeInfo = child.getUserObject();
                    if (nodeInfo == null || !RptTreeNodeInfo.class.isInstance(nodeInfo)) continue;
                    RptTreeNodeInfo treeNodeInfo = (RptTreeNodeInfo)nodeInfo;
                    assistItemID = treeNodeInfo.getId();
                    String[] array1 = assistItemID.split("','");
                    for (int i = 0; i < array1.length; ++i) {
                        set.remove(array1[i]);
                    }
                    assistTypeID = this.getAssistTypeId(node);
                    if (assistItemID == null || assistItemID.length() <= 0 || assistTypeID == null || assistTypeID.length() <= 0) continue;
                    childAssistItem.put(treeNodeInfo, assistItemID);
                }
                Object nodeInfo = node.getUserObject();
                if (nodeInfo != null && RptTreeNodeInfo.class.isInstance(nodeInfo)) {
                    RptTreeNodeInfo treeNodeInfo = (RptTreeNodeInfo)nodeInfo;
                    asstAccountID = this.getAsstAccountId(node);
                    assistItemID = treeNodeInfo.getId();
                    assistTypeID = this.getAssistTypeId(node);
                    if (assistItemID != null && assistItemID.length() > 0 && assistTypeID != null && assistTypeID.length() > 0) {
                        String temp;
                        IReportConditionAssist glCondition = (IReportConditionAssist)this.getCondition().get("GLFixCondition");
                        glCondition.setAsstAccountId(asstAccountID);
                        glCondition.setAssistItemId(assistItemID);
                        glCondition.setAssistTypeId(assistTypeID);
                        if (assistItemID.indexOf("','") != -1 && !set.isEmpty() && (temp = set.toString()).length() == 46) {
                            childAssistItem.put(treeNodeInfo, temp.substring(1, 45));
                        }
                        glCondition.setAssistItem(childAssistItem);
                        StringBuffer sb = new StringBuffer();
                        if (this.isAssitemShowNumber()) {
                            sb.append(treeNodeInfo.getNumber());
                            sb.append(" - ");
                        }
                        if (this.isAssitemShowLongName()) {
                            sb.append(this.getLongName(node));
                        } else {
                            sb.append(treeNodeInfo.getName());
                        }
                        this.assistItemName = sb.toString();
                        this.lblAssist.setText(this.titleAssistItem + sb.toString());
                        this.getTable().removeRows();
                    } else {
                        this.getTable().removeRows(false);
                    }
                }
            }
        }
    }

    protected String getAssistTypeId(DefaultKingdeeTreeNode node) {
        if (node != null) {
            Object nodeInfo = node.getUserObject();
            if (nodeInfo != null && RptTreeNodeInfo.class.isInstance(nodeInfo) && !((RptTreeNodeInfo)nodeInfo).isItem()) {
                return ((RptTreeNodeInfo)nodeInfo).getTypeId();
            }
            return this.getAssistTypeId((DefaultKingdeeTreeNode)node.getParent());
        }
        return null;
    }

    protected String getAsstAccountId(DefaultKingdeeTreeNode node) {
        if (node == null || !(node.getUserObject() instanceof RptTreeNodeInfo)) {
            return null;
        }
        RptTreeNodeInfo nodeInfo = (RptTreeNodeInfo)node.getUserObject();
        if (!nodeInfo.isItem() && nodeInfo.getTypeId() == null) {
            return nodeInfo.getId();
        }
        return this.getAsstAccountId((DefaultKingdeeTreeNode)node.getParent());
    }

    protected String getLongName(DefaultKingdeeTreeNode node) throws Exception {
        ArrayList<RptTreeNodeInfo> list = new ArrayList<RptTreeNodeInfo>();
        DefaultKingdeeTreeNode nodeP = node;
        while (nodeP != null) {
            Object nodeInfo = nodeP.getUserObject();
            if (nodeInfo != null && RptTreeNodeInfo.class.isInstance(nodeInfo)) {
                RptTreeNodeInfo treeNodeInfo = (RptTreeNodeInfo)nodeInfo;
                list.add(treeNodeInfo);
                if (!treeNodeInfo.isItem()) {
                    nodeP = null;
                    continue;
                }
                nodeP = (DefaultKingdeeTreeNode)node.getParent();
                continue;
            }
            throw new ReportException(ReportException.NODE_NO_TYPE);
        }
        if (list.size() <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append((RptTreeNodeInfo)list.get(list.size() - 1));
        for (int i = list.size() - 2; i >= 0; --i) {
            sb.append(".");
            sb.append(((RptTreeNodeInfo)list.get(i)).getName());
        }
        return sb.toString();
    }

    protected ReportResultInfo findAssistTreeData() throws Exception {
        ReportResultInfo result = null;
        IGLReportAssistTree report = null;
        report = this.getRemoteInstanceForTree();
        result = report.findAssistTree(this.getCondition(), (CompanyOrgUnitInfo)this.getUIContext().get("company"));
        report = null;
        return result;
    }

    protected IGLReportAssistTree getRemoteInstanceForTree() throws BOSException, EASBizException {
        throw new ReportException(ReportException.REMOTEINSTANCE_EMPTY);
    }

    protected IGLReport getRemoteInstance() throws BOSException, EASBizException {
        throw new ReportException(ReportException.REMOTEINSTANCE_EMPTY);
    }

    protected void refreshAssistTree() {
        try {
            ReportResultInfo result = this.findAssistTreeData();
            if (result != null) {
                Boolean parmShowNumber = (Boolean)result.getExtendData().get("ParmAssitemShowNumber");
                Boolean parmShowLongName = (Boolean)result.getExtendData().get("ParmAssitemShowLongName");
                if (parmShowNumber != null) {
                    this.setAssitemShowNumber(parmShowNumber);
                }
                if (parmShowLongName != null) {
                    this.setAssitemShowLongName(parmShowLongName);
                }
                this.showDataToTree(result.getData(), this.tree);
                AccountViewInfo accountViewInfo = (AccountViewInfo)result.getExtendData().get("Account");
                this.setAccountViewInfo(accountViewInfo);
                if (accountViewInfo != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    sb.append(accountViewInfo.getNumber());
                    sb.append("]");
                    Boolean accountShowLongName = (Boolean)result.getExtendData().get("AccountShowLongName");
                    if (accountShowLongName != null && accountShowLongName.booleanValue()) {
                        sb.append(accountViewInfo.getLongName());
                    } else {
                        sb.append(accountViewInfo.getName());
                    }
                    String accountTitle = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportAssistBaseUI", (String)"PreAccount");
                    this.accountName = sb.toString();
                    this.lblAccount.setText(accountTitle + this.accountName);
                }
            }
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    protected void showDataToTree(ArrayList data, KDTree treeForShowData) {
        treeForShowData.setIgnoreRepaint(true);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeForShowData.getModel().getRoot();
        root.removeAllChildren();
        root = new DefaultKingdeeTreeNode((Object)"KDTree");
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            this.addChildNode(root, (RptTreeNodeInfo)iterator.next());
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeForShowData.setModel((TreeModel)treeModel);
        treeForShowData.setRootVisible(false);
        DefaultKingdeeTreeNode accountNode = null;
        DefaultKingdeeTreeNode selectNode = null;
        try {
            ReportConditionBase glCondition = this.getConditionFromUIContext();
            selectNode = glCondition.getSelectAccountNode();
            if (selectNode == null) {
                accountNode = this.getFirstAccountNodePath(root);
            } else {
                accountNode = this.getRightNode(root, selectNode);
                if (accountNode == null) {
                    accountNode = this.getFirstAccountNodePath(root);
                }
            }
        }
        catch (Exception glCondition) {
            // empty catch block
        }
        if (accountNode != null) {
            Stack<Integer> stack = new Stack<Integer>();
            this.getParent(accountNode, stack);
            if (selectNode != null && stack.size() > 0) {
                stack.set(stack.size() - 1, new Integer(0));
            }
            treeForShowData.setSelectionNode(this.getSelectNode(root, stack));
        }
        treeForShowData.setIgnoreRepaint(false);
    }

    private DefaultKingdeeTreeNode getRightNode(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode selectNode) {
        if (node == null) {
            return null;
        }
        Object nodeInfo = node.getUserObject();
        Object selectNodeInfo = selectNode.getUserObject();
        if (selectNode.getChildCount() == 0 && nodeInfo != null && nodeInfo instanceof RptTreeNodeInfo && ((RptTreeNodeInfo)nodeInfo).getId().equals(((RptTreeNodeInfo)selectNodeInfo).getId())) {
            return node;
        }
        if (selectNode.getChildCount() != 0 && nodeInfo != null && nodeInfo instanceof RptTreeNodeInfo && ((RptTreeNodeInfo)nodeInfo).getName().equals(((RptTreeNodeInfo)selectNodeInfo).getName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode rightNode = this.getRightNode((DefaultKingdeeTreeNode)node.getChildAt(i), selectNode);
            if (rightNode == null) continue;
            return rightNode;
        }
        return null;
    }

    protected DefaultKingdeeTreeNode getSelectNode(DefaultKingdeeTreeNode node, Stack stack) {
        if (!stack.isEmpty() && !node.isLeaf()) {
            return this.getSelectNode((DefaultKingdeeTreeNode)node.getChildAt(((Integer)stack.pop()).intValue()), stack);
        }
        return node;
    }

    protected void getParent(DefaultKingdeeTreeNode node, Stack stack) {
        if (node.getParent() == null) {
            return;
        }
        node.getParent().getIndex((TreeNode)node);
        stack.push(new Integer(node.getParent().getIndex((TreeNode)node)));
        this.getParent((DefaultKingdeeTreeNode)node.getParent(), stack);
    }

    protected void addChildNode(DefaultKingdeeTreeNode parentNode, RptTreeNodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return;
        }
        String nodeTitle = null;
        if (nodeInfo.isItem() && this.isAssitemShowNumber()) {
            StringBuffer sb = new StringBuffer();
            sb.append(nodeInfo.getNumber());
            sb.append(" - ");
            sb.append(nodeInfo.getName());
            nodeTitle = sb.toString();
        } else {
            nodeTitle = nodeInfo.getName();
        }
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)nodeTitle);
        node.setUserObject((Object)nodeInfo);
        parentNode.add((MutableTreeNode)node);
        if (nodeInfo.getSonNodeList() != null) {
            for (int i = 0; i < nodeInfo.getSonNodeList().size(); ++i) {
                this.addChildNode(node, (RptTreeNodeInfo)nodeInfo.getSonNodeList().get(i));
            }
        }
    }

    protected DefaultKingdeeTreeNode getFirstAccountNodePath(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return null;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo != null && nodeInfo instanceof RptTreeNodeInfo && ((RptTreeNodeInfo)nodeInfo).getSonNodeList() == null) {
            return node;
        }
        int i = 0;
        if (i < node.getChildCount()) {
            return this.getFirstAccountNodePath((DefaultKingdeeTreeNode)node.getChildAt(i));
        }
        return null;
    }

    public ReportResultInfo getResult() {
        return this.result;
    }

    public void setResult(ReportResultInfo info) {
        this.result = info;
    }

    protected void initTree(KDTree treeForInit) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"KDTree");
        treeForInit.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        treeForInit.setRootVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public boolean isAssitemShowLongName() {
        return this.assitemShowLongName;
    }

    public void setAssitemShowLongName(boolean b) {
        this.assitemShowLongName = b;
    }

    public boolean isAssitemShowNumber() {
        return this.assitemShowNumber;
    }

    public void setAssitemShowNumber(boolean b) {
        this.assitemShowNumber = b;
    }

    public AccountViewInfo getAccountViewInfo() {
        return this.accountViewInfo;
    }

    public void setAccountViewInfo(AccountViewInfo info) {
        this.accountViewInfo = info;
    }

    protected String getNumberFormat(int scale, boolean needkilobit) {
        StringBuffer sbff = new StringBuffer();
        StringBuffer sbffN = new StringBuffer();
        if (scale == 0) {
            sbff.append("#,##0");
            sbffN.append("-#,##0");
        } else {
            sbff.append("#,##0.");
            sbffN.append("-#,##0.");
        }
        for (int i = 0; i < scale; ++i) {
            sbff.append("0");
            sbffN.append("0");
        }
        return sbff.append(";").append(sbffN).toString();
    }

    protected static Color getColor(Integer lineType) {
        if (lineType == null) {
            return NORMAL_COLOR;
        }
        if (ReportResultInfo.LINE_NORMAL.equals(lineType)) {
            return NORMAL_COLOR;
        }
        if (ReportResultInfo.LINE_DAY_SUM.equals(lineType)) {
            return DAY_SUM_COLOR;
        }
        if (ReportResultInfo.LINE_DAY_TOTAL.equals(lineType)) {
            return DAY_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_PERIOD_TOTAL.equals(lineType)) {
            return PERIOD_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_YEAR_TOTAL.equals(lineType)) {
            return YEAR_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_TOTAL.equals(lineType)) {
            return TOTAL_COLOR;
        }
        return NORMAL_COLOR;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(boolean preview) throws Exception {
        try {
            this.setCursorOfWair();
            MultiPrint mp = new MultiPrint((Component)((Object)this));
            if (!mp.showPrintOption()) {
                return;
            }
            this.preparePrintPage(this.table);
            TreePath[] tps = this.getAsstactTreePath(mp.isPrintAll());
            int begin = 0;
            if (mp.isPrintAll()) {
                begin = 2;
            }
            mp.getMultiPrintModel().setTable(this.table);
            mp.getMultiPrintModel().setRequestData(this);
            this.setNeedInitHead(false);
            int n = tps.length;
            for (int i = begin; i < n; ++i) {
                HashMap<String, String> var = new HashMap<String, String>();
                var.put("CompanyName", this.getUIContext().get("company").toString());
                var.put("User", SysContext.getSysContext().getUserName());
                var.put("Period", this.lblPeriod.getText().substring(3));
                var.put("Currency", this.lblCurrency.getText().substring(3));
                StringBuffer sb = new StringBuffer(EASResource.getString((String)this.getResourceNameForPrint(), (String)"AssistItem_Label"));
                sb.append(tps[i].getLastPathComponent().toString());
                var.put("Asstact", sb.toString());
                var.put("Account", this.lblAccount.getText().toString());
                mp.getMultiPrintModel().addVarParser("PrintJob_" + i, var);
                mp.getMultiPrintModel().addTreePath("PrintJob_" + i, tps[i]);
            }
            if (preview) {
                mp.preview();
            } else {
                mp.print();
            }
        }
        finally {
            this.setNeedInitHead(true);
            this.setCursorOfDefault();
        }
    }

    private TreePath[] getAsstactTreePath(boolean all) {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath[] tps = null;
        if (all) {
            Enumeration em = ((DefaultKingdeeTreeNode)this.tree.getModel().getRoot()).preorderEnumeration();
            while (em.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)em.nextElement();
                list.add(new TreePath(node.getPath()));
            }
        } else {
            tps = this.tree.getSelectionPaths();
            if (tps != null) {
                int n = tps.length;
                for (int i = 0; i < n; ++i) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
                    list.add(tps[i]);
                }
            }
        }
        tps = new TreePath[list.size()];
        list.toArray(tps);
        return tps;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(9);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Period_Label"));
        sb.append("&[Period]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Currency_Label"));
        sb.append("&[Currency]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sb.append("&[CompanyName]");
        header.addRow(sb.append("&|").toString(), sa);
    }

    protected int appendHeadRow(HeadFootModel header) {
        int rowheight = 35;
        int appendHeight = 105;
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append("&[Account]&|&|").append("&[Asstact]&|&| ");
        header.addRow(sb.toString(), sa);
        return appendHeight;
    }

    protected Variant tableRequestPrintDataOther(String varName) {
        Variant v = new Variant();
        if ("Account".equals(varName)) {
            v.setObject((Object)this.lblAccount.getText());
        } else if ("Asstact".equals(varName)) {
            v.setObject((Object)this.lblAssist.getText());
        }
        if (v.getValue() != null) {
            return v;
        }
        return null;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        return this.evp;
    }

    public Variant tableRequestPrintData(String varName) {
        Variant v = this.tableRequestPrintDataOther(varName);
        if (v != null) {
            return v;
        }
        v = new Variant();
        String companyName = "";
        if (varName.equals("CompanyName")) {
            try {
                CompanyOrgUnitInfo company = this.getCurrentCompany();
                companyName = company != null ? company.getName() : "";
            }
            catch (Exception e) {
                companyName = "";
            }
            v.setObject((Object)companyName);
        } else if (varName.equals("User")) {
            String curUser = SysContext.getSysContext().getUserName();
            v.setObject((Object)(curUser == null ? "" : curUser));
        } else if (varName.equals("Period")) {
            ReportConditionBase condition;
            String periodString = "";
            if (this.getCondition() != null && (condition = (ReportConditionBase)this.getCondition().get("GLFixCondition")) != null) {
                periodString = this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd());
            }
            v.setObject((Object)periodString);
        } else if (varName.equals("Currency")) {
            ReportConditionBase condition;
            String CurrencyString = "";
            if (this.getCondition() != null && (condition = (ReportConditionBase)this.getCondition().get("GLFixCondition")) != null) {
                CurrencyString = condition.getCurrencyName();
            }
            v.setObject((Object)CurrencyString);
        } else if (varName.equals("Account")) {
            v.setObject((Object)(this.accountName == null ? " " : this.accountName));
        } else if (varName.equals("Asstact")) {
            v.setObject((Object)(this.assistItemName == null ? " " : this.assistItemName));
        } else {
            v.setObject((Object)"");
        }
        return v;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.currentCompany == null) {
            this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        return this.currentCompany;
    }

    protected String getResourceNameForPrint() {
        return "com.kingdee.eas.fi.gl.ReportPrintTitle";
    }

    public boolean isInitPrint() {
        return this.initPrint;
    }

    public void setInitPrint(boolean b) {
        this.initPrint = b;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshAssistTree();
    }

    protected KDTable getTableForPrintSetting() {
        return this.getTable();
    }

    protected KDTable getTableForOA() {
        return this.getTable();
    }

    protected KDTable getTableForCommon() {
        return this.getTable();
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    protected CompanyOrgUnitInfo getCurrentCompanyForTaoda() {
        return (CompanyOrgUnitInfo)this.getUIContext().get("company");
    }

    public boolean isNeedInitHead() {
        return this.isNeedInitHead;
    }

    public void setNeedInitHead(boolean isNeedInitHead) {
        this.isNeedInitHead = isNeedInitHead;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        CompanyOrgUnitInfo company;
        if (action != null && action.getClass().getName().contains("ActionExport") && (company = (CompanyOrgUnitInfo)this.getUIContext().get("company")) != null) {
            return new ObjectUuidPK(company.getId());
        }
        return super.getOrgPK(action);
    }
}

