/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLReportAssistTreeFactory;
import com.kingdee.eas.fi.gl.GLReportBalanceListAssitFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.IGLReportAssistTree;
import com.kingdee.eas.fi.gl.IReportConditionAssist;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListAssist;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.client.AbstractReportBalanceListAssistUI;
import com.kingdee.eas.fi.gl.client.ReportBaseUI;
import com.kingdee.eas.fi.gl.client.ReportSubsidiaryLedgerAssistUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class ReportBalanceListAssistUI
extends AbstractReportBalanceListAssistUI {
    @Override
    protected IGLReport getRemoteInstance() throws BOSException, EASBizException {
        return GLReportBalanceListAssitFactory.getRemoteInstance();
    }

    @Override
    protected IGLReportAssistTree getRemoteInstanceForTree() throws BOSException, EASBizException {
        return GLReportAssistTreeFactory.getRemoteInstance();
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return true;
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHead() throws ReportException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FAsstAcctNumber", "FAsstAcctName", "FCurrencyName", "FBeginDebitFor", "FBeginCreditFor", "FDebitFor", "FCreditFor", "FYearDebitFor", "FYearCreditFor", "FEndDebitFor", "FEndCreditFor"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"AsstAcctNumber", "AsstAcctName", "CurrencyName", "BalanceBegin", "BalanceBegin", "NumberTotal", "NumberTotal", "YearTotal", "YearTotal", "BalanceEnd", "BalanceEnd"}, {"AsstAcctNumber", "AsstAcctName", "CurrencyName", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit", "Debit", "Credit"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = null;
        widths = new int[]{80, 160, 0, 80, 80, 80, 80, 80, 80, 80, 80};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2};
        head.setAlignments(alignments);
        return head;
    }

    public static void queryByCondition(EntityViewInfo currentCondition, Object owner, CompanyOrgUnitInfo company) throws Exception {
        ReportBalanceListAssistUI.checkOrgsFuncPerm(company);
        if (currentCondition == null) {
            throw new ReportException(ReportException.ENTITY_EMPTY);
        }
        Object conditionObj = currentCondition.get("GLFixCondition");
        if (conditionObj == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        if (!(conditionObj instanceof ReportConditionBalanceListAssist)) {
            throw new ReportException(ReportException.CONDITION_ERROR);
        }
        ReportConditionBase cond = (ReportConditionBase)currentCondition.get("GLFixCondition");
        PeriodInfo usedPeriod = GlUtils.getStartPeriod(null, company.getId().toString());
        if (cond.getPeriodYearStart() * 100 + cond.getPeriodNumberStart() < usedPeriod.getNumber()) {
            cond.setPeriodYearStart(usedPeriod.getPeriodYear());
            cond.setPeriodNumberStart(usedPeriod.getPeriodNumber());
        }
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"company", (Object)company);
        ReportBaseUI.fetchCompany((Map)uiContext);
        uiContext.put((Object)"EntityView", (Object)currentCondition);
        String period = "" + cond.getPeriodYearStart() + cond.getPeriodNumberStart() + cond.getPeriodYearEnd() + cond.getPeriodNumberEnd();
        uiContext.put((Object)"UIClassParam", (Object)(cond.getAccountId() + cond.getCurrencyID() + period + cond.getOptionPosting() + cond.getAccountLevelStart() + cond.getAccountLevelEnd() + cond.getAccountCodeStart() + cond.getAccountCodeEnd() + cond.getExpandInfo().hashCode()));
        String mode = ((CoreUI)owner).getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(ReportBalanceListAssistUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    private static void checkOrgsFuncPerm(CompanyOrgUnitInfo company) throws Exception {
        String funPermItem = "gl_rptAsstactBalanceUI_view";
        IGLGeneralFacade iGLGeneralFacade = GLGeneralFacadeFactory.getRemoteInstance();
        Map mapOrgWithPerm = iGLGeneralFacade.getOrgWithPerm(funPermItem, new CompanyOrgUnitInfo[]{company});
        StringBuffer errOrg = new StringBuffer();
        if (!mapOrgWithPerm.containsKey(company.getId().toString())) {
            if (errOrg.length() > 0) {
                errOrg.append(",");
            }
            errOrg.append(company.getName());
        }
        if (errOrg.length() > 0) {
            ReportBalanceListAssistUI.showFuncPermErr(funPermItem, errOrg.toString());
        }
    }

    private static void showFuncPermErr(String funPermItem, String errOrg) throws EASBizException, BOSException {
        PermItemCollection permColl = PermItemFactory.getRemoteInstance().getPermItemCollection("select description where number = '" + funPermItem + "'");
        String GLX_RES = "com.kingdee.eas.fi.gl.GLXResource";
        String errMsg = EASResource.getString((String)GLX_RES, (String)"no_org_funcperm");
        errMsg = errMsg.replace("{0}", errOrg);
        errMsg = errMsg.replace("{1}", permColl.get(0).getDescription());
        MsgBox.showWarning((String)errMsg);
        SysUtil.abort();
    }

    @Override
    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportBalanceListAssistUI";
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.table.getBody().getRows().size() != 0) {
            super.actionPrintPreview_actionPerformed(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_print_please"));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.table.getBody().getRows().size() != 0) {
            super.actionPrint_actionPerformed(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_print_please"));
        }
    }

    @Override
    public void actionAssistDetail_actionPerformed(ActionEvent e) throws Exception {
        this.findAssitDetail();
    }

    @Override
    public void onLoad() throws Exception {
        Object hgID;
        super.onLoad();
        this.btnAssistDetail.setIcon(EASResource.getIcon((String)"imgTbtn_assistantlistaccount"));
        this.initListener();
        Object evi = this.getUIContext().get("EntityView");
        if (evi != null && evi instanceof EntityViewInfo && (hgID = ((EntityViewInfo)evi).get("asstHGId")) != null) {
            this.selectTreeNode(hgID.toString());
        }
    }

    private void selectTreeNode(String hgid) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        String assItmeID = RptClientUtil.queryAsstItemByAssisthgID(hgid);
        this.doSelect(this.getTree(), node, assItmeID);
    }

    private void doSelect(KDTree tree, DefaultKingdeeTreeNode root, String assItmeID) {
        if (root == null) {
            return;
        }
        RptTreeNodeInfo nodeInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeInfo = (RptTreeNodeInfo)node.getUserObject();
            if (nodeInfo.getId() != null && nodeInfo.getId().equals(assItmeID)) {
                tree.setSelectionNode(node);
                return;
            }
            this.doSelect(tree, node, assItmeID);
        }
    }

    protected void initListener() {
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ReportBalanceListAssistUI.this.findAssitDetail();
                    }
                    catch (Exception exc) {
                        ReportBalanceListAssistUI.this.handUIException(exc);
                    }
                } else if (e.getClickCount() == 1) {
                    EntityViewInfo currentCondition = ReportBalanceListAssistUI.this.getCondition();
                    if (currentCondition == null) {
                        ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(false);
                        return;
                    }
                    ReportConditionBase glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition");
                    if (glCondition == null) {
                        ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(false);
                        return;
                    }
                    ReportConditionSubsidiaryLedgerAssist fixCondition = new ReportConditionSubsidiaryLedgerAssist(glCondition);
                    if (fixCondition.isAllCurrency()) {
                        String str;
                        if (ReportBalanceListAssistUI.this.table.getSelectManager().get() == null) {
                            ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(false);
                            return;
                        }
                        int selectIndex = ReportBalanceListAssistUI.this.table.getSelectManager().get().getTop();
                        IRow row = ReportBalanceListAssistUI.this.table.getRow(selectIndex);
                        String string = str = row.getCell("FCurrencyID") == null ? null : (String)row.getCell("FCurrencyID").getValue();
                        if ("AllCurrency".equals(str)) {
                            ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(false);
                        } else {
                            ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(true);
                        }
                    } else {
                        ReportBalanceListAssistUI.this.actionAssistDetail.setEnabled(true);
                    }
                }
            }
        });
    }

    private void findAssitDetail() throws Exception {
        EntityViewInfo currentCondition = this.getCondition();
        if (currentCondition == null) {
            return;
        }
        ReportConditionBase glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition");
        if (glCondition == null) {
            return;
        }
        EntityViewInfo assistCondition = (EntityViewInfo)currentCondition.clone();
        ReportConditionSubsidiaryLedgerAssist fixCondition = new ReportConditionSubsidiaryLedgerAssist(glCondition);
        if (glCondition instanceof ReportConditionBalanceListAssist) {
            fixCondition.setOptionAmountZero(((ReportConditionBalanceListAssist)glCondition).isOptionAmountZero());
            fixCondition.setAssistItemId(((ReportConditionBalanceListAssist)glCondition).getAssistItemId());
        }
        fixCondition.setAccountId(glCondition.getAccountId());
        fixCondition.setSelectAccountNode(this.selectAccountNode);
        assistCondition.put("GLFixCondition", (Object)fixCondition);
        if (fixCondition.isAllCurrency()) {
            String str;
            if (this.table.getSelectManager().get() == null) {
                return;
            }
            int selectIndex = this.table.getSelectManager().get().getTop();
            IRow row = this.table.getRow(selectIndex);
            String string = str = row.getCell("FCurrencyID") == null ? null : (String)row.getCell("FCurrencyID").getValue();
            if ("AllCurrency".equals(str)) {
                return;
            }
            if (str != null) {
                fixCondition.setCurrencyID(str);
                fixCondition.setCurrencyName(row.getCell("FCurrencyName") == null ? null : (String)row.getCell("FCurrencyName").getValue());
            }
        }
        if (this.getAccountViewInfo() == null) {
            AccountViewInfo avi = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(glCondition.getAccountId()));
            this.setAccountViewInfo(avi);
        }
        if (this.getAccountViewInfo().isIsLeaf() && glCondition instanceof IReportConditionAssist) {
            fixCondition.setAsstAccountId(((IReportConditionAssist)((Object)glCondition)).getAsstAccountId());
        }
        ReportSubsidiaryLedgerAssistUI.queryByCondition(assistCondition, this, (CompanyOrgUnitInfo)this.getUIContext().get("company"));
    }

    @Override
    protected ReportResultInfo findAssistTreeData() throws Exception {
        ReportResultInfo result = null;
        IGLReportAssistTree report = null;
        report = this.getRemoteInstanceForTree();
        EntityViewInfo currentCondition = this.getCondition();
        if (currentCondition == null) {
            return null;
        }
        ReportConditionBase glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition");
        if (glCondition == null) {
            return null;
        }
        EntityViewInfo assistCondition = (EntityViewInfo)currentCondition.clone();
        ReportConditionSubsidiaryLedgerAssist fixCondition = new ReportConditionSubsidiaryLedgerAssist(glCondition);
        String assistItemIdString = (String)currentCondition.get("asstHGId");
        if (assistItemIdString != null) {
            fixCondition.setAssistItemId(assistItemIdString);
        }
        assistCondition.put("GLFixCondition", (Object)fixCondition);
        result = report.findAssistTree(assistCondition, (CompanyOrgUnitInfo)this.getUIContext().get("company"));
        report = null;
        return result;
    }
}

