/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionBalanceListNew;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.RptCommonFactory;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.client.AbstractReportBalanceListConditionUI;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ReportBalanceListConditionUI
extends AbstractReportBalanceListConditionUI {
    private static final long serialVersionUID = 2647852884967013232L;
    private static final Logger logger = CoreUIObject.getLogger(ReportBalanceListConditionUI.class);
    CompanyOrgUnitInfo company = null;
    boolean companyFilterChanged = false;
    boolean isFromSolu = false;
    boolean loading = false;
    String companyIds = null;
    private PeriodEntity pe = null;
    private boolean isAfterPeriodIncluded = false;
    private String preCurInfoId = "";
    private Map initDataUsingForClear = null;
    CompanyTreeSelectUI ctsUI = null;
    JDialog dialog = null;
    private TreeModel treeModelOfCompany = null;
    private TreeModel treeModelOfCompanyClone = null;

    public ReportBalanceListConditionUI() throws Exception {
        this.tfCompany.setRequired(true);
        this.tfCompany.setEnabled(true);
        this.tfCompany.setEditable(false);
        this.cmbCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ReportBalanceListConditionUI.this.cmbCurrency_propertyChange(e);
                }
                catch (Exception e1) {
                    ReportBalanceListConditionUI.this.handUIException(e1);
                }
            }
        });
    }

    protected void cmbCurrency_propertyChange(ItemEvent evt) throws Exception {
        CurrencyInfo currencyInfo;
        Object objectCurrency = evt.getItem();
        if (objectCurrency instanceof CurrencyInfo && GlUtils.isCompanyUnion(this.company) && (currencyInfo = (CurrencyInfo)objectCurrency).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
    }

    @Override
    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) throws Exception {
        if (!GlUtils.isCompanyUnion(this.company)) {
            int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
            int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
            RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.prbAccountBegin, this.prbAccountEnd);
        }
    }

    public ReportConditionBalanceListNew getCustomCondition() {
        AccountViewInfo account;
        int i;
        String accountNumber;
        Object[] ar;
        String strNumber;
        ReportConditionBalanceListNew customCondition = new ReportConditionBalanceListNew();
        HashMap<String, RptConditionManager> hm = new HashMap<String, RptConditionManager>();
        RptConditionManager rc = new RptConditionManager();
        rc.recordAllStatus((Container)((Object)this));
        hm.put("RptCondition", rc);
        customCondition.setExpandInfo(hm);
        int yearBegin = (Integer)this.spnPeriodYearBegin.getValue();
        customCondition.setPeriodYearStart(yearBegin);
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        customCondition.setPeriodYearEnd(yearEnd);
        Integer periodBegin = (Integer)this.spnPeriodNumberBegin.getValue();
        customCondition.setPeriodNumberStart(periodBegin);
        Integer periodEND = (Integer)this.spnPeriodNumberEnd.getValue();
        customCondition.setPeriodNumberEnd(periodEND);
        customCondition.setAccountCodeStart(null);
        Object object = this.prbAccountBegin.getValue();
        if (object != null) {
            if (object instanceof String) {
                strNumber = (String)object;
                if (!strNumber.trim().equals("")) {
                    customCondition.setAccountCodeStart(strNumber.trim());
                }
            } else {
                Object[] objectArray;
                if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object;
                }
                ar = objectArray;
                accountNumber = "";
                for (i = 0; i < ar.length; ++i) {
                    account = (AccountViewInfo)ar[i];
                    if (account == null) continue;
                    accountNumber = accountNumber + account.getNumber() + ",";
                }
                if (accountNumber.equals("")) {
                    accountNumber = null;
                }
                customCondition.setAccountCodeStart(accountNumber);
                customCondition.setAccountViewStart(ar);
            }
        }
        customCondition.setAccountCodeEnd(null);
        object = this.prbAccountEnd.getValue();
        if (object != null) {
            if (object instanceof String) {
                strNumber = (String)object;
                if (!strNumber.trim().equals("")) {
                    customCondition.setAccountCodeEnd(strNumber.trim());
                }
            } else {
                Object[] objectArray;
                if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = object;
                }
                ar = objectArray;
                accountNumber = "";
                for (i = 0; i < ar.length; ++i) {
                    account = (AccountViewInfo)ar[i];
                    if (account == null) continue;
                    accountNumber = accountNumber + account.getNumber() + ",";
                }
                if (accountNumber.equals("")) {
                    accountNumber = null;
                }
                customCondition.setAccountCodeEnd(accountNumber);
                customCondition.setAccountViewEnd(ar);
            }
        }
        Integer accountLevel = (Integer)this.spnAccountLevel.getValue();
        customCondition.setAccountLevelStart(1);
        customCondition.setAccountLevelEnd(accountLevel);
        Integer companyLevel = (Integer)this.spnCompanyLevel.getValue();
        if (companyLevel == null || companyLevel <= 0) {
            companyLevel = new Integer(1);
        }
        customCondition.setExpandCompanyLevel(companyLevel);
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            customCondition.setCurrencyID(currencyInfo.getId().toString());
            customCondition.setCurrencyName(currencyInfo.getName());
        } else if (GLResUtil.getRes("all_currency").equals((String)objectCurrency)) {
            customCondition.setCurrencyID("AllCurrency");
            customCondition.setCurrencyName((String)objectCurrency);
        } else {
            customCondition.setCurrencyID(null);
            customCondition.setCurrencyName((String)objectCurrency);
        }
        boolean includeBWAccount = this.chkIncludeBW.isSelected();
        customCondition.setIncludeBWAccount(includeBWAccount);
        boolean displayAsstDetail = this.chkDisplayAsstDetail.isSelected();
        customCondition.setDisplayAsstDetail(displayAsstDetail);
        boolean includeNotPosting = this.chkOpIncludeNotPosting.isSelected();
        customCondition.setOptionPosting(includeNotPosting);
        boolean optionAmountZero = this.chkOpAmountZero.isSelected();
        customCondition.setOptionAmountZero(optionAmountZero);
        boolean optionAmountAndBalZero = this.chkAmountAndBalZero.isSelected();
        customCondition.setOptionAmountAndBalZero(optionAmountAndBalZero);
        boolean optionYearAmountAndBalZero = this.chkYearAmountAndBalZero.isSelected();
        customCondition.setOptionYearAmountAndBalZero(optionYearAmountAndBalZero);
        boolean optionBalanceZero = this.chkOpBalanceZero.isSelected();
        customCondition.setOptionBalanceZero(optionBalanceZero);
        boolean optionNotUsed = this.chkOpNotUsed.isSelected();
        customCondition.setOptionNotUsed(optionNotUsed);
        boolean optionYearAmountZero = this.chkOpYearAmountZero.isSelected();
        customCondition.setOptionYearAmountZero(optionYearAmountZero);
        boolean optionDCDispatchAsst = this.chkisDCDispatchAsst.isSelected();
        customCondition.setOptionDCDispatchAsst(optionDCDispatchAsst);
        if (this.treeModelOfCompany != null) {
            customCondition.setTreeModelOfCompany(this.treeModelOfCompany.getRoot());
        }
        customCondition.setOptionShowQty(this.chkShowQty.isSelected());
        customCondition.getExpandInfo().put("company", this.company);
        customCondition.getExpandInfo().put("periodEntity", this.pe);
        if (GlUtils.isCompanyUnion(this.company)) {
            customCondition.getExpandInfo().put("isAfterPeriodIncluded", this.isAfterPeriodIncluded);
        } else {
            customCondition.getExpandInfo().put("isAfterPeriodIncluded", yearEnd > this.pe.getCurrentYear() || yearEnd == this.pe.getCurrentYear() && periodEND > this.pe.getCurrentPeriod());
        }
        customCondition.setNotIncludePLVoucher(this.chkNotIncluePLVoucher.isSelected());
        return customCondition;
    }

    public void setInitData(Map initData) throws ReportException {
        AccountPromptBox apb;
        Boolean usingForeignCurrencyInUse;
        Boolean foreignCurrencyInUse;
        this.initDataUsingForClear = initData;
        this.loading = true;
        boolean bForeignCurrencyInUse = false;
        boolean bUsingForeignCurrency = false;
        this.company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        try {
            RptClientUtil.fullCompanyInfo(this.company);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tfCompany.setText(this.company.getName());
        this.tfCompany.setToolTipText(this.company.getName());
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setValue((Object)this.company.getAccountTable());
            this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        }
        if ((foreignCurrencyInUse = (Boolean)initData.get("ParmForeignCurrencyIsUse")) != null) {
            bForeignCurrencyInUse = foreignCurrencyInUse;
        }
        if ((usingForeignCurrencyInUse = (Boolean)initData.get("ParmUsingReportingCurrency")) != null) {
            bUsingForeignCurrency = usingForeignCurrencyInUse;
        }
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        CurrencyInfo curCurrency = (CurrencyInfo)initData.get("DefaultCurrency");
        if (GlUtils.isCompanyUnion(this.company)) {
            PeriodInfo pi = (PeriodInfo)initData.get("CurrentPeriod");
            HashMap<String, Object> allMap = new HashMap<String, Object>();
            if (pi == null) {
                Date a = new Date();
                int year = a.getYear() + 1900;
                int[] periodRange = new int[]{a.getMonth() + 1, a.getMonth() + 1};
                HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
                map.put(new Integer(year), periodRange);
                allMap.put("usedPeriod", map);
                allMap.put("queryPeriod", map);
                allMap.put("currentPeriod", new int[]{year, a.getMonth() + 1});
            } else {
                int year = pi.getPeriodYear();
                int[] periodRange = new int[]{pi.getPeriodNumber(), pi.getPeriodNumber()};
                HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
                map.put(new Integer(year), periodRange);
                allMap.put("usedPeriod", map);
                allMap.put("queryPeriod", map);
                allMap.put("currentPeriod", new int[]{year, pi.getPeriodNumber()});
            }
            PeriodEntity pe = new PeriodEntity(allMap);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)true, (boolean)false);
        } else {
            try {
                this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
                SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                throw new ReportException(ReportException.PERIOD_ERROR, e);
            }
        }
        if (GlUtils.isCompanyUnion(this.company)) {
            this.btnCompany.setEnabled(true);
            this.btnCompany.setVisible(true);
            this.tfCompany.setEnabled(true);
            this.bpAccount.setEnabled(true);
            this.bpPeriod.setEnabled(true);
            this.prbAccountBegin.setEnabled(false);
            this.prbAccountEnd.setEnabled(false);
            this.spnPeriodYearBegin.setEnabled(false);
            this.spnPeriodYearEnd.setEnabled(false);
            this.spnPeriodNumberBegin.setEnabled(false);
            this.spnPeriodNumberEnd.setEnabled(false);
            this.btnCompany.setEnabled(false);
            this.spnAccountLevel.setEnabled(false);
        } else {
            this.btnCompany.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.tfCompany.setEnabled(false);
            this.tfCompany.setEditable(false);
            this.bpAccount.setEnabled(false);
            this.bpPeriod.setEnabled(false);
        }
        Integer maxLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelModelEnd = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevel.setModel((SpinnerModel)levelModelEnd);
        }
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.lblCompanyLevel.setEnabled(false);
            this.spnCompanyLevel.setEnabled(false);
        }
        this.cmbCurrency.removeAllItems();
        CurrencyCollection currencyCollection = (CurrencyCollection)initData.get("AllCurrency");
        if (currencyCollection != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    this.cmbCurrency.addItem((Object)currencyCollection.get(i));
                }
                if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currency;
            }
            if (!bForeignCurrencyInUse) {
                if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem(generalLocalCurrency);
                }
                if (bUsingForeignCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem((Object)generalRptCurrency);
                }
            }
            if (!GlUtils.isCompanyUnion(this.company)) {
                this.cmbCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
            }
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)curCurrency);
        }
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkDisplayAsstDetail.setSelected(false);
        this.chkOpAmountZero.setSelected(false);
        this.chkOpBalanceZero.setSelected(false);
        this.chkOpNotUsed.setSelected(false);
        this.chkOpYearAmountZero.setSelected(false);
        this.chkIncludeBW.setSelected(false);
        this.chkAmountAndBalZero.setSelected(false);
        this.chkYearAmountAndBalZero.setSelected(false);
        this.chkisDCDispatchAsst.setSelected(false);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        if (GlUtils.isCompanyUnion(this.company)) {
            this.chkisDCDispatchAsst.setEnabled(false);
            AccountTableInfo ati = (AccountTableInfo)this.bpAccount.getValue();
            if (ati == null) {
                ati = this.company.getAccountTable();
            }
            apb = new AccountPromptBox((IUIObject)this, ati, filter, false);
        } else {
            this.chkisDCDispatchAsst.setEnabled(true);
            apb = new AccountPromptBox((IUIObject)this, this.company, filter, false, false);
        }
        this.prbAccountBegin.setEditable(true);
        this.prbAccountBegin.setEditFormat("$number$");
        this.prbAccountBegin.setCommitFormat("$helpCode$;$name$;$number$");
        this.prbAccountBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountBegin.setEnabledMultiSelection(true);
        this.prbAccountBegin.setSelector((KDPromptSelector)apb);
        this.prbAccountEnd.setEditFormat("$number$");
        this.prbAccountEnd.setCommitFormat("$helpCode$;$name$;$number$");
        this.prbAccountEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountEnd.setEnabledMultiSelection(true);
        this.prbAccountEnd.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.prbAccountBegin.setEntityViewInfo(myevi);
        this.prbAccountEnd.setEntityViewInfo(myevi);
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection fic2 = filter2.getFilterItems();
        EntityViewInfo myevi2 = new EntityViewInfo();
        myevi2.setFilter(filter2);
        this.bpAccount.setEntityViewInfo(myevi2);
        fic2.add(new FilterItemInfo("destcompany.id", (Object)this.company.getId().toString()));
        this.bpAccount.setEditable(true);
        this.bpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountTableQuery");
        this.bpAccount.setEditFormat("$number$");
        this.bpAccount.setCommitFormat("$number$");
        this.bpAccount.setDisplayFormat("$number$ - $name$");
        this.bpPeriod.setEditable(true);
        this.bpPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodTypeQuery");
        this.bpPeriod.setEditFormat("$number$");
        this.bpPeriod.setCommitFormat("$number$");
        this.bpPeriod.setDisplayFormat("$number$ - $name$");
        DataChangeListener dcl = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ReportBalanceListConditionUI.this.fireFiltersChanged(eventObj.getSource());
                }
                catch (Exception e) {
                    ReportBalanceListConditionUI.this.companyFilterChanged = true;
                    ReportBalanceListConditionUI.this.btnCompany.setEnabled(false);
                    MsgBox.showInfo((Component)((Object)ReportBalanceListConditionUI.this), (String)e.getMessage());
                }
            }
        };
        this.bpAccount.addDataChangeListener(dcl);
        this.bpPeriod.addDataChangeListener(dcl);
        this.loading = false;
        if (GlUtils.isCompanyUnion(this.company)) {
            try {
                RptClientUtil.setDefaultAccountPeriod(this.company, this.bpPeriod, this.bpAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.spnPeriodYearEnd_stateChanged(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void prbAccountBegin_dataChanged(DataChangeEvent e) throws Exception, BOSException {
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            if (accountFrom instanceof Object[]) {
                Object[] accounts = (Object[])accountFrom;
                for (int i = 0; i < accounts.length; ++i) {
                    if (accounts[i] != null) continue;
                    return;
                }
            }
            this.prbAccountEnd.setValue(accountFrom);
        } else {
            this.prbAccountEnd_dataChanged(e);
        }
        this.prbAccountBegin.setAutoFocusNextComponent(false);
        this.prbAccountEnd.requestFocus();
    }

    @Override
    public void prbAccountEnd_dataChanged(DataChangeEvent e) throws Exception, BOSException {
        AccountViewInfo ac;
        String strAccountNumber;
        String[] accountValue;
        int i;
        BOSUuid companyId = this.company.getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        AccountTableInfo account = this.company.getAccountTable();
        if (account == null) {
            return;
        }
        ObjectUuidPK accountTablePK = new ObjectUuidPK(account.getId());
        if (!(this.prbAccountBegin.getValue() instanceof Object[]) || !(this.prbAccountEnd.getValue() instanceof Object[])) {
            return;
        }
        Object[] accountFrom = (Object[])this.prbAccountBegin.getValue();
        Object[] accountTo = (Object[])this.prbAccountEnd.getValue();
        int l = 1;
        int j = 1;
        int t = 1;
        if (accountFrom != null) {
            for (i = 0; i < accountFrom.length && accountFrom[i] != null; ++i) {
                String accountNumberNameFrom = accountFrom[i].toString();
                if (accountNumberNameFrom == null) continue;
                accountValue = accountNumberNameFrom.split(" ");
                strAccountNumber = accountValue[0];
                ac = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK);
                if (ac != null) {
                    l = ac.getLevel();
                }
                if (l <= t) continue;
                t = l;
            }
            l = t;
        }
        if (accountTo != null) {
            t = 1;
            for (i = 0; i < accountTo.length && accountTo[i] != null; ++i) {
                String accountNumberNameTo = accountTo[i].toString();
                if (accountNumberNameTo == null) continue;
                accountValue = accountNumberNameTo.split(" ");
                strAccountNumber = accountValue[0];
                ac = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK);
                if (ac != null) {
                    j = ac.getLevel();
                }
                if (j <= t) continue;
                t = j;
            }
            j = t;
        }
        Integer k = l > j ? new Integer(l) : new Integer(j);
        this.spnAccountLevel.setValue((Object)k);
    }

    private void fireFiltersChanged(Object source) throws Exception {
        if (this.company == null || !GlUtils.isCompanyUnion(this.company)) {
            return;
        }
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        boolean b = account != null && period != null;
        this.btnCompany.setEnabled(b);
        this.prbAccountBegin.setEnabled(account != null);
        this.prbAccountEnd.setEnabled(account != null);
        this.spnAccountLevel.setEnabled(account != null);
        this.spnPeriodYearBegin.setEnabled(period != null);
        this.spnPeriodYearEnd.setEnabled(period != null);
        this.spnPeriodNumberBegin.setEnabled(period != null);
        this.spnPeriodNumberEnd.setEnabled(period != null);
        this.treeModelOfCompany = null;
        this.companyFilterChanged = true;
        this.tfCompany.setText("");
        this.tfCompany.setToolTipText("");
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        if (account != null) {
            this.company.setAccountTable(account);
        }
        if (period != null) {
            this.company.setAccountPeriodType(period);
        }
        if (source == this.bpAccount && account != null) {
            FilterInfo fi = this.prbAccountBegin.getEntityViewInfo().getFilter();
            if (fi.getFilterItems().size() == 1) {
                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            } else {
                fi.getFilterItems().set(1, new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            }
            fi.setMaskString("#0 and #1");
            this.prbAccountBegin.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
            this.prbAccountEnd.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
            try {
                Integer maxLevel = (Integer)RptCommonFactory.getRemoteInstance().invoke("getMaxGroupControlAccountLevel", new String[]{account.getId().toString(), this.company.getId().toString()});
                SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnAccountLevel, (KDSpinner)this.spnAccountLevel);
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        list.add("CurrentCompany");
        return list;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionBalanceListNew((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setCustomCondition(ReportConditionBalanceListNew condition) {
        block24: {
            String currencyId;
            block23: {
                if (condition == null) {
                    return;
                }
                Map hm = condition.getExpandInfo();
                RptConditionManager rc = (RptConditionManager)hm.get("RptCondition");
                if (rc != null) {
                    rc.restoreAllStatus((Container)((Object)this));
                }
                if (this.bpPeriod.getValue() != null) {
                    try {
                        this.bpPeriod.setValue((Object)PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(AccessHelper.getId((Object)this.bpPeriod.getValue()))));
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                if (this.bpAccount.getValue() != null) {
                    try {
                        this.bpAccount.setValue((Object)AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(AccessHelper.getId((Object)this.bpAccount.getValue()))));
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                Object[] accFroms = null;
                try {
                    AccountViewInfo accFrom = null;
                    String accoutCodeStrats = condition.getAccountCodeStart();
                    if (accoutCodeStrats != null) {
                        String[] accoutCodeStratsArray = accoutCodeStrats.split(",");
                        accFroms = new Object[accoutCodeStratsArray.length];
                        for (int i = 0; i < accoutCodeStratsArray.length; ++i) {
                            accFrom = VoucherIOSparser.findAccountViewInfoByNumber(accoutCodeStratsArray[i], false);
                            accFroms[i] = accFrom;
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                this.prbAccountBegin.setValue(accFroms);
                Object[] accTos = null;
                try {
                    AccountViewInfo accTo = null;
                    String accoutCodeTos = condition.getAccountCodeEnd();
                    if (accoutCodeTos != null) {
                        String[] accoutCodeTosArray = accoutCodeTos.split(",");
                        accTos = new Object[accoutCodeTosArray.length];
                        for (int i = 0; i < accoutCodeTosArray.length; ++i) {
                            accTo = VoucherIOSparser.findAccountViewInfoByNumber(accoutCodeTosArray[i], false);
                            accTos[i] = accTo;
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                this.prbAccountEnd.setValue(accTos);
                this.spnAccountLevel.setValue((Object)new Integer(condition.getAccountLevelEnd()));
                currencyId = condition.getCurrencyID();
                if (currencyId != null && currencyId.trim().length() != 0) break block23;
                if (this.cmbCurrency.getItemCount() == 0) break block24;
                this.cmbCurrency.setSelectedIndex(this.cmbCurrency.getItemCount() - 1);
                break block24;
            }
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo;
                Object object = this.cmbCurrency.getItemAt(i);
                if (!(object instanceof CurrencyInfo) || (currencyInfo = (CurrencyInfo)object) == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkDisplayAsstDetail.setSelected(condition.getDisplayAsstDetail());
        this.chkDisplayAsstDetail.setEnabled(true);
        this.chkIncludeBW.setSelected(condition.getIncludeBWAccount());
        this.chkOpAmountZero.setSelected(condition.getOptionAmountZero());
        this.chkOpBalanceZero.setSelected(condition.getOptionBalanceZero());
        this.chkOpNotUsed.setSelected(condition.getOptionNotUsed());
        this.chkOpYearAmountZero.setSelected(condition.getOptionYearAmountZero());
        this.chkAmountAndBalZero.setSelected(condition.getOptionAmountAndBalZero());
        this.chkYearAmountAndBalZero.setSelected(condition.getOptionYearAmountAndBalZero());
        this.chkisDCDispatchAsst.setSelected(condition.getOptionDCDispatchAsst());
        this.chkShowQty.setSelected(condition.getOptionShowQty());
        this.chkNotIncluePLVoucher.setSelected(condition.isNotIncludePLVoucher());
        if (GlUtils.isCompanyUnion(this.company)) {
            if (condition.getTreeModelOfCompany() != null) {
                this.treeModelOfCompany = new DefaultTreeModel((TreeNode)this.transLan(condition.getTreeModelOfCompany()));
                this.companyChanged(this.treeModelOfCompany);
            }
            this.bpAccount.setEnabled(true);
            this.bpPeriod.setEnabled(true);
            this.btnCompany.setEnabled(true);
        } else {
            String textComp = "";
            try {
                textComp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString())).getName();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.tfCompany.setText(textComp);
            this.tfCompany.setToolTipText(textComp);
        }
        this.spnPeriodYearBegin.setValue((Object)new Integer(condition.getPeriodYearStart()));
        this.spnPeriodNumberBegin.setValue((Object)new Integer(condition.getPeriodNumberStart()));
        this.spnPeriodYearEnd.setValue((Object)new Integer(condition.getPeriodYearEnd()));
        this.spnPeriodNumberEnd.setValue((Object)new Integer(condition.getPeriodNumberEnd()));
        this.companyFilterChanged = false;
        this.isFromSolu = true;
        int expandLevel = condition.getExpandCompanyLevel();
        if (expandLevel <= 0) {
            expandLevel = 1;
        }
        this.spnCompanyLevel.setValue((Object)new Integer(expandLevel));
    }

    private Object transLan(Object object) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        Set ids = this.getCompanyIds(node);
        this.doTrans(ids, (DefaultMutableTreeNode)object);
        return object;
    }

    private void doTrans(Set ids, DefaultMutableTreeNode object) {
        Map hm = this.getCompanyNameMap(ids);
        this.setNodeName(object, hm);
    }

    private void setNodeName(DefaultMutableTreeNode root, Map hm) {
        this.setNodeNameLoop(root, hm);
        SimpleCompanyUserObject simplyComp = (SimpleCompanyUserObject)root.getUserObject();
        ((SimpleCompanyUserObject)root.getUserObject()).setName((String)hm.get(simplyComp.getCompanyId()));
    }

    private void setNodeNameLoop(DefaultMutableTreeNode root, Map hm) {
        if (root == null) {
            return;
        }
        SimpleCompanyUserObject simplyComp = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            simplyComp = (SimpleCompanyUserObject)node.getUserObject();
            ((SimpleCompanyUserObject)node.getUserObject()).setName((String)hm.get(simplyComp.getCompanyId()));
            this.setNodeNameLoop(node, hm);
        }
    }

    private Map getCompanyNameMap(Set ids) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evi.setFilter(f);
        CompanyOrgUnitCollection comCol = null;
        try {
            comCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        if (comCol != null && comCol.size() > 0) {
            for (int i = 0; i < comCol.size(); ++i) {
                CompanyOrgUnitInfo companyOrgUnitInfo = comCol.get(i);
                hm.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo.getName());
            }
        }
        return hm;
    }

    private Set getCompanyIds(DefaultMutableTreeNode node) {
        HashSet<String> ids = new HashSet<String>();
        this.getCompanyIdsLoop(node, ids);
        ids.add(((SimpleCompanyUserObject)node.getUserObject()).getCompanyId());
        return ids;
    }

    private void getCompanyIdsLoop(DefaultMutableTreeNode root, Set ids) {
        if (root == null) {
            return;
        }
        SimpleCompanyUserObject simplyComp = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            simplyComp = (SimpleCompanyUserObject)node.getUserObject();
            ids.add(simplyComp.getCompanyId());
            this.getCompanyIdsLoop(node, ids);
        }
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYearBegin.getEditor()).getTextField();
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        PeriodTypeInfo period;
        AccountTableInfo account;
        if (this.ctsUI == null) {
            this.dialog = new JDialog(InitClientHelp.getFrameAncestor((Component)((Object)this)), true);
            this.ctsUI = new CompanyTreeSelectUI(this.company);
            this.ctsUI.setDialog(this.dialog);
            this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
            this.dialog.setSize(640, 480);
            InitClientHelp.centerWindow(this.dialog);
            this.dialog.setResizable(false);
            this.dialog.setTitle(this.ctsUI.getUITitle());
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("companyChanged")) {
                        ReportBalanceListConditionUI.this.companyChanged(evt.getNewValue());
                    }
                }
            });
        }
        if (this.companyFilterChanged || this.treeModelOfCompany == null || this.isFromSolu) {
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            this.companyFilterChanged = false;
            Object objectCurrency = this.cmbCurrency.getSelectedItem();
            if (objectCurrency instanceof CurrencyInfo) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
                if (currencyInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                    this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
                } else {
                    this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
                }
            } else {
                this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
            }
            if (this.isFromSolu && this.treeModelOfCompany != null) {
                this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
                this.isFromSolu = false;
            }
        } else {
            this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
        }
        this.dialog.show();
    }

    protected void companyChanged(Object object) {
        Object objectnew = null;
        try {
            objectnew = ObjectUtils.createCopy((Object)object);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
        this.treeModelOfCompany = (TreeModel)object;
        this.treeModelOfCompanyClone = (TreeModel)objectnew;
        try {
            String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
            this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
            this.company.setDescription(this.companyIds);
            this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)true, (boolean)false);
            this.tfCompany.setText(info);
            this.tfCompany.setToolTipText(info);
            int maxLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany);
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, ++maxLevel, 1);
            this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
    }

    @Override
    protected void chkisDCDispatchAsst_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkisDCDispatchAsst.isSelected()) {
            this.chkDisplayAsstDetail.setEnabled(false);
            this.chkDisplayAsstDetail.setSelected(true);
        } else {
            this.chkDisplayAsstDetail.setEnabled(true);
        }
    }

    public boolean verify() {
        block15: {
            int numberBegin;
            int yearBegin;
            if (GlUtils.isCompanyUnion(this.company)) {
                if (this.bpAccount.getValue() == null) {
                    this.bpAccount.requestFocus();
                    MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
                    return false;
                }
                if (this.bpPeriod.getValue() == null) {
                    this.bpPeriod.requestFocus();
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
                    return false;
                }
                if (this.treeModelOfCompany == null || this.companyFilterChanged) {
                    this.btnCompany.requestFocus();
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
                    return false;
                }
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                try {
                    if (!ReportBalanceListConditionUI.hasPhysicalCompany(this.treeModelOfCompany)) {
                        MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                        return false;
                    }
                    int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
                    int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
                    this.isAfterPeriodIncluded = RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
                    if (this.treeModelOfCompany.getChildCount(this.treeModelOfCompany.getRoot()) <= 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("company_cant_null"));
                        return false;
                    }
                    break block15;
                }
                catch (BOSException e) {
                    MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                    return false;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    return false;
                }
                catch (Exception e) {
                    try {
                        this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                    }
                    catch (CloneNotSupportedException cnse) {
                        throw new InternalError();
                    }
                    return false;
                }
            }
            int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
            if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnPeriodYearBegin.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodNumberBegin.getValue()).intValue())) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasPhysicalCompany(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        if (node.getChildCount() <= 0) {
            return false;
        }
        StringBuffer result = new StringBuffer("(");
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append("'").append(userObject.getCompanyId()).append("',");
        }
        result.replace(result.length() - 1, result.length(), ")");
        Boolean bb = (Boolean)RptCommonFactory.getRemoteInstance().invoke("hasPhysicalCompany", result.toString());
        return bb;
    }

    @Override
    protected void cmbCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cmbCurrency_actionPerformed(e);
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo && GlUtils.isCompanyUnion(this.company)) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
            if (currencyInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") || this.preCurInfoId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                this.treeModelOfCompany = null;
                this.tfCompany.setText("");
                this.tfCompany.setToolTipText("");
                SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
                this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
            }
            this.preCurInfoId = currencyInfo.getId().toString();
        }
    }

    public void clear() {
        super.clear();
        try {
            this.setInitData(this.initDataUsingForClear);
        }
        catch (ReportException e) {
            logger.error((Object)e);
            this.handUIException((Throwable)((Object)e));
        }
        this.chkOpNotUsed.setSelected(false);
        this.chkIncludeBW.setSelected(false);
        this.chkOpAmountZero.setSelected(false);
        this.chkOpBalanceZero.setSelected(false);
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkOpYearAmountZero.setSelected(false);
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        this.spnAccountLevel.setValue((Object)new Integer(1));
        this.chkShowQty.setSelected(false);
        this.chkisDCDispatchAsst.setSelected(false);
        this.chkYearAmountAndBalZero.setSelected(false);
        this.chkAmountAndBalZero.setSelected(false);
        this.chkDisplayAsstDetail.setSelected(false);
        this.chkShowQty.setSelected(false);
        this.chkNotIncluePLVoucher.setSelected(false);
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
    }
}

