/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportBalanceListTaoda
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(ReportBalanceListTaoda.class);
    String[] colVal = new String[]{"SysDateTime", "CurrentUser", "AccountLevel", "Company", "Currency", "Period"};
    String[] col = null;
    private String strResource = "com.kingdee.eas.fi.gl.client.TaoDaResource";
    ReportResultInfo result = null;
    Map mapCondition = null;

    public ReportBalanceListTaoda(ReportResultInfo result, Map mapCondition) {
        this.result = result;
        this.mapCondition = mapCondition;
        try {
            this.setCol(this.getColumnName());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        SimpleDateFormat format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
        HashMap hmParamValue = new HashMap();
        try {
            hmParamValue = this.getInitParam(SysContext.getSysContext().getCurrentFIUnit());
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        boolean isImp = hmParamValue.get("GL_059") == null ? true : Boolean.valueOf(hmParamValue.get("GL_059").toString());
        int colCount = this.col.length;
        DynamicRowSet drs = null;
        try {
            int i;
            drs = new DynamicRowSet(colCount);
            for (i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = this.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int n = this.result.getData().size();
            for (i = 0; i < n; ++i) {
                drs.moveToInsertRow();
                ReportBalanceListTaoda.clearRow((IRowSet)drs);
                drs.updateString("SysDateTime", GlUtils.formatDate(format, new Date()));
                if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                    drs.updateString("CurrentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
                } else {
                    drs.updateString("CurrentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
                }
                drs.updateString("AccountLevel", this.mapCondition.get("mapAccountLevel").toString());
                drs.updateString("Company", this.mapCondition.get("mapCompany").toString());
                drs.updateString("Currency", this.mapCondition.get("mapCurrency").toString());
                drs.updateString("Period", this.mapCondition.get("mapPeriod").toString());
                Object[] objValue = (Object[])this.result.getData().get(i);
                int m = objValue.length - 2;
                for (int j = 0; j < m; ++j) {
                    if (objValue[j] != null) {
                        if (objValue[j].getClass() != BigDecimal.class) {
                            String[] a;
                            if (this.getColumnName()[j].startsWith("FAsstAccountName") && !isImp && (a = objValue[j].toString().trim().split("\\:")).length > 1) {
                                StringBuffer sbE = new StringBuffer();
                                int r = a.length - 1;
                                for (int k = 0; k <= r; ++k) {
                                    if (k == 0) continue;
                                    sbE.append(a[k]).append(":");
                                }
                                sbE.deleteCharAt(sbE.length() - 1);
                                objValue[j] = sbE.toString();
                            }
                            drs.updateString(this.getColumnName()[j], objValue[j].toString());
                            continue;
                        }
                        if (((BigDecimal)objValue[j]).compareTo(new BigDecimal("0")) == 0) {
                            drs.updateString(this.getColumnName()[j], "");
                            continue;
                        }
                        drs.updateString(this.getColumnName()[j], GlUtils.withComma((BigDecimal)objValue[j], this.getScale()[j]));
                        continue;
                    }
                    drs.updateString(this.getColumnName()[j], "");
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private String[] getColumnName() throws Exception {
        String[] strColumnName = this.result.getTableHeadInfo().getColumnNames();
        return strColumnName;
    }

    private int[] getScale() throws Exception {
        int[] iScale = this.result.getTableHeadInfo().getNumberScales();
        return iScale;
    }

    private void setCol(String[] strColName) throws Exception {
        int iCol = this.colVal.length;
        int iColumnCount = strColName.length;
        this.col = new String[iColumnCount + iCol];
        try {
            for (int i = 0; i < iColumnCount; ++i) {
                this.col[i] = strColName[i];
            }
            for (int j = 0; j < iCol; ++j) {
                this.col[j + iColumnCount] = this.colVal[j];
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)String.valueOf(company.getId())));
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        hmNumAndOrgId.put("GL_059", comPK);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmNumAndOrgId);
        return hmAllParam;
    }
}

