/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportLineKey;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gl.client.AbstractReportBaseUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.ReportJournalUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public abstract class ReportBaseUI
extends AbstractReportBaseUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(ReportBaseUI.class);
    protected int printTopMargin = 0;
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    public static final Color DAY_SUM_COLOR = new Color(16119270);
    public static final Color DAY_TOTAL_COLOR = new Color(15789529);
    public static final Color PERIOD_TOTAL_COLOR = new Color(15262923);
    public static final Color YEAR_TOTAL_COLOR = new Color(15327928);
    public static final Color TOTAL_COLOR = new Color(0xF6F6BF);
    public static final String ENTITY_VIEW = "EntityView";
    public static final String QUERY_BY_OTHER_FLAG = "QueryByOther";
    public static final String TITLE_PERIOD_NAME = "TitlePeriodName";
    public static final String TITLE_CURRENCY_NAME = "TitleCurrencyName";
    Map initData = null;
    EntityViewInfo condition = null;
    ReportResultInfo result = null;
    ReportTableHeadInfo currentTableHeadInfo = null;
    private String tempTableName = null;
    private String titleCurrencyName = null;
    private String titlePeriodName = null;
    private boolean queryByOther = false;
    private CellTreeRenderer virtureCompanyRender = null;
    private boolean isNeedInitHead = true;
    private boolean isShowForPreCol = false;
    private SimpleCompanyUserObject oldCompany = null;
    private boolean isFirstDefaultQuery = true;
    ExtVarProvider evp = new ExtVarProvider(){

        public Variant requestVarData(String varName) {
            return ReportBaseUI.this.tableRequestPrintData(varName);
        }
    };

    public ReportBaseUI() throws Exception {
        GLResUtil.setLocale(SysContext.getSysContext().getLocale());
    }

    public static IUIWindow getUI(CoreUIObject parentUI, String className, Map newContext) throws Exception {
        ReportBaseUI.fetchCompany(newContext);
        String mode = null;
        mode = parentUI.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        return UIFactory.createUIFactory((String)mode).create(className, newContext, null, OprtState.VIEW);
    }

    protected static void fetchCompany(Map uiContext) throws BOSException, EASBizException {
        String companyId = (String)uiContext.get("companyId");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)uiContext.get("company");
        BOSUuid preAccountTableId = null;
        if (company != null && company.getAccountTable() != null) {
            preAccountTableId = company.getAccountTable().getId();
        }
        if (companyId == null) {
            companyId = company == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : company.getId().toString();
        }
        company = ReportBaseUI.getCompanyById(companyId);
        if (preAccountTableId != null) {
            company.getAccountTable().setId(preAccountTableId);
        }
        String accountTableId = (String)uiContext.get("accountTableId");
        String accountPeriodTypeId = (String)uiContext.get("accountPeriodTypeId");
        if (accountTableId != null) {
            company.getAccountTable().setId(BOSUuid.read((String)accountTableId));
        }
        if (accountPeriodTypeId != null) {
            company.getAccountPeriodType().setId(BOSUuid.read((String)accountPeriodTypeId));
        }
        uiContext.put("companyId", companyId);
        uiContext.put("company", company);
    }

    private static CompanyOrgUnitInfo getCompanyById(String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        return companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
    }

    protected String getMessageText() {
        return GLResUtil.getRes("join_query") + this.getCurrentCompany().getName();
    }

    protected boolean isSupportVirtual() {
        return false;
    }

    public void onLoad() throws Exception {
        ReportBaseUI.fetchCompany(this.getUIContext());
        RptClientUtil.checkFIUnit(this.getCurrentCompany(), this.isSupportVirtual());
        super.onLoad();
        this.getTable().getViewManager().setFreezeView(0, 2);
        this.initTable(this.getTable());
        this.getTable().setRowCount(0);
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        Map initData = this.findInitData();
        this.setInitData(initData);
        Integer maxAccountLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxAccountLevel != null && maxAccountLevel <= 0) {
            if (!company.isIsBizUnit()) {
                initData.put("MaxAccountLevel", new Integer(1));
            } else {
                throw new ReportException(ReportException.GET_ACCOUNT_ERROR);
            }
        }
        ReportTableHeadInfo head = (ReportTableHeadInfo)this.getInitData().get("DefaultTableHead");
        this.initTableHead(head, this.getTable());
        if (!company.isIsBizUnit()) {
            Boolean isGroupPattern = (Boolean)this.getInitData().get("ParmGroupPattern");
            if (isGroupPattern == null || !isGroupPattern.booleanValue()) {
                String info = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBalanceListUI", (String)"NotGroupPattern");
                MsgBox.showInfo((Component)((Component)this.getUIContext().get("Owner")), (String)info);
                return;
            }
            this.virtureCompanyRender = new CellTreeRenderer();
            if (this.getTable().getColumn("FCompany") != null) {
                this.getTable().getColumn("FCompany").setRenderer((IBasicRender)this.virtureCompanyRender);
                this.getTable().getDataRequestManager().setDataRequestMode(0);
            }
        }
        if (!this.isQueryByOther()) {
            try {
                this.openConditionDialog();
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
            if (this.getCondition() == null) {
                SysUtil.abort();
            }
        }
        if (this.getCurrentCompany() != null && !SysContext.getSysContext().getCurrentFIUnit().getId().toString().equals(this.getCurrentCompany().getId().toString())) {
            this.showMessage();
        }
        super.enableExportExcel(this.getTable());
        super.checkTableCommonMenu(this.getTable());
        this.displayNoLinkForRpt();
    }

    private void displayNoLinkForRpt() {
        if (this.getMenuManager(this.tblMain) == null) {
            return;
        }
        KDPopupMenu pop = this.getMenuManager(this.tblMain).getMenu();
        if (pop == null) {
            return;
        }
        int count = pop.getComponentCount();
        block0: for (int i = 0; i < count; ++i) {
            Component menu = pop.getComponent(i);
            if (!(menu instanceof KDMenu) || menu == null || menu.getName() == null) continue;
            KDMenu m = (KDMenu)menu;
            Component[] menuComponents = m.getMenuComponents();
            for (int j = 0; menuComponents != null && j < menuComponents.length; ++j) {
                if (!menuComponents[j].getName().equalsIgnoreCase("menuItemToLinkForRpt")) continue;
                menuComponents[j].setVisible(false);
                if (j - 1 <= -1 || !(menuComponents[j - 1] instanceof JSeparator)) continue block0;
                menuComponents[j - 1].setVisible(false);
                continue block0;
            }
        }
    }

    protected KDTable getTableForOA() {
        return this.getTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnFilter);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected Map findInitData() throws Exception {
        IGLReport report = this.getRemoteInstance();
        return report.findInitData(this.getInitList(), (CompanyOrgUnitInfo)this.getUIContext().get("company"));
    }

    protected void openConditionDialog() throws Exception {
        EntityViewInfo mainQuery = null;
        String uiParams = (String)this.getUIContext().get("UIClassParam");
        if (uiParams != null && !"FSSC".equals(uiParams)) {
            mainQuery = this.buildLinkedQuery(uiParams);
            this.queryByOther = true;
        }
        if (this.isQueryByOther()) {
            this.isFirstDefaultQuery = false;
        }
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
            if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                if (solution == null || !this.getCurrentCompany().isIsBizUnit() && solution.getName().equals(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"29_ReportBaseUI")) || solution.getName() == null) {
                    mainQuery = this.getDefaultEntityViewInfo();
                } else if (solution.getName().equals(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"29_ReportBaseUI"))) {
                    if (mainQuery == null) {
                        mainQuery = new EntityViewInfo();
                    }
                    if (mainQuery.getFilter() == null) {
                        mainQuery.setFilter(new FilterInfo());
                    }
                } else {
                    QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                    QueryPanelInfo queryPanel = queryPanels.get(0);
                    int size = queryPanels.size();
                    for (int i = 0; i < size; ++i) {
                        if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                        queryPanel = queryPanels.get(i);
                        break;
                    }
                    if (queryPanel.getCustomerParams() != null) {
                        this.getConditionPanel().setCustomerParams(CustomerParams.getCustomerParams2((String)queryPanel.getCustomerParams()));
                    } else {
                        mainQuery = null;
                    }
                }
            }
        }
        if (mainQuery == null && this.getConditionDialog().show()) {
            mainQuery = this.getConditionDialog().getEntityViewInfoResult();
        }
        if (mainQuery != null) {
            if (this.getCurrentCompany().isIsBizUnit()) {
                GlUtils.updateBalance();
            } else {
                GlUtils.updateBalance((String[])null);
            }
            this.query(mainQuery);
        }
    }

    protected EntityViewInfo getDefaultEntityViewInfo() throws Exception {
        return null;
    }

    protected EntityViewInfo buildLinkedQuery(String uiParams) throws EASBizException, BOSException {
        return null;
    }

    protected IMetaDataPK getQueryMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.fi.gl.app", "VoucherReportQuery");
    }

    protected abstract void query(EntityViewInfo var1) throws Exception;

    public abstract CustomerQueryPanel getConditionPanel() throws Exception;

    public abstract CommonQueryDialog getConditionDialog() throws Exception;

    protected Map getInitData() {
        return this.initData;
    }

    protected void setInitData(Map initData) {
        this.initData = initData;
    }

    public void setCondition(EntityViewInfo condition) {
        this.condition = condition;
    }

    public EntityViewInfo getCondition() {
        ReportConditionBase cond;
        CompanyOrgUnitInfo currCompany = this.getCurrentCompany();
        if (this.condition != null && currCompany.isIsBizUnit() && (cond = (ReportConditionBase)this.condition.get("GLFixCondition")) != null && cond.getExpandInfo() != null && cond.getExpandInfo().get("periodEntity") == null) {
            try {
                PeriodEntity entity = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)currCompany);
                cond.getExpandInfo().put("periodEntity", entity);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.condition;
    }

    public ReportConditionBase getFixCondition() {
        return (ReportConditionBase)this.getCondition().get("GLFixCondition");
    }

    public ReportTableHeadInfo getCurrentTableHeadInfo() {
        return this.currentTableHeadInfo;
    }

    public void setCurrentTableHeadInfo(ReportTableHeadInfo info) {
        this.currentTableHeadInfo = info;
    }

    protected void showResult(ReportResultInfo result, KDTable tableForShowResult, int startRow) {
        if (result == null || tableForShowResult == null) {
            return;
        }
        tableForShowResult.setRefresh(false);
        if (startRow == 0 && result.getTableHeadInfo() != null && (this.getCurrentCompany() == null || !this.getCurrentCompany().isIsBizUnit() || this.getCurrentCompany().isIsBizUnit() && result.getRowCount() >= 0)) {
            this.initTableHead(result.getTableHeadInfo(), tableForShowResult);
            tableForShowResult.setRowCount(result.getRowCount());
        }
        this.showData(result.getData(), tableForShowResult, startRow);
        tableForShowResult.setRefresh(true);
        tableForShowResult.reLayoutAndPaint();
    }

    public String getResx(String resName, String itemName) {
        return EASResource.getString((String)resName, (String)itemName);
    }

    public String getPeriodTitle(ReportConditionBase condition) {
        return this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd());
    }

    public String getPeriodTitle(int periodYearStart, int periodNumberStart, int periodYearEnd, int periodNumberEnd) {
        return InitClientHelp.getPeriodTitle(periodYearStart, periodNumberStart, periodYearEnd, periodNumberEnd);
    }

    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        ReportTableHeadInfo headInfo = this.getCurrentTableHeadInfo();
        if (data == null || tableForShowData == null || headInfo == null) {
            return;
        }
        int[] numberFormatTypes = headInfo.getNumberStyleTypes();
        if (numberFormatTypes == null) {
            numberFormatTypes = new int[headInfo.getColumnCount()];
            for (int i = 0; i < numberFormatTypes.length; ++i) {
                numberFormatTypes[i] = 0;
            }
        }
        int index = startRow;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            int cols = Math.min(headInfo.getColumnCount(), lineObjects.length);
            Color color = ReportBaseUI.getColor((Integer)lineObjects[lineObjects.length - 2]);
            if (!color.equals(NORMAL_COLOR)) {
                row.getStyleAttributes().setBackground(color);
            }
            for (int i = 0; i < cols; ++i) {
                ICell cell = row.getCell(headInfo.getColumnNames()[i]);
                if (cell == null || lineObjects[i] == null) continue;
                if (!BigDecimal.class.isInstance(lineObjects[i])) {
                    cell.setValue(lineObjects[i]);
                    continue;
                }
                if (ZERO.compareTo((BigDecimal)lineObjects[i]) == 0) continue;
                if (numberFormatTypes[i] == 2 || (headInfo.getColumnNames()[i].endsWith("For") || headInfo.getColumnNames()[i].endsWith("Rate")) && this.isShowForPreCol()) {
                    cell.getStyleAttributes().setNumberFormat(this.getNumberFormat(((BigDecimal)lineObjects[i]).scale(), headInfo.getNeedKilobits()[i]));
                }
                cell.setValue(lineObjects[i]);
            }
            row.setUserObject(lineObjects[lineObjects.length - 1]);
        }
    }

    protected boolean isShowForPreCol() {
        return this.isShowForPreCol;
    }

    protected void setShowForPreCol(boolean isShowForPreCol) {
        this.isShowForPreCol = isShowForPreCol;
    }

    protected static Color getColor(Integer lineType) {
        if (lineType == null) {
            return NORMAL_COLOR;
        }
        if (ReportResultInfo.LINE_NORMAL.equals(lineType)) {
            return NORMAL_COLOR;
        }
        if (ReportResultInfo.LINE_DAY_SUM.equals(lineType)) {
            return DAY_SUM_COLOR;
        }
        if (ReportResultInfo.LINE_DAY_TOTAL.equals(lineType)) {
            return DAY_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_PERIOD_TOTAL.equals(lineType)) {
            return PERIOD_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_YEAR_TOTAL.equals(lineType)) {
            return YEAR_TOTAL_COLOR;
        }
        if (ReportResultInfo.LINE_TOTAL.equals(lineType)) {
            return TOTAL_COLOR;
        }
        return NORMAL_COLOR;
    }

    protected String getNumberFormat(int scale, boolean needkilobit) {
        StringBuffer sb = new StringBuffer("");
        StringBuffer fsb = new StringBuffer("-");
        if (needkilobit) {
            sb.append("#,##");
            fsb.append("#,##");
        }
        sb.append("0");
        fsb.append("0");
        if (scale > 0) {
            sb.append(".");
            fsb.append(".");
            for (int i = 0; i < scale; ++i) {
                sb.append("0");
                fsb.append("0");
            }
            sb.append("_ ");
            fsb.append("_ ");
        }
        return sb.toString();
    }

    protected void initTableHead(ReportTableHeadInfo tableHeadInfo, KDTable tableForInit) {
        if (tableHeadInfo == null || tableForInit == null || !this.isNeedInitHead()) {
            return;
        }
        if (this.getCurrentTableHeadInfo() == null || this.isNeedUpdateTableHead()) {
            tableForInit.removeColumns();
            for (int i = 0; i < tableHeadInfo.getColumnCount(); ++i) {
                int numberStyleType;
                IColumn column = tableForInit.addColumn();
                column.setWidth(tableHeadInfo.getWidths()[i]);
                column.setKey(tableHeadInfo.getColumnNames()[i]);
                int alignInt = tableHeadInfo.getAlignments()[i];
                Styles.HorizontalAlignment align = alignInt == 1 ? Styles.HorizontalAlignment.CENTER : (alignInt == 2 ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT);
                column.getStyleAttributes().setHorizontalAlign(align);
                if (tableHeadInfo.getVisibles() != null && !tableHeadInfo.getVisibles()[i] || column.getWidth() == 0 || column.getWidth() == -1) {
                    column.getStyleAttributes().setHided(true);
                }
                if (tableHeadInfo.getWidths()[i] == 0 || tableHeadInfo.getWidths()[i] == -1) {
                    column.getStyleAttributes().setHided(true);
                }
                if (tableHeadInfo.getMerges() != null) {
                    column.setMergeable(tableHeadInfo.getMerges()[i]);
                }
                if (tableHeadInfo.getNumberStyleTypes() == null || (numberStyleType = tableHeadInfo.getNumberStyleTypes()[i]) != 1) continue;
                int scale = tableHeadInfo.getNumberScales()[i];
                boolean needKilobit = tableHeadInfo.getNeedKilobits()[i];
                column.getStyleAttributes().setNumberFormat(this.getNumberFormat(scale, needKilobit));
            }
            String resourceName = this.getResourceName();
            IRow row = null;
            for (int i = 0; i < tableHeadInfo.getTitles().length; ++i) {
                row = tableForInit.addHeadRow();
                for (int j = 0; j < tableHeadInfo.getColumnCount(); ++j) {
                    String titleLocal = tableHeadInfo.getTitles()[i][j];
                    if (tableHeadInfo.getTitleNeedResource() == null || tableHeadInfo.getTitleNeedResource()[i][j]) {
                        titleLocal = EASResource.getString((String)resourceName, (String)titleLocal);
                    }
                    row.getCell(j).setValue((Object)titleLocal);
                }
            }
            if (tableHeadInfo.isHeadMerge()) {
                tableForInit.getHeadMergeManager().mergeBlock(0, 0, tableHeadInfo.getTitles().length - 1, tableHeadInfo.getColumnCount() - 1, 3);
            }
            this.setCurrentTableHeadInfo(tableHeadInfo);
        } else if (this.isNeedUpdateTableColumnVisible()) {
            for (int i = 0; i < tableHeadInfo.getColumnCount(); ++i) {
                IColumn column = tableForInit.getColumn(tableHeadInfo.getColumnNames()[i]);
                if (tableHeadInfo.getVisibles() == null || column == null) continue;
                column.getStyleAttributes().setHided(!tableHeadInfo.getVisibles()[i]);
            }
        }
        if (this.virtureCompanyRender != null && this.getTable().getColumn("FCompany") != null) {
            this.getTable().getColumn("FCompany").setRenderer((IBasicRender)this.virtureCompanyRender);
        } else {
            IColumn col = this.getTable().getColumn("FCompany");
            if (col != null) {
                col.getStyleAttributes().setHided(true);
            }
        }
        this.tHelper.init();
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportBase";
    }

    public void queryVirtualData(boolean newQuery) throws Exception {
        IGLReport report = null;
        ReportConditionBase customCondition = this.getFixCondition();
        customCondition.setNewQuery(newQuery);
        if (newQuery) {
            SimpleCompanyUserObject newUserObject = new SimpleCompanyUserObject();
            String companyId = this.getCurrentCompany().getId().toString();
            String longNumber = this.getCurrentCompany().getLongNumber();
            String number = this.getCurrentCompany().getNumber();
            String name = this.getCurrentCompany().getName();
            newUserObject.setCompanyId(companyId);
            newUserObject.setLongNumber(longNumber);
            newUserObject.setName(name);
            newUserObject.setNumber(number);
            Map conditionMap = customCondition.getExpandInfo();
            conditionMap.put("AccountNumber", null);
            conditionMap.put("SortNumber", null);
            conditionMap.put("AccountID", null);
            customCondition.setExpandInfo(conditionMap);
            customCondition.setVirtureCompany(newUserObject);
        }
        try {
            report = this.getRemoteInstance();
            this.setCompanyCondition(this.getCondition());
            this.result = report.findData(this.getCondition(), -1, -1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
            this.setTempTableName(this.result.getTempTableName());
            this.showResult(this.result, this.getTable(), 0);
        }
        catch (Exception err) {
            this.setTempTableName(null);
            this.handUIException(err);
        }
        report = null;
    }

    public void setCompanyCondition(EntityViewInfo cc) {
        if (this.getUIContext().get("company") != null) {
            cc.put("company", this.getUIContext().get("company"));
        }
        if (this.getUIContext().get("companyId") != null) {
            cc.put("companyId", this.getUIContext().get("companyId"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.setCursorOfWair();
            if (e.getDataRequestMode() == 0) {
                return;
            }
            LowTimer t = new LowTimer();
            t.reset();
            IGLReport report = null;
            try {
                EntityViewInfo evi = this.getCondition();
                ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
                customCondition.setNewQuery(e.getFirstRow() == 0);
                report = this.getRemoteInstance();
                this.setCompanyCondition(this.getCondition());
                int rowIndex = e.getFirstRow() - this.getTable().getDataRequestManager().getPageRowCount();
                if (rowIndex > 0) {
                    this.getTable().getRow(rowIndex);
                }
                this.result = report.findData(this.getCondition(), e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
                this.setTempTableName(this.result.getTempTableName());
                if (this instanceof ReportJournalUI) {
                    this.result.setRowCount(this.result.getData().size());
                }
                this.showResult(this.result, this.getTable(), e.getFirstRow());
            }
            catch (Exception err) {
                this.getTable().setRowCount(0);
                this.setTempTableName(null);
                this.handUIException(err);
            }
            Object var3_3 = null;
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    public void initTable(KDTable tableForInit) {
        tableForInit.getDataRequestManager().setPageRowCount(this.getTablePageRowCount());
        tableForInit.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        tableForInit.getDataRequestManager().setDataRequestMode(1);
        tableForInit.getStyleAttributes().setLocked(true);
        int selectMode = 15;
        try {
            Object GL_125 = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_125");
            if ("1".equals(GL_125)) {
                selectMode = 10;
            }
        }
        catch (Exception e) {
            logger.info((Object)"\uff08ReportBaseUI.java\uff09get param GL_125 error\u3002");
        }
        tableForInit.getSelectManager().setSelectMode(selectMode);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)tableForInit, (int)2);
        KDTableHelper.setTabKeyJumpOrientation((KDTable)tableForInit, (int)2);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCondition() == null) {
            this.openConditionDialog();
        } else {
            if (this.getCurrentCompany().isIsBizUnit()) {
                GlUtils.updateBalance();
            } else {
                GlUtils.updateBalance((String[])null);
            }
            this.getTable().removeRows();
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.openConditionDialog();
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        return this.evp;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(9);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Period_Label"));
        sb.append("&[Period]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Currency_Label"));
        sb.append("&[Currency]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sb.append("&[CompanyName]");
        header.addRow(sb.append("&|").toString(), sa);
        this.printTopMargin = 160 + this.appendHeadRow(header);
    }

    protected int appendHeadRow(HeadFootModel header) {
        return 0;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.preparePrintPage(this.getTable());
        this.getTable().getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.preparePrintPage(this.getTable());
        this.getTable().getPrintManager().printPreview();
    }

    protected Collection getInitList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("DefaultTableHead");
        list.add("MaxAccountLevel");
        list.add("CurrentCompany");
        return list;
    }

    protected IGLReport getRemoteInstance() throws BOSException {
        return null;
    }

    protected boolean isNeedUpdateTableHead() {
        return false;
    }

    protected boolean isNeedUpdateTableColumnVisible() {
        return false;
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public void setTempTableName(String string) {
        this.tempTableName = string;
    }

    protected void disposeUIWindow() {
        if (this.tempTableName != null) {
            try {
                RptBaseFactory.getRemoteInstance().dropTable(this.tempTableName);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        super.disposeUIWindow();
    }

    public String getTitleCurrencyName() {
        return this.titleCurrencyName;
    }

    public void setTitleCurrencyName(String string) {
        this.titleCurrencyName = string;
    }

    public String getTitlePeriodName() {
        return this.titlePeriodName;
    }

    public void setTitlePeriodName(String string) {
        this.titlePeriodName = string;
    }

    public int getTablePageRowCount() {
        return 100;
    }

    public boolean isQueryByOther() {
        return this.queryByOther;
    }

    public void setQueryByOther(boolean b) {
        this.queryByOther = b;
    }

    public ReportResultInfo getResult() {
        return this.result;
    }

    public void setResult(ReportResultInfo info) {
        this.result = info;
    }

    public KDTable getSetupKDTable() {
        return this.getTable();
    }

    public Variant tableRequestPrintData(String varName) {
        Variant v = this.tableRequestPrintDataOther(varName);
        if (v != null) {
            return v;
        }
        v = new Variant();
        String companyName = "";
        if (varName.equals("CompanyName")) {
            try {
                CompanyOrgUnitInfo company = this.getCurrentCompany();
                companyName = company != null ? company.getName() : "";
            }
            catch (Exception e) {
                companyName = "";
            }
            v.setObject((Object)companyName);
        } else if (varName.equals("User")) {
            String curUser = SysContext.getSysContext().getUserName();
            v.setObject((Object)(curUser == null ? "" : curUser));
        } else if (varName.equals("Period")) {
            ReportConditionBase condition;
            String periodString = "";
            if (this.getCondition() != null && (condition = (ReportConditionBase)this.getCondition().get("GLFixCondition")) != null) {
                periodString = this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearEnd(), condition.getPeriodNumberEnd());
            }
            v.setObject((Object)periodString);
        } else if (varName.equals("Currency")) {
            ReportConditionBase condition;
            String CurrencyString = "";
            if (this.getCondition() != null && (condition = (ReportConditionBase)this.getCondition().get("GLFixCondition")) != null) {
                CurrencyString = condition.getCurrencyName();
            }
            v.setObject((Object)CurrencyString);
        } else {
            v.setObject((Object)"");
        }
        return v;
    }

    protected Variant tableRequestPrintDataOther(String varName) {
        return null;
    }

    protected String getResourceNameForPrint() {
        return "com.kingdee.eas.fi.gl.ReportPrintTitle";
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        return (CompanyOrgUnitInfo)this.getUIContext().get("company");
    }

    public void dropTable(String tablename) {
        try {
            IGLReport facade = this.getRemoteInstance();
            facade.dropTempTable(tablename);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String[] getAccountNumberNameByRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        String strAccountNumber = (String)row.getCell("FAccountNumber").getValue();
        String strAccountName = (String)row.getCell("FAccountName").getValue();
        if (strAccountNumber == null || strAccountNumber.trim().length() == 0) {
            for (int i = rowIndex - 1; i >= 0; --i) {
                strAccountNumber = (String)this.getTable().getRow(i).getCell("FAccountNumber").getValue();
                if (strAccountNumber == null || strAccountNumber.trim().length() == 0) continue;
                strAccountName = (String)this.getTable().getRow(i).getCell("FAccountName").getValue();
                break;
            }
        }
        return new String[]{strAccountNumber, strAccountName};
    }

    public String getCompanyIdByRow(int rowIndex) {
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(rowIndex).getCell("FCompany").getValue();
        if (companyUserObject == null) {
            return null;
        }
        return companyUserObject.getCompanyId();
    }

    public void initVirtualCompanyListener() {
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            this.getTable().addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (e.getButton() == 1) {
                        int row = e.getRowIndex();
                        int column = e.getColIndex();
                        ReportBaseUI.this.cellClicked(row, column, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cellClicked(int row, int column, int x, int y) {
        if (this.getTable().getRowCount() > 0 && row > -1 && column == this.getTable().getColumnIndex("FCompany")) {
            SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)this.getTable().getRow(row).getCell(column).getValue();
            if (companyUserObject == null) {
                return;
            }
            if (this.virtureCompanyRender.inRect(companyUserObject, x, y)) {
                try {
                    this.setCursorOfWair();
                    this.doExpand(companyUserObject, row);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    this.setCursorOfDefault();
                }
            }
        }
    }

    private void doExpand(SimpleCompanyUserObject companyUserObject, int rowIndex) throws Exception {
        int rowCount = this.getTable().getRowCount();
        if (companyUserObject.isLeaf()) {
            return;
        }
        this.getTable().setRefresh(false);
        if (companyUserObject.isExpanded()) {
            IRow row2;
            SimpleCompanyUserObject company2;
            for (int i = rowIndex + 1; i < rowCount && ((company2 = (SimpleCompanyUserObject)(row2 = this.getTable().getRow(i)).getCell("FCompany").getValue()) == null || company2.getLevel() > companyUserObject.getLevel()); ++i) {
                row2.getStyleAttributes().setHided(true);
            }
            companyUserObject.setExpanded(false);
        } else if (companyUserObject.isHasExpanded()) {
            this.expandRow(rowIndex);
            companyUserObject.setExpanded(true);
        } else {
            this.setExpandInfo(this.getFixCondition(), rowIndex);
            this.getFixCondition().setNewQuery(false);
            this.getFixCondition().setVirtureCompany(companyUserObject);
            IGLReport report = this.getRemoteInstance();
            this.setCompanyCondition(this.getCondition());
            this.result = report.findData(this.getCondition(), -1, -1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
            this.showResult(this.result, this.getTable(), rowIndex + 1);
            companyUserObject.setExpanded(true);
            companyUserObject.setHasExpanded(true);
        }
        this.getTable().setRefresh(true);
        this.getTable().repaint();
    }

    protected void doExpandAll(SimpleCompanyUserObject companyUserObject, int rowIndex) throws Exception {
        SimpleCompanyUserObject comObj;
        if (companyUserObject.isLeaf()) {
            return;
        }
        if (companyUserObject.isAllExpanded()) {
            this.expandAllRow(rowIndex);
            companyUserObject.setExpanded(true);
            return;
        }
        this.getTable().setRefresh(false);
        this.setExpandInfo(this.getFixCondition(), rowIndex);
        this.getFixCondition().setNewQuery(false);
        this.getFixCondition().setVirtureCompany(companyUserObject);
        IGLReport report = this.getRemoteInstance();
        this.setCompanyCondition(this.getCondition());
        this.result = report.findData(this.getCondition(), -1, -1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), true);
        IRow row = null;
        KDTable table = this.getTable();
        while ((row = table.getRow(rowIndex + 1)) != null && ((comObj = (SimpleCompanyUserObject)row.getCell(this.getTable().getColumnIndex("FCompany")).getValue()) == null || comObj.getLevel() > companyUserObject.getLevel())) {
            table.removeRow(rowIndex + 1);
        }
        this.showResult(this.result, this.getTable(), rowIndex + 1);
        companyUserObject.setExpanded(true);
        companyUserObject.setHasExpanded(true);
        companyUserObject.setAllExpanded(true);
        SimpleCompanyUserObject cuObj = null;
        int count = this.result.getData().size();
        for (int i = 1; i <= count; ++i) {
            Object obj = this.getTable().getRow(rowIndex + i).getCell(this.getTable().getColumnIndex("FCompany")).getValue();
            if (obj == null) continue;
            cuObj = (SimpleCompanyUserObject)obj;
            cuObj.setExpanded(true);
            cuObj.setHasExpanded(true);
            cuObj.setAllExpanded(true);
        }
        this.getTable().setRefresh(true);
        this.getTable().repaint();
        this.oldCompany = companyUserObject;
    }

    protected void setExpandInfo(ReportConditionBase fixCondition, int rowIndex) {
        String account = this.getAccountIdByRow(rowIndex);
        fixCondition.getExpandInfo().put("AccountID", account);
        fixCondition.getExpandInfo().put("AccountIsLeaf", this.getAccountLeafByRow(rowIndex));
    }

    protected String getAccountIdByRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        ReportLineKey userObject = (ReportLineKey)row.getUserObject();
        String account = userObject.getStrAccountID();
        return account;
    }

    protected boolean getAccountLeafByRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        ReportLineKey userObject = (ReportLineKey)row.getUserObject();
        return userObject.isAccountLeaf();
    }

    private int expandRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        int rowCount = this.getTable().getRowCount();
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)row.getCell("FCompany").getValue();
        while (++rowIndex < rowCount) {
            IRow row2 = this.getTable().getRow(rowIndex);
            SimpleCompanyUserObject companyUserObject2 = (SimpleCompanyUserObject)row2.getCell("FCompany").getValue();
            if (companyUserObject2 == null) {
                row2.getStyleAttributes().setHided(false);
                rowIndex = this.expandRow(rowIndex);
                continue;
            }
            if (companyUserObject != null && companyUserObject2.getLevel() > companyUserObject.getLevel()) {
                row2.getStyleAttributes().setHided(false);
                if (companyUserObject2.isExpanded()) {
                    rowIndex = this.expandRow(rowIndex);
                    continue;
                }
                if (companyUserObject2.isLeaf()) continue;
                rowIndex = this.expandSkipChildren(rowIndex);
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private int expandAllRow(int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        int rowCount = this.getTable().getRowCount();
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)row.getCell("FCompany").getValue();
        while (++rowIndex < rowCount) {
            IRow row2 = this.getTable().getRow(rowIndex);
            Object obj = row2.getCell("FCompany").getValue();
            if (obj != null) {
                SimpleCompanyUserObject companyUserObject2 = (SimpleCompanyUserObject)obj;
                if (companyUserObject != null && companyUserObject2.getLevel() > companyUserObject.getLevel()) {
                    row2.getStyleAttributes().setHided(false);
                    rowIndex = this.expandAllRow(rowIndex);
                    companyUserObject2.setExpanded(true);
                    companyUserObject2.setHasExpanded(true);
                    continue;
                }
                --rowIndex;
                break;
            }
            row2.getStyleAttributes().setHided(false);
            rowIndex = this.expandAllRow(rowIndex);
        }
        return rowIndex;
    }

    private int expandSkipChildren(int rowIndex) {
        IRow row2;
        SimpleCompanyUserObject companyUserObject2;
        IRow row = this.getTable().getRow(rowIndex);
        int rowCount = this.getTable().getRowCount();
        SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)row.getCell("FCompany").getValue();
        while (++rowIndex < rowCount && ((companyUserObject2 = (SimpleCompanyUserObject)(row2 = this.getTable().getRow(rowIndex)).getCell("FCompany").getValue()) == null || companyUserObject == null || companyUserObject2.getLevel() != companyUserObject.getLevel() && companyUserObject2.getLevel() != 0)) {
        }
        return rowIndex - 1;
    }

    protected KDTable getTableForPrintSetting() {
        return this.getTable();
    }

    private void setDefaultButton(JButton bt) {
        if (bt != null && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(bt);
        }
    }

    public void onShow() throws Exception {
        this.initListener();
        this.setDefaultButton(this.getDefaultButton());
        UserMonitorClientTool.monitor((CoreUIObject)this);
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    public boolean isNeedInitHead() {
        return this.isNeedInitHead;
    }

    public void setNeedInitHead(boolean isNeedInitHead) {
        this.isNeedInitHead = isNeedInitHead;
    }

    public String getSysStatusBarTitle(CoreUI ui) throws Exception {
        if (ui == null) {
            return null;
        }
        PeriodInfo curP = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        if (curP == null) {
            return null;
        }
        return ReportBaseUI.getPeriodString(curP);
    }

    public static String getPeriodString(PeriodInfo curP) {
        if (curP == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"PeriodTitle"));
        sb.append(curP.getPeriodYear()).append(EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"year"));
        sb.append(curP.getPeriodNumber()).append(EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"period"));
        return sb.toString();
    }

    protected static void checkOrgsFuncPerm(CompanyOrgUnitInfo company, String funPermItem) throws Exception {
        IGLGeneralFacade iGLGeneralFacade = GLGeneralFacadeFactory.getRemoteInstance();
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{company};
        Map mapOrgWithPerm = iGLGeneralFacade.getOrgWithPerm(funPermItem, companys);
        StringBuffer errOrg = new StringBuffer();
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company0 = companys[i];
            if (mapOrgWithPerm.containsKey(company0.getId().toString())) continue;
            if (errOrg.length() > 0) {
                errOrg.append(",");
            }
            errOrg.append(company0.getName());
        }
        if (errOrg.length() > 0) {
            ReportBaseUI.showFuncPermErr(funPermItem, errOrg.toString());
        }
    }

    private static void showFuncPermErr(String funPermItem, String errOrg) throws EASBizException, BOSException {
        PermItemCollection permColl = PermItemFactory.getRemoteInstance().getPermItemCollection("select description where number = '" + funPermItem + "'");
        String GLX_RES = "com.kingdee.eas.fi.gl.GLXResource";
        String errMsg = EASResource.getString((String)GLX_RES, (String)"no_org_funcperm");
        errMsg = errMsg.replace("{0}", errOrg);
        errMsg = errMsg.replace("{1}", permColl.get(0).getDescription());
        MsgBox.showWarning((String)errMsg);
        SysUtil.abort();
    }

    protected String getExportPermissionItem() {
        return null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action != null && action.getClass().getName().contains("ActionExport") && this.getExportPermissionItem() != null && this.getFixCondition() != null) {
            try {
                if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                    if (this.getCurrentCompany() != null) {
                        return new ObjectUuidPK(this.getCurrentCompany().getId());
                    }
                } else {
                    DefaultMutableTreeNode node;
                    ObjectUuidPK orgPK;
                    ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                    if (!GlUtils.hasFunctionPermission(null, userPK, orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId()), this.getExportPermissionItem()) && (node = (DefaultMutableTreeNode)this.getFixCondition().getTreeModelOfCompany()) != null) {
                        HashSet<String> idSet = new HashSet<String>();
                        Enumeration<TreeNode> e = node.depthFirstEnumeration();
                        while (e.hasMoreElements()) {
                            node = (DefaultMutableTreeNode)e.nextElement();
                            if (!node.isLeaf()) continue;
                            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
                            idSet.add(userObject.getCompanyId());
                        }
                        ObjectUuidPK[] orgPKs = new ObjectUuidPK[idSet.size()];
                        int index = 0;
                        for (Object e2 : idSet) {
                            orgPKs[index++] = new ObjectUuidPK(e2.toString());
                        }
                        if (orgPKs.length > 1) {
                            Set hasPermissionOrgSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, (IObjectPK[])orgPKs, this.getExportPermissionItem());
                            for (ObjectUuidPK pk : orgPKs) {
                                if (hasPermissionOrgSet.contains(pk.toString())) continue;
                                return pk;
                            }
                        }
                        return orgPKs[0];
                    }
                }
            }
            catch (BOSException | EASBizException e) {
                e.printStackTrace();
            }
        }
        return super.getOrgPK(action);
    }

    public static class CellTreeRenderer
    implements IBasicRender {
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected Icon cbIcon;
        private Map mapOfTreeNodeLocation = new Hashtable();

        public CellTreeRenderer() {
            this.cbIcon = new TreeIcon();
        }

        public boolean inRect(SimpleCompanyUserObject companyUserObject, int x, int y) {
            String companyId = companyUserObject.getCompanyId();
            Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics g, Shape clip, Object value, Style style) {
            if (value == null || !(value instanceof SimpleCompanyUserObject)) {
                return;
            }
            SimpleCompanyUserObject companyUserObject = (SimpleCompanyUserObject)value;
            int ident = companyUserObject.getLevel() * 8;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = companyUserObject.isLeaf() ? 0 : (companyUserObject.isExpanded() ? 2 : 1);
            Color color = style.getFontColor();
            g.setColor(color);
            Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
            String companyId = companyUserObject.getCompanyId();
            this.mapOfTreeNodeLocation.put(companyId, locRec);
            int xx = x + this.cbIcon.getWidth() + 8;
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(g, (Shape)newRec, companyUserObject.toString(), style);
            this.cbIcon.paint((Object)new Integer(v), g, x, y);
        }
    }

    public static class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (value instanceof Integer) {
                int type = (Integer)value;
                if (type == 0) {
                    this.drawLeaf(g, x, y);
                } else if (type == 1) {
                    this.drawCollapsed(g, x, y);
                } else {
                    this.drawExpanded(g, x, y);
                }
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }
}

