/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.MCLdgSchemeInfo;
import com.kingdee.eas.fi.gl.ReportConditionColumnarJournal;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractReportColumnarJournalConditionUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class ReportColumnarJournalConditionUI
extends AbstractReportColumnarJournalConditionUI {
    PeriodInfo currentPeriod = null;
    Map periodRange = null;
    boolean loading = false;

    public ReportConditionColumnarJournal getCustomCondition() {
        MCLdgSchemeInfo scheme;
        ReportConditionColumnarJournal condition = new ReportConditionColumnarJournal();
        Object rptObj = this.prbReportName.getValue();
        if (MCLdgSchemeInfo.class.isInstance(rptObj) && (scheme = (MCLdgSchemeInfo)rptObj) != null && scheme.getId() != null) {
            condition.setSchemeId(scheme.getId().toString());
        }
        condition.setPeriodYearStart((Integer)this.spnPeriodYearBegin.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumberBegin.getValue());
        condition.setPeriodYearEnd((Integer)this.spnPeriodYearEnd.getValue());
        condition.setPeriodNumberEnd((Integer)this.spnPeriodNumberEnd.getValue());
        condition.setOptionPosting(this.chkOpIncludeNotPosting.isSelected());
        condition.setOptionReportEveryLine(this.chkOpReportEveryLine.isSelected());
        condition.setOptionShowPeriodBalance(this.chkOpShowPeriodBalance.isSelected());
        condition.setOptionShowQuantity(this.chkOpShowQuantity.isSelected());
        condition.setOptionShowSourceAmount(this.chkOpShowSourceAmount.isSelected());
        condition.setSortByNumberDate(this.rbnSortByNumberDate.isSelected());
        return condition;
    }

    public void setCustomCondition(ReportConditionColumnarJournal condition) {
        if (condition == null) {
            return;
        }
        this.spnPeriodYearBegin.setValue((Object)new Integer(condition.getPeriodYearStart()));
        this.spnPeriodNumberBegin.setValue((Object)new Integer(condition.getPeriodNumberStart()));
        this.spnPeriodYearEnd.setValue((Object)new Integer(condition.getPeriodYearEnd()));
        this.spnPeriodNumberEnd.setValue((Object)new Integer(condition.getPeriodNumberEnd()));
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkOpReportEveryLine.setSelected(condition.getOptionReportEveryLine());
        this.chkOpShowPeriodBalance.setSelected(condition.getOptionShowPeriodBalance());
        this.chkOpShowQuantity.setSelected(condition.getOptionShowQuantity());
        this.chkOpShowSourceAmount.setSelected(condition.getOptionShowSourceAmount());
        this.rbnSortByNumberDate.setSelected(condition.isSortByNumberDate());
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CurrentPeriod");
        list.add("PeriodRange");
        list.add("CurrentCompany");
        return list;
    }

    public void setInitData(Map initData) throws ReportException {
        int[] yearRange;
        this.loading = true;
        this.setCurrentPeriod((PeriodInfo)initData.get("CurrentPeriod"));
        this.setPeriodRange((Map)initData.get("PeriodRange"));
        if (this.getPeriodRange() != null && this.getCurrentPeriod() != null && (yearRange = (int[])this.getPeriodRange().get("YearRange")) != null) {
            SpinnerNumberModel yearBeginModel = new SpinnerNumberModel(this.getCurrentPeriod().getPeriodYear(), yearRange[0], yearRange[1], 1);
            this.spnPeriodYearBegin.setModel((SpinnerModel)yearBeginModel);
            SpinnerNumberModel yearEndModel = new SpinnerNumberModel(this.getCurrentPeriod().getPeriodYear(), yearRange[0], yearRange[1], 1);
            this.spnPeriodYearEnd.setModel((SpinnerModel)yearEndModel);
            int[] periodRange = (int[])this.getPeriodRange().get(new Integer(this.getCurrentPeriod().getPeriodYear()));
            SpinnerNumberModel periodBeginModel = new SpinnerNumberModel(this.getCurrentPeriod().getPeriodNumber(), periodRange[0], periodRange[1], 1);
            this.spnPeriodNumberBegin.setModel((SpinnerModel)periodBeginModel);
            SpinnerNumberModel periodEndModel = new SpinnerNumberModel(this.getCurrentPeriod().getPeriodNumber(), periodRange[0], periodRange[1], 1);
            this.spnPeriodNumberEnd.setModel((SpinnerModel)periodEndModel);
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        filter.setMaskString("#0");
        this.prbReportName.setEntityViewInfo(view);
        this.loading = false;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public Map getPeriodRange() {
        return this.periodRange;
    }

    public void setCurrentPeriod(PeriodInfo info) {
        this.currentPeriod = info;
    }

    public void setPeriodRange(Map map) {
        this.periodRange = map;
    }

    @Override
    protected void spnPeriodYearBegin_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnPeriodYearBegin_stateChanged(e);
        Integer yearBegin = (Integer)((KDSpinner)e.getSource()).getValue();
        int[] periodRange = (int[])this.getPeriodRange().get(yearBegin);
        if (periodRange == null || periodRange.length < 2) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        Integer numberBegin = (Integer)this.spnPeriodNumberBegin.getValue();
        int iPeriodNumberBegin = 1;
        if (numberBegin != null) {
            iPeriodNumberBegin = numberBegin;
            if (iPeriodNumberBegin < periodRange[0]) {
                iPeriodNumberBegin = periodRange[0];
            } else if (iPeriodNumberBegin > periodRange[1]) {
                iPeriodNumberBegin = periodRange[1];
            }
        }
        SpinnerNumberModel periodModel = new SpinnerNumberModel(iPeriodNumberBegin, periodRange[0], periodRange[1], 1);
        this.spnPeriodNumberBegin.setModel((SpinnerModel)periodModel);
        Integer yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        if (yearEnd != null && yearEnd <= yearBegin) {
            SpinnerNumberModel yearEndModel = (SpinnerNumberModel)this.spnPeriodYearEnd.getModel();
            yearEndModel.setValue(new Integer(yearBegin));
            int[] periodRangeEnd = (int[])this.getPeriodRange().get(yearBegin);
            if (periodRangeEnd == null || periodRangeEnd.length < 2) {
                throw new ReportException(ReportException.INIT_DATA_ERROR);
            }
            Integer numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
            int iPeriodNumberEnd = 1;
            if (numberEnd != null && (iPeriodNumberEnd = numberEnd.intValue()) < iPeriodNumberBegin) {
                iPeriodNumberEnd = iPeriodNumberBegin;
            }
            SpinnerNumberModel periodEndModel = new SpinnerNumberModel(iPeriodNumberEnd, periodRangeEnd[0], periodRange[1], 1);
            this.spnPeriodNumberEnd.setModel((SpinnerModel)periodEndModel);
        }
    }

    @Override
    protected void spnPeriodNumberBegin_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnPeriodNumberBegin_stateChanged(e);
        Integer yearBegin = (Integer)this.spnPeriodYearBegin.getValue();
        Integer yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        Integer numberBegin = (Integer)this.spnPeriodNumberBegin.getValue();
        Integer numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        if (yearBegin == null || yearEnd == null || numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        int iYearBegin = yearBegin;
        int iYearEnd = yearEnd;
        int iNumberBegin = numberBegin;
        int iNumberEnd = numberEnd;
        if (iYearBegin == iYearEnd && iNumberEnd < iNumberBegin) {
            this.spnPeriodNumberEnd.setValue((Object)new Integer(iNumberBegin));
        }
    }

    @Override
    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnPeriodYearEnd_stateChanged(e);
        Integer yearEnd = (Integer)((KDSpinner)e.getSource()).getValue();
        int[] periodRangeEnd = (int[])this.getPeriodRange().get(yearEnd);
        if (periodRangeEnd == null || periodRangeEnd.length < 2) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        Integer numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        int iPeriodNumberEnd = 1;
        if (numberEnd != null) {
            iPeriodNumberEnd = numberEnd;
            if (iPeriodNumberEnd < periodRangeEnd[0]) {
                iPeriodNumberEnd = periodRangeEnd[0];
            } else if (iPeriodNumberEnd > periodRangeEnd[1]) {
                iPeriodNumberEnd = periodRangeEnd[1];
            }
        }
        SpinnerNumberModel periodModelEnd = new SpinnerNumberModel(iPeriodNumberEnd, periodRangeEnd[0], periodRangeEnd[1], 1);
        this.spnPeriodNumberEnd.setModel((SpinnerModel)periodModelEnd);
        Integer yearBegin = (Integer)this.spnPeriodYearBegin.getValue();
        if (yearBegin != null && yearBegin >= yearEnd) {
            SpinnerNumberModel yearModelBegin = (SpinnerNumberModel)this.spnPeriodYearBegin.getModel();
            yearModelBegin.setValue(new Integer(yearEnd));
            int[] periodRangeBegin = (int[])this.getPeriodRange().get(yearEnd);
            if (periodRangeBegin == null || periodRangeBegin.length < 2) {
                throw new ReportException(ReportException.INIT_DATA_ERROR);
            }
            Integer numberBegin = (Integer)this.spnPeriodNumberBegin.getValue();
            int iPeriodNumberBegin = 1;
            if (numberBegin != null && (iPeriodNumberBegin = numberBegin.intValue()) > iPeriodNumberEnd) {
                iPeriodNumberBegin = iPeriodNumberEnd;
            }
            SpinnerNumberModel periodModelBegin = new SpinnerNumberModel(iPeriodNumberBegin, periodRangeBegin[0], periodRangeBegin[1], 1);
            this.spnPeriodNumberBegin.setModel((SpinnerModel)periodModelBegin);
        }
    }

    @Override
    protected void spnPeriodNumberEnd_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnPeriodNumberEnd_stateChanged(e);
        Integer yearBegin = (Integer)this.spnPeriodYearBegin.getValue();
        Integer yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        Integer numberBegin = (Integer)this.spnPeriodNumberBegin.getValue();
        Integer numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        if (yearBegin == null || yearEnd == null || numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        int iYearBegin = yearBegin;
        int iYearEnd = yearEnd;
        int iNumberBegin = numberBegin;
        int iNumberEnd = numberEnd;
        if (iYearBegin == iYearEnd && iNumberBegin > iNumberEnd) {
            this.spnPeriodNumberBegin.setValue((Object)new Integer(iNumberEnd));
        }
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionColumnarJournal((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    @Override
    public void actionDesign_actionPerformed(ActionEvent e) throws Exception {
        super.actionDesign_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.MCLdgSchemaDesignUI", (Map)uiContext);
        uiWindow.show();
    }

    public boolean verify() {
        ReportConditionColumnarJournal cond = this.getCustomCondition();
        if (cond == null || cond.getSchemeId() == null) {
            ReportException ex = new ReportException(ReportException.SCHEME_EMPTY);
            MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            return false;
        }
        return super.verify();
    }
}

