/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportExchangeRateAdjustCondition;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractReportExchangeRateAdjustConditionUI;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;

public class ReportExchangeRateAdjustConditionUI
extends AbstractReportExchangeRateAdjustConditionUI {
    boolean loading = false;
    private CompanyOrgUnitInfo firstCompany;
    private int currYear;
    private int currMonth;
    private String strAllCurrency;
    private String uiParam = null;
    private PeriodEntity pe = null;

    @Override
    protected void prbAccountNumberBegin_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.prbAccountNumberBegin.getValue();
        Object accountTo = this.prbAccountNumberEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            this.prbAccountNumberEnd.setValue(accountFrom);
        }
    }

    @Override
    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) {
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        RptClientUtil.periodChanged((IUIObject)this, company, yearEnd, numberEnd, this.prbAccountNumberBegin, this.prbAccountNumberEnd);
    }

    public ReportExchangeRateAdjustCondition getCustomCondition() {
        Object objectCurrency;
        AccountViewInfo account;
        String strNumber;
        ReportExchangeRateAdjustCondition condition = new ReportExchangeRateAdjustCondition();
        condition.setPeriodYearStart((Integer)this.spnPeriodYearBegin.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumberBegin.getValue());
        condition.setPeriodYearEnd((Integer)this.spnPeriodYearEnd.getValue());
        condition.setPeriodNumberEnd((Integer)this.spnPeriodNumberEnd.getValue());
        condition.setAccountCodeStart(null);
        Object object = this.prbAccountNumberBegin.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeStart(strNumber.trim());
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeStart(account.getNumber());
            }
        }
        condition.setAccountCodeEnd(null);
        object = this.prbAccountNumberEnd.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeEnd(strNumber.trim() + "z");
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeEnd(account.getNumber());
            }
        }
        if ((objectCurrency = this.cmbCurrency.getSelectedItem()) != null) {
            if (objectCurrency instanceof CurrencyInfo) {
                CurrencyInfo currency = (CurrencyInfo)objectCurrency;
                condition.setCurrencyID(currency.getId().toString());
                condition.setAllCurrency(false);
            } else {
                condition.setCurrencyID(null);
                condition.setAllCurrency(true);
            }
            condition.setCurrencyName(objectCurrency.toString());
        }
        if (this.prmtCompany.getValue() == null) {
            condition.setCompany(this.firstCompany);
        } else {
            condition.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        }
        if (this.bpAccount.getSelectedItem() != null) {
            condition.setAccountTable((AccountTableInfo)this.bpAccount.getSelectedItem());
        } else {
            condition.setAccountTable(this.firstCompany.getAccountTable());
        }
        condition.setDisplayAsstDetail(this.chkDisplayAsstDetail.isSelected());
        return condition;
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportExchangeRateAdjustUI";
    }

    private String getResx(String resxItemName) {
        String resxName = this.getResourceName();
        return EASResource.getString((String)resxName, (String)resxItemName);
    }

    public void setInitData(Map initData) throws ReportException, BOSException {
        this.loading = true;
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        this.firstCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.firstCompany == null || !this.firstCompany.isIsBizUnit()) {
            this.firstCompany = this.getFirstCompany();
        }
        try {
            PeriodEntity pe;
            this.pe = pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.firstCompany);
            this.currYear = pe.getCurrentYear();
            this.currMonth = pe.getCurrentPeriod();
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        CurrencyCollection currencyCollection = (CurrencyCollection)initData.get("AllCurrency");
        this.strAllCurrency = this.getResx("AllCurrency");
        this.cmbCurrency.addItem((Object)this.strAllCurrency);
        CurrencyInfo baseCurrencyInfo = (CurrencyInfo)initData.get("DefaultCurrency");
        if (currencyCollection != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currencyInfo = currencyCollection.get(i);
                if (!(currencyInfo == null || currencyInfo.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyInfo.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString()) || currencyInfo.getId().toString().trim().equals(baseCurrencyInfo.getId().toString().trim()))) {
                    this.cmbCurrency.addItem((Object)currencyCollection.get(i));
                }
                if (currencyInfo != null && currencyInfo.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currencyInfo;
                }
                if (currencyInfo == null || !currencyInfo.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currencyInfo;
            }
        }
        this.cmbCurrency.setSelectedIndex(0);
        AccountTableInfo accountTable = this.firstCompany.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.firstCompany.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), this.spnPeriodYearEnd.getIntegerVlaue().intValue(), this.spnPeriodNumberEnd.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = RptClientUtil.periodCheckForAccountRefContrast(ar, this.spnPeriodYearEnd.getIntegerVlaue(), this.spnPeriodNumberEnd.getIntegerVlaue()) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.firstCompany.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter);
        this.prbAccountNumberBegin.setEditable(true);
        this.prbAccountNumberBegin.setEditFormat("$number$");
        this.prbAccountNumberBegin.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountNumberBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountNumberBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountNumberBegin.setCommitParser((IParser)new AccountViewParser(this.prbAccountNumberBegin));
        this.prbAccountNumberBegin.setSelector((KDPromptSelector)apb);
        this.prbAccountNumberEnd.setEditFormat("$number$");
        this.prbAccountNumberEnd.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountNumberEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountNumberEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountNumberEnd.setCommitParser((IParser)new AccountViewParser(this.prbAccountNumberEnd));
        this.prbAccountNumberEnd.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.prbAccountNumberBegin.setEntityViewInfo(myevi);
        this.prbAccountNumberEnd.setEntityViewInfo(myevi);
        this.initAccountTableComboBox();
        this.loading = false;
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportExchangeRateAdjustCondition((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void setCustomCondition(ReportExchangeRateAdjustCondition condition) {
        if (condition == null) {
            return;
        }
        if (condition.getCompany() == null) {
            this.prmtCompany.setValue((Object)this.firstCompany);
        } else {
            this.prmtCompany.setValue((Object)condition.getCompany());
        }
        this.setSelectedItem(this.bpAccount, (DataBaseInfo)condition.getAccountTable());
        this.spnPeriodYearBegin.setValue((Object)this.pe.getMinYear());
        this.spnPeriodNumberBegin.setValue((Object)this.pe.getMinPeriod(this.pe.getMinYear()));
        this.spnPeriodYearEnd.setValue((Object)this.pe.getMaxYear());
        this.spnPeriodNumberEnd.setValue((Object)this.pe.getMaxPeriod(this.pe.getMaxYear()));
        this.spnPeriodYearBegin.setValue((Object)new Integer(condition.getPeriodYearStart()));
        this.spnPeriodNumberBegin.setValue((Object)new Integer(condition.getPeriodNumberStart()));
        this.spnPeriodYearEnd.setValue((Object)new Integer(condition.getPeriodYearEnd()));
        this.spnPeriodNumberEnd.setValue((Object)new Integer(condition.getPeriodNumberEnd()));
        String currencyId = condition.getCurrencyID();
        if (currencyId == null || currencyId.trim().length() == 0) {
            this.cmbCurrency.setSelectedIndex(0);
        } else {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo;
                Object object = this.cmbCurrency.getItemAt(i);
                if (!(object instanceof CurrencyInfo) || (currencyInfo = (CurrencyInfo)object) == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.prbAccountNumberBegin.setValue((Object)condition.getAccountCodeStart());
        this.prbAccountNumberEnd.setValue((Object)condition.getAccountCodeEnd());
        this.chkDisplayAsstDetail.setSelected(condition.getDisplayAsstDetail());
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYearBegin.getEditor()).getTextField();
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"365_ReportExchangeRateAdjustConditionUI"));
            this.prmtCompany.requestFocus();
            return false;
        }
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        return !RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnPeriodYearBegin.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodNumberBegin.getValue()).intValue());
    }

    public void clear() {
        super.clear();
        this.spnPeriodYearBegin.setValue((Object)new Integer(this.currYear));
        this.spnPeriodYearEnd.setValue((Object)new Integer(this.currYear));
        this.spnPeriodNumberBegin.setValue((Object)new Integer(this.currMonth));
        this.spnPeriodNumberEnd.setValue((Object)new Integer(this.currMonth));
        this.prbAccountNumberBegin.setValue(null);
        this.prbAccountNumberEnd.setValue(null);
        this.chkDisplayAsstDetail.setSelected(false);
        if (this.strAllCurrency != null) {
            this.cmbCurrency.setSelectedItem((Object)this.strAllCurrency);
        }
        if (this.firstCompany != null) {
            this.prmtCompany.setValue((Object)this.firstCompany);
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
    }

    private void initCompanyF7() {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        AcountSchemeInfo scheme = null;
        if (SysContext.getSysContext().getCurrentFIUnit().isIsAssistantOrg()) {
            scheme = new AcountSchemeInfo();
            scheme.setIsMaster(false);
        } else {
            scheme = new AcountSchemeInfo();
            scheme.setIsMaster(true);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(companyView);
        this.prmtCompany.setSelector(this.getCompanySelector());
        this.prmtCompany.setRequired(true);
    }

    public void initListener() {
        super.initListener();
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (ReportExchangeRateAdjustConditionUI.this.isCompanyChanged(eventObj)) {
                    ReportExchangeRateAdjustConditionUI.this.companyChanged();
                }
            }
        });
        this.bpAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1 || ReportExchangeRateAdjustConditionUI.this.bpAccount.getSelectedItem() == null) {
                        ReportExchangeRateAdjustConditionUI.this.accountTableChanged();
                    }
                }
                catch (Exception e) {
                    ReportExchangeRateAdjustConditionUI.this.handUIException(e);
                }
            }
        });
    }

    protected void accountTableChanged() throws Exception {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        boolean b = account != null;
        this.prbAccountNumberBegin.setEnabled(b);
        this.prbAccountNumberEnd.setEnabled(b);
        this.prbAccountNumberBegin.setValue(null);
        this.prbAccountNumberEnd.setValue(null);
        this.setAccountF7Filter();
    }

    protected void companyChanged() {
        boolean isEnable = this.getCompanys() != null;
        this.spnPeriodYearBegin.setEnabled(isEnable);
        this.spnPeriodNumberBegin.setEnabled(isEnable);
        this.spnPeriodYearEnd.setEnabled(isEnable);
        this.spnPeriodNumberEnd.setEnabled(isEnable);
        this.setSelectedItem(this.bpAccount, (DataBaseInfo)this.getSameAccountTableInfo());
        Object accountTable = this.bpAccount.getSelectedItem();
        this.prbAccountNumberBegin.setEnabled(isEnable && accountTable != null);
        this.prbAccountNumberEnd.setEnabled(isEnable && accountTable != null);
        if (isEnable) {
            this.setPeriodRange();
        }
        this.setAccountF7Filter();
        this.firePropertyChange("companyF7", null, this.getCompanyIdSet());
    }

    protected void setSelectedItem(KDComboBox comboBox, DataBaseInfo dbInfo) {
        if (dbInfo == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (!(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !dbInfo.getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    private AccountTableInfo getSameAccountTableInfo() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return null;
        }
        AccountTableInfo accountTable = companys[0].getAccountTable();
        if (accountTable == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountTable() == null) {
                return null;
            }
            if (companys[i].getAccountTable().getId().equals((Object)accountTable.getId())) continue;
            return null;
        }
        return accountTable;
    }

    private void setPeriodRange() {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        for (int i = 0; i < companys.length; ++i) {
            companyColl.add(companys[i]);
        }
        boolean isPeriodEnable = !companyColl.isEmpty();
        this.spnPeriodYearBegin.setEnabled(isPeriodEnable);
        this.spnPeriodNumberBegin.setEnabled(isPeriodEnable);
        this.spnPeriodYearEnd.setEnabled(isPeriodEnable);
        this.spnPeriodNumberEnd.setEnabled(isPeriodEnable);
        if (isPeriodEnable) {
            try {
                Map pdRang = VoucherFacadeFactory.getRemoteInstance().getPeriodRange(companyColl, null);
                PeriodEntity pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                this.spnPeriodYearBegin.setEnabled(false);
                this.spnPeriodYearEnd.setEnabled(false);
                this.spnPeriodNumberBegin.setEnabled(false);
                this.spnPeriodNumberEnd.setEnabled(false);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    protected void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (accountTable == null || companys == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection accountfic = filter.getFilterItems();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
            accountfic.add(new FilterItemInfo("companyid.id", (Object)company.getId().toString()));
            accountfic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            filter.setMaskString("#0 and #1 ");
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter);
            EntityViewInfo accountmyevi = new EntityViewInfo();
            accountmyevi.setFilter(filter);
            this.prbAccountNumberBegin.setEntityViewInfo(accountmyevi);
            this.prbAccountNumberEnd.setEntityViewInfo(accountmyevi);
            this.prbAccountNumberBegin.setSelector((KDPromptSelector)apb);
            this.prbAccountNumberEnd.setSelector((KDPromptSelector)apb);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    protected KDPromptSelector getCompanySelector() {
        if (!GlUtils.isEmpty(this.uiParam) && "FSSC".equalsIgnoreCase(this.uiParam)) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.prmtCompany, this.getPermissionItem(), true, this.getCompanyFilterSql());
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.partFI.adjustExchangeTable.id", null, CompareType.NOTEMPTY));
        StringBuffer periodFilterSql = new StringBuffer();
        periodFilterSql.append("select 1 from T_BD_SystemStatusCtrol  AS sysctrl ");
        periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
        periodFilterSql.append(" where sysstatus.FName = 6 ");
        periodFilterSql.append(" and sysctrl.FCompanyID = \"UNIT\".fid ");
        periodFilterSql.append(" and sysctrl.fstartperiodid is not null ");
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)periodFilterSql.toString(), CompareType.EXISTS));
        companySelector.setOuterFilterInfo(filter);
        return companySelector;
    }

    private String getCompanyFilterSql() {
        return " cp.FAdjustExgTableID is not null ";
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getCompanyIdFilter() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private String getPermissionItem() {
        return "gl_exchangeRate_view";
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.prmtCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
        }
        if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.prmtCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.prmtCompany.setValue((Object)companys);
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem(), " and " + this.getCompanyFilterSql());
        }
        catch (Exception e) {
            this.handUIException(e);
            return SysContext.getSysContext().getCurrentFIUnit();
        }
    }

    protected void initAccountTableComboBox() {
        try {
            AccountTableCollection accountTables = this.getAllAccountTableCollection();
            Vector accountTableList = this.toVector((AbstractObjectCollection)accountTables);
            accountTableList.add(0, null);
            this.bpAccount.setModel(new DefaultComboBoxModel(accountTableList));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    private AccountTableCollection getAllAccountTableCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
    }
}

