/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GLReportExchangeRateAdjustFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.PLType;
import com.kingdee.eas.fi.gl.ReportExchangeRateAdjustCondition;
import com.kingdee.eas.fi.gl.client.AbstractReportExchangeRateAdjustUI;
import com.kingdee.eas.fi.gl.client.GLLicenseUtils;
import com.kingdee.eas.fi.gl.client.ReportExchangeRateAdjustConditionUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerConditionUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.KeyStroke;

public class ReportExchangeRateAdjustUI
extends AbstractReportExchangeRateAdjustUI {
    CommonQueryDialog conditionDialog = null;
    ReportExchangeRateAdjustConditionUI conditionPanel = null;
    PLChangeListener plChangeListener = new PLChangeListener();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ReportExchangeRateAdjustConditionUI();
            this.conditionPanel.setInitData(this.getInitData());
        }
        return this.conditionPanel;
    }

    @Override
    protected Collection getInitList() {
        Collection list = ReportGeneralLedgerConditionUI.getInitDataItem();
        list.add("DefaultTableHead");
        list.add("ParmForeignCurrencyIsUse");
        list.add("ParmUsingReportingCurrency");
        list.add("CurrentCompany");
        return list;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return GLReportExchangeRateAdjustFactory.getRemoteInstance();
    }

    @Override
    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportExchangeRateAdjustUI";
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        ReportExchangeRateAdjustCondition condition = ((ReportExchangeRateAdjustConditionUI)this.getConditionPanel()).getCustomCondition();
        mainQuery.put("GLFixCondition", (Object)condition);
        this.getUIContext().put("company", condition.getCompany());
        this.setCondition(mainQuery);
        this.setReportExtraTitle(condition);
        this.setShowForPreCol(true);
        this.tblMain.removeRows();
        this.setEnumDisplayStatus();
    }

    @Override
    protected EntityViewInfo getDefaultEntityViewInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        return view;
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }

    @Override
    public EntityViewInfo getCondition() {
        if (this.condition != null) {
            ReportExchangeRateAdjustCondition c = (ReportExchangeRateAdjustCondition)this.condition.get("GLFixCondition");
            c.setPltype((PLType)((Object)this.plCombo.getSelectedItem()));
        }
        return this.condition;
    }

    protected void initListener() {
    }

    protected void switchCompany(CompanyOrgUnitInfo company) throws Exception {
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.comboCompany.getSelectedIndex();
        if (index > 0) {
            this.comboCompany.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.comboCompany.getSelectedIndex();
        if (index < this.comboCompany.getItemCount() - 1) {
            this.comboCompany.setSelectedIndex(index + 1);
        }
    }

    private void setEnumDisplayStatus() {
        this.lblCompany.setVisible(true);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.comboCompany.setVisible(false);
        this.actionPre.setEnabled(false);
        this.actionNext.setEnabled(false);
        this.comboCompany.setEnabled(false);
    }

    public void setReportExtraTitle(ReportExchangeRateAdjustCondition condition) {
        if (condition == null) {
            return;
        }
        String strYear = this.getResx("NIAN");
        String strNumber = this.getResx("DI");
        String strPeriod = this.getResx("QI");
        String strSeparator = this.getResx("SEPARATOR");
        String strPrePeriod = this.getResx("PREPERIOD");
        String strPreCurrency = this.getResx("PRECURRENCY");
        String strPreCompany = this.getResx("CompanyName");
        int yearBegin = condition.getPeriodYearStart();
        int numberBegin = condition.getPeriodNumberStart();
        int yearEnd = condition.getPeriodYearEnd();
        int numberEnd = condition.getPeriodNumberEnd();
        String txtPeriod = strPrePeriod + this.getPeriodTitle(yearBegin, numberBegin, yearEnd, numberEnd);
        this.lblPeriod.setText(txtPeriod);
        this.lblCurrency.setText(strPreCurrency + condition.getCurrencyName());
        this.lblCompany.setText(strPreCompany + condition.getCompany().getName());
        this.plCombo.removeItemListener((ItemListener)this.plChangeListener);
        this.plCombo.setSelectedItem((Object)PLType.PL);
        this.plCombo.addItemListener((ItemListener)this.plChangeListener);
    }

    private String getResx(String resxItemName) {
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        return EASResource.getString((String)resxName, (String)resxItemName);
    }

    @Override
    public void onLoad() throws Exception {
        GLLicenseUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, this);
        super.onLoad();
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintView.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            String uiParam = (String)this.getUIContext().get("UIClassParam");
            if (this.getUIContext() != null && !GlUtils.isEmpty(uiParam) && "FSSC".equalsIgnoreCase(uiParam)) {
                this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.MultiOrg") + this.getConditionPanel().getUITitle());
            } else {
                this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            }
            this.conditionDialog.setMaxReturnCountVisible(false);
        }
        return this.conditionDialog;
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    protected Map findInitData() throws Exception {
        Map map = super.findInitData();
        map.put("ParmGroupPattern", true);
        return map;
    }

    class PLChangeListener
    implements ItemListener {
        PLChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                ReportExchangeRateAdjustUI.this.actionRefresh_actionPerformed(null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

