/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedger;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.client.AbstractReportGeneralLedgerConditionUI;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.ReportBalanceListConditionUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ReportGeneralLedgerConditionUI
extends AbstractReportGeneralLedgerConditionUI {
    private static final long serialVersionUID = 9213881559259547204L;
    private static final Logger logger = CoreUIObject.getLogger(ReportGeneralLedgerConditionUI.class);
    CompanyOrgUnitInfo company;
    CompanyTreeSelectUI ctsUI = null;
    JDialog dialog = null;
    private TreeModel treeModelOfCompany = null;
    private TreeModel treeModelOfCompanyClone = null;
    String companyIds;
    boolean companyFilterChanged = false;
    boolean isFromScm = false;
    private Map initDataUsingForClear = null;
    private boolean isQueryByOther = false;
    private ActionListener cmbCurrencyLs = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportGeneralLedgerConditionUI.this.beforeActionPerformed(e);
            try {
                ReportGeneralLedgerConditionUI.this.cmbCurrency_actionPerformed(e);
            }
            catch (Exception exc) {
                ReportGeneralLedgerConditionUI.this.handUIException(exc);
            }
            finally {
                ReportGeneralLedgerConditionUI.this.afterActionPerformed(e);
            }
        }
    };

    public void setIsQueryByOther(boolean isQueryByOther) {
        this.isQueryByOther = isQueryByOther;
    }

    public ReportGeneralLedgerConditionUI() throws Exception {
        this.initListeners();
    }

    private void initListeners() {
        this.chkOpNoAmount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportGeneralLedgerConditionUI.this.chkOpZeroNoAmount.setSelected(false);
                    ReportGeneralLedgerConditionUI.this.chkOpZeroNoAmount.setEnabled(false);
                    ReportGeneralLedgerConditionUI.this.jcbNoDisplayZeroTotal.setSelected(false);
                } else {
                    ReportGeneralLedgerConditionUI.this.chkOpZeroNoAmount.setEnabled(true);
                }
            }
        });
        this.chkOpZeroNoAmount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportGeneralLedgerConditionUI.this.chkOpNoAmount.setSelected(false);
                    ReportGeneralLedgerConditionUI.this.chkOpNoAmount.setEnabled(false);
                } else {
                    ReportGeneralLedgerConditionUI.this.chkOpNoAmount.setEnabled(true);
                    ReportGeneralLedgerConditionUI.this.chkOpNoAmount.setEnabled(true);
                }
            }
        });
        this.jcbNoDisplayZeroTotal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportGeneralLedgerConditionUI.this.chkOpNoAmount.setSelected(false);
                }
            }
        });
        this.bpAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (ReportGeneralLedgerConditionUI.this.company != null) {
                        ReportGeneralLedgerConditionUI.this.reSetButtonStatus();
                        ReportGeneralLedgerConditionUI.this.reSetAccountF7();
                    }
                }
                catch (Exception e) {
                    ReportGeneralLedgerConditionUI.this.companyFilterChanged = true;
                    ReportGeneralLedgerConditionUI.this.tfCompany.setText("");
                    ReportGeneralLedgerConditionUI.this.tfCompany.setToolTipText("");
                    ReportGeneralLedgerConditionUI.this.btnCompany.setEnabled(false);
                    MsgBox.showInfo((Component)((Object)ReportGeneralLedgerConditionUI.this), (String)e.getMessage());
                }
            }
        });
        this.bpPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (ReportGeneralLedgerConditionUI.this.company != null) {
                        ReportGeneralLedgerConditionUI.this.reSetButtonStatus();
                    }
                }
                catch (Exception e) {
                    ReportGeneralLedgerConditionUI.this.companyFilterChanged = true;
                    ReportGeneralLedgerConditionUI.this.tfCompany.setText("");
                    ReportGeneralLedgerConditionUI.this.tfCompany.setToolTipText("");
                    ReportGeneralLedgerConditionUI.this.btnCompany.setEnabled(false);
                    MsgBox.showInfo((Component)((Object)ReportGeneralLedgerConditionUI.this), (String)e.getMessage());
                }
            }
        });
    }

    private void initButtonStatus() {
        this.tfCompany.setRequired(true);
        this.tfCompany.setEditable(false);
        if (GlUtils.isCompanyUnion(this.company)) {
            this.btnCompany.setEnabled(true);
            this.tfCompany.setEnabled(true);
            this.bpPeriod.setEnabled(true);
            this.prbAccountBegin.setEnabled(false);
            this.prbAccountEnd.setEnabled(false);
            this.spnPeriodYearBegin.setEnabled(false);
            this.spnPeriodYearEnd.setEnabled(false);
            this.spnPeriodNumberBegin.setEnabled(false);
            this.spnPeriodNumberEnd.setEnabled(false);
            this.spnAccountLevelBegin.setEnabled(false);
            this.spnAccountLevelEnd.setEnabled(false);
        } else {
            this.btnCompany.setEnabled(false);
            this.tfCompany.setEnabled(false);
            this.bpPeriod.setEnabled(false);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (this.isQueryByOther) {
                return;
            }
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    @Override
    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) throws Exception {
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.setPeriodEnd();
            this.bpAccount.setValue((Object)this.company.getAccountTable());
        }
    }

    private void setPeriodEnd() {
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.prbAccountBegin, this.prbAccountEnd);
    }

    public ReportConditionGeneralLedger getCustomCondition() {
        Object objectCurrency;
        AccountViewInfo account;
        String strNumber;
        ReportConditionGeneralLedger condition = new ReportConditionGeneralLedger();
        HashMap<String, RptConditionManager> hm = new HashMap<String, RptConditionManager>();
        RptConditionManager rc = new RptConditionManager();
        rc.recordAllStatus((Container)((Object)this));
        hm.put("RptCondition", rc);
        condition.setExpandInfo(hm);
        Integer companyLevel = (Integer)this.spnCompanyLevel.getValue();
        if (companyLevel == null || companyLevel <= 0) {
            companyLevel = 1;
        }
        condition.setExpandCompanyLevel(companyLevel);
        condition.setPeriodYearStart((Integer)this.spnPeriodYearBegin.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumberBegin.getValue());
        condition.setPeriodYearEnd((Integer)this.spnPeriodYearEnd.getValue());
        condition.setPeriodNumberEnd((Integer)this.spnPeriodNumberEnd.getValue());
        condition.setAccountLevelStart((Integer)this.spnAccountLevelBegin.getValue());
        condition.setAccountLevelEnd((Integer)this.spnAccountLevelEnd.getValue());
        condition.setAccountCodeStart(null);
        Object object = this.prbAccountBegin.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeStart(strNumber.trim());
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeStart(account.getNumber());
            }
        }
        condition.setAccountCodeEnd(null);
        object = this.prbAccountEnd.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeEnd(strNumber.trim() + "z");
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeEnd(account.getNumber());
            }
        }
        if ((objectCurrency = this.cmbCurrency.getSelectedItem()) != null) {
            if (objectCurrency instanceof CurrencyInfo) {
                CurrencyInfo currency = (CurrencyInfo)objectCurrency;
                condition.setCurrencyID(currency.getId().toString());
                condition.setAllCurrencyMultiColumn(false);
            } else {
                condition.setCurrencyID(null);
                condition.setAllCurrencyMultiColumn(true);
            }
            condition.setCurrencyName(objectCurrency.toString());
        }
        condition.setOptionPosting(this.chkOpIncludeNoPostingPeriod.isSelected());
        condition.setOptionNOTDisplayIfNoAmount(this.chkOpNoAmount.isSelected());
        condition.setOptionNOTDisplayIfZeroNoAmount(this.chkOpZeroNoAmount.isSelected());
        condition.setOptionNoDisplayZeroTotal(this.jcbNoDisplayZeroTotal.isSelected());
        condition.setOptionShowQuantity(this.chkOpDisplayQuantity.isSelected());
        condition.setShowTotal(this.chkShowTotal.isSelected());
        if (GlUtils.isCompanyUnion(this.company) && this.treeModelOfCompany != null) {
            condition.setTreeModelOfCompany(this.treeModelOfCompany.getRoot());
        }
        condition.getExpandInfo().put("company", this.company);
        if (this.bpAccount.getValue() != null && this.bpAccount.getValue() instanceof AccountTableInfo) {
            condition.getExpandInfo().put("accountTableId", ((AccountTableInfo)this.bpAccount.getValue()).getId().toString());
        }
        condition.setNotIncludePLVoucher(this.chkNotIncludePLVoucher.isSelected());
        return condition;
    }

    public void setInitData(Map initData) throws ReportException {
        this.initDataUsingForClear = initData;
        this.initComapny(initData);
        this.initCompanyLevel();
        this.initButtonStatus();
        this.initPeriod(initData);
        this.initAccountLevel();
        this.initCurrency(initData);
        this.initAccountTable();
        this.initPeriodType();
        this.initAccount();
        this.setDefaultAccountPeriod();
    }

    private void setDefaultAccountPeriod() {
        try {
            if (GlUtils.isCompanyUnion(this.company)) {
                RptClientUtil.setDefaultAccountPeriod(this.company, this.bpPeriod, this.bpAccount);
            } else {
                this.setPeriodEnd();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCompanyDisplayMode() {
        if (GlUtils.isCompanyUnion(this.company)) {
            this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.level);
            if (this.canDetailDisplay()) {
                this.cbDisplayMode.addItem((Object)CompanyDisplayModeEnum.details);
            } else {
                this.cbDisplayMode.setEnabled(false);
            }
        } else {
            this.kDLabelContainer4.setVisible(false);
            this.cbDisplayMode.setEnabled(false);
            this.kDLabelContainer5.setVisible(false);
            this.spnCompanyLevel.setEnabled(false);
        }
    }

    private boolean canDetailDisplay() {
        return false;
    }

    private void setCompanyMaxLevel() {
        boolean isLevel = this.cbDisplayMode.getSelectedItem() == CompanyDisplayModeEnum.level;
        this.kDLabelContainer5.setVisible(isLevel);
        if (isLevel) {
            int maxLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany) + 1;
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
    }

    private void initComapny(Map initData) {
        this.company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        try {
            RptClientUtil.fullCompanyInfo(this.company);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.tfCompany.setText(this.company.getName());
        this.tfCompany.setToolTipText(this.company.getName());
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setValue((Object)this.company.getAccountTable());
            this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        }
        this.setCompanyDisplayMode();
    }

    private void initCompanyLevel() {
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spnCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
    }

    private void initPeriod(Map initData) throws ReportException {
        if (GlUtils.isCompanyUnion(this.company)) {
            PeriodInfo pi = (PeriodInfo)initData.get("CurrentPeriod");
            HashMap<String, Object> allMap = new HashMap<String, Object>();
            int year = 0;
            int periodNumber = 0;
            if (pi == null) {
                Date a = new Date();
                year = a.getYear() + 1900;
                periodNumber = a.getMonth() + 1;
            } else {
                year = pi.getPeriodYear();
                periodNumber = pi.getPeriodNumber();
            }
            HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
            map.put(new Integer(year), new int[]{periodNumber, periodNumber});
            allMap.put("usedPeriod", map);
            allMap.put("queryPeriod", map);
            allMap.put("currentPeriod", new int[]{year, periodNumber});
            PeriodEntity pe = new PeriodEntity(allMap);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)false);
        } else {
            try {
                PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)true);
            }
            catch (Exception e) {
                throw new ReportException(ReportException.PERIOD_ERROR, e);
            }
        }
    }

    private void initAccountLevel() {
        SpinnerUtil.manageAccountLevelRange((int)1, (int)10, (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
    }

    private void initCurrency(Map initData) {
        CurrencyInfo defaultCurrency;
        this.cmbCurrency.removeAllItems();
        CurrencyCollection currencyCollection = (CurrencyCollection)initData.get("AllCurrency");
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        if (currencyCollection != null) {
            Boolean reportCurrency;
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    this.cmbCurrency.addItem((Object)currencyCollection.get(i));
                }
                if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currency;
            }
            boolean useForeignCurrency = false;
            boolean useReportCurrency = false;
            Boolean foreignCurrency = (Boolean)initData.get("ParmForeignCurrencyIsUse");
            if (foreignCurrency != null) {
                useForeignCurrency = foreignCurrency;
            }
            if ((reportCurrency = (Boolean)initData.get("ParmUsingReportingCurrency")) != null) {
                useReportCurrency = reportCurrency;
            }
            if (!useForeignCurrency) {
                if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem((Object)generalLocalCurrency);
                }
                if (useReportCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem((Object)generalRptCurrency);
                }
            }
        }
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.cmbCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        }
        if ((defaultCurrency = (CurrencyInfo)initData.get("DefaultCurrency")) != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)defaultCurrency);
        }
    }

    private void initAccountTable() {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        ev.setFilter(filter);
        fic.add(new FilterItemInfo("destCompany.id", (Object)this.company.getId().toString()));
        this.bpAccount.setEntityViewInfo(ev);
        this.bpAccount.setEditable(true);
        this.bpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountTableQuery");
        this.bpAccount.setEditFormat("$number$");
        this.bpAccount.setCommitFormat("$number$");
        this.bpAccount.setDisplayFormat("$number$ - $name$");
    }

    private void initPeriodType() {
        this.bpPeriod.setEditable(true);
        this.bpPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodTypeQuery");
        this.bpPeriod.setEditFormat("$number$");
        this.bpPeriod.setCommitFormat("$number$");
        this.bpPeriod.setDisplayFormat("$number$ - $name$");
    }

    private void initAccount() {
        if (this.company.getAccountTable() == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        this.prbAccountBegin.setEditable(true);
        this.prbAccountBegin.setEditFormat("$number$");
        this.prbAccountBegin.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountBegin.setCommitParser((IParser)new AccountViewParser(this.prbAccountBegin));
        this.prbAccountEnd.setEditFormat("$number$");
        this.prbAccountEnd.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountEnd.setCommitParser((IParser)new AccountViewParser(this.prbAccountEnd));
        this.prbAccountBegin.setEntityViewInfo(ev);
        this.prbAccountEnd.setEntityViewInfo(ev);
        this.setAccountF7Filter();
    }

    @Override
    protected void prbAccountEnd_dataChanged(DataChangeEvent e) throws Exception {
        String strAccountNumber;
        String[] accountValue;
        if (this.isFromScm) {
            return;
        }
        BOSUuid companyId = SysContext.getSysContext().getCurrentFIUnit().getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        if (account == null) {
            return;
        }
        ObjectUuidPK accountTablePK = new ObjectUuidPK(account.getId());
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        int i = 1;
        int j = 1;
        if (accountFrom != null) {
            if (accountFrom instanceof AccountViewInfo) {
                i = ((AccountViewInfo)accountFrom).getLevel();
            } else {
                String accountNumberNameFrom = accountFrom.toString();
                if (accountNumberNameFrom != null) {
                    accountValue = accountNumberNameFrom.split(" ");
                    strAccountNumber = accountValue[0];
                    i = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
                }
            }
        }
        if (accountTo != null) {
            if (accountTo instanceof AccountViewInfo) {
                j = ((AccountViewInfo)accountTo).getLevel();
            } else {
                String accountNumberNameTo = accountTo.toString();
                if (accountNumberNameTo != null) {
                    accountValue = accountNumberNameTo.split(" ");
                    strAccountNumber = accountValue[0];
                    j = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
                }
            }
        }
        this.spnAccountLevelBegin.setValue((Object)Math.min(i, j));
        this.spnAccountLevelEnd.setValue((Object)Math.max(i, j));
    }

    @Override
    protected void prbAccountBegin_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            this.prbAccountEnd.setValue(accountFrom);
        } else {
            this.prbAccountEnd_dataChanged(e);
        }
    }

    private void reSetAccountF7() {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        if (account != null && this.prbAccountBegin.getEntityViewInfo() != null) {
            FilterInfo fi = this.prbAccountBegin.getEntityViewInfo().getFilter();
            if (fi.getFilterItems().size() == 1) {
                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            } else {
                fi.getFilterItems().set(1, new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            }
            fi.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            fi.setMaskString("#0 and #1 AND #2");
            this.prbAccountBegin.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
            this.prbAccountEnd.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
        }
    }

    private void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = this.company.getAccountTable();
            CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{this.company};
            if (accountTable == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            for (int i = 0; i < companys.length; ++i) {
                companyColl.add(companys[i]);
            }
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)companys[0].getId().toString()));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            fic.add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            String mStr = "#0  AND #1 AND #2";
            filter.setMaskString(mStr);
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            this.prbAccountBegin.setSelector((KDPromptSelector)apb);
            this.prbAccountEnd.setSelector((KDPromptSelector)apb);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    private void reSetButtonStatus() {
        boolean b;
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        boolean bl = b = account != null && period != null;
        if (GlUtils.isCompanyUnion(this.company)) {
            this.btnCompany.setEnabled(b);
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
            this.companyFilterChanged = true;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
        this.prbAccountBegin.setEnabled(account != null);
        this.prbAccountEnd.setEnabled(account != null);
        this.spnAccountLevelBegin.setEnabled(account != null);
        this.spnAccountLevelEnd.setEnabled(account != null);
        this.spnPeriodYearBegin.setEnabled(b);
        this.spnPeriodYearEnd.setEnabled(b);
        this.spnPeriodNumberBegin.setEnabled(b);
        this.spnPeriodNumberEnd.setEnabled(b);
        if (account != null) {
            this.company.setAccountTable(account);
        }
        if (period != null) {
            this.company.setAccountPeriodType(period);
        }
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        list.add("CurrentCompany");
        return list;
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportGeneralLedgerUI";
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setCustomCondition(ReportConditionGeneralLedger condition) {
        block16: {
            String currencyId;
            block15: {
                String accountEnd;
                if (condition == null) {
                    return;
                }
                Map hm = condition.getExpandInfo();
                RptConditionManager rc = (RptConditionManager)hm.get("RptCondition");
                if (rc != null) {
                    rc.restoreAllStatus((Container)((Object)this));
                }
                this.bpAccount.setEnabled(true);
                Object accountTableId = hm.get("accountTableId");
                if (!(accountTableId == null || this.bpAccount.getValue() != null && ((AccountTableInfo)this.bpAccount.getValue()).getId().toString().equals(accountTableId))) {
                    try {
                        AccountTableInfo accountTable = (AccountTableInfo)AccountTableFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)accountTableId))));
                        this.bpAccount.setValue((Object)accountTable);
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u83b7\u53d6\u79d1\u76ee\u8868\u5931\u8d25\uff0c", (Throwable)e);
                    }
                }
                if (GlUtils.isCompanyUnion(this.company)) {
                    this.treeModelOfCompany = new DefaultTreeModel((TreeNode)condition.getTreeModelOfCompany());
                    this.companyChanged(this.treeModelOfCompany);
                }
                this.spnPeriodYearEnd.setValue((Object)condition.getPeriodYearEnd());
                this.spnPeriodYearBegin.setValue((Object)condition.getPeriodYearStart());
                this.spnPeriodNumberEnd.setValue((Object)condition.getPeriodNumberEnd());
                this.spnPeriodNumberBegin.setValue((Object)condition.getPeriodNumberStart());
                if (condition.getAccountCodeStart() != null) {
                    try {
                        AccountViewInfo accFrom = VoucherIOSparser.findAccountViewInfoByNumber(condition.getAccountCodeStart(), false);
                        this.prbAccountBegin.setValue((Object)accFrom);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
                if ((accountEnd = condition.getAccountCodeEnd()) != null && accountEnd.endsWith("z")) {
                    accountEnd = accountEnd.substring(0, accountEnd.length() - 1);
                }
                if (accountEnd != null) {
                    try {
                        AccountViewInfo accTo = VoucherIOSparser.findAccountViewInfoByNumber(accountEnd, false);
                        this.prbAccountEnd.setValue((Object)accTo);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
                this.spnAccountLevelBegin.setValue((Object)condition.getAccountLevelStart());
                this.spnAccountLevelEnd.setValue((Object)condition.getAccountLevelEnd());
                int expandLevel = condition.getExpandCompanyLevel();
                if (expandLevel <= 0) {
                    expandLevel = 1;
                }
                this.spnCompanyLevel.setValue((Object)expandLevel);
                currencyId = condition.getCurrencyID();
                if (currencyId != null && currencyId.trim().length() != 0) break block15;
                if (this.cmbCurrency.getItemCount() == 0) break block16;
                this.cmbCurrency.setSelectedIndex(this.cmbCurrency.getItemCount() - 1);
                break block16;
            }
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo;
                Object object = this.cmbCurrency.getItemAt(i);
                if (!(object instanceof CurrencyInfo) || (currencyInfo = (CurrencyInfo)object) == null || !currencyId.equals(currencyInfo.getId().toString())) continue;
                this.cmbCurrency.removeActionListener(this.cmbCurrencyLs);
                this.cmbCurrency.setSelectedIndex(i);
                this.cmbCurrency.addActionListener(this.cmbCurrencyLs);
                break;
            }
        }
        this.chkOpIncludeNoPostingPeriod.setSelected(condition.getOptionPosting());
        this.chkOpNoAmount.setSelected(condition.isOptionNOTDisplayIfNoAmount());
        this.chkOpZeroNoAmount.setSelected(condition.isOptionNOTDisplayIfZeroNoAmount());
        this.jcbNoDisplayZeroTotal.setSelected(condition.isOptionNoDisplayZeroTotal());
        this.chkOpDisplayQuantity.setSelected(condition.isOptionShowQuantity());
        this.chkShowTotal.setSelected(condition.isShowTotal());
        this.chkNotIncludePLVoucher.setSelected(condition.isNotIncludePLVoucher());
        this.companyFilterChanged = false;
        this.isFromScm = true;
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionGeneralLedger((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYearBegin.getEditor()).getTextField();
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        Object objectCurrency;
        PeriodTypeInfo period;
        AccountTableInfo account;
        if (this.ctsUI == null) {
            this.dialog = new JDialog(InitClientHelp.getFrameAncestor((Component)((Object)this)), true);
            this.dialog.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    ReportGeneralLedgerConditionUI.this.ctsUI.clearSelectCompanySet();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }
            });
            this.ctsUI = new CompanyTreeSelectUI(this.company);
            this.ctsUI.initListener();
            this.ctsUI.setDialog(this.dialog);
            this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
            this.dialog.setSize(640, 480);
            InitClientHelp.centerWindow(this.dialog);
            this.dialog.setResizable(false);
            this.dialog.setTitle(this.ctsUI.getUITitle());
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            this.ctsUI.setPmissionItem(ReportGeneralLedgerUI.getPermItem());
            this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("companyChanged")) {
                        ReportGeneralLedgerConditionUI.this.companyChanged(evt.getNewValue());
                    }
                }
            });
        }
        if (this.companyFilterChanged || this.treeModelOfCompany == null || this.isFromScm) {
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            this.companyFilterChanged = false;
            this.isFromScm = false;
        }
        if ((objectCurrency = this.cmbCurrency.getSelectedItem()) instanceof CurrencyInfo && ((CurrencyInfo)objectCurrency).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportGeneralLedgerConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
        } else {
            this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportGeneralLedgerConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
        }
        this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
        this.dialog.setVisible(true);
    }

    protected void companyChanged(Object object) {
        if (object != null) {
            Object objectnew = null;
            try {
                objectnew = ObjectUtils.createCopy((Object)object);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            this.treeModelOfCompany = (TreeModel)object;
            this.treeModelOfCompanyClone = (TreeModel)objectnew;
            try {
                String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
                this.tfCompany.setText(info);
                this.tfCompany.setToolTipText(info);
                this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
                this.company.setDescription(this.companyIds);
                PeriodEntity pe = null;
                pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
                if (!this.isFromScm) {
                    SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (!GlUtils.isCompanyUnion(this.company) ? 1 : 0) != 0);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                this.tfCompany.setText("");
                this.tfCompany.setToolTipText("");
            }
            this.setCompanyMaxLevel();
        }
    }

    public boolean verify() {
        Integer beginLevel = (Integer)this.spnAccountLevelBegin.getValue();
        Integer endLevel = (Integer)this.spnAccountLevelEnd.getValue();
        if (beginLevel != null && endLevel != null && beginLevel > endLevel) {
            MsgBox.showInfo((Component)this.spnAccountLevelBegin, (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"18_ReportSubsidiaryLedgerConditionUI"));
            return false;
        }
        if (GlUtils.isCompanyUnion(this.company)) {
            if (this.bpAccount.getValue() == null) {
                this.bpAccount.requestFocus();
                MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
                return false;
            }
            this.company.setAccountTable((AccountTableInfo)this.bpAccount.getValue());
            if (this.bpPeriod.getValue() == null) {
                this.bpPeriod.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
                return false;
            }
            if (this.treeModelOfCompany == null) {
                this.btnCompany.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
                return false;
            }
            try {
                this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            try {
                if (!ReportBalanceListConditionUI.hasPhysicalCompany(this.treeModelOfCompany)) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                    return false;
                }
                Object objectCurrency = this.cmbCurrency.getSelectedItem();
                if (objectCurrency instanceof CurrencyInfo && this.companyIds != null) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)objectCurrency;
                    HashSet<String> idSet = new HashSet<String>();
                    String[] idArray = this.companyIds.split(",");
                    for (int i = 1; i < idArray.length; ++i) {
                        idSet.add(idArray[i].replaceAll("'", "").trim());
                    }
                    if (idSet.size() > 0 && currencyInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC") && !RptClientUtil.isSameBaseCurrency(RptClientUtil.getCompanyCollection(idSet))) {
                        MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("localCyIncons"));
                        return false;
                    }
                }
                int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
                int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
                RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                return false;
            }
            catch (Exception e) {
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void cmbCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.cmbCurrency_actionPerformed_new(e);
    }

    protected void cmbCurrency_actionPerformed_new(ActionEvent e) throws Exception {
        super.cmbCurrency_actionPerformed(e);
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo) {
            this.chkShowTotal.setSelected(false);
            this.chkShowTotal.setEnabled(false);
        } else {
            this.chkShowTotal.setEnabled(true);
        }
    }

    protected void initListener() {
        this.cmbCurrency.addActionListener(this.cmbCurrencyLs);
    }

    public void clear() {
        super.clear();
        if (this.isQueryByOther) {
            this.isQueryByOther = false;
            return;
        }
        try {
            this.setInitData(this.initDataUsingForClear);
        }
        catch (ReportException e) {
            logger.error((Object)e);
            this.handUIException((Throwable)((Object)e));
        }
        this.isFromScm = false;
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        this.chkOpIncludeNoPostingPeriod.setSelected(false);
        this.chkOpZeroNoAmount.setSelected(false);
        this.chkOpNoAmount.setSelected(false);
        this.chkOpDisplayQuantity.setSelected(false);
        this.spnAccountLevelBegin.setValue((Object)1);
        this.spnAccountLevelEnd.setValue((Object)1);
        this.jcbNoDisplayZeroTotal.setSelected(false);
        this.chkNotIncludePLVoucher.setSelected(false);
    }
}

