/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerPrintByAccountAddBf;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportGeneralLedgerTaoDa
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(ReportGeneralLedgerTaoDa.class);
    public static final String[] col = new String[]{"sysDateNow", "h_CurrentUser", "h_period", "h_currency", "h_company", "FPeriodYearHead", "FPeriodYear", "FPeriodMonth", "FperiodDay", "FPeriodChinese", "FAccountNumber", "FAccountName", "FCompany", "FCurrencyID", "FCurrencyName", "FCurrencyPre", "FPeriodRedundancy", "FPeriod", "FDescOfVoucher", "FDebitQty", "FDebitFor", "FDebitLocal", "FDebitRpt", "FCreditQty", "FCreditFor", "FCreditLocal", "FCreditRpt", "FQty", "FPrice", "FBalanceOritention", "FBalanceAmountFor", "FBalanceAmountLocal", "FBalanceAmountRpt"};
    Collection colTaoDa = null;
    Map mapInfo = null;
    String[] strGetColumnName;
    boolean bBF = false;
    boolean printByAccount = false;
    int[] iScal = null;
    ArrayList alPeriods = null;
    boolean isChkFillAccountNumberAndName = false;
    String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.TaoDaResource";

    public ReportGeneralLedgerTaoDa(Collection colTaoDa, Map mapInfo, String[] strGetColumnName, boolean bBF, boolean printByAccount, int[] iScal, ArrayList alPeriods) {
        this.colTaoDa = colTaoDa;
        this.mapInfo = mapInfo;
        this.strGetColumnName = strGetColumnName;
        this.bBF = bBF;
        this.printByAccount = printByAccount;
        this.iScal = iScal;
        this.alPeriods = alPeriods;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    private String getValue(IRowSet rowSet, int pace, String field) throws SQLException {
        String returnVal = "";
        int cp = rowSet.getRow();
        rowSet.absolute(cp + pace);
        returnVal = rowSet.getString(field);
        rowSet.absolute(cp);
        return returnVal;
    }

    private void insertEmptyRow(IRowSet rowSet) throws SQLException {
        int rowNum = rowSet.getRow();
        rowSet.moveToInsertRow();
        rowSet.updateString("FCompany", "");
        rowSet.updateString("FPeriod", "");
        rowSet.updateString("FDebitQty", "");
        rowSet.updateString("FCreditQty", "");
        rowSet.updateString("FQty", "");
        rowSet.updateString("FPrice", "");
        rowSet.updateString("h_period", "");
        rowSet.updateString("FPeriodYear", "");
        rowSet.updateString("FPeriodMonth", "");
        rowSet.updateString("FperiodDay", "");
        rowSet.updateString("FPeriodRedundancy", "");
        rowSet.updateString("FPeriodMonth", "");
        rowSet.updateString("FperiodDay", "");
        rowSet.updateString("FAccountNumber", "");
        rowSet.updateString("FAccountName", "");
        rowSet.updateString("FPeriod", "");
        rowSet.updateString("FDescOfVoucher", "");
        rowSet.updateString("FBalanceOritention", "");
        rowSet.updateString("FDebitFor", "");
        rowSet.updateString("FDebitLocal", "");
        rowSet.updateString("FDebitRpt", "");
        rowSet.updateString("FCreditFor", "");
        rowSet.updateString("FCreditLocal", "");
        rowSet.updateString("FCreditRpt", "");
        rowSet.updateString("FBalanceAmountFor", "");
        rowSet.updateString("FBalanceAmountLocal", "");
        rowSet.updateString("FBalanceAmountRpt", "");
        rowSet.insertRow();
        rowSet.beforeFirst();
        rowSet.absolute(rowNum + 1);
    }

    public IRowSet getRowSet(int rowLineCount) {
        SimpleDateFormat format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
        int it = 0;
        int entryCount = 0;
        int icycleDegree = rowLineCount;
        int entryNumber = 0;
        int ir = 1;
        int flagBF = 0;
        boolean bearForwardPage = false;
        boolean overHypoPage = false;
        String[] strYearMonthDay = null;
        String cell_yearInitAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_yearInitAmount");
        String cell_periodInitAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_periodInitAmount");
        String cell_periodAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_periodAmount");
        String cell_yearAmount = EASResource.getString((String)this.RESOURCE_PATH, (String)"cell_yearAmount");
        int colCount = col.length;
        String strTempNumber = null;
        String strTempName = null;
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            it = this.colTaoDa.size();
            entryCount = 0;
            Iterator iterator = this.colTaoDa.iterator();
            while (iterator.hasNext()) {
                drs.moveToInsertRow();
                ReportGeneralLedgerTaoDa.clearRow((IRowSet)drs);
                Object[] lineObjects = (Object[])iterator.next();
                if (lineObjects == null) continue;
                ++entryCount;
                drs.updateString("sysDateNow", GlUtils.formatDate(format, new Date()));
                if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                    drs.updateString("h_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
                } else {
                    drs.updateString("h_CurrentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
                }
                if (this.mapInfo.get("period") != null) {
                    drs.updateString("h_period", this.mapInfo.get("period").toString());
                }
                if (this.mapInfo.get("currency") != null) {
                    drs.updateString("h_currency", this.mapInfo.get("currency").toString());
                }
                String yearBegin = null;
                if (this.mapInfo.get("yearBegin") != null) {
                    yearBegin = this.mapInfo.get("yearBegin").toString();
                }
                String yearEnd = null;
                if (this.mapInfo.get("yearEnd") != null) {
                    yearEnd = this.mapInfo.get("yearEnd").toString();
                }
                if (yearBegin != null && !StringUtils.isEmpty((String)yearBegin) && yearEnd != null && !StringUtils.isEmpty((String)yearEnd)) {
                    if (yearBegin.equals(yearEnd)) {
                        drs.updateString("FPeriodYearHead", yearBegin);
                    } else {
                        drs.updateString("FPeriodYearHead", yearBegin + "-" + yearEnd);
                    }
                }
                drs.updateString("h_company", SysContext.getSysContext().getCurrentFIUnit().toString());
                for (int i = 0; i < this.strGetColumnName.length; ++i) {
                    if (lineObjects[i] == null) continue;
                    if (lineObjects[i].getClass() != BigDecimal.class) {
                        drs.updateString(this.strGetColumnName[i], lineObjects[i].toString());
                        if (this.strGetColumnName[i].equalsIgnoreCase("FCompany")) {
                            drs.updateString(this.strGetColumnName[i], SysContext.getSysContext().getCurrentFIUnit().toString());
                        }
                        if (this.strGetColumnName[i].equalsIgnoreCase("FPeriod")) {
                            String[] yearMonthDay;
                            String periodTemp = this.getPeriodTemp(lineObjects[i].toString());
                            String[] strPeriodStartEnd = this.getCompoundingPeriodData(periodTemp);
                            strYearMonthDay = yearMonthDay = this.getYearMonthDay(strPeriodStartEnd);
                            drs.updateString("FPeriodRedundancy", lineObjects[i].toString());
                            if (lineObjects[i] != null) {
                                String strPeriodChinese = this.getYearAndMonthChinese(lineObjects[i].toString());
                                drs.updateString("FPeriodChinese", strPeriodChinese);
                            }
                        }
                        if (strYearMonthDay != null && lineObjects[i].toString().equalsIgnoreCase(cell_periodInitAmount) || lineObjects[i].toString().equalsIgnoreCase(cell_yearInitAmount)) {
                            drs.updateString("FPeriodYear", (String)strYearMonthDay[0]);
                            drs.updateString("FPeriodMonth", strYearMonthDay[1]);
                            drs.updateString("FperiodDay", strYearMonthDay[2]);
                        } else if (strYearMonthDay != null && lineObjects[i].toString().equalsIgnoreCase(cell_periodAmount) || lineObjects[i].toString().equalsIgnoreCase(cell_yearAmount)) {
                            drs.updateString("FPeriodYear", strYearMonthDay[3]);
                            drs.updateString("FPeriodMonth", strYearMonthDay[4]);
                            drs.updateString("FperiodDay", strYearMonthDay[5]);
                        }
                        if (!this.isChkFillAccountNumberAndName) continue;
                        if (this.strGetColumnName[i].equalsIgnoreCase("FAccountNumber") && !lineObjects[i].toString().equals("")) {
                            strTempNumber = lineObjects[i].toString();
                        }
                        if (this.strGetColumnName[i].equalsIgnoreCase("FAccountNumber") && lineObjects[i].toString().equals("")) {
                            drs.updateString(this.strGetColumnName[i], strTempNumber);
                        }
                        if (this.strGetColumnName[i].equalsIgnoreCase("FAccountName") && !lineObjects[i].toString().equals("")) {
                            strTempName = lineObjects[i].toString();
                        }
                        if (!this.strGetColumnName[i].equalsIgnoreCase("FAccountName") || !lineObjects[i].toString().equals("")) continue;
                        drs.updateString(this.strGetColumnName[i], strTempName);
                        continue;
                    }
                    if (((BigDecimal)lineObjects[i]).compareTo(new BigDecimal("0")) == 0) {
                        drs.updateString(this.strGetColumnName[i], "");
                        continue;
                    }
                    drs.updateString(this.strGetColumnName[i], GlUtils.withComma((BigDecimal)lineObjects[i], this.iScal[i]));
                }
                drs.insertRow();
                if (!this.bBF || this.printByAccount) continue;
                if (it - entryCount > icycleDegree) {
                    bearForwardPage = true;
                    overHypoPage = true;
                }
                if (it == entryCount + flagBF) {
                    bearForwardPage = false;
                    overHypoPage = false;
                    ir = 1;
                }
                if (++entryNumber != icycleDegree - ir) continue;
                if (overHypoPage) {
                    drs.moveToInsertRow();
                    ++flagBF;
                    ++it;
                    drs.updateString("FAccountNumber", strTempNumber);
                    drs.updateString("FAccountName", strTempName);
                    drs.updateString("FCompany", "");
                    drs.updateString("FCurrencyName", "");
                    drs.updateString("FCurrencyPre", "");
                    drs.updateString("FPeriodRedundancy", "");
                    drs.updateString("FDebitQty", "");
                    drs.updateString("FCreditQty", "");
                    drs.updateString("FQty", "");
                    drs.updateString("FPrice", "");
                    drs.updateString("FPeriodYear", "");
                    drs.updateString("FPeriodMonth", "");
                    drs.updateString("FperiodDay", "");
                    String resFullName = "com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage";
                    String strOverHypoPage = EASResource.getString((String)resFullName);
                    drs.updateString("FDescOfVoucher", strOverHypoPage);
                    drs.insertRow();
                }
                if (bearForwardPage) {
                    drs.moveToInsertRow();
                    ++flagBF;
                    ++it;
                    drs.updateString("FAccountNumber", strTempNumber);
                    drs.updateString("FAccountName", strTempName);
                    drs.updateString("FCompany", "");
                    drs.updateString("FCurrencyName", "");
                    drs.updateString("FCurrencyPre", "");
                    drs.updateString("FPeriodRedundancy", "");
                    drs.updateString("FDebitQty", "");
                    drs.updateString("FCreditQty", "");
                    drs.updateString("FQty", "");
                    drs.updateString("FPrice", "");
                    drs.updateString("FPeriodYear", "");
                    drs.updateString("FPeriodMonth", "");
                    drs.updateString("FperiodDay", "");
                    String resFullName = "com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage";
                    String strBearForwardPage = EASResource.getString((String)resFullName);
                    drs.updateString("FDescOfVoucher", strBearForwardPage);
                    drs.insertRow();
                }
                entryNumber = 0;
                if (it - entryCount <= icycleDegree) continue;
                ir = 2;
            }
            if (this.bBF) {
                if (this.printByAccount) {
                    ReportGeneralLedgerPrintByAccountAddBf addBf = new ReportGeneralLedgerPrintByAccountAddBf();
                    addBf.addBf((IRowSet)drs, rowLineCount);
                } else {
                    drs.beforeFirst();
                    while (!drs.last()) {
                        String resFullName = "com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage";
                        String strBearForwardPage = EASResource.getString((String)resFullName);
                        if (drs.getString("FDescOfVoucher").equals(strBearForwardPage)) {
                            drs.next();
                            String accountName = drs.getString("FAccountName");
                            drs.previous();
                            drs.updateString("FAccountName", accountName);
                        }
                        drs.next();
                    }
                }
            }
            if (this.printByAccount) {
                drs.beforeFirst();
                drs.next();
                String curAccountNumber = drs.getString("FAccountNumber");
                int rowCount = 1;
                while (!drs.isLast()) {
                    try {
                        String nextRowAccountNumber = this.getValue((IRowSet)drs, 1, "FAccountNumber");
                        if (nextRowAccountNumber != null && nextRowAccountNumber.length() != 0 && !nextRowAccountNumber.equals(curAccountNumber)) {
                            for (int i = rowCount; i < rowLineCount; ++i) {
                                this.insertEmptyRow((IRowSet)drs);
                            }
                            curAccountNumber = nextRowAccountNumber;
                            rowCount = 1;
                        } else {
                            rowCount = rowCount < rowLineCount ? ++rowCount : 1;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    drs.next();
                }
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    protected String getPeriodTemp(String strPeriod) throws Exception {
        String sPeriod = null;
        try {
            String yearBegin = this.mapInfo.get("yearBegin").toString();
            String numberBegin = this.mapInfo.get("numberBegin").toString();
            String yearEnd = this.mapInfo.get("yearEnd").toString();
            String numberEnd = this.mapInfo.get("numberEnd").toString();
            sPeriod = yearBegin.equalsIgnoreCase(yearEnd) && numberBegin.equalsIgnoreCase(numberEnd) && strPeriod.indexOf(".") == -1 ? yearBegin + "." + strPeriod : (yearBegin.equalsIgnoreCase(yearEnd) && !numberBegin.equalsIgnoreCase(numberEnd) && strPeriod.indexOf(".") == -1 ? yearBegin + "." + strPeriod : strPeriod);
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"221_ReportGeneralLedgerTaoDa"));
            SysUtil.abort();
        }
        return sPeriod;
    }

    protected String[] getCompoundingPeriodData(String strPeriod) throws Exception {
        String[] sDate = null;
        Object[] obj = null;
        String[] strPeriodStartEnd = null;
        if (strPeriod.contains(".")) {
            sDate = strPeriod.split("\\.");
            strPeriodStartEnd = new String[2];
            int n = this.alPeriods.size();
            for (int i = 0; i < n; ++i) {
                obj = (Object[])this.alPeriods.get(i);
                if (!sDate[0].equalsIgnoreCase(obj[0].toString()) || !sDate[1].equalsIgnoreCase(obj[1].toString())) continue;
                strPeriodStartEnd[0] = obj[2].toString();
                strPeriodStartEnd[1] = obj[3].toString();
                break;
            }
        } else {
            String msg = EASResource.getString((String)this.RESOURCE_PATH, (String)"lblDataError");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        return strPeriodStartEnd;
    }

    protected String[] getYearMonthDay(String[] strPeriodStartEnd) throws Exception {
        String[] periodStart = strPeriodStartEnd[0].split("\\-");
        String[] periodEnd = strPeriodStartEnd[1].split("\\-");
        String[] yearMonthDay = new String[]{periodStart[0], periodStart[1], periodStart[2], periodEnd[0], periodEnd[1], periodEnd[2]};
        return yearMonthDay;
    }

    protected String getYearAndMonthChinese(String strPeriod) throws Exception {
        String sPeriod = null;
        String strdi = EASResource.getString((String)this.RESOURCE_PATH, (String)"di");
        String strqi = EASResource.getString((String)this.RESOURCE_PATH, (String)"qi");
        if (strPeriod.indexOf(".") != -1) {
            String[] sPeriods = strPeriod.split("\\.");
            Locale locale = SysContext.getSysContext().getLocale();
            String strPq = GlUtils.getChineseFormat(Integer.parseInt(sPeriods[0]), locale);
            String strPh = null;
            if (sPeriods.length > 1) {
                strPh = GlUtils.getChineseBig(Integer.parseInt(sPeriods[1]), locale);
            }
            sPeriod = strPq + strdi + strPh + strqi;
        } else {
            sPeriod = strdi + strPeriod + strqi;
        }
        if (sPeriod == null) {
            String msg = EASResource.getString((String)this.RESOURCE_PATH, (String)"lblDataError");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        return sPeriod;
    }

    public void setChkFillAccountNumberAndName(boolean v) {
        this.isChkFillAccountNumberAndName = v;
    }
}

