/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLReportGeneralLedgerFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedger;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedgerAssist;
import com.kingdee.eas.fi.gl.ReportLineKey;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.client.AbstractReportGeneralLedgerUI;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.ReportBaseUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerAssistUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerConditionUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerTaoDa;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerTaoDaAccount;
import com.kingdee.eas.fi.gl.client.ReportGeneralParame;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class ReportGeneralLedgerUI
extends AbstractReportGeneralLedgerUI {
    private static final long serialVersionUID = -8458762944997777519L;
    private static final Logger logger = CoreUIObject.getLogger(ReportGeneralLedgerUI.class);
    protected CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
    CommonQueryDialog conditionDialog = null;
    ReportGeneralLedgerConditionUI conditionPanel = null;
    ReportGeneralParame editParame = ReportGeneralParame.getInstance();
    Collection colTaoda = null;
    Map mapInfo;
    String[] strGetColumnName;
    int[] iScal;
    ArrayList altPeriods;
    boolean isOptionNoDisplayZeroTotal = false;
    static Map mapGl;
    static ArrayList altPeriod;

    public ReportGeneralLedgerUI() throws Exception {
        this.setPreferredSize(new Dimension(800, 600));
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintView);
        this.menuFile.add((JMenuItem)this.menuItemPrintParame);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuTool.add((JMenuItem)this.menuItemCalculator);
        this.menuView.add((JMenuItem)this.menuItemFilter);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuView.add((JMenuItem)this.menuItemSubsidiaryLedger);
        this.menuView.add((JMenuItem)this.menuItemAssistGeneralLedger);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemRegPro);
        this.menuHelp.add((JMenuItem)this.menuItemPersonalSite);
        this.menuHelp.add((Component)this.helpseparatorDiv);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    @Override
    protected KDTable getTable() {
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            return this.tblMainGroup;
        }
        return this.tblMain;
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return GLReportGeneralLedgerFactory.getRemoteInstance();
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return true;
    }

    protected ReportGeneralLedgerConditionUI getDefaultConditionObject() throws Exception {
        return new ReportGeneralLedgerConditionUI();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.getDefaultConditionObject();
            if (this.getInitData() == null) {
                this.setInitData(this.findInitData());
            }
            this.conditionPanel.setInitData(this.getInitData());
        }
        if (this.isQueryByOther()) {
            ReportConditionGeneralLedger glCondition;
            if (this.getCondition() != null && (glCondition = (ReportConditionGeneralLedger)this.getCondition().get("GLFixCondition")) != null) {
                this.conditionPanel.setParam(glCondition.toMap());
            }
            this.conditionPanel.setIsQueryByOther(true);
        } else {
            this.conditionPanel.setIsQueryByOther(false);
        }
        return this.conditionPanel;
    }

    private boolean canJoinQuery() {
        ReportConditionBase glCondition = (ReportConditionBase)this.getCondition().get("GLFixCondition");
        return glCondition.isCanJoinQueryOther();
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        ReportConditionGeneralLedger condition = ((ReportGeneralLedgerConditionUI)this.getConditionPanel()).getCustomCondition();
        mainQuery.put("GLFixCondition", (Object)condition);
        if (!this.getCurrentCompany().isIsBizUnit()) {
            this.getUIContext().put("company", condition.getExpandInfo().get("company"));
        } else if (!this.isQueryByOther()) {
            int yearEnd = condition.getPeriodYearEnd();
            int numberEnd = condition.getPeriodNumberEnd();
            this.getUIContext().put("company", RptClientUtil.getCompany(yearEnd, numberEnd));
        }
        condition.getExpandInfo().remove("company");
        this.setCondition(mainQuery);
        this.setReportExtraTitle(condition);
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            this.queryVirtualData(true);
        } else {
            this.getTable().removeRows();
        }
        this.setJoinActionEnable(false);
    }

    @Override
    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportGeneralLedgerUI";
    }

    @Override
    protected Collection getInitList() {
        Collection list = ReportGeneralLedgerConditionUI.getInitDataItem();
        list.add("DefaultTableHead");
        list.add("ParmForeignCurrencyIsUse");
        list.add("ParmUsingReportingCurrency");
        list.add("CurrentCompany");
        list.add("ParmGroupPattern");
        return list;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            this.queryVirtualData(true);
        } else {
            super.actionRefresh_actionPerformed(e);
        }
        this.setJoinActionEnable(false);
    }

    public void setReportExtraTitle(ReportConditionGeneralLedger condition) {
        if (condition == null) {
            return;
        }
        String strPrePeriod = this.getResx("PREPERIOD");
        String strPreCurrency = this.getResx("PRECURRENCY");
        int yearBegin = condition.getPeriodYearStart();
        int numberBegin = condition.getPeriodNumberStart();
        int yearEnd = condition.getPeriodYearEnd();
        int numberEnd = condition.getPeriodNumberEnd();
        if (this.mapInfo == null) {
            this.mapInfo = new HashMap();
        } else {
            this.mapInfo.clear();
        }
        this.mapInfo.put("yearBegin", new Integer(condition.getPeriodYearStart()));
        this.mapInfo.put("numberBegin", new Integer(condition.getPeriodNumberStart()));
        this.mapInfo.put("yearEnd", new Integer(condition.getPeriodYearEnd()));
        this.mapInfo.put("numberEnd", new Integer(condition.getPeriodNumberEnd()));
        try {
            this.altPeriods = ReportGeneralLedgerUI.getPeriods(condition.getPeriodYearStart(), condition.getPeriodYearEnd());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.isOptionNoDisplayZeroTotal = condition.isOptionNoDisplayZeroTotal() || condition.isOptionNOTDisplayIfNoAmount() || condition.isOptionNOTDisplayIfZeroNoAmount();
        String txtPeriod = strPrePeriod + this.getPeriodTitle(yearBegin, numberBegin, yearEnd, numberEnd);
        this.lblPeriod.setText(txtPeriod);
        this.lblCurrency.setText(strPreCurrency + condition.getCurrencyName());
    }

    private String getResx(String resxItemName) {
        Locale locale = this.getCurrentLocale();
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    public void actionSubsidiaryLedger_actionPerformed(ActionEvent e) throws Exception {
        this.findSubsidiaryLedger();
    }

    @Override
    public void actionAssistGeneralLedger_actionPerformed(ActionEvent e) throws Exception {
        if (this.condition != null) {
            ReportConditionGeneralLedger glCondition = (ReportConditionGeneralLedger)this.condition.get("GLFixCondition");
            if (glCondition.isNotIncludePLVoucher() && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"PL_ASSOCIATED_NOT_SUPPORT")))) {
                return;
            }
            this.findAssistGeneral();
        }
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        boolean byOther = false;
        if (this.isQueryByOther()) {
            this.getConditionPanel();
            byOther = true;
        }
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.conditionPanel == null) {
                this.getConditionPanel();
            }
            if (byOther) {
                this.conditionDialog.setOwner((Component)InitClientHelp.getFrameAncestor((Component)((Object)this)));
            } else {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            }
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setShowDefaultSolution(true);
            this.conditionDialog.setWidth(400);
            this.conditionDialog.setHeight(400);
            this.conditionDialog.addUserPanel((KDPanel)this.conditionPanel);
            this.conditionDialog.setTitle(this.conditionPanel.getUITitle());
            this.conditionDialog.setMaxReturnCountVisible(false);
            this.conditionDialog.setOnlyShowInCurrentOrg(true);
        }
        return this.conditionDialog;
    }

    @Override
    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        if (data == null || tableForShowData == null) {
            return;
        }
        ReportTableHeadInfo headInfo = this.getCurrentTableHeadInfo();
        if (headInfo == null) {
            return;
        }
        this.colTaoda = data;
        this.strGetColumnName = new String[this.getCurrentTableHeadInfo().getColumnCount()];
        this.strGetColumnName = this.getCurrentTableHeadInfo().getColumnNames();
        this.iScal = this.getCurrentTableHeadInfo().getNumberScales();
        int index = startRow;
        int size = data.size();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Object objPre;
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            for (int i = 0; i < this.getCurrentTableHeadInfo().getColumnCount(); ++i) {
                ICell cell = row.getCell(this.getCurrentTableHeadInfo().getColumnNames()[i]);
                if (cell == null || lineObjects[i] == null) continue;
                if (lineObjects[i].getClass() != BigDecimal.class) {
                    cell.setValue(lineObjects[i]);
                    continue;
                }
                if (ZERO.compareTo((BigDecimal)lineObjects[i]) == 0) continue;
                cell.setValue((Object)((BigDecimal)lineObjects[i]));
            }
            row.getStyleAttributes().setBackground(ReportGeneralLedgerUI.getColor((Integer)lineObjects[lineObjects.length - 2]));
            String strAccountCode = (String)row.getCell("FAccountNumber").getValue();
            String strAccountName = (String)row.getCell("FAccountName").getValue();
            if (this.getFixCondition().getCurrencyID() == null && row.getCell("FCurrencyPre") != null && (objPre = row.getCell("FCurrencyPre").getValue()) != null && objPre instanceof Integer) {
                String format = this.getNumberFormat((Integer)objPre, true);
                row.getCell("FDebitFor").getStyleAttributes().setNumberFormat(format);
                row.getCell("FCreditFor").getStyleAttributes().setNumberFormat(format);
                row.getCell("FBalanceAmountFor").getStyleAttributes().setNumberFormat(format);
            }
            row.setUserObject(lineObjects[lineObjects.length - 1]);
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.btnSubsidiaryLedger.setEnabled(true);
        this.btnSubsidiaryLedger.setVisible(true);
        Map uiContext = this.getUIContext();
        Boolean queryByOther = (Boolean)uiContext.get("QueryByOther");
        if (queryByOther != null && queryByOther.booleanValue()) {
            this.setQueryByOther(true);
        } else {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            ReportGeneralLedgerUI.checkOrgsFuncPerm(company, ReportGeneralLedgerUI.getPermItem());
        }
        super.onLoad();
        if (this.getCurrentCompany() != null && this.getCurrentCompany().isIsBizUnit() && this.getTable().getColumn("FCompany") != null) {
            this.getTable().getColumn("FCompany").getStyleAttributes().setHided(true);
        }
        this.getMainStatusBar().setPerTitle(this.getSysStatusBarTitle(this));
        this.btnSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_listaccount"));
        this.btnAssistGeneralLedger.setIcon(EASResource.getIcon((String)"imgTbtn_assistantgeneralledger"));
        this.menuItemSubsidiaryLedger.setIcon(EASResource.getIcon((String)"imgTbtn_listaccount"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemHelp.setIcon(EASResource.getIcon((String)"imgTbtn_help"));
        this.menuItemAssistGeneralLedger.setIcon(EASResource.getIcon((String)"imgTbtn_assistantgeneralledger"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintView.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        if (this.currCompany.isIsBizUnit()) {
            this.menuItemPrintParame.setVisible(true);
            this.menuItemPrintParame.setEnabled(true);
            this.menuItemPrintAccountContents.setVisible(false);
            this.menuItemPrintAccountContents.setEnabled(false);
        } else {
            this.menuItemPrintParame.setEnabled(false);
            this.menuItemPrintParame.setVisible(false);
            this.menuItemPrintAccountContents.setVisible(false);
            this.menuItemPrintAccountContents.setEnabled(false);
        }
        this.setJoinActionEnable(false);
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            this.tblMain.setVisible(false);
            this.tblMainGroup.setVisible(true);
        } else {
            this.tblMain.setVisible(true);
            this.tblMainGroup.setVisible(false);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        IColumn col;
        try {
            this.setCursorOfWair();
            if (e.getDataRequestMode() == 0) {
                return;
            }
            LowTimer t = new LowTimer();
            t.reset();
            IGLReport report = null;
            try {
                ReportConditionGeneralLedger rcb = (ReportConditionGeneralLedger)this.getCondition().get("GLFixCondition");
                if (rcb.getCurrencyID() == null) {
                    this.setShowForPreCol(true);
                    this.tblMain.getViewManager().setFreezeView(0, 2);
                } else {
                    this.setShowForPreCol(false);
                }
                EntityViewInfo evi = this.getCondition();
                ReportConditionBase customCondition = (ReportConditionBase)evi.get("GLFixCondition");
                customCondition.setNewQuery(e.getFirstRow() == 0);
                report = this.getRemoteInstance();
                this.setCompanyCondition(this.getCondition());
                this.result = report.findData(this.getCondition(), e.getFirstRow(), e.getLastRow() - e.getFirstRow() + 1, this.getTempTableName(), (CompanyOrgUnitInfo)this.getUIContext().get("company"), false);
                this.setTempTableName(this.result.getTempTableName());
                this.showResult(this.result, this.getTable(), e.getFirstRow());
            }
            catch (Exception err) {
                this.getTable().setRowCount(0);
                this.setTempTableName(null);
                this.handUIException(err);
            }
            report = null;
        }
        finally {
            this.setCursorOfDefault();
        }
        EntityViewInfo en = this.getCondition();
        ReportConditionGeneralLedger rcb = (ReportConditionGeneralLedger)en.get("GLFixCondition");
        if (rcb.isOptionShowQuantity()) {
            for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                col = this.tblMain.getColumn(i);
                if (!col.getKey().endsWith("Qty") && !col.getKey().equalsIgnoreCase("FPrice")) continue;
                col.getStyleAttributes().setHided(false);
            }
        } else {
            for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                col = this.tblMain.getColumn(i);
                if ((col == null || !col.getKey().endsWith("Qty")) && !col.getKey().equalsIgnoreCase("FPrice")) continue;
                col.getStyleAttributes().setHided(true);
            }
        }
    }

    @Override
    protected void setExpandInfo(ReportConditionBase fixCondition, int rowIndex) {
        IRow row = this.getTable().getRow(rowIndex);
        ReportLineKey userObject = (ReportLineKey)row.getUserObject();
        String account = userObject.getStrAccountID();
        String accountNumber = userObject.getStrAccountNumber();
        int sortNumber = userObject.getSortNumber();
        int periodYear = userObject.getPeriodYear();
        int periodNumber = userObject.getPeriodNumber();
        fixCondition.getExpandInfo().put("AccountID", account);
        fixCondition.getExpandInfo().put("AccountNumber", accountNumber);
        fixCondition.getExpandInfo().put("SortNumber", new Integer(sortNumber));
        fixCondition.getExpandInfo().put("PeriodNumber", new Integer(periodNumber));
        fixCondition.getExpandInfo().put("PeriodYear", new Integer(periodYear));
    }

    protected void initListener() {
        this.getTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (!ReportGeneralLedgerUI.this.actionSubsidiaryLedger.isEnabled()) {
                        return;
                    }
                    try {
                        ReportGeneralLedgerUI.this.setCursorOfWair();
                        ReportGeneralLedgerUI.this.findSubsidiaryLedger();
                    }
                    catch (Exception exc) {
                        ReportGeneralLedgerUI.this.handUIException(exc);
                    }
                    finally {
                        ReportGeneralLedgerUI.this.setCursorOfDefault();
                    }
                }
            }
        });
        super.initVirtualCompanyListener();
    }

    private static void setTreeModelOfCompany(ReportConditionBase rc, CompanyOrgUnitInfo company) throws Exception {
        if (!company.isIsBizUnit()) {
            CompanyTreeSelectUI ui = new CompanyTreeSelectUI(company);
            ui.setAccountTableID(company.getAccountTable().getId().toString());
            ui.setPeriodTypeID(company.getAccountPeriodType().getId().toString());
            ui.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportGeneralLedgerUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)ui.treeOrigin.getModel().getRoot();
            DefaultKingdeeTreeNode simpleRoot = new DefaultKingdeeTreeNode();
            DefaultKingdeeTreeNode bigNode = root;
            ui.makeSimpleTree((DefaultMutableTreeNode)bigNode, (DefaultMutableTreeNode)simpleRoot, bigNode.getLevel());
            rc.setTreeModelOfCompany(simpleRoot);
        }
    }

    public static void queryByCondition(EntityViewInfo currentCondition, CoreUIObject owner, CompanyOrgUnitInfo company, boolean isVirtual) throws Exception {
        if (currentCondition == null) {
            return;
        }
        ReportConditionGeneralLedger glCondition = (ReportConditionGeneralLedger)currentCondition.get("GLFixCondition");
        if (glCondition == null) {
            return;
        }
        ReportGeneralLedgerUI.checkOrgsFuncPerm(company, ReportGeneralLedgerUI.getPermItem());
        ReportGeneralLedgerUI.reQueryPeriodRange(company, glCondition);
        if (mapGl == null) {
            mapGl = new HashMap();
        } else {
            mapGl.clear();
        }
        mapGl.put("yearBegin", new Integer(glCondition.getPeriodYearStart()));
        mapGl.put("numberBegin", new Integer(glCondition.getPeriodNumberStart()));
        mapGl.put("yearEnd", new Integer(glCondition.getPeriodYearEnd()));
        mapGl.put("numberEnd", new Integer(glCondition.getPeriodNumberEnd()));
        if (altPeriod == null) {
            altPeriod = new ArrayList();
        } else {
            altPeriod.clear();
        }
        altPeriod = ReportGeneralLedgerUI.getPeriods(glCondition.getPeriodYearStart(), glCondition.getPeriodYearEnd());
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"company", (Object)company);
        ReportBaseUI.fetchCompany((Map)uiContext);
        uiContext.put((Object)"QueryByOther", (Object)Boolean.TRUE);
        if (!company.isIsBizUnit() && glCondition.getExpandInfo().get("companyIds") == null) {
            ReportGeneralLedgerUI.setTreeModelOfCompany(glCondition, company);
        }
        IUIWindow uiWindow = ReportGeneralLedgerUI.getUI(owner, ReportGeneralLedgerUI.class.getName(), (Map)uiContext);
        ReportGeneralLedgerUI ui = (ReportGeneralLedgerUI)uiWindow.getUIObject();
        ui.setQueryByOther(true);
        ui.setCondition(currentCondition);
        if (!company.isIsBizUnit()) {
            ui.queryVirtualData(true);
        } else {
            ui.getTable().removeRows();
        }
        Map mm = glCondition.toMap();
        for (Object k : mm.keySet()) {
        }
        ui.btnFilter.setVisible(false);
        ui.menuItemFilter.setVisible(false);
        ui.setTitlePeriodName(ui.getPeriodTitle(glCondition.getPeriodYearStart(), glCondition.getPeriodNumberStart(), glCondition.getPeriodYearEnd(), glCondition.getPeriodNumberEnd()));
        ui.setTitleCurrencyName(glCondition.getCurrencyName());
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPeriodExtraRes", (String)"PREPERIOD"));
        sb.append(ui.getTitlePeriodName());
        ui.lblPeriod.setText(sb.toString());
        StringBuffer sb1 = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPeriodExtraRes", (String)"PRECURRENCY"));
        sb1.append(ui.getTitleCurrencyName());
        ui.lblCurrency.setText(sb1.toString());
        uiWindow.show();
        if (!ui.getTable().getBody().getRows().isEmpty()) {
            ui.getTable().getSelectManager().select(0, 0);
        }
    }

    public static String getPermItem() {
        return "gl_generalLedger_view";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_generalLedger_export";
    }

    private static void reQueryPeriodRange(CompanyOrgUnitInfo company, ReportConditionBase glCondition) throws Exception {
        if (company.isIsBizUnit()) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            if (glCondition.getPeriodYearStart() * 100 + glCondition.getPeriodNumberStart() < startPeriod.getNumber()) {
                glCondition.setPeriodYearStart(startPeriod.getPeriodYear());
                glCondition.setPeriodNumberStart(startPeriod.getPeriodNumber());
            }
            if (glCondition.getPeriodYearEnd() * 100 + glCondition.getPeriodNumberEnd() < startPeriod.getNumber()) {
                glCondition.setPeriodYearEnd(startPeriod.getPeriodYear());
                glCondition.setPeriodNumberEnd(startPeriod.getPeriodNumber());
            }
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb != null && this.condition != null) {
            int top = sb.getTop();
            IRow row = this.getTable().getRow(top);
            if (row == null || !this.canBeJoinQuery(top)) {
                this.setJoinActionEnable(false);
                return;
            }
            this.actionSubsidiaryLedger.setEnabled(this.canJoinQuery());
            ReportLineKey lineKey = (ReportLineKey)row.getUserObject();
            if (lineKey == null || "xiaojiID".equals(lineKey.getStrCurrencyId())) {
                this.actionAssistGeneralLedger.setEnabled(false);
            } else {
                this.actionAssistGeneralLedger.setEnabled(this.canJoinQuery() && lineKey.isAccountLeaf() && this.isAccountHasAssist(lineKey));
            }
        }
    }

    private boolean isAccountHasAssist(ReportLineKey lineKey) throws EASBizException, BOSException {
        ReportConditionBase glCondition;
        if (lineKey.isAccountHasAssist()) {
            return true;
        }
        EntityViewInfo currentCondition = this.getCondition();
        if (currentCondition != null && (glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition")) != null) {
            int periodStart = glCondition.getPeriodYearStart() * 100 + glCondition.getPeriodNumberStart();
            int periodEnd = glCondition.getPeriodYearEnd() * 100 + glCondition.getPeriodNumberEnd();
            Set caaIds = AccountFacadeFactory.getRemoteInstance().getCAAIdsByPeriodRange(lineKey.getStrAccountID(), periodStart, periodEnd);
            if (caaIds.size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void tblMainGroup_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.tblMain_tableSelectChanged(e);
    }

    private boolean canBeJoinQuery(int rowIndex) {
        if (this.getCurrentCompany() == null) {
            return false;
        }
        if (this.getCurrentCompany().isIsBizUnit()) {
            return true;
        }
        String companyId = this.getCompanyIdByRow(rowIndex);
        EntityViewInfo evi = this.getCondition();
        ReportConditionGeneralLedger rc = (ReportConditionGeneralLedger)evi.get("GLFixCondition");
        if (rc.getTreeModelOfCompany() == null) {
            Object companyIds = rc.getExpandInfo().get("companyIds");
            if (!(companyIds instanceof Set)) {
                return false;
            }
            DefaultKingdeeTreeNode root = GlUtils.getTreeModeOfCompany(null, SysContext.getSysContext().getCurrentFIUnit(), (Set)companyIds);
            rc.setTreeModelOfCompany(root);
        }
        return this.isLeafCompany((DefaultMutableTreeNode)rc.getTreeModelOfCompany(), companyId);
    }

    private boolean isLeafCompany(DefaultMutableTreeNode node, String companyId) {
        SimpleCompanyUserObject company = (SimpleCompanyUserObject)node.getUserObject();
        if (company.getCompanyId().equals(companyId)) {
            return company.isLeaf();
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isLeafCompany((DefaultMutableTreeNode)node.getChildAt(i), companyId)) continue;
            return true;
        }
        return false;
    }

    private void findAssistGeneral() throws Exception {
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb != null && this.condition != null) {
            int top = sb.getTop();
            IRow row = this.getTable().getRow(top);
            ReportLineKey lineKey = (ReportLineKey)row.getUserObject();
            EntityViewInfo currentCondition = this.getCondition();
            if (currentCondition == null) {
                return;
            }
            ReportConditionBase glCondition = (ReportConditionBase)currentCondition.get("GLFixCondition");
            if (glCondition == null) {
                return;
            }
            EntityViewInfo assistCondition = (EntityViewInfo)currentCondition.clone();
            ReportConditionGeneralLedgerAssist fixCondition = new ReportConditionGeneralLedgerAssist((ReportConditionGeneralLedger)glCondition);
            assistCondition.put("GLFixCondition", (Object)fixCondition);
            String strAccountId = lineKey.getStrAccountID();
            if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
                String companyId = this.getCompanyIdByRow(top);
                fixCondition.setCompanyId(companyId);
                HashMap<String, String> ctx = new HashMap<String, String>();
                ctx.put("companyId", companyId);
                CompanyOrgUnitInfo vcompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
                ctx.put("accountTableId", vcompany.getAccountTable().getId().toString());
                ctx.put("accountPeriodTypeId", vcompany.getAccountPeriodType().getId().toString());
                ReportBaseUI.fetchCompany(ctx);
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get("company");
                fixCondition.setAccountId(strAccountId);
                fixCondition.setOptionShowQuantity(fixCondition.isOptionShowQuantity() && lineKey.getAccountIsQty());
                ReportGeneralLedgerAssistUI.queryByCondition(assistCondition, (Object)this, company);
            } else {
                fixCondition.setAccountId(strAccountId);
                Object currObj = row.getCell("FCurrencyID").getValue();
                if (currObj != null && !"xiaojiID".equalsIgnoreCase(currObj.toString())) {
                    fixCondition.setCurrencyID(currObj.toString());
                    fixCondition.setCurrencyName(row.getCell("FCurrencyName").getValue().toString());
                } else if (fixCondition.getCurrencyID() == null || "".equals(fixCondition.getCurrencyID().trim())) {
                    fixCondition.setCurrencyID("AllCurrency");
                }
                fixCondition.setOptionShowQuantity(fixCondition.isOptionShowQuantity() && lineKey.getAccountIsQty());
                ReportGeneralLedgerAssistUI.queryByCondition(assistCondition, (Object)this, (CompanyOrgUnitInfo)this.getUIContext().get("company"));
            }
        }
    }

    @Override
    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    @Override
    public void actionPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ReportGeneralPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getBody().getRows().size() != 0) {
            if (!this.editParame.isChkPrintParame()) {
                super.actionPrint_actionPerformed(e);
            } else if (this.currCompany.isIsBizUnit()) {
                if (this.editParame.isChkPrintAccountContents() && this.invokePrintFuncAccount(e, false) == 2) {
                    return;
                }
                this.invokePrintFunc(e, false);
            } else {
                super.actionPrint_actionPerformed(e);
            }
        } else if (!this.currCompany.isIsBizUnit()) {
            super.actionPrint_actionPerformed(e);
        } else {
            this.showInfoCom();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getBody().getRows().size() != 0) {
            if (!this.editParame.isChkPrintParame()) {
                super.actionPrintPreview_actionPerformed(e);
            } else if (this.currCompany.isIsBizUnit()) {
                if (this.editParame.isChkPrintAccountContents()) {
                    this.invokePrintFuncAccount(e, true);
                }
                this.invokePrintFunc(e, true);
            } else {
                super.actionPrintPreview_actionPerformed(e);
            }
        } else if (!this.currCompany.isIsBizUnit()) {
            super.actionPrintPreview_actionPerformed(e);
        } else {
            this.showInfoCom();
        }
    }

    private void showInfoCom() {
        KDTable tbl = this.getTableForPrintSetting();
        tbl.getPrintManager().getNewPrintManager().getPrinter().prompt(Resources.getMsg((String)"prompt.nocontent"));
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        String strTemplatepathPath = this.editParame.getStrTempletpathPath();
        String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)strTemplatepathPath) || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)this.editParame.getStrTempletpathName())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"notTemplet");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        boolean bBF = this.editParame.isChkBF();
        boolean bPrintByAccount = this.editParame.isChkPrintByAccount();
        String strPeriod = this.lblPeriod.getText().trim();
        String strCurrency = this.lblCurrency.getText().trim();
        int iPer = strPeriod.compareTo(this.getResx("PREPERIOD"));
        String ss = strPeriod.substring(strPeriod.length() - iPer, strPeriod.length());
        int iCur = strCurrency.compareTo(this.getResx("PRECURRENCY"));
        String st = strCurrency.substring(strCurrency.length() - iCur, strCurrency.length());
        if (this.mapInfo == null) {
            this.mapInfo = mapGl;
        }
        this.mapInfo.put("period", ss);
        this.mapInfo.put("currency", st);
        if (this.altPeriods == null) {
            this.altPeriods = (ArrayList)altPeriod.clone();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        ReportGeneralLedgerTaoDa rsprv = new ReportGeneralLedgerTaoDa(this.colTaoda, this.mapInfo, this.strGetColumnName, bBF, bPrintByAccount, this.iScal, this.altPeriods);
        rsprv.setChkFillAccountNumberAndName(this.editParame.isChkFillAccountNumberAndName());
        appHlp.directPrint(strTemplatepathPath, (Object)rsprv, noPreview, (Component)((Object)this));
    }

    protected int invokePrintFuncAccount(ActionEvent evt, boolean noPreview) throws Exception {
        String strTemplateAccountpathPath = this.editParame.getStrTempletAccountpathPath();
        String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)strTemplateAccountpathPath) || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)this.editParame.getStrTempletAccountpathName())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"notTemplet");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        boolean bBF = this.editParame.isChkBF();
        boolean printByAccount = this.editParame.isChkPrintByAccount();
        if (this.mapInfo == null) {
            this.mapInfo = mapGl;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        ReportGeneralLedgerTaoDaAccount rsprv = new ReportGeneralLedgerTaoDaAccount(this.colTaoda, this.mapInfo, this.strGetColumnName, bBF, this.isOptionNoDisplayZeroTotal, printByAccount);
        return appHlp.directPrint(strTemplateAccountpathPath, (Object)rsprv, noPreview, (Component)((Object)this));
    }

    protected static ArrayList getPeriods(int periodYearStart, int periodYearEnd) throws Exception {
        int i;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String strPeriodId = SysContext.getSysContext().getCurrentFIUnit().getAccountPeriodType().getId().toString();
        int periodYear = 0;
        int periodNumber = 0;
        String periodStart = null;
        String periodEnd = null;
        PeriodCollection c = null;
        PeriodCollection pc = null;
        PeriodInfo info = null;
        ArrayList<PeriodCollection> alPeriodCollection = new ArrayList<PeriodCollection>();
        ArrayList<Object[]> alPeriods = new ArrayList<Object[]>();
        Object[] objPeriod = null;
        for (i = periodYearStart; i <= periodYearEnd; ++i) {
            c = ReportGeneralLedgerUI.getPeriodCollection(strPeriodId, i);
            alPeriodCollection.add(c);
        }
        int n = alPeriodCollection.size();
        for (i = 0; i < n; ++i) {
            pc = (PeriodCollection)alPeriodCollection.get(i);
            if (pc == null) continue;
            int m = pc.size();
            for (int j = 0; j < m; ++j) {
                info = pc.get(j);
                objPeriod = new Object[4];
                if (info == null) continue;
                periodYear = info.getPeriodYear();
                periodNumber = info.getPeriodNumber();
                periodStart = GlUtils.formatDate(format, info.getBeginDate());
                periodEnd = GlUtils.formatDate(format, (Date)info.getEndDate());
                objPeriod[0] = new Integer(periodYear);
                objPeriod[1] = new Integer(periodNumber);
                objPeriod[2] = periodStart;
                objPeriod[3] = periodEnd;
                alPeriods.add(objPeriod);
            }
        }
        return alPeriods;
    }

    private static PeriodCollection getPeriodCollection(String strPeriodId, int PeriodYear) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        FilterInfo i = new FilterInfo();
        if (strPeriodId != null) {
            i.getFilterItems().add(new FilterItemInfo("periodType", (Object)strPeriodId, CompareType.EQUALS));
        }
        if (PeriodYear != -1) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear), CompareType.EQUALS));
        } else if (PeriodYear == 0) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)"", CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        evi.getSelector().add(new SelectorItemInfo("CU"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return iPeriod.getPeriodCollection(evi);
    }

    public Object getTablePreferenceSchemaKey() {
        String tableSystleKey = null;
        if (this.getCondition() != null && this.getCondition().get("GLFixCondition") != null) {
            ReportConditionGeneralLedger ledger = (ReportConditionGeneralLedger)this.getCondition().get("GLFixCondition");
            tableSystleKey = ledger.getCurrencyID() == null ? "ALL_CURRENCY" : ("11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(ledger.getCurrencyID()) ? "GENERAL_LOCAL_CURRENCY" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(ledger.getCurrencyID()) ? "GENERAL_REPORT_CURRENCY" : (SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString().equalsIgnoreCase(ledger.getCurrencyID()) ? "COMPANY_BASE_CURRENCY" : "OTHER_CURRENCY")));
            if (ledger.isOptionShowQuantity()) {
                tableSystleKey = tableSystleKey + "_QUANTITY";
            }
        }
        return tableSystleKey;
    }

    @Override
    protected KDTable getTableForCommon() {
        return this.getTable();
    }

    private void findSubsidiaryLedger() throws Exception {
        KDTSelectBlock sb = this.getTable().getSelectManager().get();
        if (sb == null || this.condition == null) {
            return;
        }
        int top = sb.getTop();
        IRow row = this.getTable().getRow(top);
        ReportLineKey lineKey = (ReportLineKey)row.getUserObject();
        String strAccountId = lineKey.getStrAccountID();
        EntityViewInfo currentCondition = this.getCondition();
        if (currentCondition == null) {
            return;
        }
        ReportConditionGeneralLedger glCondition = (ReportConditionGeneralLedger)currentCondition.get("GLFixCondition");
        if (glCondition == null) {
            return;
        }
        GLRptSubLedgerCondition newCondition = new GLRptSubLedgerCondition();
        GLRptUtils.transOldGlConditionToNewCondition(newCondition, glCondition);
        newCondition.setAsstActList(new ArrayList());
        newCondition.setOptionAmountZero(glCondition.isOptionNOTDisplayIfNoAmount() && !glCondition.isOptionNOTDisplayIfZeroNoAmount());
        newCondition.setOptionAmountAndBalZero(glCondition.isOptionNOTDisplayIfZeroNoAmount());
        newCondition.setOptionBalanceZero(glCondition.isOptionNoDisplayZeroTotal());
        newCondition.setNoDisplayZeroTotal(glCondition.isOptionNoDisplayZeroTotal());
        newCondition.setNotIncluePLVoucher(glCondition.isNotIncludePLVoucher());
        IAccountView iacct = AccountViewFactory.getRemoteInstance();
        AccountViewInfo acctInfo = iacct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(lineKey.getStrAccountID()));
        AccountViewInfo[] accts = new AccountViewInfo[]{acctInfo};
        newCondition.setAccountId(strAccountId);
        newCondition.setAccountViewStart(accts);
        newCondition.setAccountViewEnd(accts);
        newCondition.setAccountCodeStart(lineKey.getStrAccountNumber());
        newCondition.setAccountCodeEnd(lineKey.getStrAccountNumber());
        Object currObj = row.getCell("FCurrencyID").getValue();
        if (currObj != null && !"xiaojiID".equalsIgnoreCase(currObj.toString())) {
            newCondition.setCurrencyID(currObj.toString());
            newCondition.setCurrencyName(row.getCell("FCurrencyName").getValue().toString());
        } else if (newCondition.getCurrencyID() == null || "".equals(newCondition.getCurrencyID().trim())) {
            newCondition.setCurrencyID("AllCurrency");
        }
        CompanyOrgUnitInfo company = null;
        String companyId = null;
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            companyId = this.getCompanyIdByRow(top);
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("companyId", companyId);
            CompanyOrgUnitInfo vcompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
            ctx.put("accountTableId", vcompany.getAccountTable().getId().toString());
            ctx.put("accountPeriodTypeId", vcompany.getAccountPeriodType().getId().toString());
            ReportBaseUI.fetchCompany(ctx);
            company = (CompanyOrgUnitInfo)ctx.get("company");
            newCondition.switchCompany(company, true);
            newCondition.setPeriodTypeId(company.getAccountPeriodType().getId().toString());
            newCondition.setAccountTableId(company.getAccountTable().getId().toString());
        } else {
            company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
            newCondition.switchCompany(company, true);
            newCondition.setPeriodTypeId(company.getAccountPeriodType().getId().toString());
            Object accountTableId = glCondition.getExpandInfo().get("accountTableId");
            if (accountTableId != null && accountTableId.toString().trim().length() > 0) {
                newCondition.setAccountTableId(accountTableId.toString());
            } else {
                newCondition.setAccountTableId(company.getAccountTable().getId().toString());
            }
            if (newCondition.getCurrencyID() == null || "".equals(newCondition.getCurrencyID().trim())) {
                newCondition.setCurrencyID("AllCurrency");
            }
        }
        if (!(acctInfo.isIsLeaf() || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)glCondition.getAccountCodeStart()) && com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)glCondition.getAccountCodeEnd()))) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("level"));
            FilterInfo filter = new FilterInfo();
            if (!StringUtils.isEmpty((String)glCondition.getAccountCodeStart())) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)glCondition.getAccountCodeStart(), CompareType.GREATER_EQUALS));
            }
            if (!StringUtils.isEmpty((String)glCondition.getAccountCodeEnd())) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)(glCondition.getAccountCodeEnd() + "zz"), CompareType.LESS));
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctInfo.getNumber(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(acctInfo.getNumber() + "zz"), CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)companyId)) {
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
            }
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
            view.setFilter(filter);
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
            int maxLevel = 1;
            if (!coll.isEmpty()) {
                HashSet<String> accountIdSet = new HashSet<String>();
                for (int j = 0; j < coll.size(); ++j) {
                    AccountViewInfo info = coll.get(j);
                    maxLevel = Math.max(info.getLevel(), maxLevel);
                    accountIdSet.add(info.getId().toString());
                }
                newCondition.setAccountIdSet(accountIdSet);
            }
            newCondition.setAccountLevelStart(1);
            newCondition.setAccountLevelEnd(maxLevel);
        }
        this.joinQurySubLedger(newCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinQurySubLedger(GLRptSubLedgerCondition cond) throws Exception {
        try {
            this.setCursorOfWair();
            String uiClassName = GLRptSubLedgerUI.class.getName();
            UIContext uiCtx = this.getLinkedContext(cond);
            String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            IUIWindow ui = UIFactory.createUIFactory((String)mode).create(uiClassName, (Map)uiCtx, null);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected UIContext getLinkedContext(GLRptSubLedgerCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    private void setLinkedCurrency(GLRptSubLedgerCondition cond) throws Exception {
        if (cond.isAllCurrency()) {
            ReportConditionGeneralLedger condition = ((ReportGeneralLedgerConditionUI)this.getConditionPanel()).getCustomCondition();
            cond.setCurrencyID(condition.getCurrencyID());
            cond.setCurrencyName(condition.getCurrencyName());
        }
    }

    protected void setLinkedPeriod(GLRptSubLedgerCondition cond) throws EASBizException, BOSException {
        IRow row = this.getSelectedTableRow();
        if (row == null) {
            SysUtil.abort();
        }
        ReportLineKey userObject = (ReportLineKey)row.getUserObject();
        cond.setPeriodYearStart(userObject.getPeriodYear());
        cond.setPeriodYearEnd(userObject.getPeriodYear());
        cond.setPeriodNumberStart(userObject.getPeriodNumber());
        cond.setPeriodNumberEnd(userObject.getPeriodNumber());
    }

    private IRow getSelectedTableRow() {
        int rowIndex = this.getTable().getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        return this.getTable().getRow(rowIndex);
    }

    private void setJoinActionEnable(boolean isEnabled) {
        this.actionSubsidiaryLedger.setEnabled(isEnabled);
        this.actionAssistGeneralLedger.setEnabled(isEnabled);
    }
}

