/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionJournal;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.RptCommonFactory;
import com.kingdee.eas.fi.gl.client.AbstractReportJournalConditionUI;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ReportJournalConditionUI
extends AbstractReportJournalConditionUI {
    private static final long serialVersionUID = -6861214499759786894L;
    private static final Logger logger = CoreUIObject.getLogger(ReportJournalConditionUI.class);
    private PeriodInfo startPeriod = null;
    CompanyOrgUnitInfo company = null;
    boolean companyFilterChanged = false;
    String companyIds = null;
    boolean loading = false;
    private boolean tag = true;
    boolean isFromSolu = false;
    boolean isAfterPeriodIncluded = false;
    private PeriodEntity pe;
    private ActionListener cmbCurrencyLs = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportJournalConditionUI.this.beforeActionPerformed(e);
            try {
                ReportJournalConditionUI.this.cmbCurrency_actionPerformed_new(e);
            }
            catch (Exception exc) {
                ReportJournalConditionUI.this.handUIException(exc);
            }
            finally {
                ReportJournalConditionUI.this.afterActionPerformed(e);
            }
        }
    };
    private Map initDataUsingForClear = null;
    CompanyTreeSelectUI ctsUI = null;
    JDialog dialog = null;
    private TreeModel treeModelOfCompany = null;
    private TreeModel treeModelOfCompanyClone = null;

    public ReportJournalConditionUI() throws Exception {
        this.tfCompany.setRequired(true);
        this.tfCompany.setEnabled(true);
        this.tfCompany.setEditable(false);
        this.dateDateBegin.setSupportedEmpty(false);
        this.dateDateEnd.setSupportedEmpty(false);
    }

    @Override
    protected void spnAccountLevelBegin_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnAccountLevelBegin_stateChanged(e);
        Integer numberBegin = (Integer)this.spnAccountLevelBegin.getValue();
        Integer numberEnd = (Integer)this.spnAccountLevelEnd.getValue();
        if (numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        if (numberEnd < numberBegin) {
            this.spnAccountLevelEnd.setValue((Object)numberBegin);
        }
    }

    protected void initListener() {
        super.initListener();
        this.cmbCurrency.addActionListener(this.cmbCurrencyLs);
        this.bpPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (ReportJournalConditionUI.this.company != null) {
                        AccountTableInfo account = (AccountTableInfo)ReportJournalConditionUI.this.bpAccount.getValue();
                        PeriodTypeInfo period = (PeriodTypeInfo)ReportJournalConditionUI.this.bpPeriod.getValue();
                        if (GlUtils.isCompanyUnion(ReportJournalConditionUI.this.company)) {
                            ReportJournalConditionUI.this.treeModelOfCompany = null;
                            ReportJournalConditionUI.this.treeModelOfCompanyClone = null;
                            ReportJournalConditionUI.this.companyFilterChanged = true;
                            ReportJournalConditionUI.this.tfCompany.setText("");
                            ReportJournalConditionUI.this.tfCompany.setToolTipText("");
                        }
                        if (account != null) {
                            ReportJournalConditionUI.this.company.setAccountTable(account);
                        }
                        if (period != null) {
                            ReportJournalConditionUI.this.company.setAccountPeriodType(period);
                        }
                    }
                }
                catch (Exception e) {
                    ReportJournalConditionUI.this.companyFilterChanged = true;
                    ReportJournalConditionUI.this.tfCompany.setText("");
                    ReportJournalConditionUI.this.tfCompany.setToolTipText("");
                    ReportJournalConditionUI.this.btnCompany.setEnabled(false);
                    MsgBox.showInfo((Component)((Object)ReportJournalConditionUI.this), (String)("\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u51fa\u9519\u4e86\uff1a" + e.getMessage()));
                }
            }
        });
    }

    @Override
    protected void spnAccountLevelEnd_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnAccountLevelEnd_stateChanged(e);
        Integer numberBegin = (Integer)this.spnAccountLevelBegin.getValue();
        Integer numberEnd = (Integer)this.spnAccountLevelEnd.getValue();
        if (numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        if (numberBegin > numberEnd) {
            this.spnAccountLevelBegin.setValue((Object)numberEnd);
        }
    }

    public ReportConditionJournal getCustomCondition() {
        Object objectCurrency;
        AccountViewInfo account;
        String strNumber;
        ReportConditionJournal condition = new ReportConditionJournal();
        HashMap<String, RptConditionManager> hm = new HashMap<String, RptConditionManager>();
        RptConditionManager rc = new RptConditionManager();
        rc.recordAllStatus((Container)((Object)this));
        hm.put("RptCondition", rc);
        condition.setExpandInfo(hm);
        if (this.treeModelOfCompany != null) {
            condition.setTreeModelOfCompany(this.treeModelOfCompany.getRoot());
        }
        condition.setExpandCompanyLevel(this.spnCompanyLevel.getIntegerVlaue());
        java.sql.Date dateBegin = this.dateDateBegin.getSqlDate();
        java.sql.Date dateEnd = this.dateDateEnd.getSqlDate();
        condition.setDateBegin(dateBegin);
        condition.setDateEnd(dateEnd);
        condition.setAccountLevelStart((Integer)this.spnAccountLevelBegin.getValue());
        condition.setAccountLevelEnd((Integer)this.spnAccountLevelEnd.getValue());
        condition.setAccountCodeStart(null);
        Object object = this.prbAccountBegin.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeStart(strNumber.trim());
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeStart(account.getNumber());
            }
        }
        condition.setAccountCodeEnd(null);
        object = this.prbAccountEnd.getValue();
        if (object != null) {
            if (object instanceof String && !(strNumber = (String)object).trim().equals("")) {
                condition.setAccountCodeEnd(strNumber.trim());
            }
            if (object instanceof AccountViewInfo) {
                account = (AccountViewInfo)object;
                condition.setAccountCodeEnd(account.getNumber());
            }
        }
        if ((objectCurrency = this.cmbCurrency.getSelectedItem()) != null) {
            if (objectCurrency instanceof CurrencyInfo) {
                CurrencyInfo currency = (CurrencyInfo)objectCurrency;
                condition.setCurrencyID(currency.getId().toString());
            } else if (GLResUtil.getRes("all_currency").equals((String)objectCurrency)) {
                condition.setCurrencyID("AllCurrency");
                condition.setCurrencyName((String)objectCurrency);
            } else {
                condition.setCurrencyID(null);
                condition.setCurrencyName((String)objectCurrency);
            }
            condition.setCurrencyName(objectCurrency.toString());
        }
        condition.getExpandInfo().put("company", this.company);
        if (this.bpAccount.getValue() != null && this.bpAccount.getValue() instanceof AccountTableInfo) {
            condition.getExpandInfo().put("accountTableId", ((AccountTableInfo)this.bpAccount.getValue()).getId().toString());
        }
        condition.setOptionPosting(this.chkIncludeNotPosting.isSelected());
        condition.setOptionNOTDisplayIfNoAmount(this.chkIncludeNoAmount.isSelected());
        condition.setOptionNOTDisplayIfBalanceZero(this.chkBalanceZero.isSelected());
        condition.setOptionShowTotal(this.chkIncludeTotal.isSelected());
        condition.setOptionShowAsstItem(this.chkShowAsstItem.isSelected());
        condition.setFillInfo(this.chkFillInfo.isSelected());
        return condition;
    }

    protected void setInitData(Map initData) throws EASBizException, BOSException {
        CurrencyInfo defaultCurrency;
        Boolean usingForeignCurrencyInUse;
        Boolean foreignCurrencyInUse;
        this.initDataUsingForClear = initData;
        this.loading = true;
        boolean bForeignCurrencyInUse = false;
        boolean bUsingForeignCurrency = false;
        this.company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        try {
            RptClientUtil.fullCompanyInfo(this.company);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tfCompany.setText(this.company.getName());
        this.tfCompany.setToolTipText(this.company.getName());
        if (!GlUtils.isCompanyUnion(this.company)) {
            int yearEnd = ((Date)this.dateDateEnd.getValue()).getYear() + 1900;
            int numberEnd = ((Date)this.dateDateEnd.getValue()).getMonth() + 1;
            RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.prbAccountBegin, this.prbAccountEnd);
            this.bpAccount.setValue((Object)this.company.getAccountTable());
            this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        }
        if ((foreignCurrencyInUse = (Boolean)initData.get("ParmForeignCurrencyIsUse")) != null) {
            bForeignCurrencyInUse = foreignCurrencyInUse;
        }
        if ((usingForeignCurrencyInUse = (Boolean)initData.get("ParmUsingReportingCurrency")) != null) {
            bUsingForeignCurrency = usingForeignCurrencyInUse;
        }
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.startPeriod = (PeriodInfo)initData.get("StartPeriod");
            this.dateDateBegin.setMinimumDate(this.startPeriod.getBeginDate());
            this.dateDateEnd.setMinimumDate(this.startPeriod.getBeginDate());
        }
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(currentTime);
        Date currentDate = calendar.getTime();
        if (this.startPeriod != null && currentDate.before(this.startPeriod.getBeginDate())) {
            currentDate = this.startPeriod.getBeginDate();
        }
        this.dateDateBegin.setValue((Object)currentDate);
        this.dateDateEnd.setValue((Object)currentDate);
        if (GlUtils.isCompanyUnion(this.company)) {
            this.btnCompany.setEnabled(true);
            this.btnCompany.setVisible(true);
            this.tfCompany.setEnabled(true);
            this.btnCompany.setEnabled(false);
            this.bpPeriod.setEnabled(true);
        } else {
            this.btnCompany.setEnabled(false);
            this.btnCompany.setVisible(false);
            this.tfCompany.setEnabled(false);
            this.tfCompany.setEditable(false);
            this.bpPeriod.setEnabled(false);
        }
        Integer maxLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelModelBegin = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevelBegin.setModel((SpinnerModel)levelModelBegin);
            SpinnerNumberModel levelModelEnd = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevelEnd.setModel((SpinnerModel)levelModelEnd);
            SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
        }
        CurrencyCollection currencyCollection = (CurrencyCollection)initData.get("AllCurrency");
        String strAllCurrencyMultiColumn = this.getResx("AllCurrenyMultiColumn");
        if (currencyCollection != null) {
            this.cmbCurrency.removeAllItems();
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) && !currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
                    this.cmbCurrency.addItem((Object)currencyCollection.get(i));
                }
                if (currency != null && currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID)) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) continue;
                generalRptCurrency = currency;
            }
            if (!bForeignCurrencyInUse) {
                if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem((Object)generalLocalCurrency);
                }
                if (bUsingForeignCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                    this.cmbCurrency.addItem((Object)generalRptCurrency);
                }
            }
            this.cmbCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        }
        if ((defaultCurrency = (CurrencyInfo)initData.get("DefaultCurrency")) != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)defaultCurrency);
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, filter, false, false);
        SpinnerNumberModel companyLevelModel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spnCompanyLevel.setModel((SpinnerModel)companyLevelModel);
        this.spnCompanyLevel.setEnabled(false);
        AccountTableInfo ati = (AccountTableInfo)this.bpAccount.getValue();
        if (ati == null) {
            ati = company.getAccountTable();
        }
        apb = new AccountPromptBox((IUIObject)this, ati, filter, false);
        this.prbAccountBegin.setEditable(true);
        this.prbAccountBegin.setEditFormat("$number$");
        this.prbAccountBegin.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountBegin.setCommitParser((IParser)new AccountViewParser(this.prbAccountBegin));
        this.prbAccountBegin.setSelector((KDPromptSelector)apb);
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setEditFormat("$number$");
        this.prbAccountEnd.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountEnd.setCommitParser((IParser)new AccountViewParser(this.prbAccountEnd));
        this.prbAccountEnd.setSelector((KDPromptSelector)apb);
        this.prbAccountEnd.setValue(null);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.prbAccountBegin.setEntityViewInfo(myevi);
        this.prbAccountEnd.setEntityViewInfo(myevi);
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection fic2 = filter2.getFilterItems();
        EntityViewInfo myevi2 = new EntityViewInfo();
        myevi2.setFilter(filter2);
        this.bpAccount.setEntityViewInfo(myevi2);
        fic2.add(new FilterItemInfo("destcompany.id", (Object)company.getId().toString()));
        this.bpAccount.setEditable(true);
        this.bpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountTableQuery");
        this.bpAccount.setEditFormat("$number$");
        this.bpAccount.setCommitFormat("$number$");
        this.bpAccount.setDisplayFormat("$number$ - $name$");
        DataChangeListener dcl = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ReportJournalConditionUI.this.fireFiltersChanged(eventObj);
                }
                catch (Exception e) {
                    ReportJournalConditionUI.this.companyFilterChanged = true;
                    ReportJournalConditionUI.this.btnCompany.setEnabled(false);
                    MsgBox.showInfo((Component)((Object)ReportJournalConditionUI.this), (String)e.getMessage());
                }
            }
        };
        this.bpAccount.addDataChangeListener(dcl);
        if (GlUtils.isCompanyUnion(company)) {
            try {
                RptClientUtil.setDefaultAccount(company, this.bpAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bpPeriod.setEditable(true);
        this.bpPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodTypeQuery");
        this.bpPeriod.setEditFormat("$number$");
        this.bpPeriod.setCommitFormat("$number$");
        this.bpPeriod.setDisplayFormat("$number$ - $name$");
        this.loading = false;
        try {
            this.dateDateEnd_dataChanged(null);
            if (GlUtils.isCompanyUnion(company)) {
                RptClientUtil.setDefaultAccountPeriod(company, this.bpPeriod, this.bpAccount);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void prbAccountEnd_dataChanged(DataChangeEvent e) throws Exception {
        String strAccountNumber;
        String[] accountValue;
        if (!this.getTag()) {
            return;
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)company);
        BOSUuid companyId = company.getId();
        AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getValue();
        if (accountTable == null) {
            return;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ObjectUuidPK accountTablePK = new ObjectUuidPK(accountTable.getId());
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom instanceof String && accountTo instanceof String) {
            return;
        }
        int i = 1;
        int j = 1;
        if (accountFrom != null) {
            if (accountFrom instanceof AccountViewInfo) {
                i = ((AccountViewInfo)accountFrom).getLevel();
            } else {
                accountValue = accountFrom.toString().split(" ");
                strAccountNumber = accountValue[0];
                i = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
            }
        }
        if (accountTo != null) {
            if (accountTo instanceof AccountViewInfo) {
                j = ((AccountViewInfo)accountTo).getLevel();
            } else {
                accountValue = accountTo.toString().split(" ");
                strAccountNumber = accountValue[0];
                j = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
            }
        }
        this.spnAccountLevelBegin.setValue((Object)Math.min(i, j));
        this.spnAccountLevelEnd.setValue((Object)Math.max(i, j));
    }

    @Override
    protected void prbAccountBegin_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            this.prbAccountEnd.setValue(accountFrom);
        } else {
            this.prbAccountEnd_dataChanged(e);
        }
    }

    private String getResx(String resxItemName) {
        String resxName = this.getResourceName();
        return EASResource.getString((String)resxName, (String)resxItemName);
    }

    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportJournalUI";
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                param = RptFilterUtils.toObjectFromRptFilterMap((Object)param);
            }
            this.setCustomCondition(new ReportConditionJournal((Map)param));
        }
        catch (CloneNotSupportedException ex) {
            this.handUIException(ex);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getCustomCondition().toMap()));
        return cp;
    }

    public void setCustomCondition(ReportConditionJournal condition) {
        if (condition == null) {
            return;
        }
        this.setTag(false);
        Map hm = condition.getExpandInfo();
        RptConditionManager rc = (RptConditionManager)hm.get("RptCondition");
        if (rc != null) {
            rc.restoreAllStatus((Container)((Object)this));
        }
        if (this.bpAccount.getValue() != null) {
            try {
                this.bpAccount.setValue((Object)AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(AccessHelper.getId((Object)this.bpAccount.getValue()))));
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.bpAccount.setEnabled(true);
        if (GlUtils.isCompanyUnion(this.company)) {
            if (condition.getTreeModelOfCompany() != null) {
                this.treeModelOfCompany = new DefaultTreeModel((TreeNode)this.transLan(condition.getTreeModelOfCompany()));
                this.companyChanged(this.treeModelOfCompany);
            }
            this.btnCompany.setEnabled(true);
        } else {
            String textComp = "";
            try {
                textComp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString())).getName();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.tfCompany.setText(textComp);
            this.tfCompany.setToolTipText(textComp);
        }
        this.dateDateBegin.setValue((Object)condition.getDateBegin());
        this.dateDateEnd.setValue((Object)condition.getDateEnd());
        this.spnAccountLevelBegin.setValue((Object)new Integer(condition.getAccountLevelStart()));
        this.spnAccountLevelEnd.setValue((Object)new Integer(condition.getAccountLevelEnd()));
        this.prbAccountBegin.setValue((Object)condition.getAccountCodeStart());
        this.prbAccountEnd.setValue((Object)condition.getAccountCodeEnd());
        String currencyId = condition.getCurrencyID();
        if (currencyId == null || currencyId.trim().length() == 0 || currencyId.equals("AllCurrency")) {
            this.cmbCurrency.setSelectedItem((Object)GLResUtil.getRes("all_currency"));
        } else {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo;
                Object object = this.cmbCurrency.getItemAt(i);
                if (!(object instanceof CurrencyInfo) || (currencyInfo = (CurrencyInfo)object) == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                this.cmbCurrency.removeActionListener(this.cmbCurrencyLs);
                this.cmbCurrency.setSelectedIndex(i);
                this.cmbCurrency.addActionListener(this.cmbCurrencyLs);
                break;
            }
        }
        this.spnCompanyLevel.setValue((Object)condition.getExpandCompanyLevel());
        this.chkIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkIncludeNoAmount.setSelected(condition.isOptionNOTDisplayIfNoAmount());
        this.chkBalanceZero.setSelected(condition.isOptionNOTDisplayIfBalanceZero());
        this.chkIncludeTotal.setSelected(condition.isOptionShowTotal());
        this.chkShowAsstItem.setSelected(condition.isOptionShowAsstItem());
        this.companyFilterChanged = false;
        this.isFromSolu = true;
        this.chkFillInfo.setSelected(condition.isFillInfo());
        this.setTag(true);
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        list.add("CurrentCompany");
        return list;
    }

    public Component getFocusComponent() {
        return this.dateDateBegin.getEditor().getEditorComponent();
    }

    public boolean verify() {
        if (this.bpAccount.getValue() == null) {
            this.bpAccount.requestFocus();
            MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
            return false;
        }
        if (GlUtils.isCompanyUnion(this.company)) {
            if (this.bpPeriod.getValue() == null) {
                this.bpPeriod.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
                return false;
            }
            if (this.treeModelOfCompany == null || this.companyFilterChanged) {
                this.btnCompany.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
                return false;
            }
            try {
                this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            try {
                if (!ReportJournalConditionUI.hasPhysicalCompany(this.treeModelOfCompany)) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                    return false;
                }
                java.sql.Date dateEnd = this.dateDateEnd.getSqlDate();
                int numberEnd = dateEnd.getMonth();
                int yearEnd = dateEnd.getYear();
                this.isAfterPeriodIncluded = RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
                if (this.treeModelOfCompany.getChildCount(this.treeModelOfCompany.getRoot()) <= 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("company_cant_null"));
                    return false;
                }
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                return false;
            }
            catch (Exception e) {
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                return false;
            }
        }
        java.sql.Date dateBegin = this.dateDateBegin.getSqlDate();
        java.sql.Date dateEnd = this.dateDateEnd.getSqlDate();
        Window window = UICommonUtils.getWindow((Component)((Object)this));
        String strError = this.getResx("BEINGAFTEREND");
        String strStartPeriodError = this.getResx("BEINGAFTERSTART");
        String strErrorTitle = this.getResx("ERRORTITLE");
        if (this.startPeriod != null && dateBegin.before(this.startPeriod.getBeginDate())) {
            KDOptionPane.showMessageDialog((Component)window, (Object)strStartPeriodError, (String)strErrorTitle, (int)0);
            return false;
        }
        if (dateBegin.after(dateEnd)) {
            KDOptionPane.showMessageDialog((Component)window, (Object)strError, (String)strErrorTitle, (int)0);
            return false;
        }
        return true;
    }

    @Override
    protected void dateDateBegin_dataChanged(DataChangeEvent e) throws Exception {
        java.sql.Date dateBegin = this.dateDateBegin.getSqlDate();
        java.sql.Date dateEnd = this.dateDateEnd.getSqlDate();
        if (this.startPeriod != null && dateBegin.before(this.startPeriod.getBeginDate())) {
            this.dateDateBegin.setValue((Object)this.startPeriod.getBeginDate());
            dateBegin = this.dateDateBegin.getSqlDate();
        }
        if (dateBegin.after(dateEnd)) {
            this.dateDateEnd.setValue((Object)dateBegin);
        }
    }

    @Override
    protected void dateDateEnd_dataChanged(DataChangeEvent e) throws Exception {
        java.sql.Date dateBegin = this.dateDateBegin.getSqlDate();
        java.sql.Date dateEnd = this.dateDateEnd.getSqlDate();
        if (this.startPeriod != null && dateEnd.before(this.startPeriod.getBeginDate())) {
            this.dateDateEnd.setValue((Object)this.startPeriod.getBeginDate());
            dateEnd = this.dateDateEnd.getSqlDate();
        }
        if (dateEnd.before(dateBegin)) {
            this.dateDateBegin.setValue((Object)dateEnd);
        }
        if (e != null && e.getOldValue() instanceof Date && e.getNewValue() instanceof Date) {
            Date oldDate = (Date)e.getOldValue();
            Date newDate = (Date)e.getNewValue();
            if (oldDate.getYear() != newDate.getYear()) {
                int yearEnd = ((Date)this.dateDateEnd.getValue()).getYear() + 1900;
                int numberEnd = ((Date)this.dateDateEnd.getValue()).getMonth() + 1;
                RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.prbAccountBegin, this.prbAccountEnd);
                this.bpAccount.setValue((Object)this.company.getAccountTable());
            }
        }
    }

    public boolean getTag() {
        return this.tag;
    }

    public void setTag(boolean tag) {
        this.tag = tag;
    }

    @Override
    protected void cmbCurrency_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void cmbCurrency_actionPerformed_new(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo && GlUtils.isCompanyUnion(this.company) && (currencyInfo = (CurrencyInfo)objectCurrency).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
        if (objectCurrency != null && objectCurrency.equals(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"113_ReportJournalConditionUI"))) {
            this.chkIncludeTotal.setEnabled(false);
            this.chkIncludeTotal.setSelected(false);
        } else {
            this.chkIncludeTotal.setEnabled(true);
        }
    }

    public void clear() {
        super.clear();
        try {
            this.setInitData(this.initDataUsingForClear);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        this.chkIncludeNotPosting.setSelected(false);
        this.chkIncludeNoAmount.setSelected(false);
        this.chkBalanceZero.setSelected(false);
        this.chkIncludeTotal.setSelected(false);
        this.chkShowAsstItem.setSelected(false);
        this.chkFillInfo.setSelected(false);
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        Object objectCurrency;
        AccountTableInfo account;
        if (this.ctsUI == null) {
            this.dialog = new JDialog(InitClientHelp.getFrameAncestor((Component)((Object)this)), true);
            this.ctsUI = new CompanyTreeSelectUI(this.company);
            this.ctsUI.initListener();
            this.ctsUI.setDialog(this.dialog);
            this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
            this.dialog.setSize(640, 480);
            InitClientHelp.centerWindow(this.dialog);
            this.dialog.setResizable(false);
            this.dialog.setTitle(this.ctsUI.getUITitle());
            account = (AccountTableInfo)this.bpAccount.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(this.company.getAccountPeriodType().getId().toString());
            this.ctsUI.setBooksModel();
            this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("companyChanged")) {
                        ReportJournalConditionUI.this.companyChanged(evt.getNewValue());
                    }
                }
            });
        }
        if (this.companyFilterChanged || this.treeModelOfCompany == null || this.isFromSolu) {
            account = (AccountTableInfo)this.bpAccount.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(this.company.getAccountPeriodType().getId().toString());
            this.ctsUI.setBooksModel();
            this.companyFilterChanged = false;
        }
        if ((objectCurrency = this.cmbCurrency.getSelectedItem()) instanceof CurrencyInfo && ((CurrencyInfo)objectCurrency).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportJournalConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
        } else {
            this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportJournalConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
        }
        this.isFromSolu = false;
        this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
        this.dialog.setVisible(true);
    }

    protected void companyChanged(Object object) {
        Object objectnew = null;
        try {
            objectnew = ObjectUtils.createCopy((Object)object);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
        this.treeModelOfCompany = (TreeModel)object;
        this.treeModelOfCompanyClone = (TreeModel)objectnew;
        try {
            PeriodInfo minPeriodInfo;
            String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
            this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
            this.company.setDescription(this.companyIds);
            this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            int minYear = this.pe.getUsedPeriod().getMinYear();
            int minPeriod = this.pe.getUsedPeriod().getMinPeriod(minYear);
            this.startPeriod = minPeriodInfo = this.getPeriod(minYear, minPeriod);
            this.tfCompany.setText(info);
            this.tfCompany.setToolTipText(info);
            int maxCompanyLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany);
            if (maxCompanyLevel > 0) {
                this.spnCompanyLevel.setEnabled(true);
                SpinnerNumberModel companyLevelModel = new SpinnerNumberModel(1, 1, ++maxCompanyLevel, 1);
                this.spnCompanyLevel.setModel((SpinnerModel)companyLevelModel);
            } else {
                this.spnCompanyLevel.setEnabled(false);
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
    }

    private Object transLan(Object object) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        Set ids = this.getCompanyIds(node);
        this.doTrans(ids, (DefaultMutableTreeNode)object);
        return object;
    }

    private Set getCompanyIds(DefaultMutableTreeNode node) {
        HashSet<String> ids = new HashSet<String>();
        this.getCompanyIdsLoop(node, ids);
        ids.add(((SimpleCompanyUserObject)node.getUserObject()).getCompanyId());
        return ids;
    }

    private void getCompanyIdsLoop(DefaultMutableTreeNode root, Set ids) {
        if (root == null) {
            return;
        }
        SimpleCompanyUserObject simplyComp = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            simplyComp = (SimpleCompanyUserObject)node.getUserObject();
            ids.add(simplyComp.getCompanyId());
            this.getCompanyIdsLoop(node, ids);
        }
    }

    private void doTrans(Set ids, DefaultMutableTreeNode object) {
        Map hm = this.getCompanyNameMap(ids);
        this.setNodeName(object, hm);
    }

    private Map getCompanyNameMap(Set ids) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evi.setFilter(f);
        CompanyOrgUnitCollection comCol = null;
        try {
            comCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        if (comCol != null && comCol.size() > 0) {
            for (int i = 0; i < comCol.size(); ++i) {
                CompanyOrgUnitInfo companyOrgUnitInfo = comCol.get(i);
                hm.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo.getName());
            }
        }
        return hm;
    }

    private void setNodeName(DefaultMutableTreeNode root, Map hm) {
        this.setNodeNameLoop(root, hm);
        SimpleCompanyUserObject simplyComp = (SimpleCompanyUserObject)root.getUserObject();
        ((SimpleCompanyUserObject)root.getUserObject()).setName((String)hm.get(simplyComp.getCompanyId()));
    }

    private void setNodeNameLoop(DefaultMutableTreeNode root, Map hm) {
        if (root == null) {
            return;
        }
        SimpleCompanyUserObject simplyComp = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            simplyComp = (SimpleCompanyUserObject)node.getUserObject();
            ((SimpleCompanyUserObject)node.getUserObject()).setName((String)hm.get(simplyComp.getCompanyId()));
            this.setNodeNameLoop(node, hm);
        }
    }

    private void fireFiltersChanged(DataChangeEvent eventObj) throws Exception {
        if (this.company == null || eventObj.getNewValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        boolean b = account != null && period != null;
        this.btnCompany.setEnabled(b);
        this.prbAccountBegin.setEnabled(account != null);
        this.prbAccountEnd.setEnabled(account != null);
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        this.spnAccountLevelBegin.setEnabled(account != null);
        this.spnAccountLevelEnd.setEnabled(account != null);
        if (GlUtils.isCompanyUnion(this.company)) {
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
            this.companyFilterChanged = true;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
        if (account != null) {
            this.company.setAccountTable(account);
        }
        if (period != null) {
            this.company.setAccountPeriodType(period);
        }
        if (eventObj.getSource() == this.bpAccount && account != null) {
            FilterInfo fi = this.prbAccountBegin.getEntityViewInfo().getFilter();
            if (fi.getFilterItems().size() == 1) {
                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            } else {
                fi.getFilterItems().set(1, new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
            }
            fi.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            fi.setMaskString("#0 and #1 and #2");
            this.prbAccountBegin.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
            this.prbAccountEnd.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, account, fi, false));
            try {
                Integer maxLevel = (Integer)RptCommonFactory.getRemoteInstance().invoke("getMaxGroupControlAccountLevel", new String[]{account.getId().toString(), this.company.getCU().getId().toString()});
                SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    public static boolean hasPhysicalCompany(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        if (node.getChildCount() <= 0) {
            return false;
        }
        StringBuffer result = new StringBuffer("(");
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append("'").append(userObject.getCompanyId()).append("',");
        }
        result.replace(result.length() - 1, result.length(), ")");
        Boolean bb = (Boolean)RptCommonFactory.getRemoteInstance().invoke("hasPhysicalCompany", result.toString());
        return bb;
    }

    private PeriodInfo getPeriod(int periodYear, int periodNumber) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 ");
        evi.setFilter(filter);
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        PeriodInfo info = null;
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }
}

