/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLReportJournalFacadeFactory;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.ReportConditionJournal;
import com.kingdee.eas.fi.gl.ReportLineKey;
import com.kingdee.eas.fi.gl.client.AbstractReportJournalUI;
import com.kingdee.eas.fi.gl.client.ReportJournalConditionUI;
import com.kingdee.eas.fi.gl.client.ReportJournalParame;
import com.kingdee.eas.fi.gl.client.ReportJournalTaoda;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ReportJournalUI
extends AbstractReportJournalUI {
    CommonQueryDialog conditionDialog = null;
    ReportJournalConditionUI conditionPanel = null;
    private String periodRangeText = null;
    ReportJournalParame editParame = null;

    public ReportJournalUI() throws Exception {
        this.setPreferredSize(new Dimension(800, 600));
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initMenuItemButton();
        this.tblMain.checkParsed();
        this.menuItemPrintParame.setEnabled(true);
        this.editParame = ReportJournalParame.getInstance();
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintView.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemPrintParame.setVisible(false);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintView);
        this.menuFile.add((JMenuItem)this.menuItemPrintParame);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuTool.add((JMenuItem)this.menuItemCalculator);
        this.menuView.add((JMenuItem)this.menuItemFilter);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    private void initMenuItemButton() {
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected Collection getInitList() {
        Collection list = ReportJournalConditionUI.getInitDataItem();
        list.add("DefaultTableHead");
        list.add("ParmForeignCurrencyIsUse");
        list.add("ParmUsingReportingCurrency");
        list.add("StartPeriod");
        list.add("CurrentCompany");
        list.add("ParmGroupPattern");
        return list;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return GLReportJournalFacadeFactory.getRemoteInstance();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ReportJournalConditionUI();
            this.conditionPanel.setInitData(this.getInitData());
        }
        return this.conditionPanel;
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        ReportConditionJournal condition = ((ReportJournalConditionUI)this.getConditionPanel()).getCustomCondition();
        mainQuery.put("GLFixCondition", (Object)condition);
        int yearEnd = condition.getDateEnd().getYear() + 1900;
        int numberEnd = condition.getDateEnd().getMonth() + 1;
        if (!this.getCurrentCompany().isIsBizUnit()) {
            this.getUIContext().put("company", condition.getExpandInfo().get("company"));
        } else {
            this.getUIContext().put("company", RptClientUtil.getCompany(yearEnd, numberEnd));
        }
        this.setCondition(mainQuery);
        this.setReportExtraTitle(condition);
        if (this.getCurrentCompany() != null && !this.getCurrentCompany().isIsBizUnit()) {
            this.queryVirtualData(true);
        } else {
            this.tblMain.removeRows();
        }
    }

    public void setReportExtraTitle(ReportConditionJournal condition) {
        if (condition == null) {
            return;
        }
        String strDate = this.getResx("DATERANGE");
        String strDateBegin = this.getResx("DATEBEGIN");
        String strDateSeperator = this.getResx("DATESEPERATOR");
        String strPreCurrency = this.getResx("PRECURRENCY");
        Date dateBegin = condition.getDateBegin();
        Date dateEnd = condition.getDateEnd();
        SimpleDateFormat longFormat = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
        String strFormatDateBegin = longFormat.format(dateBegin);
        String strFormatDateEnd = longFormat.format(dateEnd);
        this.periodRangeText = strDateBegin + strFormatDateBegin + strDateSeperator + strFormatDateEnd;
        this.lblPeriod.setText(strDate + " " + this.periodRangeText);
        this.lblCurrency.setText(strPreCurrency + condition.getCurrencyName());
    }

    private String getResx(String resxItemName) {
        String resxName = "com.kingdee.eas.fi.gl.ReportDateExtraRes";
        return EASResource.getString((String)resxName, (String)resxItemName);
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return true;
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    public String getResourceName() {
        return "com.kingdee.eas.fi.gl.ReportJournalUI";
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(530);
            this.conditionDialog.setHeight(370);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            this.conditionDialog.setMaxReturnCountVisible(false);
            this.conditionDialog.setOnlyShowInCurrentOrg(true);
        }
        return this.conditionDialog;
    }

    @Override
    protected Variant tableRequestPrintDataOther(String varName) {
        if (varName.equals("DateRange")) {
            String strDateBegin = this.getResx("DATEBEGIN");
            String strDateSeperator = this.getResx("DATESEPERATOR");
            String strPreCurrency = this.getResx("PRECURRENCY");
            ReportConditionJournal condition = (ReportConditionJournal)this.getCondition().get("GLFixCondition");
            Date dateBegin = condition.getDateBegin();
            Date dateEnd = condition.getDateEnd();
            DateFormat longFormat = DateFormat.getDateInstance(1, this.getLocale());
            String strFormatDateBegin = longFormat.format(dateBegin);
            String strFormatDateEnd = longFormat.format(dateEnd);
            String txtPeriod = null;
            txtPeriod = dateBegin.equals(dateEnd) ? strFormatDateBegin : strDateBegin + strFormatDateBegin + strDateSeperator + strFormatDateEnd;
            Variant v = new Variant();
            v.setObject((Object)(txtPeriod == null ? "" : txtPeriod));
            return v;
        }
        if ("Period".equals(varName)) {
            Variant v = new Variant();
            v.setObject((Object)this.periodRangeText);
            return v;
        }
        return super.tableRequestPrintDataOther(varName);
    }

    @Override
    public void actionMenuItemPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ReportJournalPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        KDNoteHelper appHlp = new KDNoteHelper();
        ReportJournalTaoda rsprv = new ReportJournalTaoda();
        if (noPreview) {
            appHlp.print("/FI/GL/Account/ReportGeneralLedger", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/GL/Account/ReportGeneralLedger", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public Object getTablePreferenceSchemaKey() {
        String tableSystleKey = null;
        if (this.getCondition() != null && this.getCondition().get("GLFixCondition") != null) {
            ReportConditionJournal ledger = (ReportConditionJournal)this.getCondition().get("GLFixCondition");
            tableSystleKey = "11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(ledger.getCurrencyID()) ? "GENERAL_LOCAL_CURRENCY" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(ledger.getCurrencyID()) ? "GENERAL_REPORT_CURRENCY" : (SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString().equalsIgnoreCase(ledger.getCurrencyID()) ? "COMPANY_BASE_CURRENCY" : "OTHER_CURRENCY"));
            if (ledger.isOptionShowAsstItem()) {
                tableSystleKey = tableSystleKey + "_AsstItem";
            }
        }
        if (this.getResult() != null && this.getResult().getTableHeadInfo() != null) {
            tableSystleKey = tableSystleKey + this.getResult().getTableHeadInfo().getColumnCount();
        }
        return tableSystleKey;
    }

    @Override
    protected void setExpandInfo(ReportConditionBase fixCondition, int rowIndex) {
        super.setExpandInfo(fixCondition, rowIndex);
        IRow row = this.getTable().getRow(rowIndex);
        ReportLineKey userObject = (ReportLineKey)row.getUserObject();
        String account = userObject.getStrAccountID();
        String accountNumber = userObject.getStrAccountNumber();
        String currencyId = userObject.getStrCurrencyId();
        fixCondition.getExpandInfo().put("AccountID", account);
        fixCondition.getExpandInfo().put("AccountNumber", accountNumber);
        fixCondition.getExpandInfo().put("CurrencyIDa", currencyId);
    }

    @Override
    protected boolean isSupportVirtual() {
        return true;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getCurrentCompany().isIsBizUnit()) {
            this.queryVirtualData(true);
        } else {
            super.actionRefresh_actionPerformed(e);
        }
    }

    protected void initListener() {
        super.initVirtualCompanyListener();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            String companyId = (String)this.getUIContext().get("companyId");
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
            if (companyId == null) {
                if (company == null) {
                    companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                    company = SysContext.getSysContext().getCurrentFIUnit();
                } else {
                    companyId = company.getId().toString();
                }
            }
            request.put("USERINFO", (Object)SysContext.getSysContext().getCurrentUserInfo());
            request.put("COMPANY_ID", (Object)companyId);
            request.put("COMPANY", (Object)company);
            request.put("InitList", (Object)this.getInitList());
            request.put("FULLNAME", (Object)this.getMetaDataPK().getFullName());
        }
        return clientHanlder;
    }

    @Override
    public String getUIHandlerClassName() {
        return "com.kingdee.eas.fi.gl.app.ReportJournalUIHandler";
    }

    @Override
    protected String getExportPermissionItem() {
        return "gl_journal_export";
    }
}

