/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ReportSubsidiaryLedgerAssistRowSetAddBf {
    private static final Logger logger = Logger.getLogger(ReportSubsidiaryLedgerAssistRowSetAddBf.class);
    private static final String GUO_CHI_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private static final String CHENG_QIAN_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    private static final String QI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"13_RptAsstactMultiColumnRowSetAddBf");
    private static final String RI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"14_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_RI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"15_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_QI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"16_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_NIAN_LEI_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"17_RptAsstactMultiColumnRowSetAddBf");
    private InsertValues insertValues;

    public IRowSet addBf(IRowSet rowSet, int rowLineCount) {
        this.clearValues();
        try {
            if (rowSet.size() <= rowLineCount) {
                return rowSet;
            }
            rowSet.beforeFirst();
            while (rowSet.getRow() < rowLineCount - 1) {
                rowSet.next();
                this.calculate(rowSet);
            }
            this.distinguish(rowSet);
            this.insertValues.setDesc(CHENG_QIAN_YE);
            this.insertBfRow(rowSet, this.insertValues);
            while (!rowSet.isLast()) {
                if (rowSet.getRow() % rowLineCount == 0) {
                    this.insertValues.setDesc(GUO_CHI_YE);
                    this.insertBfRow(rowSet, this.insertValues);
                }
                rowSet.next();
                this.calculate(rowSet);
                if (rowSet.getRow() % rowLineCount != rowLineCount - 1) continue;
                this.distinguish(rowSet);
                this.insertValues.setDesc(CHENG_QIAN_YE);
                this.insertBfRow(rowSet, this.insertValues);
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return rowSet;
    }

    private void clearValues() {
        this.insertValues.bfDebtSum = new BigDecimal(0);
        this.insertValues.bfDebtQuantity = new BigDecimal(0);
        this.insertValues.bfCredSum = new BigDecimal(0);
        this.insertValues.bfCredQuantity = new BigDecimal(0);
        this.insertValues.bfBel = "";
        this.insertValues.bfBelQuantity = "";
        this.insertValues.dc = "";
    }

    private void distinguish(IRowSet rowSet) throws SQLException {
        String desc = rowSet.getString("FDescription");
        if (desc.equals(BEN_RI_HE_JI) || desc.equals(BEN_QI_HE_JI) || desc.equals(BEN_NIAN_LEI_JI)) {
            try {
                this.insertValues.bfDebtSum = new BigDecimal(rowSet.getString("FDebitFor").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.insertValues.bfDebtSum = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.insertValues.bfDebtSum = new BigDecimal(0);
            }
            try {
                this.insertValues.bfDebtQuantity = new BigDecimal(rowSet.getString("FDebitQuantity").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.insertValues.bfDebtQuantity = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.insertValues.bfDebtQuantity = new BigDecimal(0);
            }
            try {
                this.insertValues.bfCredSum = new BigDecimal(rowSet.getString("FCreditFor").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.insertValues.bfCredSum = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.insertValues.bfCredSum = new BigDecimal(0);
            }
            try {
                this.insertValues.bfCredQuantity = new BigDecimal(rowSet.getString("FCreditQuantity").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.insertValues.bfCredQuantity = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.insertValues.bfCredQuantity = new BigDecimal(0);
            }
        } else if (desc.equals(QI_CHU_YU_E) || desc.equals(RI_CHU_YU_E)) {
            this.insertValues.bfDebtSum = new BigDecimal(0);
            this.insertValues.bfDebtQuantity = new BigDecimal(0);
            this.insertValues.bfCredSum = new BigDecimal(0);
            this.insertValues.bfCredQuantity = new BigDecimal(0);
        }
    }

    private void calculate(IRowSet rowSet) throws SQLException {
        String desc = rowSet.getString("FDescription");
        if (!(desc.equals(QI_CHU_YU_E) || desc.equals(RI_CHU_YU_E) || desc.equals(BEN_RI_HE_JI) || desc.equals(BEN_QI_HE_JI) || desc.equals(BEN_NIAN_LEI_JI))) {
            try {
                this.insertValues.bfDebtSum = this.insertValues.bfDebtSum.add(new BigDecimal(rowSet.getString("FDebitFor").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.insertValues.bfDebtQuantity = this.insertValues.bfDebtQuantity.add(new BigDecimal(rowSet.getString("FDebitQuantity").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.insertValues.bfCredSum = this.insertValues.bfCredSum.add(new BigDecimal(rowSet.getString("FCreditFor").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.insertValues.bfCredQuantity = this.insertValues.bfCredQuantity.add(new BigDecimal(rowSet.getString("FCreditQuantity").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.insertValues.bfBel = rowSet.getString("FBalanceFor");
            }
            catch (NullPointerException e) {
                this.insertValues.bfBel = "";
            }
            catch (NumberFormatException e) {
                this.insertValues.bfBel = "";
            }
            try {
                this.insertValues.bfBelQuantity = rowSet.getString("FBalanceQuantity");
            }
            catch (NullPointerException e) {
                this.insertValues.bfBelQuantity = "";
            }
            catch (NumberFormatException e) {
                this.insertValues.bfBelQuantity = "";
            }
            try {
                this.insertValues.dc = rowSet.getString("FDC");
            }
            catch (NullPointerException e) {
                this.insertValues.dc = "";
            }
        }
    }

    private void insertBfRow(IRowSet rowSet, InsertValues insertValues) throws SQLException {
        int rowNum = rowSet.getRow();
        rowSet.moveToInsertRow();
        rowSet.updateString("sysDateNow", "");
        rowSet.updateString("h_CurrentUser", "");
        rowSet.updateString("h_period", "");
        rowSet.updateString("h_currency", "");
        rowSet.updateString("h_company", "");
        rowSet.updateString("FDate", "");
        rowSet.updateString("FVoucherNumber", "");
        rowSet.updateString("FDebitUnit", "");
        rowSet.updateString("FDebitPrice", "");
        rowSet.updateString("FCreditUnit", "");
        rowSet.updateString("FCreditPrice", "");
        rowSet.updateString("FBalanceUnit", "");
        rowSet.updateString("FBalancePrice", "");
        rowSet.updateString("FDescription", insertValues.getDesc());
        rowSet.updateString("FDebitFor", GlUtils.withComma(insertValues.getBfDebtSum(), 2));
        rowSet.updateString("FDebitQuantity", GlUtils.withComma(insertValues.getBfDebtQuantity(), 2));
        rowSet.updateString("FCreditFor", GlUtils.withComma(insertValues.getBfCredSum(), 2));
        rowSet.updateString("FCreditQuantity", GlUtils.withComma(insertValues.getBfCredQuantity(), 2));
        rowSet.updateString("FBalanceFor", insertValues.bfBel);
        rowSet.updateString("FBalanceQuantity", insertValues.bfBelQuantity);
        rowSet.updateString("FDC", insertValues.dc);
        rowSet.insertRow();
        rowSet.beforeFirst();
        rowSet.absolute(rowNum + 1);
    }

    class InsertValues {
        private String desc;
        private String dc;
        private BigDecimal bfDebtSum;
        private BigDecimal bfDebtQuantity;
        private BigDecimal bfCredSum;
        private BigDecimal bfCredQuantity;
        private String bfBel;
        private String bfBelQuantity;

        InsertValues() {
        }

        public BigDecimal getBfCredQuantity() {
            return this.bfCredQuantity;
        }

        public void setBfCredQuantity(BigDecimal bfCredQuantity) {
            this.bfCredQuantity = bfCredQuantity;
        }

        public BigDecimal getBfCredSum() {
            return this.bfCredSum;
        }

        public void setBfCredSum(BigDecimal bfCredSum) {
            this.bfCredSum = bfCredSum;
        }

        public BigDecimal getBfDebtQuantity() {
            return this.bfDebtQuantity;
        }

        public void setBfDebtQuantity(BigDecimal bfDebtQuantity) {
            this.bfDebtQuantity = bfDebtQuantity;
        }

        public BigDecimal getBfDebtSum() {
            return this.bfDebtSum;
        }

        public void setBfDebtSum(BigDecimal bfDebtSum) {
            this.bfDebtSum = bfDebtSum;
        }

        public String getDc() {
            return this.dc;
        }

        public void setDc(String dc) {
            this.dc = dc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getBfBel() {
            return this.bfBel;
        }

        public void setBfBel(String bfBel) {
            this.bfBel = bfBel;
        }

        public String getBfBelQuantity() {
            return this.bfBelQuantity;
        }

        public void setBfBelQuantity(String bfBelQuantity) {
            this.bfBelQuantity = bfBelQuantity;
        }
    }
}

