/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLReportAssistTreeFactory;
import com.kingdee.eas.fi.gl.GLReportSubsidiaryLedgerAssistFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.IGLReportAssistTree;
import com.kingdee.eas.fi.gl.ReportConditionGeneralLedgerAssist;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedgerAssist;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.ReportTableHeadInfo;
import com.kingdee.eas.fi.gl.ReportTreeNodeInfo;
import com.kingdee.eas.fi.gl.RptTreeNodeInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractReportSubsidiaryLedgerAssistUI;
import com.kingdee.eas.fi.gl.client.ReportBaseUI;
import com.kingdee.eas.fi.gl.client.ReportGeneralLedgerAssistUI;
import com.kingdee.eas.fi.gl.client.ReportSubsidiaryLedgerAssistParame;
import com.kingdee.eas.fi.gl.client.ReportSubsidiaryLedgerAssistTaoDa;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ReportSubsidiaryLedgerAssistUI
extends AbstractReportSubsidiaryLedgerAssistUI {
    private static final long serialVersionUID = 6777903145836761763L;
    private static final Logger logger = CoreUIObject.getLogger(ReportSubsidiaryLedgerAssistUI.class);
    private Map mapInfo;
    private static Map mapGl;
    protected CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
    ReportSubsidiaryLedgerAssistParame editParame = null;
    public static final String TITLE_ACCOUNT_NAME = "TitleAccountName";
    String PRE_ACCOUNT = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportAssistBaseUI", (String)"PreAccount");
    private String accountString = null;

    public ReportSubsidiaryLedgerAssistUI() throws Exception {
        this.editParame = ReportSubsidiaryLedgerAssistParame.getInstance();
    }

    @Override
    public void onLoad() throws Exception {
        this.actionGLAssist.setEnabled(false);
        this.actionVoucher.setEnabled(false);
        this.actionPrintParame.setEnabled(true);
        this.actionPageSetup.setVisible(true);
        if (this.currCompany.isIsBizUnit()) {
            this.actionPrintParame.setVisible(true);
        } else {
            this.actionPrintParame.setVisible(false);
        }
        super.onLoad();
    }

    @Override
    protected IGLReportAssistTree getRemoteInstanceForTree() throws BOSException, EASBizException {
        return GLReportAssistTreeFactory.getRemoteInstance();
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException, EASBizException {
        return GLReportSubsidiaryLedgerAssistFactory.getRemoteInstance();
    }

    public static void queryByCondition(EntityViewInfo currentCondition, Object owner, CompanyOrgUnitInfo company) throws Exception {
        if (currentCondition == null) {
            throw new ReportException(ReportException.ENTITY_EMPTY);
        }
        Object conditionObj = currentCondition.get("GLFixCondition");
        if (conditionObj == null) {
            throw new ReportException(ReportException.CONDITION_EMPTY);
        }
        if (!ReportConditionSubsidiaryLedgerAssist.class.isInstance(conditionObj)) {
            throw new ReportException(ReportException.CONDITION_ERROR);
        }
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"company", (Object)company);
        ReportBaseUI.fetchCompany((Map)uiContext);
        uiContext.put((Object)"EntityView", (Object)currentCondition);
        ReportConditionSubsidiaryLedgerAssist cond = (ReportConditionSubsidiaryLedgerAssist)conditionObj;
        StringBuffer str = new StringBuffer();
        str.append(cond.getAccountId());
        str.append(cond.getAssistItemId());
        str.append(cond.getCurrencyID());
        str.append(String.valueOf(cond.getPeriodYearStart() + cond.getPeriodNumberStart()));
        str.append(String.valueOf(cond.getPeriodYearEnd() + cond.getPeriodNumberEnd()));
        str.append(String.valueOf(cond.getOptionPosting()));
        uiContext.put((Object)"UIClassParam", (Object)str.toString());
        String mode = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        if (owner instanceof CoreUIObject) {
            mode = ((CoreUIObject)owner).getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(ReportSubsidiaryLedgerAssistUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    @Override
    protected ReportTableHeadInfo getDefalutTableHead() throws ReportException {
        ReportTableHeadInfo head = new ReportTableHeadInfo();
        String[] columnNames = new String[]{"FDate", "FVoucherNumber", "FDescription", "FDebit", "FCredit", "FDC", "FBalance"};
        head.setColumnNames(columnNames);
        String[][] titles = new String[][]{{"Date", "VoucherNumber", "Description", "Debit", "Credit", "Balance", "Balance"}};
        head.setTitles(titles);
        head.setHeadMerge(true);
        int[] widths = new int[]{80, 100, 100, 80, 80, 40, 80};
        head.setWidths(widths);
        int[] alignments = new int[]{0, 0, 0, 2, 2, 1, 2};
        head.setAlignments(alignments);
        if (!head.check()) {
            throw new ReportException(ReportException.TABLE_HEAD_ERROR);
        }
        return head;
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return false;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
        this.queryVoucher();
    }

    @Override
    public void actionGLAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionGLAssist_actionPerformed(e);
        this.queryGLAssist();
    }

    protected void queryVoucher() throws Exception {
        if (this.getTable().getSelectManager().size() > 0) {
            Object accountId;
            int selectIndex = this.getTable().getSelectManager().get().getTop();
            IRow row = this.getTable().getRow(selectIndex);
            if (row != null && (accountId = row.getUserObject()) != null && String.class.isInstance(accountId) && ((String)accountId).length() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)((String)accountId).trim());
                uiContext.put((Object)"company", (Object)((CompanyOrgUnitInfo)this.getUIContext().get("company")));
                String mode = this.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
                IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
        }
    }

    protected void queryGLAssist() throws Exception {
        EntityViewInfo condition = this.getCondition();
        if (condition == null) {
            return;
        }
        ReportConditionSubsidiaryLedgerAssist glCondition = (ReportConditionSubsidiaryLedgerAssist)condition.get("GLFixCondition");
        if (glCondition == null) {
            return;
        }
        if (this.getAccountViewInfo() == null) {
            return;
        }
        EntityViewInfo newCondition = (EntityViewInfo)condition.clone();
        ReportConditionGeneralLedgerAssist fixCondition = new ReportConditionGeneralLedgerAssist();
        fixCondition.setAccountCodeEnd(glCondition.getAccountCodeEnd());
        fixCondition.setAccountCodeStart(glCondition.getAccountCodeStart());
        fixCondition.setAccountId(glCondition.getAccountId());
        fixCondition.setAccountIdSet(glCondition.getAccountIdSet());
        fixCondition.setAccountLevelEnd(glCondition.getAccountLevelEnd());
        fixCondition.setAccountLevelStart(glCondition.getAccountLevelStart());
        fixCondition.setAllCurrencyMultiColumn(false);
        fixCondition.setAssistItemId(this.processAssistItemId(glCondition.getAssistItemId()));
        fixCondition.setAssistTypeId(glCondition.getAssistTypeId());
        fixCondition.setCurrencyID(glCondition.getCurrencyID());
        fixCondition.setCurrencyName(glCondition.getCurrencyName());
        fixCondition.setOptionNOTDisplayIfNoAmount(glCondition.getOptionAmountZero());
        fixCondition.setOptionNOTDisplayIfZeroNoAmount(glCondition.getOptionBalanceAndAmountZero());
        fixCondition.setOptionPosting(glCondition.getOptionPosting());
        fixCondition.setOptionShowQuantity(this.getAccountViewInfo().isIsQty());
        fixCondition.setPeriodNumberStart(glCondition.getPeriodNumberStart());
        fixCondition.setPeriodNumberEnd(glCondition.getPeriodNumberEnd());
        fixCondition.setPeriodYearStart(glCondition.getPeriodYearStart());
        fixCondition.setPeriodYearEnd(glCondition.getPeriodYearEnd());
        fixCondition.setSelectAccountNode(this.selectAccountNode);
        newCondition.put("GLFixCondition", (Object)fixCondition);
        if (this.getAccountViewInfo().isIsLeaf()) {
            fixCondition.setAsstAccountId(glCondition.getAsstAccountId());
        }
        ReportGeneralLedgerAssistUI.queryByCondition(newCondition, this, (CompanyOrgUnitInfo)this.getUIContext().get("company"));
    }

    @Override
    protected void table_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.table_tableSelectChanged(e);
        this.actionVoucher.setEnabled(this.isEnabledVoucher());
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        this.actionVoucher.setEnabled(false);
        this.actionGLAssist.setEnabled(true);
        super.tree_valueChanged(e);
    }

    protected boolean isEnabledVoucher() throws Exception {
        boolean isEnabledVoucher = false;
        if (this.getTable().getSelectManager().size() > 0) {
            Object accountId;
            int selectIndex = this.getTable().getSelectManager().get().getTop();
            IRow row = this.getTable().getRow(selectIndex);
            if (row != null && (accountId = row.getUserObject()) != null && String.class.isInstance(accountId) && ((String)accountId).length() > 0) {
                isEnabledVoucher = true;
            }
        }
        return isEnabledVoucher;
    }

    protected boolean isEnabledGLAssist(TreePath path) throws Exception {
        Object nodeInfo;
        DefaultKingdeeTreeNode node;
        boolean isEnabledGLAssist = false;
        String assistTypeID = null;
        String assistItemID = null;
        if (path != null && (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && (nodeInfo = node.getUserObject()) != null && RptTreeNodeInfo.class.isInstance(nodeInfo) && ((RptTreeNodeInfo)nodeInfo).isItem()) {
            assistItemID = ((RptTreeNodeInfo)nodeInfo).getId();
            assistTypeID = this.getAssistTypeId(node);
            if (assistItemID != null && assistItemID.length() > 0 && assistTypeID != null && assistTypeID.length() > 0) {
                isEnabledGLAssist = true;
            }
        }
        return isEnabledGLAssist;
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        super.table_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.queryVoucher();
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnGLAssist.setIcon(EASResource.getIcon((String)"imgTbtn_assistantgeneralledger"));
    }

    @Override
    public void actionPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ReportSubsidiaryLedgerAssistPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editParame.isChkPrintParame()) {
            super.actionPrintPreview_actionPerformed(e);
        } else if (this.currCompany.isIsBizUnit()) {
            this.invokePrintFunc(e, true);
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editParame.isChkPrintParame()) {
            super.actionPrint_actionPerformed(e);
        } else if (this.currCompany.isIsBizUnit()) {
            this.invokePrintFunc(e, true);
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        String strTemplatepathPath = this.editParame.getStrTempletpathPath();
        String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)strTemplatepathPath) || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)this.editParame.getStrTempletpathName())) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"notTemplet");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        boolean bBF = this.editParame.isChkBF();
        String strPeriod = this.lblPeriod.getText().trim();
        String strCurrency = this.lblCurrency.getText().trim();
        EntityViewInfo condition = this.getCondition();
        if (condition == null) {
            return;
        }
        ReportConditionSubsidiaryLedgerAssist glCondition = (ReportConditionSubsidiaryLedgerAssist)condition.get("GLFixCondition");
        if (glCondition == null) {
            return;
        }
        int periodYearStart = glCondition.getPeriodYearStart();
        int PeriodNumberStart = glCondition.getPeriodNumberStart();
        int periodYearEnd = glCondition.getPeriodYearEnd();
        int PeriodNumberEnd = glCondition.getPeriodNumberEnd();
        mapGl = new HashMap();
        mapGl.put("yearBegin", new Integer(periodYearStart));
        mapGl.put("numberBegin", new Integer(PeriodNumberStart));
        mapGl.put("yearEnd", new Integer(periodYearEnd));
        mapGl.put("numberEnd", new Integer(PeriodNumberEnd));
        int iPer = strPeriod.compareTo(this.getResx("PREPERIOD"));
        String ss = strPeriod.substring(strPeriod.length() - iPer, strPeriod.length());
        int iCur = strCurrency.compareTo(this.getResx("PRECURRENCY"));
        String st = strCurrency.substring(strCurrency.length() - iCur, strCurrency.length());
        if (this.mapInfo == null) {
            this.mapInfo = mapGl;
        }
        this.mapInfo.put("period", ss);
        this.mapInfo.put("currency", st);
        KDNoteHelper appHlp = new KDNoteHelper();
        TreePath[] tps = this.getAccountTreePath(false);
        ICrossPrintDataProvider[] dps = new ICrossPrintDataProvider[]{new DataProvider(this, tps, bBF)};
        appHlp.crossPrint(new String[]{strTemplatepathPath}, dps, noPreview, (Component)((Object)this));
    }

    public String getAccountString() {
        return this.accountString;
    }

    public void setAccountString(String accountString) {
        this.accountString = accountString;
    }

    public void requestTableData2(TreePath path) {
        try {
            this.requestTableData(path);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private TreePath[] getAccountTreePath(boolean all) {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath[] tps = null;
        if (all) {
            Enumeration em = ((DefaultKingdeeTreeNode)this.tree.getModel().getRoot()).depthFirstEnumeration();
            while (em.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)em.nextElement();
                Object nodeInfo = node.getUserObject();
                if (nodeInfo == null || !ReportTreeNodeInfo.class.isInstance(nodeInfo) || !((ReportTreeNodeInfo)nodeInfo).isItem()) continue;
                list.add(new TreePath(node.getPath()));
            }
        } else {
            tps = this.tree.getSelectionPaths();
            if (tps != null) {
                int n = tps.length;
                for (int i = 0; i < n; ++i) {
                    Object nodeInfo;
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
                    if (node == null || (nodeInfo = node.getUserObject()) == null || !RptTreeNodeInfo.class.isInstance(nodeInfo)) continue;
                    list.add(tps[i]);
                }
            }
        }
        tps = new TreePath[list.size()];
        list.toArray(tps);
        return tps;
    }

    protected static ArrayList getPeriods(int periodYearStart, int periodYearEnd) throws Exception {
        int i;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String strPeriodId = SysContext.getSysContext().getCurrentFIUnit().getAccountPeriodType().getId().toString();
        int periodYear = 0;
        int periodNumber = 0;
        String periodStart = null;
        String periodEnd = null;
        PeriodCollection c = null;
        PeriodCollection pc = null;
        PeriodInfo info = null;
        ArrayList<PeriodCollection> alPeriodCollection = new ArrayList<PeriodCollection>();
        ArrayList<Object[]> alPeriods = new ArrayList<Object[]>();
        Object[] objPeriod = null;
        for (i = periodYearStart; i <= periodYearEnd; ++i) {
            c = ReportSubsidiaryLedgerAssistUI.getPeriodCollection(strPeriodId, i);
            alPeriodCollection.add(c);
        }
        int n = alPeriodCollection.size();
        for (i = 0; i < n; ++i) {
            pc = (PeriodCollection)alPeriodCollection.get(i);
            if (pc == null) continue;
            int m = pc.size();
            for (int j = 0; j < m; ++j) {
                info = pc.get(j);
                objPeriod = new Object[4];
                if (info == null) continue;
                periodYear = info.getPeriodYear();
                periodNumber = info.getPeriodNumber();
                periodStart = GlUtils.formatDate(format, info.getBeginDate());
                periodEnd = GlUtils.formatDate(format, (Date)info.getEndDate());
                objPeriod[0] = new Integer(periodYear);
                objPeriod[1] = new Integer(periodNumber);
                objPeriod[2] = periodStart;
                objPeriod[3] = periodEnd;
                alPeriods.add(objPeriod);
            }
        }
        return alPeriods;
    }

    private String getResx(String resxItemName) {
        Locale locale = this.getCurrentLocale();
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    private static PeriodCollection getPeriodCollection(String strPeriodId, int PeriodYear) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        FilterInfo i = new FilterInfo();
        if (strPeriodId != null) {
            i.getFilterItems().add(new FilterItemInfo("periodType", (Object)strPeriodId, CompareType.EQUALS));
        }
        if (PeriodYear != -1) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear), CompareType.EQUALS));
        } else if (PeriodYear == 0) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)"", CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        evi.getSelector().add(new SelectorItemInfo("CU"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return iPeriod.getPeriodCollection(evi);
    }

    @Override
    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        if (data == null || tableForShowData == null || this.getCurrentTableHeadInfo() == null) {
            return;
        }
        int index = startRow;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            for (int i = 0; i < this.getCurrentTableHeadInfo().getColumnCount(); ++i) {
                ICell cell = row.getCell(this.getCurrentTableHeadInfo().getColumnNames()[i]);
                if (cell == null || lineObjects[i] == null) continue;
                if (lineObjects[i].getClass() != BigDecimal.class) {
                    cell.setValue(lineObjects[i]);
                    continue;
                }
                if (ZERO.compareTo((BigDecimal)lineObjects[i]) == 0) continue;
                cell.setValue((Object)((BigDecimal)lineObjects[i]));
            }
            row.getStyleAttributes().setBackground(ReportSubsidiaryLedgerAssistUI.getColor((Integer)lineObjects[lineObjects.length - 2]));
            row.setUserObject(lineObjects[lineObjects.length - 1]);
        }
    }

    @Override
    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(9);
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Account_Label"));
        sb.append("&[Account]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Period_Label"));
        sb.append("&[Period]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sb.append("&[CompanyName]");
        header.addRow(sb.append("&|").toString(), sa);
        sb = new StringBuffer();
        sb.append("&[Asstact]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Currency_Label"));
        sb.append("&[Currency]");
        header.addRow(sb.append("&|").toString(), sa);
    }

    private String processAssistItemId(String assistItemId) {
        if (StringUtils.isEmpty((String)assistItemId)) {
            return "";
        }
        if (assistItemId.contains(",")) {
            String[] array = assistItemId.split("','");
            HashSet<String> idSet = new HashSet<String>(Arrays.asList(array));
            StringBuilder resultSb = new StringBuilder();
            if (idSet.size() != 1) {
                for (String s : idSet) {
                    resultSb.append("'").append(s).append("'").append(",");
                }
                resultSb.deleteCharAt(resultSb.length() - 1);
            } else {
                for (String s : idSet) {
                    resultSb.append(s);
                }
            }
            return resultSb.toString();
        }
        return assistItemId;
    }

    class DataProvider
    implements ICrossPrintDataProvider {
        private int point = 0;
        private ReportSubsidiaryLedgerAssistUI ui;
        private TreePath[] tps;
        private boolean bBF = false;

        public DataProvider(ReportSubsidiaryLedgerAssistUI ui, TreePath[] tps, boolean bBF) {
            this.ui = ui;
            this.tps = tps;
            this.bBF = bBF;
        }

        public boolean hasNext() {
            return this.point < this.tps.length;
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            TreePath tp = this.tps[this.point++];
            ReportSubsidiaryLedgerAssistUI.this.table.getDataRequestManager().setDataRequestMode(0);
            this.ui.requestTableData2(tp);
            ReportSubsidiaryLedgerAssistUI.this.table.getDataRequestManager().setDataRequestMode(1);
            ReportSubsidiaryLedgerAssistTaoDa rsprv = new ReportSubsidiaryLedgerAssistTaoDa(ReportSubsidiaryLedgerAssistUI.this.result, ReportSubsidiaryLedgerAssistUI.this.mapInfo, tp, this.bBF);
            return rsprv.execute(ds);
        }
    }
}

