/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.client.AbstractReportSubsidiaryLedgerConditionAdvanceUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AsstGroupChooserPrompt;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;

public class ReportSubsidiaryLedgerConditionAdvanceUI
extends AbstractReportSubsidiaryLedgerConditionAdvanceUI {
    private static final long serialVersionUID = 5950222891496423491L;
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private boolean isJoinQuery = false;
    public static final Color LOCKCOLOR = new Color(228, 228, 228);

    public ReportSubsidiaryLedgerConditionAdvanceUI() throws Exception {
        this.tblAct.checkParsed();
        this.tblAct.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblAct.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tblAct.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ReportSubsidiaryLedgerConditionAdvanceUI.this.tblEditStopped(e);
            }
        });
        this.chkOpAsstGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getColumn("group").getStyleAttributes().setHided(false);
                } else {
                    ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getColumn("group").getStyleAttributes().setHided(true);
                }
            }
        });
        this.tblAct.getColumn("group").getStyleAttributes().setHided(true);
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        super.kdDown_actionPerformed(e);
        this.moveRow(1);
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        super.kdUp_actionPerformed(e);
        this.moveRow(-1);
    }

    private void moveRow(int offset) {
        if (this.tblAct.getSelectManager().get() != null) {
            int r = this.tblAct.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tblAct.getRowCount()) {
                return;
            }
            IRow row = this.tblAct.removeRow(r);
            this.tblAct.addRow(newr, row);
            this.tblAct.getSelectManager().select(newr, 0, newr, this.tblAct.getColumnCount());
            this.tblAct.getLayoutManager().scrollToShow(newr, 0);
        }
    }

    protected void tblEditStopped(KDTEditEvent e) {
        if (e.getColIndex() == 0) {
            this.tblAct.getCell(e.getRowIndex(), 0).setValue(e.getValue());
            boolean isSelect = (Boolean)e.getValue();
            IRow row = this.tblAct.getRow(e.getRowIndex());
            if (isSelect && (row.getCell("from").getEditor() == null || row.getCell("to").getEditor() == null)) {
                row.getCell("from").setValue(null);
                row.getCell("to").setValue(null);
                AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                this.addF7(row, at);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionSubsidiaryLedger((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public void setCustomCondition(ReportConditionSubsidiaryLedger condition) {
        if (condition == null) {
            return;
        }
        this.setTableData(condition.getTableData());
        this.chkOpAsstGroup.setSelected(condition.getOptionAsstGroup());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public ReportConditionSubsidiaryLedger getCustomCondition() {
        ReportConditionSubsidiaryLedger condition = new ReportConditionSubsidiaryLedger();
        condition.setTableData(this.getTableData());
        condition.setOptionAsstGroup(this.chkOpAsstGroup.isSelected());
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)condition.toMap());
        return condition;
    }

    public void onLoad() throws Exception {
        if (!this.isJoinQuery) {
            super.onLoad();
            this.tblActInit();
        }
    }

    private void tblActInit() throws Exception {
        List list = RptClientUtil.queryAsstAct(null, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                at.setSelected(false);
            }
        }
        this.setTableData(list);
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tblAct.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblAct.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            boolean select = (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            if (row.getCell("group").getValue() != null) {
                at.setAsstGroup(row.getCell("group").getValue().toString());
            } else {
                at.setAsstGroup(null);
            }
            list.add(at);
        }
        return list;
    }

    protected void setTableData(List list) {
        AsstactTypeEntity at;
        this.tblAct.setRefresh(false);
        this.tblAct.removeRows();
        if (list == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            at = (AsstactTypeEntity)list.get(i);
            if (at.getId() == null) continue;
            idSet.add(at.getId());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(fi);
        AsstActTypeCollection asstActColl = null;
        try {
            asstActColl = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String att;
            IRow row = this.tblAct.addRow();
            at = (AsstactTypeEntity)list.get(i);
            row.setUserObject((Object)at);
            AsstActTypeInfo asstActTypeInfo = this.findAsstActTypeInfo(asstActColl, at.getId());
            if (asstActTypeInfo != null) {
                row.getCell("type").setValue((Object)asstActTypeInfo.getName());
            }
            boolean isSelected = at.isSelected();
            row.getCell("selected").setValue((Object)isSelected);
            if (isSelected) {
                this.addF7(row, at);
                row.getCell("from").setValue(at.getFrom());
                row.getCell("to").setValue(at.getTo());
                row.getCell("group").setValue((Object)at.getAsstGroup());
            }
            if ((att = at.getHgAttribute()).equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) continue;
            this.lockGroup(row);
        }
        this.tblAct.setRefresh(true);
        this.tblAct.updateUI();
    }

    private AsstActTypeInfo findAsstActTypeInfo(AsstActTypeCollection asstActCol, String id) {
        if (asstActCol == null || id == null || id.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < asstActCol.size(); ++i) {
            if (!BOSUuid.read((String)id).equals((Object)asstActCol.get(i).getId())) continue;
            return asstActCol.get(i);
        }
        return null;
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        GeneralAsstActTypeGroupInfo grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        bizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getSelectManager().get().getBeginRow();
                    IRow row = ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(e.getNewValue());
                    }
                }
                catch (Exception exc) {
                    ReportSubsidiaryLedgerConditionAdvanceUI.this.handUIException(exc);
                }
            }
        });
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("from").setEditor((ICellEditor)editor);
        String att = at.getHgAttribute();
        if (att == null || att.toString().trim().length() < 1) {
            this.lockGroup(row);
        } else {
            KDBizPromptBox groupPromptBox = new KDBizPromptBox();
            groupPromptBox.setEditable(true);
            groupPromptBox.setEditFormat("$number$");
            groupPromptBox.setDisplayFormat("$number$ - $name$");
            groupPromptBox.setCommitFormat("$number$");
            if (att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) {
                AsstGroupChooserPrompt prompt = new AsstGroupChooserPrompt((IUIObject)this);
                int asstGroupChooser = 0;
                asstGroupChooser = att.equalsIgnoreCase("Customer") ? 1 : (att.equalsIgnoreCase("Material") ? 3 : 2);
                groupPromptBox.setSelector((KDPromptSelector)prompt);
                groupPromptBox.addSelectorListener((SelectorListener)new GroupSelectorListener(row.getCell("group")));
                prompt.setGroupType(asstGroupChooser);
                bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(asstGroupChooser));
            }
            KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
            ICell cell = row.getCell("group");
            if (cell != null) {
                cell.setEditor((ICellEditor)groupEditor);
            }
        }
    }

    public boolean isJoinQuery() {
        return this.isJoinQuery;
    }

    public void setJoinQuery(boolean isJoinQuery) {
        this.isJoinQuery = isJoinQuery;
    }

    private void lockGroup(IRow row) {
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private static class GroupSelectorListener
    implements SelectorListener {
        ICell groupCell;

        public GroupSelectorListener(ICell cell) {
            this.groupCell = cell;
        }

        public void willShow(SelectorEvent e) {
            KDBizPromptBox box = (KDBizPromptBox)e.getSource();
            AsstGroupChooserPrompt prompt = (AsstGroupChooserPrompt)box.getSelector();
            prompt.setInitData(this.groupCell.getValue());
        }
    }

    private final class AssItemSelectorListener
    implements SelectorListener {
        int type = -1;

        public AssItemSelectorListener(int type) {
            this.type = type;
        }

        public void willShow(SelectorEvent e) {
            IRow row = ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getRow(ReportSubsidiaryLedgerConditionAdvanceUI.this.tblAct.getSelectManager().getActiveRowIndex());
            Object startGroup = row.getCell("group").getValue();
            if (startGroup == null) {
                return;
            }
            String groups = startGroup.toString();
            KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
            if (StringUtils.isEmpty((String)groups)) {
                pb.setEntityViewInfo(null);
                pb.getQueryAgent().resetRuntimeEntityView();
                return;
            }
            EntityViewInfo view = pb.getEntityViewInfo();
            if (view == null) {
                view = new EntityViewInfo();
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            view.setFilter(filter);
            pb.setEntityViewInfo(view);
            pb.getQueryAgent().resetRuntimeEntityView();
            try {
                int i;
                AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem((String)("1002|001|" + groups + "#"));
                if (item == null) {
                    return;
                }
                AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
                String mask = null;
                for (i = 0; group != null && i < group.length; ++i) {
                    String std = group[i].standardNumber;
                    if (this.type == 1) {
                        fic.add(new FilterItemInfo("customerGroupDetails.CustomerGroupStandard.number", (Object)std));
                    } else if (this.type == 2) {
                        fic.add(new FilterItemInfo("supplierGroupDetails.SupplierGroupStandard.number", (Object)std));
                    } else if (this.type == 3) {
                        fic.add(new FilterItemInfo("materialGroupDetails.MaterialGroupStandard.number", (Object)std));
                    }
                    mask = i == 0 ? "#" + i : mask + " or #" + i;
                }
                if (i > 1) {
                    filter.setMaskString(mask);
                }
            }
            catch (ParseException e1) {
                return;
            }
        }
    }
}

