/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionSubsidiaryLedger;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractReportSubsidiaryLedgerConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ReportSubsidiaryLedgerConditionUI
extends AbstractReportSubsidiaryLedgerConditionUI {
    private static final long serialVersionUID = 7100804815047478364L;
    private static final Logger logger = CoreUIObject.getLogger(ReportSubsidiaryLedgerConditionUI.class);
    CompanyOrgUnitInfo company = null;
    boolean loading = false;
    private PeriodEntity pe = null;
    boolean isCleared = false;
    boolean isQueryByOther = false;
    private Map initDataUsingForClear = null;

    public ReportSubsidiaryLedgerConditionUI() throws Exception {
        this.chkOpOnlyAsst.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 || ReportSubsidiaryLedgerConditionUI.this.chkOpAccountCusAttribute.isSelected()) {
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setSelected(false);
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setEnabled(false);
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItems(true);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                } else {
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setEnabled(true);
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItems(false);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.chkOpAccountCusAttribute.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 || ReportSubsidiaryLedgerConditionUI.this.chkOpOnlyAsst.isSelected()) {
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setSelected(false);
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setEnabled(false);
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItems(true);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                } else {
                    ReportSubsidiaryLedgerConditionUI.this.chkOpOtherAccount.setEnabled(true);
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItems(false);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                }
                if (e.getStateChange() == 1) {
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItemsForZDY(true);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                } else {
                    try {
                        ReportSubsidiaryLedgerConditionUI.this.showQueryItemsForZDY(false);
                    }
                    catch (BOSException e1) {
                        ReportSubsidiaryLedgerConditionUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.cmbCurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportSubsidiaryLedgerConditionUI.this.beforeActionPerformed(e);
                try {
                    ReportSubsidiaryLedgerConditionUI.this.cmbCurrency_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportSubsidiaryLedgerConditionUI.this.handUIException(exc);
                }
                finally {
                    ReportSubsidiaryLedgerConditionUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    protected void cmbCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (GlUtils.isCompanyUnion(this.company)) {
            return;
        }
        Object objectCurrency = this.cmbCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo) {
            this.chkOpOtherAccount.setEnabled(!this.chkOpOnlyAsst.isSelected());
        } else if (objectCurrency != null && GLResUtil.getRes("all_currency").equals(objectCurrency.toString())) {
            this.chkOpOtherAccount.setEnabled(!this.chkOpOnlyAsst.isSelected());
            this.chkOpOtherAccount.setSelected(false);
        }
    }

    @Override
    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) throws Exception {
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        int numberEnd = (Integer)this.spnPeriodNumberEnd.getValue();
        RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.prbAccountBegin, this.prbAccountEnd);
    }

    @Override
    protected void rbnQueryByPeriod_itemStateChanged(ItemEvent e) throws Exception {
        super.rbnQueryByPeriod_itemStateChanged(e);
    }

    @Override
    protected void spnAccountLevelBegin_stateChanged(ChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        super.spnAccountLevelBegin_stateChanged(e);
        Integer numberBegin = (Integer)this.spnAccountLevelBegin.getValue();
        Integer numberEnd = (Integer)this.spnAccountLevelEnd.getValue();
        if (numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        int iNumberBegin = numberBegin;
        int iNumberEnd = numberEnd;
        if (iNumberEnd < iNumberBegin) {
            this.spnAccountLevelEnd.setValue((Object)new Integer(iNumberBegin));
        }
    }

    @Override
    protected void spnAccountLevelEnd_stateChanged(ChangeEvent e) throws Exception {
        int iNumberEnd;
        if (this.loading) {
            return;
        }
        super.spnAccountLevelEnd_stateChanged(e);
        Integer numberBegin = (Integer)this.spnAccountLevelBegin.getValue();
        Integer numberEnd = (Integer)this.spnAccountLevelEnd.getValue();
        if (numberBegin == null || numberEnd == null) {
            throw new ReportException(ReportException.INIT_DATA_ERROR);
        }
        int iNumberBegin = numberBegin;
        if (iNumberBegin > (iNumberEnd = numberEnd.intValue())) {
            this.spnAccountLevelBegin.setValue((Object)new Integer(iNumberEnd));
        }
    }

    @Override
    protected void chkOpOnlyLeaf_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpOnlyLeaf_itemStateChanged(e);
        boolean isOnlyLeaf = ((KDCheckBox)e.getSource()).isSelected();
        this.spnAccountLevelBegin.setEnabled(!isOnlyLeaf);
        if (isOnlyLeaf) {
            Object max = this.spnAccountLevelEnd.getValue();
            Object cur = null;
            while ((cur = this.spnAccountLevelEnd.getNextValue()) != null && !max.equals(cur)) {
                max = cur;
            }
            this.spnAccountLevelEnd.setValue(max);
        }
        this.spnAccountLevelEnd.setEnabled(!isOnlyLeaf);
    }

    @Override
    protected void chkOpAmountZero_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpAmountZero_itemStateChanged(e);
        boolean isAmountZero = ((KDCheckBox)e.getSource()).isSelected();
        this.chkOpBalanceAndAmountZero.setEnabled(!isAmountZero);
        this.chkOpNotUsed.setEnabled(!isAmountZero);
    }

    @Override
    protected void chkOpBalanceAndAmountZero_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpBalanceAndAmountZero_itemStateChanged(e);
        boolean isBalanceAndAmountZero = ((KDCheckBox)e.getSource()).isSelected();
        if (!this.chkOpNotUsed.isSelected()) {
            this.chkOpAmountZero.setEnabled(!isBalanceAndAmountZero);
        }
    }

    @Override
    protected void chkOpNotUsed_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpNotUsed_itemStateChanged(e);
        boolean isNotUsed = ((KDCheckBox)e.getSource()).isSelected();
        if (!this.chkOpBalanceAndAmountZero.isSelected()) {
            this.chkOpAmountZero.setEnabled(!isNotUsed);
        }
    }

    @Override
    protected void chkOpOtherAccount_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpOtherAccount_itemStateChanged(e);
    }

    public ReportConditionSubsidiaryLedger getCustomCondition() {
        CurrencyInfo currency;
        AccountViewInfo account;
        int i;
        String accountNumber;
        Object[] ar;
        String strNumber;
        ReportConditionSubsidiaryLedger condition = new ReportConditionSubsidiaryLedger();
        condition.setByPeriod(this.rbnQueryByPeriod.isSelected());
        condition.setPeriodYearStart((Integer)this.spnPeriodYearBegin.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumberBegin.getValue());
        condition.setPeriodYearEnd((Integer)this.spnPeriodYearEnd.getValue());
        condition.setPeriodNumberEnd((Integer)this.spnPeriodNumberEnd.getValue());
        condition.setDateBegin(this.dpkDateBegin.getSqlDate());
        condition.setDateEnd(this.dpkDateEnd.getSqlDate());
        condition.setAccountCodeStart(null);
        Object object = this.prbAccountBegin.getValue();
        condition.setAccountViewStart(object);
        if (object != null) {
            if (object instanceof String) {
                strNumber = (String)object;
                if (!strNumber.trim().equals("")) {
                    condition.setAccountCodeStart(strNumber.trim());
                }
            } else {
                Object[] objectArray;
                if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object;
                }
                ar = objectArray;
                accountNumber = "";
                for (i = 0; i < ar.length; ++i) {
                    account = (AccountViewInfo)ar[i];
                    if (account == null) continue;
                    accountNumber = accountNumber + account.getNumber() + ",";
                }
                if (!accountNumber.equals("")) {
                    accountNumber = accountNumber.substring(0, accountNumber.length() - 1);
                }
                condition.setAccountCodeStart(accountNumber);
            }
        }
        condition.setAccountCodeEnd(null);
        object = this.prbAccountEnd.getValue();
        condition.setAccountViewEnd(object);
        if (object != null) {
            if (object instanceof String) {
                strNumber = (String)object;
                if (!strNumber.trim().equals("")) {
                    condition.setAccountCodeEnd(strNumber.trim() + "z");
                }
            } else {
                Object[] objectArray;
                if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = object;
                }
                ar = objectArray;
                accountNumber = "";
                for (i = 0; i < ar.length; ++i) {
                    account = (AccountViewInfo)ar[i];
                    if (account == null) continue;
                    accountNumber = accountNumber + account.getNumber() + ",";
                }
                if (!accountNumber.equals("")) {
                    accountNumber = accountNumber.substring(0, accountNumber.length() - 1);
                }
                condition.setAccountCodeEnd(accountNumber);
            }
        }
        condition.setAccountLevelStart((Integer)this.spnAccountLevelBegin.getValue());
        condition.setAccountLevelEnd((Integer)this.spnAccountLevelEnd.getValue());
        CurrencyInfo currencyInfo = currency = this.cmbCurrency.getSelectedItem() instanceof CurrencyInfo ? (CurrencyInfo)this.cmbCurrency.getSelectedItem() : null;
        if (currency != null) {
            if (currency.getId() != null) {
                condition.setCurrencyID(currency.getId().toString());
            } else {
                condition.setCurrencyID(currency.getNumber());
            }
            condition.setCurrencyName(currency.getName());
        } else if (GLResUtil.getRes("all_currency").equals((String)this.cmbCurrency.getSelectedItem())) {
            condition.setCurrencyID("AllCurrency");
            condition.setCurrencyName((String)this.cmbCurrency.getSelectedItem());
        }
        condition.setOptionPosting(this.chkOpIncludeNotPosting.isSelected());
        condition.setOptionOnlyLeaf(this.chkOpOnlyLeaf.isSelected());
        condition.setOptionAmountZero(this.chkOpAmountZero.isSelected());
        condition.setOptionBalanceAndAmountZero(this.chkOpBalanceAndAmountZero.isSelected());
        condition.setOptionNoDisplayZeroTotal(this.jcbNoDisplayZeroTotal.isSelected());
        condition.setOptionNotUsed(this.chkOpNotUsed.isSelected());
        condition.setOptionOtherAccount(this.chkOpOtherAccount.isSelected());
        condition.setOptionOtherAccountItem(this.chkOpOtherAccountItem.isSelected());
        condition.setOptionShowBusinessDate(this.chkOpShowBusinessDate.isSelected());
        condition.setOptionOnlyAsst(this.chkOpOnlyAsst.isSelected());
        condition.setOptionDailyTotal(this.chkOpDailyTotal.isSelected());
        condition.setOptionShowAccountCusAttribute(this.chkOpAccountCusAttribute.isSelected());
        condition.getExpandInfo().put("company", this.company);
        condition.getExpandInfo().put("periodEntity", this.pe);
        condition.setOptionNotIncludePLVoucher(this.chkNotIncluePLVoucher.isSelected());
        return condition;
    }

    public void setCustomCondition(ReportConditionSubsidiaryLedger condition) throws BOSException {
        if (condition == null) {
            return;
        }
        this.rbnQueryByPeriod.setSelected(condition.isByPeriod());
        this.setSpinnerValueInRange(this.spnPeriodYearBegin, condition.getPeriodYearStart());
        this.setSpinnerValueInRange(this.spnPeriodNumberBegin, condition.getPeriodNumberStart());
        this.setSpinnerValueInRange(this.spnPeriodYearEnd, condition.getPeriodYearEnd());
        this.setSpinnerValueInRange(this.spnPeriodNumberEnd, condition.getPeriodNumberEnd());
        this.prbAccountBegin.setValue(condition.getAccountViewStart() == null ? condition.getAccountCodeStart() : condition.getAccountViewStart());
        String accountEnd = condition.getAccountCodeEnd();
        if (accountEnd != null && accountEnd.endsWith("z")) {
            accountEnd = accountEnd.substring(0, accountEnd.length() - 1);
        }
        this.prbAccountEnd.setValue(condition.getAccountViewEnd() == null ? accountEnd : condition.getAccountViewEnd());
        this.spnAccountLevelBegin.setValue((Object)new Integer(condition.getAccountLevelStart()));
        this.spnAccountLevelEnd.setValue((Object)new Integer(condition.getAccountLevelEnd()));
        String currencyId = condition.getCurrencyID();
        if (currencyId != null && currencyId.length() > 0) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                Object objectCurrency = this.cmbCurrency.getItemAt(i);
                if (objectCurrency instanceof CurrencyInfo) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)objectCurrency;
                    if (currencyInfo == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                    this.cmbCurrency.setSelectedIndex(i);
                    break;
                }
                if (!GLResUtil.getRes("all_currency").equals((String)objectCurrency)) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkOpOnlyLeaf.setSelected(condition.getOptionOnlyLeaf());
        this.chkOpAmountZero.setSelected(condition.getOptionAmountZero());
        this.chkOpBalanceAndAmountZero.setSelected(condition.getOptionBalanceAndAmountZero());
        this.jcbNoDisplayZeroTotal.setSelected(condition.getOptionNoDisplayZeroTotal());
        this.chkOpNotUsed.setSelected(condition.getOptionNotUsed());
        this.chkOpOtherAccount.setSelected(condition.getOptionOtherAccount());
        this.chkOpOtherAccountItem.setSelected(condition.getOptionOtherAccountItem());
        this.chkOpShowBusinessDate.setSelected(condition.getOptionShowBusinessDate());
        this.chkOpOnlyAsst.setSelected(condition.getOptionOnlyAsst());
        this.chkOpDailyTotal.setSelected(condition.getOptionDailyTotal());
        this.chkNotIncluePLVoucher.setSelected(condition.getOptionNotIncludePLVoucher());
        this.chkOpAccountCusAttribute.setSelected(condition.getOptionShowAccountCusAttribute());
        if (condition.getOptionOnlyAsst() || condition.getOptionShowAccountCusAttribute()) {
            this.showQueryItems(true);
        } else {
            this.showQueryItems(false);
        }
        if (condition.getOptionShowAccountCusAttribute()) {
            this.showQueryItemsForZDY(true);
        } else {
            this.showQueryItemsForZDY(false);
        }
    }

    public void setSpinnerValueInRange(KDSpinner spinner, int value) {
        if (spinner == null) {
            return;
        }
        SpinnerNumberModel yearBeginModel = (SpinnerNumberModel)spinner.getModel();
        Integer max = (Integer)yearBeginModel.getMaximum();
        Integer min = (Integer)yearBeginModel.getMinimum();
        int newValue = value;
        if (max != null && max < newValue) {
            newValue = max;
        }
        if (min != null && min > newValue) {
            newValue = min;
        }
        spinner.setValue((Object)new Integer(newValue));
    }

    public String getAccountCodeFromPromptBox(KDBizPromptBox prbAccount) {
        Object object;
        String accountCode = null;
        if (prbAccount != null && (object = prbAccount.getValue()) != null) {
            String strNumber;
            if (object instanceof String && (strNumber = (String)object) != null && strNumber.trim().length() > 0) {
                accountCode = strNumber.trim();
            }
            if (object instanceof AccountViewInfo) {
                AccountViewInfo account = (AccountViewInfo)object;
                accountCode = account.getNumber();
            }
        }
        return accountCode;
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        list.add("CurrentCompany");
        list.add("PeriodRangeAll");
        return list;
    }

    public void setInitData(Map initData) throws ReportException {
        CurrencyInfo defaultCurrency;
        this.loading = true;
        this.initDataUsingForClear = initData;
        this.company = (CompanyOrgUnitInfo)initData.get("CurrentCompany");
        try {
            this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)true);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        Integer maxLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelStartModel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevelBegin.setModel((SpinnerModel)levelStartModel);
            SpinnerNumberModel levelEndModel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevelEnd.setModel((SpinnerModel)levelEndModel);
            SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
        }
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        this.cmbCurrency.removeAllItems();
        CurrencyCollection currencyCollection = (CurrencyCollection)initData.get("AllCurrency");
        if (currencyCollection != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                CurrencyInfo currency = currencyCollection.get(i);
                if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    this.cmbCurrency.addItem((Object)currency);
                }
                if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    generalLocalCurrency = currency;
                }
                if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                generalRptCurrency = currency;
            }
            if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                this.cmbCurrency.addItem(generalLocalCurrency);
            }
            if (generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                this.cmbCurrency.addItem(generalRptCurrency);
            }
            if (!GlUtils.isCompanyUnion(this.company)) {
                this.cmbCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
            }
        }
        if ((defaultCurrency = (CurrencyInfo)initData.get("DefaultCurrency")) != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)defaultCurrency);
        }
        AccountTableInfo accountTable = this.company.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.company.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), this.spnPeriodYearEnd.getIntegerVlaue().intValue(), this.spnPeriodNumberEnd.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = RptClientUtil.periodCheckForAccountRefContrast(ar, this.spnPeriodYearEnd.getIntegerVlaue(), this.spnPeriodNumberEnd.getIntegerVlaue()) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter);
        this.prbAccountBegin.setEditable(true);
        this.prbAccountBegin.setEditFormat("$number$");
        this.prbAccountBegin.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountBegin.setDisplayFormat("$number$ - $name$");
        this.prbAccountBegin.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountBegin.setEnabledMultiSelection(true);
        this.prbAccountBegin.setSelector((KDPromptSelector)apb);
        this.prbAccountEnd.setEditFormat("$number$");
        this.prbAccountEnd.setCommitFormat("$helpCode$;$number$;$name$");
        this.prbAccountEnd.setDisplayFormat("$number$ - $name$");
        this.prbAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prbAccountEnd.setEnabledMultiSelection(true);
        this.prbAccountEnd.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.prbAccountBegin.setEntityViewInfo(myevi);
        this.prbAccountEnd.setEntityViewInfo(myevi);
        this.loading = false;
    }

    @Override
    protected void prbAccountEnd_dataChanged(DataChangeEvent e) throws Exception {
        String[] accountValue;
        String strAccountNumber;
        int i;
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)this.company);
        BOSUuid companyId = this.company.getId();
        BOSUuid accountTableId = this.company.getAccountTable().getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ObjectUuidPK accountTablePK = new ObjectUuidPK(accountTableId);
        if (!(this.prbAccountBegin.getValue() instanceof Object[]) || !(this.prbAccountEnd.getValue() instanceof Object[])) {
            return;
        }
        Object[] accountFrom = (Object[])this.prbAccountBegin.getValue();
        Object[] accountTo = (Object[])this.prbAccountEnd.getValue();
        int l = 1;
        int j = 1;
        int t = 1;
        if (accountFrom != null) {
            for (i = 0; i < accountFrom.length && accountFrom[i] != null; ++i) {
                String accountNumberNameFrom = accountFrom[i].toString();
                if (accountNumberNameFrom == null || (l = AccountUtils.getAccountViewCByNumber((String)(strAccountNumber = (accountValue = accountNumberNameFrom.split(" "))[0]), (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel()) <= t) continue;
                t = l;
            }
            l = t;
        }
        if (accountTo != null) {
            t = 1;
            for (i = 0; i < accountTo.length && accountTo[i] != null; ++i) {
                String accountNumberNameTo = accountTo[i].toString();
                if (accountNumberNameTo == null || (j = AccountUtils.getAccountViewCByNumber((String)(strAccountNumber = (accountValue = accountNumberNameTo.split(" "))[0]), (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel()) <= t) continue;
                t = j;
            }
            j = t;
        }
        Integer k = l > j ? new Integer(l) : new Integer(j);
        this.spnAccountLevelEnd.setValue((Object)k);
    }

    @Override
    protected void prbAccountBegin_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.prbAccountBegin.getValue();
        Object accountTo = this.prbAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            if (accountFrom instanceof Object[]) {
                Object[] accounts = (Object[])accountFrom;
                for (int i = 0; i < accounts.length; ++i) {
                    if (accounts[i] != null) continue;
                    return;
                }
            }
            this.prbAccountEnd.setValue(accountFrom);
        } else {
            this.prbAccountEnd_dataChanged(e);
        }
    }

    public void setPeriodEntity(CompanyOrgUnitInfo com) throws ReportException {
        this.loading = true;
        try {
            this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)com);
            SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.spnPeriodYearBegin, (KDSpinner)this.spnPeriodNumberBegin, (KDSpinner)this.spnPeriodYearEnd, (KDSpinner)this.spnPeriodNumberEnd, (boolean)true);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setParam(Object param) throws BOSException {
        if (this.isQueryByOther && this.isCleared) {
            this.isQueryByOther = false;
        }
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionSubsidiaryLedger((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        Integer beginLevel = (Integer)this.spnAccountLevelBegin.getValue();
        Integer endLevel = (Integer)this.spnAccountLevelEnd.getValue();
        if (beginLevel != null && endLevel != null && beginLevel > endLevel) {
            MsgBox.showInfo((Component)this.spnAccountLevelBegin, (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"18_ReportSubsidiaryLedgerConditionUI"));
            return false;
        }
        int yearEnd = (Integer)this.spnPeriodYearEnd.getValue();
        return !RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnPeriodYearBegin.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodNumberBegin.getValue()).intValue());
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYearBegin.getEditor()).getTextField();
    }

    public void clear() {
        super.clear();
        this.isCleared = true;
        if (this.isQueryByOther) {
            this.isQueryByOther = false;
            return;
        }
        try {
            this.setInitData(this.initDataUsingForClear);
        }
        catch (ReportException e) {
            logger.error((Object)e);
            this.handUIException((Throwable)((Object)e));
        }
        this.spnAccountLevelBegin.setValue((Object)new Integer(1));
        this.spnAccountLevelEnd.setValue((Object)new Integer(1));
        this.prbAccountBegin.setValue(null);
        this.prbAccountEnd.setValue(null);
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkOpAmountZero.setSelected(false);
        this.chkOpOnlyLeaf.setSelected(false);
        this.chkOpBalanceAndAmountZero.setSelected(false);
        this.chkOpNotUsed.setSelected(false);
        this.chkOpShowBusinessDate.setSelected(false);
        this.chkOpOtherAccount.setSelected(false);
        this.chkOpOtherAccountItem.setSelected(false);
        this.chkOpShowQuantity.setSelected(false);
        this.chkOpOnlyAsst.setSelected(false);
        this.chkOpDailyTotal.setSelected(false);
        this.jcbNoDisplayZeroTotal.setSelected(false);
        this.chkNotIncluePLVoucher.setSelected(false);
        this.chkOpAccountCusAttribute.setSelected(false);
        try {
            this.showQueryItems(false);
            this.showQueryItemsForZDY(false);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void showQueryItems(boolean isShowItem) throws BOSException {
        String[] QueryItemsForRemove = new String[]{"assistRecords.description", "assistRecords.originalAmount", "assistRecords.localAmount", "assistRecords.reportingAmount", "assistRecords.quantity"};
        RptClientUtil.showCommonQueryItems(this.getCommonQueryPanel(), QueryItemsForRemove, isShowItem);
    }

    private void showQueryItemsForZDY(boolean isShowItem) throws BOSException {
        String[] QueryItemsForRemove = new String[]{"assistRecords.settlementCode", "settlementType.number"};
        RptClientUtil.showCommonQueryItems(this.getCommonQueryPanel(), QueryItemsForRemove, isShowItem);
    }

    public boolean isIsQueryByOther() {
        return this.isQueryByOther;
    }

    public void setIsQueryByOther(boolean b) {
        this.isQueryByOther = b;
    }
}

