/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.ReportConditionTrialBalance;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractReportTrialBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ReportTrialBalanceConditionUI
extends AbstractReportTrialBalanceConditionUI {
    boolean loading = false;
    CurrencyInfo defaultCurrency;
    private int currYear = 0;
    private int currMonth = 0;

    public ReportConditionTrialBalance getCustomCondition() {
        ReportConditionTrialBalance condition = new ReportConditionTrialBalance();
        condition.setPeriodYearStart((Integer)this.spnPeriodYear.getValue());
        condition.setPeriodNumberStart((Integer)this.spnPeriodNumber.getValue());
        condition.setAccountLevelStart((Integer)this.spnAccountLevel.getValue());
        CurrencyInfo currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        if (currency != null) {
            if (currency.getId() != null) {
                condition.setCurrencyID(currency.getId().toString());
            } else {
                condition.setCurrencyID(currency.getNumber());
            }
            condition.setCurrencyName(currency.getName());
        }
        condition.setOptionPosting(this.chkOpIncludeNotPosting.isSelected());
        condition.setOptionOnlyLeaf(this.chkOpOnlyLeaf.isSelected());
        condition.setIncludeBWAccount(this.chkIncludeBW.isSelected());
        return condition;
    }

    public void setCustomCondition(ReportConditionTrialBalance condition) {
        if (condition == null) {
            return;
        }
        this.spnPeriodYear.setValue((Object)new Integer(condition.getPeriodYearStart()));
        this.spnPeriodNumber.setValue((Object)new Integer(condition.getPeriodNumberStart()));
        this.spnAccountLevel.setValue((Object)new Integer(condition.getAccountLevelStart()));
        String currencyId = condition.getCurrencyID();
        if (currencyId != null && currencyId.length() > 0) {
            for (int i = 0; i < this.cmbCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(i);
                if (currencyInfo == null || !currencyId.equals(currencyInfo.getId().toString()) && !currencyId.equals(currencyInfo.getNumber())) continue;
                this.cmbCurrency.setSelectedIndex(i);
                break;
            }
        }
        this.chkOpIncludeNotPosting.setSelected(condition.getOptionPosting());
        this.chkOpOnlyLeaf.setSelected(condition.getOptionOnlyLeaf());
        this.chkIncludeBW.setSelected(condition.getIncludeBWAccount());
    }

    public static Collection getInitDataItem() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("AllCurrency");
        list.add("CurrentPeriod");
        list.add("MaxAccountLevel");
        list.add("PeriodRange");
        list.add("DefaultCurrency");
        return list;
    }

    public void setInitData(Map initData) throws ReportException {
        CurrencyCollection currencyCollection;
        this.loading = true;
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            this.currYear = pe.getCurrentYear();
            this.currMonth = pe.getCurrentPeriod();
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (KDSpinner)this.spnPeriodYear, (KDSpinner)this.spnPeriodNumber, (boolean)false);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        Integer maxLevel = (Integer)initData.get("MaxAccountLevel");
        if (maxLevel != null) {
            SpinnerNumberModel levelModel = new SpinnerNumberModel(1, 1, maxLevel, 1);
            this.spnAccountLevel.setModel((SpinnerModel)levelModel);
        }
        if ((currencyCollection = (CurrencyCollection)initData.get("AllCurrency")) != null) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.cmbCurrency.addItem((Object)currencyCollection.get(i));
            }
        }
        this.defaultCurrency = (CurrencyInfo)initData.get("DefaultCurrency");
        if (this.defaultCurrency != null) {
            EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cmbCurrency, (ObjectBaseInfo)this.defaultCurrency);
        }
        this.loading = false;
    }

    @Override
    protected void chkOpOnlyLeaf_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOpOnlyLeaf_itemStateChanged(e);
        this.spnAccountLevel.setEnabled(!((KDCheckBox)e.getSource()).isSelected());
    }

    public Object getParam() {
        return this.getCustomCondition().toMap();
    }

    public void setParam(Object param) {
        if (param != null) {
            try {
                this.setCustomCondition(new ReportConditionTrialBalance((Map)param));
            }
            catch (CloneNotSupportedException ex) {
                this.handUIException(ex);
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Component getFocusComponent() {
        return ((KDSpinner.DefaultNumberEditor)this.spnPeriodYear.getEditor()).getTextField();
    }

    public void clear() {
        super.clear();
        this.chkOpIncludeNotPosting.setSelected(false);
        this.chkOpOnlyLeaf.setSelected(false);
        this.chkIncludeBW.setSelected(false);
        this.spnPeriodYear.setValue((Object)new Integer(this.currYear));
        this.spnPeriodNumber.setValue((Object)new Integer(this.currMonth));
        this.spnAccountLevel.setValue((Object)new Integer(1));
        if (this.defaultCurrency != null) {
            this.cmbCurrency.setSelectedItem((Object)this.defaultCurrency);
        }
    }
}

