/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLReportTrialBalanceFactory;
import com.kingdee.eas.fi.gl.IGLReport;
import com.kingdee.eas.fi.gl.ReportConditionTrialBalance;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.client.AbstractReportTrialBalanceUI;
import com.kingdee.eas.fi.gl.client.ReportTrialBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.ReportTrialBalanceParame;
import com.kingdee.eas.fi.gl.client.ReportTrialBalanceTaoda;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReportTrialBalanceUI
extends AbstractReportTrialBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(ReportTrialBalanceUI.class);
    CommonQueryDialog conditionDialog = null;
    ReportTrialBalanceConditionUI conditionPanel = null;
    ReportTrialBalanceParame editParame = null;
    boolean isResultBalance = false;
    protected static final String RESULT_BALANCE_TEXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportTrialBalanceUI", (String)"ResultBalance");
    protected static final String RESULT_NOT_BALANCE_TEXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportTrialBalanceUI", (String)"ResultNotBalance");
    protected static final String RESULT_BALANCE_BN_TEXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportTrialBalanceUI", (String)"ResulBalanceBN");
    protected static final String RESULT_NOT_BALANCE_BN_TEXT = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportTrialBalanceUI", (String)"ResultNotBalanceBN");

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initMenuItemButton();
        this.menuItemPrintParame.setEnabled(true);
        this.editParame = ReportTrialBalanceParame.getInstance();
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.menuItemPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.menuItemPrintView.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemPrintParame.setVisible(false);
        this.actionBalance.setVisible(false);
        this.menuItemShowPL.setVisible(false);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintView);
        this.menuFile.add((JMenuItem)this.menuItemPrintParame);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuView.add((JMenuItem)this.menuItemFilter);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    private void initMenuItemButton() {
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnBalance.setIcon(EASResource.getIcon((String)"imgTbtn_trialbalance"));
    }

    @Override
    protected Collection getInitList() {
        Collection list = ReportTrialBalanceConditionUI.getInitDataItem();
        list.add("DefaultTableHead");
        list.add("CurrentCompany");
        return list;
    }

    @Override
    protected IGLReport getRemoteInstance() throws BOSException {
        return GLReportTrialBalanceFactory.getRemoteInstance();
    }

    @Override
    protected void query(EntityViewInfo mainQuery) throws Exception {
        ReportConditionTrialBalance condition = ((ReportTrialBalanceConditionUI)this.getConditionPanel()).getCustomCondition();
        mainQuery.put("GLFixCondition", (Object)condition);
        int yearEnd = condition.getPeriodYearStart();
        int numberEnd = condition.getPeriodNumberStart();
        this.getUIContext().put("company", RptClientUtil.getCompany(yearEnd, numberEnd));
        this.setCondition(mainQuery);
        this.lblPeriod.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPeriodExtraRes", (String)"PREPERIOD") + this.getPeriodTitle(condition.getPeriodYearStart(), condition.getPeriodNumberStart(), condition.getPeriodYearStart(), condition.getPeriodNumberStart()));
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportPeriodExtraRes", (String)"PRECURRENCY"));
        sb.append(condition.getCurrencyName());
        this.lblCurrency.setText(sb.toString());
        this.tblMain.removeRows();
    }

    @Override
    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ReportTrialBalanceConditionUI();
            this.conditionPanel.setInitData(this.getInitData());
        }
        return this.conditionPanel;
    }

    @Override
    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.conditionDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setTitle(this.getConditionPanel().getUITitle());
            this.conditionDialog.setMaxReturnCountVisible(false);
        }
        return this.conditionDialog;
    }

    @Override
    protected boolean isNeedUpdateTableColumnVisible() {
        return true;
    }

    @Override
    protected void showResult(ReportResultInfo result, KDTable tableForShowResult, int startRow) {
        super.showResult(result, tableForShowResult, startRow);
        if (startRow == 0) {
            Boolean isBalance = (Boolean)result.getExtendData().get("TrialBalance");
            this.isResultBalance = isBalance != null && isBalance != false;
            this.setShowMessagePolicy(2);
            this.showMessage();
        }
    }

    protected Color getMessageBgcolor() {
        return this.isResultBalance ? SHOW_MESSAGE_BG_OK : SHOW_MESSAGE_BG_ERROR;
    }

    protected Icon getMessageIcon() {
        return SHOW_MESSAGE_ICON_DEFAULT;
    }

    @Override
    protected String getMessageText() {
        String resultBalanceText = RESULT_BALANCE_TEXT;
        String resultNotBalanceText = RESULT_BALANCE_BN_TEXT;
        ReportConditionTrialBalance condition = (ReportConditionTrialBalance)this.getCondition().get("GLFixCondition");
        if (condition != null) {
            if (condition.getIncludeBWAccount()) {
                resultBalanceText = RESULT_BALANCE_BN_TEXT;
                resultNotBalanceText = RESULT_NOT_BALANCE_BN_TEXT;
            } else {
                resultBalanceText = RESULT_BALANCE_TEXT;
                resultNotBalanceText = RESULT_NOT_BALANCE_TEXT;
            }
        }
        return this.isResultBalance ? resultBalanceText : resultNotBalanceText;
    }

    @Override
    protected boolean isNeedUpdateTableHead() {
        return true;
    }

    @Override
    public void actionMenuItemPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ReportTrialBalancePrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionShowPL_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ReportPLBalanceUI", (Map)uiContext, null, OprtState.EDIT);
        }
        catch (UIException e1) {
            logger.error((Object)e1);
            this.handUIException(e1);
        }
        uiWindow.show();
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        KDNoteHelper appHlp = new KDNoteHelper();
        ReportTrialBalanceTaoda rsprv = new ReportTrialBalanceTaoda();
        if (noPreview) {
            appHlp.print("/FI/GL/Account/ReportGeneralLedger", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/GL/Account/ReportGeneralLedger", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }
}

