/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLResource;
import com.kingdee.eas.fi.gl.client.AbstractRequisitionCheckTempletUI;
import com.kingdee.eas.fi.gl.client.CFRequisitionCorrelationFilterUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class RequisitionCheckTempletUI
extends AbstractRequisitionCheckTempletUI {
    private static final String UNSELECT_ROW = "UnselectRow";
    private static final Logger logger = CoreUIObject.getLogger(RequisitionCheckTempletUI.class);
    public static final String CFREQ_RES = "com.kingdee.eas.fi.gl.CFRequisitionResource";
    protected boolean isFirstLoad = false;
    public static final String REQ_TABLE_COLINDEX_ISCHECEKED = "isChecked";
    protected KDPanel conditionPanel = null;
    protected CommonQueryDialog conditionDialog = null;
    protected CompanyOrgUnitInfo curCompany = null;
    private boolean isFirstDefaultQuery = true;
    private IRow currentRow = null;
    private KDTable currentTable = null;

    protected void refresh() {
        this.refreshReceive();
        this.refreshSend();
    }

    protected abstract void refreshReceive();

    protected abstract void refreshSend();

    public void createCondition() {
        this.createSrcCondition();
        this.createTargCondition();
    }

    protected abstract void createSrcCondition();

    protected abstract void createTargCondition();

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        this.showConditionDialog();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refresh();
    }

    public final void showConditionDialog() {
        if (!SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"COMMUSTBEENTITY"));
            SysUtil.abort();
        }
        if (this.getConditionDialog().show()) {
            this.createCondition();
            this.refresh();
        } else {
            SysUtil.abort();
        }
    }

    protected abstract boolean isShowConditionDialog();

    protected CommonQueryDialog getConditionDialog() {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.conditionDialog.setShowFilter(true);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setTitle(this.getStandardFilterTitle(this.getFilterTitle()));
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(280);
            this.conditionDialog.addUserPanel(this.getConditionPanel());
            this.conditionDialog.setQueryObjectPK(this.getQueryObjectPK());
            this.conditionDialog.setParentUIClassName(this.getParentUIClassName());
            CommonQueryProcessor process = this.getProperCommonProcessor();
            process.set("parentDialog", (Object)this.conditionDialog);
            this.conditionDialog.setProcessor((IProcessor)process);
        }
        return this.conditionDialog;
    }

    protected CommonQueryProcessor getProperCommonProcessor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
            }
        };
    }

    protected abstract KDPanel getConditionPanel();

    protected abstract IMetaDataPK getQueryObjectPK();

    protected abstract String getParentUIClassName();

    protected abstract String getFilterTitle();

    private boolean showQueryDlg() throws Exception {
        boolean showDlg = true;
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
            String curUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String curCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryObjectPK()).getFullName();
            if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID)) {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID);
                QueryPanelCollection panels = solution.getQueryPanelInfo();
                QueryPanelInfo panel = null;
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    panel = panels.get(i);
                    if (panel == null || panel.getCustomerParams() == null || !panel.getPanelClassName().equals(this.getDefaultFilterUI().getMetaDataPK().getFullName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)panel.getCustomerParams());
                    this.getDefaultFilterUI().setCustomerParams(cp);
                    break;
                }
                this.getConditionDialog().init();
                this.createCondition();
                showDlg = false;
            }
        }
        if (showDlg) {
            this.showConditionDialog();
        }
        return true;
    }

    public CFRequisitionCorrelationFilterUI getDefaultFilterUI() {
        CFRequisitionCorrelationFilterUI filterUI = null;
        if (this.conditionPanel != null) {
            filterUI = (CFRequisitionCorrelationFilterUI)this.conditionPanel;
        }
        return filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ((CustomerQueryPanel)this.getConditionPanel()).onLoad();
        this.showQueryDlg();
        this.visibleWorkButton();
        this.enableWorkButton();
        this.initWorkMenu();
        this.visibleWorkMenu();
        this.enableWorkMenu();
    }

    protected String getStandardFilterTitle(String uiKey) {
        return uiKey + " - " + GLResource.getResourceString("ConditionFilter");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnFilter);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnCorrelation.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnCancelCorrelation.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.btnAutoCorrelation.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
    }

    protected void initWorkMenu() {
    }

    protected void visibleWorkButton() {
        this.btnFilter.setVisible(true);
        this.btnRefresh.setVisible(true);
        this.btnSelectAll.setVisible(true);
        this.btnClearAll.setVisible(true);
        this.btnCorrelation.setVisible(true);
        this.btnCancelCorrelation.setVisible(true);
        this.btnAutoCorrelation.setVisible(true);
    }

    protected void enableWorkButton() {
        this.btnFilter.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnCorrelation.setEnabled(true);
        this.btnCancelCorrelation.setEnabled(true);
        this.btnAutoCorrelation.setEnabled(true);
    }

    protected void enableWorkMenu() {
    }

    protected void visibleWorkMenu() {
    }

    protected void selectAll(boolean isSelected) {
        this.selectTable(this.getReceiveTable(), isSelected);
        this.selectTable(this.getSendTable(), isSelected);
    }

    protected abstract KDTable getReceiveTable();

    protected abstract KDTable getSendTable();

    public void selectTable(KDTable table, boolean isSelected) {
        if (table != null) {
            int rowCount = table.getExpandedRowCount();
            IRow row = null;
            ICell cell = null;
            Boolean b = new Boolean(isSelected);
            for (int i = 0; i < rowCount; ++i) {
                row = table.getRow(i);
                if (row == null || (cell = row.getCell("fischecked")) == null) continue;
                cell.setValue((Object)b);
            }
        }
    }

    public final Collection getSelectedReceiveItems(boolean isSelected) {
        KDTable receiveTab = this.getReceiveTable();
        int rowStartIndex = 0;
        int rowCount = receiveTab.getExpandedRowCount();
        IRow row = null;
        ICell cell = null;
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = rowStartIndex; i < rowCount; ++i) {
            row = receiveTab.getRow(i);
            cell = receiveTab.getCell(i, "fischecked");
            if (cell == null || cell.getValue() == null || Boolean.valueOf(cell.getValue().toString()) != Boolean.TRUE) continue;
            items.add(this.getSelectedReceiveItem(row));
        }
        return items;
    }

    public final Collection getSelectedSendItems(boolean isSelected) {
        KDTable sendTab = this.getSendTable();
        int rowStartIndex = 0;
        int rowCount = sendTab.getExpandedRowCount();
        IRow row = null;
        ICell cell = null;
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = rowStartIndex; i < rowCount; ++i) {
            row = sendTab.getRow(i);
            cell = sendTab.getCell(i, "fischecked");
            if (cell == null || cell.getValue() == null || Boolean.valueOf(cell.getValue().toString()) != Boolean.TRUE) continue;
            items.add(this.getSelectedSendItem(row));
        }
        return items;
    }

    protected abstract Object getSelectedReceiveItem(IRow var1);

    protected abstract Object getSelectedSendItem(IRow var1);

    protected IRow getCurrentRow() {
        if (this.currentRow == null) {
            MsgBox.showInfo((String)this.getResource(UNSELECT_ROW, null));
            SysUtil.abort();
        }
        return this.currentRow;
    }

    protected KDTable getCurrentTable() {
        return this.currentTable;
    }

    protected void setCurrentRow(IRow row) {
        this.currentRow = row;
    }

    protected void setCurrentTable(KDTable table) {
        this.currentTable = table;
    }

    protected String getResource(String key, Object[] params) {
        String message = ResourceBase.getString((String)CFREQ_RES, (String)key, (Locale)SysContext.getSysContext().getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

