/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.account.client.FilterForAccountF7UI;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.client.AbstractRptAccAsstactConditionUI;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.client.GeneralBizPromptBox;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAccAsstactConditionUI
extends AbstractRptAccAsstactConditionUI {
    private static final long serialVersionUID = -3172131850899821827L;
    private static final Logger logger = CoreUIObject.getLogger(RptAccAsstactConditionUI.class);
    private int currYear;
    private int currMonth;
    private CompanyOrgUnitInfo company;
    private RptParams initParams;
    private AccountRefContrastInfo lastAcctInfo;
    private boolean assistFromOrToChange = false;
    private HashMap accountMap = new HashMap();
    private Set hashAccountIdSet;
    private HashMap<String, AccountTableInfo> accTable = new HashMap();

    public RptAccAsstactConditionUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getColumn("selected").getStyleAttributes().setLocked(false);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonSorterPanel", (String)"moveUp"));
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonSorterPanel", (String)"moveDown"));
        this.setSize(520, 430);
        this.jspYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAccAsstactConditionUI.this.spnPeriodYearEnd_stateChanged(e);
            }
        });
        this.jcbShowOnlySubAccountview.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptAccAsstactConditionUI.this.jspLevelFrom.setEnabled(false);
                    RptAccAsstactConditionUI.this.jspLevelTo.setEnabled(false);
                } else {
                    RptAccAsstactConditionUI.this.jspLevelFrom.setEnabled(true);
                    RptAccAsstactConditionUI.this.jspLevelTo.setEnabled(true);
                }
            }
        });
        this.rtnAccountRow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAccAsstactConditionUI.this.sumByAsstactLevel.setSelected(false);
                RptAccAsstactConditionUI.this.sumByAsstactLevel.setEnabled(RptAccAsstactConditionUI.this.rtnAccountRow.isSelected());
            }
        });
    }

    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) {
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        this.changeAccountFilter();
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        String asstAccountId = null;
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        Object value = this.jebAcct.getValue();
        if (value != null) {
            AsstAccountInfo aai = (AsstAccountInfo)value;
            asstAccountId = aai.getId().toString();
        }
        try {
            List list = RptClientUtil.queryAsstAct(asstAccountId, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
            if (list != null && value == null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                    at.setSelected(false);
                }
            }
            this.setTableData(list);
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        this.changeAccountFilter();
    }

    @Override
    protected void jebAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.jebAccountFrom.getValue();
        Object accountTo = this.jebAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.jebAccountTo.setValue(accountFrom);
        } else {
            this.jebAccountTo_dataChanged(e);
        }
        this.hashAccountIdSet = null;
    }

    @Override
    protected void jebAccountTo_dataChanged(DataChangeEvent e) throws Exception {
        AccountViewInfo account;
        String strAccountNumber;
        String[] accountValue;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        Object accountFrom = this.jebAccountFrom.getValue();
        Object accountTo = this.jebAccountTo.getValue();
        int i = 1;
        int j = 1;
        if (accountFrom != null) {
            accountValue = accountFrom.toString().split(" ");
            strAccountNumber = accountValue[0];
            if (this.accountMap.get(strAccountNumber) == null) {
                account = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (CompanyOrgUnitInfo)company);
                this.accountMap.put(strAccountNumber, account);
            } else {
                account = (AccountViewInfo)this.accountMap.get(strAccountNumber);
            }
            if (account != null) {
                i = account.getLevel();
            }
        }
        if (accountTo != null) {
            accountValue = accountTo.toString().split(" ");
            strAccountNumber = accountValue[0];
            if (this.accountMap.get(strAccountNumber) == null) {
                account = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (CompanyOrgUnitInfo)company);
                this.accountMap.put(strAccountNumber, account);
            } else {
                account = (AccountViewInfo)this.accountMap.get(strAccountNumber);
            }
            if (account != null) {
                j = account.getLevel();
            }
        }
        this.jspLevelFrom.setValue((Object)Math.min(i, j));
        this.jspLevelTo.setValue((Object)Math.max(i, j));
        this.hashAccountIdSet = null;
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    protected void setUIContextInitParams(RptParams aParams) {
        this.initParams = aParams;
    }

    protected RptParams getUIContextInitParams() {
        return this.initParams;
    }

    public void onInit(RptParams initParams) throws Exception {
        this.company = (CompanyOrgUnitInfo)initParams.getObject("company");
        this.jebAccountFrom.setEnabled(false);
        this.jebAccountTo.setEnabled(false);
        this.btnAccountDiscrete.setEnabled(false);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 ");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.company.getAccountTable(), filter);
        this.jebAccountFrom.setEditable(true);
        this.jebAccountFrom.setEditFormat("$number$");
        this.jebAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountFrom.setDisplayFormat("$number$ - $name$");
        this.jebAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountFrom.setCommitParser((IParser)new AccountViewParser(this.jebAccountFrom));
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setEditable(true);
        this.jebAccountTo.setEditFormat("$number$");
        this.jebAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountTo.setDisplayFormat("$number$ - $name$");
        this.jebAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountTo.setCommitParser((IParser)new AccountViewParser(this.jebAccountTo));
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.jebAccountFrom.setEntityViewInfo(myevi);
        this.jebAccountTo.setEntityViewInfo(myevi);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        int maxLevel = initParams.getInt("maxLevel");
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currency");
        this.lastAcctInfo = (AccountRefContrastInfo)initParams.getObject("lastAcctInfo");
        PeriodEntity pe = (PeriodEntity)initParams.getObject("pe");
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false, (boolean)false);
        if (maxLevel != 0) {
            this.fillAccLevelSpinner(maxLevel);
        }
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.jbxCurrency, cc, SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency(), SysContext.getSysContext().getCurrentFIUnit(), (RptParams)initParams.getObject("sysParams"));
        int selectMode = 15;
        try {
            Object GL_125 = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_125");
            if ("1".equals(GL_125)) {
                selectMode = 10;
            }
        }
        catch (Exception e) {
            logger.info((Object)"\uff08ReportBaseUI.java\uff09\u8001\u8d26\u8868\u83b7\u53d6\u53c2\u6570GL_125\u9519\u8bef\u3002");
        }
        this.tbl.getSelectManager().setSelectMode(selectMode);
        this.tbl.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tbl.getColumn("selected").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                RptAccAsstactConditionUI.this.tblEditStopped(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                RptAccAsstactConditionUI.this.storeAsstactTypeEntityFields(e);
                if (e.getColIndex() == RptAccAsstactConditionUI.this.tbl.getColumnIndex("selected")) {
                    RptAccAsstactConditionUI.this.tbl.getCell(e.getRowIndex(), "selected").setValue(e.getValue());
                    RptAccAsstactConditionUI.this.changeAccountFilter();
                }
            }
        });
        this.jcbNoDisplayAllZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAccAsstactConditionUI.this.jcbNoDisplayZero.setSelected(false);
                    RptAccAsstactConditionUI.this.chkOpBalanceZero.setSelected(false);
                }
            }
        });
        this.jcbNoDisplayZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAccAsstactConditionUI.this.jcbNoDisplayAllZero.setSelected(false);
                    RptAccAsstactConditionUI.this.chkOpBalanceZero.setSelected(false);
                }
            }
        });
        this.chkOpBalanceZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptAccAsstactConditionUI.this.jcbNoDisplayZero.setSelected(false);
                    RptAccAsstactConditionUI.this.jcbNoDisplayAllZero.setSelected(false);
                }
            }
        });
        this.btnAccountDiscrete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptAccAsstactConditionUI.this.action_showHashAccount();
                }
                catch (Exception ex) {
                    RptAccAsstactConditionUI.this.handUIException(ex);
                }
            }
        });
    }

    protected void action_showHashAccount() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        FilterInfo filterInfo = this.getHashAccountFilter();
        uiContext.put((Object)"filter", (Object)filterInfo);
        uiContext.put((Object)"selectedAccountIdSet", (Object)this.hashAccountIdSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FilterForAccountF7UI.class.getName(), (Map)uiContext);
        if (uiWindow instanceof KDDialog) {
            ((KDDialog)uiWindow).setResizable(true);
        }
        FilterForAccountF7UI filterUI = (FilterForAccountF7UI)uiWindow.getUIObject();
        filterUI.getUIWindow().show();
        if (filterUI.isCancel()) {
            return;
        }
        this.hashAccountIdSet = filterUI.getData();
        int maxLevel = GLGeneralFacadeFactory.getRemoteInstance().getMaxHashAccountLevel(this.hashAccountIdSet);
        this.jspLevelFrom.setValue((Object)1);
        this.jspLevelTo.setValue((Object)Math.max(maxLevel, 1));
    }

    protected FilterInfo getCAAFilter() {
        List list = this.getTableData();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        AccountTableInfo table = null;
        String accTableKey = this.company.getId().toString() + yearEnd + numberEnd;
        if (this.accTable.containsKey(accTableKey)) {
            table = this.accTable.get(accTableKey);
        } else {
            try {
                AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.company.getId().toString(), this.company.getAccountTable().getId().toString(), yearEnd, numberEnd);
                if (ar != null) {
                    AccountTableInfo newAccountTable;
                    PeriodInfo period = PeriodUtils.getPeriodInfo((int)yearEnd, (int)numberEnd, (CompanyOrgUnitInfo)this.company);
                    AccountTableInfo accountTableInfo = newAccountTable = period != null && RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
                    if (newAccountTable != null) {
                        table = newAccountTable;
                        this.accTable.put(accTableKey, newAccountTable);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (table == null) {
            table = this.company.getAccountTable();
        }
        fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
        Object value = this.jebAcct.getValue();
        if (value != null) {
            fic.add(new FilterItemInfo("CAA.id", (Object)((AsstAccountInfo)value).getId()));
            filter.setMaskString("#0 and #1 and #2 ");
        } else {
            filter.setMaskString("#0 and #1 ");
        }
        for (int i = 0; i < list.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (at.isSelected()) continue;
            list.remove(i);
            --i;
        }
        boolean hasSelected = list.size() > 0;
        HashMap<String, Integer> asstAccIds = null;
        if (value == null && hasSelected) {
            int from = fic.size();
            StringBuffer sf = new StringBuffer(filter.getMaskString());
            asstAccIds = new HashMap<String, Integer>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                sf.append(" and(");
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                int m = at.getAsstAccountCount();
                for (int j = 0; j < m; ++j) {
                    String asstAccountId;
                    asstAccIds.put(asstAccountId, asstAccIds.get(asstAccountId = at.getAsstAccountId(j)) == null ? 1 : (Integer)asstAccIds.get(asstAccountId) + 1);
                    fic.add(new FilterItemInfo("CAA.id", (Object)asstAccountId));
                    sf.append("#").append(from++);
                    if (j == m - 1) continue;
                    sf.append(" or ");
                }
                sf.append(')');
            }
            filter.setMaskString(sf.toString());
        }
        if (asstAccIds != null && asstAccIds.size() > 0) {
            this.setAsstAccountChangeFilter(filter, (Map<String, Integer>)asstAccIds);
        }
        return filter;
    }

    protected FilterInfo getHashAccountFilter() throws BOSException, EASBizException {
        String endAccountNumber;
        String startAccountNumber;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.company.getAccountTable().getId().toString()));
        if (this.jebAccountFrom.getValue() != null && (startAccountNumber = ((AccountViewInfo)this.jebAccountFrom.getValue()).getNumber()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startAccountNumber, CompareType.GREATER_EQUALS));
        }
        if (this.jebAccountTo.getValue() != null && (endAccountNumber = ((AccountViewInfo)this.jebAccountTo.getValue()).getNumber()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(endAccountNumber + 'Z'), CompareType.LESS_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
        FilterInfo filter1 = this.getCAAFilter();
        filter.mergeFilter(filter1, "AND");
        FilterInfo permissionFilterInfo = this.getAccountPermissionFilterInfo();
        if (permissionFilterInfo != null) {
            filter.mergeFilter(permissionFilterInfo, "AND");
        }
        return filter;
    }

    private FilterInfo getAccountPermissionFilterInfo() throws EASBizException, BOSException {
        String permissionSql;
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_account_accountView_view");
        FilterInfo permissionFilter = null;
        if (!StringUtils.isEmpty((String)rule) && (permissionSql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_account_accountView_view")) != null) {
            permissionFilter = new FilterInfo();
            permissionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)permissionSql, CompareType.INNER));
            this.filterInfo.mergeFilter(permissionFilter, "and");
        }
        return permissionFilter;
    }

    protected void tblEditStopped(KDTEditEvent e) {
        if (e.getColIndex() == this.tbl.getColumnIndex("selected")) {
            this.tbl.getCell(e.getRowIndex(), 0).setValue(e.getValue());
            boolean isSelect = (Boolean)e.getValue();
            if (isSelect) {
                Object objTo;
                IRow row = this.tbl.getRow(e.getRowIndex());
                this.addF7(row, (AsstactTypeEntity)row.getUserObject());
                Object objFrom = row.getCell("from").getValue();
                if (objFrom != null && !(objFrom instanceof IObjectValue)) {
                    row.getCell("from").setValue(null);
                }
                if ((objTo = row.getCell("to").getValue()) != null && !(objTo instanceof IObjectValue)) {
                    row.getCell("to").setValue(null);
                }
            } else {
                IRow row = this.tbl.getRow(e.getRowIndex());
                row.getCell("to").getStyleAttributes().setLocked(true);
                row.getCell("from").getStyleAttributes().setLocked(true);
            }
        }
        this.storeAsstactTypeEntityFields(e);
    }

    private void storeAsstactTypeEntityFields(KDTEditEvent e) {
        AsstactTypeEntity at = null;
        IRow row = null;
        if (e.getColIndex() == this.tbl.getColumn("selected").getColumnIndex()) {
            row = this.tbl.getRow(e.getRowIndex());
            at = (AsstactTypeEntity)row.getUserObject();
            if (at == null) {
                return;
            }
            at.setSelected((Boolean)e.getValue());
        }
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            if (at == null) continue;
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean selected = false;
            if (row.getCell("selected").getValue() != null) {
                selected = (Boolean)row.getCell("selected").getValue();
            }
            at.setSelected(selected);
        }
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        row.getCell("to").getStyleAttributes().setLocked(false);
        row.getCell("from").getStyleAttributes().setLocked(false);
        row.getCell("dist").getStyleAttributes().setLocked(false);
        KDBizPromptBox toBizPromptBox = new KDBizPromptBox();
        toBizPromptBox.setEditable(true);
        toBizPromptBox.setEditFormat("$number$");
        toBizPromptBox.setCommitFormat("$number$;$name$");
        toBizPromptBox.setDisplayFormat("$number$ - $name$");
        toBizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLongNumber() || at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        toBizPromptBox.setSelectorCollection(sic);
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(at.getHgAttribute());
        atInfo.setIsForCompany(at.isForCompany());
        atInfo.setUseLongNumber(at.isUseLongNumber());
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setUnUse(true);
        f7Param.setOnlyLeaf(true);
        if (at.getGeneralAsstactGroupId() != null && at.getGeneralAsstactGroupId().trim().length() > 0) {
            GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
            atInfo.setGlAsstActTypeGrp(groupInfo);
            f7Param.setGeneralShowLongNumber(at.isUseLongNumber());
        }
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)toBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])new CompanyOrgUnitInfo[]{this.company}, (GLF7Parameter)f7Param);
        toBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object from;
                    Object to;
                    AsstactTypeEntity asst;
                    int beginRow = RptAccAsstactConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAccAsstactConditionUI.this.tbl.getRow(beginRow);
                    KDBizPromptBox disBox = new KDBizPromptBox();
                    disBox.setEditFormat("$number$");
                    disBox.setDisplayFormat("$name$");
                    disBox.setCommitFormat("$number$");
                    disBox.setEditable(false);
                    KDBizPromptBox toBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = toBox.getEntityViewInfo() == null ? new FilterInfo() : toBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if ((to = e.getNewValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    if ((from = row.getCell("from").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    RptAccAsstactConditionUI.this.assistFromOrToChange = true;
                    RptAccAsstactConditionUI.this.loadDistBox(row, toBox, view);
                }
                catch (Exception exc) {
                    RptAccAsstactConditionUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)toBizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        KDBizPromptBox fromBizPromptBox = new KDBizPromptBox();
        fromBizPromptBox.setEditable(true);
        fromBizPromptBox.setEditFormat("$number$");
        fromBizPromptBox.setCommitFormat("$number$;$name$");
        fromBizPromptBox.setDisplayFormat("$number$ - $name$");
        fromBizPromptBox.setQueryInfo(at.getQueryName());
        fromBizPromptBox.setSelectorCollection(sic);
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)fromBizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo[])new CompanyOrgUnitInfo[]{this.company}, (GLF7Parameter)f7Param);
        fromBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    Object to;
                    Object from;
                    AsstactTypeEntity asst;
                    int beginRow = RptAccAsstactConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAccAsstactConditionUI.this.tbl.getRow(beginRow);
                    KDBizPromptBox disBox = new KDBizPromptBox();
                    disBox.setEditFormat("$number$");
                    disBox.setDisplayFormat("$name$");
                    disBox.setCommitFormat("$number$");
                    disBox.setEditable(false);
                    KDBizPromptBox fromBox = (KDBizPromptBox)e.getSource();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = fromBox.getEntityViewInfo() == null ? new FilterInfo() : fromBox.getEntityViewInfo().getFilter();
                    FilterInfo newFilter = new FilterInfo();
                    Object obj = row.getUserObject();
                    String compareExpr = "number";
                    if (obj instanceof AsstactTypeEntity && (asst = (AsstactTypeEntity)obj).isGeneralActType()) {
                        compareExpr = "longnumber";
                    }
                    if ((from = e.getNewValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.GREATER_EQUALS));
                    }
                    if ((to = row.getCell("to").getValue()) instanceof IObjectValue) {
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)to).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    } else if (from != null) {
                        row.getCell("to").setValue(from);
                        newFilter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)((IObjectValue)from).get(compareExpr).toString().replace("!", "."), CompareType.LESS_EQUALS));
                    }
                    newFilter.mergeFilter(filter, "and");
                    view.setFilter(newFilter);
                    RptAccAsstactConditionUI.this.assistFromOrToChange = true;
                    RptAccAsstactConditionUI.this.loadDistBox(row, fromBox, view);
                }
                catch (Exception exc) {
                    RptAccAsstactConditionUI.this.handUIException(exc);
                }
            }
        });
        editor = new KDTDefaultCellEditor((IKDEditor)fromBizPromptBox);
        row.getCell("from").setEditor((ICellEditor)editor);
        KDBizPromptBox disBox = this.loadDistBox(row, fromBizPromptBox, null);
    }

    private KDBizPromptBox loadDistBox(IRow row, KDBizPromptBox bizBox, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        disBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = RptAccAsstactConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAccAsstactConditionUI.this.tbl.getRow(beginRow);
                    Object dist = e.getNewValue();
                    if (dist == null) {
                        AsstactTypeEntity entry = (AsstactTypeEntity)row.getUserObject();
                        entry.setDist(null);
                        row.getCell("dist").setUserObject(null);
                    }
                }
                catch (Exception exc) {
                    RptAccAsstactConditionUI.this.handUIException(exc);
                }
            }
        });
        if (view == null && (view = bizBox.getEntityViewInfo()) != null) {
            view = (EntityViewInfo)view.clone();
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        disBox.setSelector((KDPromptSelector)new GeneralBizPromptBox(view, bizBox.getQueryInfo(), this.tbl, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI"));
        if (this.assistFromOrToChange) {
            row.getCell("dist").setValue(null);
            row.getCell("dist").setUserObject(null);
            this.assistFromOrToChange = false;
        }
        row.getCell("dist").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
        return disBox;
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object from = row.getCell("from").getValue();
        if (from != null && from instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.GREATER_EQUALS));
        }
        if ((to = row.getCell("to").getValue()) != null && to instanceof IObjectValue) {
            newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)to).get("number"), CompareType.LESS_EQUALS));
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        rcm.setProperty("tableData", (Object)this.getTableData());
        rcm.setProperty("tableDataHasChaged", (Object)Boolean.TRUE);
        if (!this.company.isIsBizUnit()) {
            rcm.setProperty("company", (Object)this.company);
        } else {
            rcm.setProperty("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        }
        rcm.setProperty("hashAccountIdSet", (Object)this.hashAccountIdSet);
        RptParams rpt = rcm.toRptParams();
        rpt.setBoolean("isAsstactRow", this.rtnAsstactRow.isSelected());
        return rpt;
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        if (params.getBoolean("isAsstactRow")) {
            this.rtnAsstactRow.setSelected(params.getBoolean("isAsstactRow"));
            this.sumByAsstactLevel.setSelected(false);
            this.sumByAsstactLevel.setEnabled(false);
        } else {
            this.rtnAccountRow.setSelected(true);
        }
        if (params.getObjectElement("jspLevelFrom.value") != null) {
            this.jspLevelFrom.setValue(params.getObjectElement("jspLevelFrom.value"));
        }
        if (params.getObjectElement("jspLevelTo.value") != null) {
            this.jspLevelTo.setValue(params.getObjectElement("jspLevelTo.value"));
        }
        if (params.getObjectElement("chkOpBalanceZero.value") != null) {
            this.chkOpBalanceZero.setSelected(((Boolean)params.getObjectElement("chkOpBalanceZero.value")).booleanValue());
        } else {
            this.chkOpBalanceZero.setSelected(false);
        }
        Object obj = params.getObjectElement("jbxCurrency.value");
        if (obj instanceof CurrencyInfo) {
            for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
                Object value = this.jbxCurrency.getItemAt(i);
                if (!(value instanceof CurrencyInfo) || !((CurrencyInfo)obj).getId().equals((Object)((CurrencyInfo)value).getId())) continue;
                this.jbxCurrency.setSelectedItem(value);
            }
        }
        if ((obj = params.getObjectElement("hashAccountIdSet")) instanceof Set) {
            this.hashAccountIdSet = (Set)obj;
        }
        this.setTableData((List)rcm.getProperty("tableData"));
    }

    public void setRptParams(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        if (params.getBoolean("isAsstactRow")) {
            this.rtnAsstactRow.setSelected(true);
        } else {
            this.rtnAccountRow.setSelected(true);
        }
        if (params.getObjectElement("jspLevelFrom.value") != null) {
            this.jspLevelFrom.setValue(params.getObjectElement("jspLevelFrom.value"));
        }
        if (params.getObjectElement("jspLevelTo.value") != null) {
            this.jspLevelTo.setValue(params.getObjectElement("jspLevelTo.value"));
        }
        this.setTableData((List)rcm.getProperty("tableData"));
        this.jebAcct.setValue(params.getObjectElement("jebAcct.value"));
        this.jebAccountFrom.setValue(params.getObjectElement("jebAccountFrom.value"));
        this.jebAccountTo.setValue(params.getObjectElement("jebAccountTo.value"));
    }

    private void changeAccountFilter() {
        List list = this.getTableData();
        boolean hasSelected = list.size() > 0;
        this.jebAccountFrom.setValue(null);
        this.jebAccountFrom.setEnabled(hasSelected);
        this.jebAccountTo.setValue(null);
        this.jebAccountTo.setEnabled(hasSelected);
        this.btnAccountDiscrete.setEnabled(hasSelected);
        FilterInfo filter = this.getCAAFilter();
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        String accTableKey = this.company.getId().toString() + yearEnd + numberEnd;
        AccountTableInfo table = this.accTable.containsKey(accTableKey) ? this.accTable.get(accTableKey) : this.company.getAccountTable();
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, table, filter);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        this.jebAccountFrom.setEntityViewInfo(entityViewInfo);
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setEntityViewInfo(entityViewInfo);
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
    }

    private void setAsstAccountChangeFilter(FilterInfo filter, Map<String, Integer> asstAccIds) {
        String asstAcctStr = null;
        if (asstAccIds != null && asstAccIds.size() > 0) {
            StringBuilder asstAccIdSb = new StringBuilder();
            int max = 1;
            for (Map.Entry<String, Integer> entry : asstAccIds.entrySet()) {
                Integer count = entry.getValue();
                String asstId = entry.getKey();
                if (count > max) {
                    max = count;
                    asstAccIdSb.setLength(0);
                    asstAccIdSb.append("'").append(asstId).append("',");
                    continue;
                }
                if (count != max) continue;
                asstAccIdSb.append("'").append(asstId).append("',");
            }
            if (asstAccIdSb.length() > 0) {
                asstAcctStr = asstAccIdSb.substring(0, asstAccIdSb.length() - 1);
            }
        }
        int startPeriodNum = (Integer)this.jspYearFrom.getValue() * 100 + (Integer)this.jspPeriodFrom.getValue();
        if (asstAcctStr != null && !"".equals(asstAcctStr.trim())) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ac.FACCOUNTID  FROM T_BD_AsstAccountChange ac inner join T_BD_ASSTACCOUNT ca ");
            sb.append("on ac.FBEFOREID = ca.FID  inner join T_BD_PERIOD bp on ac.FPERIODID = bp.FID inner join T_BD_ACCOUNTVIEW bd on ac.FACCOUNTID = bd.FID ");
            sb.append("where bd.FACCOUNTTABLEID ='").append(this.company.getAccountTable().getId().toString()).append("' and bd.FCOMPANYID='");
            sb.append(this.company.getId().toString()).append("'");
            sb.append(" and ca.fid in(").append(asstAcctStr).append(")");
            sb.append(" and bp.FNUMBER >=").append(startPeriodNum);
            try {
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
                filter.mergeFilter(filter1, "or");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
        }
    }

    private void setTableData(List list) {
        this.tbl.setRefresh(false);
        this.tbl.removeRows();
        if (list == null) {
            return;
        }
        boolean hasSelected = false;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            idSet.add(at.getId());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(fi);
        AsstActTypeCollection asstActColl = null;
        try {
            asstActColl = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        for (int i = 0; i < list.size(); ++i) {
            IRow row = this.tbl.addRow();
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            boolean isSelected = at.isSelected();
            if (isSelected) {
                this.addF7(row, at);
            } else {
                row.getCell("to").getStyleAttributes().setLocked(true);
                row.getCell("from").getStyleAttributes().setLocked(true);
            }
            row.setUserObject((Object)at);
            row.getCell("selected").setValue((Object)isSelected);
            AsstActTypeInfo asstActTypeInfo = this.findAsstActTypeInfo(asstActColl, at.getId());
            if (asstActTypeInfo != null) {
                row.getCell("type").setValue((Object)asstActTypeInfo.getName());
            }
            row.getCell("from").setValue(at.getFrom());
            row.getCell("to").setValue(at.getTo());
            Object dist = at.getDist();
            if (dist == null) continue;
            Set assists = (Set)dist;
            Iterator it = assists.iterator();
            String names = "";
            Object assist = null;
            while (it.hasNext()) {
                assist = it.next();
                if (assist instanceof AssistViewFilterInfo) {
                    names = names + ((AssistViewFilterInfo)assist).getName() + ";";
                    continue;
                }
                if (!(assist instanceof Map)) continue;
                names = names + ((Map)assist).get("name") + ";";
            }
            row.getCell("dist").setValue((Object)names);
            row.getCell("dist").setUserObject(dist);
        }
        if (hasSelected) {
            this.jebAccountFrom.setEnabled(true);
            this.jebAccountTo.setEnabled(true);
            this.btnAccountDiscrete.setEnabled(true);
        }
        this.tbl.setRefresh(true);
        this.tbl.updateUI();
    }

    private AsstActTypeInfo findAsstActTypeInfo(AsstActTypeCollection asstActCol, String id) {
        if (asstActCol == null || id == null || id.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < asstActCol.size(); ++i) {
            if (!BOSUuid.read((String)id).equals((Object)asstActCol.get(i).getId())) continue;
            return asstActCol.get(i);
        }
        return null;
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            at.setDist(row.getCell("dist").getUserObject());
            boolean select = (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            list.add(at);
        }
        return list;
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.jspYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), this.lastAcctInfo, yearEnd, yearBegin = ((Integer)this.jspYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.jspPeriodFrom.getValue()).intValue())) {
            return false;
        }
        List list = this.getTableData();
        boolean actSelected = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (!at.isSelected()) continue;
            actSelected = true;
        }
        if (!actSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please2"));
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.jspYearFrom.setValue((Object)this.currYear);
        this.jspYearTo.setValue((Object)this.currYear);
        this.jspPeriodFrom.setValue((Object)this.currMonth);
        this.jspPeriodTo.setValue((Object)this.currMonth);
        this.jebAcct.setValue(null);
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        this.hashAccountIdSet = null;
        this.jspLevelFrom.setValue((Object)1);
        this.jspLevelTo.setValue((Object)1);
        this.jcbIncludeUnPost.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        this.jcbShowOnlySubAccountview.setSelected(false);
        this.sumByAsstactLevel.setSelected(false);
        this.sumByAsstactLevel.setEnabled(true);
        this.rtnAccountRow.setSelected(true);
        this.jsbInAccAccount.setSelected(false);
        this.jsbInCostAccount.setSelected(false);
        this.jcbNoDisplayAllZero.setSelected(false);
        this.chkNotIncluePLVoucher.setSelected(false);
        this.chkOpBalanceZero.setSelected(false);
        try {
            this.jebAcct_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
            Object value = this.jbxCurrency.getItemAt(i);
            if (!(value instanceof CurrencyInfo) || !this.company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
            this.jbxCurrency.setSelectedItem(value);
        }
    }

    protected void fillAccLevelSpinner(int maxLevel) {
        SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.jspLevelFrom, (KDSpinner)this.jspLevelTo);
    }
}

