/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RptAsstactBalanceConditionUI
extends AbstractRptAsstactBalanceConditionUI {
    private static final long serialVersionUID = -4997261608424335647L;
    private RptParams initParams;
    CompanyOrgUnitInfo company = null;

    public RptAsstactBalanceConditionUI() throws Exception {
        this.tblAct.checkParsed();
        this.tblAct.getColumn(1).setWidth(100);
        this.tblAct.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblAct.getSelectManager().setSelectMode(1);
        this.tblAct.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblAct.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tblAct.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                RptAsstactBalanceConditionUI.this.tblEditStopped(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                RptAsstactBalanceConditionUI.this.tblEditValueChanged(e);
            }
        });
        this.setSize(382, 330);
        this.spnPeriodYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAsstactBalanceConditionUI.this.spnPeriodYearEnd_stateChanged(e);
            }
        });
        this.jcbNoDisplayZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAsstactBalanceConditionUI.this.ckbNoDisplayBalanceZeroUnhappen.setSelected(false);
                }
            }
        });
        this.ckbNoDisplayBalanceZeroUnhappen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAsstactBalanceConditionUI.this.jcbNoDisplayZero.setSelected(false);
                }
            }
        });
    }

    protected void tblEditValueChanged(KDTEditEvent e) {
    }

    protected void tblEditStopped(KDTEditEvent e) {
        if (e.getColIndex() == 0) {
            this.tblAct.getCell(e.getRowIndex(), 0).setValue(e.getValue());
            boolean isSelect = (Boolean)e.getValue();
            if (isSelect) {
                IRow row = this.tblAct.getRow(e.getRowIndex());
                AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                if (at == null) {
                    List actList = (List)this.initParams.getObject("asstact");
                    at = (AsstactTypeEntity)actList.get(e.getRowIndex());
                }
                this.addF7(row, at);
            }
        }
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLongNumber()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        GeneralAsstActTypeGroupInfo grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, null, (CoreUIObject)this, (boolean)at.isUseLongNumber());
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        bizPromptBox.setSelectorCollection(sic);
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, null, (CoreUIObject)this, (boolean)at.isUseLongNumber());
        bizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = RptAsstactBalanceConditionUI.this.tblAct.getSelectManager().get().getBeginRow();
                    IRow row = RptAsstactBalanceConditionUI.this.tblAct.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(e.getNewValue());
                    }
                }
                catch (Exception exc) {
                    RptAsstactBalanceConditionUI.this.handUIException(exc);
                }
            }
        });
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("from").setEditor((ICellEditor)editor);
    }

    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) {
        int yearEnd = (Integer)this.spnPeriodYearTo.getValue();
        int numberEnd = (Integer)this.spnPeriodNumberTo.getValue();
        RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.bpAccountNumberFrom, this.bpAccountNumberTo);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
        this.initParams = initParams;
        this.company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        this.company = GlUtils.getCompanyById(null, this.company.getId().toString());
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearFrom, (KDSpinner)this.spnPeriodNumberFrom, (KDSpinner)this.spnPeriodYearTo, (KDSpinner)this.spnPeriodNumberTo, (boolean)false);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        AccountTableInfo accountTable = this.company.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.company.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), this.spnPeriodYearTo.getIntegerVlaue().intValue(), this.spnPeriodNumberTo.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = RptClientUtil.periodCheckForAccountRefContrast(ar, this.spnPeriodYearTo.getIntegerVlaue(), this.spnPeriodNumberTo.getIntegerVlaue()) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 ");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter);
        this.bpAccountNumberFrom.setEditable(true);
        this.bpAccountNumberFrom.setEditFormat("$number$");
        this.bpAccountNumberFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.bpAccountNumberFrom.setDisplayFormat("$number$ - $name$");
        this.bpAccountNumberFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.bpAccountNumberFrom.setCommitParser((IParser)new AccountViewParser(this.bpAccountNumberFrom));
        this.bpAccountNumberFrom.setSelector((KDPromptSelector)apb);
        this.bpAccountNumberTo.setEditable(true);
        this.bpAccountNumberTo.setEditFormat("$number$");
        this.bpAccountNumberTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.bpAccountNumberTo.setDisplayFormat("$number$ - $name$");
        this.bpAccountNumberTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.bpAccountNumberTo.setCommitParser((IParser)new AccountViewParser(this.bpAccountNumberTo));
        this.bpAccountNumberTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.bpAccountNumberFrom.setEntityViewInfo(myevi);
        this.bpAccountNumberTo.setEntityViewInfo(myevi);
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currency");
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.cbCurrency, cc, null, this.company, RptClientUtil.loadSystemParams(this.company.getId().toString()));
        this.cbCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        this.tblAct.setRefresh(false);
        List actList = (List)initParams.getObject("asstact");
        if (actList != null) {
            int n = actList.size();
            for (int i = 0; i < n; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
                at.setSelected(false);
            }
        }
        this.setTableData(actList);
    }

    protected void setTableData(List list) {
        this.tblAct.setRefresh(false);
        this.tblAct.removeRows();
        if (list == null) {
            list = (List)this.initParams.getObject("asstact");
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                at.setSelected(false);
            }
        }
        HashSet<String> idSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (at.getId() == null) continue;
            idSet.add(at.getId());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(fi);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            IRow row = this.tblAct.addRow();
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            LabelValueBean lvb = new LabelValueBean(at.getId(), at.getName());
            lvb.setProperty("attrs", (Object)at);
            row.getCell(1).setValue((Object)lvb);
            row.setUserObject((Object)at);
            row.getCell("asstact").setValue((Object)lvb);
            boolean isSelected = at.isSelected();
            row.getCell("selected").setValue((Object)isSelected);
            if (isSelected) {
                this.addF7(row, at);
            }
            row.getCell("from").setValue(at.getFrom());
            row.getCell("to").setValue(at.getTo());
        }
        this.tblAct.setRefresh(true);
        this.tblAct.updateUI();
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tblAct.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblAct.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean select = (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            list.add(at);
        }
        return list;
    }

    protected void updateTableData() {
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tblAct.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean select;
            row = this.tblAct.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            if (at == null) {
                List actList = (List)this.initParams.getObject("asstact");
                at = (AsstactTypeEntity)actList.get(i);
            }
            if (!(select = ((Boolean)row.getCell("selected").getValue()).booleanValue())) continue;
            at.setSelected(select);
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            LabelValueBean lvb = new LabelValueBean(at.getId(), at.getName());
            lvb.setProperty("attrs", (Object)at);
            row.getCell(1).setValue((Object)lvb);
            row.setUserObject((Object)at);
        }
    }

    @Override
    protected void bpAccountNumberFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.bpAccountNumberFrom.getValue();
        Object accountTo = this.bpAccountNumberTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.bpAccountNumberTo.setValue(accountFrom);
        }
        this.accountLVChangedByMaxLV();
    }

    protected void accountLVChangedByMaxLV() throws BOSException, EASBizException {
        String accountNumberNameTo;
        String accountNumberNameFrom;
        String[] accountValue;
        String strAccountNumber;
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)this.company);
        BOSUuid companyId = this.company.getId();
        BOSUuid accountTableId = this.company.getAccountTable().getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ObjectUuidPK accountTablePK = new ObjectUuidPK(accountTableId);
        Object accountFrom = this.bpAccountNumberFrom.getValue();
        Object accountTo = this.bpAccountNumberTo.getValue();
        int i = 1;
        int j = 1;
        if (accountFrom != null && AccountUtils.getAccountViewCByNumber((String)(strAccountNumber = (accountValue = (accountNumberNameFrom = accountFrom.toString()).split(" "))[0]), (IObjectPK)companyPK, (IObjectPK)accountTablePK) != null) {
            i = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
        }
        if (accountTo != null && AccountUtils.getAccountViewCByNumber((String)(strAccountNumber = (accountValue = (accountNumberNameTo = accountTo.toString()).split(" "))[0]), (IObjectPK)companyPK, (IObjectPK)accountTablePK) != null) {
            j = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK).getLevel();
        }
        Integer k = i > j ? new Integer(i) : new Integer(j);
        this.spnLevelTo.setValue((Object)k);
    }

    @Override
    protected void bpAccountNumberTo_dataChanged(DataChangeEvent e) throws Exception {
        this.accountLVChangedByMaxLV();
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this), new Component[]{this.tblAct});
        rcm.setProperty("tableData", (Object)this.getTableData());
        rcm.setProperty("tableDataHasChaged", (Object)Boolean.TRUE);
        rcm.recordAllStatus((Container)((Object)this));
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        this.clear();
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        this.setTableData((List)rcm.getProperty("tableData"));
        this.spnLevelFrom.setValue(params.getObjectElement("spnLevelFrom.value"));
        this.spnLevelTo.setValue(params.getObjectElement("spnLevelTo.value"));
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.spnPeriodYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.spnPeriodYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.spnPeriodNumberFrom.getValue()).intValue())) {
            return false;
        }
        boolean selected = false;
        int n = this.tblAct.getRowCount();
        for (int i = 0; i < n; ++i) {
            selected = selected || (Boolean)this.tblAct.getRow(i).getCell(0).getValue() != false;
        }
        if (!selected) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please"));
            return false;
        }
        return true;
    }

    public void clear() {
        this.bpAccountNumberFrom.setValue(null);
        this.bpAccountNumberTo.setValue(null);
        this.spnLevelFrom.setValue((Object)new Integer(1));
        this.spnLevelTo.setValue((Object)new Integer(1));
        this.ktAsstactNumberFrom.setText("");
        this.ktAsstactNumberTo.setText("");
        this.cbIncludeNoPost.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        this.sumByAsst.setSelected(false);
        this.ckbNoDisplayBalanceZeroUnhappen.setSelected(false);
        this.ckbNoDisplayBalanceZero.setSelected(false);
        int maxLevel = this.initParams.getInt("maxLevel");
        PeriodEntity pe = (PeriodEntity)this.initParams.getObject("pe");
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnPeriodYearFrom, (KDSpinner)this.spnPeriodNumberFrom, (KDSpinner)this.spnPeriodYearTo, (KDSpinner)this.spnPeriodNumberTo, (boolean)true, (boolean)false);
        SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnLevelFrom, (KDSpinner)this.spnLevelTo);
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.cbCurrency, (ObjectBaseInfo)SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        for (int i = 0; i < this.tblAct.getRowCount(); ++i) {
            this.tblAct.getCell(i, 0).setValue((Object)Boolean.FALSE);
            this.tblAct.getCell(i, 2).setValue(null);
            this.tblAct.getCell(i, 3).setValue(null);
        }
    }
}

