/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.RptAsstactBalanceListFactory;
import com.kingdee.eas.fi.gl.RptCommonFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactBalanceListConditionUI;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptAsstactBalanceListConditionUI
extends AbstractRptAsstactBalanceListConditionUI {
    private static final long serialVersionUID = -1672905732989928762L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactBalanceListConditionUI.class);
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private RptRowSet rs = null;
    CompanyOrgUnitInfo company = null;
    boolean companyFilterChanged = false;
    boolean isFromSolu = false;
    String companyIds = null;
    private TreeModel treeModelOfCompany = null;
    private TreeModel treeModelOfCompanyClone = null;
    private boolean loading = false;
    private boolean hasSelectAcctItem = false;
    private FilterInfo filter = null;
    private List bizCodeIdList = new ArrayList();
    CompanyTreeSelectUI ctsUI = null;
    JDialog dialog = null;

    public RptAsstactBalanceListConditionUI() throws Exception {
        this.tfCompany.setRequired(true);
        this.tfCompany.setEnabled(true);
        this.tfCompany.setEditable(false);
        this.tbl.checkParsed();
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.getColumn(2).setWidth(110);
        this.tbl.getColumn(3).setWidth(110);
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.getProperties();
        this.setSize(520, 430);
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    protected Vector getProperties() throws BOSException, EASBizException {
        Vector<PropertyInfo> vec = new Vector<PropertyInfo>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        CustomerInfo info = new CustomerInfo();
        EntityObjectInfo eo = loader.getEntity(info.getBOSType());
        PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo p = props.get(i);
            vec.addElement(p);
        }
        return vec;
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    @Override
    protected void jcbDisplayAmount_stateChanged(ChangeEvent e) throws Exception {
        if (this.jcbDisplayAmount.isSelected()) {
            this.jcbincludeNoTransPLVoucher.setSelected(false);
            this.jcbincludeNoTransPLVoucher.setEnabled(false);
        } else {
            this.jcbincludeNoTransPLVoucher.setEnabled(true);
        }
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
            this.rs.moveRow(r, newr);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        this.company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        RptClientUtil.fullCompanyInfo(this.company, true);
        this.jebAcct_dataChanged(null);
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currencys");
        Date a = new Date();
        int year = a.getYear() + 1900;
        int[] periodRange = new int[]{a.getMonth() + 1, a.getMonth() + 1};
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(new Integer(year), periodRange);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map);
        allMap.put("currentPeriod", new int[]{year, a.getMonth() + 1});
        PeriodEntity pe = new PeriodEntity(allMap);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
        this.bpAccount.setValue((Object)this.company.getAccountTable());
        this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        if (GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setEnabled(true);
            this.bpPeriod.setEnabled(true);
        } else {
            this.tfCompany.setText(this.company.getName());
            this.tfCompany.setToolTipText(this.company.getName());
            this.btnCompany.setEnabled(false);
            this.bpAccount.setEnabled(false);
            this.bpPeriod.setEnabled(false);
        }
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.jbxCurrency, cc, null, this.company);
        RptParams sysPros = RptClientUtil.loadSystemParams(this.company.getId().toString());
        boolean sameAsAccount = false;
        if (sysPros.getString("GL_005") != null) {
            sameAsAccount = Boolean.valueOf(sysPros.getString("GL_005"));
        }
        this.jcbisDCSperate.setEnabled(!sameAsAccount);
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection fic2 = filter2.getFilterItems();
        EntityViewInfo myevi2 = new EntityViewInfo();
        myevi2.setFilter(filter2);
        this.bpAccount.setEntityViewInfo(myevi2);
        fic2.add(new FilterItemInfo("destCompany.id", (Object)this.company.getId().toString()));
        this.bpAccount.setEditable(true);
        this.bpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountTableQuery");
        this.bpAccount.setEditFormat("$number$");
        this.bpAccount.setCommitFormat("$number$");
        this.bpAccount.setDisplayFormat("$number$ - $name$");
        this.bpPeriod.setEditable(true);
        this.bpPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodTypeQuery");
        this.bpPeriod.setEditFormat("$number$");
        this.bpPeriod.setCommitFormat("$number$");
        this.bpPeriod.setDisplayFormat("$number$ - $name$");
        DataChangeListener dcl = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    RptAsstactBalanceListConditionUI.this.fireFiltersChanged(eventObj.getSource());
                }
                catch (Exception e) {
                    RptAsstactBalanceListConditionUI.this.companyFilterChanged = true;
                    MsgBox.showInfo((Component)((Object)RptAsstactBalanceListConditionUI.this), (String)e.getMessage());
                }
            }
        };
        this.bpAccount.addDataChangeListener(dcl);
        this.bpPeriod.addDataChangeListener(dcl);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("selected")) {
                    Boolean bool = (Boolean)e.getValue();
                    RptAsstactBalanceListConditionUI.this.tbl.getCell(e.getRowIndex(), "selected").setValue((Object)bool);
                    boolean isSelect = (Boolean)e.getValue();
                    if (isSelect) {
                        IRow row = RptAsstactBalanceListConditionUI.this.tbl.getRow(e.getRowIndex());
                        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                        int level = 1;
                        if (row.getCell("selectedLevel").getValue() != null) {
                            level = Integer.parseInt(row.getCell("selectedLevel").getValue().toString());
                        }
                        at.setSelectedLevel(level);
                        RptAsstactBalanceListConditionUI.this.addF7(row, at);
                        if (row.getCell("collect") != null && row.getCell("collect").getValue() == null) {
                            row.getCell("collect").setValue((Object)CollectEnum.LEAF);
                            RptAsstactBalanceListConditionUI.this.setMaxLevelCell(row, at);
                        }
                    }
                    RptAsstactBalanceListConditionUI.this.changeAccountFilter(bool != false && (RptAsstactBalanceListConditionUI.this.jebAccount.getValue() == null || RptAsstactBalanceListConditionUI.this.jebAccountEnd.getValue() == null));
                } else if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("collect")) {
                    IRow row = RptAsstactBalanceListConditionUI.this.tbl.getRow(e.getRowIndex());
                    AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                    int level = 1;
                    if (row.getCell("selectedLevel").getValue() != null) {
                        level = Integer.parseInt(row.getCell("selectedLevel").getValue().toString());
                    }
                    at.setSelectedLevel(level);
                    RptAsstactBalanceListConditionUI.this.setMaxLevelCell(row, at);
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("selected")) {
                    Boolean bool = (Boolean)e.getValue();
                    RptAsstactBalanceListConditionUI.this.tbl.getCell(e.getRowIndex(), "selected").setValue((Object)bool);
                    RptAsstactBalanceListConditionUI.this.changeAccountFilter(bool != false && (RptAsstactBalanceListConditionUI.this.jebAccount.getValue() == null || RptAsstactBalanceListConditionUI.this.jebAccountEnd.getValue() == null));
                }
            }
        });
        this.accountInit();
        this.jebBizCodeFrom.setEditable(true);
        this.jebBizCodeFrom.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7BizAnalysisCodeQuery");
        this.jebBizCodeFrom.setEditFormat("$number$");
        this.jebBizCodeFrom.setCommitFormat("$number$");
        this.jebBizCodeFrom.setDisplayFormat("$number$ - $name$");
        this.jebBizCodeFrom.setEnabled(false);
        EntityViewInfo bizcodeview = new EntityViewInfo();
        SorterItemCollection bizcodesorters = bizcodeview.getSorter();
        bizcodesorters.add(new SorterItemInfo("number"));
        this.jebBizCodeFrom.setEntityViewInfo(bizcodeview);
        this.jebBizCodeTo.setEditable(true);
        this.jebBizCodeTo.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7BizAnalysisCodeQuery");
        this.jebBizCodeTo.setEditFormat("$number$");
        this.jebBizCodeTo.setCommitFormat("$number$");
        this.jebBizCodeTo.setDisplayFormat("$number$ - $name$");
        this.jebBizCodeTo.setEnabled(false);
        this.jebBizCodeTo.setEntityViewInfo(bizcodeview);
        this.rdAcct.setSelected(true);
        this.rdBizAnalysisCode.setSelected(false);
        this.initselfListener();
        this.setAccountInitFilter();
    }

    private void initselfListener() {
        this.rdAcct.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RptAsstactBalanceListConditionUI.this.jebBizCodeFrom.setEnabled(!RptAsstactBalanceListConditionUI.this.rdAcct.isSelected());
                RptAsstactBalanceListConditionUI.this.jebBizCodeTo.setEnabled(!RptAsstactBalanceListConditionUI.this.rdAcct.isSelected());
                RptAsstactBalanceListConditionUI.this.tbl.setEnabled(RptAsstactBalanceListConditionUI.this.rdAcct.isSelected());
                RptAsstactBalanceListConditionUI.this.tbl.setEditable(RptAsstactBalanceListConditionUI.this.rdAcct.isSelected());
                RptAsstactBalanceListConditionUI.this.changeAccountFilter(false);
                if (RptAsstactBalanceListConditionUI.this.rdAcct.isSelected()) {
                    RptAsstactBalanceListConditionUI.this.jebAcct.setEnabled(!RptAsstactBalanceListConditionUI.this.hasSelectAcctItem);
                    RptAsstactBalanceListConditionUI.this.tbl.getStyleAttributes().setBackground(Color.WHITE);
                } else {
                    RptAsstactBalanceListConditionUI.this.jebAcct.setEnabled(false);
                    RptAsstactBalanceListConditionUI.this.tbl.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
                }
            }
        });
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int count = 0;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean select = (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            if (this.tbl.getColumn("collect") != null) {
                CollectEnum collect = (CollectEnum)((Object)row.getCell("collect").getValue());
                if (select && collect != null && !collect.getValue().equals("1")) {
                    ++count;
                }
                at.setCollect((CollectEnum)((Object)row.getCell("collect").getValue()));
            }
            if (row.getCell("selectedLevel").getValue() != null) {
                at.setSelectedLevel((Integer)row.getCell("selectedLevel").getValue());
            } else {
                at.setSelectedLevel(1);
            }
            list.add(at);
        }
        if (count > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)GLResUtil.getRes("lab_more_one_act_not_level"));
            SysUtil.abort();
        }
        return list;
    }

    private void setMaxLevelCell(final IRow row, AsstactTypeEntity at) {
        CollectEnum collect = (CollectEnum)((Object)row.getCell("collect").getValue());
        if (collect != null && CollectEnum.UP.equals((Object)collect)) {
            row.getCell("selectedLevel").getStyleAttributes().setLocked(false);
            int maxLevel = at.getMaxLevel();
            int selectedLevel = at.getSelectedLevel();
            if (maxLevel > 0 && selectedLevel == 0) {
                selectedLevel = 1;
            }
            final SpinnerNumberModel sm = new SpinnerNumberModel(selectedLevel, maxLevel > 0 ? 1 : 0, maxLevel, 1);
            sm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    row.getCell("selectedLevel").setValue(sm.getValue());
                }
            });
            KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
            sce.setEditable(true);
            row.getCell("selectedLevel").setValue((Object)new Integer(selectedLevel));
            row.getCell("selectedLevel").setEditor((ICellEditor)sce);
            sce.setEditable(maxLevel > 0);
            sce.setEnabled(maxLevel > 0);
            row.getCell("selectedLevel").getStyleAttributes().setBackground(Color.WHITE);
        } else if (collect != null && CollectEnum.LEAF.equals((Object)collect)) {
            row.getCell("selectedLevel").getStyleAttributes().setLocked(true);
            row.getCell("selectedLevel").setEditor(null);
            row.getCell("selectedLevel").setValue(null);
            row.getCell("selectedLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        } else {
            row.getCell("selectedLevel").getStyleAttributes().setLocked(true);
            row.getCell("selectedLevel").setEditor(null);
            row.getCell("selectedLevel").setValue(null);
            row.getCell("selectedLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        }
    }

    private void setAccountInitFilter() {
        AccountPromptBox apb;
        this.filter = new FilterInfo();
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        FilterItemCollection fic = this.filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)account.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        this.filter.setMaskString("#0 and #1 and #2");
        if (GlUtils.isCompanyUnion(this.company)) {
            AccountTableInfo ati = (AccountTableInfo)this.bpAccount.getValue();
            if (ati == null) {
                ati = this.company.getAccountTable();
            }
            apb = new AccountPromptBox((IUIObject)this, ati, this.filter, false);
        } else {
            apb = new AccountPromptBox((IUIObject)this, this.company, this.filter, false, false, true);
        }
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(this.filter);
        this.jebAccount.setSelector((KDPromptSelector)apb);
        this.jebAccount.setEntityViewInfo(myevi);
        this.jebAccountEnd.setSelector((KDPromptSelector)apb);
        this.jebAccountEnd.setEntityViewInfo(myevi);
    }

    private void accountInit() {
        this.jebAccount.setRefresh(true);
        this.jebAccount.setEditable(true);
        this.jebAccount.setEditFormat("$number$");
        this.jebAccount.setCommitFormat("$number$");
        this.jebAccount.setDisplayFormat("$number$ - $name$");
        this.jebAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        RptParams initparams = new RptParams();
        initparams.setString("cuID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        try {
            this.rs = RptAsstactBalanceListFactory.getRemoteInstance().queryAsstAct(initparams);
            RptRowSet asstAccountIdRst = (RptRowSet)this.rs.getProperty("asstAccountIdRst");
            for (int i = 0; i < asstAccountIdRst.getRowCount(); ++i) {
                asstAccountIdRst.next();
                if (!asstAccountIdRst.getString("FREALTIONDATAOBJECT").equalsIgnoreCase("T_BD_Customer") && !asstAccountIdRst.getString("FREALTIONDATAOBJECT").equalsIgnoreCase("T_BD_Supplier")) continue;
                this.bizCodeIdList.add(asstAccountIdRst.getString("fasstaccountid"));
            }
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.jebAccountEnd.setRefresh(true);
        this.jebAccountEnd.setEditable(true);
        this.jebAccountEnd.setEditFormat("$number$");
        this.jebAccountEnd.setCommitFormat("$number$");
        this.jebAccountEnd.setDisplayFormat("$number$ - $name$");
        this.jebAccountEnd.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountEnd.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        this.jebAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
    }

    private void fireFiltersChanged(Object source) throws Exception {
        if (this.bpAccount.getValue() == null || this.company == null || !GlUtils.isCompanyUnion(this.company)) {
            return;
        }
        this.treeModelOfCompany = null;
        this.tfCompany.setText("");
        this.tfCompany.setToolTipText("");
        this.setAccountInitFilter();
        if (source != this.bpPeriod) {
            this.jebAccount.setValue(null);
            this.jebAccountEnd.setValue(null);
            this.jebAcct.setEnabled(this.rdAcct.isSelected());
            if (this.jebAcct.getValue() != null) {
                this.jebAcct.setValue(null);
            } else {
                this.jebAcct_dataChanged(null);
            }
        }
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        boolean b = account != null && period != null;
        this.btnCompany.setEnabled(b);
        this.jebAccount.setEnabled(account != null);
        this.jebAccountEnd.setEnabled(account != null);
        this.company.setAccountTable(account);
        this.company.setAccountPeriodType(period);
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.bpAccount.getValue() == null) {
            return;
        }
        if (this.ctsUI == null) {
            this.dialog = new JDialog(InitClientHelp.getFrameAncestor((Component)((Object)this)), true);
            this.ctsUI = new CompanyTreeSelectUI(this.company);
            this.ctsUI.initListener();
            this.ctsUI.setDialog(this.dialog);
            this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
            this.dialog.setSize(640, 480);
            InitClientHelp.centerWindow(this.dialog);
            this.dialog.setResizable(false);
            this.dialog.setTitle(this.ctsUI.getUITitle());
            this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("companyChanged")) {
                        RptAsstactBalanceListConditionUI.this.companyChanged(evt.getNewValue());
                    }
                }
            });
        }
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        this.ctsUI.setAccountTableID(account.getId().toString());
        this.ctsUI.setPeriodTypeID(period.getId().toString());
        this.ctsUI.setBooksModel();
        if (this.companyFilterChanged || this.treeModelOfCompany == null || this.isFromSolu) {
            this.companyFilterChanged = false;
            Object objectCurrency = this.jbxCurrency.getSelectedItem();
            if (objectCurrency instanceof CurrencyInfo) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.jbxCurrency.getSelectedItem();
                if (currencyInfo.getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                    this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
                } else {
                    this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
                }
            } else {
                this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
            }
            if (this.isFromSolu && this.treeModelOfCompany != null) {
                this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
                this.isFromSolu = false;
            }
        } else {
            this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
            this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
        }
        this.dialog.show();
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        this.jebAccount.setValue(null);
        this.jebAccountEnd.setValue(null);
        Object value = this.jebAcct.getValue();
        RptParams params = new RptParams();
        params.setString("cuID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (value != null) {
            AsstAccountInfo aai = (AsstAccountInfo)value;
            params.setString("asstAccountId", aai.getId().toString());
        }
        try {
            this.rs = RptAsstactBalanceListFactory.getRemoteInstance().queryAsstAct(params);
            while (this.rs.next()) {
                this.rs.setValue("FFrom", null);
                this.rs.setValue("FTo", null);
                this.rs.setValue("FSelected", (Object)Boolean.TRUE);
                this.rs.setValue("FCollect", (Object)CollectEnum.LEAF);
            }
            this.setTableData();
            if (value == null) {
                this.inverseSelect();
            }
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        if (e != null) {
            this.changeAccountFilter(true);
        }
    }

    @Override
    protected void jebAccount_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.jebAccount.getValue();
        Object accountTo = this.jebAccountEnd.getValue();
        if (accountFrom != null && accountTo == null) {
            this.jebAccountEnd.setValue(accountFrom);
        }
    }

    private void inverseSelect() {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            this.tbl.getRow(i).getCell("selected").setValue((Object)(Boolean.valueOf(String.valueOf(this.tbl.getRow(i).getCell("selected").getValue())) == false ? 1 : 0));
        }
    }

    private void changeAccountFilter(boolean bool) {
        if (this.filter == null) {
            return;
        }
        FilterItemCollection fic = this.filter.getFilterItems();
        while (fic.size() > 3) {
            fic.removeObject(fic.size() - 1);
        }
        Object value = this.jebAcct.getValue();
        if (value != null && this.rdAcct.isSelected()) {
            fic.add(new FilterItemInfo("CAA.id", (Object)((AsstAccountInfo)value).getId()));
            this.filter.setMaskString("#0 and #1 and #2 and #3 ");
        } else {
            this.filter.setMaskString("#0 and #1 and #2 ");
        }
        HashSet<String> asstItemIdSet = new HashSet<String>();
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)this.tbl.getCell(i, "selected").getValue()).booleanValue()) continue;
            this.rs.moveTo(i);
            asstItemIdSet.add(this.rs.getString("fid"));
        }
        boolean hasSelected = asstItemIdSet.size() > 0;
        int getTag = this.getTag();
        this.setTag(1);
        if (bool) {
            this.jebAccount.setValue(null);
            this.jebAccountEnd.setValue(null);
        }
        this.setTag(getTag);
        if (hasSelected && this.rdAcct.isSelected()) {
            RptRowSet asstAccountIdRst = (RptRowSet)this.rs.getProperty("asstAccountIdRst");
            int from = fic.size();
            StringBuffer sf = new StringBuffer(this.filter.getMaskString());
            ArrayList<String> asstAccountIdList = null;
            for (String id : asstItemIdSet) {
                asstAccountIdRst.reset();
                asstAccountIdList = new ArrayList<String>();
                while (asstAccountIdRst.next()) {
                    if (!id.equals(asstAccountIdRst.getString("fasstacttypeid"))) continue;
                    asstAccountIdList.add(asstAccountIdRst.getString("fasstaccountid"));
                }
                sf.append(" and (");
                int n2 = asstAccountIdList.size();
                for (int j = 0; j < n2; ++j) {
                    fic.add(new FilterItemInfo("CAA.id", asstAccountIdList.get(j)));
                    sf.append("#").append(from++);
                    if (j == n2 - 1) continue;
                    sf.append(" or ");
                }
                sf.append(")");
            }
            this.filter.setMaskString(sf.toString());
        } else if (!this.rdAcct.isSelected()) {
            int from = fic.size();
            StringBuffer sf = new StringBuffer(this.filter.getMaskString());
            sf.append(" and (");
            int n3 = this.bizCodeIdList.size();
            for (int j = 0; j < n3; ++j) {
                fic.add(new FilterItemInfo("CAA.id", this.bizCodeIdList.get(j)));
                sf.append("#").append(from++);
                if (j == n3 - 1) continue;
                sf.append(" or ");
            }
            if (this.bizCodeIdList.size() == 0) {
                fic.add(new FilterItemInfo("CAA.id", (Object)"noClientSupply"));
                sf.append("#").append(from++);
            }
            sf.append(")");
            this.filter.setMaskString(sf.toString());
        }
        AccountTableInfo ati = (AccountTableInfo)this.bpAccount.getValue();
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, ati, this.filter);
        this.jebAccount.setSelector((KDPromptSelector)apb);
        this.jebAccountEnd.setSelector((KDPromptSelector)apb);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.filter);
        this.jebAccount.setEntityViewInfo(evi);
        this.jebAccountEnd.setEntityViewInfo(evi);
    }

    protected void companyChanged(Object object) {
        if (object == null) {
            return;
        }
        Object objectnew = null;
        try {
            objectnew = ObjectUtils.createCopy((Object)object);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
        this.treeModelOfCompany = (TreeModel)object;
        this.treeModelOfCompanyClone = (TreeModel)objectnew;
        try {
            String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
            this.tfCompany.setText(info);
            this.tfCompany.setToolTipText(info);
            this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
            this.company.setDescription(this.companyIds);
            PeriodEntity pe = null;
            pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("GL_008");
            ArrayList companyList = this.getLeafCompany(this.treeModelOfCompany);
            ArrayList ParamResultList = ParamControlFactory.getRemoteInstance().getParamHashMapBatch(paramList, companyList);
            HashSet<String> paramSet = new HashSet<String>();
            for (int i = 0; i < ParamResultList.size(); ++i) {
                ParamSimpleInfo paramSimpleInfo = (ParamSimpleInfo)ParamResultList.get(i);
                if (!"GL_008".equals(paramSimpleInfo.getParamNumber()) || paramSimpleInfo.getOrgUnitPK() == null) continue;
                paramSet.add(paramSimpleInfo.getParamValue());
            }
            if (paramSet.size() > 1) {
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("companyForCurrError"));
                this.treeModelOfCompany = null;
                this.tfCompany.setText("");
                this.tfCompany.setToolTipText("");
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
    }

    private void setTableData() {
        this.tbl.removeRows();
        if (this.rs == null) {
            return;
        }
        if (this.rs.getRowCount() == 0) {
            return;
        }
        this.tbl.setRefresh(false);
        this.rs.reset();
        AsstactTypeEntity at = null;
        while (this.rs.next()) {
            IRow row = this.tbl.addRow();
            row.getCell("selected").setValue((Object)Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))));
            row.getCell("type").setValue((Object)this.rs.getString("FName"));
            row.getCell("from").setValue(this.rs.getObject("FFrom"));
            row.getCell("to").setValue(this.rs.getObject("FTo"));
            row.getCell("selectedLevel").setValue(this.rs.getObject("selectedLevel"));
            if (this.rs.getObject("FCollect") != null) {
                row.getCell("collect").setValue(this.rs.getObject("FCollect"));
            } else {
                row.getCell("collect").setValue((Object)CollectEnum.LEAF);
            }
            at = new AsstactTypeEntity();
            at.setSelected(Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))));
            at.setMaxLevel(this.rs.getInt("FmaxLevel"));
            if (this.rs.getObject("selectedLevel") != null) {
                at.setSelectedLevel(Integer.valueOf(String.valueOf(this.rs.getObject("selectedLevel"))));
            }
            at.setName(this.rs.getString("FName"));
            at.setFrom(this.rs.getObject("FFrom"));
            at.setTo(this.rs.getObject("FTo"));
            if (Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))).booleanValue()) {
                this.addF7(row, at);
            }
            if (this.tbl.getColumn("collect") != null) {
                row.getCell("collect").setEditor(GLEditor.getComboBox(CollectEnum.getEnumList()));
                this.setMaxLevelCell(row, at);
            } else {
                this.setMaxLevelCell(row, at);
            }
            at.setGeneralAsstactGroupId(this.rs.getString("FGLAsstActTypeGrpID"));
            row.setUserObject((Object)at);
            if (GlUtils.isCompanyUnion(this.company)) {
                row.getCell("acctproperty").getStyleAttributes().setLocked(true);
            }
            this.tbl.getColumn("acctproperty").getStyleAttributes().setHided(true);
        }
        this.tbl.setRefresh(true);
        this.tbl.updateUI();
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        this.rs.reset();
        int i = 0;
        while (this.rs.next()) {
            this.rs.setValue("FSelected", this.tbl.getCell(i, "selected").getValue());
            this.rs.setValue("FFrom", this.tbl.getCell(i, "from").getValue());
            this.rs.setValue("FTo", this.tbl.getCell(i, "to").getValue());
            this.rs.setValue("selectedLevel", this.tbl.getCell(i, "selectedLevel").getValue());
            this.rs.setValue("FCollect", this.tbl.getCell(i, "collect").getValue());
            ++i;
        }
        this.rs.reset();
        i = 0;
        while (this.rs.next()) {
            if (!((CollectEnum)((Object)this.tbl.getCell(i, "collect").getValue())).equals((Object)CollectEnum.LEAF) && this.rs.getRow() != 0) {
                this.rs.moveRow(this.rs.getRow(), 0);
                this.tbl.moveRow(this.rs.getRow(), 0);
            }
            ++i;
        }
        rm.setProperty("rs", (Object)this.rs);
        rm.setProperty("treeCompany", this.treeModelOfCompany.getRoot());
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        this.setTag(1);
        RptConditionManager rm = new RptConditionManager(params, new String[]{"rs"});
        Integer iYearFrom = (Integer)((RptConditionManager.ComponentStatus)params.getObject("jspYearFrom")).getValue();
        Integer iPeriodFrom = (Integer)((RptConditionManager.ComponentStatus)params.getObject("jspPeriodFrom")).getValue();
        Integer iYearTo = (Integer)((RptConditionManager.ComponentStatus)params.getObject("jspYearTo")).getValue();
        Integer iPeriodTo = (Integer)((RptConditionManager.ComponentStatus)params.getObject("jspPeriodTo")).getValue();
        rm.restoreAllStatus((Container)((Object)this));
        if (GlUtils.isCompanyUnion(this.company)) {
            this.treeModelOfCompany = new DefaultTreeModel((TreeNode)params.getObject("treeCompany"));
            this.companyChanged(this.treeModelOfCompany);
            Object tmpValue = params.getObject("jebAccount");
            Object accountFrom = null;
            if (tmpValue != null) {
                accountFrom = ((RptConditionManager.ComponentStatus)tmpValue).getValue();
            }
            this.jebAccount.setValue(accountFrom);
            tmpValue = params.getObject("jebAccountEnd");
            Object accountTo = null;
            if (tmpValue != null) {
                accountTo = ((RptConditionManager.ComponentStatus)tmpValue).getValue();
            }
            this.jebAccountEnd.setValue(accountTo);
            this.jspYearFrom.setValue((Object)iYearFrom);
            this.jspPeriodFrom.setValue((Object)iPeriodFrom);
            this.jspYearTo.setValue((Object)iYearTo);
            this.jspPeriodTo.setValue((Object)iPeriodTo);
        }
        this.rs = (RptRowSet)rm.getProperty("rs");
        this.setTableData();
        this.isFromSolu = true;
        this.companyFilterChanged = false;
        this.setTag(0);
    }

    public boolean verify() {
        if (GlUtils.isCompanyUnion(this.company)) {
            if (this.bpAccount.getValue() == null) {
                this.bpAccount.requestFocus();
                MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
                return false;
            }
            if (this.bpPeriod.getValue() == null) {
                this.bpPeriod.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
                return false;
            }
            if (this.treeModelOfCompany == null || this.companyFilterChanged) {
                this.btnCompany.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
                return false;
            }
            try {
                this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            try {
                if (!RptAsstactBalanceListConditionUI.hasPhysicalCompany(this.treeModelOfCompany)) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                    return false;
                }
                int numberEnd = (Integer)this.jspPeriodTo.getValue();
                int yearEnd = (Integer)this.jspYearTo.getValue();
                RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                return false;
            }
            catch (Exception e) {
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                return false;
            }
        }
        if (this.rdAcct.isSelected()) {
            if (this.rs == null) {
                this.jebAccount.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("reSelect_accountView_for_incorrectness_act"));
                return false;
            }
            boolean s = false;
            this.getCustomCondition();
            this.rs.reset();
            while (this.rs.next()) {
                if (this.rs.getObject("FSelected") == null || !((Boolean)this.rs.getObject("FSelected")).booleanValue()) continue;
                s = true;
                break;
            }
            if (!s) {
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please"));
                return false;
            }
            List list = this.getTableData();
            boolean actSelected = false;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                if (!at.isSelected()) continue;
                actSelected = true;
                break;
            }
            if (!actSelected) {
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please2"));
                return false;
            }
        }
        return true;
    }

    public static boolean hasPhysicalCompany(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        if (node.getChildCount() <= 0) {
            return false;
        }
        StringBuffer result = new StringBuffer("(");
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append("'").append(userObject.getCompanyId()).append("',");
        }
        result.replace(result.length() - 1, result.length(), ")");
        Boolean bb = (Boolean)RptCommonFactory.getRemoteInstance().invoke("hasPhysicalCompany", result.toString());
        return bb;
    }

    @Override
    protected void jbxCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        super.jbxCurrency_actionPerformed(e);
        Object objectCurrency = this.jbxCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo && (currencyInfo = (CurrencyInfo)this.jbxCurrency.getSelectedItem()).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
    }

    public void clear() {
        super.clear();
        this.bpAccount.setValue((Object)this.company.getAccountTable());
        this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        Date a = new Date();
        int year = a.getYear() + 1900;
        int[] periodRange = new int[]{a.getMonth() + 1, a.getMonth() + 1};
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(new Integer(year), periodRange);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map);
        allMap.put("currentPeriod", new int[]{year, a.getMonth() + 1});
        PeriodEntity pe = new PeriodEntity(allMap);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
        if (GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setEnabled(true);
            this.bpPeriod.setEnabled(true);
        } else {
            this.tfCompany.setText(this.company.getName());
            this.tfCompany.setToolTipText(this.company.getName());
            this.btnCompany.setEnabled(false);
            this.bpAccount.setEnabled(false);
            this.bpPeriod.setEnabled(false);
        }
        try {
            this.tfCompany.setText("");
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
            this.jebAcct.setValue(null);
            this.jcbIncludeUnPost.setSelected(false);
            this.kDCheckBox1.setSelected(false);
            this.jcbNoPlayBalanceZero.setSelected(false);
            this.jcbincludeNoTransPLVoucher.setSelected(false);
            this.jcbDisplayAmount.setSelected(false);
            this.jcbNoDisplayZero.setSelected(false);
            this.jcbisDCSperate.setSelected(false);
            this.jebAcct_dataChanged(null);
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
                Object value = this.jbxCurrency.getItemAt(i);
                if (!(value instanceof CurrencyInfo) || !company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
                this.jbxCurrency.setSelectedItem(value);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addF7(IRow row, AsstactTypeEntity userObject) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(this.rs.getString("FDefaultQueryName"));
        EntityViewInfo vv = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        vv.setFilter(ff);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        bizPromptBox.setSelectorCollection(sic);
        boolean isUseLongNumber = false;
        boolean isForCompany = false;
        String asstHGAttribute = null;
        try {
            isForCompany = "1".equals(String.valueOf(this.rs.getObject("FisForCompany")));
            asstHGAttribute = this.rs.getString("FAsstHGAttribute");
            isUseLongNumber = "1".equals(String.valueOf(this.rs.getObject("FUseLongNumber")));
        }
        catch (Exception ex) {
            logger.error((Object)"Query solution error! ", (Throwable)ex);
        }
        AsstActTypeInfo atInfo = new AsstActTypeInfo();
        atInfo.setAsstHGAttribute(asstHGAttribute);
        atInfo.setIsForCompany(isForCompany);
        atInfo.setUseLongNumber(isUseLongNumber);
        atInfo.setDefaultQueryName(this.rs.getString("FDefaultQueryName"));
        atInfo.setIsForCompany(userObject.isForCompany());
        atInfo.setUseLongNumber(userObject.isUseLongNumber());
        GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
        if (this.rs.getObject("FGLAsstActTypeGrpID") != null) {
            groupInfo = new GeneralAsstActTypeGroupInfo();
            groupInfo.setId(BOSUuid.read((String)this.rs.getString("FGLAsstActTypeGrpID")));
            atInfo.setGlAsstActTypeGrp(groupInfo);
        }
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(false);
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.company, (GLF7Parameter)f7Param);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(this.rs.getString("FDefaultQueryName"));
        bizPromptBox.setSelectorCollection(sic);
        GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.company, (GLF7Parameter)f7Param);
        bizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = RptAsstactBalanceListConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAsstactBalanceListConditionUI.this.tbl.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(e.getNewValue());
                    }
                }
                catch (Exception exc) {
                    RptAsstactBalanceListConditionUI.this.handUIException(exc);
                }
            }
        });
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("from").setEditor((ICellEditor)editor);
    }

    private ArrayList getLeafCompany(TreeModel model) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        ArrayList<String> companyList = new ArrayList<String>();
        for (node = node.getFirstLeaf(); node != null; node = node.getNextLeaf()) {
            if (node.getUserObject() == null || !(node.getUserObject() instanceof SimpleCompanyUserObject)) continue;
            SimpleCompanyUserObject info = (SimpleCompanyUserObject)node.getUserObject();
            companyList.add(info.getCompanyId());
        }
        return companyList;
    }
}

