/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RptAsstactBalanceFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactBalanceUI;
import com.kingdee.eas.fi.gl.client.RptAsstactBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.RptAsstactBalancePrintParame;
import com.kingdee.eas.fi.gl.client.RptAsstactBalanceTaoDa;
import com.kingdee.eas.fi.gl.client.RptAsstactGDUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.client.CommRptBaseUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RptAsstactBalanceUI
extends AbstractRptAsstactBalanceUI {
    private static final long serialVersionUID = -4699261133980948650L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactBalanceUI.class);
    protected CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String strResource = "com.kingdee.eas.fi.gl.client.GlResource";
    RptAsstactBalancePrintParame editParame = null;
    Map mapParame = null;
    RptRowSet rsParame = null;
    protected List acctAsstList;
    private boolean sumByAcctType = false;
    private String strDebit = GLResUtil.getRes("debit");
    private String strCredit = GLResUtil.getRes("credit");

    public RptAsstactBalanceUI() throws Exception {
        this.editParame = RptAsstactBalancePrintParame.getInstance();
        RptClientUtil.checkFIUnit(false);
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().setDataRequestMode(0);
        this.tbl.getSelectManager().setSelectMode(10);
        this.tbl.getStyleAttributes().setLocked(true);
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.enableExportExcel(this.tbl);
        this.tbl.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int i = e.getSelectBlock().getTop();
                if (i >= 0) {
                    IRow row = RptAsstactBalanceUI.this.tbl.getRow(i);
                    if (row == null) {
                        return;
                    }
                    Object year = row.getCell(8).getValue();
                    if (year != null) {
                        RptAsstactBalanceUI.this.actionQueryAsstList.setEnabled(true);
                    } else {
                        RptAsstactBalanceUI.this.actionQueryAsstList.setEnabled(false);
                    }
                } else {
                    RptAsstactBalanceUI.this.actionQueryAsstList.setEnabled(false);
                }
            }
        });
        this.tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        RptAsstactBalanceUI.this.actionQueryAsstList_actionPerformed(null);
                    }
                    catch (Exception ex) {
                        RptAsstactBalanceUI.this.handleException(ex);
                    }
                }
            }
        });
        this.setButtonIcon((JButton)this.btnQueryAsstList, "imgTbtn_assistantaccountdetail");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemQueryAsstList.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        if (!GlUtils.isCompanyUnion(this.currCompany)) {
            this.menuItemParame.setVisible(true);
            this.menuItemParame.setEnabled(true);
        } else {
            this.menuItemParame.setVisible(false);
            this.menuItemParame.setEnabled(false);
        }
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setColumnWidth();
    }

    private void setColumnWidth() {
        try {
            this.tbl.getColumn(0).setWidth(-1);
            this.tbl.getColumn(3).setWidth(-1);
        }
        catch (NullPointerException e) {
            logger.error((Object)e);
        }
    }

    protected void initHelper() {
        this.setColumnWidth();
        super.initHelper();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setColumnWidth();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setColumnWidth();
    }

    @Override
    public void actionQueryAsstList_actionPerformed(ActionEvent e) throws Exception {
        if (!this.actionQueryAsstList.isEnabled() || this.tbl.getSelectManager().get() == null) {
            return;
        }
        try {
            this.setCursorOfWair();
            int selectedRow = this.tbl.getSelectManager().get().getTop();
            this.joinQueryAsstactList(selectedRow);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return RptAsstactBalanceFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected KDTable getTableForCommon() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new RptAsstactBalanceConditionUI();
    }

    protected void query() {
        this.actionQueryAsstList.setEnabled(false);
        this.mapParame = new HashMap();
        this.sumByAcctType = (Boolean)this.params.getObjectElement("sumByAsst.value");
        String strPeriod = RptClientUtil.getPeriodTitle((Integer)this.params.getObjectElement("spnPeriodYearFrom.value"), (Integer)this.params.getObjectElement("spnPeriodNumberFrom.value"), (Integer)this.params.getObjectElement("spnPeriodYearTo.value"), (Integer)this.params.getObjectElement("spnPeriodNumberTo.value"));
        String strCurrency = String.valueOf(this.params.getObjectElement("cbCurrency.value"));
        this.mapParame.put("periodParmae", strPeriod);
        this.mapParame.put("currencyParame", strCurrency);
        this.lblPeriod.setText(strPeriod);
        this.lblCurrency.setText(strCurrency);
        List actList = this.getActList();
        StringBuffer sb = new StringBuffer();
        int n = actList.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            sb.append(at.getName()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        String strAsstAct = sb.toString();
        this.mapParame.put("asstActParame", strAsstAct);
        StringBuffer act = new StringBuffer();
        Object[] vv = (Object[])this.params.getObjectElement("tblAct.value");
        int _i = 0;
        int _j = 0;
        int n2 = vv.length;
        for (int i = 0; i < n2; ++i) {
            Object[] _tmp = (Object[])vv[i];
            if (_tmp[0] instanceof Boolean) {
                _i = 0;
                _j = 1;
            } else {
                _i = 1;
                _j = 0;
            }
            if (!((Boolean)_tmp[_i]).booleanValue()) continue;
            act.append(_tmp[_j]).append(", ");
        }
        act.setLength(act.length() - 2);
        this.mapParame.put("asstActParame", strAsstAct);
        this.lblAsstActItem.setText(strAsstAct);
        this.lblAsstActItem.setToolTipText(strAsstAct);
        this.tbl.removeRows();
        this.tHelper.init();
        this.checkTableCommonMenu(this.tbl);
    }

    protected List getActList() {
        boolean tableDataHasChaged;
        boolean bl = tableDataHasChaged = this.params.getObject("tableDataHasChaged") != null ? (Boolean)this.params.getObject("tableDataHasChaged") : true;
        if (tableDataHasChaged) {
            int i;
            this.acctAsstList = new ArrayList();
            List list = (List)this.params.getObject("tableData");
            AsstactTypeEntity at = null;
            int n = list.size();
            for (i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                if (!at.isSelected() || CollectEnum.LEAF.equals((Object)at.getCollect())) continue;
                this.acctAsstList.add(at);
            }
            n = list.size();
            for (i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                if (!at.isSelected() || !CollectEnum.LEAF.equals((Object)at.getCollect())) continue;
                this.acctAsstList.add(at);
            }
            this.params.setObject("tableDataHasChaged", (Object)Boolean.FALSE);
        }
        return this.acctAsstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableDataRequest(KDTDataRequestEvent e) {
        this.setCursorOfWair();
        int from = e.getFirstRow();
        int length = e.getLastRow() - e.getFirstRow() + 1;
        try {
            RptParams pp = (RptParams)this.params.clone();
            pp.remove("tableData");
            pp.setObject("actList", (Object)this.getActList());
            int yearEnd = (Integer)this.params.getObjectElement("spnPeriodYearTo.value");
            int numberEnd = (Integer)this.params.getObjectElement("spnPeriodNumberTo.value");
            pp.setObject("company", (Object)RptClientUtil.getCompany(yearEnd, numberEnd));
            pp.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            pp.setString("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            pp.setString("baseCurrencyId", SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
            RptParams rp = RptAsstactBalanceFactory.getRemoteInstance().query(pp, from, length);
            RptRowSet rs = (RptRowSet)rp.getObject("rs");
            if (from == 0) {
                this.tbl.removeColumns();
                KDTableUtil.setHeader((RptTableHeader)((RptTableHeader)rp.getObject("head")), (KDTable)this.tbl);
                this.tbl.getColumn(0).getStyleAttributes().setNumberFormat("@");
                this.tbl.getColumn(1).getStyleAttributes().setNumberFormat("@");
                this.tbl.getColumn(2).getStyleAttributes().setNumberFormat("@");
            }
            if (rs.getRowCount() < 100) {
                this.tbl.setRowCount(from + rs.getRowCount());
            } else {
                int forNextFetchCount = 100;
                this.tbl.setRowCount(from + length + forNextFetchCount);
            }
            int cols = rs.getColumnCount();
            CurrencyInfo ci = RptClientUtil.searchCurrency((CurrencyCollection)this.getUIContextInitParams().getObject("currency"), SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
            String strDebit = GLResUtil.getRes("debit");
            String strCredit = GLResUtil.getRes("credit");
            this.rsParame = rs;
            rs.reset();
            while (rs.next()) {
                IRow row = this.tbl.addRow(from + rs.getRow());
                int precision = rs.getInt("FPrecision");
                int fdc = rs.getInt("FDC");
                String accountDirect = GlUtils.zero.compareTo(rs.getBigDecimal("FENDBALANCELOCAL")) == 0 && GlUtils.zero.compareTo(rs.getBigDecimal("FENDBALANCEFOR")) == 0 ? GLResUtil.getRes("dir_equal") : (fdc == 1 ? strDebit : strCredit);
                for (int i = 0; i < cols; ++i) {
                    if (i < 10 || i >= cols - 1) {
                        row.getCell(i).setValue(rs.getObject(i));
                        continue;
                    }
                    if (i != 22) {
                        row.getCell(i).setValue(((BigDecimal)rs.getObject(i)).floatValue() == 0.0f ? null : rs.getObject(i));
                        if (i < 22 && i % 2 == 0 || i > 22 && (i + 1) % 2 == 0) {
                            row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
                            continue;
                        }
                        row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(ci.getPrecision()));
                        continue;
                    }
                    row.getCell(i).setValue((Object)accountDirect);
                }
            }
            if (this.sumByAcctType) {
                this.dealWithSumByActType(rp);
            } else {
                this.dealWithSum(rp);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void fillTable(RptRowSet sumRsTwo, int rsLocation, int j) {
        int cols = sumRsTwo.getColumnCount();
        CurrencyInfo ci = RptClientUtil.searchCurrency((CurrencyCollection)this.getUIContextInitParams().getObject("currency"), SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
        String strDebit = GLResUtil.getRes("debit");
        String strCredit = GLResUtil.getRes("credit");
        IRow row = j == -1 ? this.tbl.addRow() : this.tbl.addRow(j + 1);
        sumRsTwo.moveTo(rsLocation);
        int precision = sumRsTwo.getInt("FPrecision");
        int fdc = sumRsTwo.getInt("FDC");
        String accountDirect = GlUtils.zero.compareTo(sumRsTwo.getBigDecimal("FENDBALANCELOCAL")) == 0 && GlUtils.zero.compareTo(sumRsTwo.getBigDecimal("FENDBALANCEFOR")) == 0 ? GLResUtil.getRes("dir_equal") : (fdc == 1 ? strDebit : strCredit);
        for (int i = 0; i < cols; ++i) {
            if (i < 10 || i >= cols - 1) {
                row.getCell(i).setValue(sumRsTwo.getObject(i));
                continue;
            }
            if (i != 22) {
                row.getCell(i).setValue(((BigDecimal)sumRsTwo.getObject(i)).floatValue() == 0.0f ? null : sumRsTwo.getObject(i));
                if (i < 22 && i % 2 == 0 || i > 22 && (i + 1) % 2 == 0) {
                    row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
                    continue;
                }
                row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(ci.getPrecision()));
                continue;
            }
            row.getCell(i).setValue((Object)accountDirect);
        }
        row.getStyleAttributes().setBackground(this.tbl.getRequiredColor());
    }

    private void dealWithSumByResultTwo(RptRowSet rowSet) {
        int k;
        String oldAstType;
        int j = 0;
        int rsLocation = 0;
        rowSet.reset();
        HashMap resultMap = new HashMap();
        List actTypeCurrency = null;
        while (rowSet.next()) {
            String type = rowSet.getString("FActTypeName");
            actTypeCurrency = (ArrayList<Integer>)resultMap.get(type);
            if (actTypeCurrency == null) {
                actTypeCurrency = new ArrayList<Integer>();
                resultMap.put(type, actTypeCurrency);
            }
            rsLocation = rowSet.getRow();
            actTypeCurrency.add(new Integer(rsLocation));
        }
        for (int ii = 0; ii < this.tbl.getRowCount(); ++ii) {
            if (ii > 0) {
                j = ii - 1;
            }
            IRow rowNew = this.tbl.getRow(ii);
            IRow rowOld = this.tbl.getRow(j);
            String newAstType = (String)rowNew.getCell(4).getValue();
            if (newAstType.equals(oldAstType = (String)rowOld.getCell(4).getValue()) || (actTypeCurrency = (List)resultMap.get(oldAstType)) == null) continue;
            for (k = 0; k < actTypeCurrency.size(); ++k) {
                rsLocation = (Integer)actTypeCurrency.get(k);
                this.fillTable(rowSet, rsLocation, j + k);
                ++ii;
            }
        }
        IRow rowTwo = this.tbl.getRow(this.tbl.getRowCount() - 1);
        if (rowTwo == null) {
            return;
        }
        oldAstType = (String)rowTwo.getCell(4).getValue();
        actTypeCurrency = (List)resultMap.get(oldAstType);
        if (actTypeCurrency != null) {
            for (k = 0; k < actTypeCurrency.size(); ++k) {
                rsLocation = (Integer)actTypeCurrency.get(k);
                this.fillTable(rowSet, rsLocation, -1);
            }
        }
    }

    private void dealWithSumByResultOne(RptRowSet rowSet) {
        String oldNumber;
        String oldAstName;
        String oldAstType;
        int j = 0;
        int rsLocation = 0;
        rowSet.reset();
        String key = null;
        HashMap resultMap = new HashMap();
        List actCurrency = null;
        while (rowSet.next()) {
            String type = rowSet.getString("FActTypeName");
            String name = rowSet.getString("FName");
            String number = rowSet.getString("FNumber");
            key = type + number + name;
            actCurrency = (ArrayList<Integer>)resultMap.get(key);
            if (actCurrency == null) {
                actCurrency = new ArrayList<Integer>();
                resultMap.put(key, actCurrency);
            }
            rsLocation = rowSet.getRow();
            actCurrency.add(new Integer(rsLocation));
        }
        for (int ii = 0; ii < this.tbl.getRowCount(); ++ii) {
            if (ii > 0) {
                j = ii - 1;
            }
            IRow rowNew = this.tbl.getRow(ii);
            IRow rowOld = this.tbl.getRow(j);
            String newAstType = (String)rowNew.getCell(4).getValue();
            oldAstType = (String)rowOld.getCell(4).getValue();
            String newAstName = (String)rowNew.getCell(2).getValue();
            oldAstName = (String)rowOld.getCell(2).getValue();
            String newNumber = (String)rowNew.getCell(1).getValue();
            oldNumber = (String)rowOld.getCell(1).getValue();
            if (newAstType.equals(oldAstType) && newAstName.equals(oldAstName) && newNumber.equals(oldNumber) || (actCurrency = (List)resultMap.get(oldAstType + oldNumber + oldAstName)) == null) continue;
            for (int k = 0; k < actCurrency.size(); ++k) {
                rsLocation = (Integer)actCurrency.get(k);
                this.fillTable(rowSet, rsLocation, j + k);
                ++ii;
            }
        }
        IRow rowTwo = this.tbl.getRow(this.tbl.getRowCount() - 1);
        if (rowTwo == null) {
            return;
        }
        oldAstType = (String)rowTwo.getCell(4).getValue();
        oldAstName = (String)rowTwo.getCell(2).getValue();
        oldNumber = (String)rowTwo.getCell(1).getValue();
        actCurrency = (List)resultMap.get(oldAstType + oldNumber + oldAstName);
        if (actCurrency != null) {
            for (int k = 0; k < actCurrency.size(); ++k) {
                rsLocation = (Integer)actCurrency.get(k);
                this.fillTable(rowSet, rsLocation, -1);
            }
        }
    }

    private void dealWithSumByActType(RptParams rp) {
        RptRowSet sumRsThree = (RptRowSet)rp.getObject("sumRsThree");
        RptRowSet sumRsTwo = (RptRowSet)rp.getObject("sumRsTwo");
        RptRowSet sumRsOne = (RptRowSet)rp.getObject("sumRsOne");
        this.dealWithSumByResultOne(sumRsOne);
        if (sumRsTwo == null) {
            return;
        }
        this.dealWithSumByResultTwo(sumRsTwo);
        if (sumRsThree == null) {
            return;
        }
        int cols = sumRsThree.getColumnCount();
        CurrencyInfo ci = RptClientUtil.searchCurrency((CurrencyCollection)this.getUIContextInitParams().getObject("currency"), SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
        String strDebit = GLResUtil.getRes("debit");
        String strCredit = GLResUtil.getRes("credit");
        sumRsThree.reset();
        while (sumRsThree.next()) {
            IRow row = this.tbl.addRow();
            int precision = sumRsThree.getInt("FPrecision");
            int fdc = sumRsThree.getInt("FDC");
            String accountDirect = GlUtils.zero.compareTo(sumRsThree.getBigDecimal("FENDBALANCELOCAL")) == 0 && GlUtils.zero.compareTo(sumRsThree.getBigDecimal("FENDBALANCEFOR")) == 0 ? GLResUtil.getRes("dir_equal") : (fdc == 1 ? strDebit : strCredit);
            for (int i = 0; i < cols; ++i) {
                if (i < 10 || i >= cols - 1) {
                    row.getCell(i).setValue(sumRsThree.getObject(i));
                    continue;
                }
                if (i != 22) {
                    row.getCell(i).setValue(((BigDecimal)sumRsThree.getObject(i)).floatValue() == 0.0f ? null : sumRsThree.getObject(i));
                    if (i < 22 && i % 2 == 0 || i > 22 && (i + 1) % 2 == 0) {
                        row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
                        continue;
                    }
                    row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(ci.getPrecision()));
                    continue;
                }
                row.getCell(i).setValue((Object)accountDirect);
            }
            row.getStyleAttributes().setBackground(this.tbl.getRequiredColor());
        }
        this.updateCreditAndDebit();
    }

    private void dealWithSum(RptParams rp) {
        RptRowSet sumRsThree = (RptRowSet)rp.getObject("sumRsThree");
        if (sumRsThree == null) {
            return;
        }
        int cols = sumRsThree.getColumnCount();
        CurrencyInfo ci = RptClientUtil.searchCurrency((CurrencyCollection)this.getUIContextInitParams().getObject("currency"), SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
        String strDebit = GLResUtil.getRes("debit");
        String strCredit = GLResUtil.getRes("credit");
        sumRsThree.reset();
        int k = 0;
        Object[] sum = new Object[sumRsThree.getColumnCount()];
        if (sumRsThree.getRowCount() > 1) {
            sumRsThree.addRow(sum);
            BigDecimal fyearbeginbalancelocal = new BigDecimal(0);
            BigDecimal fbeginbalancelocal = new BigDecimal(0);
            BigDecimal fdebitlocal = new BigDecimal(0);
            BigDecimal fcreditlocal = new BigDecimal(0);
            BigDecimal fyeardebitlocal = new BigDecimal(0);
            BigDecimal fyearcreditlocal = new BigDecimal(0);
            BigDecimal fendbalancelocal = new BigDecimal(0);
            String faccountnumber = "";
            while (sumRsThree.next()) {
                if (++k < sumRsThree.getRowCount()) {
                    fyearbeginbalancelocal = fyearbeginbalancelocal.add(sumRsThree.getBigDecimal("fyearbeginbalancelocal"));
                    fbeginbalancelocal = fbeginbalancelocal.add(sumRsThree.getBigDecimal("fbeginbalancelocal"));
                    fdebitlocal = fdebitlocal.add(sumRsThree.getBigDecimal("fdebitlocal"));
                    fcreditlocal = fcreditlocal.add(sumRsThree.getBigDecimal("fcreditlocal"));
                    fyeardebitlocal = fyeardebitlocal.add(sumRsThree.getBigDecimal("fyeardebitlocal"));
                    fyearcreditlocal = fyearcreditlocal.add(sumRsThree.getBigDecimal("fyearcreditlocal"));
                    fendbalancelocal = fendbalancelocal.add(sumRsThree.getBigDecimal("fendbalancelocal"));
                    faccountnumber = sumRsThree.getString("faccountnumber");
                    continue;
                }
                sumRsThree.setValue("fyearbeginbalancelocal", (Object)fyearbeginbalancelocal);
                sumRsThree.setValue("fbeginbalancelocal", (Object)fbeginbalancelocal);
                sumRsThree.setValue("fdebitlocal", (Object)fdebitlocal);
                sumRsThree.setValue("fcreditlocal", (Object)fcreditlocal);
                sumRsThree.setValue("fyeardebitlocal", (Object)fyeardebitlocal);
                sumRsThree.setValue("fyearcreditlocal", (Object)fyearcreditlocal);
                sumRsThree.setValue("fendbalancelocal", (Object)fendbalancelocal);
                sumRsThree.setValue("FACCOUNTNUMBER", (Object)faccountnumber);
            }
            sumRsThree.reset();
        }
        k = 0;
        while (sumRsThree.next()) {
            String accountDirect;
            int precision;
            IRow row = this.tbl.addRow();
            this.rsParame.addRow(sumRsThree.toRowArray());
            if (sumRsThree.getRowCount() > 1) {
                ++k;
            }
            if (k < sumRsThree.getRowCount()) {
                precision = sumRsThree.getInt("FPrecision");
                int fdc = sumRsThree.getInt("FDC");
                accountDirect = GlUtils.zero.compareTo(sumRsThree.getBigDecimal("FENDBALANCELOCAL")) == 0 && GlUtils.zero.compareTo(sumRsThree.getBigDecimal("FENDBALANCEFOR")) == 0 ? GLResUtil.getRes("dir_equal") : (fdc == 1 ? strDebit : strCredit);
            } else {
                accountDirect = "";
                precision = 0;
            }
            for (int i = 0; i < cols; ++i) {
                if (i < 10 || i >= cols - 1) {
                    row.getCell(i).setValue(sumRsThree.getObject(i));
                    continue;
                }
                if (i != 22) {
                    if (sumRsThree.getObject(i) != null && sumRsThree.getObject(i) instanceof BigDecimal) {
                        row.getCell(i).setValue(((BigDecimal)sumRsThree.getObject(i)).floatValue() == 0.0f ? null : sumRsThree.getObject(i));
                    } else {
                        row.getCell(i).setValue(null);
                    }
                    if (i < 22 && i % 2 == 0 || i > 22 && (i + 1) % 2 == 0) {
                        row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
                        continue;
                    }
                    row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(ci.getPrecision()));
                    continue;
                }
                row.getCell(i).setValue((Object)accountDirect);
            }
            row.getStyleAttributes().setBackground(this.tbl.getRequiredColor());
        }
        this.updateCreditAndDebit();
    }

    private void updateCreditAndDebit() {
        IRow row = null;
        for (int ii = 0; ii < this.tbl.getRowCount(); ++ii) {
            row = this.tbl.getRow(ii);
            Object year = row.getCell(8).getValue();
            if (year != null) continue;
            row.getCell(22).setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinQueryAsstactList(int selectedRow) throws Exception {
        try {
            AsstactTypeEntity at;
            int i;
            this.setCursorOfWair();
            RptParams pp = new RptParams();
            IRow row = this.tbl.getRow(selectedRow);
            if (row == null) {
                return;
            }
            pp.setObject("company", (Object)this.currCompany);
            pp.setObject("jspYearFrom", this.params.getObject("spnPeriodYearFrom"));
            pp.setObjectElement("jspYearFrom.name", (Object)"jspYearFrom");
            pp.setObject("jspYearTo", this.params.getObject("spnPeriodYearTo"));
            pp.setObjectElement("jspYearTo.name", (Object)"jspYearTo");
            pp.setObject("jspPeriodFrom", this.params.getObject("spnPeriodNumberFrom"));
            pp.setObjectElement("jspPeriodFrom.name", (Object)"jspPeriodFrom");
            pp.setObject("jspPeriodTo", this.params.getObject("spnPeriodNumberTo"));
            pp.setObjectElement("jspPeriodTo.name", (Object)"jspPeriodTo");
            AccountViewInfo av = new AccountViewInfo();
            av.setNumber((String)row.getCell(5).getValue());
            String displayName = (String)row.getCell(6).getValue();
            av.setDisplayName(displayName);
            int _i = displayName.lastIndexOf(95);
            if (_i == -1) {
                av.setName(displayName);
            } else {
                av.setName(displayName.substring(_i + 1));
            }
            RptConditionManager.ComponentStatus cs = new RptConditionManager.ComponentStatus();
            cs.setName("jebAccountFrom");
            cs.setEnabled(true);
            cs.setValue((Object)av);
            pp.setObject("jebAccountFrom", (Object)cs);
            cs = new RptConditionManager.ComponentStatus();
            cs.setName("jebAccountTo");
            cs.setEnabled(true);
            cs.setValue((Object)av);
            pp.setObject("jebAccountTo", (Object)cs);
            pp.setObjectElement("jebAccountFrom.value", (Object)av);
            pp.setObjectElement("jebAccountTo.value", (Object)av);
            cs = new RptConditionManager.ComponentStatus();
            cs.setName("jbxCurrency");
            cs.setEnabled(true);
            pp.setObject("jbxCurrency", (Object)cs);
            String currency = (String)row.getCell(7).getValue();
            CurrencyCollection cc = (CurrencyCollection)this.getUIContextInitParams().getObject("currency");
            for (int i2 = 0; i2 < cc.size(); ++i2) {
                if (!currency.equals(cc.get(i2).getName())) continue;
                cs.setValue((Object)cc.get(i2));
                break;
            }
            pp.setObject("jbxCurrency", (Object)cs);
            pp.setObject("jcbIncludeUnPost", this.params.getObject("cbIncludeNoPost"));
            pp.setObjectElement("jcbIncludeUnPost.name", (Object)"jcbIncludeUnPost");
            pp.setObject("jcbNoDisplayZero", this.params.getObject("jcbNoDisplayZero"));
            pp.setObject("jspLevelFrom", this.params.getObject("spnLevelFrom"));
            pp.setObjectElement("jspLevelFrom.name", (Object)"jspLevelFrom");
            pp.setObject("jspLevelTo", this.params.getObject("spnLevelTo"));
            pp.setObjectElement("jspLevelTo.name", (Object)"jspLevelFrom");
            pp.setObject("ckbNoDisplayBalanceZero", this.params.getObject("ckbNoDisplayBalanceZero"));
            pp.setObject("jcbNoDisplayAllZero", this.params.getObject("ckbNoDisplayBalanceZeroUnhappen"));
            pp.setObject("jcbShowSum", this.params.getObject("sumByAsst"));
            List actList = RptClientUtil.queryAsstAct(null, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
            String rowItemId = (String)row.getCell(0).getValue();
            String rowActId = (String)row.getCell(3).getValue();
            int itemIndex = 0;
            int n = actList.size();
            for (i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)actList.get(i);
                at.setSelected(false);
            }
            for (i = 0; i < actList.size(); ++i) {
                at = (AsstactTypeEntity)actList.get(i);
                if (!rowActId.equals(at.getId())) continue;
                at.setSelected(true);
                RptParams actItem = RptClientUtil.getAsstactItemInfo(rowItemId, rowActId);
                at.setSelectedLevel(actItem.getInt("FLevel"));
                DataBaseDInfo db = new DataBaseDInfo();
                db.setString("number", actItem.getString("FNumber"));
                db.setString("longnumber", actItem.getString("FLongNumber"));
                db.setString("id", rowItemId);
                db.setString("name", actItem.getString("FName"));
                at.setFrom(db);
                at.setTo(db);
                ++itemIndex;
            }
            pp.setObject("tableData", (Object)actList);
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)pp);
            ctx.put((Object)"UIClassParam", (Object)rowItemId);
            CommRptBaseUI ui = this.createJoinQueryUIWindow(RptAsstactGDUI.class, ctx, pp);
            ui.getUIWindow().show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(RptAsstactBalanceUI.getResourceString((String)"print_label_period")).append("&[Period]").append("&|").append(RptAsstactBalanceUI.getResourceString((String)"print_label_currency")).append("&[Currency]").append("&|").append(RptAsstactBalanceUI.getResourceString((String)"print_label_company")).append("&[Company]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(RptAsstactBalanceUI.getResourceString((String)"print_label_asstact")).append("&[Asstact]").append("&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Period", this.lblPeriod.getText());
        map.put("Currency", this.lblCurrency.getText());
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Asstact", this.lblAsstActItem.getText());
        if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
            map.put("Person", SysContext.getSysContext().getCurrentUserInfo().getName());
        } else {
            map.put("Person", SysContext.getSysContext().getCurrentUserInfo().toString());
        }
        return map;
    }

    @Override
    public void actionMenuItemPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.RptAsstactBalancePrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.tbl.getBody().getRows().size() != 0) {
            if (!this.editParame.isChkPrintParame()) {
                super.actionPrint_actionPerformed(e);
            } else if (!GlUtils.isCompanyUnion(this.currCompany)) {
                this.invokePrintFunc(e, false);
            } else {
                super.actionPrint_actionPerformed(e);
            }
        } else {
            this.showInfoCom();
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.tbl.getBody().getRows().size() != 0) {
            if (!this.editParame.isChkPrintParame()) {
                super.actionPrintPreview_actionPerformed(e);
            } else if (!GlUtils.isCompanyUnion(this.currCompany)) {
                this.invokePrintFunc(e, true);
            } else {
                super.actionPrintPreview_actionPerformed(e);
            }
        } else {
            this.showInfoCom();
        }
    }

    private void showInfoCom() {
        KDTable tbl = this.getTableForPrintSetting();
        tbl.getPrintManager().getNewPrintManager().getPrinter().prompt(Resources.getMsg((String)"prompt.nocontent"));
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        boolean bBF = this.editParame.isChkBF();
        String strTemplatepathPath = null;
        strTemplatepathPath = this.editParame.getStrTempletpathPath();
        String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
        if (strTemplatepathPath == null && StringUtils.isEmpty((String)strTemplatepathPath)) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"notTemplet");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        RptAsstactBalanceTaoDa rsprv = new RptAsstactBalanceTaoDa(this.mapParame, this.rsParame, bBF);
        appHlp.directPrint(strTemplatepathPath, (Object)rsprv, noPreview, (Component)((Object)this));
    }
}

