/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.RptAsstActCrossFacadeFactory;
import com.kingdee.eas.fi.gl.StatisticTypeEnum;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactCrossUI;
import com.kingdee.eas.fi.gl.client.RptAsstactCrossConditionUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;

public class RptAsstactCrossUI
extends AbstractRptAsstactCrossUI {
    protected ArrayList acctAsstList;
    private RptParams sysParams;
    String hAsstActId = null;
    String hAsstActNumber = null;
    StringBuffer hAsstActName = new StringBuffer("");
    String vAsstActId = null;
    String vAsstActNumber = null;
    StringBuffer vAsstActName = new StringBuffer("");
    StringBuffer asstActName = new StringBuffer("");

    public RptAsstactCrossUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.tblMain.setColumnMoveable(false);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.tHelper.setCanMoveColumn(true);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return RptAsstActCrossFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void setUIContextInitParams(RptParams aParams) {
        super.setUIContextInitParams(aParams);
        this.sysParams = (RptParams)aParams.getObject("sysParams");
        if (aParams.getObject("defaultParam") != null) {
            this.params = (RptParams)aParams.getObject("defaultParam");
            this.setShowDialogOnLoad(false);
        }
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new RptAsstactCrossConditionUI();
    }

    protected void query() {
        this.setCursorOfWair();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        BOSUuid companyId = company.getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        AccountTableInfo account = company.getAccountTable();
        ObjectUuidPK accountTablePK = new ObjectUuidPK(account.getId());
        String asstAccountNameFrom = (String)this.params.getObjectElement("jebAccountFrom.value.name");
        String asstAccountNameTo = (String)this.params.getObjectElement("jebAccountTo.value.name");
        String asstAccountNumberFrom = (String)this.params.getObjectElement("jebAccountFrom.value.number");
        String asstAccountNumberTo = (String)this.params.getObjectElement("jebAccountTo.value.number");
        if (this.sysParams.getBoolean("GL_012")) {
            try {
                if (asstAccountNumberFrom != null && !asstAccountNumberFrom.equals("")) {
                    AccountViewInfo accountFrom = AccountUtils.getAccountViewCByNumber((String)asstAccountNumberFrom, (IObjectPK)companyPK, (IObjectPK)accountTablePK);
                    asstAccountNameFrom = accountFrom.getLongName();
                }
                if (asstAccountNumberTo != null && !asstAccountNumberTo.equals("")) {
                    AccountViewInfo accountTo = AccountUtils.getAccountViewCByNumber((String)asstAccountNumberTo, (IObjectPK)companyPK, (IObjectPK)accountTablePK);
                    asstAccountNameTo = accountTo.getLongName();
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (asstAccountNameFrom == null) {
            asstAccountNameFrom = "";
        }
        if (asstAccountNameTo == null) {
            asstAccountNameTo = "";
        }
        StringBuffer accountName = new StringBuffer("");
        if (!asstAccountNameFrom.equals("")) {
            accountName.append(asstAccountNameFrom);
        }
        if (!(asstAccountNameFrom.equals("") || asstAccountNameTo.equals("") || asstAccountNameFrom.equals(asstAccountNameTo))) {
            accountName.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"130_RptAsstactCrossUI"));
        }
        if (!asstAccountNameTo.equals("") && !asstAccountNameFrom.equals(asstAccountNameTo)) {
            accountName.append(asstAccountNameTo);
        }
        this.jtAsst2.setText(accountName.toString());
        this.jtAsst2.setToolTipText(accountName.toString());
        this.jtCurrency2.setText(String.valueOf(this.params.getObjectElement("jbxCurrency.value")));
        String strjtPeriod2 = RptClientUtil.getPeriodTitle((Integer)this.params.getObjectElement("jspYearFrom.value"), (Integer)this.params.getObjectElement("jspPeriodFrom.value"), (Integer)this.params.getObjectElement("jspYearTo.value"), (Integer)this.params.getObjectElement("jspPeriodTo.value"));
        this.jtPeriod2.setText(strjtPeriod2);
        StatisticTypeEnum statisticType = (StatisticTypeEnum)((Object)this.params.getObjectElement("combStatisticType.value"));
        this.jtStatisticType.setText(statisticType.getAlias());
        ArrayList actList = this.getActList();
        StringBuffer sb = new StringBuffer();
        int n = actList.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            if (i == 0) {
                this.asstActName.setLength(0);
                this.asstActName.append(at.getName());
            }
            sb.append(at.getName()).append("/ ");
        }
        sb.setLength(sb.length() - 2);
        this.jtAsstact2.setText(sb.toString());
        this.jtAsstact2.setToolTipText(sb.toString());
        this.requestTableData();
        this.setCursorOfDefault();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.checkTableCommonMenu(this.tblMain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTableData() {
        try {
            this.setCursorOfWair();
            this.tblMain.removeRows();
            this.tblMain.setRefresh(false);
            RptParams pp = (RptParams)this.params.clone();
            pp.remove("tableData");
            pp.setObject("actList", (Object)this.getActList());
            pp.setString("tempTable", this.getTempTable());
            pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
            pp.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            pp.setString("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            RptParams rpt = null;
            rpt = RptAsstActCrossFacadeFactory.getRemoteInstance().query(pp);
            RptRowSet rs = (RptRowSet)rpt.getObject("rs");
            RptRowSet headRs = (RptRowSet)rpt.getObject("headRs");
            this.buildTableHead(headRs);
            this.fillTableData(rs);
            this.tblMain.updateUI();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.tblMain.setRefresh(true);
            this.setCursorOfDefault();
        }
    }

    private void buildTableHead(RptRowSet headRs) {
        this.tblMain.removeColumns();
        IRow headRow = this.tblMain.addHeadRow();
        ArrayList actList = this.getActList();
        for (int i = 0; i < actList.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)actList.get(i);
            String tab = at.getHgAttribute();
            if (i == 0) {
                this.vAsstActId = tab + "Id";
                this.vAsstActNumber = tab + "Number";
                this.vAsstActName.setLength(0);
                this.vAsstActName.append(tab).append("Name");
                continue;
            }
            this.hAsstActId = tab + "Id";
            this.hAsstActNumber = tab + "Number";
            this.hAsstActName.setLength(0);
            this.hAsstActName.append(tab).append("Name");
            IColumn col = this.tblMain.addColumn();
            col.setWidth(180);
            col.setKey(this.hAsstActId);
            headRow.getCell(this.hAsstActId).setValue((Object)at.getName());
        }
        boolean isShowNumber = this.sysParams.getBoolean("GL_004");
        int precision = 2;
        if (this.params.getObjectElement("jbxCurrency.value.precision") != null) {
            precision = (Integer)this.params.getObjectElement("jbxCurrency.value.precision");
        }
        while (headRs.next()) {
            String field = headRs.getString(this.vAsstActId);
            String fieldNumber = headRs.getString(this.vAsstActNumber);
            String fieldName = headRs.getString(this.vAsstActName.toString());
            IColumn col = this.tblMain.addColumn();
            col.setKey(field.toString());
            col.setWidth(150);
            if ("1".equals(field)) {
                col.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
            }
            col.getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(precision));
            headRow.getCell(field).setValue((Object)(isShowNumber && !"1".equals(field) ? fieldNumber + " " + fieldName : fieldName));
        }
        this.tblMain.getHeadMergeManager().setMergeMode(0);
    }

    private void fillTableData(RptRowSet rs) {
        BigDecimal statisticAmount = new BigDecimal("0.0");
        IRow row = null;
        boolean isShowNumber = this.sysParams.getBoolean("GL_004");
        String asstActIdOld = "";
        while (rs.next()) {
            String asstActId = rs.getString(this.hAsstActId);
            String asstActNumber = rs.getString(this.hAsstActNumber);
            String asstActName = rs.getString(this.hAsstActName.toString());
            if (!asstActIdOld.equalsIgnoreCase(asstActId)) {
                row = this.tblMain.addRow();
                if ("2".equals(asstActId)) {
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
                }
                row.getCell(this.hAsstActId).setValue((Object)(isShowNumber && !"2".equals(asstActId) ? asstActNumber + " " + asstActName : asstActName));
            }
            asstActIdOld = asstActId;
            String vAsstActIDCol = rs.getString(this.vAsstActId);
            statisticAmount = rs.getBigDecimal("FAmount");
            if (row == null) continue;
            row.getCell(vAsstActIDCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (statisticAmount.compareTo(new BigDecimal("0.0")) == 0) {
                row.getCell(vAsstActIDCol).setValue(null);
                continue;
            }
            row.getCell(vAsstActIDCol).setValue((Object)statisticAmount);
        }
    }

    public void tableDataRequest(KDTDataRequestEvent arg0) {
    }

    protected ArrayList getActList() {
        boolean tableDataHasChaged;
        boolean bl = tableDataHasChaged = this.params.getObject("tableDataHasChaged") == null ? true : (Boolean)this.params.getObject("tableDataHasChaged");
        if (tableDataHasChaged) {
            this.acctAsstList = new ArrayList();
            List list = (List)this.params.getObject("tableData");
            AsstactTypeEntity at = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                if (!at.isSelected()) continue;
                this.acctAsstList.add(at);
            }
            this.params.setObject("tableDataHasChaged", (Object)Boolean.FALSE);
        }
        return this.acctAsstList;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.jtAsst.getText()).append("&[Asst]&|").append(this.jtAsstact.getText()).append("&[AsstAct]&| ").append(this.kDLabel1.getText()).append("&[StatisticType]&|");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(RptAsstactCrossUI.getResourceString((String)"print_label_period")).append("&[Period]&|").append(RptAsstactCrossUI.getResourceString((String)"print_label_currency")).append("&[Currency]&| ").append(RptAsstactCrossUI.getResourceString((String)"print_label_company")).append("&[Company]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Period", this.jtPeriod2.getText());
        map.put("Currency", this.jtCurrency2.getText());
        map.put("Asst", this.jtAsst2.getText());
        map.put("AsstAct", this.jtAsstact2.getText());
        map.put("StatisticType", this.jtStatisticType.getText());
        return map;
    }
}

