/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IMeasureUnitGroup;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactGDConditionUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAsstactGDConditionUI
extends AbstractRptAsstactGDConditionUI {
    private static final long serialVersionUID = -964393885306351235L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactGDConditionUI.class);
    private MeasureUnitInfo standardUnit = null;
    private String standardUnitGroupid = null;
    private int currYear = 0;
    private int currMonth = 0;
    boolean isCleared = false;
    boolean isQueryByOther = false;

    public RptAsstactGDConditionUI() throws Exception {
        this.setSize(420, 400);
    }

    @Override
    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.jbxCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        this.jebMeasureUnit.setEnabled(false);
        this.jcbSumByMeasureUnit.setEnabled(false);
        this.jcbExchangeStandardUnit.setEnabled(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isDisabled", (Object)new Integer(0)));
        this.jebMeasureUnit.setEditable(true);
        this.jebMeasureUnit.setEditFormat("$number$");
        this.jebMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.jebMeasureUnit.setCommitFormat("$number$;$name$");
        this.jebMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.jebMeasureUnit.setSelectorCollection(sic);
        PeriodEntity pe = (PeriodEntity)initParams.getObject("pe");
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        this.jebMeasureUnit.setEntityViewInfo(view);
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    RptAsstactGDConditionUI.this.changeMeasureUnitFilter();
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    RptAsstactGDConditionUI.this.tbl.getCell(e.getRowIndex(), 0).setValue(e.getValue());
                    RptAsstactGDConditionUI.this.changeMeasureUnitFilter();
                }
            }
        });
        this.jcbDisplayAttribute.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        RptAsstactGDConditionUI.this.showQueryItemsForZDY(true);
                    }
                    catch (BOSException e1) {
                        RptAsstactGDConditionUI.this.handUIException(e1);
                    }
                } else {
                    try {
                        RptAsstactGDConditionUI.this.showQueryItemsForZDY(false);
                    }
                    catch (BOSException e1) {
                        RptAsstactGDConditionUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.lblCompanyLevel.setVisible(false);
        this.lblCompanyLevel.setEnabled(false);
        this.spCompanyLevel.setVisible(false);
        this.spCompanyLevel.setEnabled(false);
        this.jcbNoDisplayYearZero.setVisible(false);
        this.jcbNoDisplayYearZero.setEditable(false);
    }

    @Override
    public void onInit2(RptParams initParams) throws Exception {
        if (GlUtils.isCompanyUnion(this.company)) {
            throw new GLException(GLException.COMMUSTBECOMMANY);
        }
        this.tbl.getColumn("type").setWidth(100);
        this.tbl.getColumn("from").setWidth(100);
        this.tbl.getColumn("to").setWidth(100);
        this.tbl.getColumn("collect").getStyleAttributes().setHided(true);
        this.tbl.getColumn("maxLevel").getStyleAttributes().setHided(true);
        this.tbl.removeColumn(this.tbl.getColumnIndex("collect"));
        this.tbl.removeColumn(this.tbl.getColumnIndex("group"));
        this.tfCompany.setText(this.company.getName());
        this.tfCompany.setToolTipText(this.company.getName());
        this.bpAccount.setValue((Object)this.company.getAccountTable());
        this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        this.bpPeriod.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void jcbDisplayAmount_stateChanged(ChangeEvent e) throws Exception {
        if (this.jcbDisplayAmount.isSelected()) {
            this.jebMeasureUnit.setEnabled(true);
            this.jcbExchangeStandardUnit.setEnabled(true);
            if (!this.jbxCurrency.getSelectedItem().equals(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"113_ReportJournalConditionUI"))) {
                this.jcbSumByMeasureUnit.setEnabled(true);
            }
        } else {
            this.jebMeasureUnit.setEnabled(false);
            this.jebMeasureUnit.setValue(null);
            this.jcbExchangeStandardUnit.setEnabled(false);
            this.jcbExchangeStandardUnit.setSelected(false);
            this.jcbSumByMeasureUnit.setEnabled(false);
            this.jcbSumByMeasureUnit.setSelected(false);
        }
    }

    @Override
    protected void jbxCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (this.jbxCurrency.getSelectedItem().equals(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"113_ReportJournalConditionUI"))) {
            this.jcbSumByMeasureUnit.setEnabled(false);
            this.jcbSumByMeasureUnit.setSelected(false);
        } else if (this.jcbDisplayAmount.isSelected()) {
            this.jcbSumByMeasureUnit.setEnabled(true);
        }
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (e == null) {
            super.jebAcct_dataChanged(e);
        } else {
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if (newValue == null && oldValue != null || newValue != null && oldValue == null || newValue != null && !newValue.equals(oldValue)) {
                super.jebAcct_dataChanged(e);
            }
        }
        this.jebMeasureUnit.setValue(null);
        this.changeMeasureUnitFilter();
    }

    private void changeMeasureUnitFilter() {
        AsstactTypeEntity at;
        List list = super.getTableData();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isDisabled", (Object)new Integer(0)));
        Object value = this.jebAcct.getValue();
        if (value != null && ((AsstAccountInfo)value).getMeasureUnitGroup() != null) {
            fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)((AsstAccountInfo)value).getMeasureUnitGroup().getId()));
            this.standardUnitGroupid = ((AsstAccountInfo)value).getMeasureUnitGroup().getId().toString();
            filter.setMaskString("#0 and #1 ");
        }
        for (int i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            if (at.isSelected()) continue;
            list.remove(i);
            --i;
        }
        boolean hasSelected = list.size() > 0;
        this.jebMeasureUnit.setValue(null);
        if (value == null && hasSelected) {
            StringBuffer sf;
            int from = fic.size();
            if (filter.getMaskString() == null) {
                sf = new StringBuffer();
                sf.append(" #0 ");
            } else {
                sf = new StringBuffer(filter.getMaskString());
            }
            this.standardUnitGroupid = null;
            this.standardUnit = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                sf.append(" and ");
                at = (AsstactTypeEntity)list.get(i);
                if (at.getAsstMeasureUnitGroupId() == null) continue;
                fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)at.getAsstMeasureUnitGroupId()));
                this.standardUnitGroupid = at.getAsstMeasureUnitGroupId();
                sf.append("#").append(from++);
            }
            filter.setMaskString(sf.toString());
        }
        this.jebMeasureUnit.setEditFormat("$number$");
        this.jebMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.jebMeasureUnit.setCommitFormat("$number$;$name$");
        this.jebMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.jebMeasureUnit.setSelectorCollection(sic);
        this.jebMeasureUnit.setEntityViewInfo(view);
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        super.kdUp_actionPerformed(e);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        super.kdDown_actionPerformed(e);
    }

    @Override
    protected void jcbShowAll_actionPerformed(ActionEvent e) throws Exception {
        super.jcbShowAll_actionPerformed(e);
    }

    @Override
    protected void setMaxLevelCell(IRow row, AsstactTypeEntity at) {
        int selectedLevel;
        int maxLevel = at.getMaxLevel() > 0 ? at.getMaxLevel() : 1;
        int n = selectedLevel = at.getSelectedLevel() > maxLevel ? maxLevel : at.getSelectedLevel();
        if (maxLevel > 0 && selectedLevel == 0) {
            selectedLevel = 1;
        }
        final SpinnerNumberModel sm = new SpinnerNumberModel(selectedLevel, maxLevel > 0 ? 1 : 0, maxLevel, 1);
        final IRow atrow = row;
        sm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                atrow.getCell("maxLevel").setValue(sm.getValue());
            }
        });
        KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
        row.getCell("maxLevel").setValue((Object)new Integer(selectedLevel));
        row.getCell("maxLevel").setEditor((ICellEditor)sce);
        sce.setEditable(maxLevel > 0);
        sce.setEnabled(maxLevel > 0);
    }

    @Override
    protected boolean checkColect() {
        return false;
    }

    @Override
    protected void fillAccLevelSpinner(int maxLevel) {
        SpinnerUtil.manageAccountLevelRange2((int)1, (int)maxLevel, (KDSpinner)this.jspLevelFrom, (KDSpinner)this.jspLevelTo);
    }

    @Override
    public void clear() {
        if (Boolean.valueOf(String.valueOf(this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
            this.getUIContext().put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", false);
            return;
        }
        this.jspYearFrom.setValue((Object)new Integer(this.currYear));
        this.jspYearTo.setValue((Object)new Integer(this.currYear));
        this.jspPeriodFrom.setValue((Object)new Integer(this.currMonth));
        this.jspPeriodTo.setValue((Object)new Integer(this.currMonth));
        this.rdFirstAccount.setSelected(true);
        this.jebAcct.setValue(null);
        try {
            this.jebAcct_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Integer ONE = new Integer(1);
        this.jspLevelFrom.setValue((Object)ONE);
        this.jspLevelTo.setValue((Object)ONE);
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
            Object value = this.jbxCurrency.getItemAt(i);
            if (!(value instanceof CurrencyInfo) || !this.company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
            this.jbxCurrency.setSelectedItem(value);
        }
        this.jebMeasureUnit.setValue(null);
        this.jcbIncludeUnPost.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        this.jcbDisplayAttribute.setSelected(false);
        this.jcbNoDisplayZeroTotal.setSelected(false);
        this.jcbDisplayAmount.setSelected(false);
        this.jcbNoDisplayAllZero.setSelected(false);
        this.jcbExchangeStandardUnit.setSelected(false);
        this.jcbShowSum.setSelected(false);
        this.jcbSumByMeasureUnit.setSelected(false);
        this.jcbincludeNoTransPLVoucher.setSelected(false);
        this.jcbShowOnlySubAccountview.setSelected(false);
        this.jcbNoDisplayYearZero.setSelected(false);
        this.standardUnit = null;
        this.standardUnitGroupid = null;
        try {
            this.showQueryItemsForZDY(false);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        this.jcbEndPeriod.setSelected(false);
    }

    @Override
    public void setCustomCondition(RptParams params) {
        super.setCustomCondition(params);
        this.jebMeasureUnit.setValue(params.getObjectElement("jebMeasureUnit.value"));
        if (params.getObjectElement("jcbShowSum.value") != null) {
            this.jcbShowSum.setSelected(((Boolean)params.getObjectElement("jcbShowSum.value")).booleanValue());
        }
        this.standardUnit = (MeasureUnitInfo)params.getObject("standardUnitValue");
        if (params.getObjectElement("jcbDisplayAttribute.value") != null && ((Boolean)params.getObjectElement("jcbDisplayAttribute.value")).booleanValue()) {
            try {
                this.showQueryItemsForZDY(true);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            try {
                this.showQueryItemsForZDY(false);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptParams rr = super.getCustomCondition();
        if (this.standardUnitGroupid != null) {
            try {
                IMeasureUnitGroup iunitGroup = MeasureUnitGroupFactory.getRemoteInstance();
                ObjectUuidPK pk = new ObjectUuidPK(this.standardUnitGroupid);
                SelectorItemCollection sicUnitGroup = new SelectorItemCollection();
                sicUnitGroup.add(new SelectorItemInfo("defaultUnit"));
                MeasureUnitGroupInfo unitGroupInfo = iunitGroup.getMeasureUnitGroupInfo((IObjectPK)pk, sicUnitGroup);
                IMeasureUnit iunit = MeasureUnitFactory.getRemoteInstance();
                if (unitGroupInfo.getDefaultUnit() != null) {
                    pk = new ObjectUuidPK(unitGroupInfo.getDefaultUnit().getId());
                    this.standardUnit = iunit.getMeasureUnitInfo((IObjectPK)pk);
                    this.standardUnitGroupid = null;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
        rr.setObject("standardUnitValue", (Object)this.standardUnit);
        return rr;
    }

    @Override
    public void actionRadioButton_actionPerformed(ActionEvent e) throws Exception {
        if (this.rdFirstAccount.isSelected()) {
            this.jcbEndPeriod.setEnabled(true);
        } else if (this.rdFirstPeriod.isSelected()) {
            this.jcbEndPeriod.setSelected(false);
            this.jcbEndPeriod.setEnabled(false);
        }
    }

    @Override
    protected boolean isGG() {
        return false;
    }

    private void showQueryItemsForZDY(boolean isShowItem) throws BOSException {
        String[] QueryItemsForRemove = new String[]{"assistRecords.settlementCode", "settlementType.number", "assistRecords.bizNumber"};
        RptClientUtil.showCommonQueryItems(this.getCommonQueryPanel(), QueryItemsForRemove, isShowItem);
    }
}

