/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gl.utils.ExcelUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class RptAsstactGDExportHelper {
    private static final Logger logger = Logger.getLogger(RptAsstactGDExportHelper.class);
    private final int ROW_TYPE_INIT = 0;
    private final int ROW_TYPE_DATA = 1;
    private final int ROW_TYPE_PERIOD = 2;
    private final int ROW_TYPE_YEAR = 3;
    private final int ROW_TYPE_SUBTOTAL = 4;
    private HSSFCellStyle headMsgStyle = null;
    private HSSFCellStyle headColumnStyle = null;
    private Map plaintStringStyleMap = new HashMap();
    private Map numberStyleMap = new HashMap();
    private Pattern toMatchZero = Pattern.compile("0.0+");
    public final short ALIGN_LEFT = HorizontalAlignment.LEFT.getCode();
    public final short ALIGN_CENTER = HorizontalAlignment.CENTER.getCode();
    public final short ALIGN_RIGHT = HorizontalAlignment.RIGHT.getCode();
    public final short ALIGN_VERTICAL_CENTER = VerticalAlignment.CENTER.getCode();
    private String[] columnSeq = null;
    private String[] columnNameSeq1 = null;
    private String[] columnNameSeq2 = null;
    private List tableData = null;
    private int[] columnContentMaxLength = null;
    private String period_total = null;
    private String sum_year = null;
    private String column_des = "FDESCRIPTION";
    private String currencyID = null;
    private boolean displayAttribute = false;
    private boolean displayAmount = false;
    private String FDebitQty = "FDebitQty";
    private String FCreditQty = "FCreditQty";
    private String FEndQty = "FEndQty";
    private String FBizNumber = "FBizNumber";
    private String FTicketNumber = "FTicketNumber";
    private boolean sumByMeasureUnit = false;
    private boolean sameAsAccount = false;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    private CurrencyInfo curinfo;
    private int currPeriod;
    private int currPeriodYear;
    private boolean isBaseCurrency = false;
    private String currencyId;
    private RptParams params = null;
    protected CompanyOrgUnitInfo currCompany;
    private static BigDecimal TEN = new BigDecimal("10");
    private Map periodValue = new HashMap();
    private Map columnType = new HashMap();
    private Map cellCreation = new HashMap();
    private Map endColumnHm = new HashMap();
    private Map columnBalance = new HashMap();
    private Map commonMerger = new HashMap();
    private String[] commonMerge = new String[]{"fdebitqty", "fdebitprice", "fcreditqty", "fcreditprice", "fendqty", "fbalanceprice", "fbiznumber", "finvoicenumber", "fsettlementcode", "settlename", "fticketnumber"};
    private Map dataDest = null;

    public void export(List data, String headMsg, RptParams sysParams, CurrencyInfo currencyInfo, boolean displayAttribute, boolean displayAmount, PeriodEntity peParam, CompanyOrgUnitInfo currCompanyParam) {
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "sheet1");
        this.currCompany = currCompanyParam;
        this.initParams(sysParams, peParam, currencyInfo);
        int atListAcmount = sysParams.getInt("atListAcmount");
        this.parseValue(data, currencyInfo, displayAttribute, displayAmount, atListAcmount);
        this.createHeadColumn(wb, sheet);
        this.createBodyColumn(wb, sheet);
        this.createHeadMsg(wb, sheet, headMsg);
        this.adjustColumnWidth(wb, sheet);
        this.writeFile(wb);
    }

    protected CompanyOrgUnitInfo getCurrentFIUnit(RptParams params) {
        if (this.currCompany != null) {
            if (params != null) {
                params.setObject("company", (Object)this.currCompany);
            }
            return this.currCompany;
        }
        if (params != null && params.getObject("company") != null) {
            return (CompanyOrgUnitInfo)params.getObject("company");
        }
        if (params != null && params.getString("cuID") != null) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)params.getString("cuID")));
            try {
                RptClientUtil.fullCompanyInfo(company, true);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            return company;
        }
        if (params != null) {
            int yearEnd = (Integer)params.getObjectElement("jspYearTo.value");
            int numberEnd = (Integer)params.getObjectElement("jspPeriodTo.value");
            return RptClientUtil.getCompany(yearEnd, numberEnd);
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    private void initParams(RptParams sysParams, PeriodEntity peParam, CurrencyInfo currencyInfo) {
        this.sameAsAccount = sysParams.getBoolean("GL_005");
        CompanyOrgUnitInfo currCompany = this.getCurrentFIUnit(sysParams);
        this.localCurrency = currCompany.getBaseCurrency();
        this.reportingCurrency = currCompany.getReportCurrency();
        if (currencyInfo != null) {
            this.curinfo = currencyInfo;
            this.currencyId = currencyInfo.getId().toString();
            this.isBaseCurrency = this.currencyId.equals(this.localCurrency.getId().toString());
        }
        this.sumByMeasureUnit = sysParams.getObjectElement("jcbSumByMeasureUnit.value") != null ? (Boolean)sysParams.getObjectElement("jcbSumByMeasureUnit.value") : false;
        this.currPeriod = peParam.getCurrentYear() * 100 + peParam.getCurrentPeriod();
        this.currPeriodYear = peParam.getCurrentYear();
        this.params = sysParams;
    }

    private void adjustColumnWidth(HSSFWorkbook wb, HSSFSheet sheet) {
        int length = -1;
        for (int i = 0; i < this.columnContentMaxLength.length; ++i) {
            length = this.columnContentMaxLength[i];
            if (length == -1) {
                length = this.columnNameSeq1[i].length();
            } else if (this.columnNameSeq1[i].length() > length) {
                length = this.columnNameSeq1[i].length();
            }
            sheet.setColumnWidth((int)((short)i), (int)((short)(length * 2 * 250)));
        }
    }

    private void parseValue(List data, CurrencyInfo currencyInfo, boolean displayAttribute2, boolean displayAmount2, int atListAcmount) {
        this.period_total = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"period_total");
        this.sum_year = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"sum_year");
        if (currencyInfo != null) {
            this.currencyID = currencyInfo.getId().toString();
        }
        this.displayAmount = displayAmount2;
        this.displayAttribute = displayAttribute2;
        this.setColumnSeq((String[])data.get(0));
        this.setColumnNameSeq1((Map)data.get(1));
        this.setColumnNameSeq2((Map)data.get(2));
        this.setTableData(data, atListAcmount);
    }

    private boolean isGeneralRptCurrency() {
        return "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyID);
    }

    private boolean isGeneralLocalCurrency() {
        return "11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyID);
    }

    private void setTableData(List data, int atListAcmount) {
        this.tableData = new ArrayList();
        int size = data.size();
        for (int i = 3; i < size; ++i) {
            this.tableData.add(data.get(i));
        }
        this.processTableData(this.tableData, atListAcmount);
    }

    private void processTableData(List tableData, int atListAcmount) {
        int size = tableData.size();
        int tmpIndex = -1;
        for (int i = 0; i < size; ++i) {
            tmpIndex = i;
            this.dealWithSingleData(tableData, (Map)tableData.get(i), tmpIndex, atListAcmount);
        }
    }

    private void dealWithSingleData(List tableData, Map singleData, int tmpIndex, int atListAcmount) {
        this.dataDest = singleData;
        int rowType = this.getInt("FRowType");
        String fdcValue = (String)singleData.get("FDC");
        int fdc = this.getFdcValue(fdcValue);
        switch (rowType) {
            case 0: {
                if (this.getInt("FPeriodYear") * 100 + this.getInt("FPeriodNumber") <= this.currPeriod) break;
                String accountNumber = this.getString("FAccountNumber");
                String currencyNumber = null;
                if (this.currencyId == null) {
                    currencyNumber = this.getString("FCurrencyNumber");
                }
                boolean foundFlag = false;
                Map hm = null;
                for (int i = tmpIndex - 1; i >= 0; --i) {
                    String ASSTITEMS;
                    hm = (Map)tableData.get(i);
                    boolean isTheSameAsst = false;
                    int asstmount = atListAcmount;
                    for (int j = 0; j < asstmount && (isTheSameAsst = (ASSTITEMS = this.getString("ASSTITEM" + j)).equals(this.getStringFromSelf(hm, "ASSTITEM" + j))); ++j) {
                    }
                    if (!accountNumber.equals(this.getStringFromSelf(hm, "FAccountNumber")) || !isTheSameAsst) continue;
                    if (this.currencyId == null) {
                        if (currencyNumber == null || !currencyNumber.equals(this.getStringFromSelf(hm, "FCurrencyNumber"))) continue;
                        foundFlag = true;
                        break;
                    }
                    foundFlag = true;
                    break;
                }
                if (!foundFlag) break;
                BigDecimal balance_for = this.getBigDecimalFromSelf(hm, "FBalance_for");
                BigDecimal balance_local = this.getBigDecimalFromSelf(hm, "FBalance_local");
                BigDecimal balance_rpt = this.getBigDecimalFromSelf(hm, "FBalance_rpt");
                BigDecimal qty = this.displayAmount ? this.getBigDecimalFromSelf(hm, "FEndQty") : GlUtils.zero;
                this.putValue(singleData, "FBalance_for", balance_for);
                this.putValue(singleData, "FBalance_local", balance_local);
                this.putValue(singleData, "FBalance_rpt", balance_rpt);
                if (!this.displayAmount) break;
                this.putValue(singleData, "FEndQty", qty);
                break;
            }
            case 1: {
                if (!this.sumByMeasureUnit || this.sumByMeasureUnit && this.getInt("isSumMU") == 0) {
                    Map hm;
                    BigDecimal preBlance_for;
                    BigDecimal debit_for = this.getObject("FDebit_for") == null ? GlUtils.zero : this.getBigDecimal("FDebit_for");
                    BigDecimal debit_local = this.getObject("FDebit_local") == null ? GlUtils.zero : this.getBigDecimal("FDebit_local");
                    BigDecimal debit_rpt = this.getObject("FDebit_rpt") == null ? GlUtils.zero : this.getBigDecimal("FDebit_rpt");
                    BigDecimal credit_for = this.getObject("FCredit_for") == null ? GlUtils.zero : this.getBigDecimal("FCredit_for");
                    BigDecimal credit_local = this.getObject("FCredit_local") == null ? GlUtils.zero : this.getBigDecimal("FCredit_local");
                    BigDecimal credit_rpt = this.getObject("FCredit_rpt") == null ? GlUtils.zero : this.getBigDecimal("FCredit_rpt");
                    BigDecimal debit_qty = GlUtils.zero;
                    if (this.displayAmount && this.getBigDecimal("FDebitQty") != null) {
                        debit_qty = this.getBigDecimal("FDebitQty");
                        if (this.params.getObjectElement("jebMeasureUnit.value") == null && this.getBigDecimal("FCoefficient") != null) {
                            debit_qty = this.getBigDecimal("FDebitQty").multiply(this.getBigDecimal("FCoefficient"));
                        }
                    }
                    BigDecimal credit_qty = GlUtils.zero;
                    if (this.displayAmount && this.getBigDecimal("FCreditQty") != null) {
                        credit_qty = this.getBigDecimal("FCreditQty");
                        if (this.params.getObjectElement("jebMeasureUnit.value") == null && this.getBigDecimal("FCoefficient") != null) {
                            credit_qty = this.getBigDecimal("FCreditQty").multiply(this.getBigDecimal("FCoefficient"));
                        }
                    }
                    preBlance_for = (preBlance_for = this.getBigDecimalFromSelf(hm = (Map)tableData.get(tmpIndex - 1), "FBalance_for")) == null ? GlUtils.zero : preBlance_for;
                    BigDecimal preBalance_local = this.getBigDecimalFromSelf(hm, "FBalance_local");
                    preBalance_local = preBalance_local == null ? GlUtils.zero : preBalance_local;
                    BigDecimal preBalance_rpt = this.getBigDecimalFromSelf(hm, "FBalance_rpt");
                    preBalance_rpt = preBalance_rpt == null ? GlUtils.zero : preBalance_rpt;
                    BigDecimal preEnd_qty = GlUtils.zero;
                    if (this.displayAmount && this.getBigDecimalFromSelf(hm, "FEndQty") != null) {
                        preEnd_qty = this.getBigDecimalFromSelf(hm, "FEndQty");
                        preEnd_qty = preEnd_qty == null ? GlUtils.zero : preEnd_qty;
                    }
                    BigDecimal balance_for = preBlance_for.add(debit_for).subtract(credit_for);
                    BigDecimal balance_local = preBalance_local.add(debit_local).subtract(credit_local);
                    BigDecimal balance_rpt = preBalance_rpt.add(debit_rpt).subtract(credit_rpt);
                    BigDecimal end_qty = preEnd_qty.add(debit_qty).subtract(credit_qty).setScale(preEnd_qty.scale(), 4);
                    this.putValue(singleData, "FBalance_for", balance_for);
                    this.putValue(singleData, "FBalance_local", balance_local);
                    this.putValue(singleData, "FBalance_rpt", balance_rpt);
                    if (!this.displayAmount) break;
                    this.putValue(singleData, "FEndQty", end_qty);
                    break;
                }
                if (!this.sumByMeasureUnit || this.getInt("isSumMU") != 1) break;
                Map hm = (Map)tableData.get(tmpIndex - 1);
                BigDecimal end_qty = this.getBigDecimalFromSelf(hm, "FEndQty");
                BigDecimal balance_for = this.getBigDecimalFromSelf(hm, "FBalance_for");
                BigDecimal balance_local = this.getBigDecimalFromSelf(hm, "FBalance_local");
                BigDecimal balance_rpt = this.getBigDecimalFromSelf(hm, "FBalance_rpt");
                this.putValue(singleData, "FEndQty", end_qty);
                this.putValue(singleData, "FBalance_for", balance_for);
                this.putValue(singleData, "FBalance_local", balance_local);
                this.putValue(singleData, "FBalance_rpt", balance_rpt);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                if (!this.params.getBoolean("onlyEndPeriod") && this.getInt("FPeriodYear") * 100 + this.getInt("FPeriodNumber") > this.currPeriod) {
                    String accountNumber = this.getString("FAccountNumber");
                    String currencyNumber = null;
                    String ASSTITEM0 = this.getString("ASSTITEM0");
                    if (this.currencyId == null) {
                        currencyNumber = this.getString("FCurrencyNumber");
                    }
                    boolean foundFlag = false;
                    Map hm = null;
                    for (int i = tmpIndex - 1; i >= 0; --i) {
                        String ASSTITEMS;
                        hm = (Map)tableData.get(i);
                        boolean isTheSameAsst = false;
                        int asstmount = atListAcmount;
                        for (int j = 0; j < asstmount && (isTheSameAsst = (ASSTITEMS = this.getString("ASSTITEM" + j)).equals(this.getStringFromSelf(hm, "ASSTITEM" + j))); ++j) {
                        }
                        if (!accountNumber.equals(this.getStringFromSelf(hm, "FAccountNumber")) || !isTheSameAsst) continue;
                        if (this.currencyId == null) {
                            if (null == currencyNumber || !currencyNumber.equals(this.getStringFromSelf(hm, "FCurrencyNumber"))) continue;
                            foundFlag = true;
                            break;
                        }
                        foundFlag = true;
                        break;
                    }
                    if (!foundFlag) break;
                    BigDecimal balance_for = this.getBigDecimalFromSelf(hm, "FBalance_for");
                    BigDecimal balance_local = this.getBigDecimalFromSelf(hm, "FBalance_local");
                    BigDecimal balance_rpt = this.getBigDecimalFromSelf(hm, "FBalance_rpt");
                    BigDecimal qty = this.displayAmount ? this.getBigDecimalFromSelf(hm, "FEndQty") : GlUtils.zero;
                    this.putValue(singleData, "FBalance_for", balance_for);
                    this.putValue(singleData, "FBalance_local", balance_local);
                    this.putValue(singleData, "FBalance_rpt", balance_rpt);
                    if (!this.displayAmount) break;
                    this.putValue(singleData, "FEndQty", qty);
                    break;
                }
                BigDecimal balance_for = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_for");
                BigDecimal balance_local = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_local");
                BigDecimal balance_rpt = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_rpt");
                BigDecimal qty = this.displayAmount ? this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FEndQty") : GlUtils.zero;
                this.putValue(singleData, "FBalance_for", balance_for);
                this.putValue(singleData, "FBalance_local", balance_local);
                this.putValue(singleData, "FBalance_rpt", balance_rpt);
                if (!this.displayAmount) break;
                this.putValue(singleData, "FEndQty", qty);
                break;
            }
            case 3: {
                if (!this.params.getBoolean("onlyEndPeriod") && this.getInt("FPeriodYear") * 100 + this.getInt("FPeriodNumber") > this.currPeriod && this.getInt("FPeriodYear") <= this.currPeriodYear) {
                    Map hm = (Map)tableData.get(tmpIndex - 1);
                    BigDecimal pDebit_for = this.getBigDecimalFromSelf(hm, "FDebit_for");
                    pDebit_for = pDebit_for == null ? GlUtils.zero : pDebit_for;
                    BigDecimal pDebit_local = this.getBigDecimalFromSelf(hm, "FDebit_local");
                    pDebit_local = pDebit_local == null ? GlUtils.zero : pDebit_local;
                    BigDecimal pDebit_rpt = this.getBigDecimalFromSelf(hm, "FDebit_rpt");
                    pDebit_rpt = pDebit_rpt == null ? GlUtils.zero : pDebit_rpt;
                    BigDecimal pCredit_for = this.getBigDecimalFromSelf(hm, "FCredit_for");
                    pCredit_for = pCredit_for == null ? GlUtils.zero : pCredit_for;
                    BigDecimal pCredit_local = this.getBigDecimalFromSelf(hm, "FCredit_local");
                    pCredit_local = pCredit_local == null ? GlUtils.zero : pCredit_local;
                    BigDecimal pCredit_rpt = this.getBigDecimalFromSelf(hm, "FCredit_rpt");
                    pCredit_rpt = pCredit_rpt == null ? GlUtils.zero : pCredit_rpt;
                    BigDecimal pDebit_qty = this.displayAmount ? this.getBigDecimalFromSelf(hm, "FDebitQty") : GlUtils.zero;
                    BigDecimal pCredit_qty = this.displayAmount ? this.getBigDecimalFromSelf(hm, "FCreditQty") : GlUtils.zero;
                    BigDecimal balance_for = this.getBigDecimalFromSelf(hm, "FBalance_for");
                    balance_for = balance_for == null ? GlUtils.zero : balance_for;
                    BigDecimal balance_local = this.getBigDecimalFromSelf(hm, "FBalance_local");
                    balance_local = balance_local == null ? GlUtils.zero : balance_local;
                    BigDecimal balance_rpt = this.getBigDecimalFromSelf(hm, "FBalance_rpt");
                    balance_rpt = balance_rpt == null ? GlUtils.zero : balance_rpt;
                    BigDecimal qty = this.displayAmount ? this.getBigDecimalFromSelf(hm, "FEndQty") : GlUtils.zero;
                    this.putValue(singleData, "FBalance_for", balance_for);
                    this.putValue(singleData, "FBalance_local", balance_local);
                    this.putValue(singleData, "FBalance_rpt", balance_rpt);
                    if (this.displayAmount) {
                        this.putValue(singleData, "FEndQty", qty);
                    }
                    String accountNumber = this.getString("FAccountNumber");
                    String currencyNumber = null;
                    if (this.currencyId == null) {
                        currencyNumber = this.getString("FCurrencyNumber");
                    }
                    boolean foundFlag = false;
                    Map hm1 = null;
                    for (int i = tmpIndex - 1; i >= 0; --i) {
                        hm1 = (Map)tableData.get(i);
                        if (!accountNumber.equals(this.getString("FAccountNumber"))) continue;
                        if (this.currencyId == null) {
                            if (!currencyNumber.equals(this.getStringFromSelf(hm1, "FCurrencyNumber")) || this.getIntFromSelf(hm1, "FRowType") != 3) continue;
                            foundFlag = true;
                            break;
                        }
                        if (this.getIntFromSelf(hm1, "FRowType") != 3) continue;
                        foundFlag = true;
                        break;
                    }
                    if (!foundFlag) break;
                    BigDecimal debit_for = this.getBigDecimalFromSelf(hm1, "FDebit_for");
                    debit_for = debit_for == null ? GlUtils.zero : debit_for;
                    BigDecimal debit_local = this.getBigDecimalFromSelf(hm1, "FDebit_local");
                    debit_local = debit_local == null ? GlUtils.zero : debit_local;
                    BigDecimal debit_rpt = this.getBigDecimalFromSelf(hm1, "FDebit_rpt");
                    debit_rpt = debit_rpt == null ? GlUtils.zero : debit_rpt;
                    BigDecimal credit_for = this.getBigDecimalFromSelf(hm1, "FCredit_for");
                    credit_for = credit_for == null ? GlUtils.zero : credit_for;
                    BigDecimal credit_local = this.getBigDecimalFromSelf(hm1, "FCredit_local");
                    credit_local = credit_local == null ? GlUtils.zero : credit_local;
                    BigDecimal credit_rpt = this.getBigDecimalFromSelf(hm1, "FCredit_rpt");
                    credit_rpt = credit_rpt == null ? GlUtils.zero : credit_rpt;
                    BigDecimal debit_qty = this.displayAmount ? this.getBigDecimalFromSelf(hm1, "FDebitQty") : GlUtils.zero;
                    BigDecimal credit_qty = this.displayAmount ? this.getBigDecimalFromSelf(hm1, "FCreditQty") : GlUtils.zero;
                    this.putValue(singleData, "FDebit_for", debit_for.add(pDebit_for));
                    this.putValue(singleData, "FDebit_local", debit_local.add(pDebit_local));
                    this.putValue(singleData, "FDebit_rpt", debit_rpt.add(pDebit_rpt));
                    this.putValue(singleData, "FCredit_for", credit_for.add(pCredit_for));
                    this.putValue(singleData, "FCredit_local", credit_local.add(pCredit_local));
                    this.putValue(singleData, "FCredit_rpt", credit_rpt.add(pCredit_rpt));
                    if (!this.displayAmount) break;
                    this.putValue(singleData, "FDebitQty", debit_qty.add(pDebit_qty));
                    this.putValue(singleData, "FCreditQty", credit_qty.add(pCredit_qty));
                    break;
                }
                BigDecimal balance_for = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_for");
                BigDecimal balance_local = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_local");
                BigDecimal balance_rpt = this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FBalance_rpt");
                BigDecimal qty = this.displayAmount ? this.getBigDecimalFromSelf((Map)tableData.get(tmpIndex - 1), "FEndQty") : GlUtils.zero;
                this.putValue(singleData, "FBalance_for", balance_for);
                this.putValue(singleData, "FBalance_local", balance_local);
                this.putValue(singleData, "FBalance_rpt", balance_rpt);
                if (!this.displayAmount) break;
                this.putValue(singleData, "FEndQty", qty);
            }
        }
    }

    private void createHeadMsg(HSSFWorkbook wb, HSSFSheet sheet, String headMsg) {
        int columnCount = this.columnSeq.length;
        HSSFRow row0 = sheet.createRow(0);
        int n = columnCount;
        for (int j = 0; j < n; ++j) {
            HSSFCell cell = row0.createCell((int)((short)j));
            cell.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
            row0.setHeight((short)435);
        }
        row0.getCell(0).setCellValue((RichTextString)new HSSFRichTextString(headMsg));
        row0.getCell(0).setCellStyle(this.getHeadMsgStyle(wb));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)(sheet.getRow(1).getLastCellNum() - 1))));
    }

    private void createSumRow(HSSFWorkbook wb, HSSFSheet sheet, Map singleData, int rowBegin) {
        short bgcolor = HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex();
        HSSFRow row = sheet.createRow(rowBegin);
        HSSFCell cell = null;
        int columnColumn = this.columnSeq.length;
        String columnKey = "";
        int cellIndex = 0;
        Object valueTmp = null;
        for (int j = 0; j < columnColumn; ++j) {
            columnKey = this.columnSeq[j].toUpperCase();
            if (columnKey.equalsIgnoreCase("FRowType") || columnKey.equalsIgnoreCase("FCoefficient") || columnKey.equalsIgnoreCase("isSumMU") || columnKey.equalsIgnoreCase("FPeriodYear") || columnKey.equalsIgnoreCase("FPeriodNumber") || columnKey.equalsIgnoreCase("FCurrencyNumber")) continue;
            cell = row.createCell((int)((short)cellIndex));
            cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor, columnKey));
            valueTmp = singleData.get(columnKey);
            if (columnKey.equalsIgnoreCase("FDESCRIPTION")) {
                cell.setCellType(CellType.STRING);
                cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmp == null ? "" : valueTmp.toString()));
                cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor, columnKey));
            } else {
                if (this.isBaseCurrency) {
                    if (columnKey.equalsIgnoreCase("FCREDIT_FOR") || columnKey.equalsIgnoreCase("FDEBIT_FOR") || columnKey.equalsIgnoreCase("FBALANCE_FOR")) {
                        this.createCell(wb, bgcolor, cell, columnKey, valueTmp);
                    }
                } else if (columnKey.equalsIgnoreCase("FCREDIT_LOCAL") || columnKey.equalsIgnoreCase("FDEBIT_LOCAL") || columnKey.equalsIgnoreCase("FBALANCE_LOCAL")) {
                    this.createCell(wb, bgcolor, cell, columnKey, valueTmp);
                }
                if (columnKey.equalsIgnoreCase("FCREDIT_RPT") || columnKey.equalsIgnoreCase("FDEBIT_RPT") || columnKey.equalsIgnoreCase("FBALANCE_RPT")) {
                    this.createCell(wb, bgcolor, cell, columnKey, valueTmp);
                }
            }
            ++cellIndex;
        }
    }

    private void createCell(HSSFWorkbook wb, short bgcolor, HSSFCell cell, String columnKey, Object valueTmp) {
        cell.setCellType(CellType.NUMERIC);
        boolean toBeDisplay = valueTmp == null || this.toMatchZero.matcher(valueTmp.toString()).matches();
        String valueTmpStr = toBeDisplay ? "" : valueTmp.toString();
        cell.setCellStyle(this.getNumberColumnStyle(wb, bgcolor, valueTmpStr, columnKey));
        cell.setCellType(CellType.NUMERIC);
        if (!"".equals(valueTmpStr)) {
            try {
                cell.setCellValue(Double.parseDouble(valueTmpStr));
            }
            catch (NumberFormatException nfe) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmpStr));
            }
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
        }
    }

    private void createBodyColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        HSSFRow row = null;
        HSSFCell cell = null;
        Object valueTmp = null;
        String columnKey = "";
        Map singleData = null;
        int dataSize = this.tableData.size();
        int columnColumn = this.columnSeq.length;
        int iRowBegin = 3;
        int cellIndex = -1;
        for (int i = 0; i < dataSize; ++i) {
            BigDecimal rowType;
            cellIndex = 0;
            singleData = (Map)this.tableData.get(i);
            if (singleData.get("FROWTYPE") != null && (rowType = new BigDecimal((String)singleData.get("FROWTYPE"))).compareTo(TEN) == 0) {
                this.createSumRow(wb, sheet, singleData, iRowBegin);
                ++iRowBegin;
                continue;
            }
            short bgcolor = 0;
            bgcolor = this.period_total.equals(singleData.get(this.column_des)) ? HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex() : (this.sum_year.equals(singleData.get(this.column_des)) ? HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex() : HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            if (iRowBegin >= Short.MAX_VALUE) break;
            row = sheet.createRow(iRowBegin);
            for (int j = 0; j < columnColumn; ++j) {
                int valueLength;
                columnKey = this.columnSeq[j].toUpperCase();
                if (columnKey.equalsIgnoreCase("FRowType") || columnKey.equalsIgnoreCase("FCoefficient") || columnKey.equalsIgnoreCase("isSumMU") || columnKey.equalsIgnoreCase("FPeriodYear") || columnKey.equalsIgnoreCase("FPeriodNumber") || columnKey.equalsIgnoreCase("FCurrencyNumber")) continue;
                cell = row.createCell((int)((short)cellIndex));
                valueTmp = singleData.get(columnKey);
                if (valueTmp != null && (valueLength = valueTmp.toString().length()) > this.columnContentMaxLength[j]) {
                    this.columnContentMaxLength[j] = valueLength;
                }
                if (this.isAmtColumn(columnKey) || columnKey.equalsIgnoreCase("FLocalExchangeRate")) {
                    cell.setCellType(CellType.NUMERIC);
                    if (!this.isEndColumn(columnKey)) {
                        BigDecimal endBalance;
                        if ("FCREDITPRICE".equalsIgnoreCase(columnKey)) {
                            BigDecimal price = GlUtils.zero;
                            if (this.displayAmount) {
                                endBalance = GlUtils.zero;
                                endBalance = "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FCREDIT_RPT")) : ("11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FCREDIT_LOCAL")) : new BigDecimal((String)singleData.get("FCREDIT_FOR")));
                                String FCRDITQTYStr = singleData.get("FCREDITQTY") == null ? "0.0" : (String)singleData.get("FCREDITQTY");
                                int precision = this.getPrecosion(FCRDITQTYStr);
                                BigDecimal FCRDITQTY = new BigDecimal(FCRDITQTYStr);
                                if (FCRDITQTY.doubleValue() != 0.0) {
                                    price = endBalance.divide(FCRDITQTY, precision, 4).abs();
                                    valueTmp = String.valueOf(price);
                                }
                            }
                        } else if ("FDEBITPRICE".equalsIgnoreCase(columnKey)) {
                            BigDecimal price = GlUtils.zero;
                            if (this.displayAmount) {
                                endBalance = GlUtils.zero;
                                endBalance = "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FDEBIT_RPT")) : ("11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FDEBIT_LOCAL")) : new BigDecimal((String)singleData.get("FDEBIT_FOR")));
                                String FDEBITQTYStr = singleData.get("FDEBITQTY") == null ? "0.0" : (String)singleData.get("FDEBITQTY");
                                int precision = this.getPrecosion(FDEBITQTYStr);
                                BigDecimal FDEBITQTY = new BigDecimal(FDEBITQTYStr);
                                if (FDEBITQTY.doubleValue() != 0.0) {
                                    price = endBalance.divide(FDEBITQTY, precision, 4).abs();
                                    valueTmp = String.valueOf(price);
                                }
                            }
                        }
                        boolean toBeDisplay = valueTmp == null || this.toMatchZero.matcher(valueTmp.toString()).matches();
                        String valueTmpStr = toBeDisplay ? "" : valueTmp.toString();
                        cell.setCellStyle(this.getNumberColumnStyle(wb, bgcolor, valueTmpStr, columnKey));
                        cell.setCellType(CellType.NUMERIC);
                        if (!"".equals(valueTmpStr)) {
                            try {
                                cell.setCellValue(Double.parseDouble(valueTmpStr));
                            }
                            catch (NumberFormatException nfe) {
                                cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmpStr));
                            }
                        } else {
                            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                        }
                    } else {
                        String fdc = (String)singleData.get("FDC");
                        String endqty = singleData.get("FENDQTY") == null ? "0.0" : (String)singleData.get("FENDQTY");
                        int precision = this.getPrecosion(endqty);
                        BigDecimal endQty = new BigDecimal(endqty);
                        String balance_for = singleData.get("FBALANCE_FOR") == null ? "0" : (String)singleData.get("FBALANCE_FOR");
                        BigDecimal balance_FOR = new BigDecimal(balance_for);
                        String balance_loacl = singleData.get("FBALANCE_LOCAL") == null ? "0" : (String)singleData.get("FBALANCE_LOCAL");
                        BigDecimal balance_LOCAL = new BigDecimal(balance_loacl);
                        String balance_rpt = singleData.get("FBALANCE_RPT") == null ? "0" : (String)singleData.get("FBALANCE_RPT");
                        BigDecimal balance_RPT = new BigDecimal(balance_rpt);
                        valueTmp = this.autoMatchAmountOrientation(fdc, endQty, balance_FOR, balance_LOCAL, balance_RPT, columnKey);
                        if ("FBALANCEPRICE".equalsIgnoreCase(columnKey)) {
                            BigDecimal price = GlUtils.zero;
                            if (this.displayAmount) {
                                BigDecimal endBalance = GlUtils.zero;
                                endBalance = "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FBALANCE_RPT")) : ("11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyId) ? new BigDecimal((String)singleData.get("FBALANCE_LOCAL")) : new BigDecimal((String)singleData.get("FBALANCE_FOR")));
                                if (endQty.doubleValue() != 0.0) {
                                    price = endBalance.divide(endQty, precision, 4).abs();
                                    valueTmp = String.valueOf(price);
                                }
                            }
                        }
                        boolean toBeDisplay = valueTmp == null || this.toMatchZero.matcher(valueTmp.toString()).matches();
                        cell.setCellValue((RichTextString)new HSSFRichTextString(toBeDisplay ? "" : valueTmp.toString()));
                        String valueTmpStr = toBeDisplay ? "" : valueTmp.toString();
                        cell.setCellStyle(this.getNumberColumnStyle(wb, bgcolor, valueTmpStr, columnKey));
                        if (!"".equals(valueTmpStr)) {
                            try {
                                cell.setCellValue(Double.parseDouble(valueTmpStr));
                            }
                            catch (NumberFormatException nfe) {
                                cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmpStr));
                            }
                        } else {
                            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                        }
                    }
                } else if (this.isPeriod(columnKey)) {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.getPeriodDisplay(valueTmp.toString())));
                    cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor, columnKey));
                } else {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmp == null ? "" : valueTmp.toString()));
                    cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor, columnKey));
                }
                ++cellIndex;
            }
            ++iRowBegin;
        }
    }

    private String autoMatchAmountOrientation(String dc, BigDecimal qty, BigDecimal amount_for, BigDecimal amount_local, BigDecimal amount_rpt, String columnKey) {
        Object[] result = new Object[5];
        if (amount_for == null) {
            amount_for = GlUtils.zero;
        }
        if (amount_local == null) {
            amount_local = GlUtils.zero;
        }
        if (amount_rpt == null) {
            amount_rpt = GlUtils.zero;
        }
        if (amount_for.doubleValue() == 0.0 && amount_local.doubleValue() == 0.0 && amount_rpt.doubleValue() == 0.0) {
            result[0] = qty;
            result[1] = RptConstant.getEquals();
            result[2] = amount_for;
            result[3] = amount_local;
            result[4] = amount_rpt;
        } else if (this.sameAsAccount) {
            result[0] = qty;
            result[1] = "-1".equals(dc) || RptConstant.getCredit().equals(dc) ? RptConstant.getCredit() : RptConstant.getDebit();
            result[2] = "1".equals(dc) || RptConstant.getDebit().equals(dc) ? amount_for : amount_for.negate();
            result[3] = "1".equals(dc) || RptConstant.getDebit().equals(dc) ? amount_local : amount_local.negate();
            result[4] = "1".equals(dc) || RptConstant.getDebit().equals(dc) ? amount_rpt : amount_rpt.negate();
        } else {
            BigDecimal amount = amount_for;
            if (this.isGeneralRptCurrency()) {
                amount = amount_rpt;
            } else if (this.isGeneralLocalCurrency()) {
                amount = amount_local;
            }
            if (amount.doubleValue() >= 0.0) {
                result[0] = qty;
                result[1] = amount.doubleValue() == 0.0 ? RptConstant.getEquals() : RptConstant.getDebit();
                result[2] = amount_for;
                result[3] = amount_local;
                result[4] = amount_rpt;
            } else {
                result[0] = qty.negate();
                result[1] = RptConstant.getCredit();
                result[2] = amount_for.negate();
                result[3] = amount_local.negate();
                result[4] = amount_rpt.negate();
            }
        }
        String valueRet = null;
        if ("fendqty".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[0]);
        } else if ("fdc".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[1]);
        } else if ("fbalance_FOR".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[2]);
        } else if ("fbalance_Local".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[3]);
        } else if ("fbalance_Rpt".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[4]);
        }
        return valueRet;
    }

    public static void main(String[] args) {
        RptAsstactGDExportHelper hh = new RptAsstactGDExportHelper();
        logger.info((Object)("200810\u3000\uff0d\uff0d\uff0d" + hh.getPeriodDisplay("200810")));
        logger.info((Object)("2008.10\u3000\uff0d\uff0d\uff0d" + hh.getPeriodDisplay("2008.10")));
        logger.info((Object)("2008-10\u3000\uff0d\uff0d\uff0d" + hh.getPeriodDisplay("2008-10")));
    }

    private String getPeriodDisplay(String valueTmp) {
        if (this.periodValue.get(valueTmp) == null) {
            if (valueTmp.indexOf(".") != -1) {
                if (!GlUtils.isEmpty(valueTmp)) {
                    String period = valueTmp.substring(0, 4) + "." + valueTmp.substring(valueTmp.indexOf(".") + 1);
                    this.periodValue.put(valueTmp, period);
                } else {
                    this.periodValue.put(valueTmp, "");
                }
            } else if (!GlUtils.isEmpty(valueTmp)) {
                String period = valueTmp.substring(0, 4) + "." + valueTmp.substring(4);
                this.periodValue.put(valueTmp, period);
            } else {
                this.periodValue.put(valueTmp, "");
            }
        }
        return (String)this.periodValue.get(valueTmp);
    }

    private boolean isPeriod(String columnKey) {
        return columnKey.equalsIgnoreCase("FPERIOD");
    }

    private boolean hiddenCell(String columnKey) {
        String columnKeyValue = columnKey.toLowerCase();
        if (columnKeyValue.equalsIgnoreCase("FRowType") || columnKeyValue.equalsIgnoreCase("FCoefficient") || columnKeyValue.equalsIgnoreCase("isSumMU") || columnKeyValue.equalsIgnoreCase("FPeriodYear") || columnKeyValue.equalsIgnoreCase("FPeriodNumber") || columnKeyValue.equalsIgnoreCase("FCurrencyNumber")) {
            this.cellCreation.put(columnKey, Boolean.TRUE);
        } else {
            this.cellCreation.put(columnKey, Boolean.FALSE);
        }
        return true;
    }

    private boolean isAmtColumn(String columnKey) {
        String columnKeyValue;
        if (this.columnType.get(columnKey) == null && ((columnKeyValue = columnKey.toLowerCase()).startsWith("fdebit_") || columnKeyValue.startsWith("fcredit_") || columnKeyValue.startsWith("fbalance_") || columnKeyValue.equals("fdebitqty") || columnKeyValue.equals("fdebitprice") || columnKeyValue.equals("fendqty") || columnKeyValue.equals("fbalanceprice") || columnKeyValue.equals("fcreditqty") || columnKeyValue.startsWith("fcreditprice") || columnKeyValue.equals("fdebitassistqty") || columnKeyValue.equals("fdebitassistprice") || columnKeyValue.equals("fcreditassistqty") || columnKeyValue.equals("fcreditassistprice") || columnKeyValue.startsWith("fdc"))) {
            this.columnType.put(columnKey, Boolean.TRUE);
        }
        return this.columnType.get(columnKey) != null && (Boolean)this.columnType.get(columnKey) != false;
    }

    private boolean isEndColumn(String columnKey) {
        String columnKeyValue;
        if (this.endColumnHm.get(columnKey) == null && ((columnKeyValue = columnKey.toLowerCase()).startsWith("fbalance_") || columnKeyValue.equalsIgnoreCase("fendqty") || columnKeyValue.equalsIgnoreCase("FBALANCEPRICE") || columnKeyValue.equalsIgnoreCase("fdc"))) {
            this.endColumnHm.put(columnKey, Boolean.TRUE);
        }
        return this.endColumnHm.get(columnKey) != null && (Boolean)this.endColumnHm.get(columnKey) != false;
    }

    private boolean isBalanceColumn(String columnKey) {
        String columnKeyValue;
        if (this.columnBalance.get(columnKey) == null && (columnKeyValue = columnKey.toLowerCase()).startsWith("fbalance_")) {
            this.columnBalance.put(columnKey, Boolean.TRUE);
        }
        return this.columnBalance.get(columnKey) != null && (Boolean)this.columnBalance.get(columnKey) != false;
    }

    private void createHeadColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        this.createHeadColumn1(wb, sheet);
        this.createHeadColumn2(wb, sheet);
        this.mergeColumn(wb, sheet);
    }

    private void mergeColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        if (!this.displayAttribute && !this.displayAmount) {
            this.doMergeCase1(wb, sheet);
        } else if (this.displayAttribute && this.displayAmount) {
            this.doMergeCase2(wb, sheet);
        } else if (!this.displayAttribute && this.displayAmount) {
            this.doMergeCase3(wb, sheet);
        } else if (this.displayAttribute && !this.displayAmount) {
            this.doMergeCase4(wb, sheet);
        }
    }

    private void doMergeCase4(HSSFWorkbook wb, HSSFSheet sheet) {
        short megeColumnIndexEnd;
        short megeColumnIndexBegin;
        short megeColumnIndex;
        ArrayList<Short> creditColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> debitColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> balanceColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> avAttrColumnIndexs = new ArrayList<Short>();
        int columnsCount = this.columnSeq.length;
        for (int i = 0; i < columnsCount; ++i) {
            if (!this.isAmtColumn(this.columnSeq[i]) && !this.columnSeq[i].equalsIgnoreCase("fdc") && this.noCommomMerger(this.columnSeq[i])) {
                sheet.addMergedRegion(new CellRangeAddress(1, (int)((short)i), 2, (int)((short)i)));
            }
            if (this.columnSeq[i].toLowerCase().startsWith("fdebit_") || this.FDebitQty.equalsIgnoreCase(this.columnSeq[i])) {
                debitColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (this.columnSeq[i].toLowerCase().startsWith("fcredit_") || this.FCreditQty.equalsIgnoreCase(this.columnSeq[i])) {
                creditColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (this.columnSeq[i].toLowerCase().startsWith("fbalance_") || "fdc".equalsIgnoreCase(this.columnSeq[i]) || this.FEndQty.equalsIgnoreCase(this.columnSeq[i])) {
                balanceColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (!this.FBizNumber.equalsIgnoreCase(this.columnSeq[i]) && !this.FTicketNumber.equalsIgnoreCase(this.columnSeq[i])) continue;
            avAttrColumnIndexs.add(Short.valueOf(i + ""));
        }
        if (creditColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)creditColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)creditColumnIndexs.get(0);
            megeColumnIndexEnd = (Short)creditColumnIndexs.get(creditColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        if (debitColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)debitColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)debitColumnIndexs.get(0);
            megeColumnIndexEnd = (Short)debitColumnIndexs.get(debitColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        short balanceColumnIndexBegin = (Short)balanceColumnIndexs.get(0);
        short balanceColumnIndexEnd = (Short)balanceColumnIndexs.get(balanceColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)balanceColumnIndexBegin, 1, (int)balanceColumnIndexEnd));
        short avAttrColumnIndexBegin = (Short)avAttrColumnIndexs.get(0);
        short avAttrColumnIndexBeginEnd = (Short)avAttrColumnIndexs.get(avAttrColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)avAttrColumnIndexBegin, 1, (int)avAttrColumnIndexBeginEnd));
    }

    private void doMergeCase3(HSSFWorkbook wb, HSSFSheet sheet) {
        short megeColumnIndexBegin;
        short megeColumnIndex;
        ArrayList<Short> creditColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> debitColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> balanceColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> avAttrColumnIndexs = new ArrayList<Short>();
        int columnsCount = this.columnSeq.length;
        for (int i = 0; i < columnsCount; ++i) {
            String columnKey = this.columnSeq[i];
            if (!this.isAmtColumn(columnKey) && !columnKey.equalsIgnoreCase("fdc") && this.noCommomMerger(columnKey)) {
                sheet.addMergedRegion(new CellRangeAddress(1, (int)((short)i), 2, (int)((short)i)));
                continue;
            }
            if (columnKey.toLowerCase().startsWith("fdebit_") || this.FDebitQty.equalsIgnoreCase(columnKey)) {
                debitColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (columnKey.toLowerCase().startsWith("fcredit_") || this.FCreditQty.equalsIgnoreCase(columnKey)) {
                creditColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (columnKey.toLowerCase().startsWith("fbalance_") || "fdc".equalsIgnoreCase(columnKey) || this.FEndQty.equalsIgnoreCase(columnKey)) {
                balanceColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (!this.FBizNumber.equalsIgnoreCase(columnKey) && !this.FTicketNumber.equalsIgnoreCase(columnKey)) continue;
            avAttrColumnIndexs.add(Short.valueOf(i + ""));
        }
        if (creditColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)creditColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)creditColumnIndexs.get(0);
            short megeColumnIndexEnd = (Short)creditColumnIndexs.get(creditColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        if (debitColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)debitColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)debitColumnIndexs.get(0);
            short megeColumnIndexEnd = (Short)debitColumnIndexs.get(debitColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        short balanceColumnIndexBegin = (Short)balanceColumnIndexs.get(0);
        short balanceColumnIndexEnd = (Short)balanceColumnIndexs.get(balanceColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)balanceColumnIndexBegin, 1, (int)balanceColumnIndexEnd));
        short avAttrColumnIndexBegin = (Short)balanceColumnIndexs.get(0);
        short avAttrColumnIndexBeginEnd = (Short)balanceColumnIndexs.get(balanceColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)avAttrColumnIndexBegin, 1, (int)avAttrColumnIndexBeginEnd));
    }

    private void doMergeCase2(HSSFWorkbook wb, HSSFSheet sheet) {
        short megeColumnIndexBegin;
        short megeColumnIndex;
        ArrayList<Short> creditColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> debitColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> balanceColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> avAttrColumnIndexs = new ArrayList<Short>();
        int columnsCount = this.columnSeq.length;
        for (int i = 0; i < columnsCount; ++i) {
            String columnKey = this.columnSeq[i];
            if (!this.isAmtColumn(columnKey) && !columnKey.equalsIgnoreCase("fdc") && this.noCommomMerger(columnKey)) {
                sheet.addMergedRegion(new CellRangeAddress(1, (int)((short)i), 2, (int)((short)i)));
            }
            if (columnKey.toLowerCase().startsWith("fdebit_") || this.FDebitQty.equalsIgnoreCase(columnKey)) {
                debitColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (columnKey.toLowerCase().startsWith("fcredit_") || this.FCreditQty.equalsIgnoreCase(columnKey)) {
                creditColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (columnKey.toLowerCase().startsWith("fbalance_") || "fdc".equalsIgnoreCase(columnKey) || this.FEndQty.equalsIgnoreCase(columnKey)) {
                balanceColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (!this.FBizNumber.equalsIgnoreCase(columnKey) && !this.FTicketNumber.equalsIgnoreCase(columnKey)) continue;
            avAttrColumnIndexs.add(Short.valueOf(i + ""));
        }
        if (creditColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)creditColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)creditColumnIndexs.get(0);
            short megeColumnIndexEnd = (Short)creditColumnIndexs.get(creditColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        if (debitColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)debitColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)debitColumnIndexs.get(0);
            short megeColumnIndexEnd = (Short)debitColumnIndexs.get(debitColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        short balanceColumnIndexBegin = (Short)balanceColumnIndexs.get(0);
        short balanceColumnIndexEnd = (Short)balanceColumnIndexs.get(balanceColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)balanceColumnIndexBegin, 1, (int)balanceColumnIndexEnd));
        short avAttrColumnIndexBegin = (Short)avAttrColumnIndexs.get(0);
        short avAttrColumnIndexBeginEnd = (Short)avAttrColumnIndexs.get(avAttrColumnIndexs.size() - 1);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)avAttrColumnIndexBegin, 1, (int)avAttrColumnIndexBeginEnd));
    }

    private boolean noCommomMerger(String columnKey) {
        String columnKeyValue = columnKey.toLowerCase();
        if (this.commonMerger.get(columnKeyValue) == null) {
            if (this.isCommonMerge(columnKeyValue)) {
                this.commonMerger.put(columnKeyValue, Boolean.FALSE);
            } else {
                this.commonMerger.put(columnKeyValue, Boolean.TRUE);
            }
        }
        return this.commonMerger.get(columnKeyValue) != null && (Boolean)this.commonMerger.get(columnKeyValue) != false;
    }

    private boolean isCommonMerge(String columnKeyValue) {
        for (int i = 0; i < this.commonMerge.length; ++i) {
            if (!columnKeyValue.equals(this.commonMerge[i])) continue;
            return true;
        }
        return false;
    }

    private void doMergeCase1(HSSFWorkbook wb, HSSFSheet sheet) {
        short megeColumnIndexEnd;
        short megeColumnIndexBegin;
        short megeColumnIndex;
        ArrayList<Short> creditColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> debitColumnIndexs = new ArrayList<Short>();
        ArrayList<Short> fdcColumnIndexs = new ArrayList<Short>();
        int columnsCount = this.columnSeq.length;
        for (int i = 0; i < columnsCount; ++i) {
            if (!this.isAmtColumn(this.columnSeq[i]) && !this.columnSeq[i].equalsIgnoreCase("fdc") && this.noCommomMerger(this.columnSeq[i])) {
                sheet.addMergedRegion(new CellRangeAddress(1, (int)((short)i), 2, (int)((short)i)));
            }
            if (this.columnSeq[i].toLowerCase().startsWith("fdebit_")) {
                debitColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (this.columnSeq[i].toLowerCase().startsWith("fcredit_")) {
                creditColumnIndexs.add(Short.valueOf(i + ""));
                continue;
            }
            if (!this.columnSeq[i].equalsIgnoreCase("fdc")) continue;
            fdcColumnIndexs.add(Short.valueOf(i + ""));
        }
        if (creditColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)creditColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)creditColumnIndexs.get(0);
            megeColumnIndexEnd = (Short)creditColumnIndexs.get(creditColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        if (debitColumnIndexs.size() == 1) {
            megeColumnIndex = (Short)debitColumnIndexs.get(0);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndex, 2, (int)megeColumnIndex));
        } else {
            megeColumnIndexBegin = (Short)debitColumnIndexs.get(0);
            megeColumnIndexEnd = (Short)debitColumnIndexs.get(debitColumnIndexs.size() - 1);
            sheet.addMergedRegion(new CellRangeAddress(1, (int)megeColumnIndexBegin, 1, (int)megeColumnIndexEnd));
        }
        short fdcColumnIndexBegin = (Short)fdcColumnIndexs.get(0);
        sheet.addMergedRegion(new CellRangeAddress(1, (int)fdcColumnIndexBegin, 1, (int)((short)(sheet.getRow(1).getLastCellNum() - 1))));
    }

    private void createHeadColumn2(HSSFWorkbook wb, HSSFSheet sheet) {
        int cellIndex = 0;
        HSSFRow row = sheet.createRow(2);
        int size = this.columnSeq.length;
        for (int i = 0; i < size; ++i) {
            String columnKey = this.columnSeq[i];
            if (columnKey.equalsIgnoreCase("FRowType") || columnKey.equalsIgnoreCase("FCoefficient") || columnKey.equalsIgnoreCase("isSumMU") || columnKey.equalsIgnoreCase("FPeriodYear") || columnKey.equalsIgnoreCase("FPeriodNumber") || columnKey.equalsIgnoreCase("FCurrencyNumber")) continue;
            HSSFCell cell = row.createCell((int)((short)cellIndex));
            cell.setCellValue((RichTextString)new HSSFRichTextString(this.columnNameSeq2[i]));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.getHeadColumnStyle(wb, columnKey));
            ++cellIndex;
        }
    }

    private void createHeadColumn1(HSSFWorkbook wb, HSSFSheet sheet) {
        int cellIndex = 0;
        HSSFRow row = sheet.createRow(1);
        int size = this.columnSeq.length;
        for (int i = 0; i < size; ++i) {
            String columnKey = this.columnSeq[i];
            if (columnKey.equalsIgnoreCase("FRowType") || columnKey.equalsIgnoreCase("FCoefficient") || columnKey.equalsIgnoreCase("isSumMU") || columnKey.equalsIgnoreCase("FPeriodYear") || columnKey.equalsIgnoreCase("FPeriodNumber") || columnKey.equalsIgnoreCase("FCurrencyNumber")) continue;
            HSSFCell cell = row.createCell((int)((short)cellIndex));
            cell.setCellValue((RichTextString)new HSSFRichTextString(this.columnNameSeq1[i]));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.getHeadColumnStyle(wb, columnKey));
            ++cellIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(HSSFWorkbook wb) {
        FileOutputStream fOut = null;
        try {
            String fileName = this.getTempFilename("GL");
            fOut = new FileOutputStream(new File(fileName));
            wb.write((OutputStream)fOut);
            fOut.flush();
            fOut.close();
            fOut = null;
            this.showFile(fileName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getTempFilename(String prefix) {
        String filename;
        String path = System.getProperty("user.dir") + File.separator + "asstActGDTmp.xls";
        File uploadFilePath = new File(path);
        if (!uploadFilePath.exists()) {
            uploadFilePath.mkdirs();
        }
        String pp = path + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + ".xls";
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    private void showFile(String fileName) throws IOException {
        ExcelUtils.showFile(fileName);
    }

    private HSSFCellStyle getPlaintStringStyle(HSSFWorkbook wb, short bgcolor, String columnKey) {
        String key = this.genKey(bgcolor, null);
        if (this.plaintStringStyleMap.get(key) == null) {
            HSSFCellStyle plaintString = wb.createCellStyle();
            plaintString.setBorderLeft(BorderStyle.THIN);
            plaintString.setBorderRight(BorderStyle.THIN);
            plaintString.setFillForegroundColor(bgcolor);
            plaintString.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            plaintString.setAlignment(HorizontalAlignment.LEFT);
            plaintString.setHidden(this.hiddenCell(columnKey));
            this.plaintStringStyleMap.put(key, plaintString);
        }
        return (HSSFCellStyle)this.plaintStringStyleMap.get(key);
    }

    private String genKey(short bgcolor, String valueTmpStr) {
        int precision = -1;
        if (valueTmpStr != null) {
            precision = this.getPrecosion(valueTmpStr);
        }
        return (bgcolor + "-key-" + precision).intern();
    }

    private int getPrecosion(String valueTmpStr) {
        return valueTmpStr.length() - valueTmpStr.indexOf(".") - 1;
    }

    private HSSFCellStyle getNumberColumnStyle(HSSFWorkbook wb, short bgcolor, String valueTmpStr, String columnKey) {
        String key = this.genKey(bgcolor, valueTmpStr);
        if (this.numberStyleMap.get(key) == null) {
            HSSFCellStyle numberStyle = wb.createCellStyle();
            numberStyle.setBorderLeft(BorderStyle.THIN);
            numberStyle.setBorderRight(BorderStyle.THIN);
            numberStyle.setFillForegroundColor(bgcolor);
            numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            numberStyle.setAlignment(HorizontalAlignment.RIGHT);
            String preicion = key.substring(key.lastIndexOf("-") + 1);
            HSSFDataFormat format = wb.createDataFormat();
            numberStyle.setDataFormat(format.getFormat(this.getFormatterByPrecision(preicion)));
            numberStyle.setHidden(this.hiddenCell(columnKey));
            this.numberStyleMap.put(key, numberStyle);
        }
        return (HSSFCellStyle)this.numberStyleMap.get(key);
    }

    private String getFormatterByPrecision(String preicion) {
        String retValue = "#,##0.";
        int precision = Integer.parseInt(preicion);
        for (int i = 0; i < precision; ++i) {
            retValue = retValue + "0";
        }
        return retValue;
    }

    private HSSFCellStyle getHeadMsgStyle(HSSFWorkbook wb) {
        if (this.headMsgStyle == null) {
            this.headMsgStyle = wb.createCellStyle();
            this.headMsgStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            this.headMsgStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headMsgStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        return this.headMsgStyle;
    }

    private HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb, String key) {
        this.headColumnStyle = wb.createCellStyle();
        this.headColumnStyle.setBorderBottom(BorderStyle.THIN);
        this.headColumnStyle.setBorderTop(BorderStyle.THIN);
        this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
        this.headColumnStyle.setBorderRight(BorderStyle.THIN);
        this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.headColumnStyle.setHidden(this.hiddenCell(key));
        return this.headColumnStyle;
    }

    private void setColumnSeq(String[] columnSeqParam) {
        this.columnSeq = columnSeqParam;
        this.columnContentMaxLength = new int[this.columnSeq.length];
        this.initArray();
    }

    private void initArray() {
        for (int i = 0; i < this.columnContentMaxLength.length; ++i) {
            this.columnContentMaxLength[i] = -1;
        }
    }

    private void setColumnNameSeq1(Map head1) {
        this.columnNameSeq1 = new String[this.columnSeq.length];
        int columnSeqSize = this.columnSeq.length;
        for (int i = 0; i < columnSeqSize; ++i) {
            this.columnNameSeq1[i] = (String)head1.get(this.columnSeq[i].toUpperCase());
        }
    }

    private void setColumnNameSeq2(Map head2) {
        this.columnNameSeq2 = new String[this.columnSeq.length];
        int columnSeqSize = this.columnSeq.length;
        for (int i = 0; i < columnSeqSize; ++i) {
            this.columnNameSeq2[i] = (String)head2.get(this.columnSeq[i].toUpperCase());
        }
    }

    private int getFdcValue(String fdc) {
        int fdcValue = 0;
        fdcValue = RptConstant.getCredit().equals(fdc) ? -1 : (RptConstant.getDebit().equals(fdc) ? 1 : 0);
        return fdcValue;
    }

    private int getInt(String key) {
        if (this.dataDest.get(key = key.toUpperCase()) == null) {
            return -1;
        }
        Object value = this.dataDest.get(key);
        return new BigDecimal((String)value).intValue();
    }

    private int getIntFromSelf(Map hm, String key) {
        Object value = hm.get(key.toUpperCase());
        if (value == null) {
            return -1;
        }
        return new BigDecimal((String)value).intValue();
    }

    private String getStringFromSelf(Map hm, String key) {
        if (hm.get(key = key.toUpperCase()) == null) {
            return "";
        }
        Object value = hm.get(key);
        return (String)value;
    }

    private String getString(String key) {
        if (this.dataDest.get(key = key.toUpperCase()) == null) {
            return "";
        }
        Object value = this.dataDest.get(key);
        return (String)value;
    }

    private Object getObject(String key) {
        if (this.dataDest.get(key = key.toUpperCase()) == null) {
            return null;
        }
        return this.dataDest.get(key);
    }

    private BigDecimal getBigDecimalFromSelf(Map hm, String key) {
        if (hm.get(key = key.toUpperCase()) == null) {
            return null;
        }
        Object value = hm.get(key);
        return new BigDecimal(value.toString());
    }

    private BigDecimal getBigDecimal(String key) {
        if (this.dataDest.get(key = key.toUpperCase()) == null) {
            return GlUtils.zero;
        }
        Object value = this.dataDest.get(key);
        return new BigDecimal(value.toString());
    }

    private void putValue(Map singleData, String key, Object value) {
        if (!singleData.containsKey(key = key.toUpperCase())) {
            return;
        }
        singleData.put(key, value.toString());
    }
}

