/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactGGConditionUI;
import com.kingdee.eas.fi.gl.client.AsstGroupFIChooserPrompt;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.client.GroupSelectorListener;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.RptAsstactBalanceListConditionUI;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RptAsstactGGConditionUI
extends AbstractRptAsstactGGConditionUI {
    private static final long serialVersionUID = 7879393880773784216L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactGGConditionUI.class);
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    public static final Color LOCKCOLOR = new Color(228, 228, 228);
    private FilterInfo filter = null;
    private boolean loading = false;
    CompanyOrgUnitInfo company;
    boolean companyFilterChanged = false;
    String companyIds = null;
    private AccountRefContrastInfo lastAcctInfo;
    private TreeModel treeModelOfCompany = null;
    private TreeModel treeModelOfCompanyClone = null;
    private int currYear = 0;
    private int currMonth = 0;
    private HashMap accountMap = new HashMap();
    RptParams initParams;
    CompanyTreeSelectUI ctsUI = null;
    JDialog dialog = null;

    public RptAsstactGGConditionUI() throws Exception {
        this.tfCompany.setRequired(true);
        this.tfCompany.setEnabled(true);
        this.tfCompany.setEditable(false);
        this.bpAccount.setRequired(true);
        this.bpPeriod.setRequired(true);
        this.tbl.checkParsed();
        this.tbl.getColumn(1).getStyleAttributes().setLocked(true);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.setSize(520, 430);
        this.jcbShowOnlySubAccountview.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptAsstactGGConditionUI.this.jspLevelFrom.setEnabled(false);
                    RptAsstactGGConditionUI.this.jspLevelTo.setEnabled(false);
                } else {
                    RptAsstactGGConditionUI.this.jspLevelFrom.setEnabled(true);
                    RptAsstactGGConditionUI.this.jspLevelTo.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (this.loading) {
            return;
        }
        String asstAccountId = null;
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        Object value = this.jebAcct.getValue();
        this.jcbShowAll.setSelected(value == null);
        if (value != null) {
            AsstAccountInfo aai = (AsstAccountInfo)value;
            asstAccountId = aai.getId().toString();
        }
        try {
            List list = RptClientUtil.queryAsstAct(asstAccountId, SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
            if (list != null && value == null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                    at.setSelected(false);
                }
            }
            this.setTableData(list);
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        this.changeAccountFilter();
    }

    @Override
    protected void jebAccountTo_dataChanged(DataChangeEvent e) throws Exception {
        String accountNumberNameTo;
        AccountViewInfo account;
        String strAccountNumber;
        String[] accountValue;
        String accountNumberNameFrom;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        Object accountFrom = this.jebAccountFrom.getValue();
        Object accountTo = this.jebAccountTo.getValue();
        int i = 1;
        int j = 1;
        if (accountFrom != null && (accountNumberNameFrom = accountFrom.toString()) != null) {
            accountValue = accountNumberNameFrom.split(" ");
            strAccountNumber = accountValue[0];
            if (this.accountMap.get(strAccountNumber) == null) {
                account = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (CompanyOrgUnitInfo)company);
                this.accountMap.put(strAccountNumber, account);
            } else {
                account = (AccountViewInfo)this.accountMap.get(strAccountNumber);
            }
            if (account != null) {
                i = account.getLevel();
            }
        }
        if (accountTo != null && (accountNumberNameTo = accountTo.toString()) != null) {
            accountValue = accountNumberNameTo.split(" ");
            strAccountNumber = accountValue[0];
            if (this.accountMap.get(strAccountNumber) == null) {
                account = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (CompanyOrgUnitInfo)company);
                this.accountMap.put(strAccountNumber, account);
            } else {
                account = (AccountViewInfo)this.accountMap.get(strAccountNumber);
            }
            if (account != null) {
                j = account.getLevel();
            }
        }
        Integer k = i > j ? new Integer(i) : new Integer(j);
        this.jspLevelTo.setValue((Object)k);
    }

    @Override
    protected void jebAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.jebAccountFrom.getValue();
        Object accountTo = this.jebAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.jebAccountTo.setValue(accountFrom);
        } else {
            this.jebAccountTo_dataChanged(e);
        }
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    @Override
    protected void jcbShowAll_actionPerformed(ActionEvent e) throws Exception {
        super.jcbShowAll_actionPerformed(e);
    }

    protected void setUIContextInitParams(RptParams aParams) {
        this.initParams = aParams;
    }

    protected RptParams getUIContextInitParams() {
        return this.initParams;
    }

    public void onInit(RptParams initParams) throws Exception {
        this.company = (CompanyOrgUnitInfo)initParams.getObject("company");
        this.company.setDescription("''");
        this.jebAccountFrom.setEnabled(false);
        this.jebAccountTo.setEnabled(false);
        this.filter = new FilterInfo();
        FilterItemCollection fic = this.filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        this.filter.setMaskString("#0 and #1 ");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.company.getAccountTable(), this.filter);
        this.jebAccountFrom.setEditable(true);
        this.jebAccountFrom.setEditFormat("$number$");
        this.jebAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountFrom.setDisplayFormat("$number$ - $name$");
        this.jebAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setEditable(true);
        this.jebAccountTo.setEditFormat("$number$");
        this.jebAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountTo.setDisplayFormat("$number$ - $name$");
        this.jebAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(this.filter);
        this.jebAccountFrom.setEntityViewInfo(myevi);
        this.jebAccountTo.setEntityViewInfo(myevi);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        int maxLevel = initParams.getInt("maxLevel");
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currency");
        PeriodEntity pe = (PeriodEntity)initParams.getObject("pe");
        this.lastAcctInfo = (AccountRefContrastInfo)initParams.getObject("lastAcctInfo");
        boolean open = false;
        boolean isUnit = GlUtils.isCompanyUnion(this.company);
        if (isUnit) {
            Date a = new Date();
            int year = a.getYear() + 1900;
            int[] periodRange = new int[]{a.getMonth() + 1, a.getMonth() + 1};
            HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
            map.put(new Integer(year), periodRange);
            HashMap<String, Object> allMap = new HashMap<String, Object>();
            allMap.put("usedPeriod", map);
            allMap.put("queryPeriod", map);
            allMap.put("currentPeriod", new int[]{year, a.getMonth() + 1});
            pe = new PeriodEntity(allMap);
            initParams.setObject("pe", (Object)pe);
            this.setUIContextInitParams(initParams);
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        } else {
            open = true;
            pe = (PeriodEntity)initParams.getObject("pe");
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
            this.spCompanyLevel.setEnabled(false);
        }
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)open);
        if (maxLevel != 0) {
            this.fillAccLevelSpinner(maxLevel);
        }
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.jbxCurrency, cc, this.company.getBaseCurrency(), this.company, (RptParams)initParams.getObject("sysParams"));
        this.tbl.getSelectManager().setSelectMode(1);
        this.tbl.getColumn("selected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tbl.getColumn("selected").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                RptAsstactGGConditionUI.this.tblEditStopped(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                RptAsstactGGConditionUI.this.tblEditValueChanged(e);
            }
        });
        this.jcbNoDisplayAllZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAsstactGGConditionUI.this.jcbNoDisplayZero.setSelected(false);
                }
            }
        });
        this.jcbNoDisplayYearZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAsstactGGConditionUI.this.jcbNoDisplayZero.setSelected(false);
                }
            }
        });
        this.jcbNoDisplayZero.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    RptAsstactGGConditionUI.this.jcbNoDisplayAllZero.setSelected(false);
                    RptAsstactGGConditionUI.this.jcbNoDisplayYearZero.setSelected(false);
                }
            }
        });
        this.chkFilterByCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (RptAsstactGGConditionUI.this.tbl.getColumn("group") != null) {
                        RptAsstactGGConditionUI.this.tbl.getColumn("group").getStyleAttributes().setHided(false);
                    }
                } else if (RptAsstactGGConditionUI.this.tbl.getColumn("group") != null) {
                    RptAsstactGGConditionUI.this.tbl.getColumn("group").getStyleAttributes().setHided(true);
                }
            }
        });
        this.jspYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    RptAsstactGGConditionUI.this.jspYearTo_stateChanged(e);
                }
                catch (Exception exc) {
                    RptAsstactGGConditionUI.this.handUIException(exc);
                }
            }
        });
        if (this.tbl.getColumn("group") != null) {
            this.tbl.getColumn("group").getStyleAttributes().setHided(true);
        }
        if (isUnit) {
            this.chkFilterByCat.setSelected(false);
            this.chkFilterByCat.setEnabled(false);
        }
        this.onInit2(initParams);
    }

    protected void tblEditStopped(KDTEditEvent e) {
        if (e.getColIndex() == 5) {
            IRow row = this.tbl.getRow(e.getRowIndex());
            AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
            int level = 1;
            if (row.getCell("maxLevel").getValue() != null) {
                level = Integer.parseInt(row.getCell("maxLevel").getValue().toString());
            }
            at.setSelectedLevel(level);
            this.setMaxLevelCell(row, at);
        }
    }

    protected void tblEditValueChanged(KDTEditEvent e) {
        if (e.getColIndex() == 0) {
            this.tbl.getCell(e.getRowIndex(), 0).setValue(e.getValue());
            boolean isSelect = (Boolean)e.getValue();
            if (isSelect) {
                IRow row = this.tbl.getRow(e.getRowIndex());
                AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                int level = 1;
                if (row.getCell("maxLevel").getValue() != null) {
                    level = Integer.parseInt(row.getCell("maxLevel").getValue().toString());
                }
                at.setSelectedLevel(level);
                this.addF7(row, at);
                if (row.getCell("collect") != null && row.getCell("collect").getValue() == null) {
                    row.getCell("collect").setValue((Object)CollectEnum.LEAF);
                    this.setMaxLevelCell(row, at);
                }
            }
            this.changeAccountFilter();
        }
    }

    protected void setMaxLevelCell(final IRow row, AsstactTypeEntity at) {
        CollectEnum collect = (CollectEnum)((Object)row.getCell("collect").getValue());
        if (collect != null && CollectEnum.UP.equals((Object)collect)) {
            row.getCell("maxLevel").getStyleAttributes().setLocked(false);
            int maxLevel = at.getMaxLevel();
            int selectedLevel = at.getSelectedLevel();
            if (maxLevel > 0 && selectedLevel == 0) {
                selectedLevel = 1;
            }
            final SpinnerNumberModel sm = new SpinnerNumberModel(selectedLevel, maxLevel > 0 ? 1 : 0, maxLevel, 1);
            sm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    row.getCell("maxLevel").setValue(sm.getValue());
                }
            });
            KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
            sce.setEditable(true);
            row.getCell("maxLevel").setValue((Object)new Integer(selectedLevel));
            row.getCell("maxLevel").setEditor((ICellEditor)sce);
            sce.setEditable(maxLevel > 0);
            sce.setEnabled(maxLevel > 0);
            row.getCell("maxLevel").getStyleAttributes().setBackground(Color.WHITE);
        } else if (collect != null && CollectEnum.LEAF.equals((Object)collect)) {
            row.getCell("maxLevel").getStyleAttributes().setLocked(true);
            row.getCell("maxLevel").setEditor(null);
            row.getCell("maxLevel").setValue(null);
            row.getCell("maxLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        } else {
            row.getCell("maxLevel").getStyleAttributes().setLocked(true);
            row.getCell("maxLevel").setEditor(null);
            row.getCell("maxLevel").setValue(null);
            row.getCell("maxLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        }
    }

    public void onInit2(RptParams initParams) throws Exception {
        this.bpAccount.setValue((Object)this.company.getAccountTable());
        this.bpPeriod.setValue((Object)this.company.getAccountPeriodType());
        if (GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setEnabled(true);
            this.bpPeriod.setEnabled(true);
            this.btnCompany.setEnabled(true);
        } else {
            this.tfCompany.setText(this.company.getName());
            this.tfCompany.setToolTipText(this.company.getName());
            this.btnCompany.setEnabled(false);
            this.bpAccount.setEnabled(false);
            this.bpPeriod.setEnabled(false);
        }
        FilterInfo filter2 = new FilterInfo();
        FilterItemCollection fic2 = filter2.getFilterItems();
        EntityViewInfo myevi2 = new EntityViewInfo();
        myevi2.setFilter(filter2);
        this.bpAccount.setEntityViewInfo(myevi2);
        fic2.add(new FilterItemInfo("destCompany.id", (Object)this.company.getId().toString()));
        this.bpAccount.setEditable(true);
        this.bpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountTableQuery");
        this.bpAccount.setEditFormat("$number$");
        this.bpAccount.setCommitFormat("$number$");
        this.bpAccount.setDisplayFormat("$number$ - $name$");
        this.bpPeriod.setEditable(true);
        this.bpPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodTypeQuery");
        this.bpPeriod.setEditFormat("$number$");
        this.bpPeriod.setCommitFormat("$number$");
        this.bpPeriod.setDisplayFormat("$number$ - $name$");
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.bpAccount.setEditable(false);
            this.bpPeriod.setEditable(false);
            return;
        }
        DataChangeListener dcl = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (eventObj.getOldValue() != null && eventObj.getNewValue() != null && eventObj.getOldValue().equals(eventObj.getNewValue())) {
                        return;
                    }
                    RptAsstactGGConditionUI.this.fireFiltersChanged(eventObj.getSource());
                }
                catch (Exception e) {
                    RptAsstactGGConditionUI.this.companyFilterChanged = true;
                    MsgBox.showInfo((Component)((Object)RptAsstactGGConditionUI.this), (String)e.getMessage());
                }
            }
        };
        this.bpAccount.addDataChangeListener(dcl);
        this.bpPeriod.addDataChangeListener(dcl);
    }

    private void addF7(IRow row, AsstactTypeEntity at) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        bizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        GeneralAsstActTypeGroupInfo grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        row.getCell("to").setValue(null);
        KDBizPromptBox bizPromptBoxTO = new KDBizPromptBox();
        bizPromptBoxTO.setEditable(true);
        bizPromptBoxTO.setEditFormat("$number$");
        bizPromptBoxTO.setCommitFormat("$number$;$name$");
        bizPromptBoxTO.setDisplayFormat("$number$ - $name$");
        bizPromptBoxTO.setQueryInfo(at.getQueryName());
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBoxTO.setSelectorCollection(sic);
        bizPromptBoxTO.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = RptAsstactGGConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAsstactGGConditionUI.this.tbl.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(e.getNewValue());
                    }
                }
                catch (Exception exc) {
                    RptAsstactGGConditionUI.this.handUIException(exc);
                }
            }
        });
        grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBoxTO, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxTO);
        row.getCell("from").setEditor((ICellEditor)editor);
        row.getCell("from").setValue(null);
        String att = at.getHgAttribute();
        if (att == null || att.toString().trim().length() < 1) {
            this.lockGroup(row);
        } else if ((att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) && this.isGG()) {
            this.unLockGroup(row);
            KDBizPromptBox groupPromptBox = new KDBizPromptBox();
            groupPromptBox.setEditable(true);
            groupPromptBox.setEditFormat("$number$");
            groupPromptBox.setDisplayFormat("$number$ - $name$");
            groupPromptBox.setCommitFormat("$number$");
            AsstGroupFIChooserPrompt prompt = new AsstGroupFIChooserPrompt((IUIObject)this);
            int asstGroupChooser = 0;
            asstGroupChooser = att.equalsIgnoreCase("Customer") ? 1 : (att.equalsIgnoreCase("Material") ? 3 : 2);
            groupPromptBox.setSelector((KDPromptSelector)prompt);
            groupPromptBox.addSelectorListener((SelectorListener)new GroupSelectorListener(row.getCell("group")));
            prompt.setGroupType(asstGroupChooser);
            KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
            ICell cell = row.getCell("group");
            if (cell != null) {
                row.getCell("group").setValue(null);
                cell.setEditor((ICellEditor)groupEditor);
            }
        } else {
            this.lockGroup(row);
        }
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        rcm.setProperty("tableData", (Object)this.getTableData());
        rcm.setProperty("tableDataHasChaged", (Object)Boolean.TRUE);
        if (!this.company.isIsBizUnit()) {
            rcm.setProperty("company", (Object)this.company);
            rcm.setProperty("companyTreeNode", this.treeModelOfCompany.getRoot());
        } else {
            rcm.setProperty("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        }
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        this.loading = true;
        try {
            RptConditionManager rcm = new RptConditionManager((RptParams)params.clone(), new String[]{"tableData"});
            rcm.restoreAllStatus((Container)((Object)this));
            this.bpAccount.setValue(params.getObjectElement("bpAccount.value") == null ? this.company.getAccountTable() : params.getObjectElement("bpAccount.value"));
            this.bpPeriod.setValue(params.getObjectElement("bpPeriod.value") == null ? this.company.getAccountPeriodType() : params.getObjectElement("bpPeriod.value"));
            if (!this.company.isIsBizUnit()) {
                TreeNode companyTreeNode = (TreeNode)params.getObjectElement("companyTreeNode");
                this.treeModelOfCompany = new DefaultTreeModel(companyTreeNode);
                this.treeModelOfCompanyClone = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompany);
                this.companyFilterChanged = true;
                String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
                this.tfCompany.setText(info);
                this.tfCompany.setToolTipText(info);
                this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
                this.company.setDescription(this.companyIds);
                PeriodEntity pe = null;
                pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
                this.getUIContextInitParams().setObject("pe", (Object)pe);
                int maxLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany);
                SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, ++maxLevel, 1);
                this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
            } else {
                SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
                this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
                this.tfCompany.setText(this.company.getName());
            }
            this.jspYearFrom.setValue(params.getObjectElement("jspYearFrom.value"));
            this.jspYearTo.setValue(params.getObjectElement("jspYearTo.value"));
            this.jspPeriodFrom.setValue(params.getObjectElement("jspPeriodFrom.value"));
            this.jspPeriodTo.setValue(params.getObjectElement("jspPeriodTo.value"));
            this.jebAcct.setValue(params.getObjectElement("jebAcct.value"));
            this.setTableData((List)rcm.getProperty("tableData"));
            if (params.getObjectElement("jspLevelFrom.value") != null) {
                this.jspLevelFrom.setValue(params.getObjectElement("jspLevelFrom.value"));
            }
            if (params.getObjectElement("jspLevelTo.value") != null) {
                this.jspLevelTo.setValue(params.getObjectElement("jspLevelTo.value"));
            }
            this.jebAccountFrom.setDataNoNotify(params.getObjectElement("jebAccountFrom.value"));
            this.jebAccountTo.setDataNoNotify(params.getObjectElement("jebAccountTo.value"));
            Object currencyObj = params.getObjectElement("jbxCurrency.value");
            if (currencyObj != null && currencyObj instanceof CurrencyInfo) {
                for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
                    Object value = this.jbxCurrency.getItemAt(i);
                    if (!(value instanceof CurrencyInfo) || !((CurrencyInfo)currencyObj).getId().equals((Object)((CurrencyInfo)value).getId())) continue;
                    this.jbxCurrency.setSelectedItem(value);
                }
            }
            this.jcbIncludeUnPost.setSelected(params.getObjectElement("jcbIncludeUnPost.value") == null ? false : (Boolean)params.getObjectElement("jcbIncludeUnPost.value"));
            this.jcbNoDisplayZero.setSelected(params.getObjectElement("jcbNoDisplayZero.value") == null ? false : (Boolean)params.getObjectElement("jcbNoDisplayZero.value"));
            this.jcbNoDisplayAllZero.setSelected(params.getObjectElement("jcbNoDisplayAllZero.value") == null ? false : (Boolean)params.getObjectElement("jcbNoDisplayAllZero.value"));
            this.jcbNoDisplayYearZero.setSelected(params.getObjectElement("jcbNoDisplayYearZero.value") == null ? false : (Boolean)params.getObjectElement("jcbNoDisplayYearZero.value"));
            this.jcbShowOnlySubAccountview.setSelected(params.getObjectElement("jcbShowOnlySubAccountview.value") == null ? false : (Boolean)params.getObjectElement("jcbShowOnlySubAccountview.value"));
            this.jcbincludeNoTransPLVoucher.setSelected(params.getObjectElement("jcbincludeNoTransPLVoucher.value") == null ? false : (Boolean)params.getObjectElement("jcbincludeNoTransPLVoucher.value"));
            if (params.getObjectElement("spCompanyLevel.value") != null) {
                int expandLevel = Integer.parseInt(params.getObjectElement("spCompanyLevel.value").toString());
                if (expandLevel <= 0) {
                    expandLevel = 1;
                }
                this.spCompanyLevel.setValue((Object)new Integer(expandLevel));
            }
            this.loading = false;
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void setRptParams(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params, new String[]{"tableData"});
        rcm.restoreAllStatus((Container)((Object)this));
        if (params.getObjectElement("jspLevelFrom.value") != null) {
            this.jspLevelFrom.setValue(params.getObjectElement("jspLevelFrom.value"));
        }
        if (params.getObjectElement("jspLevelTo.value") != null) {
            this.jspLevelTo.setValue(params.getObjectElement("jspLevelTo.value"));
        }
        this.setTableData((List)rcm.getProperty("tableData"));
        this.jebAcct.setValue(params.getObjectElement("jebAcct.value"));
        this.jebAccountFrom.setValue(params.getObjectElement("jebAccountFrom.value"));
        this.jebAccountTo.setValue(params.getObjectElement("jebAccountTo.value"));
    }

    private void changeAccountFilter() {
        AsstactTypeEntity at;
        List list = this.getTableData();
        if (this.filter == null) {
            return;
        }
        FilterItemCollection fic = this.filter.getFilterItems();
        while (fic.size() > 2) {
            fic.removeObject(fic.size() - 1);
        }
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        AccountTableInfo table = null;
        if (!GlUtils.isCompanyUnion(this.company)) {
            try {
                IAccountRefContrast iARef = AccountRefContrastFactory.getRemoteInstance();
                AccountRefContrastInfo ar = iARef.getLastAcctInfo(this.company.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), yearEnd, numberEnd);
                if (ar != null && ar.getEnabledAcctTable() != null) {
                    table = RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            table = (AccountTableInfo)this.bpAccount.getValue();
        }
        if (table == null) {
            return;
        }
        Object value = this.jebAcct.getValue();
        if (value != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            fic.add(new FilterItemInfo("CAA.id", (Object)((AsstAccountInfo)value).getId()));
            this.filter.setMaskString("#0 and #1 and #2 and #3 ");
        } else {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            this.filter.setMaskString("#0 and #1 and #2 ");
        }
        for (int i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            if (at.isSelected()) continue;
            list.remove(i);
            --i;
        }
        boolean hasSelected = list.size() > 0;
        this.jebAccountFrom.setValue(null);
        this.jebAccountFrom.setEnabled(hasSelected);
        this.jebAccountTo.setValue(null);
        this.jebAccountTo.setEnabled(hasSelected);
        if (value == null && hasSelected) {
            int from = fic.size();
            StringBuffer sf = new StringBuffer(this.filter.getMaskString());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                sf.append(" and(");
                at = (AsstactTypeEntity)list.get(i);
                int m = at.getAsstAccountCount();
                for (int j = 0; j < m; ++j) {
                    fic.add(new FilterItemInfo("CAA.id", (Object)at.getAsstAccountId(j)));
                    sf.append("#").append(from++);
                    if (j == m - 1) continue;
                    sf.append(" or ");
                }
                sf.append(')');
            }
            this.filter.setMaskString(sf.toString());
        }
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, table, this.filter);
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
        }
    }

    private void setTableData(List list) {
        AsstactTypeEntity at;
        this.tbl.setRefresh(false);
        this.tbl.removeRows();
        if (list == null) {
            return;
        }
        boolean hasSelected = false;
        HashSet<String> idSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            at = (AsstactTypeEntity)list.get(i);
            idSet.add(at.getId());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(fi);
        AsstActTypeCollection asstActColl = null;
        try {
            asstActColl = AsstActTypeFactory.getRemoteInstance().getAsstActTypeCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            IRow row = this.tbl.addRow();
            at = (AsstactTypeEntity)list.get(i);
            if ("Customer".equalsIgnoreCase(at.getHgAttribute()) || "provider".equalsIgnoreCase(at.getHgAttribute()) || "Material".equalsIgnoreCase(at.getHgAttribute())) {
                this.unLockGroup(row);
            } else {
                this.lockGroup(row);
            }
            boolean isSelected = at.isSelected();
            if (isSelected) {
                this.addF7(row, at);
            }
            row.setUserObject((Object)at);
            row.getCell("selected").setValue((Object)isSelected);
            AsstActTypeInfo asstActTypeInfo = this.findAsstActTypeInfo(asstActColl, at.getId());
            if (asstActTypeInfo != null) {
                row.getCell("type").setValue((Object)asstActTypeInfo.getName());
            }
            row.getCell("from").setValue(at.getFrom());
            row.getCell("to").setValue(at.getTo());
            if (this.tbl.getColumn("collect") != null) {
                row.getCell("collect").setEditor(GLEditor.getComboBox(CollectEnum.getEnumList()));
                row.getCell("collect").setValue((Object)at.getCollect());
                this.setMaxLevelCell(row, at);
            } else {
                this.setMaxLevelCell(row, at);
            }
            if (row.getCell("group") == null) continue;
            row.getCell("group").setValue((Object)at.getAsstGroup());
        }
        if (hasSelected) {
            this.jebAccountFrom.setEnabled(true);
            this.jebAccountTo.setEnabled(true);
        }
        this.tbl.setRefresh(true);
        this.tbl.updateUI();
    }

    private AsstActTypeInfo findAsstActTypeInfo(AsstActTypeCollection asstActCol, String id) {
        if (asstActCol == null || id == null || id.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < asstActCol.size(); ++i) {
            if (!BOSUuid.read((String)id).equals((Object)asstActCol.get(i).getId())) continue;
            return asstActCol.get(i);
        }
        return null;
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean select = row.getCell("selected").getValue() == null ? false : (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            if (this.tbl.getColumn("collect") != null) {
                at.setCollect((CollectEnum)((Object)row.getCell("collect").getValue()));
            }
            if (row.getCell("maxLevel").getValue() != null) {
                at.setSelectedLevel((Integer)row.getCell("maxLevel").getValue());
            } else {
                at.setSelectedLevel(1);
            }
            if (row.getCell("group") != null && row.getCell("group").getValue() != null) {
                at.setAsstGroup(row.getCell("group").getValue().toString());
            } else {
                at.setAsstGroup(null);
            }
            list.add(at);
        }
        return list;
    }

    protected boolean checkColect() {
        return true;
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        if (GlUtils.isCompanyUnion(this.company)) {
            if (this.bpAccount.getValue() == null) {
                this.bpAccount.requestFocus();
                MsgBox.showInfo((Component)this.bpAccount, (String)GLResUtil.getRes("select_accountView_table_please"));
                return false;
            }
            if (this.bpPeriod.getValue() == null) {
                this.bpPeriod.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
                return false;
            }
            if (this.treeModelOfCompany == null) {
                this.btnCompany.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
                return false;
            }
            try {
                this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            try {
                if (!RptAsstactBalanceListConditionUI.hasPhysicalCompany(this.treeModelOfCompany)) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                    return false;
                }
                int numberEnd = (Integer)this.jspPeriodTo.getValue();
                int yearEnd = (Integer)this.jspYearTo.getValue();
                RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                return false;
            }
            catch (Exception e) {
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                return false;
            }
        }
        int yearEnd = (Integer)this.jspYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.jspYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.jspPeriodFrom.getValue()).intValue())) {
            return false;
        }
        List list = this.getTableData();
        int count = 0;
        boolean actSelected = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (!at.isSelected()) continue;
            actSelected = true;
            if (at.getCollect() == CollectEnum.LEAF) continue;
            ++count;
        }
        if (!actSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please2"));
            return false;
        }
        if (this.checkColect() && count > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"30_RptAsstactGGConditionUI"));
            return false;
        }
        return true;
    }

    private void fireFiltersChanged(Object source) throws Exception {
        if (this.company == null || !GlUtils.isCompanyUnion(this.company)) {
            return;
        }
        this.treeModelOfCompany = null;
        this.tfCompany.setText("");
        this.tfCompany.setToolTipText("");
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        this.setAccountInitFilter();
        if (source != this.bpPeriod) {
            this.jebAccountFrom.setValue(null);
            this.jebAccountTo.setValue(null);
            this.jebAcct.setEnabled(true);
            if (this.jebAcct.getValue() != null) {
                this.jebAcct.setValue(null);
            } else {
                this.jebAcct_dataChanged(null);
            }
        }
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        PeriodTypeInfo period = (PeriodTypeInfo)this.bpPeriod.getValue();
        boolean b = account != null && period != null;
        this.btnCompany.setEnabled(b);
        this.jebAccountFrom.setEnabled(account != null);
        this.jebAccountTo.setEnabled(account != null);
        this.company.setAccountTable(account);
        this.company.setAccountPeriodType(period);
        this.companyFilterChanged = true;
        this.treeModelOfCompanyClone = null;
    }

    private void setAccountInitFilter() {
        this.filter = new FilterInfo();
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getValue();
        FilterItemCollection fic = this.filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)(this.company == null ? "" : this.company.getId().toString())));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)(account == null ? "" : account.getId().toString())));
        this.filter.setMaskString("#0 and #1 ");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.company, this.filter, false, false, true);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(this.filter);
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountFrom.setEntityViewInfo(myevi);
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setEntityViewInfo(myevi);
    }

    @Override
    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        PeriodTypeInfo period;
        AccountTableInfo account;
        if (this.ctsUI == null) {
            this.dialog = new JDialog(InitClientHelp.getFrameAncestor((Component)((Object)this)), true);
            this.ctsUI = new CompanyTreeSelectUI(this.company);
            this.ctsUI.setDialog(this.dialog);
            this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
            this.dialog.setSize(640, 480);
            InitClientHelp.centerWindow(this.dialog);
            this.dialog.setResizable(false);
            this.dialog.setTitle(this.ctsUI.getUITitle());
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            this.companyFilterChanged = true;
            this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("companyChanged")) {
                        RptAsstactGGConditionUI.this.companyChanged(evt.getNewValue());
                    }
                }
            });
        }
        if (this.companyFilterChanged) {
            account = (AccountTableInfo)this.bpAccount.getValue();
            period = (PeriodTypeInfo)this.bpPeriod.getValue();
            this.ctsUI.setAccountTableID(account.getId().toString());
            this.ctsUI.setPeriodTypeID(period.getId().toString());
            this.ctsUI.setBooksModel();
            Object objectCurrency = this.jbxCurrency.getSelectedItem();
            if (objectCurrency instanceof CurrencyInfo && ((CurrencyInfo)objectCurrency).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), true);
            } else {
                this.ctsUI.buildCompanyTree((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.client", "ReportBalanceListConditionUI"), (IMetaDataPK)new MetaDataPK("OnLoad"), false);
            }
            this.companyFilterChanged = false;
        }
        this.ctsUI.setSelectedModel(this.treeModelOfCompanyClone);
        this.dialog.setVisible(true);
    }

    protected void companyChanged(Object object) {
        Object objectnew = null;
        try {
            objectnew = ObjectUtils.createCopy((Object)object);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
        this.treeModelOfCompany = (TreeModel)object;
        this.treeModelOfCompanyClone = (TreeModel)objectnew;
        try {
            String info = RptClientUtil.getCompanyTreeNames(this.treeModelOfCompany);
            this.tfCompany.setText(info);
            this.tfCompany.setToolTipText(info);
            this.companyIds = RptClientUtil.getLeafCompany(this.treeModelOfCompany);
            this.company.setDescription(this.companyIds);
            PeriodEntity pe = null;
            pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
            this.getUIContextInitParams().setObject("pe", (Object)pe);
            int maxLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany);
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, ++maxLevel, 1);
            this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            this.treeModelOfCompany = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
        }
    }

    @Override
    protected void jbxCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        super.jbxCurrency_actionPerformed(e);
        Object objectCurrency = this.jbxCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo && GlUtils.isCompanyUnion(this.company) && (currencyInfo = (CurrencyInfo)this.jbxCurrency.getSelectedItem()).getId().toString().equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
            this.tfCompany.setText("");
            this.tfCompany.setToolTipText("");
            SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        }
        this.companyFilterChanged = true;
    }

    public void clear() {
        super.clear();
        if (Boolean.valueOf(String.valueOf(this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
            this.getUIContext().put("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY", false);
            return;
        }
        this.jebAcct.setValue(null);
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        Integer ONE = new Integer(1);
        this.jspLevelFrom.setValue((Object)ONE);
        this.jspLevelTo.setValue((Object)ONE);
        this.jcbIncludeUnPost.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        this.jcbNoDisplayAllZero.setSelected(false);
        this.jcbNoDisplayYearZero.setSelected(false);
        this.jcbShowAll.setSelected(false);
        this.jcbShowOnlySubAccountview.setSelected(false);
        this.jcbincludeNoTransPLVoucher.setSelected(false);
        this.chkFilterByCat.setSelected(false);
        this.jspYearFrom.setValue((Object)new Integer(this.currYear));
        this.jspYearTo.setValue((Object)new Integer(this.currYear));
        this.jspPeriodFrom.setValue((Object)new Integer(this.currMonth));
        this.jspPeriodTo.setValue((Object)new Integer(this.currMonth));
        if (!this.company.isIsBizUnit()) {
            this.tfCompany.setText(null);
            this.ctsUI = null;
            this.treeModelOfCompany = null;
            this.treeModelOfCompanyClone = null;
        }
        SpinnerNumberModel snmCompanyLevel = new SpinnerNumberModel(1, 1, 1, 1);
        this.spCompanyLevel.setModel((SpinnerModel)snmCompanyLevel);
        try {
            this.jebAcct_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
            Object value = this.jbxCurrency.getItemAt(i);
            if (!(value instanceof CurrencyInfo) || !this.company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
            this.jbxCurrency.setSelectedItem(value);
        }
    }

    protected void fillAccLevelSpinner(int maxLevel) {
        SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.jspLevelFrom, (KDSpinner)this.jspLevelTo);
    }

    private void lockGroup(IRow row) {
        if (row.getCell("group") == null) {
            return;
        }
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    private void unLockGroup(IRow row) {
        if (row.getCell("group") == null) {
            return;
        }
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(false);
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
    }

    protected boolean isGG() {
        return true;
    }

    protected void jspYearTo_stateChanged(ChangeEvent e) throws Exception {
        if (!GlUtils.isCompanyUnion(this.company)) {
            this.setPeriodEnd();
            this.bpAccount.setValue((Object)this.company.getAccountTable());
            this.changeAccountFilter();
        }
    }

    private void setPeriodEnd() {
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.jebAccountFrom, this.jebAccountTo);
    }
}

