/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gl.utils.ExcelUtils;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class RptAsstactGGExportHelper {
    private static final String RES_PATH = "com.kingdee.eas.fi.gl.GLRes";
    private boolean sameAsAccount = false;
    private HSSFCellStyle headMsgStyle = null;
    private HSSFCellStyle headColumnStyle = null;
    private HSSFCellStyle subTotalColumnStyle = null;
    private Map plaintStringStyleMap = new HashMap();
    private Map numberStyleMap = new HashMap();
    private Pattern toMatchZero = Pattern.compile("0.0+");
    public final short ALIGN_LEFT = HorizontalAlignment.LEFT.getCode();
    public final short ALIGN_CENTER = HorizontalAlignment.CENTER.getCode();
    public final short ALIGN_RIGHT = HorizontalAlignment.RIGHT.getCode();
    public final short ALIGN_VERTICAL_CENTER = VerticalAlignment.CENTER.getCode();
    private String[] columnSeq = null;
    private String[] columnNameSeq1 = null;
    private List tableData = null;
    private int[] columnContentMaxLength = null;
    private String subTotal = null;
    private String currencyID = null;
    private String column_accountName = "FACCOUNTNAME";
    private Map periodValue = new HashMap();
    private Map columnType = new HashMap();
    private Map endColumnHm = new HashMap();

    public void export(List data, String headMsg, RptParams sysParams, CurrencyInfo currencyInfo) {
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, "sheet1");
        this.sameAsAccount = sysParams.getBoolean("GL_005");
        this.parseValue(data, currencyInfo, sysParams);
        this.createHeadColumn(wb, sheet);
        this.createBodyColumn(wb, sheet);
        this.createHeadMsg(wb, sheet, headMsg);
        this.adjustColumnWidth(wb, sheet);
        this.writeFile(wb);
    }

    private void adjustColumnWidth(HSSFWorkbook wb, HSSFSheet sheet) {
        int length = -1;
        for (int i = 0; i < this.columnContentMaxLength.length; ++i) {
            length = this.columnContentMaxLength[i];
            if (length == -1) {
                length = this.columnNameSeq1[i].length();
            } else if (this.columnNameSeq1[i].length() > length) {
                length = this.columnNameSeq1[i].length();
            }
            sheet.setColumnWidth((int)((short)i), (int)((short)(length * 2 * 250)));
        }
    }

    private void parseValue(List data, CurrencyInfo currencyInfo, RptParams sysParams) {
        this.subTotal = EASResource.getString((String)RES_PATH, (String)"subtotal");
        if (currencyInfo != null) {
            this.currencyID = currencyInfo.getId().toString();
        }
        this.sameAsAccount = sysParams.getBoolean("GL_005");
        this.setColumnSeq((String[])data.get(0));
        this.setColumnNameSeq1((Map)data.get(1));
        this.setTableData(data);
    }

    private boolean isGeneralRptCurrency() {
        return "22222222-2222-2222-2222-222222222222DEB58FDC".equalsIgnoreCase(this.currencyID);
    }

    private boolean isGeneralLocalCurrency() {
        return "11111111-1111-1111-1111-111111111111DEB58FDC".equalsIgnoreCase(this.currencyID);
    }

    private void setTableData(List data) {
        this.tableData = new ArrayList();
        int size = data.size();
        for (int i = 2; i < size; ++i) {
            this.tableData.add(data.get(i));
        }
    }

    private void createHeadMsg(HSSFWorkbook wb, HSSFSheet sheet, String headMsg) {
        int columnCount = this.columnSeq.length;
        HSSFRow row0 = sheet.createRow(0);
        int n = columnCount;
        for (int j = 0; j < n; ++j) {
            HSSFCell cell = row0.createCell((int)((short)j));
            cell.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
            row0.setHeight((short)435);
        }
        row0.getCell(0).setCellValue((RichTextString)new HSSFRichTextString(headMsg));
        row0.getCell(0).setCellStyle(this.getHeadMsgStyle(wb));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)(columnCount - 1))));
    }

    private void createBodyColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        HSSFRow row = null;
        HSSFCell cell = null;
        Object valueTmp = null;
        String columnKey = "";
        Map singleData = null;
        int dataSize = this.tableData.size();
        int columnColumn = this.columnSeq.length;
        int iRowBegin = 2;
        int cellIndex = -1;
        for (int i = 0; i < dataSize; ++i) {
            cellIndex = 0;
            singleData = (Map)this.tableData.get(i);
            short bgcolor = 0;
            bgcolor = this.subTotal.equals(singleData.get(this.column_accountName)) ? HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex() : HSSFColor.HSSFColorPredefined.WHITE.getIndex();
            if (iRowBegin >= Short.MAX_VALUE) break;
            row = sheet.createRow((int)((short)iRowBegin));
            for (int j = 0; j < columnColumn; ++j) {
                int valueLength;
                columnKey = this.columnSeq[j].toUpperCase();
                cell = row.createCell((int)((short)cellIndex));
                valueTmp = singleData.get(columnKey);
                if (valueTmp != null && (valueLength = valueTmp.toString().length()) > this.columnContentMaxLength[j]) {
                    this.columnContentMaxLength[j] = valueLength;
                }
                if (this.isAmtColumn(columnKey) || "fdc".equalsIgnoreCase(columnKey)) {
                    this.dealAmtColumn(wb, cell, valueTmp, columnKey, singleData, bgcolor, cellIndex);
                } else if (this.isPeriod(columnKey)) {
                    this.dealPeriodColumn(wb, cell, valueTmp, bgcolor);
                } else {
                    this.dealPlantStringColumn(wb, cell, valueTmp, bgcolor);
                }
                ++cellIndex;
            }
            ++iRowBegin;
        }
    }

    private void dealAmtColumn(HSSFWorkbook wb, HSSFCell cell, Object valueTmp, String columnKey, Map singleData, short bgcolor, int cellIndex) {
        cell.setCellType(CellType.NUMERIC);
        if (!this.isEndColumn(columnKey) && !"fdc".equalsIgnoreCase(columnKey)) {
            this.dealCommonAmt(wb, cell, valueTmp, bgcolor);
        } else {
            this.dealBalance(wb, cell, columnKey, singleData, bgcolor, cellIndex);
        }
    }

    private void dealBalance(HSSFWorkbook wb, HSSFCell cell, String columnKey, Map singleData, short bgcolor, int cellIndex) {
        String fdc = (String)singleData.get("FDC");
        String amt = "";
        if (cellIndex < this.columnSeq.length - 1 && "FBEGINBALANCE".equalsIgnoreCase(this.columnSeq[cellIndex + 1])) {
            amt = singleData.get("FBEGINBALANCE") == null ? "0" : (String)singleData.get("FBEGINBALANCE");
        } else if (cellIndex < this.columnSeq.length - 1 && "FENDBALANCE".equalsIgnoreCase(this.columnSeq[cellIndex + 1])) {
            String string = amt = singleData.get("FENDBALANCE") == null ? "0" : (String)singleData.get("FENDBALANCE");
        }
        if (amt.equals("")) {
            amt = singleData.get(columnKey) == null ? "0" : (String)singleData.get(columnKey);
        }
        int fdcValue = this.getFdcValue(fdc);
        BigDecimal amtValue = new BigDecimal(amt);
        boolean isSum = this.subTotal.equals(singleData.get(this.column_accountName));
        String valueTmp = this.autoMatchAmountOrientation(fdcValue, amtValue, columnKey, isSum);
        this.dealCommonAmt(wb, cell, valueTmp, bgcolor);
    }

    private void dealCommonAmt(HSSFWorkbook wb, HSSFCell cell, Object valueTmp, short bgcolor) {
        String valueTmpStr = valueTmp.toString();
        cell.setCellStyle(this.getNumberColumnStyle(wb, bgcolor, valueTmpStr));
        if (!"".equals(valueTmpStr)) {
            try {
                cell.setCellValue(Double.parseDouble(valueTmpStr));
            }
            catch (NumberFormatException nfe) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmpStr));
            }
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
        }
    }

    private void dealPlantStringColumn(HSSFWorkbook wb, HSSFCell cell, Object valueTmp, short bgcolor) {
        cell.setCellType(CellType.STRING);
        cell.setCellValue((RichTextString)new HSSFRichTextString(valueTmp == null ? "" : valueTmp.toString()));
        cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor));
    }

    private void dealPeriodColumn(HSSFWorkbook wb, HSSFCell cell, Object valueTmp, short bgcolor) {
        cell.setCellType(CellType.STRING);
        cell.setCellValue((RichTextString)new HSSFRichTextString(this.getPeriodDisplay(valueTmp.toString())));
        cell.setCellStyle(this.getPlaintStringStyle(wb, bgcolor));
    }

    private int getFdcValue(String fdc) {
        int fdcValue = 0;
        fdcValue = "-1".equals(fdc) || RptConstant.getCredit().equals(fdc) ? -1 : ("1".equals(fdc) || RptConstant.getDebit().equals(fdc) ? 1 : 0);
        return fdcValue;
    }

    private String autoMatchAmountOrientation(int dc, BigDecimal amount, String columnKey, boolean isSum) {
        Object[] result = new Object[2];
        boolean sameAsAccountTmp = false;
        if (isSum) {
            sameAsAccountTmp = false;
        } else {
            amount = dc > 0 ? amount : amount.negate();
            sameAsAccountTmp = this.sameAsAccount;
        }
        if (amount == null || amount.doubleValue() == 0.0) {
            result[0] = RptConstant.getEquals();
            result[1] = amount;
        } else if (amount != null) {
            if (sameAsAccountTmp) {
                result[0] = dc > 0 ? RptConstant.getDebit() : RptConstant.getCredit();
                result[1] = KDTableUtil.zeroToEmpty((Object)amount);
            } else if (amount.doubleValue() > 0.0) {
                result[0] = dc > 0 ? RptConstant.getDebit() : RptConstant.getCredit();
                result[1] = KDTableUtil.zeroToEmpty((Object)amount);
            } else {
                result[0] = dc > 0 ? RptConstant.getCredit() : RptConstant.getDebit();
                result[1] = KDTableUtil.zeroToEmpty((Object)amount.negate());
            }
        }
        String valueRet = null;
        if ("fdc".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[0]);
        } else if ("FBEGINBALANCE".equalsIgnoreCase(columnKey) || "FENDBALANCE".equalsIgnoreCase(columnKey)) {
            valueRet = String.valueOf(result[1]);
        }
        return valueRet;
    }

    private String getPeriodDisplay(String valueTmp) {
        if (this.periodValue.get(valueTmp) == null) {
            if (valueTmp.indexOf(".") != -1) {
                String period = valueTmp.substring(0, 4) + "." + valueTmp.substring(valueTmp.indexOf(".") + 1);
                this.periodValue.put(valueTmp, period);
            } else {
                String period = valueTmp.substring(0, 4) + "." + valueTmp.substring(4);
                this.periodValue.put(valueTmp, period);
            }
        }
        return (String)this.periodValue.get(valueTmp);
    }

    private boolean isPeriod(String columnKey) {
        return columnKey.equalsIgnoreCase("FPERIOD");
    }

    private boolean isAmtColumn(String columnKey) {
        if (this.columnType.get(columnKey) == null && (columnKey.equalsIgnoreCase("fbeginbalance") || columnKey.equalsIgnoreCase("fdebit") || columnKey.equalsIgnoreCase("fcredit") || columnKey.equalsIgnoreCase("fyeardebit") || columnKey.equalsIgnoreCase("fyearcredit") || columnKey.toLowerCase(Locale.ENGLISH).startsWith("fendbalance"))) {
            this.columnType.put(columnKey, Boolean.TRUE);
        }
        return this.columnType.get(columnKey) != null && (Boolean)this.columnType.get(columnKey) != false;
    }

    private boolean isEndColumn(String columnKey) {
        String columnKeyValue;
        if (this.endColumnHm.get(columnKey) == null && ((columnKeyValue = columnKey.toLowerCase(Locale.ENGLISH)).startsWith("fendbalance") || columnKeyValue.equals("fbeginbalance"))) {
            this.endColumnHm.put(columnKey, Boolean.TRUE);
        }
        return this.endColumnHm.get(columnKey) != null && (Boolean)this.endColumnHm.get(columnKey) != false;
    }

    private void createHeadColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        this.createHeadColumn1(wb, sheet);
        this.mergeColumn(wb, sheet);
    }

    private void mergeColumn(HSSFWorkbook wb, HSSFSheet sheet) {
        this.doMerge(wb, sheet);
    }

    private void doMerge(HSSFWorkbook wb, HSSFSheet sheet) {
        int columnsCount = this.columnSeq.length;
        for (int i = 0; i < columnsCount; ++i) {
            if (!this.columnSeq[i].equalsIgnoreCase("FBEGINBALANCE") && !this.columnSeq[i].equalsIgnoreCase("FENDBALANCE")) continue;
            sheet.addMergedRegion(new CellRangeAddress(1, (int)((short)(i - 1)), 1, (int)((short)i)));
        }
    }

    private void createHeadColumn1(HSSFWorkbook wb, HSSFSheet sheet) {
        int cellIndex = 0;
        HSSFRow row = sheet.createRow(1);
        row.setHeight((short)543);
        int size = this.columnSeq.length;
        for (int i = 0; i < size; ++i) {
            HSSFCell cell = row.createCell((int)((short)cellIndex));
            cell.setCellValue((RichTextString)new HSSFRichTextString(this.columnNameSeq1[i]));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.getHeadColumnStyle(wb));
            ++cellIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(HSSFWorkbook wb) {
        FileOutputStream fOut = null;
        try {
            String fileName = this.getTempFilename("GL");
            fOut = new FileOutputStream(new File(fileName));
            wb.write((OutputStream)fOut);
            fOut.flush();
            fOut.close();
            fOut = null;
            this.showFile(fileName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getTempFilename(String prefix) {
        String filename;
        String path = System.getProperty("user.dir") + File.separator + "asstActTmpGG.xls";
        File uploadFilePath = new File(path);
        if (!uploadFilePath.exists()) {
            uploadFilePath.mkdirs();
        }
        String pp = path + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + ".xls";
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    private void showFile(String fileName) throws IOException {
        ExcelUtils.showFile(fileName);
    }

    private HSSFCellStyle getPlaintStringStyle(HSSFWorkbook wb, short bgcolor) {
        String key = this.genKey(bgcolor, null);
        if (this.plaintStringStyleMap.get(key) == null) {
            HSSFCellStyle plaintString = wb.createCellStyle();
            plaintString.setBorderLeft(BorderStyle.THIN);
            plaintString.setBorderRight(BorderStyle.THIN);
            plaintString.setFillForegroundColor(bgcolor);
            plaintString.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            plaintString.setAlignment(HorizontalAlignment.LEFT);
            this.plaintStringStyleMap.put(key, plaintString);
        }
        return (HSSFCellStyle)this.plaintStringStyleMap.get(key);
    }

    private String genKey(short bgcolor, String valueTmpStr) {
        int precision = -1;
        if (valueTmpStr != null) {
            precision = this.getPrecosion(valueTmpStr);
        }
        return (bgcolor + "-key-" + precision).intern();
    }

    private int getPrecosion(String valueTmpStr) {
        return valueTmpStr.length() - valueTmpStr.indexOf(".") - 1;
    }

    private HSSFCellStyle getNumberColumnStyle(HSSFWorkbook wb, short bgcolor, String valueTmpStr) {
        String key = this.genKey(bgcolor, valueTmpStr);
        if (this.numberStyleMap.get(key) == null) {
            HSSFCellStyle numberStyle = wb.createCellStyle();
            numberStyle.setBorderLeft(BorderStyle.THIN);
            numberStyle.setBorderRight(BorderStyle.THIN);
            numberStyle.setFillForegroundColor(bgcolor);
            numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            numberStyle.setAlignment(HorizontalAlignment.RIGHT);
            String preicion = key.substring(key.lastIndexOf("-") + 1);
            HSSFDataFormat format = wb.createDataFormat();
            numberStyle.setDataFormat(format.getFormat(this.getFormatterByPrecision(preicion)));
            this.numberStyleMap.put(key, numberStyle);
        }
        return (HSSFCellStyle)this.numberStyleMap.get(key);
    }

    private String getFormatterByPrecision(String preicion) {
        String retValue = "#,##0.";
        int precision = Integer.parseInt(preicion);
        for (int i = 0; i < precision; ++i) {
            retValue = retValue + "0";
        }
        return retValue;
    }

    private HSSFCellStyle getHeadMsgStyle(HSSFWorkbook wb) {
        if (this.headMsgStyle == null) {
            this.headMsgStyle = wb.createCellStyle();
            this.headMsgStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
            this.headMsgStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headMsgStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        return this.headMsgStyle;
    }

    private HSSFCellStyle getSubTotalColumnStyle(HSSFWorkbook wb) {
        if (this.subTotalColumnStyle == null) {
            this.subTotalColumnStyle = wb.createCellStyle();
            this.subTotalColumnStyle.setBorderLeft(BorderStyle.THIN);
            this.subTotalColumnStyle.setBorderRight(BorderStyle.THIN);
            this.subTotalColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex());
            this.subTotalColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.subTotalColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            this.subTotalColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        return this.subTotalColumnStyle;
    }

    private HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        if (this.headColumnStyle == null) {
            this.headColumnStyle = wb.createCellStyle();
            this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
            this.headColumnStyle.setBorderRight(BorderStyle.THIN);
            this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
            this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        return this.headColumnStyle;
    }

    private void setColumnSeq(String[] columnSeqParam) {
        this.columnSeq = columnSeqParam;
        this.columnContentMaxLength = new int[this.columnSeq.length];
        this.initArray();
    }

    private void initArray() {
        for (int i = 0; i < this.columnContentMaxLength.length; ++i) {
            this.columnContentMaxLength[i] = -1;
        }
    }

    private void setColumnNameSeq1(Map head1) {
        this.columnNameSeq1 = new String[this.columnSeq.length];
        int columnSeqSize = this.columnSeq.length;
        for (int i = 0; i < columnSeqSize; ++i) {
            this.columnNameSeq1[i] = "fdc".equalsIgnoreCase(this.columnSeq[i]) ? (String)head1.get(this.columnSeq[i + 1].toUpperCase()) : (String)head1.get(this.columnSeq[i].toUpperCase());
        }
    }
}

