/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactGSConditionUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAsstactGSConditionUI
extends AbstractRptAsstactGSConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactGSConditionUI.class);
    private int currYear;
    private int currMonth;

    public RptAsstactGSConditionUI() throws Exception {
        this.setSize(324, 223);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.rbAccountBalance);
        bg.add((AbstractButton)this.rbAsstactBalance);
        this.rbAccountBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptAsstactGSConditionUI.this.setComponentVisible(true);
            }
        });
        this.rbAsstactBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptAsstactGSConditionUI.this.setComponentVisible(false);
            }
        });
        this.rbAccountBalance.doClick();
        this.jspYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAsstactGSConditionUI.this.spnYearTo_stateChanged(e);
            }
        });
    }

    protected void spnYearTo_stateChanged(ChangeEvent e) {
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        FilterInfo filter = new FilterInfo();
        RptClientUtil.periodChanged((IUIObject)this, company, filter, yearEnd, numberEnd, this.jebAccountFrom, this.jebAccountTo);
    }

    private void setComponentVisible(boolean isAccountBalance) {
        this.spnAccountLevelBegin.setVisible(isAccountBalance);
        this.spnAccountLevelEnd.setVisible(isAccountBalance);
        this.lblAccountLevelBegin.setVisible(isAccountBalance);
        this.lblAccountLevelEnd.setVisible(isAccountBalance);
        this.jebAccountFrom.setVisible(!isAccountBalance);
        this.kDLabelContainer6.setVisible(!isAccountBalance);
        this.jebAccountTo.setVisible(!isAccountBalance);
        this.kDLabelContainer9.setVisible(!isAccountBalance);
        this.jebAcct.setVisible(!isAccountBalance);
        this.kDLabelContainer3.setVisible(!isAccountBalance);
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        AsstAccountInfo asstActValue = (AsstAccountInfo)this.jebAcct.getValue();
        this.jebAccountFrom.getQueryAgent().resetRuntimeEntityView();
        this.jebAccountTo.getQueryAgent().resetRuntimeEntityView();
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        AccountTableInfo table = null;
        if (!GlUtils.isCompanyUnion(company)) {
            try {
                IAccountRefContrast iARef = AccountRefContrastFactory.getRemoteInstance();
                AccountRefContrastInfo ar = iARef.getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), yearEnd, numberEnd);
                if (ar != null) {
                    table = ar.getEnabledAcctTable();
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        } else {
            table = company.getAccountTable();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        if (asstActValue != null) {
            String asstactid = asstActValue.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("CAA.id", (Object)asstactid));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, table, filter);
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
    }

    public void onInit(RptParams initParams) throws Exception {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        company = GlUtils.getCompanyById(null, company.getId().toString());
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
        }
        catch (Exception e) {
            throw new ReportException(ReportException.PERIOD_ERROR, e);
        }
        AccountTableInfo accountTable = company.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(company.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), this.jspYearTo.getIntegerVlaue().intValue(), this.jspPeriodTo.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = RptClientUtil.periodCheckForAccountRefContrast(ar, this.jspYearTo.getIntegerVlaue(), this.jspPeriodTo.getIntegerVlaue()) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter);
        this.jebAccountFrom.setEditable(true);
        this.jebAccountFrom.setEditFormat("$number$");
        this.jebAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountFrom.setDisplayFormat("$number$ - $name$");
        this.jebAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setEditable(true);
        this.jebAccountTo.setEditFormat("$number$");
        this.jebAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountTo.setDisplayFormat("$number$ - $name$");
        this.jebAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.jebAccountFrom.setEntityViewInfo(myevi);
        this.jebAccountTo.setEntityViewInfo(myevi);
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        int maxLevel = initParams.getInt("maxLevel");
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currency");
        PeriodEntity pe = (PeriodEntity)initParams.getObject("pe");
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)false);
        SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.spnAccountLevelBegin, (KDSpinner)this.spnAccountLevelEnd);
        String baseCurrencyId = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString();
        for (int i = 0; i < cc.size(); ++i) {
            if (cc.get(i).isGeneralLocalCurrency() || cc.get(i).isGeneralReportCurrency()) continue;
            this.jbxCurrency.addItem((Object)cc.get(i));
            if (!baseCurrencyId.equals(cc.get(i).getId().toString())) continue;
            this.jbxCurrency.setSelectedItem((Object)cc.get(i));
        }
        RptParams param = RptClientUtil.loadSystemParams(company.getId().toString(), null);
        boolean parmForeignCurrencySu = Boolean.valueOf(param.getObject("GL_008").toString());
        if (!parmForeignCurrencySu) {
            this.jbxCurrency.addItem((Object)GLResUtil.getRes("all_currency"));
        }
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.jspYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.jspYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.jspPeriodFrom.getValue()).intValue())) {
            return false;
        }
        RptParams pp = this.getCustomCondition();
        if (Boolean.FALSE.equals(pp.getObjectElement("rbAccountBalance.value")) && pp.getObjectElement("jebAcct.value.id") == null) {
            this.jebAcct.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_asstaccount_please"));
            return false;
        }
        return true;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager.ComponentStatus endLevelComp = (RptConditionManager.ComponentStatus)params.getObject("jspLevel");
        if (endLevelComp != null) {
            params.setObject("spnAccountLevelEnd", (Object)endLevelComp);
        }
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.setComponentVisible(this.rbAccountBalance.isSelected());
    }

    @Override
    protected void jebAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.jebAccountFrom.getValue();
        Object accountTo = this.jebAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.jebAccountTo.setValue(accountFrom);
        }
    }

    public void clear() {
        super.clear();
        this.jspYearFrom.setValue((Object)this.currYear);
        this.jspYearTo.setValue((Object)this.currYear);
        this.jspPeriodFrom.setValue((Object)this.currMonth);
        this.jspPeriodTo.setValue((Object)this.currMonth);
        this.rbAccountBalance.setSelected(true);
        this.setComponentVisible(this.rbAccountBalance.isSelected());
        this.spnAccountLevelBegin.setValue((Object)1);
        this.spnAccountLevelEnd.setValue((Object)1);
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        this.jebAcct.setValue(null);
        this.jcbIncludeUnPost.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
            Object value = this.jbxCurrency.getItemAt(i);
            if (!(value instanceof CurrencyInfo) || !company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
            this.jbxCurrency.setSelectedItem(value);
        }
    }
}

