/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IRptAsstactGS;
import com.kingdee.eas.fi.gl.RptAsstactGSFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactGSUI;
import com.kingdee.eas.fi.gl.client.RptAsstactGSConditionUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RptAsstactGSUI
extends AbstractRptAsstactGSUI {
    private static final long serialVersionUID = -5871997989537518063L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactGSUI.class);
    private int acctCount = 0;
    private static final String RES_NAME = "com.kingdee.eas.fi.gl.GLResource";

    public RptAsstactGSUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        int selectMode = 15;
        try {
            Object GL_125 = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_125");
            if ("1".equals(GL_125)) {
                selectMode = 10;
            }
        }
        catch (Exception e) {
            logger.info((Object)"\uff08RptAsstactGSUI.java\uff09\u603b\u5206\u8d26\u4f59\u989d\u8868\u83b7\u53d6\u53c2\u6570GL_125\u9519\u8bef\u3002");
        }
        this.tbl.getSelectManager().setSelectMode(selectMode);
        this.tbl.getStyleAttributes().setLocked(true);
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.enableExportExcel(this.tbl);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return RptAsstactGSFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(RptAsstactGSUI.getResourceString((String)"print_label_company")).append("&[Company]").append("&|&[Asst]").append("&| ");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(RptAsstactGSUI.getResourceString((String)"print_label_period")).append("&[Period]").append("&|").append(RptAsstactGSUI.getResourceString((String)"print_label_currency")).append("&[Currency]").append("&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Period", this.jtPeriod.getText());
        map.put("Currency", this.jtCurrency.getText());
        if (Boolean.TRUE.equals(this.params.getObjectElement("rbAccountBalance.value"))) {
            map.put("Asst", "");
        } else {
            map.put("Asst", this.jtAccountx.getText() + this.jtAccount.getText());
        }
        return map;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new RptAsstactGSConditionUI();
    }

    protected void query() {
        this.acctCount = 0;
        this.jtPeriod.setText(RptClientUtil.getPeriodTitle((Integer)this.params.getObjectElement("jspYearFrom.value"), (Integer)this.params.getObjectElement("jspPeriodFrom.value"), (Integer)this.params.getObjectElement("jspYearTo.value"), (Integer)this.params.getObjectElement("jspPeriodTo.value")));
        this.jtCurrency.setText(String.valueOf(this.params.getObjectElement("jbxCurrency.value")));
        if (Boolean.TRUE.equals(this.params.getObjectElement("rbAccountBalance.value"))) {
            this.jtAccount.setVisible(false);
            this.jtAccountx.setVisible(false);
        } else {
            this.jtAccount.setVisible(true);
            this.jtAccountx.setVisible(true);
            String n = (String)this.params.getObjectElement("jebAcct.value.name");
            this.jtAccount.setText(n == null ? "" : n);
        }
        this.tbl.removeRows();
        if (!this.isFirstOnload()) {
            this.tHelper.init();
        }
        int colCount = this.tbl.getColumnCount();
        this.tHelper.putHideColumn(this.tbl.getColumnKey(colCount - 1));
        this.tHelper.putHideColumn(this.tbl.getColumnKey(colCount - 2));
        this.checkTableCommonMenu(this.tbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            RptParams pp;
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            IRptAsstactGS gs = RptAsstactGSFactory.getRemoteInstance();
            if (from == 0) {
                pp = (RptParams)this.params.clone();
                pp.setString("companyId", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
                int yearEnd = (Integer)this.params.getObjectElement("jspYearTo.value");
                int numberEnd = (Integer)this.params.getObjectElement("jspPeriodTo.value");
                pp.setString("accountTableId", RptClientUtil.getCompany(yearEnd, numberEnd).getAccountTable().getId().toString());
                pp.setString("cuId", SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString());
                pp.setString("tempTable", this.getTempTable());
                pp = gs.createTempTable(pp);
                this.setTempTable(pp.getString("tempTable"));
                this.acctCount = pp.getInt("acctCount");
                RptTableHeader h = (RptTableHeader)pp.getObject("head");
                this.tbl.removeColumns();
                KDTableUtil.setHeader((RptTableHeader)h, (KDTable)this.tbl);
                this.tbl.setRowCount(pp.getInt("count"));
            }
            pp = new RptParams();
            pp.setString("tempTable", this.getTempTable());
            pp.setInt("acctCount", this.acctCount);
            pp = gs.query(pp, from, length);
            RptRowSet rs = (RptRowSet)pp.getObject("rs");
            rs.reset();
            int cols = rs.getColumnCount();
            int precision = 0;
            CurrencyInfo ci = RptClientUtil.searchCurrency((CurrencyCollection)this.getUIContextInitParams().getObject("currency"), SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString());
            int amountPreColumnCount = 6;
            if (Boolean.TRUE.equals(this.params.getObjectElement("rbAccountBalance.value"))) {
                amountPreColumnCount = 5;
            }
            while (rs.next()) {
                String fdc = rs.getObject("FDC").toString();
                if ("1".equals(fdc)) {
                    rs.setValue("FDC", (Object)EASResource.getString((String)RES_NAME, (String)"cell_debit"));
                } else {
                    rs.setValue("FDC", (Object)EASResource.getString((String)RES_NAME, (String)"cell_credit"));
                }
                IRow row = this.tbl.addRow(from + rs.getRow());
                precision = rs.getInt("FPrecision");
                char fno = rs.getString("FNO").charAt(0);
                if ('1' == fno) {
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_DAY_SUM);
                } else if ('2' == fno) {
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_DAY_TOTAL);
                    rs.setValue(2, (Object)GLResUtil.getRes("subtotal"));
                    for (int i = 0; i <= this.acctCount * 2; ++i) {
                        rs.setValue(i + 2 + 1, (Object)"");
                    }
                }
                int n = 0;
                int k = 0;
                if (Boolean.TRUE.equals(this.params.getObjectElement("rbAccountBalance.value"))) {
                    k = 1;
                }
                Object obj = null;
                for (int i = 0; i < cols - k; ++i) {
                    if (i < amountPreColumnCount + this.acctCount * 2 || i >= cols - 3) {
                        if (row.getCell(i) == null) continue;
                        row.getCell(i).setValue(rs.getObject(i + k));
                        continue;
                    }
                    obj = rs.getObject(i + k);
                    if (obj instanceof BigDecimal) {
                        if (((BigDecimal)obj).floatValue() == 0.0f) {
                            row.getCell(i).setValue(null);
                        } else {
                            row.getCell(i).setValue(obj);
                        }
                        if (n % 2 == 0) {
                            row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
                        } else {
                            row.getCell(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(ci.getPrecision()));
                        }
                    } else {
                        row.getCell(i).setValue(obj);
                    }
                    ++n;
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected KDTable getTableForCommon() {
        return this.tbl;
    }
}

