/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CommonSchemaInfo;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.RptCommonSchemaFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactMultiColumnConditionUI;
import com.kingdee.eas.fi.gl.client.RptMultiColumnDesignUI;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAsstactMultiColumnConditionUI
extends AbstractRptAsstactMultiColumnConditionUI {
    private static final long serialVersionUID = -1305063288533473032L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactMultiColumnConditionUI.class);
    private boolean hasLoadInitData;
    private int currYear = 0;
    private int currMonth = 0;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.onMyLoad();
        this.displayAmount.setSelected(false);
        this.displayAmount.setEnabled(false);
        this.displayOrigine.setSelected(true);
        this.displayOneLineBiz.setVisible(true);
        this.displayOneLineBiz.setEnabled(true);
    }

    public void onMyLoad() {
        try {
            if (!this.hasLoadInitData) {
                this.loadInitData();
                this.hasLoadInitData = true;
            }
            this.fillDataToUI();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ReportException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Dimension getSize() {
        return new Dimension(355, 266);
    }

    @Override
    protected void kdDesign_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"RptUIContext", (Object)this.getUIReportContext());
        uiContext.put((Object)"allCurrency", this.pp.getObject("allCurrency"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.RptMultiColumnDesignUI", (Map)uiContext);
        uiWindow.show();
    }

    private void loadInitData() throws ReportBizException, BOSException, EASBizException {
        if (this.pp == null) {
            this.pp = new RptParams();
            this.pp.setObject("period", (Object)new PeriodEntity((Map)this.getUIReportContext().getObject("periodRange")));
            this.pp.setObject("allCurrency", (Object)this.getUIReportContext().getAllCurrency());
            this.pp.setObject("currencyScaleMap", (Object)this.getUIReportContext().getCurrencyScaleMap());
        }
        PeriodEntity pe = (PeriodEntity)this.pp.getObject("period");
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        this.bpSchema.setEditable(true);
        this.bpSchema.setFocusTraversalKeysEnabled(false);
        this.bpSchema.setEditFormat("$number$");
        this.bpSchema.setDisplayFormat("$number$ - $name$");
        this.bpSchema.setCommitFormat("$number$");
        this.bpSchema.setQueryInfo("com.kingdee.eas.fi.gl.app.CommonSchemaQuery");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        ff.getFilterItems().add(new FilterItemInfo("UIPath", (Object)RptMultiColumnDesignUI.class.getName(), CompareType.EQUALS));
        ff.getFilterItems().add(new FilterItemInfo("OwnerID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
        ff.getFilterItems().add(new FilterItemInfo("OrgID", (Object)this.getUIReportContext().getCompanyID(), CompareType.EQUALS));
        ff.getFilterItems().add(new FilterItemInfo("OrgID", null, CompareType.EQUALS));
        ff.setMaskString("#0 and #1 and (#2 or #3)");
        ev.setFilter(ff);
        this.bpSchema.setEntityViewInfo(ev);
        this.bpSchema.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getOldValue() instanceof CommonSchemaInfo && eventObj.getNewValue() instanceof CommonSchemaInfo) {
                    CommonSchemaInfo oldValue = (CommonSchemaInfo)eventObj.getOldValue();
                    CommonSchemaInfo newValue = (CommonSchemaInfo)eventObj.getNewValue();
                    if (oldValue != null && newValue != null && oldValue.getId().equals((Object)newValue.getId())) {
                        return;
                    }
                }
                RptAsstactMultiColumnConditionUI.this.checkSchemaStillExits();
            }
        });
    }

    @Override
    protected void bpSchema_dataChanged(DataChangeEvent e) throws Exception {
        CommonSchemaInfo csi = (CommonSchemaInfo)this.bpSchema.getValue();
        if (csi == null) {
            return;
        }
        csi.getParams();
        CommonSchema cs = RptCommonSchemaFactory.getRemoteInstance().getSchema(csi.getId().toString());
        if (cs.getParams() != null && cs.getParams().getObject("canDisplayAmount") == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"32_RptAsstactMultiColumnConditionUI"));
            this.bpSchema.setValue(null);
        }
        if (cs.getParams() != null) {
            this.displayAmount.setEnabled(cs.getParams().getBoolean("canDisplayAmount"));
            this.displayAmount.setSelected(cs.getParams().getBoolean("canDisplayAmount") ? this.displayAmount.isSelected() : false);
        }
    }

    private boolean checkSchemaStillExits() {
        CommonSchemaInfo csi = (CommonSchemaInfo)this.bpSchema.getValue();
        if (csi == null) {
            return false;
        }
        QueryAgent qa = new QueryAgent();
        qa.setQueryInfoPK(new MetaDataPK("com.kingdee.eas.fi.gl.app.CommonSchemaQuery"));
        EntityViewInfo ev = new EntityViewInfo();
        qa.setEntityViewInfo(ev);
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("ID", (Object)csi.getId().toString()));
        try {
            if (qa.executeQuery(0, -1).next()) {
                return true;
            }
            MsgBox.showWarning((Component)((Object)this), (String)GLResUtil.getRes("reDesign_for_notExist_multi-schema"));
            this.bpSchema.requestFocus();
            SysUtil.abort();
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return false;
    }

    protected void fillDataToUI() {
        Object schema;
        SpinnerUtil.managePeriodRange((PeriodEntity)((PeriodEntity)this.pp.getObject("period")), (KDSpinner)this.yearFrom, (KDSpinner)this.periodFrom, (KDSpinner)this.yearTo, (KDSpinner)this.periodTo, (boolean)true);
        if (this.pp.containsKey("yearFrom")) {
            this.yearFrom.setValue(this.pp.getObject("yearFrom"));
            this.periodFrom.setValue(this.pp.getObject("periodFrom"));
            this.yearTo.setValue(this.pp.getObject("yearTo"));
            this.periodTo.setValue(this.pp.getObject("periodTo"));
        }
        if (this.pp.containsKey("includeNoPosting")) {
            this.includeNoPosting.setSelected(this.pp.getBoolean("includeNoPosting"));
        }
        if (this.pp.containsKey("includeNoTransPLVoucher")) {
            this.includeNoTransPLVoucher.setSelected(this.pp.getBoolean("includeNoTransPLVoucher"));
        }
        if (this.pp.containsKey("noDisplayNoCol")) {
            this.noDisplayNoCol.setSelected(this.pp.getBoolean("noDisplayNoCol"));
        }
        if (this.pp.containsKey("displayEndBalance")) {
            this.displayEndBalance.setSelected(this.pp.getBoolean("displayEndBalance"));
        }
        if (this.pp.containsKey("displayAmount")) {
            this.displayAmount.setSelected(this.pp.getBoolean("displayAmount"));
        }
        if (this.pp.containsKey("displayOneLineBiz")) {
            this.displayOneLineBiz.setSelected(this.pp.getBoolean("displayOneLineBiz"));
        }
        if (this.pp.containsKey("displayOrigine")) {
            this.displayOrigine.setSelected(this.pp.getBoolean("displayOrigine"));
        }
        if ((schema = this.pp.getObject("schema")) != null) {
            this.bpSchema.setValue(schema);
        }
    }

    @Override
    public RptParams getCustomCondition() {
        this.pp.setObject("schema", this.bpSchema.getValue());
        this.pp.setObject("yearFrom", this.yearFrom.getValue());
        this.pp.setObject("periodFrom", this.periodFrom.getValue());
        this.pp.setObject("yearTo", this.yearTo.getValue());
        this.pp.setObject("periodTo", this.periodTo.getValue());
        this.pp.setBoolean("includeNoPosting", this.includeNoPosting.isSelected());
        this.pp.setBoolean("includeNoTransPLVoucher", this.includeNoTransPLVoucher.isSelected());
        this.pp.setBoolean("noDisplayNoCol", this.noDisplayNoCol.isSelected());
        this.pp.setBoolean("displayEndBalance", this.displayEndBalance.isSelected());
        this.pp.setBoolean("displayAmount", this.displayAmount.isSelected());
        this.pp.setBoolean("displayOneLineBiz", this.displayOneLineBiz.isSelected());
        this.pp.setBoolean("displayOrigine", this.displayOrigine.isSelected());
        return this.pp;
    }

    @Override
    public void setCustomCondition(RptParams condition) {
        if (condition != null) {
            this.pp = condition;
            this.pp.setObject("period", (Object)new PeriodEntity((Map)this.getUIReportContext().getObject("periodRange")));
            this.fillDataToUI();
        }
    }

    public boolean verify() {
        if (this.bpSchema.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_multi-schema_please"));
            return false;
        }
        int yearEnd = (Integer)this.yearTo.getValue();
        int numberEnd = (Integer)this.periodTo.getValue();
        int yearBegin = (Integer)this.yearFrom.getValue();
        int numberBegin = (Integer)this.periodFrom.getValue();
        try {
            CommonSchema cs = RptCommonSchemaFactory.getRemoteInstance().getSchema(((CommonSchemaInfo)this.bpSchema.getValue()).getId().toString());
            if (cs == null || cs.getParams() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"33_RptAsstactMultiColumnConditionUI"));
                return false;
            }
            if (!RptClientUtil.getCompany(yearEnd, numberEnd).getAccountTable().getId().toString().equalsIgnoreCase(cs.getParams().getString("accountTableID"))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"34_RptAsstactMultiColumnConditionUI"));
                return false;
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin, numberBegin)) {
            return false;
        }
        return this.checkSchemaStillExits();
    }

    public void clear() {
        super.clear();
        this.fillDataToUI();
        try {
            this.loadInitData();
        }
        catch (ReportBizException e) {
            logger.error((Object)e);
            this.handUIException((Throwable)((Object)e));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        this.includeNoPosting.setSelected(false);
        this.displayAmount.setSelected(false);
        this.includeNoTransPLVoucher.setSelected(false);
        this.displayOrigine.setSelected(false);
        this.noDisplayNoCol.setSelected(false);
        this.displayOneLineBiz.setSelected(false);
        this.displayEndBalance.setSelected(false);
        this.bpSchema.setValue(null);
        this.yearFrom.setValue((Object)new Integer(this.currYear));
        this.yearTo.setValue((Object)new Integer(this.currYear));
        this.periodFrom.setValue((Object)new Integer(this.currMonth));
        this.periodTo.setValue((Object)new Integer(this.currMonth));
    }
}

