/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RptAsstactMultiColumnRowSetAddBf {
    private static final Logger logger = Logger.getLogger(RptAsstactMultiColumnRowSetAddBf.class);
    private static final String GUO_CHI_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private static final String CHENG_QIAN_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    private static final String QI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"13_RptAsstactMultiColumnRowSetAddBf");
    private static final String RI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"14_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_RI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"15_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_QI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"16_RptAsstactMultiColumnRowSetAddBf");
    private static final String BEN_NIAN_LEI_JI = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"17_RptAsstactMultiColumnRowSetAddBf");
    private BigDecimal bfDebtSum = new BigDecimal(0);
    private BigDecimal bfCredSum = new BigDecimal(0);
    private String bfBel = "";
    private String dc = "";
    private BigDecimal[] auxActTypeValues = new BigDecimal[31];
    private BigDecimal[] subValues = new BigDecimal[152];
    private Object[][] md;
    private String curPeriod = "";

    public RptAsstactMultiColumnRowSetAddBf(Object[][] md) {
        this.md = md;
    }

    public IRowSet addBf(IRowSet rowSet, int rowLineCount) {
        this.clearValues();
        try {
            if (rowSet.size() <= rowLineCount) {
                return rowSet;
            }
            rowSet.beforeFirst();
            while (rowSet.getRow() < rowLineCount - 1) {
                rowSet.next();
                this.calculate(rowSet);
            }
            this.distinguish(rowSet);
            this.insertBfRow(rowSet, GUO_CHI_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
            while (!rowSet.isLast()) {
                if (rowSet.getRow() % rowLineCount == 0) {
                    this.insertBfRow(rowSet, CHENG_QIAN_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
                }
                rowSet.next();
                this.calculate(rowSet);
                if (rowSet.getRow() % rowLineCount != rowLineCount - 1 || rowSet.isLast()) continue;
                this.distinguish(rowSet);
                this.insertBfRow(rowSet, GUO_CHI_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return rowSet;
    }

    private void clearValues() {
        int i;
        this.bfDebtSum = new BigDecimal(0);
        this.bfCredSum = new BigDecimal(0);
        for (i = 0; i < 152; ++i) {
            this.subValues[i] = new BigDecimal(0);
        }
        for (i = 0; i < 31; ++i) {
            this.auxActTypeValues[i] = new BigDecimal(0);
        }
    }

    private void distinguish(IRowSet rowSet) throws SQLException {
        String desc = rowSet.getString("3");
        if (desc.equals(BEN_RI_HE_JI) || desc.equals(BEN_QI_HE_JI) || desc.equals(BEN_NIAN_LEI_JI)) {
            int i;
            try {
                this.bfDebtSum = new BigDecimal(rowSet.getString("4").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.bfDebtSum = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.bfDebtSum = new BigDecimal(0);
            }
            try {
                this.bfCredSum = new BigDecimal(rowSet.getString("5").replaceAll(",", ""));
            }
            catch (NullPointerException e) {
                this.bfCredSum = new BigDecimal(0);
            }
            catch (NumberFormatException e) {
                this.bfCredSum = new BigDecimal(0);
            }
            for (i = 0; i < 152; ++i) {
                try {
                    this.subValues[i] = new BigDecimal(rowSet.getString(String.valueOf(i + 8)).replaceAll(",", ""));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (i = 0; i < 31; ++i) {
                try {
                    this.auxActTypeValues[i] = new BigDecimal(rowSet.getString("AuxActType" + i).replaceAll(",", ""));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else if (desc.equals(QI_CHU_YU_E) || desc.equals(RI_CHU_YU_E)) {
            this.bfDebtSum = new BigDecimal(0);
            this.bfCredSum = new BigDecimal(0);
        }
    }

    private void calculate(IRowSet rowSet) throws SQLException {
        String desc = rowSet.getString("3");
        String period = rowSet.getString("FDateYear") + "-" + rowSet.getString("FDateMonth");
        if (!this.curPeriod.equals(period)) {
            this.clearValues();
            this.curPeriod = period;
        }
        if (!(desc.equals(QI_CHU_YU_E) || desc.equals(RI_CHU_YU_E) || desc.equals(BEN_RI_HE_JI) || desc.equals(BEN_QI_HE_JI) || desc.equals(BEN_NIAN_LEI_JI))) {
            int i;
            try {
                this.bfDebtSum = this.bfDebtSum.add(new BigDecimal(rowSet.getString("4").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.bfCredSum = this.bfCredSum.add(new BigDecimal(rowSet.getString("5").replaceAll(",", "")));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (i = 0; i < 152; ++i) {
                try {
                    this.subValues[i] = this.subValues[i].add(new BigDecimal(rowSet.getString(String.valueOf(i + 8)).replaceAll(",", "")));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (i = 0; i < 31; ++i) {
                try {
                    this.auxActTypeValues[i] = this.auxActTypeValues[i].add(new BigDecimal(rowSet.getString("AuxActType" + i).replaceAll(",", "")));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                this.bfBel = rowSet.getString("7");
            }
            catch (NullPointerException e) {
                this.bfBel = "";
            }
            catch (NumberFormatException e) {
                this.bfBel = "";
            }
            try {
                this.dc = rowSet.getString("6");
            }
            catch (NullPointerException e) {
                this.dc = "";
            }
        }
    }

    private void insertBfRow(IRowSet rowSet, String desc, BigDecimal bfDebtSum, BigDecimal bfcredSum, String bfcredBel, String dc) throws SQLException {
        int i;
        int rowNum = rowSet.getRow();
        String yeCode = rowSet.getString("yeCode");
        if (GUO_CHI_YE.equals(desc)) {
            String[] codes = yeCode.split("/");
            int page = Integer.parseInt(codes[0]) + 1;
            yeCode = String.valueOf(page) + "/" + codes[1];
        }
        String date = rowSet.getString("1");
        rowSet.moveToInsertRow();
        rowSet.updateString("yeCode", String.valueOf(yeCode));
        rowSet.updateString("3", desc);
        rowSet.updateString("4", GlUtils.withComma(bfDebtSum, 2));
        rowSet.updateString("5", GlUtils.withComma(bfcredSum, 2));
        rowSet.updateString("6", dc);
        rowSet.updateString("7", this.bfBel);
        for (i = 0; i < 152; ++i) {
            rowSet.updateString(String.valueOf(i + 8), GlUtils.withComma(this.subValues[i], 2));
        }
        for (i = 0; i < 31; ++i) {
            Object[] objValue = null;
            int m = 0;
            int imd = this.md.length;
            for (int k = 0; k < imd; ++k) {
                objValue = this.md[k];
                m = objValue.length;
                if (objValue[0] != null) {
                    rowSet.updateString("accountDC", objValue[0].toString());
                } else {
                    rowSet.updateString("accountDC", "");
                }
                if (objValue[m - 1] != null) {
                    rowSet.updateString("AuxActType" + k, objValue[m - 1].toString());
                    continue;
                }
                rowSet.updateString("AuxActType" + k, "");
            }
        }
        rowSet.updateString("1", date);
        rowSet.insertRow();
        rowSet.beforeFirst();
        rowSet.absolute(rowNum + 1);
    }
}

