/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountF7Filter;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.RptAsstactXBalanceFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactXBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.AsstGroupFIChooserPrompt;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAsstactXBalanceConditionUI
extends AbstractRptAsstactXBalanceConditionUI {
    private static final long serialVersionUID = 838278940918952710L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactXBalanceConditionUI.class);
    private static final String commonSorterRes = "com.kingdee.eas.base.commonquery.client.CommonSorterPanel";
    private RptRowSet rs = null;
    CompanyOrgUnitInfo company = null;
    private int currYear;
    private int currMonth;
    private boolean isQtyAsst = false;
    private boolean hasQtyAsst = false;
    private boolean hasStdUnit = false;
    private boolean hasSelectAsst = false;
    private boolean hasSelectAcctItem = false;
    MeasureUnitInfo standardUnit = null;
    private FilterInfo filter = null;
    private List bizCodeIdList = new ArrayList();
    private boolean isUp = false;
    boolean sameAsAccount = false;
    private boolean isAccountRangeQty = false;
    private RptRowSet rsAsstAll = null;
    public static final Color LOCKCOLOR = new Color(228, 228, 228);

    public RptAsstactXBalanceConditionUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.getColumn(2).setWidth(110);
        this.tbl.getColumn(3).setWidth(110);
        KDCheckBox cb = new KDCheckBox();
        cb.setSelected(false);
        KDTDefaultCellEditor cbEditor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.tbl.getColumn("selected").setEditor((ICellEditor)cbEditor);
        this.kdUp.setEnabled(false);
        this.kdUp.setText(null);
        this.kdUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.kdUp.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveUp"));
        this.kdDown.setEnabled(false);
        this.kdDown.setText(null);
        this.kdDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.kdDown.setToolTipText(EASResource.getString((String)commonSorterRes, (String)"moveDown"));
        this.jebMeasureUnit.setEnabled(false);
        this.jebMeasureUnit.setValue(null);
        this.jcbExchangeStandardUnit.setEnabled(false);
        this.jcbExchangeStandardUnit.setSelected(false);
        this.jcbDisplayAmount.setEnabled(false);
        this.jcbDisplayAmount.setSelected(false);
        this.setSize(420, 378);
        this.initSomeComponents();
    }

    protected void spnPeriodYearEnd_stateChanged(ChangeEvent e) {
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.jebAccountFrom, this.jebAccountTo);
        this.changeAccountFilter();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void jebAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getTag() == 1) {
            return;
        }
        String asstAccountId = null;
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        Object value = this.jebAcct.getValue();
        if (value != null && value instanceof AsstAccountInfo) {
            AsstAccountInfo aai = (AsstAccountInfo)value;
            asstAccountId = aai.getId().toString();
            this.hasSelectAsst = true;
        } else {
            this.hasSelectAsst = false;
        }
        if (asstAccountId == null) {
            this.rs = (RptRowSet)this.rsAsstAll.clone();
        }
        try {
            List list = RptClientUtil.queryAsstAct(asstAccountId, this.company.getCU().getId().toString());
            if (value == null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                    at.setSelected(false);
                }
            }
            this.setTableData(list);
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        this.changeAccountFilter();
    }

    private void setTableData(List list) {
        this.tbl.removeRows();
        this.kdUp.setEnabled(false);
        this.kdDown.setEnabled(false);
        if (list == null) {
            this.hasSelectAsst = false;
            return;
        }
        this.kdUp.setEnabled(true);
        this.kdDown.setEnabled(true);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.addRow();
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            boolean isSelected = at.isSelected();
            if (isSelected) {
                this.addAsstActF7(row, at);
            } else {
                row.getCell("to").getStyleAttributes().setLocked(true);
                row.getCell("from").getStyleAttributes().setLocked(true);
            }
            row.setUserObject((Object)at);
            row.getCell("selected").setValue((Object)isSelected);
            row.getCell("type").setValue((Object)at.getName());
            row.getCell("from").setValue(at.getFrom());
            row.getCell("to").setValue(at.getTo());
            if (this.tbl.getColumn("collect") != null) {
                row.getCell("collect").setEditor(GLEditor.getComboBox(CollectEnum.getEnumList()));
                row.getCell("collect").setValue((Object)at.getCollect());
                this.setMaxLevelCell(row, at);
            } else {
                this.setMaxLevelCell(row, at);
            }
            row.getCell("group").setValue((Object)at.getAsstGroup());
            String att = at.getHgAttribute();
            if (!(att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material"))) {
                this.lockGroup(row);
                continue;
            }
            this.unLockGroup(row);
        }
        try {
            this.rs = (RptRowSet)this.rsAsstAll.clone();
            this.filterRsByTbl(this.rs, this.tbl);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e);
        }
        this.tbl.setRefresh(true);
        this.tbl.setScrollStateVertical(0);
        this.changeMeasureUnitFilter();
        this.tbl.updateUI();
    }

    private void changeAccountFilter() {
        StringBuffer sf;
        int from;
        AsstactTypeEntity at;
        List list = this.getTableData();
        if (this.filter == null) {
            return;
        }
        FilterItemCollection fic = this.filter.getFilterItems();
        while (fic.size() > 2) {
            fic.removeObject(fic.size() - 1);
        }
        int yearEnd = (Integer)this.jspYearTo.getValue();
        int numberEnd = (Integer)this.jspPeriodTo.getValue();
        AccountTableInfo accountTable = this.company.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.company.getId().toString(), SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString(), yearEnd, numberEnd);
            if (ar != null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((int)yearEnd, (int)numberEnd, (CompanyOrgUnitInfo)this.company);
                accountTable = period != null && RptClientUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable();
                fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        Object asstActValue = this.jebAcct.getValue();
        if (asstActValue != null && asstActValue instanceof AsstAccountInfo && this.rdAcct.isSelected()) {
            fic.add(new FilterItemInfo("CAA.id", (Object)((AsstAccountInfo)asstActValue).getId()));
            this.filter.setMaskString("#0 and #1 and #2 and #3 ");
        } else {
            this.filter.setMaskString("#0 and #1 and #2 ");
        }
        for (int i = 0; i < list.size(); ++i) {
            at = (AsstactTypeEntity)list.get(i);
            if (at.isSelected()) continue;
            list.remove(i);
            --i;
        }
        boolean hasSelected = list.size() > 0;
        this.jebAccountFrom.setEnabled(hasSelected);
        this.jebAccountTo.setEnabled(hasSelected);
        if (asstActValue == null && hasSelected && this.rdAcct.isSelected()) {
            from = fic.size();
            sf = new StringBuffer(this.filter.getMaskString());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                sf.append(" and(");
                at = (AsstactTypeEntity)list.get(i);
                int m = at.getAsstAccountCount();
                for (int j = 0; j < m; ++j) {
                    fic.add(new FilterItemInfo("CAA.id", (Object)at.getAsstAccountId(j)));
                    sf.append("#").append(from++);
                    if (j == m - 1) continue;
                    sf.append(" or ");
                }
                sf.append(')');
            }
            this.filter.setMaskString(sf.toString());
        } else if (!this.rdAcct.isSelected()) {
            from = fic.size();
            sf = new StringBuffer(this.filter.getMaskString());
            sf.append(" and (");
            int n = this.bizCodeIdList.size();
            for (int j = 0; j < n; ++j) {
                fic.add(new FilterItemInfo("CAA.id", this.bizCodeIdList.get(j)));
                sf.append("#").append(from++);
                if (j == n - 1) continue;
                sf.append(" or ");
            }
            if (this.bizCodeIdList.size() == 0) {
                fic.add(new FilterItemInfo("CAA.id", (Object)"noClientSupply"));
                sf.append("#").append(from++);
            }
            sf.append(")");
            this.filter.setMaskString(sf.toString());
        }
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, this.filter);
        this.jebAccountFrom.setSelector((KDPromptSelector)apb);
        this.jebAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.filter);
        this.jebAccountFrom.setEntityViewInfo(evi);
        this.jebAccountTo.setEntityViewInfo(evi);
        this.setDisplayAmountEnabled();
    }

    protected List getTableData() {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        AsstactTypeEntity at = null;
        IRow row = null;
        int count = 0;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean select = (Boolean)row.getCell("selected").getValue();
            at.setSelected(select);
            if (this.tbl.getColumn("collect") != null) {
                CollectEnum collect = (CollectEnum)((Object)row.getCell("collect").getValue());
                if (select && collect != null && !collect.getValue().equals("1")) {
                    ++count;
                }
                at.setCollect((CollectEnum)((Object)row.getCell("collect").getValue()));
            }
            if (row.getCell("maxLevel").getValue() != null) {
                at.setSelectedLevel((Integer)row.getCell("maxLevel").getValue());
            } else {
                at.setSelectedLevel(1);
            }
            if (row.getCell("group") != null && row.getCell("group").getValue() != null) {
                at.setAsstGroup(row.getCell("group").getValue().toString());
            } else {
                at.setAsstGroup(null);
            }
            list.add(at);
        }
        if (this.checkColect() && count > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"30_RptAsstactGGConditionUI"));
            SysUtil.abort();
        }
        return list;
    }

    protected boolean checkColect() {
        return true;
    }

    protected void setMaxLevelCell(final IRow row, AsstactTypeEntity at) {
        CollectEnum collect = (CollectEnum)((Object)row.getCell("collect").getValue());
        if (collect != null && CollectEnum.UP.equals((Object)collect)) {
            row.getCell("maxLevel").getStyleAttributes().setLocked(false);
            int maxLevel = at.getMaxLevel();
            int selectedLevel = at.getSelectedLevel();
            if (maxLevel > 0 && selectedLevel == 0) {
                selectedLevel = 1;
            }
            final SpinnerNumberModel sm = new SpinnerNumberModel(selectedLevel, maxLevel > 0 ? 1 : 0, maxLevel, 1);
            sm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    row.getCell("maxLevel").setValue(sm.getValue());
                }
            });
            KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
            sce.setEditable(true);
            row.getCell("maxLevel").setValue((Object)new Integer(selectedLevel));
            row.getCell("maxLevel").setEditor((ICellEditor)sce);
            sce.setEditable(maxLevel > 0);
            sce.setEnabled(maxLevel > 0);
            row.getCell("maxLevel").getStyleAttributes().setBackground(Color.WHITE);
        } else if (collect != null && CollectEnum.LEAF.equals((Object)collect)) {
            row.getCell("maxLevel").getStyleAttributes().setLocked(true);
            row.getCell("maxLevel").setEditor(null);
            row.getCell("maxLevel").setValue(null);
            row.getCell("maxLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        } else {
            row.getCell("maxLevel").getStyleAttributes().setLocked(true);
            row.getCell("maxLevel").setEditor(null);
            row.getCell("maxLevel").setValue(null);
            row.getCell("maxLevel").getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        }
    }

    private void addAsstActF7(IRow row, AsstactTypeEntity at) {
        row.getCell("to").getStyleAttributes().setLocked(false);
        row.getCell("from").getStyleAttributes().setLocked(false);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ - $name$");
        logger.info((Object)row.getUserObject().toString());
        bizPromptBox.setQueryInfo(at.getQueryName());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (at.isUseLevel()) {
            sic.add(new SelectorItemInfo("longnumber"));
        }
        bizPromptBox.setSelectorCollection(sic);
        GeneralAsstActTypeGroupInfo grp = null;
        if (at.getGeneralAsstactGroupId() != null) {
            grp = new GeneralAsstActTypeGroupInfo();
            grp.setId(BOSUuid.read((String)at.getGeneralAsstactGroupId()));
        }
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        bizPromptBox.setRecordName(at.getNumber().toString());
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("to").setEditor((ICellEditor)editor);
        row.getCell("to").setValue(null);
        KDBizPromptBox bizPromptBoxFrom = new KDBizPromptBox();
        bizPromptBoxFrom.setEditable(true);
        bizPromptBoxFrom.setEditFormat("$number$");
        bizPromptBoxFrom.setCommitFormat("$number$;$name$");
        bizPromptBoxFrom.setDisplayFormat("$number$ - $name$");
        bizPromptBoxFrom.setQueryInfo(at.getQueryName());
        bizPromptBoxFrom.setSelectorCollection(sic);
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBoxFrom, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
        bizPromptBoxFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = RptAsstactXBalanceConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                    IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(beginRow);
                    if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                        row.getCell("to").setValue(e.getNewValue());
                    }
                }
                catch (Exception exc) {
                    RptAsstactXBalanceConditionUI.this.handUIException(exc);
                }
            }
        });
        bizPromptBoxFrom.setRecordName(at.getNumber().toString());
        editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxFrom);
        row.getCell("from").setEditor((ICellEditor)editor);
        row.getCell("from").setValue(null);
        String att = at.getHgAttribute();
        if (att == null || att.toString().trim().length() < 1) {
            this.lockGroup(row);
        } else {
            KDBizPromptBox groupPromptBox = new KDBizPromptBox();
            groupPromptBox.setEditable(true);
            groupPromptBox.setEditFormat("$number$");
            groupPromptBox.setDisplayFormat("$number$ - $name$");
            groupPromptBox.setCommitFormat("$number$");
            if (att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) {
                AsstGroupFIChooserPrompt prompt = new AsstGroupFIChooserPrompt((IUIObject)this);
                int asstGroupChooser = 0;
                asstGroupChooser = att.equalsIgnoreCase("Customer") ? 1 : (att.equalsIgnoreCase("Material") ? 3 : 2);
                groupPromptBox.setSelector((KDPromptSelector)prompt);
                groupPromptBox.addSelectorListener((SelectorListener)new GroupSelectorListener(row.getCell("group")));
                prompt.setGroupType(asstGroupChooser);
                bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(asstGroupChooser));
            }
            KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
            ICell cell = row.getCell("group");
            if (cell != null) {
                cell.setEditor((ICellEditor)groupEditor);
            }
        }
    }

    @Override
    protected void jebAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object[] accountFrom = (Object[])this.jebAccountFrom.getValue();
        Object[] accountTo = (Object[])this.jebAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            if (accountFrom instanceof Object[]) {
                Object[] accounts = accountFrom;
                for (int i = 0; i < accounts.length; ++i) {
                    if (accounts[i] != null) continue;
                    return;
                }
            }
            this.jebAccountTo.setValue((Object)accountFrom);
        } else {
            this.jebaccountToLvChangedByAccount();
        }
        if (this.getTag() == 1) {
            return;
        }
        super.jebAccountFrom_dataChanged(e);
        this.setDisplayAmountEnabled();
    }

    public void jebaccountToLvChangedByAccount() throws Exception, BOSException {
        String[] accountValue;
        String strAccountNumber;
        int i;
        BOSUuid companyId = this.company.getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        AccountTableInfo account = this.company.getAccountTable();
        if (account == null) {
            return;
        }
        ObjectUuidPK accountTablePK = new ObjectUuidPK(account.getId());
        if (!(this.jebAccountFrom.getValue() instanceof Object[]) || !(this.jebAccountTo.getValue() instanceof Object[])) {
            return;
        }
        Object[] accountFrom = (Object[])this.jebAccountFrom.getValue();
        Object[] accountTo = (Object[])this.jebAccountTo.getValue();
        int l = 1;
        int j = 1;
        int t = 1;
        if (accountFrom != null) {
            for (i = 0; i < accountFrom.length && accountFrom[i] != null; ++i) {
                String accountNumberNameFrom = accountFrom[i].toString();
                if (accountNumberNameFrom == null || (l = this.getAccountLevel((IObjectPK)companyPK, (IObjectPK)accountTablePK, strAccountNumber = (accountValue = accountNumberNameFrom.split(" "))[0])) <= t) continue;
                t = l;
            }
            l = t;
        }
        if (accountTo != null) {
            t = 1;
            for (i = 0; i < accountTo.length && accountTo[i] != null; ++i) {
                String accountNumberNameTo = accountTo[i].toString();
                if (accountNumberNameTo == null || (j = this.getAccountLevel((IObjectPK)companyPK, (IObjectPK)accountTablePK, strAccountNumber = (accountValue = accountNumberNameTo.split(" "))[0])) <= t) continue;
                t = j;
            }
            j = t;
        }
        Integer k = l > j ? new Integer(l) : new Integer(j);
        this.jspLevelTo.setValue((Object)k);
    }

    @Override
    protected void jebMeasureUnit_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void jcbDisplayAmount_stateChanged(ChangeEvent e) throws Exception {
        if (this.jcbDisplayAmount.isSelected() && this.isQtyAsst && this.hasQtyAsst && this.hasStdUnit) {
            this.jebMeasureUnit.setEnabled(true);
            this.jcbExchangeStandardUnit.setEnabled(true);
        } else if (this.jcbDisplayAmount.isSelected() && this.isQtyAsst && this.hasQtyAsst && !this.hasStdUnit) {
            this.jebMeasureUnit.setEnabled(true);
            this.jcbExchangeStandardUnit.setEnabled(true);
        } else {
            this.jebMeasureUnit.setEnabled(false);
            this.jebMeasureUnit.setValue(null);
            this.jcbExchangeStandardUnit.setEnabled(false);
            this.jcbExchangeStandardUnit.setSelected(false);
        }
    }

    @Override
    protected void kdUp_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(-1);
    }

    @Override
    protected void kdDown_actionPerformed(ActionEvent e) throws Exception {
        this.moveRow(1);
    }

    private void moveRow(int offset) {
        if (this.tbl.getSelectManager().get() != null) {
            int r = this.tbl.getSelectManager().get().getTop();
            int newr = r + offset;
            if (r < 0 || newr < 0 || newr >= this.tbl.getRowCount()) {
                return;
            }
            IRow row = this.tbl.removeRow(r);
            this.tbl.addRow(newr, row);
            this.tbl.getSelectManager().select(newr, 0, newr, this.tbl.getColumnCount());
            this.tbl.getLayoutManager().scrollToShow(newr, 0);
            if (this.rs != null && r < this.rs.getRowCount() && newr < this.rs.getRowCount()) {
                this.rs.moveRow(r, newr);
            }
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        GlUtils.updateBalance();
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("currencys");
        PeriodEntity pe = new PeriodEntity((Map)initParams.getObject("periodRange"));
        this.currYear = pe.getCurrentYear();
        this.currMonth = pe.getCurrentPeriod();
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.jspYearFrom, (KDSpinner)this.jspPeriodFrom, (KDSpinner)this.jspYearTo, (KDSpinner)this.jspPeriodTo, (boolean)true);
        this.company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        this.company = GlUtils.getCompanyById(null, this.company.getId().toString());
        RptClientUtil.setJComboBoxCurrencys((JComboBox)this.jbxCurrency, cc, null, this.company);
        RptParams sysPros = RptClientUtil.loadSystemParams(this.company.getId().toString());
        this.sameAsAccount = Boolean.valueOf(sysPros.getString("GL_005"));
        this.jcbisDCSperate.setEnabled(!this.sameAsAccount);
        this.initSomeComponents();
        this.initAccountF7(initParams);
        this.jebBizCodeFrom.setEditable(true);
        this.jebBizCodeFrom.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7BizAnalysisCodeQuery");
        this.jebBizCodeFrom.setEditFormat("$number$");
        this.jebBizCodeFrom.setCommitFormat("$number$");
        this.jebBizCodeFrom.setDisplayFormat("$number$ - $name$");
        this.jebBizCodeFrom.setEnabled(false);
        EntityViewInfo bizcodeview = new EntityViewInfo();
        SorterItemCollection bizcodesorters = bizcodeview.getSorter();
        bizcodesorters.add(new SorterItemInfo("number"));
        this.jebBizCodeFrom.setEntityViewInfo(bizcodeview);
        this.jebBizCodeTo.setEditable(true);
        this.jebBizCodeTo.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7BizAnalysisCodeQuery");
        this.jebBizCodeTo.setEditFormat("$number$");
        this.jebBizCodeTo.setCommitFormat("$number$");
        this.jebBizCodeTo.setDisplayFormat("$number$ - $name$");
        this.jebBizCodeTo.setEnabled(false);
        this.jebBizCodeTo.setEntityViewInfo(bizcodeview);
        this.rdBizAnalysisCode.setSelected(false);
        this.rdAcct.setSelected(true);
        this.rdAcct.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RptAsstactXBalanceConditionUI.this.jebBizCodeFrom.setEnabled(!RptAsstactXBalanceConditionUI.this.rdAcct.isSelected());
                RptAsstactXBalanceConditionUI.this.jebBizCodeTo.setEnabled(!RptAsstactXBalanceConditionUI.this.rdAcct.isSelected());
                RptAsstactXBalanceConditionUI.this.tbl.setEnabled(RptAsstactXBalanceConditionUI.this.rdAcct.isSelected());
                RptAsstactXBalanceConditionUI.this.tbl.setEditable(RptAsstactXBalanceConditionUI.this.rdAcct.isSelected());
                RptAsstactXBalanceConditionUI.this.changeAccountFilter();
                if (RptAsstactXBalanceConditionUI.this.rdAcct.isSelected()) {
                    RptAsstactXBalanceConditionUI.this.jebAcct.setEnabled(!RptAsstactXBalanceConditionUI.this.hasSelectAcctItem);
                    RptAsstactXBalanceConditionUI.this.tbl.getStyleAttributes().setBackground(Color.WHITE);
                } else {
                    RptAsstactXBalanceConditionUI.this.jebAcct.setEnabled(false);
                    RptAsstactXBalanceConditionUI.this.tbl.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
                    RptAsstactXBalanceConditionUI.this.jebAccountFrom.setValue(null);
                    RptAsstactXBalanceConditionUI.this.jebAccountTo.setValue(null);
                }
            }
        });
        RptParams initparams1 = new RptParams();
        initparams1.setString("cuID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        try {
            this.rs = RptClientUtil.queryAsstActOfRS(initparams1);
            this.rsAsstAll = (RptRowSet)this.rs.clone();
            RptRowSet asstAccountIdRst = (RptRowSet)this.rs.getProperty("asstAccountIdRst");
            for (int i = 0; i < asstAccountIdRst.getRowCount(); ++i) {
                asstAccountIdRst.next();
                if (!asstAccountIdRst.getString("FREALTIONDATAOBJECT").equalsIgnoreCase("T_BD_Customer") && !asstAccountIdRst.getString("FREALTIONDATAOBJECT").equalsIgnoreCase("T_BD_Supplier")) continue;
                this.bizCodeIdList.add(asstAccountIdRst.getString("fasstaccountid"));
            }
        }
        catch (ReportBizException ex) {
            this.handUIException((Throwable)((Object)ex));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        AuxAccountF7Filter.setFilter((KDBizPromptBox)this.jebAcct);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo mufilter = new FilterInfo();
        view.setFilter(mufilter);
        FilterItemCollection fic = mufilter.getFilterItems();
        fic.add(new FilterItemInfo("isDisabled", (Object)new Integer(0)));
        this.jebMeasureUnit.setEditable(true);
        this.jebMeasureUnit.setEditFormat("$number$");
        this.jebMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.jebMeasureUnit.setCommitFormat("$number$;$name$");
        this.jebMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.jebMeasureUnit.setSelectorCollection(sic);
        this.jebMeasureUnit.setEntityViewInfo(view);
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("selected")) {
                    RptAsstactXBalanceConditionUI.this.tbl.getCell(e.getRowIndex(), "selected").setValue(e.getValue());
                    boolean isSelect = (Boolean)e.getValue();
                    if (isSelect) {
                        IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(e.getRowIndex());
                        AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                        int level = 1;
                        if (row.getCell("maxLevel").getValue() != null) {
                            level = Integer.parseInt(row.getCell("maxLevel").getValue().toString());
                        }
                        at.setSelectedLevel(level);
                        RptAsstactXBalanceConditionUI.this.addAsstActF7(row, at);
                        if (row.getCell("collect") != null && row.getCell("collect").getValue() == null) {
                            row.getCell("collect").setValue((Object)CollectEnum.LEAF);
                            RptAsstactXBalanceConditionUI.this.setMaxLevelCell(row, at);
                        }
                    } else {
                        IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(e.getRowIndex());
                        row.getCell("to").getStyleAttributes().setLocked(true);
                        row.getCell("from").getStyleAttributes().setLocked(true);
                    }
                    RptAsstactXBalanceConditionUI.this.changeMeasureUnitFilter();
                } else if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("collect")) {
                    IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(e.getRowIndex());
                    AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                    int level = 1;
                    if (row.getCell("maxLevel").getValue() != null) {
                        level = Integer.parseInt(row.getCell("maxLevel").getValue().toString());
                    }
                    at.setSelectedLevel(level);
                    RptAsstactXBalanceConditionUI.this.setMaxLevelCell(row, at);
                }
            }

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("selected")) {
                    RptAsstactXBalanceConditionUI.this.jebAccountFrom.setValue(null);
                    RptAsstactXBalanceConditionUI.this.jebAccountTo.setValue(null);
                    RptAsstactXBalanceConditionUI.this.tbl.getCell(e.getRowIndex(), "selected").setValue(e.getValue());
                    RptAsstactXBalanceConditionUI.this.changeAccountFilter();
                    RptAsstactXBalanceConditionUI.this.changeMeasureUnitFilter();
                }
            }
        });
        try {
            this.spnPeriodYearEnd_stateChanged(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTableData() {
        this.kdUp.setEnabled(false);
        this.kdDown.setEnabled(false);
        this.tbl.removeRows();
        if (this.rs == null) {
            return;
        }
        if (this.rs.getRowCount() == 0) {
            return;
        }
        this.kdUp.setEnabled(true);
        this.kdDown.setEnabled(true);
        this.tbl.setRefresh(false);
        this.rs.reset();
        AsstactTypeEntity at = null;
        this.isUp = true;
        block2: for (int i = this.rs.getColumnNames().length - 1; i >= 0; --i) {
            if (!this.rs.getColumnName(i).equalsIgnoreCase("FCollect")) continue;
            for (int j = this.rs.getColumnNames().length - 1; j >= 0; --j) {
                if (!this.rs.getColumnName(j).equalsIgnoreCase("FAsstGroupInfo")) continue;
                this.isUp = false;
                break block2;
            }
            break;
        }
        List lsAt = (List)this.rs.getProperty("lsAt");
        int ils = 0;
        while (this.rs.next()) {
            IRow row = this.tbl.addRow();
            row.getCell("selected").setValue((Object)Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))));
            row.getCell("type").setValue((Object)this.rs.getString("FName"));
            row.getCell("from").setValue(this.rs.getObject("FFrom"));
            row.getCell("to").setValue(this.rs.getObject("FTo"));
            at = new AsstactTypeEntity();
            at.setSelected(Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))));
            at.setName(this.rs.getString("FName"));
            at.setFrom(this.rs.getObject("FFrom"));
            at.setTo(this.rs.getObject("FTo"));
            at.setHgAttribute(this.rs.getString("FASSTHGATTRIBUTE"));
            if (!this.isUp) {
                at.setCollect((CollectEnum)((Object)this.rs.getObject("FCollect")));
                at.setAsstGroup(this.rs.getString("FAsstGroupInfo"));
                at.setMaxLevel(this.rs.getInt("FMaxLevel"));
                if (this.rs.getObject("selectedLevel") != null) {
                    at.setSelectedLevel(Integer.valueOf(String.valueOf(this.rs.getObject("selectedLevel"))));
                }
            } else {
                at.setCollect(CollectEnum.LEAF);
                at.setMaxLevel(10);
                at.setSelectedLevel(1);
            }
            at.setAsstMeasureUnitGroupId(this.rs.getString("FAsstMeasureUnitGroupId"));
            at.setQtyAsst(this.rs.getInt("FQtyAsst") == 1);
            at.setUseLongNumber(false);
            try {
                at.setUseLongNumber(this.rs.getInt("FUseLongNumber") == 1);
            }
            catch (Exception ex) {
                logger.error((Object)"Query solution error! ", (Throwable)ex);
            }
            if (this.tbl.getColumn("collect") != null) {
                row.getCell("collect").setEditor(GLEditor.getComboBox(CollectEnum.getEnumList()));
                row.getCell("collect").setValue((Object)at.getCollect());
                this.setMaxLevelCell(row, at);
            } else {
                this.setMaxLevelCell(row, at);
            }
            if (lsAt == null || lsAt.size() == 0) {
                row.setUserObject((Object)at);
            } else {
                row.setUserObject((Object)((AsstactTypeEntity)lsAt.get(ils++)));
            }
            String att = at.getHgAttribute();
            if (Boolean.valueOf(String.valueOf(this.rs.getObject("FSelected"))).booleanValue()) {
                KDBizPromptBox bizPromptBox = new KDBizPromptBox();
                bizPromptBox.setEditable(true);
                bizPromptBox.setEditFormat("$number$");
                bizPromptBox.setCommitFormat("$number$;$name$");
                bizPromptBox.setDisplayFormat("$number$ - $name$");
                bizPromptBox.setQueryInfo(this.rs.getString("FDefaultQueryName"));
                EntityViewInfo vv = new EntityViewInfo();
                FilterInfo ff = new FilterInfo();
                vv.setFilter(ff);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                if ("1".equals(String.valueOf(this.rs.getObject("FIsMultiLevel")))) {
                    sic.add(new SelectorItemInfo("longnumber"));
                }
                bizPromptBox.setSelectorCollection(sic);
                bizPromptBox.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent e) {
                        try {
                            int beginRow = RptAsstactXBalanceConditionUI.this.tbl.getSelectManager().get().getBeginRow();
                            IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(beginRow);
                            if (e.getNewValue() != null && row.getCell("to").getValue() == null) {
                                row.getCell("to").setValue(e.getNewValue());
                            }
                        }
                        catch (Exception exc) {
                            RptAsstactXBalanceConditionUI.this.handUIException(exc);
                        }
                    }
                });
                GeneralAsstActTypeGroupInfo grp = null;
                if (this.rs.getObject("FGLAsstActTypeGrpID") != null) {
                    grp = new GeneralAsstActTypeGroupInfo();
                    grp.setId(BOSUuid.read((String)this.rs.getString("FGLAsstActTypeGrpID")));
                }
                GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, (GeneralAsstActTypeGroupInfo)grp, (String)at.getHgAttribute(), (boolean)at.isForCompany(), (boolean)false, (boolean)true, null, (CoreUIObject)this);
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
                row.getCell("from").setEditor((ICellEditor)editor);
                row.getCell("to").setEditor((ICellEditor)editor);
                row.getCell("group").setValue((Object)at.getAsstGroup());
                if (att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) {
                    KDBizPromptBox groupPromptBox = new KDBizPromptBox();
                    groupPromptBox.setEditable(true);
                    groupPromptBox.setEditFormat("$number$");
                    groupPromptBox.setDisplayFormat("$number$ - $name$");
                    groupPromptBox.setCommitFormat("$number$");
                    if (att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material")) {
                        AsstGroupFIChooserPrompt prompt = new AsstGroupFIChooserPrompt((IUIObject)this);
                        int asstGroupChooser = 0;
                        asstGroupChooser = att.equalsIgnoreCase("Customer") ? 1 : (att.equalsIgnoreCase("Material") ? 3 : 2);
                        groupPromptBox.setSelector((KDPromptSelector)prompt);
                        groupPromptBox.addSelectorListener((SelectorListener)new GroupSelectorListener(row.getCell("group")));
                        prompt.setGroupType(asstGroupChooser);
                        bizPromptBox.addSelectorListener((SelectorListener)new AssItemSelectorListener(asstGroupChooser));
                    }
                    KDTDefaultCellEditor groupEditor = new KDTDefaultCellEditor((IKDEditor)groupPromptBox);
                    ICell cell = row.getCell("group");
                    if (cell != null) {
                        cell.setEditor((ICellEditor)groupEditor);
                    }
                }
            }
            if (!(att.equalsIgnoreCase("Customer") || att.equalsIgnoreCase("provider") || att.equalsIgnoreCase("Material"))) {
                this.lockGroup(row);
                continue;
            }
            this.unLockGroup(row);
        }
        this.tbl.setRefresh(true);
        this.tbl.setScrollStateVertical(0);
        this.changeMeasureUnitFilter();
    }

    private void changeMeasureUnitFilter() {
        AsstactTypeEntity at;
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tbl.getRow(i);
            at = (AsstactTypeEntity)row.getUserObject();
            if (at == null) continue;
            at.setFrom(row.getCell("from").getValue());
            at.setTo(row.getCell("to").getValue());
            boolean selected = false;
            if (row.getCell("selected").getValue() != null) {
                selected = (Boolean)row.getCell("selected").getValue();
            }
            at.setSelected(selected);
            if (!selected) continue;
            list.add(at);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isDisabled", (Object)new Integer(0)));
        boolean hasSelected = list.size() > 0;
        this.hasQtyAsst = false;
        this.hasStdUnit = false;
        this.jcbExchangeStandardUnit.setEnabled(false);
        this.jcbExchangeStandardUnit.setSelected(false);
        this.jebMeasureUnit.setEnabled(false);
        if (hasSelected && this.isQtyAsst) {
            StringBuffer sf;
            int from = fic.size();
            if (filter.getMaskString() == null) {
                sf = new StringBuffer();
                sf.append(" #0 ");
            } else {
                sf = new StringBuffer(filter.getMaskString());
            }
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                if (!at.isQtyAsst()) continue;
                sf.append(" and ");
                this.setDisplayAmountEnabled(true);
                this.hasQtyAsst = true;
                if (at.getFrom() != null && at.getTo() != null && at.getFrom().toString().equals(at.getTo().toString())) {
                    Object o = at.getFrom();
                    if (o instanceof MaterialInfo) {
                        if (at.getAsstMeasureUnitGroupId() != null) {
                            if (((MaterialInfo)o).getBaseUnit().getMeasureUnitGroup() != null && ((MaterialInfo)o).getBaseUnit().getMeasureUnitGroup().getId().equals((Object)at.getAsstMeasureUnitGroupId())) {
                                fic.add(new FilterItemInfo("id", (Object)((MaterialInfo)o).getBaseUnit().getId()));
                                sf.append("#").append(from++);
                            } else {
                                fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)at.getAsstMeasureUnitGroupId()));
                                sf.append("#").append(from++);
                            }
                        } else {
                            fic.add(new FilterItemInfo("id", (Object)((MaterialInfo)o).getBaseUnit().getId()));
                            sf.append("#").append(from++);
                        }
                    } else if (o instanceof GeneralAsstActTypeInfo) {
                        GeneralAsstActTypeInfo generalType = (GeneralAsstActTypeInfo)o;
                        if (generalType.getMeasureUnit() != null) {
                            fic.add(new FilterItemInfo("id", (Object)generalType.getMeasureUnit().getId()));
                            sf.append("#").append(from++);
                        } else if (at.getAsstMeasureUnitGroupId() != null) {
                            fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)at.getAsstMeasureUnitGroupId()));
                            sf.append("#").append(from++);
                        }
                    } else if (at.getAsstMeasureUnitGroupId() != null) {
                        fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)at.getAsstMeasureUnitGroupId()));
                        sf.append("#").append(from++);
                    }
                } else if (at.getAsstMeasureUnitGroupId() != null) {
                    fic.add(new FilterItemInfo("measureUnitGroup.id", (Object)at.getAsstMeasureUnitGroupId()));
                    sf.append("#").append(from++);
                }
                if (at.getAsstMeasureUnitGroupId() == null) continue;
                this.hasStdUnit = at.isQtyAsst();
                if (this.jcbDisplayAmount.isSelected()) {
                    this.jcbExchangeStandardUnit.setEnabled(true);
                    this.jebMeasureUnit.setEnabled(true);
                }
                MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                if (at.getAsstMeasureUnitId() == null) continue;
                measureUnitInfo.setId(BOSUuid.read((String)at.getAsstMeasureUnitId()));
                this.standardUnit = measureUnitInfo;
            }
            filter.setMaskString(sf.toString());
        }
        this.jebMeasureUnit.setEditFormat("$number$");
        this.jebMeasureUnit.setDisplayFormat("$number$ - $name$");
        this.jebMeasureUnit.setCommitFormat("$number$;$name$");
        this.jebMeasureUnit.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherMeasureUnitQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("coefficient"));
        sic.add(new SelectorItemInfo("isDisabled"));
        sic.add(new SelectorItemInfo("measureUnitGroup.id"));
        this.jebMeasureUnit.setSelectorCollection(sic);
        this.jebMeasureUnit.setEntityViewInfo(view);
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this), new Component[]{this.tbl});
        this.rs.reset();
        this.filterRsByTbl(this.rs, this.tbl);
        this.rs.reset();
        ArrayList<AsstactTypeEntity> lsAt = new ArrayList<AsstactTypeEntity>();
        int i = 0;
        while (this.rs.next()) {
            this.rs.setValue("FSelected", this.tbl.getCell(i, "selected").getValue());
            this.rs.setValue("FFrom", this.tbl.getCell(i, "from").getValue());
            this.rs.setValue("FTo", this.tbl.getCell(i, "to").getValue());
            if (!this.isUp) {
                this.rs.setValue("FCollect", this.tbl.getCell(i, "collect").getValue());
                this.rs.setValue("FAsstGroupInfo", this.tbl.getCell(i, "group").getValue());
                if (this.tbl.getCell(i, "maxLevel").getValue() != null) {
                    this.rs.setValue("selectedLevel", this.tbl.getCell(i, "maxLevel").getValue());
                } else {
                    this.rs.setValue("selectedLevel", (Object)new Integer(-1));
                }
                IRow row = this.tbl.getRow(i);
                AsstactTypeEntity at = (AsstactTypeEntity)row.getUserObject();
                this.rs.setValue("FMaxLevel", (Object)new Integer(at.getMaxLevel()));
                if (this.tbl.getCell(i, "group") != null && this.tbl.getCell(i, "group").getValue() != null) {
                    at.setAsstGroup(this.tbl.getCell(i, "group").getValue().toString());
                } else {
                    at.setAsstGroup(null);
                }
                lsAt.add(i, at);
            }
            ++i;
        }
        this.rs.setProperty("lsAt", lsAt);
        this.rs.reset();
        i = 0;
        while (this.rs.next()) {
            if (!((CollectEnum)((Object)this.tbl.getCell(i, "collect").getValue())).equals((Object)CollectEnum.LEAF) && this.rs.getRow() != 0) {
                this.rs.moveRow(this.rs.getRow(), 0);
                this.tbl.moveRow(this.rs.getRow(), 0);
            }
            ++i;
        }
        rm.setProperty("rs", (Object)this.rs);
        rm.setProperty("standardUnit", (Object)this.standardUnit);
        rm.setProperty("isQtyAsst", (Object)this.isQtyAsst);
        return rm.toRptParams();
    }

    private void filterRsByTbl(RptRowSet rs2, KDTable tbl2) {
        int tblCount = tbl2.getRowCount();
        AsstactTypeEntity tmpAsstactTypeEntity = null;
        block0: for (int i = 0; i < tblCount; ++i) {
            tmpAsstactTypeEntity = (AsstactTypeEntity)tbl2.getRow(i).getUserObject();
            if (tmpAsstactTypeEntity == null) continue;
            rs2.reset();
            while (rs2.next()) {
                if (rs2.getString("fname") == null || tmpAsstactTypeEntity.getName() == null || !rs2.getString("fname").equals(tmpAsstactTypeEntity.getName())) continue;
                rs2.moveRow(rs2.getRow(), i);
                continue block0;
            }
        }
        rs2.moveTo(tblCount - 1);
        while (rs2.next()) {
            rs2.remove();
        }
        rs2.reset();
    }

    public void setCustomCondition(RptParams params) {
        this.setTag(1);
        RptConditionManager rm = new RptConditionManager(params, new String[]{"rs"});
        this.rs = (RptRowSet)rm.getProperty("rs");
        this.isUp = true;
        block0: for (int i = this.rs.getColumnNames().length - 1; i >= 0; --i) {
            if (!this.rs.getColumnName(i).equalsIgnoreCase("FCollect")) continue;
            for (int j = this.rs.getColumnNames().length - 1; j >= 0; --j) {
                if (!this.rs.getColumnName(j).equalsIgnoreCase("FAsstGroupInfo")) continue;
                this.isUp = false;
                break block0;
            }
            break;
        }
        if (params.getObjectElement("jspLevelFrom.value") == null) {
            this.jspLevelFrom.setValue((Object)new Integer(1));
        } else {
            this.jspLevelFrom.setValue(params.getObjectElement("jspLevelFrom.value"));
        }
        if (params.getObjectElement("jspLevelTo.value") == null) {
            this.jspLevelTo.setValue((Object)new Integer(1));
        } else {
            this.jspLevelTo.setValue(params.getObjectElement("jspLevelTo.value"));
        }
        this.setTableData();
        rm.restoreAllStatus((Container)((Object)this));
        this.changeAccountFilter();
        this.jcbisDCSperate.setEnabled(!this.sameAsAccount);
        if (this.sameAsAccount) {
            this.jcbisDCSperate.setSelected(false);
        }
        this.setTag(0);
    }

    public boolean verify() {
        int numberBegin;
        int yearBegin;
        int yearEnd = (Integer)this.jspYearTo.getValue();
        if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.jspYearFrom.getValue()).intValue(), numberBegin = ((Integer)this.jspPeriodFrom.getValue()).intValue())) {
            return false;
        }
        if (this.rs == null) {
            this.jebAccountFrom.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("reSelect_accountView_for_incorrectness_act"));
            return false;
        }
        boolean s = false;
        this.getCustomCondition();
        if (this.rdBizAnalysisCode.isSelected()) {
            return true;
        }
        this.rs.reset();
        while (this.rs.next()) {
            if (this.rs.getObject("FSelected") == null || !((Boolean)this.rs.getObject("FSelected")).booleanValue()) continue;
            s = true;
            break;
        }
        if (!s) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please"));
            return false;
        }
        List list = this.getTableData();
        boolean actSelected = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            if (!at.isSelected()) continue;
            actSelected = true;
            break;
        }
        if (!actSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_act_item_please2"));
            return false;
        }
        return true;
    }

    @Override
    protected void jcbExchangeStandardUnit_itemStateChanged(ItemEvent e) throws Exception {
    }

    public void clear() {
        super.clear();
        this.jspYearFrom.setValue((Object)new Integer(this.currYear));
        this.jspYearTo.setValue((Object)new Integer(this.currYear));
        this.jspPeriodFrom.setValue((Object)new Integer(this.currMonth));
        this.jspPeriodTo.setValue((Object)new Integer(this.currMonth));
        this.rdAcct.setSelected(true);
        this.chkOpAsstGroup.setSelected(false);
        Integer ONE = new Integer(1);
        this.jspLevelFrom.setValue((Object)ONE);
        this.jspLevelTo.setValue((Object)ONE);
        this.jebAccountFrom.setValue(null);
        this.jebAccountTo.setValue(null);
        this.jebAcct.setValue(null);
        this.jebBizCodeFrom.setValue(null);
        this.jebBizCodeTo.setValue(null);
        this.jebMeasureUnit.setValue(null);
        this.jcbDisplayAmount.setSelected(false);
        this.jcbExchangeStandardUnit.setSelected(false);
        this.jcbIncludeUnPost.setSelected(false);
        this.jcbisDCSperate.setSelected(false);
        this.jcbincludeNoTransPLVoucher.setSelected(false);
        this.jcbNoDisplayZero.setSelected(false);
        this.jcbNoPlayBalanceZero.setSelected(false);
        this.chkShowLeafAccount.setSelected(false);
        this.jcbDisplayAssSum.setSelected(false);
        try {
            this.jebAcct_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 0; i < this.jbxCurrency.getItemCount(); ++i) {
            Object value = this.jbxCurrency.getItemAt(i);
            if (!(value instanceof CurrencyInfo) || !this.company.getBaseCurrency().getId().equals((Object)((CurrencyInfo)value).getId())) continue;
            this.jbxCurrency.setSelectedItem(value);
        }
    }

    private boolean checkAccountRangeIfQty() throws EASBizException, BOSException {
        String accountFrom = null;
        String accountTo = null;
        HashMap<String, Object[]> otherParam = new HashMap<String, Object[]>();
        Object[] avFrom = (Object[])this.jebAccountFrom.getValue();
        Object[] avTo = (Object[])this.jebAccountTo.getValue();
        if (avFrom != null && avFrom.length >= 1 && avFrom[0] instanceof AccountViewInfo) {
            accountFrom = ((AccountViewInfo)avFrom[avFrom.length - 1]).getNumber();
            otherParam.put("avFrom", avFrom);
        }
        if (avTo != null && avTo.length >= 1 && avTo[0] instanceof AccountViewInfo) {
            accountTo = ((AccountViewInfo)avTo[0]).getNumber();
            otherParam.put("avTo", avTo);
        }
        if (this.filter != null) {
            boolean isAcctQty = RptAsstactXBalanceFactory.getRemoteInstance().isAccountQty(accountFrom, accountTo, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), otherParam, this.filter);
            return isAcctQty;
        }
        return false;
    }

    @Override
    protected void jebAccountTo_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getTag() == 1) {
            return;
        }
        this.jebaccountToLvChangedByAccount();
        this.setDisplayAmountEnabled();
    }

    private void unLockGroup(IRow row) {
        if (row.getCell("group") == null) {
            return;
        }
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(false);
        sa.setBackground(Color.WHITE);
        sa.setPattern(Pattern.Solid);
    }

    private void lockGroup(IRow row) {
        if (row.getCell("group") == null) {
            return;
        }
        StyleAttributes sa = row.getCell("group").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    protected void fillAccLevelSpinner(int maxLevel) {
        SpinnerUtil.manageAccountLevelRange((int)1, (int)maxLevel, (KDSpinner)this.jspLevelFrom, (KDSpinner)this.jspLevelTo);
    }

    private void initAccountF7(RptParams initParams) throws Exception {
        FilterInfo accountfilter = new FilterInfo();
        AccountTableInfo accountTable = this.company.getAccountTable();
        AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.company.getId().toString(), this.company.getAccountTable().getId().toString(), this.jspYearTo.getIntegerVlaue().intValue(), this.jspPeriodTo.getIntegerVlaue().intValue());
        if (ar != null) {
            accountTable = ar.getEnabledAcctTable();
        }
        FilterItemCollection accountfic = accountfilter.getFilterItems();
        accountfic.add(new FilterItemInfo("companyid.id", (Object)this.company.getId().toString()));
        accountfic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        accountfic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        accountfilter.setMaskString("#0 and #1 and #2 ");
        AccountPromptBox accountapb = new AccountPromptBox((IUIObject)this, accountTable, accountfilter);
        EntityViewInfo accountmyevi = new EntityViewInfo();
        accountmyevi.setFilter(accountfilter);
        this.jebAccountFrom.setSelector((KDPromptSelector)accountapb);
        this.jebAccountFrom.setEntityViewInfo(accountmyevi);
        this.jebAccountFrom.setEnabled(false);
        this.jebAccountFrom.setEditable(true);
        this.jebAccountFrom.setEditFormat("$number$");
        this.jebAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountFrom.setDisplayFormat("$number$ - $name$");
        this.jebAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountFrom.setCommitParser((IParser)new AccountViewParser(this.jebAccountFrom));
        this.jebAccountFrom.setEnabledMultiSelection(true);
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("CAA.*"));
        this.jebAccountFrom.setSelectorCollection(sc);
        this.jebAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        this.jebAccountTo.setSelector((KDPromptSelector)accountapb);
        this.jebAccountTo.setEntityViewInfo(accountmyevi);
        this.jebAccountTo.setEnabled(false);
        this.jebAccountTo.setEditable(true);
        this.jebAccountTo.setEditFormat("$number$");
        this.jebAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.jebAccountTo.setDisplayFormat("$number$ - $name$");
        this.jebAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.jebAccountTo.setCommitParser((IParser)new AccountViewParser(this.jebAccountTo));
        this.jebAccountTo.setEnabledMultiSelection(true);
        this.jebAccountTo.setSelectorCollection(sc);
        int maxLevel = initParams.getInt("maxLevel");
        if (maxLevel != 0) {
            this.fillAccLevelSpinner(maxLevel);
        }
        this.jebAccountTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        this.filter = new FilterInfo();
        FilterItemCollection fic = this.filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        this.filter.setMaskString("#0 and #1 and #2 ");
    }

    private void setDisplayAmountEnabled() {
        if (this.filter == null) {
            this.setDisplayAmountEnabled(false);
            return;
        }
        boolean hasSelectedItem = this.hasSelectAsstActItem();
        if (!hasSelectedItem) {
            this.setDisplayAmountEnabled(hasSelectedItem);
            return;
        }
        if (this.isQtyAsst) {
            boolean hasSelectedItemQty = this.hasSelectAsstActItemQty();
            this.setDisplayAmountEnabled(hasSelectedItemQty);
        } else {
            try {
                this.isAccountRangeQty = this.checkAccountRangeIfQty();
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.setDisplayAmountEnabled(this.isAccountRangeQty);
        }
    }

    private void setDisplayAmountEnabled(boolean enabled) {
        this.jcbDisplayAmount.setEnabled(enabled);
        if (!enabled) {
            this.jcbDisplayAmount.setSelected(false);
        }
    }

    private void initSomeComponents() {
        this.jspYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAsstactXBalanceConditionUI.this.spnPeriodYearEnd_stateChanged(e);
            }
        });
        this.chkOpAsstGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptAsstactXBalanceConditionUI.this.tbl.getColumn("group").getStyleAttributes().setHided(false);
                } else {
                    RptAsstactXBalanceConditionUI.this.tbl.getColumn("group").getStyleAttributes().setHided(true);
                }
            }
        });
        this.chkShowLeafAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptAsstactXBalanceConditionUI.this.jspLevelFrom.setEnabled(false);
                    RptAsstactXBalanceConditionUI.this.jspLevelTo.setEnabled(false);
                } else {
                    RptAsstactXBalanceConditionUI.this.jspLevelFrom.setEnabled(true);
                    RptAsstactXBalanceConditionUI.this.jspLevelTo.setEnabled(true);
                }
            }
        });
        this.tbl.getColumn("group").getStyleAttributes().setHided(true);
        this.company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        RptParams param = RptClientUtil.loadSystemParams(this.company.getId().toString());
        if (param.getObject("G010") != null) {
            this.isQtyAsst = Boolean.valueOf(param.getObject("G010").toString());
        }
    }

    private boolean hasSelectAsstActItem() {
        IRow row = null;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            boolean select = (Boolean)row.getCell("selected").getValue();
            if (!select) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectAsstActItemQty() {
        AsstactTypeEntity at = null;
        IRow row = null;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            boolean select = (Boolean)row.getCell("selected").getValue();
            if (!select || !(at = (AsstactTypeEntity)row.getUserObject()).isQtyAsst()) continue;
            return true;
        }
        return false;
    }

    private int getAccountLevel(IObjectPK companyPK, IObjectPK accountTablePK, String strAccountNumber) throws BOSException, EASBizException {
        AccountViewInfo accView = AccountUtils.getAccountViewCByNumber((String)strAccountNumber, (IObjectPK)companyPK, (IObjectPK)accountTablePK);
        if (accView != null) {
            return accView.getLevel();
        }
        return 1;
    }

    private static class GroupSelectorListener
    implements SelectorListener {
        ICell groupCell;

        public GroupSelectorListener(ICell cell) {
            this.groupCell = cell;
        }

        public void willShow(SelectorEvent e) {
            KDBizPromptBox box = (KDBizPromptBox)e.getSource();
            AsstGroupFIChooserPrompt prompt = (AsstGroupFIChooserPrompt)box.getSelector();
            prompt.setInitData(this.groupCell.getValue());
        }
    }

    private final class AssItemSelectorListener
    implements SelectorListener {
        int type = -1;

        public AssItemSelectorListener(int type) {
            this.type = type;
        }

        public void willShow(SelectorEvent e) {
            IRow row = RptAsstactXBalanceConditionUI.this.tbl.getRow(RptAsstactXBalanceConditionUI.this.tbl.getSelectManager().getActiveRowIndex());
            Object startGroup = row.getCell("group").getValue();
            if (startGroup == null) {
                return;
            }
            String groups = startGroup.toString();
            KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
            if (StringUtils.isEmpty((String)groups)) {
                pb.setEntityViewInfo(null);
                pb.getQueryAgent().resetRuntimeEntityView();
                return;
            }
            EntityViewInfo view = pb.getEntityViewInfo();
            if (view == null) {
                view = new EntityViewInfo();
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            view.setFilter(filter);
            pb.setEntityViewInfo(view);
            pb.getQueryAgent().resetRuntimeEntityView();
            try {
                int i;
                AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem((String)("1002|001|" + groups + "#"));
                if (item == null) {
                    return;
                }
                AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
                String mask = null;
                for (i = 0; group != null && i < group.length; ++i) {
                    String std = group[i].standardNumber;
                    if (this.type == 1) {
                        fic.add(new FilterItemInfo("customerGroupDetails.CustomerGroupStandard.number", (Object)std));
                    } else if (this.type == 2) {
                        fic.add(new FilterItemInfo("supplierGroupDetails.SupplierGroupStandard.number", (Object)std));
                    } else if (this.type == 3) {
                        fic.add(new FilterItemInfo("materialGroupDetails.MaterialGroupStandard.number", (Object)std));
                    }
                    mask = i == 0 ? "#" + i : mask + " or #" + i;
                }
                if (i > 1) {
                    filter.setMaskString(mask);
                }
            }
            catch (ParseException e1) {
                return;
            }
        }
    }
}

