/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.RptAsstactXBalanceFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptAsstactXBalanceUI;
import com.kingdee.eas.fi.gl.client.RptAsstactBalanceListUI;
import com.kingdee.eas.fi.gl.client.RptAsstactXBalanceConditionUI;
import com.kingdee.eas.fi.gl.client.RptAsstactXBalanceParame;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.TreeNodeRender;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RptAsstactXBalanceUI
extends AbstractRptAsstactXBalanceUI {
    private static final long serialVersionUID = -8626156828467413058L;
    private static final Logger logger = CoreUIObject.getLogger(RptAsstactXBalanceUI.class);
    private MyTreeNodeRender render = new MyTreeNodeRender();
    private boolean isBizCode = false;
    private boolean isDisplaySubsidiary = true;
    private int selectedLevel = -1;
    private RptAsstactXBalanceParame editParame = null;
    private RptParams result = null;
    private int localScale = 2;

    public RptAsstactXBalanceUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().setDataRequestMode(0);
        this.tbl.getSelectManager().setSelectMode(10);
        this.tbl.getStyleAttributes().setLocked(true);
        this.enableExportExcel(this.tbl);
        this.tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int row = e.getRowIndex();
                int column = e.getColIndex();
                if (e.getClickCount() == 2 && RptAsstactXBalanceUI.this.actionJoinQueryRptAsstactList.isEnabled()) {
                    try {
                        RptAsstactXBalanceUI.this.joinQueryAsstactList();
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                    }
                } else {
                    RptAsstactXBalanceUI.this.cellClicked(row, column, e.getX(), e.getY());
                }
            }
        });
        this.tbl.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int i = e.getSelectBlock().getTop();
                if (i >= 0) {
                    String v = String.valueOf(RptAsstactXBalanceUI.this.tbl.getCell(i, "FIsLeaf").getValue());
                    String accountid = String.valueOf(RptAsstactXBalanceUI.this.tbl.getCell(i, "FAccountID").getValue());
                    if (!v.equals("null")) {
                        RptAsstactXBalanceUI.this.actionJoinQueryRptAsstactList.setEnabled(!RptAsstactXBalanceUI.this.isBizCode && v.trim().length() != 0 && 1 == new Float(v).intValue() && accountid != null && accountid.length() > 1);
                    }
                } else {
                    RptAsstactXBalanceUI.this.actionJoinQueryRptAsstactList.setEnabled(false);
                }
            }
        });
        this.setButtonIcon((JButton)this.btnJoinQueryList, "imgTbtn_assistantaccountdetail");
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuView.add((JMenuItem)this.menuItemQuery);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuView.add((Component)this.kDSeparator2);
        this.menuView.add((JMenuItem)this.menuJoinQueryRptAsstactList);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.tbl.getBody().getRows().size() != 0) {
            if (this.editParame == null) {
                this.editParame = RptAsstactXBalanceParame.getInstance();
            }
            if (!this.editParame.isChkPrintParame()) {
                super.preparePrintPage(this.tbl);
                this.tbl.getPrintManager().print();
            } else if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                this.invokePrintFunc(e, false);
            } else {
                super.preparePrintPage(this.tbl);
                this.tbl.getPrintManager().print();
            }
        } else {
            this.showInfoCom();
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.tbl.getBody().getRows().size() != 0) {
            if (this.editParame == null) {
                this.editParame = RptAsstactXBalanceParame.getInstance();
            }
            if (!this.editParame.isChkPrintParame()) {
                super.preparePrintPage(this.tbl);
                this.tbl.getPrintManager().printPreview();
            } else if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                this.invokePrintFunc(e, true);
            } else {
                super.preparePrintPage(this.tbl);
                this.tbl.getPrintManager().printPreview();
            }
        } else {
            this.showInfoCom();
        }
    }

    private void showInfoCom() {
        KDTable tbl = this.getTableForPrintSetting();
        tbl.getPrintManager().getNewPrintManager().getPrinter().prompt(Resources.getMsg((String)"prompt.nocontent"));
    }

    protected void invokePrintFunc(ActionEvent evt, boolean noPreview) throws Exception {
        String strTemplatepathPath = null;
        strTemplatepathPath = this.editParame.getStrTempletpathPath();
        String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
        if (strTemplatepathPath == null && StringUtils.isEmpty((String)strTemplatepathPath)) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"notTemplet");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        RptAsstactXBalanceTaoda rsprv = new RptAsstactXBalanceTaoda(this.result);
        appHlp.directPrint(strTemplatepathPath, (Object)rsprv, noPreview, (Component)((Object)this));
    }

    protected String getAsstActPrintTitle(int selectedRowIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(this.jtAsstact.getText()).append("] ");
        String s = sb.toString();
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    @Override
    public void actionJoinQueryRptAsstactList_actionPerformed(ActionEvent e) throws Exception {
        this.joinQueryAsstactList();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected KDTable getTableForCommon() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        RptParams rp = new RptParams();
        rp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return rp;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        this.queryDialog.setMaxReturnCountVisible(false);
        return new RptAsstactXBalanceConditionUI();
    }

    protected void query() {
        this.actionJoinQueryRptAsstactList.setEnabled(false);
        this.isBizCode = (Boolean)this.params.getObjectElement("rdBizAnalysisCode.value");
        String accountName = null;
        try {
            accountName = this.getAccountName(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        this.jtAccount.setText("[" + this.params.getObjectElement("jebAccountFrom.value.number") + "] " + this.params.getObjectElement(accountName));
        this.jtAccount.setToolTipText(this.jtAccount.getText());
        this.jtCurrency.setText(String.valueOf(this.params.getObjectElement("jbxCurrency.value.name")));
        this.jtCurrency.setToolTipText(this.jtCurrency.getText());
        String period = RptClientUtil.getPeriodTitle((Integer)this.params.getObjectElement("jspYearFrom.value"), (Integer)this.params.getObjectElement("jspPeriodFrom.value"), (Integer)this.params.getObjectElement("jspYearTo.value"), (Integer)this.params.getObjectElement("jspPeriodTo.value"));
        this.jtPeriod.setText(period);
        this.jtPeriod.setToolTipText(this.jtPeriod.getText());
        RptRowSet rs = (RptRowSet)this.params.getObject("rs");
        rs.reset();
        StringBuffer sb = new StringBuffer();
        this.selectedLevel = -1;
        boolean isUp = true;
        for (int i = rs.getColumnNames().length - 1; i >= 0; --i) {
            if (!rs.getColumnName(i).equalsIgnoreCase("FCollect")) continue;
            isUp = false;
            break;
        }
        this.isDisplaySubsidiary = true;
        while (rs.next()) {
            if (rs.getObject("FSelected") != null && ((Boolean)rs.getObject("FSelected")).booleanValue() && !isUp) {
                CollectEnum collect = (CollectEnum)((Object)rs.getObject("FCollect"));
                int maxLevel = rs.getInt("selectedLevel");
                if (collect != null && !collect.equals((Object)CollectEnum.LEAF)) {
                    if (maxLevel > 0 && collect.equals((Object)CollectEnum.UP)) {
                        this.selectedLevel = maxLevel;
                    } else if (collect.equals((Object)CollectEnum.LEVEL)) {
                        this.selectedLevel = 1;
                    }
                    this.isDisplaySubsidiary = false;
                }
                sb.append(rs.getString("FName")).append('+');
                continue;
            }
            if (rs.getObject("FSelected") == null || !((Boolean)rs.getObject("FSelected")).booleanValue() || !isUp) continue;
            this.selectedLevel = 1;
            sb.append(rs.getString("FName")).append('+');
        }
        if (sb.length() >= 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.jtAsstact.setText(sb.toString());
        this.jtAsstact.setToolTipText(this.jtAsstact.getText());
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        RptParams sysPros = RptClientUtil.loadSystemParams(companyId);
        int yearEnd = (Integer)this.params.getObjectElement("jspYearTo.value");
        int numberEnd = (Integer)this.params.getObjectElement("jspPeriodTo.value");
        String currencyID = String.valueOf(this.params.getObjectElement("jbxCurrency.value.id"));
        boolean isBaseCurrencyQuery = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID) || SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId().toString().equalsIgnoreCase(currencyID);
        CompanyOrgUnitInfo currCompany = RptClientUtil.getCompany(yearEnd, numberEnd);
        boolean isForgenCurr = sysPros.getBoolean("GL_008");
        if (isForgenCurr) {
            isBaseCurrencyQuery = true;
        }
        RptParams pp = null;
        try {
            pp = (RptParams)this.params.clone();
        }
        catch (CloneNotSupportedException e) {
            this.handUIExceptionAndAbort(e);
        }
        pp.setObject("company", (Object)currCompany);
        pp.setString("cuId", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        pp.setString("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        rs = ((RptRowSet)this.params.getObject("rs")).copy();
        pp.setObject("rs", (Object)rs);
        rs.reset();
        while (rs.next()) {
            if (rs.getObject("FSelected") != null && ((Boolean)rs.getObject("FSelected")).booleanValue()) continue;
            rs.removeRow(rs.getRow());
            if (rs.isBof()) {
                rs.reset();
                continue;
            }
            rs.previous();
        }
        pp.setString("tempTable", this.getTempTable());
        pp.setString("accountTableId", SysContext.getSysContext().getCurrentFIUnit().getAccountTable().getId().toString());
        try {
            this.result = RptAsstactXBalanceFactory.getRemoteInstance().createTempTable(pp);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        RptTableHeader header = (RptTableHeader)this.result.getObject("header");
        String tempTable = this.result.getString("tempTable");
        this.setTempTable(tempTable);
        RptRowSet prs = (RptRowSet)this.result.getObject("prs");
        this.tbl.removeColumns();
        KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
        this.tbl.getColumn(3).setRenderer((IBasicRender)this.render);
        int amountBeginIndex = this.result.getInt("amountBeginIndex");
        int precision = (Integer)this.params.getObjectElement("jbxCurrency.value.precision");
        String strQty = sysPros.getString("GL_002");
        String strPrice = sysPros.getString("GL_003");
        int scaleQty = new Integer(strQty);
        int strPriceScale = new Integer(strPrice);
        boolean displayAmount = (Boolean)pp.getObjectElement("jcbDisplayAmount.value");
        boolean displayPrice = true;
        int formatColumnCount = isBaseCurrencyQuery ? (displayAmount && displayPrice ? 20 : (displayAmount ? 14 : 8)) : (displayAmount && displayPrice ? 28 : (displayAmount ? 22 : 16));
        this.localScale = currCompany.getBaseCurrency().getPrecision();
        String localCurrencyName = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"currency_local");
        IRow lastHeadRow = this.tbl.getHeadRow(this.tbl.getHeadRowCount() - 1);
        for (int i = amountBeginIndex; i < amountBeginIndex + formatColumnCount; ++i) {
            if (localCurrencyName.equals(lastHeadRow.getCell(i).getValue())) {
                this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(this.localScale));
                continue;
            }
            this.tbl.getColumn(i).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
        }
        if (isBaseCurrencyQuery) {
            if (displayAmount && displayPrice) {
                this.tbl.getColumn("amount0").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount1").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
                this.tbl.getColumn("amount4").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount5").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
                this.tbl.getColumn("amount7").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount8").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
                this.tbl.getColumn("amount10").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount11").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
                this.tbl.getColumn("amount13").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount14").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
                this.tbl.getColumn("amount16").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount17").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            } else if (displayAmount) {
                this.tbl.getColumn("amount0").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount3").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount5").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount7").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount9").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
                this.tbl.getColumn("amount11").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            }
        } else if (displayAmount && displayPrice) {
            this.tbl.getColumn("amount0").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount1").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            this.tbl.getColumn("amount6").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount7").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            this.tbl.getColumn("amount10").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount11").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            this.tbl.getColumn("amount14").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount15").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            this.tbl.getColumn("amount18").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount19").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
            this.tbl.getColumn("amount22").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount23").getStyleAttributes().setNumberFormat(this.getDecimalFormat(strPriceScale));
        } else if (displayAmount) {
            this.tbl.getColumn("amount0").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount5").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount8").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount11").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount14").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
            this.tbl.getColumn("amount17").getStyleAttributes().setNumberFormat(this.getDecimalFormat(scaleQty));
        }
        this.tbl.removeRows();
        boolean sameAsAccount = Boolean.valueOf(sysPros.getString("GL_005"));
        KDTableUtil.insertRows((RptRowSet)prs, (int)0, (KDTable)this.tbl, (KDTableInsertHandler)new MyKDTableInsertHandler(prs, this.tbl, sameAsAccount, displayPrice, !isBaseCurrencyQuery, amountBeginIndex));
        if (this.isDisplaySubsidiary) {
            int i;
            prs.reset();
            int itbl = i = 0;
            prs.next();
            while (!prs.isEof()) {
                if (prs.getInt("FLevel") == 0 || prs.getInt("FIsLeaf") == 1) {
                    ++i;
                    ++itbl;
                } else {
                    ++i;
                    this.tbl.removeRow(itbl);
                }
                prs.moveTo(i);
            }
            if (prs.getRowCount() > 0 && prs.getString("FOrderNumber").equals(GlUtils.getMaxChar())) {
                this.tbl.getRow(itbl).getStyleAttributes().setBackground(new Color(0xF6F6BF));
            }
        } else {
            int i;
            prs.reset();
            int itbl = i = 0;
            int t = 0;
            prs.next();
            while (!prs.isEof()) {
                if (prs.getInt("FLevel") < this.selectedLevel && prs.getInt("FIsLeaf") != 1) {
                    ++i;
                    this.tbl.removeRow(itbl);
                } else if (prs.getInt("FLevel") == this.selectedLevel) {
                    t = i - itbl;
                    itbl = this.switchRowView(itbl);
                    i = itbl + t;
                } else {
                    ++i;
                    ++itbl;
                }
                prs.moveTo(i);
            }
            if (prs.getRowCount() > 0 && prs.getString("FOrderNumber").equals(GlUtils.getMaxChar())) {
                this.tbl.getRow(itbl).getStyleAttributes().setBackground(new Color(0xF6F6BF));
            }
        }
        if (!this.isFirstOnload()) {
            this.tHelper.init();
        }
        this.mergeBolck(0);
        this.mergeBolck(this.isBizCode ? 2 : 3);
        this.checkTableCommonMenu(this.tbl);
    }

    private String getAccountName(String companyId) throws BOSException, EASBizException {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        boolean isAccountShowLongName = false;
        paramKeyMap.put("GL_012", companyId);
        String strAccountShowLongName = (String)iParamControl.getParamHashMap(paramKeyMap).get("GL_012");
        if (strAccountShowLongName != null && strAccountShowLongName.trim().length() > 0) {
            isAccountShowLongName = Boolean.valueOf(strAccountShowLongName.trim());
        }
        return isAccountShowLongName ? "jebAccountFrom.value.longName" : "jebAccountFrom.value.name";
    }

    private void mergeBolck(int columnIndex) {
        int n = this.tbl.getRowCount();
        int COL = columnIndex;
        ArrayList<int[]> mergeList = new ArrayList<int[]>();
        int span = 0;
        for (int i = 0; i < n; ++i) {
            if (this.tbl.getCell(i, COL).getValue() == null) {
                if (++span <= 0 || i != n - 1) continue;
                mergeList.add(new int[]{i - span, COL, i, COL});
                continue;
            }
            if (span > 0) {
                mergeList.add(new int[]{i - span - 1, COL, i - 1, COL});
            }
            span = 0;
        }
        if (mergeList.size() > 0) {
            KDTMergeManager mm = this.tbl.getMergeManager();
            for (int i = 0; i < mergeList.size(); ++i) {
                int[] region = (int[])mergeList.get(i);
                mm.mergeBlock(region[0], region[1], region[2], region[3]);
            }
        }
    }

    void cellClicked(int row, int column, int x, int y) {
        LabelValueBean lvb;
        if (this.tbl.getRowCount() == 0 || this.render == null || column != 3 || this.isDisplaySubsidiary) {
            return;
        }
        LabelValueBean labelValueBean = lvb = this.tbl.getCell(row, column).getValue() instanceof LabelValueBean ? (LabelValueBean)this.tbl.getCell(row, column).getValue() : null;
        if (lvb != null && !"1".equals(lvb.getValue())) {
            this.switchRowView(row);
        }
    }

    private int switchRowView(int row) {
        LabelValueBean lvb = (LabelValueBean)this.tbl.getCell(row, 3).getValue();
        Map mm = (Map)lvb.getProperty();
        boolean show = (Boolean)mm.get("expanded") == false;
        mm.put("expanded", show);
        int level = (Integer)mm.get("level");
        int from = this.doBlockRowShow(row, show, true);
        int i = from + 1;
        int located = from;
        boolean moved = false;
        int n = this.tbl.getRowCount();
        while (i < n) {
            LabelValueBean lvb2 = (LabelValueBean)this.tbl.getCell(i, 3).getValue();
            Map mm2 = (Map)lvb2.getProperty();
            int level2 = (Integer)mm2.get("level");
            if (level2 <= level) {
                located = moved ? i - 1 : i;
                break;
            }
            moved = true;
            i = show && level2 > level + 1 ? this.doBlockRowShow(i, false, false) : this.doBlockRowShow(i, show, false);
            located = i++;
        }
        return located;
    }

    private int doBlockRowShow(int row, boolean show, boolean onlyForLocate) {
        LabelValueBean lvb = (LabelValueBean)this.tbl.getCell(row, 3).getValue();
        int located = row;
        if (lvb != null) {
            if (!onlyForLocate) {
                Map mm = (Map)lvb.getProperty();
                if (show && "0".equals(lvb.getValue())) {
                    mm.put("expanded", Boolean.FALSE);
                } else {
                    mm.put("expanded", show);
                }
                this.tbl.getRow(row).getStyleAttributes().setHided(!show);
            }
            int i = row + 1;
            int n = this.tbl.getRowCount();
            while (i < n) {
                lvb = (LabelValueBean)this.tbl.getCell(i, 3).getValue();
                if (lvb == null) {
                    if (!onlyForLocate) {
                        this.tbl.getRow(i).getStyleAttributes().setHided(!show);
                    }
                } else {
                    located = i - 1;
                    break;
                }
                located = i++;
            }
        }
        return located;
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return RptAsstactXBalanceFactory.getRemoteInstance();
    }

    private void joinQueryAsstactList() throws Exception {
        if (!this.actionJoinQueryRptAsstactList.isEnabled() || this.tbl.getSelectManager().get() == null) {
            return;
        }
        try {
            this.setCursorOfWair();
            int selectedRow = this.tbl.getSelectManager().get().getTop();
            this.joinQueryAsstactList2(selectedRow);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private void joinQueryAsstactList2(int selectedRow) throws Exception {
        String accountid;
        RptParams pp = (RptParams)this.params.clone();
        IRow row = this.tbl.getRow(selectedRow);
        String string = accountid = row.getCell("FAccountID").getValue() == null ? null : this.tbl.getRow(selectedRow).getCell("FAccountID").getValue().toString();
        if (accountid == null || accountid.length() <= 1) {
            return;
        }
        GLRptAsstactGDCondition joinCondition = new GLRptAsstactGDCondition();
        GLRptUtils.transOldConditionToNewCondition(joinCondition, pp);
        AccountViewInfo av = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountid));
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit().clone();
        curCompany.setAccountTable(av.getAccountTableID());
        joinCondition.switchCompany(curCompany, true);
        joinCondition.setAccountViewStart(av);
        joinCondition.setAccountViewEnd(av);
        joinCondition.setAccountCodeStart(av.getNumber());
        joinCondition.setAccountCodeEnd(av.getNumber());
        joinCondition.setAccountLevelStart(1);
        joinCondition.setAccountLevelEnd(av.getLevel());
        AsstAccountInfo asstAccount = (AsstAccountInfo)this.params.getObjectElement("jebAcct.value");
        if (asstAccount != null) {
            joinCondition.setAsstAccountId(asstAccount.getId().toString());
        }
        List allAsstActList = null;
        allAsstActList = RptClientUtil.queryAsstAct(null, curCompany.getCU().getId().toString());
        ArrayList<AsstactTypeEntity> newAsstActList = new ArrayList<AsstactTypeEntity>();
        RptRowSet tblRs = (RptRowSet)this.params.getObject("rs");
        tblRs.reset();
        int itemIndex = 0;
        while (tblRs.next()) {
            if (!tblRs.getBoolean("FSelected", false)) continue;
            String actId = tblRs.getString("FID");
            int n = allAsstActList.size();
            for (int i = 0; i < n; ++i) {
                AsstactTypeEntity at = (AsstactTypeEntity)allAsstActList.get(i);
                if (!actId.equals(at.getId())) continue;
                at.setSelected(tblRs.getBoolean("FSelected", false));
                at.setFrom(tblRs.getObject("FFrom"));
                at.setTo(tblRs.getObject("FTo"));
                if (at.isSelected()) {
                    IRow levelRootRow = null;
                    String longNumber = null;
                    int distance = 0;
                    do {
                        if ((levelRootRow = this.tbl.getRow(selectedRow - distance++)).getCell("FLongNumber" + itemIndex) == null) continue;
                        longNumber = (String)levelRootRow.getCell("FLongNumber" + itemIndex).getValue();
                    } while (longNumber == null);
                    if (longNumber == null) continue;
                    int level = longNumber.length() - longNumber.replaceAll("\\!", "").length() + 1;
                    int baseIndex = itemIndex * 4;
                    at.setSelectedLevel(level);
                    DataBaseDInfo db = new DataBaseDInfo();
                    db.setString("number", (String)levelRootRow.getCell(baseIndex).getValue());
                    db.setString("longnumber", longNumber);
                    db.setString("id", (String)levelRootRow.getCell(baseIndex + 2).getValue());
                    db.setString("name", String.valueOf(levelRootRow.getCell(baseIndex + 3).getValue()));
                    at.setFrom(db);
                    at.setTo(db);
                    ++itemIndex;
                }
                newAsstActList.add(at);
            }
        }
        joinCondition.setAsstActList(newAsstActList);
        boolean isQtyAsst = (Boolean)this.params.getObjectElement("isQtyAsst");
        boolean isDisplayAmount = false;
        if (this.params.getObjectElement("jcbDisplayAmount.value") != null) {
            isDisplayAmount = (Boolean)this.params.getObjectElement("jcbDisplayAmount.value");
        }
        joinCondition.setShowQty(isDisplayAmount);
        boolean isDisplayAssSum = false;
        if (this.params.getObjectElement("jcbDisplayAssSum.value") != null) {
            isDisplayAssSum = (Boolean)this.params.getObjectElement("jcbDisplayAssSum.value");
        }
        joinCondition.setShowAsstItemTotal(isDisplayAssSum);
        if (this.params.getObjectElement("jcbincludeNoTransPLVoucher.value") != null) {
            boolean includeNoTransPLVoucher = (Boolean)this.params.getObjectElement("jcbincludeNoTransPLVoucher.value");
            joinCondition.setNotIncluePLVoucher(includeNoTransPLVoucher);
        }
        if (this.params.getObjectElement("jebMeasureUnit.value") != null) {
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.params.getObjectElement("jebMeasureUnit.value");
            joinCondition.setMeasureUnitId(measureUnitInfo.getId().toString());
        }
        this.joinQuryAsstactGD(joinCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinQuryAsstactGD(GLRptAsstactGDCondition cond) throws Exception {
        try {
            this.setCursorOfWair();
            String uiClassName = GLRptAsstactGDUI.class.getName();
            UIContext uiCtx = GLRptUtils.getLinkedContext(cond, (Object)this);
            IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)uiCtx, null);
            ui.show();
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected UIContext getLinkedContext(GLRptAsstactGDCondition cond) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        return uiContext;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(RptAsstactXBalanceUI.getResourceString((String)"print_label_period")).append("&[Period]").append("&|").append(RptAsstactXBalanceUI.getResourceString((String)"print_label_currency")).append("&[Currency]").append("&|").append(RptAsstactXBalanceUI.getResourceString((String)"print_label_company")).append("&[Company]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(RptAsstactXBalanceUI.getResourceString((String)"print_label_asstact")).append("&[Asstact]").append("&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Period", this.jtPeriod.getText());
        map.put("Currency", this.jtCurrency.getText());
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Asstact", this.jtAsstact.getText());
        if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
            map.put("Person", SysContext.getSysContext().getCurrentUserInfo().getName().toString());
        } else {
            map.put("Person", SysContext.getSysContext().getCurrentUserInfo().toString());
        }
        return map;
    }

    protected boolean isAllowLoadPrintSetting() {
        return true;
    }

    public void onLoad() throws Exception {
        if (GlUtils.isCompanyUnion(SysContext.getSysContext().getCurrentFIUnit())) {
            UIContext context = new UIContext(this.getUIContext().get("Owner"));
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptAsstactBalanceListUI.class.getName(), (Map)context).show();
            super.abort();
        }
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
        this.menuJoinQueryRptAsstactList.setIcon(EASResource.getIcon((String)"imgTbtn_assistantaccountdetail"));
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    public Object getTablePreferenceSchemaKey() {
        if (this.queryDialog.getCurrentSolutionInfo() != null) {
            return "_" + this.queryDialog.getCurrentSolutionInfo().getId();
        }
        return "";
    }

    @Override
    public void actionPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.editParame == null) {
            this.editParame = RptAsstactXBalanceParame.getInstance();
        }
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.RptAsstactXBalanceParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public class RptAsstactXBalanceTaoda
    implements BOSQueryDelegate {
        private String[] colNames = new String[]{"asstNumber1", "asstName1", "asstNumber2", "asstName2", "asstNumber3", "asstName3", "asstNumber4", "asstName4", "asstNumber5", "asstName5", "asstNumber6", "asstName6", "asstNumber7", "asstName7", "asstNumber8", "asstName8", "accountNumber", "accountName", "measureUnit", "beginQty", "beginBalanceDebitFor", "beginBalanceDebitLocal", "beginBalanceCreditFor", "beginBalanceCreditLocal", "debitQty", "debitFor", "debitLocal", "creditQty", "creditFor", "creditLocal", "yearDebitQty", "yearDebitFor", "yearDebitLocal", "yearCreditQty", "yearCreditFor", "yearCreditLocal", "endQty", "endBalanceDebitFor", "endBalanceDebitLocal", "endBalanceCreditFor", "endBalanceCreditLocal"};
        private String[] filedNames = new String[]{"fnumber0", "fname0", "fnumber1", "fname1", "fnumber2", "fname2", "fnumber3", "fname3", "fnumber4", "fname4", "fnumber5", "fname5", "fnumber6", "fname6", "fnumber7", "fname7", "FAccountNumber", "FAccountName", "muName", "FBeginQty", "FBeginBalanceDebitFor", "FBeginBalanceDebitLocal", "FBeginBalanceCreditFor", "FBeginBalanceCreditLocal", "FDebitQty", "FDebitFor", "FDebitLocal", "FCreditQty", "FCreditFor", "FCreditLocal", "FYearDebitQty", "FYearDebitFor", "FYearDebitLocal", "FYearCreditQty", "FYearCreditFor", "FYearCreditLocal", "FEndQty", "FEndBalanceDebitFor", "FEndBalanceDebitLocal", "FEndBalanceCreditFor", "FEndBalanceCreditLocal"};
        private String[] priceColNames = new String[]{"beginPrice", "debitPrice", "creditPrice", "yearDebitPrice", "yearCreditPrice", "endPrice"};
        private String[] asstactTypeNames = new String[]{"asstactType1", "asstactType2", "asstactType3", "asstactType4", "asstactType5", "asstactType6", "asstactType7", "asstactType8"};
        String[] colVal = new String[]{"sysDateTime", "currentUser", "asstactTypes", "company", "currency", "period"};
        String[] col = null;
        RptParams result = null;

        public RptAsstactXBalanceTaoda(RptParams result) {
            this.result = result;
            try {
                this.setCol(this.getColumnName());
            }
            catch (Exception ex) {
                RptAsstactXBalanceUI.this.handleException(ex);
            }
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            return this.getRowSet();
        }

        public IRowSet getRowSet() {
            SimpleDateFormat format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
            int colCount = this.col.length;
            DynamicRowSet drs = null;
            try {
                drs = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo ci = new ColInfo();
                    ci.colType = 12;
                    ci.columnName = this.col[i];
                    ci.nullable = 1;
                    drs.setColInfo(i + 1, ci);
                }
                drs.beforeFirst();
                boolean isBizCode = (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("rdBizAnalysisCode.value");
                int precision = (Integer)RptAsstactXBalanceUI.this.params.getObjectElement("jbxCurrency.value.precision");
                boolean displayAmount = (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("jcbDisplayAmount.value");
                boolean isDCSeparate = (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("jcbisDCSperate.value");
                CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
                HashMap sysParams = this.getInitParam(currCompany);
                int qtyScale = Integer.parseInt((String)sysParams.get("GL_002"));
                int priceScale = Integer.parseInt((String)sysParams.get("GL_003"));
                boolean sameAsAccount = Boolean.valueOf((String)sysParams.get("GL_005"));
                String[] asstactTypes = new String[8];
                if (isBizCode) {
                    asstactTypes[0] = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLXResource", (String)"bizcode_name");
                } else {
                    RptRowSet rs = (RptRowSet)RptAsstactXBalanceUI.this.params.getObject("rs");
                    rs.reset();
                    int k = 0;
                    while (rs.next() && k < 8) {
                        if (rs.getObject("FSelected") == null || !((Boolean)rs.getObject("FSelected")).booleanValue()) continue;
                        asstactTypes[k] = rs.getString("FName");
                        ++k;
                    }
                }
                RptRowSet prs = (RptRowSet)this.result.getObject("prs");
                prs.reset();
                while (prs.next()) {
                    int i;
                    boolean isLast;
                    boolean bl = isLast = prs.getRow() == prs.getRowCount() - 1;
                    if (RptAsstactXBalanceUI.this.isDisplaySubsidiary ? prs.getInt("FLevel") != 0 && prs.getInt("FIsLeaf") != 1 && !isLast : prs.getInt("FLevel") < RptAsstactXBalanceUI.this.selectedLevel && prs.getInt("FIsLeaf") != 1 && !isLast) continue;
                    drs.moveToInsertRow();
                    this.clearRow((IRowSet)drs);
                    drs.updateString("sysDateTime", GlUtils.formatDate(format, new Date()));
                    if (SysContext.getSysContext().getCurrentUserInfo().getName() != null) {
                        drs.updateString("currentUser", SysContext.getSysContext().getCurrentUserInfo().getName());
                    } else {
                        drs.updateString("currentUser", SysContext.getSysContext().getCurrentUserInfo().toString());
                    }
                    drs.updateString("asstactTypes", RptAsstactXBalanceUI.this.jtAsstact.getText());
                    drs.updateString("company", SysContext.getSysContext().getCurrentFIUnit().getName());
                    drs.updateString("currency", RptAsstactXBalanceUI.this.jtCurrency.getText());
                    drs.updateString("period", RptAsstactXBalanceUI.this.jtPeriod.getText());
                    for (i = 0; i < this.asstactTypeNames.length && asstactTypes[i] != null; ++i) {
                        drs.updateString(this.asstactTypeNames[i], asstactTypes[i]);
                    }
                    for (i = 0; i < this.colNames.length; ++i) {
                        try {
                            int scale = precision;
                            if (this.colNames[i].endsWith("Local")) {
                                scale = RptAsstactXBalanceUI.this.localScale;
                            } else if (this.colNames[i].endsWith("Qty")) {
                                scale = qtyScale;
                            }
                            Object value = prs.getObject(this.filedNames[i]);
                            if (sameAsAccount) {
                                if (value instanceof BigDecimal) {
                                    if (((BigDecimal)value).doubleValue() == 0.0) continue;
                                    drs.updateString(this.colNames[i], GlUtils.withComma((BigDecimal)value, scale));
                                    continue;
                                }
                                if (value == null) continue;
                                drs.updateString(this.colNames[i], value.toString());
                                continue;
                            }
                            if (this.colNames[i].startsWith("beginBalanceDebit") || this.colNames[i].startsWith("endBalanceDebit")) {
                                if (isDCSeparate) {
                                    if (((BigDecimal)value).doubleValue() == 0.0) continue;
                                    drs.updateString(this.colNames[i], GlUtils.withComma((BigDecimal)value, scale));
                                    continue;
                                }
                                BigDecimal value2 = prs.getBigDecimal(this.filedNames[i + 2]);
                                BigDecimal balance = ((BigDecimal)value).subtract(value2);
                                if (balance.doubleValue() > 0.0) {
                                    drs.updateString(this.colNames[i], GlUtils.withComma(balance.abs(), scale));
                                    continue;
                                }
                                if (!(balance.doubleValue() < 0.0)) continue;
                                drs.updateString(this.colNames[i + 2], GlUtils.withComma(balance.abs(), scale));
                                continue;
                            }
                            if (this.colNames[i].startsWith("beginBalanceCredit") || this.colNames[i].startsWith("endBalanceCredit")) {
                                if (!isDCSeparate || ((BigDecimal)value).doubleValue() == 0.0) continue;
                                drs.updateString(this.colNames[i], GlUtils.withComma((BigDecimal)value, scale));
                                continue;
                            }
                            if (value instanceof BigDecimal) {
                                if (((BigDecimal)value).doubleValue() == 0.0) continue;
                                drs.updateString(this.colNames[i], GlUtils.withComma((BigDecimal)value, scale));
                                continue;
                            }
                            if (value == null) continue;
                            drs.updateString(this.colNames[i], value.toString());
                            continue;
                        }
                        catch (Exception ex) {
                            if (!this.colNames[i].endsWith("Local")) continue;
                            if (this.colNames[i].startsWith("beginBalanceDebit") || this.colNames[i].startsWith("endBalanceDebit")) {
                                if (isDCSeparate) {
                                    drs.updateString(this.colNames[i], drs.getString(this.colNames[i - 1]));
                                    continue;
                                }
                                drs.updateString(this.colNames[i], drs.getString(this.colNames[i - 1]));
                                drs.updateString(this.colNames[i + 2], drs.getString(this.colNames[i + 1]));
                                continue;
                            }
                            if (this.colNames[i].startsWith("beginBalanceCredit") || this.colNames[i].startsWith("endBalanceCredit")) {
                                if (!isDCSeparate) continue;
                                drs.updateString(this.colNames[i], drs.getString(this.colNames[i - 1]));
                                continue;
                            }
                            drs.updateString(this.colNames[i], drs.getString(this.colNames[i - 1]));
                        }
                    }
                    if (displayAmount) {
                        try {
                            if (prs.getBigDecimal("FBeginQty") != null && prs.getBigDecimal("FBeginQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FBeginBalanceDebitFor").subtract(prs.getBigDecimal("FBeginBalanceCreditFor")).divide(prs.getBigDecimal("FBeginQty"), priceScale, 4);
                                drs.updateString("beginPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                            if (prs.getBigDecimal("FDebitQty") != null && prs.getBigDecimal("FDebitQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FDebitFor").divide(prs.getBigDecimal("FDebitQty"), priceScale, 4);
                                drs.updateString("debitPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                            if (prs.getBigDecimal("FCreditQty") != null && prs.getBigDecimal("FCreditQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FCreditFor").divide(prs.getBigDecimal("FCreditQty"), priceScale, 4);
                                drs.updateString("creditPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                            if (prs.getBigDecimal("FYearDebitQty") != null && prs.getBigDecimal("FYearDebitQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FYearDebitFor").divide(prs.getBigDecimal("FYearDebitQty"), priceScale, 4);
                                drs.updateString("yearDebitPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                            if (prs.getBigDecimal("FYearCreditQty") != null && prs.getBigDecimal("FYearCreditQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FYearCreditFor").divide(prs.getBigDecimal("FYearCreditQty"), priceScale, 4);
                                drs.updateString("yearCreditPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                            if (prs.getBigDecimal("FEndQty") != null && prs.getBigDecimal("FEndQty").doubleValue() != 0.0) {
                                BigDecimal beginPrice = prs.getBigDecimal("FEndBalanceDebitFor").subtract(prs.getBigDecimal("FEndBalanceCreditFor")).divide(prs.getBigDecimal("FEndQty"), priceScale, 4);
                                drs.updateString("endPrice", GlUtils.withComma(beginPrice, priceScale));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    drs.insertRow();
                }
                drs.beforeFirst();
            }
            catch (Exception e) {
                RptAsstactXBalanceUI.this.handUIException(e);
            }
            return drs;
        }

        protected void clearRow(IRowSet rs) throws Exception {
            int colCount = rs.getRowSetMetaData().getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                rs.updateString(i, null);
            }
        }

        private String[] getColumnName() throws Exception {
            return this.colNames;
        }

        private void setCol(String[] strColName) {
            int i;
            this.col = new String[strColName.length + this.priceColNames.length + this.asstactTypeNames.length + this.colVal.length];
            for (i = 0; i < strColName.length; ++i) {
                this.col[i] = strColName[i];
            }
            for (i = 0; i < this.priceColNames.length; ++i) {
                this.col[i + strColName.length] = this.priceColNames[i];
            }
            for (i = 0; i < this.asstactTypeNames.length; ++i) {
                this.col[i + strColName.length + this.priceColNames.length] = this.asstactTypeNames[i];
            }
            for (i = 0; i < this.colVal.length; ++i) {
                this.col[i + strColName.length + this.priceColNames.length + this.asstactTypeNames.length] = this.colVal[i];
            }
        }

        private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
            ObjectUuidPK comPK = new ObjectUuidPK(company.getId());
            HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
            hmNumAndOrgId.put("GL_002", comPK);
            hmNumAndOrgId.put("GL_003", comPK);
            hmNumAndOrgId.put("GL_005", comPK);
            hmNumAndOrgId.put("GL_008", comPK);
            return ParamControlFactory.getRemoteInstance().getParamHashMap(hmNumAndOrgId);
        }
    }

    class MyKDTableInsertHandler
    implements KDTableInsertHandler {
        private RptRowSet rs;
        private String fid1;
        private String fid2;
        private boolean sameAsAccount;
        private boolean isForeignCurrency;
        private int amountBeginIndex;
        private int amountEndIndex;
        private boolean isDebit;
        private boolean displayAmount;
        private boolean displayPrice;
        private Map colorCache = new HashMap();

        MyKDTableInsertHandler(RptRowSet rs, KDTable tbl, boolean sameAsAccount, boolean displayPrice, boolean isForeignCurrency, int amountBeginIndex) {
            this.rs = rs;
            this.sameAsAccount = sameAsAccount;
            this.amountBeginIndex = amountBeginIndex;
            this.isForeignCurrency = isForeignCurrency;
            this.displayPrice = displayPrice;
            this.displayAmount = (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("jcbDisplayAmount.value");
            this.amountEndIndex = this.displayAmount && displayPrice ? (isForeignCurrency ? amountBeginIndex + 10 + 12 : amountBeginIndex + 6 + 8) : (this.displayAmount ? (isForeignCurrency ? amountBeginIndex + 10 + 12 : amountBeginIndex + 6 + 8) : (isForeignCurrency ? amountBeginIndex + 16 : amountBeginIndex + 8));
        }

        private void setCellAmountValue(ICell cell, double value) {
            if (value == 0.0) {
                cell.setValue(null);
            } else {
                cell.setValue((Object)new Double(value));
            }
        }

        private void setCellPriceValue(ICell cell, double value) {
            if (value == 0.0) {
                cell.setValue(null);
            } else {
                cell.setValue((Object)new Double(value));
            }
        }

        private void setAmountValue(int i, IRow row, Object[] rowData, boolean isDCSeparate) {
            int diffColNum;
            int diffColAttr;
            int n = diffColAttr = this.isForeignCurrency ? 2 : 1;
            if (rowData[i] == null || rowData[i + diffColAttr] == null) {
                return;
            }
            if (this.isForeignCurrency && !(rowData[i + 1 + diffColAttr] instanceof BigDecimal)) {
                return;
            }
            BigDecimal d1 = new BigDecimal(String.valueOf(rowData[i]));
            BigDecimal d2 = new BigDecimal(String.valueOf(rowData[i + diffColAttr]));
            BigDecimal d3 = null;
            BigDecimal d4 = null;
            double valueLocal = 0.0;
            if (this.isForeignCurrency) {
                d3 = new BigDecimal(String.valueOf(rowData[i + 1]));
                d4 = new BigDecimal(String.valueOf(rowData[i + 1 + diffColAttr]));
                valueLocal = d3.doubleValue() - d4.doubleValue();
            }
            int n2 = diffColNum = this.isForeignCurrency ? 12 : 6;
            if (!(i != this.amountBeginIndex && i != this.amountBeginIndex + diffColNum || isDCSeparate)) {
                double value = d1.doubleValue() - d2.doubleValue();
                boolean tmp_isDebit = this.isDebit;
                if ("".equals(rowData[this.amountBeginIndex - 2].toString().trim())) {
                    boolean bl = tmp_isDebit = value > 0.0;
                    if (this.isForeignCurrency && value == 0.0) {
                        boolean bl2 = tmp_isDebit = valueLocal > 0.0;
                    }
                }
                if (this.sameAsAccount) {
                    if (tmp_isDebit) {
                        this.setCellAmountValue(row.getCell(i), value);
                        row.getCell(i + diffColAttr).setValue(null);
                        if (this.isForeignCurrency) {
                            this.setCellAmountValue(row.getCell(i + 1), valueLocal);
                            row.getCell(i + 1 + diffColAttr).setValue(null);
                        }
                    } else {
                        row.getCell(i).setValue(null);
                        this.setCellAmountValue(row.getCell(i + diffColAttr), -value);
                        if (this.isForeignCurrency) {
                            row.getCell(i + 1).setValue(null);
                            this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), -valueLocal);
                        }
                    }
                } else {
                    if (value == 0.0) {
                        row.getCell(i).setValue(null);
                        row.getCell(i + diffColAttr).setValue(null);
                    } else if (value < 0.0) {
                        row.getCell(i).setValue(null);
                        this.setCellAmountValue(row.getCell(i + diffColAttr), -value);
                    } else {
                        this.setCellAmountValue(row.getCell(i), value);
                        row.getCell(i + diffColAttr).setValue(null);
                    }
                    if (this.isForeignCurrency) {
                        if (valueLocal == 0.0) {
                            row.getCell(i + 1).setValue(null);
                            row.getCell(i + 1 + diffColAttr).setValue(null);
                        } else if (valueLocal < 0.0) {
                            row.getCell(i + 1).setValue(null);
                            this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), -valueLocal);
                        } else {
                            this.setCellAmountValue(row.getCell(i + 1), valueLocal);
                            row.getCell(i + 1 + diffColAttr).setValue(null);
                        }
                    }
                }
            } else {
                this.setCellAmountValue(row.getCell(i), d1.doubleValue());
                this.setCellAmountValue(row.getCell(i + diffColAttr), d2.doubleValue());
                if (this.isForeignCurrency) {
                    this.setCellAmountValue(row.getCell(i + 1), d3.doubleValue());
                    this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), d4.doubleValue());
                }
            }
        }

        private void setAmountQtyValue(int i, IRow row, Object[] rowData, boolean isDCSeparate) {
            int diffColNum;
            int diffColAttr;
            int n = diffColAttr = this.isForeignCurrency ? 2 : 1;
            if (rowData[i] == null || rowData[i].toString().trim().length() == 0) {
                return;
            }
            if (i + 2 + diffColAttr > rowData.length - 1 || this.isForeignCurrency && !(rowData[i + 2 + diffColAttr] instanceof BigDecimal)) {
                return;
            }
            BigDecimal d1 = new BigDecimal(String.valueOf(rowData[i]));
            BigDecimal d2 = new BigDecimal(String.valueOf(rowData[i + 1]));
            BigDecimal d3 = new BigDecimal(String.valueOf(rowData[i + 1 + diffColAttr]));
            BigDecimal d4 = null;
            BigDecimal d5 = null;
            double valueLocal = 0.0;
            if (this.isForeignCurrency) {
                d4 = new BigDecimal(String.valueOf(rowData[i + 2]));
                d5 = new BigDecimal(String.valueOf(rowData[i + 2 + diffColAttr]));
                valueLocal = d4.doubleValue() - d5.doubleValue();
            }
            int n2 = diffColNum = this.isForeignCurrency ? 17 : 11;
            if (!(i != this.amountBeginIndex && i != this.amountBeginIndex + diffColNum || isDCSeparate)) {
                double value = d2.doubleValue() - d3.doubleValue();
                boolean tmp_isDebit = this.isDebit;
                if ("".equals(rowData[this.amountBeginIndex - 4].toString().trim())) {
                    boolean bl = tmp_isDebit = value > 0.0;
                    if (this.isForeignCurrency && value == 0.0) {
                        tmp_isDebit = valueLocal > 0.0;
                    }
                }
                this.setCellAmountValue(row.getCell(i), d1.doubleValue());
                if (this.sameAsAccount) {
                    if (tmp_isDebit) {
                        this.setCellAmountValue(row.getCell(i + 1), value);
                        row.getCell(i + 1 + diffColAttr).setValue(null);
                    } else {
                        row.getCell(i + 1).setValue(null);
                        this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), -value);
                    }
                    if (this.isForeignCurrency) {
                        if (tmp_isDebit) {
                            this.setCellAmountValue(row.getCell(i + 2), valueLocal);
                            row.getCell(i + 2 + diffColAttr).setValue(null);
                        } else {
                            row.getCell(i + 2).setValue(null);
                            this.setCellAmountValue(row.getCell(i + 2 + diffColAttr), -valueLocal);
                        }
                    }
                } else {
                    if (value == 0.0) {
                        row.getCell(i + 1).setValue(null);
                        row.getCell(i + 1 + diffColAttr).setValue(null);
                    } else if (value < 0.0) {
                        row.getCell(i + 1).setValue(null);
                        this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), -value);
                    } else {
                        this.setCellAmountValue(row.getCell(i + 1), value);
                        row.getCell(i + 1 + diffColAttr).setValue(null);
                    }
                    if (this.isForeignCurrency) {
                        if (valueLocal == 0.0) {
                            row.getCell(i + 2).setValue(null);
                            row.getCell(i + 2 + diffColAttr).setValue(null);
                        }
                        if (valueLocal < 0.0) {
                            row.getCell(i + 2).setValue(null);
                            this.setCellAmountValue(row.getCell(i + 2 + diffColAttr), -valueLocal);
                        } else {
                            this.setCellAmountValue(row.getCell(i + 2), valueLocal);
                            row.getCell(i + 2 + diffColAttr).setValue(null);
                        }
                    }
                }
            } else {
                this.setCellAmountValue(row.getCell(i), d1.doubleValue());
                this.setCellAmountValue(row.getCell(i + 1), d2.doubleValue());
                this.setCellAmountValue(row.getCell(i + 1 + diffColAttr), d3.doubleValue());
                if (this.isForeignCurrency) {
                    this.setCellAmountValue(row.getCell(i + 2), d4.doubleValue());
                    this.setCellAmountValue(row.getCell(i + 2 + diffColAttr), d5.doubleValue());
                }
            }
        }

        private void setAmountPriceValue(int i, IRow row, Object[] rowData, boolean isDCSeparate) {
            int diffColNum;
            int diffColAttr;
            int j = i;
            if (this.isForeignCurrency) {
                if (i == this.amountBeginIndex + 5) {
                    j = this.amountBeginIndex + 5 + 1;
                } else if (i == this.amountBeginIndex + 5 + 3) {
                    j = this.amountBeginIndex + 5 + 3 + 2;
                } else if (i == this.amountBeginIndex + 5 + 3 + 3) {
                    j = this.amountBeginIndex + 5 + 3 + 3 + 3;
                } else if (i == this.amountBeginIndex + 5 + 3 + 3 + 3) {
                    j = this.amountBeginIndex + 5 + 3 + 3 + 3 + 4;
                } else if (i == this.amountBeginIndex + 5 + 3 + 3 + 3 + 3) {
                    j = this.amountBeginIndex + 5 + 3 + 3 + 3 + 3 + 5;
                } else if (i == this.amountBeginIndex + 5 + 3 + 3 + 3 + 3 + 3) {
                    j = this.amountBeginIndex + 5 + 3 + 3 + 3 + 3 + 3 + 6;
                }
            } else if (i == this.amountBeginIndex + 3) {
                j = this.amountBeginIndex + 3 + 1;
            } else if (i == this.amountBeginIndex + 3 + 2) {
                j = this.amountBeginIndex + 3 + 2 + 2;
            } else if (i == this.amountBeginIndex + 3 + 2 + 2) {
                j = this.amountBeginIndex + 3 + 2 + 2 + 3;
            } else if (i == this.amountBeginIndex + 3 + 2 + 2 + 2) {
                j = this.amountBeginIndex + 3 + 2 + 2 + 2 + 4;
            } else if (i == this.amountBeginIndex + 3 + 2 + 2 + 2 + 2) {
                j = this.amountBeginIndex + 3 + 2 + 2 + 2 + 2 + 5;
            } else if (i == this.amountBeginIndex + 3 + 2 + 2 + 2 + 2 + 2) {
                j = this.amountBeginIndex + 3 + 2 + 2 + 2 + 2 + 2 + 6;
            }
            int n = diffColAttr = this.isForeignCurrency ? 2 : 1;
            if (rowData[i] == null || rowData[i].toString().trim().length() == 0) {
                return;
            }
            if (!(rowData[i + 1 + diffColAttr] instanceof BigDecimal)) {
                return;
            }
            if (i + 2 + diffColAttr > rowData.length - 1 || this.isForeignCurrency && !(rowData[i + 2 + diffColAttr] instanceof BigDecimal)) {
                return;
            }
            BigDecimal d1 = new BigDecimal(String.valueOf(rowData[i]));
            BigDecimal d2 = new BigDecimal(String.valueOf(rowData[i + 1]));
            BigDecimal d3 = new BigDecimal(String.valueOf(rowData[i + 1 + diffColAttr]));
            BigDecimal d4 = null;
            BigDecimal d5 = null;
            double valueLocal = 0.0;
            if (this.isForeignCurrency) {
                d4 = new BigDecimal(String.valueOf(rowData[i + 2]));
                d5 = new BigDecimal(String.valueOf(rowData[i + 2 + diffColAttr]));
                valueLocal = d4.doubleValue() - d5.doubleValue();
            }
            int n2 = diffColNum = this.isForeignCurrency ? 17 : 11;
            if (!(i != this.amountBeginIndex && i != this.amountBeginIndex + diffColNum || isDCSeparate)) {
                double value = d2.doubleValue() - d3.doubleValue();
                double priceValue = d1.doubleValue() == 0.0 ? 0.0 : value / d1.doubleValue();
                boolean tmp_isDebit = this.isDebit;
                if ("".equals(rowData[this.amountBeginIndex - 4].toString().trim())) {
                    boolean bl = tmp_isDebit = value > 0.0;
                    if (this.isForeignCurrency && value == 0.0) {
                        tmp_isDebit = valueLocal > 0.0;
                    }
                }
                this.setCellAmountValue(row.getCell(j), d1.doubleValue());
                this.setCellPriceValue(row.getCell(j + 1), Math.abs(priceValue));
                if (this.sameAsAccount) {
                    if (tmp_isDebit) {
                        this.setCellAmountValue(row.getCell(j + 2), value);
                        row.getCell(j + 2 + diffColAttr).setValue(null);
                    } else {
                        row.getCell(j + 2).setValue(null);
                        this.setCellAmountValue(row.getCell(j + 2 + diffColAttr), -value);
                    }
                    if (this.isForeignCurrency) {
                        if (tmp_isDebit) {
                            this.setCellAmountValue(row.getCell(j + 3), valueLocal);
                            row.getCell(j + 3 + diffColAttr).setValue(null);
                        } else {
                            row.getCell(j + 3).setValue(null);
                            this.setCellAmountValue(row.getCell(j + 3 + diffColAttr), -valueLocal);
                        }
                    }
                } else {
                    if (value == 0.0) {
                        row.getCell(j + 2).setValue(null);
                        row.getCell(j + 2 + diffColAttr).setValue(null);
                    } else if (value < 0.0) {
                        row.getCell(j + 2).setValue(null);
                        this.setCellAmountValue(row.getCell(j + 2 + diffColAttr), -value);
                    } else {
                        this.setCellAmountValue(row.getCell(j + 2), value);
                        row.getCell(j + 2 + diffColAttr).setValue(null);
                    }
                    if (this.isForeignCurrency) {
                        if (valueLocal == 0.0) {
                            row.getCell(j + 3).setValue(null);
                            row.getCell(j + 3 + diffColAttr).setValue(null);
                        } else if (valueLocal < 0.0) {
                            row.getCell(j + 3).setValue(null);
                            this.setCellAmountValue(row.getCell(j + 3 + diffColAttr), -valueLocal);
                        } else {
                            this.setCellAmountValue(row.getCell(j + 3), valueLocal);
                            row.getCell(j + 3 + diffColAttr).setValue(null);
                        }
                    }
                }
            } else {
                double priceValue = d1.doubleValue() == 0.0 ? 0.0 : (d2.doubleValue() != 0.0 ? d2.doubleValue() / d1.doubleValue() : d3.doubleValue() / d1.doubleValue());
                this.setCellAmountValue(row.getCell(j), d1.doubleValue());
                this.setCellAmountValue(row.getCell(j + 1), Math.abs(priceValue));
                this.setCellAmountValue(row.getCell(j + 2), d2.doubleValue());
                this.setCellAmountValue(row.getCell(j + 2 + diffColAttr), d3.doubleValue());
                if (this.isForeignCurrency) {
                    this.setCellAmountValue(row.getCell(j + 3), d4.doubleValue());
                    this.setCellAmountValue(row.getCell(j + 3 + diffColAttr), d5.doubleValue());
                }
            }
        }

        public void setTableRowData(IRow row, Object[] rowData) {
            boolean isDCSeparate = (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("jcbisDCSperate.value");
            this.fid1 = (String)rowData[2];
            if (rowData[this.amountBeginIndex - 1] != null) {
                this.isDebit = this.displayAmount && (Boolean)RptAsstactXBalanceUI.this.params.getObjectElement("isQtyAsst") != false ? "1".equals(rowData[this.amountBeginIndex - 3].toString()) : "1".equals(rowData[this.amountBeginIndex - 1].toString());
            }
            row.setUserObject((Object)Boolean.TRUE);
            int n = rowData.length;
            if (this.fid1.equals(this.fid2)) {
                int i;
                int n2 = i = RptAsstactXBalanceUI.this.isBizCode ? 3 : 4;
                while (i < n) {
                    if (i >= this.amountBeginIndex && i < this.amountEndIndex) {
                        if (this.displayAmount && this.displayPrice) {
                            this.setAmountPriceValue(i, row, rowData, isDCSeparate);
                            i = this.isForeignCurrency ? (i == this.amountBeginIndex || i == this.amountEndIndex - 5 ? (i += 4) : (i += 2)) : (i == this.amountBeginIndex || i == this.amountEndIndex - 3 ? (i += 2) : ++i);
                        } else if (this.displayAmount) {
                            this.setAmountQtyValue(i, row, rowData, isDCSeparate);
                            if (i == this.amountBeginIndex || i == this.amountBeginIndex + 11) {
                                ++i;
                            }
                        } else {
                            this.setAmountValue(i, row, rowData, isDCSeparate);
                        }
                        if (!this.displayAmount || !this.displayPrice) {
                            i = this.isForeignCurrency && i + 3 <= this.amountEndIndex ? (i += 3) : ++i;
                        }
                    } else if (this.displayAmount && this.displayPrice) {
                        int j = i;
                        if (i > this.amountBeginIndex) {
                            j = i + 6;
                        }
                        row.getCell(j).setValue(rowData[i]);
                    } else {
                        row.getCell(i).setValue(rowData[i]);
                    }
                    ++i;
                }
            } else {
                this.fid2 = this.fid1;
                for (int i = 0; i < n; ++i) {
                    if (i == 3 && !RptAsstactXBalanceUI.this.isBizCode) {
                        String name = (String)rowData[i];
                        LabelValueBean lvb = new LabelValueBean(this.rs.getInt("FIsLeaf") == 1 ? "1" : "0", name == null ? null : name);
                        HashMap<String, Comparable<Boolean>> mm = new HashMap<String, Comparable<Boolean>>();
                        mm.put("expanded", Boolean.TRUE);
                        mm.put("level", new Integer(this.rs.getObject("FLevel") == null ? 0 : (RptAsstactXBalanceUI.this.selectedLevel > 1 ? this.rs.getInt("FLevel") - RptAsstactXBalanceUI.this.selectedLevel + 1 : this.rs.getInt("FLevel"))));
                        lvb.setProperty(mm);
                        if (!RptAsstactXBalanceUI.this.isDisplaySubsidiary) {
                            row.getCell(i).setValue((Object)lvb);
                            continue;
                        }
                        row.getCell(i).setValue((Object)name);
                        continue;
                    }
                    if (i >= this.amountBeginIndex && i < this.amountEndIndex) {
                        if (this.displayAmount && this.displayPrice) {
                            this.setAmountPriceValue(i, row, rowData, isDCSeparate);
                            i = this.isForeignCurrency ? (i == this.amountBeginIndex || i == this.amountEndIndex - 5 ? (i += 4) : (i += 2)) : (i == this.amountBeginIndex || i == this.amountEndIndex - 3 ? (i += 2) : ++i);
                        } else if (this.displayAmount) {
                            this.setAmountQtyValue(i, row, rowData, isDCSeparate);
                            if (i == this.amountBeginIndex || i == this.amountBeginIndex + 11) {
                                ++i;
                            }
                        } else {
                            this.setAmountValue(i, row, rowData, isDCSeparate);
                        }
                        if (this.displayAmount && this.displayPrice) continue;
                        if (this.isForeignCurrency && i + 3 <= this.amountEndIndex) {
                            i += 3;
                            continue;
                        }
                        ++i;
                        continue;
                    }
                    if (this.displayAmount && this.displayPrice) {
                        int j = i;
                        if (i > this.amountBeginIndex) {
                            j = i + 6;
                        }
                        row.getCell(j).setValue(rowData[i]);
                        continue;
                    }
                    row.getCell(i).setValue(rowData[i]);
                }
            }
            if (!RptAsstactXBalanceUI.this.isDisplaySubsidiary) {
                row.getStyleAttributes().setBackground(this.getRowColor(this.rs.getObject("FLevel") == null ? 0 : (RptAsstactXBalanceUI.this.selectedLevel > 1 ? this.rs.getInt("FLevel") - RptAsstactXBalanceUI.this.selectedLevel + 1 : this.rs.getInt("FLevel"))));
            }
        }

        private Color getRowColor(int level) {
            if (level <= 1) {
                return null;
            }
            Color c = (Color)this.colorCache.get(String.valueOf(level));
            if (c == null) {
                c = new Color(0xFAFAF1 - 15 * --level);
                this.colorCache.put(String.valueOf(level + 1), c);
            }
            return c;
        }
    }

    class MyTreeNodeRender
    extends TreeNodeRender {
        MyTreeNodeRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj == null) {
                return;
            }
            if (obj instanceof LabelValueBean) {
                LabelValueBean lvb = (LabelValueBean)obj;
                Map mm = (Map)lvb.getProperty();
                int level = (Integer)mm.get("level");
                Rectangle r = clip.getBounds();
                int x = r.x + (level > 0 ? level - 1 : 0) * 20;
                int y = r.y + (r.height - this.ICONSIZE) / 2;
                if (level > 0) {
                    r.x = x + this.ICONSIZE + this.margin * 2;
                }
                this.simpleRender.draw(graphics, (Shape)r, lvb.getLabel(), style);
                if (level > 0 && !"1".equals(lvb.getValue())) {
                    if (((Boolean)mm.get("expanded")).booleanValue()) {
                        this.drawExpanded(graphics, x, y);
                    } else {
                        this.drawCollapsed(graphics, x, y);
                    }
                }
            } else {
                this.simpleRender.draw(graphics, clip, String.valueOf(obj), style);
            }
        }
    }
}

