/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.RptVoucherGeneralFactory;
import com.kingdee.eas.fi.gl.client.AbstractRptVoucherGeneralListUI;
import com.kingdee.eas.fi.gl.client.RptBaseConditionUI;
import com.kingdee.eas.fi.gl.client.RptVoucherGeneralConditionUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.RptConstant;
import com.kingdee.eas.fi.gl.common.RptUIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.KeyStroke;

public class RptVoucherGeneralListUI
extends AbstractRptVoucherGeneralListUI {
    protected RptVoucherGeneralConditionUI queryPanel = new RptVoucherGeneralConditionUI();
    private int[] numberColumns = null;

    public RptVoucherGeneralListUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.tbl.checkParsed();
        this.tbl.getViewManager().setFreezeView(0, 3);
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public IRptBase getInitRemoteInstance() throws BOSException {
        return RptVoucherGeneralFactory.getRemoteInstance();
    }

    @Override
    public RptBaseConditionUI getQueryDialogUserPanel() {
        return this.queryPanel;
    }

    @Override
    public void query(Object condition) {
        if (condition == null) {
            condition = this.queryPanel.getCustomCondition();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptUIContext ctx = this.getUIReportContext();
        this.pp = (RptParams)condition;
        int yearEnd = ((Date)this.pp.getObject("dateTo")).getYear() + 1900;
        int numberEnd = ((Date)this.pp.getObject("dateTo")).getMonth() + 1;
        this.getUIContext().put("company", RptClientUtil.getCompany(yearEnd, numberEnd));
        ctx.setObject("company", RptClientUtil.getCompany(yearEnd, numberEnd));
        this.pp.setObject("company", (Object)ctx.getCompany());
        boolean queryByPeriod = this.pp.getBoolean("queryByPeriod");
        this.LabelkdlPeriod.setText(queryByPeriod ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"24_RptVoucherGeneralListUI") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"25_RptVoucherGeneralListUI"));
        if (queryByPeriod) {
            int beginYear = this.pp.getInt("beginYear");
            int beginPeriod = this.pp.getInt("beginPeriod");
            int endYear = this.pp.getInt("endYear");
            int endPeriod = this.pp.getInt("endPeriod");
            String txtPeriod = this.getPeriodTitle(beginYear, beginPeriod, endYear, endPeriod);
            this.kdlPeriod.setText(txtPeriod);
        } else {
            String dt2;
            String dt1 = sdf.format((Date)this.pp.getObject("dateFrom"));
            if (dt1.equals(dt2 = sdf.format((Date)this.pp.getObject("dateTo")))) {
                this.kdlPeriod.setText(dt1);
            } else {
                this.kdlPeriod.setText(dt1 + GLResUtil.getRes("to") + dt2);
            }
        }
        this.kdlCurrency.setText(((CurrencyInfo)this.pp.getObject("currency")).getName());
        StringBuffer sb = new StringBuffer();
        Boolean vouchertype = (Boolean)this.pp.getObject("includeAll");
        if (vouchertype.booleanValue()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"26_RptVoucherGeneralListUI"));
        } else {
            int objLen = ((Object[])this.pp.getObject("tblData")).length;
            Object[][] tblData = new Object[objLen][4];
            if (!((Object[])this.pp.getObject("tblData") instanceof Object[][]) && (Object[])this.pp.getObject("tblData") instanceof Object[]) {
                for (int i = 0; i < objLen; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        tblData[i][j] = ((Object[])((Object[])this.pp.getObject("tblData"))[i])[j];
                    }
                }
            } else {
                tblData = (Object[][])this.pp.getObject("tblData");
            }
            for (int i = 0; i < tblData.length; ++i) {
                if (!((Boolean)tblData[i][0]).booleanValue()) continue;
                sb.append(tblData[i][1]);
                if (tblData[i][2] != null || tblData[i][3] != null) {
                    if (tblData[i][2] != null && tblData[i][2].equals(tblData[i][3])) {
                        sb.append("(").append(tblData[i][2]).append(")");
                    } else {
                        sb.append("(").append(tblData[i][2] == null ? " " : tblData[i][2]).append("--").append(tblData[i][3] == null ? " " : tblData[i][3]).append(")");
                    }
                }
                sb.append(", ");
            }
        }
        String str = sb.toString();
        if (str.endsWith(", ")) {
            str = str.substring(0, str.length() - 2);
        }
        this.kdlVoucherNo.setText(str);
        this.kdlVoucherNo.setToolTipText(str);
        super.doLayout();
        this.tbl.removeColumns();
        this.tbl.removeRows();
        this.tHelper.init();
        this.checkTableCommonMenu(this.tbl);
    }

    private String getResx(String resxItemName) {
        Locale locale = this.getCurrentLocale();
        String resxName = "com.kingdee.eas.fi.gl.ReportPeriodExtraRes";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            RptRowSet rst;
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            this.pp.setInt("from", from);
            this.pp.setInt("length", length);
            if (from == 0) {
                rst = RptVoucherGeneralFactory.getRemoteInstance().createVoucherGeneralTempTable(this.pp);
                String tableName = (String)rst.getProperty("tableName");
                this.pp.setString("tableName", tableName);
                this.setTempTableName(tableName);
            }
            rst = RptVoucherGeneralFactory.getRemoteInstance().queryVoucherGeneral(this.pp.getString("tableName"), from, length);
            if (from == 0) {
                this.tbl.setRowCount(rst.getVirtualRowCount());
                KDTableUtil.setHeader((KDTableHeaderModel)((KDTableHeaderModel)rst.getProperty("header")), (KDTable)this.tbl);
                String[] currencyFormat = new String[3];
                CompanyOrgUnitInfo cc = this.getUIReportContext().getCompany();
                CurrencyInfo selectCur = (CurrencyInfo)this.pp.getObject("currency");
                if (selectCur != null) {
                    if (selectCur.isGeneralLocalCurrency()) {
                        selectCur = cc.getBaseCurrency();
                    } else if (selectCur.isGeneralReportCurrency()) {
                        selectCur = cc.getReportCurrency();
                    }
                }
                currencyFormat[0] = RptClientUtil.getDecimalFormat(selectCur.getPrecision());
                currencyFormat[1] = RptClientUtil.getDecimalFormat(cc.getBaseCurrency().getPrecision());
                if (cc.getReportCurrency() != null) {
                    currencyFormat[2] = RptClientUtil.getDecimalFormat(cc.getReportCurrency().getPrecision());
                }
                if ("1".equals(rst.getProperty("numberColumnType"))) {
                    this.numberColumns = (int[])rst.getProperty("numberColumns");
                    KDTableUtil.setNumberFormat((int[])((int[])rst.getProperty("numberColumns1")), (String)currencyFormat[0], (KDTable)this.tbl);
                    KDTableUtil.setNumberFormat((int[])((int[])rst.getProperty("numberColumns2")), (String)currencyFormat[1], (KDTable)this.tbl);
                    if (cc.getReportCurrency() != null) {
                        KDTableUtil.setNumberFormat((int[])((int[])rst.getProperty("numberColumns3")), (String)currencyFormat[2], (KDTable)this.tbl);
                    }
                } else {
                    this.numberColumns = (int[])rst.getProperty("numberColumns");
                    KDTableUtil.setNumberFormat((int[])this.numberColumns, (String)currencyFormat[0], (KDTable)this.tbl);
                }
                this.kdlAppendCount.setText((String)rst.getProperty("FAttachments"));
                this.kdlVoucherCount.setText((String)rst.getProperty("voucherCount"));
            }
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tbl);
            if (rst.getRowCount() > 0) {
                int countRowIndex = from + rst.getRowCount() - 1;
                rst.moveTo(rst.getRowCount() - 1);
                int recordType = rst.getInt("no");
                if (recordType == 2) {
                    IRow row = this.tbl.getRow(countRowIndex);
                    row.getStyleAttributes().setBackground(RptConstant.ROW_COLOR_TOTAL);
                    this.tbl.getMergeManager().mergeBlock(countRowIndex, 1, countRowIndex, 2, 4);
                    row.getCell(0).setValue((Object)rst.getString("FNUMBER"));
                    row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                }
                int rows = from + rst.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < this.numberColumns.length; ++j) {
                        Object cv = this.tbl.getCell(i, this.numberColumns[j]).getValue();
                        this.tbl.getCell(i, this.numberColumns[j]).setValue(KDTableUtil.zeroToEmpty((Object)cv));
                    }
                }
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (ReportBizException ex) {
            ExceptionHandler.handle((Throwable)((Object)ex));
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
            this.close();
        }
        finally {
            this.setCursorOfDefault();
        }
        this.getTableForCommon().getColumn(0).getStyleAttributes().setNumberFormat("@");
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query(this.pp);
    }

    @Override
    public KDTable getPrintTable() {
        return this.tbl;
    }

    @Override
    public Variant getPrintVariant(String varName) {
        return null;
    }

    @Override
    protected int appendHeadRow(HeadFootModel header) {
        int rowheight = 35;
        int appendHeight = 70;
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kDLabel1.getText());
        sb.append("&[VoucherNo]");
        sb.append("&|");
        sb.append(this.kDLabel3.getText());
        sb.append("&[VoucherCount]");
        sb.append("&|");
        sb.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sb.append("&[CompanyName]");
        header.addRow(sb.toString(), sa);
        sb.setLength(0);
        sb.append(this.LabelkdlPeriod.getText());
        sb.append("&[Period]");
        sb.append("&|");
        sb.append(this.LabelkdlCurrency.getText());
        sb.append("&[Currency]");
        sb.append("&|");
        sb.append(this.LabelkdlAppendCount.getText());
        sb.append("&[AppendCount]");
        header.addRow(sb.toString(), sa);
        header.addRow("&| ", sa);
        return appendHeight;
    }

    @Override
    protected Variant requestPrintVariant(String varName) {
        String varValue = null;
        if (varName.equals("CompanyName")) {
            varValue = this.getUIReportContext().getCompany().getName();
        } else if (varName.equals("User")) {
            varValue = SysContext.getSysContext().getUserName();
        } else if (varName.equals("VoucherNo")) {
            varValue = this.kdlVoucherNo.getText();
        } else if (varName.equals("VoucherCount")) {
            varValue = this.kdlVoucherCount.getText();
        } else if (varName.equals("Period")) {
            varValue = this.kdlPeriod.getText();
        } else if (varName.equals("Currency")) {
            varValue = this.kdlCurrency.getText();
        } else if (varName.equals("AppendCount")) {
            varValue = this.kdlAppendCount.getText();
        }
        if (varValue != null) {
            Variant v = new Variant();
            v.setObject((Object)varValue);
            return v;
        }
        return this.getPrintVariant(varName);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemHelp.setIcon(EASResource.getIcon((String)"imgTbtn_help"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    protected KDTable getTableForCommon() {
        return this.tbl;
    }
}

