/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.client.AbstractSearchUI;
import com.kingdee.eas.fi.gl.client.SearchListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SearchUI
extends AbstractSearchUI {
    private static final Logger logger = CoreUIObject.getLogger(SearchUI.class);
    private List<KDCheckBox> cbTargets = new ArrayList<KDCheckBox>();
    private Map params = null;
    private SearchListener listener;
    private boolean showCaseSensitive = false;
    private boolean showWrapSearch = false;
    private boolean showGlobalSearch = false;
    private boolean showRemoteSearch = false;
    private Box boxTarget = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() {
        Map uiContext = this.getUIContext();
        HashMap params = (HashMap)uiContext.get("params");
        if (params == null) {
            params = new HashMap();
        }
        this.params = params;
        this.cbTargets.clear();
        this.pnContent.removeAll();
        List targets = (List)params.get("targets");
        if (targets != null && targets.size() > 0) {
            KDPanel pnTarget = new KDPanel();
            pnTarget.setLayout((LayoutManager)new BorderLayout());
            this.pnContent.add((Component)pnTarget, (Object)new KDLayout.Constraints(1, 4, 200, 244, 263));
            this.lbTarget.setBorder(BorderFactory.createEmptyBorder(1, 1, 5, 1));
            pnTarget.add((Component)this.lbTarget, (Object)"North");
            this.boxTarget = Box.createVerticalBox();
            this.boxTarget.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.boxTarget.setAlignmentX(0.0f);
            KDScrollPane scrollPane = new KDScrollPane((Component)this.boxTarget);
            scrollPane.getVerticalScrollBar().setUnitIncrement(10);
            scrollPane.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
            pnTarget.add((Component)scrollPane, (Object)"Center");
            for (Map target : targets) {
                String name = (String)target.get("name");
                String title = (String)target.get("title");
                if (title == null || title.length() == 0) continue;
                boolean selected = "true".equalsIgnoreCase((String)target.get("selected"));
                KDCheckBox cbTarget = new KDCheckBox(title);
                if (name != null && name.trim().length() > 0) {
                    cbTarget.setName(name.trim());
                    cbTarget.setToolTipText(title + "[" + name.trim() + "]");
                }
                cbTarget.setSelected(selected);
                this.cbTargets.add(cbTarget);
                this.boxTarget.add((Component)cbTarget);
            }
        } else {
            this.setPreferredSize(new Dimension(530, 220));
        }
        KDPanel pnWord = new KDPanel();
        pnWord.setLayout((LayoutManager)new BorderLayout());
        if (this.cbTargets.size() > 0) {
            this.pnContent.add((Component)pnWord, (Object)new KDLayout.Constraints(210, 4, 308, 244, 139));
        } else {
            this.pnContent.add((Component)pnWord, (Object)new KDLayout.Constraints(1, 4, 514, 244, 139));
        }
        this.lbWord.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        pnWord.add((Component)this.lbWord, (Object)"North");
        Box boxWord = Box.createVerticalBox();
        boxWord.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        boxWord.setAlignmentX(0.0f);
        pnWord.add((Component)boxWord, (Object)"Center");
        this.txtWord.setPreferredSize(new Dimension(100, 22));
        this.txtWord.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        boxWord.add((Component)this.txtWord);
        boxWord.add(Box.createVerticalStrut(8));
        String word = (String)params.get("word");
        if (word == null) {
            word = "";
        }
        this.txtWord.setText(word);
        Box boxMistiness = Box.createHorizontalBox();
        boxMistiness.setPreferredSize(new Dimension(100, 22));
        boxMistiness.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        boxMistiness.add((Component)this.cbMistiness);
        boxWord.add(boxMistiness);
        boxWord.add(Box.createVerticalStrut(8));
        boolean mistiness = true;
        if ("false".equalsIgnoreCase((String)params.get("mistiness"))) {
            mistiness = false;
        }
        this.cbMistiness.setSelected(mistiness);
        this.showCaseSensitive = "true".equalsIgnoreCase((String)params.get("showCaseSensitive"));
        if (this.showCaseSensitive) {
            Box boxCaseSensitive = Box.createHorizontalBox();
            boxCaseSensitive.setPreferredSize(new Dimension(100, 22));
            boxCaseSensitive.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
            boxCaseSensitive.add((Component)this.cbCaseSensitive);
            boxWord.add(boxCaseSensitive);
            boxWord.add(Box.createVerticalStrut(8));
            boolean caseSensitive = false;
            if ("true".equalsIgnoreCase((String)params.get("caseSensitive"))) {
                caseSensitive = true;
            }
            this.cbCaseSensitive.setSelected(caseSensitive);
        }
        Box boxSearch = Box.createHorizontalBox();
        boxSearch.setPreferredSize(new Dimension(100, 22));
        boxSearch.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        boxWord.add(boxSearch);
        this.showWrapSearch = "true".equalsIgnoreCase((String)params.get("showWrapSearch"));
        if (this.showWrapSearch) {
            boxSearch.add((Component)this.cbWrapSearch);
            boxSearch.add(Box.createHorizontalStrut(8));
            boolean wrapSearch = true;
            if ("false".equalsIgnoreCase((String)params.get("wrapSearch"))) {
                wrapSearch = false;
            }
            this.cbWrapSearch.setSelected(wrapSearch);
        }
        this.showGlobalSearch = "true".equalsIgnoreCase((String)params.get("showGlobalSearch"));
        if (this.showGlobalSearch) {
            boxSearch.add((Component)this.cbGlobalSearch);
            boxSearch.add(Box.createHorizontalStrut(8));
            boolean globalSearch = false;
            if ("true".equalsIgnoreCase((String)params.get("globalSearch"))) {
                globalSearch = true;
            }
            this.cbGlobalSearch.setSelected(globalSearch);
        }
        this.showRemoteSearch = "true".equalsIgnoreCase((String)params.get("showRemoteSearch"));
        if (this.showRemoteSearch) {
            boxSearch.add((Component)this.cbRemoteSearch);
            boxSearch.add(Box.createHorizontalStrut(8));
            boolean remoteSearch = false;
            if ("true".equalsIgnoreCase((String)params.get("remoteSearch"))) {
                remoteSearch = true;
            }
            this.cbRemoteSearch.setSelected(remoteSearch);
        }
        boxWord.add(Box.createHorizontalGlue());
        this.pnControl.removeAll();
        this.pnControl.setLayout((LayoutManager)new BorderLayout());
        this.lbMessage.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 5));
        this.lbMessage.setForeground(Color.RED);
        this.pnControl.add((Component)this.lbMessage, (Object)"Center");
        Box boxControl = Box.createHorizontalBox();
        this.pnControl.add((Component)boxControl, (Object)"East");
        if ("true".equalsIgnoreCase("showCount")) {
            boxControl.add((Component)this.btnCount);
            boxControl.add(Box.createHorizontalStrut(5));
        }
        boxControl.add((Component)this.btnPrevious);
        boxControl.add(Box.createHorizontalStrut(5));
        boxControl.add((Component)this.btnNext);
        boxControl.add(Box.createHorizontalStrut(5));
        boxControl.add((Component)this.btnClose);
        boxControl.add(Box.createHorizontalStrut(5));
        this.listener = (SearchListener)params.get("listener");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String word = SearchUI.this.txtWord.getText();
                if (word == null || word.length() == 0) {
                    SearchUI.this.txtWord.requestFocus();
                } else {
                    SearchUI.this.btnNext.requestFocus();
                }
            }
        });
    }

    public void init(Map params) {
        String word;
        if (params == null) {
            params = new HashMap();
        }
        List targets = (List)params.get("targets");
        if (this.boxTarget != null && targets != null && targets.size() > 0) {
            String name;
            HashMap<String, KDCheckBox> olds = new HashMap<String, KDCheckBox>();
            for (KDCheckBox cbTarget : this.cbTargets) {
                name = cbTarget.getName();
                if (name == null) continue;
                olds.put(name, cbTarget);
            }
            this.cbTargets.clear();
            this.boxTarget.removeAll();
            for (Map target : targets) {
                KDCheckBox tmp;
                name = (String)target.get("name");
                String title = (String)target.get("title");
                if (title == null || title.length() == 0) continue;
                KDCheckBox cbTarget = null;
                if (name != null && name.trim().length() > 0 && (tmp = (KDCheckBox)olds.get(name.trim())) != null && title.equals(tmp.getText())) {
                    cbTarget = tmp;
                }
                if (cbTarget != null) {
                    if (target.get("selected") != null) {
                        boolean selected = "true".equalsIgnoreCase((String)target.get("selected"));
                        cbTarget.setSelected(selected);
                    }
                } else {
                    boolean selected = "true".equalsIgnoreCase((String)target.get("selected"));
                    cbTarget = new KDCheckBox(title);
                    if (name != null && name.trim().length() > 0) {
                        cbTarget.setName(name.trim());
                        cbTarget.setToolTipText(title + "[" + name.trim() + "]");
                    }
                    cbTarget.setSelected(selected);
                }
                this.cbTargets.add(cbTarget);
                this.boxTarget.add((Component)cbTarget);
            }
            this.boxTarget.revalidate();
        }
        if ((word = (String)params.get("word")) != null && word.length() > 0) {
            this.txtWord.setText(word);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchUI.this.lbMessage.setText("");
                SearchUI.this.lbMessage.setToolTipText("");
                String word = SearchUI.this.txtWord.getText();
                if (word == null || word.length() == 0) {
                    SearchUI.this.txtWord.requestFocus();
                } else {
                    SearchUI.this.btnNext.requestFocus();
                }
            }
        });
    }

    @Override
    public void actionCount_actionPerformed(ActionEvent e) throws Exception {
        this.actionSearch_actionPerformed(e);
    }

    @Override
    public void actionPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.actionSearch_actionPerformed(e);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.actionSearch_actionPerformed(e);
    }

    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        Object result;
        this.lbMessage.setText("");
        this.lbMessage.setToolTipText("");
        HashMap<String, Object> params = new HashMap<String, Object>();
        String word = this.txtWord.getText();
        if (word == null || word.length() == 0) {
            this.lbMessage.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"InputSearchWord"));
            this.lbMessage.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"InputSearchWord"));
            return;
        }
        params.put("word", word);
        params.put("mistiness", String.valueOf(this.cbMistiness.isSelected()));
        if (this.showCaseSensitive) {
            params.put("caseSensitive", String.valueOf(this.cbCaseSensitive.isSelected()));
        }
        if (this.showWrapSearch) {
            params.put("wrapSearch", String.valueOf(this.cbWrapSearch.isSelected()));
        }
        if (this.showGlobalSearch) {
            params.put("globalSearch", String.valueOf(this.cbGlobalSearch.isSelected()));
        }
        if (this.showRemoteSearch) {
            params.put("remoteSearch", String.valueOf(this.cbRemoteSearch.isSelected()));
        }
        if (e.getSource() == this.btnCount) {
            params.put("action", "count");
        } else if (e.getSource() == this.btnPrevious) {
            params.put("action", "previous");
        } else {
            params.put("action", "next");
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (KDCheckBox cbTarget : this.cbTargets) {
            String name;
            if (!cbTarget.isSelected() || (name = cbTarget.getName()) == null) continue;
            targets.add(name);
        }
        params.put("targets", targets);
        if (this.listener != null && (result = this.listener.search(params)) != null) {
            if (result instanceof Map) {
                Object m = ((Map)result).get("message");
                if (m != null) {
                    this.lbMessage.setText(m.toString());
                    this.lbMessage.setToolTipText(m.toString());
                }
            } else {
                this.lbMessage.setText(result.toString());
                this.lbMessage.setToolTipText(result.toString());
            }
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

