/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.CashflowF7Util;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordCollection;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractTemplateCashflowEditUI;
import com.kingdee.eas.fi.gl.client.TemplateVoucherEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class TemplateCashflowEditUI
extends AbstractTemplateCashflowEditUI {
    public static final String PARENTUI = "PARENTUI";
    public static final String CASHFLOWFLAG = "CASHFLOWFLAG";
    public static final String CANEDIT = "CANEDIT";
    public static final String VOUCHER = "VOUCHER";
    public static final String MUSTINPUTBOTHITEM = "MUSTINPUTBOTHITEM";
    public static final String FOREIGNCURRENCYSU = "FOREIGNCURRENCYSU";
    public static final String USEREPORTINGCURRENCY = "USEREPORTINGCURRENCY";
    public static final String LOCALCURRENCY = "LOCALCURRENCY";
    public static final String REPORTINGCURRENCY = "REPORTINGCURRENCY";
    public static final String AMOUNT_ROUND_MODE = "AMOUNT_ROUND_MODE";
    public static final String REPEATE_CASHFLOW = "REPEATE_CASHFLOW";
    public static final int RV_CONFIRM = 0;
    public static final int RV_CANCEL = 1;
    protected TemplateVoucherEditUI parentUI;
    protected CashflowFlag cfFlag;
    protected int returnValue = 1;
    protected TemplateCashflowRecordCollection cfCol;
    protected boolean mustInputBothItem;
    protected TemplateVoucherInfo vch;
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    protected int amountRoundMode;
    protected int illegalCfEntryIndex = -1;
    protected int illegalCfOppEntryIndex = -1;
    protected int curCfEntryIndex = -1;
    protected int curCfOppEntryIndex = -1;
    protected KDTDefaultCellEditor comboBoxEditor;
    protected KDTDefaultCellEditor numberEditor;
    protected Vector vecOppEntries;
    protected boolean isPiEdited = false;
    protected boolean isSiEdited = false;
    protected Map piEditedMap = new HashMap();
    protected Map siEditedMap = new HashMap();
    protected CashFlowItemInfo piItem = null;
    protected CashFlowItemInfo siItem = null;
    protected boolean isInList = false;
    protected String lexTableId;
    protected String rexTableId;
    protected HashMap exchangeRate = new HashMap();
    static final String CF_ENTRY = "entry";
    static final String CF_CURRENCY = "currency";
    static final String CF_AMNT = "amount";
    static final String CF_LA = "localAmount";
    static final String CF_RA = "reportingAmount";
    static final String CF_OPP_ENTRY = "o.Entry";
    static final String CF_OPP_PI = "o.primaryItem";
    static final String CF_OPP_SI = "o.supplementaryItem";
    static final String CF_OPP_AMNT = "o.amount";
    static final String CF_OPP_LA = "o.localAmount";
    static final String CF_OPP_RA = "o.reportingAmount";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.CashflowEditResource";
    public static final String ACTIONKEY_SWITCH_TABLE = "SWITCHTABLE";
    protected boolean cashflowByDirection = true;
    CfExitListener cfExitLs = new CfExitListener(this.tblOppEntries, 0, false);
    CfFocusListener cfFocusForwardLs = new CfFocusListener(this.tblOppEntries, 0, false);
    CfFocusListener cfFocusBackwardLs = new CfFocusListener(this.tblOppEntries, 0, true);
    CfOppEntryEditAdapter cfOppEntryEditLs = new CfOppEntryEditAdapter();
    CfEntrySwitchListener cfEntrySwitchLs = new CfEntrySwitchListener();
    CfOppEntrySwitchListener cfOppEntrySwitchLs = new CfOppEntrySwitchListener();

    public TemplateCashflowEditUI() throws Exception {
        this.btnRecalc.setText(null);
        this.btnRecalc.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        Dimension size = new Dimension(650, 460);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnRecalc);
        this.remove((Component)this.btnAddLine);
        this.remove((Component)this.btnInsertLine);
        this.remove((Component)this.btnRemoveLine);
        this.kDContainer1.addButton((JButton)this.btnRecalc);
        this.kDContainer1.addButton((JButton)this.btnAddLine);
        this.kDContainer1.addButton((JButton)this.btnInsertLine);
        this.kDContainer1.addButton((JButton)this.btnRemoveLine);
    }

    public void onLoad() throws Exception {
        this.fetchInitData();
        this.initTableStyle();
        this.actionConfirm.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        super.onLoad();
        this.loadFields();
    }

    public void onShow() throws Exception {
        this.tblOppEntries.getEditManager().editCellAt(0, 0);
    }

    protected void fetchInitData() {
        Map ctx = this.getUIContext();
        this.cfFlag = (CashflowFlag)ctx.get(CASHFLOWFLAG);
        Boolean canEdit = (Boolean)ctx.get(CANEDIT);
        if (canEdit != null && canEdit.booleanValue()) {
            this.btnConfirm.setEnabled(false);
        }
        this.mustInputBothItem = (Boolean)ctx.get(MUSTINPUTBOTHITEM);
        this.foreignCurrencySU = (Boolean)ctx.get(FOREIGNCURRENCYSU);
        this.useReportingCurrency = (Boolean)ctx.get(USEREPORTINGCURRENCY);
        Object obj = ctx.get(VOUCHER);
        if (obj instanceof TemplateVoucherInfo) {
            this.vch = (TemplateVoucherInfo)ctx.get(VOUCHER);
        }
        this.localCurrency = (CurrencyInfo)ctx.get(LOCALCURRENCY);
        this.reportingCurrency = (CurrencyInfo)ctx.get(REPORTINGCURRENCY);
        this.amountRoundMode = (Integer)ctx.get(AMOUNT_ROUND_MODE);
        this.vch.setCashflowFlag(this.cfFlag);
        Boolean repeatCashflow = (Boolean)ctx.get(REPEATE_CASHFLOW);
        if (repeatCashflow != null) {
            this.isInList = repeatCashflow;
        } else {
            this.parentUI = (TemplateVoucherEditUI)((Object)ctx.get(PARENTUI));
        }
        CompanyOrgUnitInfo com = SysContext.getSysContext().getCurrentFIUnit();
        if (com.getBaseExchangeTable() != null) {
            this.lexTableId = com.getBaseExchangeTable().getId().toString();
        }
        this.rexTableId = this.useReportingCurrency && com.getReportExchangeTable() != null ? com.getReportExchangeTable().getId().toString() : this.lexTableId;
        if (this.cfFlag.equals((Object)CashflowFlag.ONLY_PNLACCOUNT)) {
            this.cashflowByDirection = false;
        }
    }

    protected void initTableStyle() {
        this.tblEntries.checkParsed();
        this.tblOppEntries.checkParsed();
        this.tblEntries.getStyleAttributes().setLocked(true);
        this.tblEntries.getSelectManager().setSelectMode(2);
        this.tblOppEntries.getSelectManager().setSelectMode(2);
        IColumn entryCol = this.tblEntries.getColumn(CF_ENTRY);
        IColumn curCol = this.tblEntries.getColumn(CF_CURRENCY);
        IColumn amntCol = this.tblEntries.getColumn(CF_AMNT);
        IColumn laCol = this.tblEntries.getColumn(CF_LA);
        IColumn raCol = this.tblEntries.getColumn(CF_RA);
        IColumn oppEntryCol = this.tblOppEntries.getColumn(CF_OPP_ENTRY);
        IColumn oppPiCol = this.tblOppEntries.getColumn(CF_OPP_PI);
        IColumn oppSiCol = this.tblOppEntries.getColumn(CF_OPP_SI);
        IColumn oppAmntCol = this.tblOppEntries.getColumn(CF_OPP_AMNT);
        IColumn oppLaCol = this.tblOppEntries.getColumn(CF_OPP_LA);
        IColumn oppRaCol = this.tblOppEntries.getColumn(CF_OPP_RA);
        amntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        laCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        raCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppAmntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppLaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppRaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.foreignCurrencySU) {
            String amount = EASResource.getString((String)RESOURCE_PATH, (String)CF_AMNT);
            amntCol.getStyleAttributes().setHided(true);
            raCol.getStyleAttributes().setHided(true);
            IRow header = this.tblEntries.getHeadRow(0);
            header.getCell(CF_LA).setValue((Object)amount);
            oppAmntCol.getStyleAttributes().setHided(true);
            oppRaCol.getStyleAttributes().setHided(true);
            IRow oppHeader = this.tblOppEntries.getHeadRow(0);
            oppHeader.getCell(CF_OPP_LA).setValue((Object)amount);
        } else if (!this.useReportingCurrency) {
            raCol.getStyleAttributes().setHided(true);
            oppRaCol.getStyleAttributes().setHided(true);
        }
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setNegativeColor(Color.red);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.numberEditor.setClickCountToStart(1);
        oppAmntCol.setEditor((ICellEditor)this.numberEditor);
        oppLaCol.setEditor((ICellEditor)this.numberEditor);
        oppRaCol.setEditor((ICellEditor)this.numberEditor);
        KDBizPromptBox bizPiPromptBox = new KDBizPromptBox();
        oppPiCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPiPromptBox));
        KDBizPromptBox bizSiPromptBox = new KDBizPromptBox();
        oppSiCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizSiPromptBox));
        ObjectValueRender normalObjectRender = new ObjectValueRender();
        normalObjectRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        curCol.setRenderer((IBasicRender)normalObjectRender);
        oppPiCol.setRenderer((IBasicRender)normalObjectRender);
        oppSiCol.setRenderer((IBasicRender)normalObjectRender);
        if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)this.cfFlag)) {
            oppPiCol.getStyleAttributes().setHided(true);
        }
        KeyStroke ctrl_enter = KeyStroke.getKeyStroke(10, 2);
        this.tblOppEntries.getInputMap().put(ctrl_enter, ACTIONKEY_SWITCH_TABLE);
    }

    protected void detachListeners() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.tblOppEntries.removeKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
            ActionMap entryActionMap = this.tblOppEntries.getActionMap();
            entryActionMap.put("FocusChangeCol", null);
            entryActionMap.put("FocusChangeRow", null);
            entryActionMap.put("FocusChangeColReverse", null);
            entryActionMap.put("FocusChangeRowReverse", null);
            entryActionMap.put(ACTIONKEY_SWITCH_TABLE, null);
        }
        this.tblOppEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
        this.tblEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
    }

    protected void attachListeners() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.tblOppEntries.addKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
            ActionMap entryActionMap = this.tblOppEntries.getActionMap();
            entryActionMap.put("FocusChangeCol", (Action)((Object)this.cfFocusForwardLs));
            entryActionMap.put("FocusChangeRow", (Action)((Object)this.cfFocusForwardLs));
            entryActionMap.put("FocusChangeColReverse", (Action)((Object)this.cfFocusBackwardLs));
            entryActionMap.put("FocusChangeRowReverse", (Action)((Object)this.cfFocusBackwardLs));
            entryActionMap.put(ACTIONKEY_SWITCH_TABLE, (Action)((Object)this.cfExitLs));
        }
        this.tblOppEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
        this.tblEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
    }

    @Override
    public void setOprtState(String state) {
        super.setOprtState(state);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionRecalc.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.tblOppEntries.getStyleAttributes().setLocked(true);
        } else {
            this.actionRecalc.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.tblOppEntries.getStyleAttributes().setLocked(false);
        }
    }

    @Override
    public void loadFields() {
        BOSUuid entryId;
        this.detachListeners();
        super.loadFields();
        this.curCfEntryIndex = -1;
        this.illegalCfEntryIndex = -1;
        this.tblOppEntries.removeRows();
        Vector<CfEntryData> vecCfEntryData = new Vector<CfEntryData>();
        this.vecOppEntries = new Vector();
        HashMap<Object, CfEntryData> hmEntryIdToDataObject = new HashMap<Object, CfEntryData>();
        TemplateVoucherEntryCollection entries = this.vch.getEntries();
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            TemplateVoucherEntryInfo entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            CfEntryData dataObject = null;
            if (acc == null || acc.isBudget()) continue;
            if (CashflowFlag.ONLY_CASHACCOUNT.equals((Object)this.cfFlag) || CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)this.cfFlag)) {
                if (acc.isIsCash() || acc.isIsBank() || acc.isIsCashEquivalent()) {
                    dataObject = new CfEntryData(entry);
                    vecCfEntryData.add(dataObject);
                } else {
                    dataObject = entry;
                    this.vecOppEntries.add(new CfVoucherEntryWrapper(entry));
                }
            } else if (AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty())) {
                dataObject = new CfEntryData(entry);
                vecCfEntryData.add(dataObject);
            } else {
                dataObject = entry;
                this.vecOppEntries.add(new CfVoucherEntryWrapper(entry));
            }
            entryId = entry.getId();
            if (entryId != null) {
                hmEntryIdToDataObject.put(entryId.toString(), dataObject);
                continue;
            }
            hmEntryIdToDataObject.put(entry.get("seq"), dataObject);
        }
        TemplateCashflowRecordCollection cfs = this.vch.getCashflowRecords();
        if (cfs != null && cfs.size() > 0) {
            this.isPiEdited = true;
            this.isSiEdited = true;
            for (TemplateCashflowRecordInfo r : cfs) {
                TemplateVoucherEntryInfo rawEntry = r.getEntry();
                entryId = rawEntry.getId();
                CfEntryData ed = null;
                Object obj = null;
                obj = entryId != null ? hmEntryIdToDataObject.get(entryId.toString()) : hmEntryIdToDataObject.get(rawEntry.get("seq"));
                if (!(obj instanceof CfEntryData)) continue;
                ed = obj;
                TemplateVoucherEntryInfo rawOppEntry = r.getOpposingAccountEntry();
                BOSUuid oppEntryId = rawOppEntry.getId();
                TemplateVoucherEntryInfo oppEntry = null;
                oppEntry = oppEntryId != null ? (hmEntryIdToDataObject.get(oppEntryId.toString()) instanceof CfEntryData ? ((CfEntryData)hmEntryIdToDataObject.get(oppEntryId.toString())).getEntry() : (TemplateVoucherEntryInfo)hmEntryIdToDataObject.get(oppEntryId.toString())) : (TemplateVoucherEntryInfo)hmEntryIdToDataObject.get(rawOppEntry.get("seq"));
                CfOppEntryData oe = new CfOppEntryData(oppEntry, r.getPrimaryItem(), r.getSupplementaryItem(), r.getOriginalAmount(), r.getLocalAmount(), r.getReportingAmount());
                ed.getOppEntries().add(oe);
            }
        }
        this.comboBoxEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox(this.vecOppEntries));
        this.tblOppEntries.getColumn(CF_OPP_ENTRY).setEditor((ICellEditor)this.comboBoxEditor);
        for (CfEntryData ed : vecCfEntryData) {
            IRow row = this.tblEntries.addRow();
            this.loadCfEntry(ed, row);
        }
        this.attachListeners();
        KDTSelectManager sm = this.tblEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(0, -1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.curCfEntryIndex >= 0) {
            IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
            CfEntryData ed = (CfEntryData)cfEntryRow.getUserObject();
            this.storeCfEntry(ed, cfEntryRow);
        }
    }

    protected void loadCfEntry(CfEntryData ed, IRow row) {
        TemplateVoucherEntryInfo entry = ed.getEntry();
        CurrencyInfo cur = entry.getCurrency();
        row.getCell(CF_ENTRY).setValue((Object)new CfVoucherEntryWrapper(entry));
        row.getCell(CF_CURRENCY).setValue((Object)cur);
        row.getCell(CF_AMNT).setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), cur.getPrecision()));
        row.getCell(CF_LA).setValue((Object)GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision()));
        if (this.useReportingCurrency) {
            row.getCell(CF_RA).setValue((Object)GlUtils.setScale(entry.getReportingAmount(), this.reportingCurrency.getPrecision()));
        } else if (row.getCell(CF_RA) != null) {
            row.getCell(CF_RA).getStyleAttributes().setHided(true);
        }
        row.setUserObject((Object)ed);
    }

    protected void storeCfEntry(CfEntryData ed, IRow row) {
        if (this.curCfOppEntryIndex >= 0) {
            IRow cfOppEntryRow = this.tblOppEntries.getRow(this.curCfOppEntryIndex);
            CfOppEntryData oe = (CfOppEntryData)cfOppEntryRow.getUserObject();
            this.storeCfOppEntry(oe, cfOppEntryRow);
        }
        Vector oeCol = ed.getOppEntries();
        oeCol.clear();
        int rowCount = this.tblOppEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow cfOppEntryRow = this.tblOppEntries.getRow(i);
            CfOppEntryData oe = (CfOppEntryData)cfOppEntryRow.getUserObject();
            oeCol.add(oe);
        }
    }

    protected void loadCfOppEntry(CfOppEntryData oe, IRow row) {
        row.getCell(CF_OPP_ENTRY).setValue((Object)new CfVoucherEntryWrapper(oe.getOppEntry()));
        row.getCell(CF_OPP_PI).setValue((Object)oe.getPrimaryItem());
        row.getCell(CF_OPP_SI).setValue((Object)oe.getSupplementaryItem());
        CurrencyInfo cur = this.getOriginalCurrency(this.curCfEntryIndex);
        BigDecimal coefficient = GlUtils.one;
        if (this.cashflowByDirection) {
            IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
            if (cfEntryRow == null) {
                return;
            }
            TemplateVoucherEntryInfo entry = ((CfVoucherEntryWrapper)cfEntryRow.getCell(CF_ENTRY).getValue()).getEntry();
            BigDecimal bigDecimal = coefficient = entry.getEntryDC().getValue() == 1 ? GlUtils.one : GlUtils.negone;
            if (oe.getPrimaryItem() != null && oe.getPrimaryItem().getDirection().equals((Object)CashFlowDirection.OUT)) {
                coefficient = GlUtils.negone.multiply(coefficient);
            }
        }
        row.getCell(CF_OPP_AMNT).setValue((Object)GlUtils.setScale(oe.getAmount().multiply(coefficient), cur.getPrecision()));
        row.getCell(CF_OPP_LA).setValue((Object)GlUtils.setScale(oe.getLocalAmount().multiply(coefficient), this.localCurrency.getPrecision()));
        if (this.useReportingCurrency) {
            row.getCell(CF_OPP_RA).setValue((Object)GlUtils.setScale(oe.getReportingAmount().multiply(coefficient), this.reportingCurrency.getPrecision()));
        } else if (row.getCell(CF_OPP_RA) != null) {
            row.getCell(CF_OPP_RA).getStyleAttributes().setHided(true);
        }
        row.setUserObject((Object)oe);
    }

    protected void storeCfOppEntry(CfOppEntryData oe, IRow row) {
        CfVoucherEntryWrapper entryWrapper = (CfVoucherEntryWrapper)row.getCell(CF_OPP_ENTRY).getValue();
        oe.setOppEntrys(entryWrapper.getEntry());
        oe.setPrimaryItem((CashFlowItemInfo)row.getCell(CF_OPP_PI).getValue());
        oe.setSupplementaryItem((CashFlowItemInfo)row.getCell(CF_OPP_SI).getValue());
        ICell amntCell = row.getCell(CF_OPP_AMNT);
        ICell raCell = row.getCell(CF_OPP_RA);
        BigDecimal amnt = (BigDecimal)amntCell.getValue();
        BigDecimal la = (BigDecimal)row.getCell(CF_OPP_LA).getValue();
        BigDecimal ra = (BigDecimal)raCell.getValue();
        BigDecimal coefficient = GlUtils.one;
        if (this.cashflowByDirection) {
            IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
            TemplateVoucherEntryInfo entry = ((CfVoucherEntryWrapper)cfEntryRow.getCell(CF_ENTRY).getValue()).getEntry();
            BigDecimal bigDecimal = coefficient = entry.getEntryDC().getValue() == 1 ? GlUtils.one : GlUtils.negone;
            if (oe.getPrimaryItem() != null && oe.getPrimaryItem().getDirection().equals((Object)CashFlowDirection.OUT)) {
                coefficient = GlUtils.negone.multiply(coefficient);
            }
        }
        if (amnt != null) {
            oe.setAmount(amnt.multiply(coefficient));
            oe.setLocalAmount(la.multiply(coefficient));
            if (this.useReportingCurrency) {
                oe.setReportingAmount(ra.multiply(coefficient));
            } else {
                oe.setReportingAmount(la.multiply(coefficient));
            }
        }
    }

    protected void construtsEntries(CashFlowItemInfo item, String columnName, TemplateVoucherEntryInfo oppEntry) {
        int rowCount = this.tblEntries.getRowCount();
        int index = this.tblEntries.getSelectManager().get().getTop();
        IRow rowCur = this.tblEntries.getRow(index);
        CfEntryData entrydata = (CfEntryData)rowCur.getUserObject();
        TemplateVoucherEntryInfo entryInfo = entrydata.getEntry();
        EntryDC entryDC = entryInfo.getEntryDC();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEntries.getRow(i);
            CfEntryData ed = (CfEntryData)row.getUserObject();
            TemplateVoucherEntryInfo entry = ed.getEntry();
            EntryDC dc = entry.getEntryDC();
            CfOppEntryData oe = null;
            if (entryDC.getValue() != dc.getValue()) continue;
            if (columnName.equals(CF_OPP_PI)) {
                if (ed.getOppEntries().size() > 0) {
                    oe = (CfOppEntryData)ed.getOppEntries().get(0);
                    oe.setPrimaryItem(item);
                    continue;
                }
                oe = new CfOppEntryData(oppEntry, item, null, entry.getOriginalAmount(), entry.getLocalAmount(), entry.getReportingAmount());
                ed.getOppEntries().add(oe);
                continue;
            }
            if (ed.getOppEntries().size() <= 0) continue;
            oe = (CfOppEntryData)ed.getOppEntries().get(0);
            oe.setSupplementaryItem(item);
        }
    }

    protected CurrencyInfo getOriginalCurrency(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getCurrency();
    }

    protected VoucherInfo.ExchangeRateWithValue getLocalExDefinition(int rowIndex) {
        CurrencyInfo cur = this.getOriginalCurrency(rowIndex);
        String curid = cur.getId().toString();
        VoucherInfo.ExchangeRateWithValue ex = null;
        ex = !this.isInList ? this.parentUI.getCachedLocalExchangeRate(cur.getId().toString()) : (curid.equals(this.localCurrency.getId().toString()) ? VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE : this.getEx(this.localCurrency.getId().toString()));
        return ex;
    }

    protected VoucherInfo.ExchangeRateWithValue getEx(String orgCurId) {
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.exchangeRate.get(orgCurId);
        String localCurid = this.localCurrency.getId().toString();
        String reprotCurid = this.reportingCurrency.getId().toString();
        if (ex == null) {
            try {
                Object[] info = new Object[8];
                if (this.lexTableId == null) {
                    throw new GLException(GLException.NOLOCALEXTABLE);
                }
                if (this.rexTableId == null) {
                    throw new GLException(GLException.NOREPORTINGEXTABLE);
                }
                info[0] = this.lexTableId;
                info[1] = this.rexTableId;
                info[2] = orgCurId;
                info[3] = localCurid;
                info[4] = reprotCurid;
                info[5] = null;
                info[6] = null;
                Object[] exes = VoucherFacadeFactory.getRemoteInstance().fetchExchangeRate(info);
                this.exchangeRate.put(localCurid, (VoucherInfo.ExchangeRateWithValue)exes[0]);
                this.exchangeRate.put(reprotCurid, exes[1]);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        ex = (VoucherInfo.ExchangeRateWithValue)this.exchangeRate.get(orgCurId);
        return ex;
    }

    protected BigDecimal getLocalExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getLocalExchangeRate();
    }

    protected VoucherInfo.ExchangeRateWithValue getReportingExDefinition(int rowIndex) {
        CurrencyInfo cur = this.getOriginalCurrency(rowIndex);
        VoucherInfo.ExchangeRateWithValue ex = null;
        String curid = cur.getId().toString();
        ex = !this.isInList ? this.parentUI.getCachedReportingExchangeRate(cur.getId().toString()) : (curid.equals(this.reportingCurrency.getId().toString()) ? VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE : this.getEx(this.reportingCurrency.getId().toString()));
        return ex;
    }

    protected BigDecimal getReportingExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getReportingExchangeRate();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        CfOppEntryData oe = this.createNewOppEntry(this.tblEntries.getRow(this.curCfEntryIndex));
        IRow row = this.tblOppEntries.addRow();
        this.loadCfOppEntry(oe, row);
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(this.tblOppEntries.getRowCount() - 1, -1);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        CfOppEntryData oe = this.createNewOppEntry(this.tblEntries.getRow(this.curCfEntryIndex));
        IRow row = null;
        int top = this.curCfOppEntryIndex;
        if (top >= 0) {
            row = this.tblOppEntries.addRow(top);
        } else {
            top = this.tblOppEntries.getRowCount();
            row = this.tblOppEntries.addRow();
        }
        this.loadCfOppEntry(oe, row);
        if (this.curCfOppEntryIndex >= 0) {
            ++this.curCfOppEntryIndex;
        }
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(top, -1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        int top = this.curCfOppEntryIndex;
        IRow curRow = this.tblOppEntries.getRow(top);
        CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
        this.storeCfOppEntry(oe, curRow);
        this.tblOppEntries.removeRow(top);
        this.afterRemoveLine(oe);
        if (this.curCfOppEntryIndex >= 0) {
            this.curCfOppEntryIndex = -1;
        }
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        int rowCount = this.tblOppEntries.getRowCount();
        if (rowCount == 0) {
            sm.removeAll(false);
            this.actionAddLine_actionPerformed(null);
        } else if (top < rowCount) {
            sm.removeAll(false);
            sm.select(top, -1);
        } else {
            sm.removeAll();
            this.afterSelectCfOppEntry(null);
        }
    }

    protected void afterRemoveLine(CfOppEntryData oe) {
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTEditManager em = this.tblOppEntries.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
            if (em.isEditing()) {
                SysUtil.abort();
            }
        }
    }

    protected boolean checkDataObject() {
        int rowCount = this.tblEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CfEntryData ed = (CfEntryData)this.tblEntries.getRow(i).getUserObject();
            String prop = this.getCfEntryIllegalProp(ed);
            if (prop == null) continue;
            this.illegalCfEntryIndex = -1;
            this.curCfEntryIndex = -1;
            KDTSelectManager sm = this.tblEntries.getSelectManager();
            sm.removeAll(false);
            sm.select(i, -1);
            if (prop.startsWith("o.")) {
                int rowIndex = this.illegalCfOppEntryIndex;
                this.illegalCfOppEntryIndex = -1;
                this.curCfOppEntryIndex = -1;
                this.goBackToCell(this.tblOppEntries, rowIndex, prop);
            }
            return false;
        }
        return true;
    }

    protected TemplateCashflowRecordCollection buildResult() {
        TemplateCashflowRecordCollection result = new TemplateCashflowRecordCollection();
        int rowCount = this.tblEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CfEntryData ed = (CfEntryData)this.tblEntries.getRow(i).getUserObject();
            TemplateVoucherEntryInfo entry = ed.getEntry();
            EntryDC entryDC = entry.getEntryDC();
            BalanceDirectionEnum accDC = entry.getAccount().getDC();
            Vector oppEntries = ed.getOppEntries();
            Iterator itr = oppEntries.iterator();
            int seq = 1;
            while (itr.hasNext()) {
                CfOppEntryData oe = (CfOppEntryData)itr.next();
                TemplateCashflowRecordInfo rec = new TemplateCashflowRecordInfo();
                result.add(rec);
                rec.setSeq(seq++);
                rec.setVoucher(this.vch);
                rec.setEntry(entry);
                rec.setOpposingAccountEntry(oe.getOppEntry());
                CashFlowItemInfo pi = oe.getPrimaryItem();
                rec.setPrimaryItem(pi);
                CashFlowItemInfo si = oe.getSupplementaryItem();
                rec.setSupplementaryItem(si);
                rec.setOriginalAmount(oe.getAmount());
                rec.setLocalAmount(oe.getLocalAmount());
                rec.setReportingAmount(oe.getReportingAmount());
                if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)this.cfFlag)) {
                    rec.setItemFlag(ItemFlag.SUPPLEMENTARY);
                    rec.setPrimaryCoefficient(0);
                    if (EntryDC.DEBIT.equals((Object)entryDC)) {
                        rec.setSupplementaryCoefficient(1);
                        continue;
                    }
                    rec.setSupplementaryCoefficient(-1);
                    continue;
                }
                int pc = 1;
                if (pi == null) continue;
                CashFlowDirection direct = pi.getDirection();
                if (EntryDC.DEBIT.equals((Object)entryDC) && CashFlowDirection.OUT.equals((Object)direct) || EntryDC.CREDIT.equals((Object)entryDC) && CashFlowDirection.IN.equals((Object)direct)) {
                    pc = -1;
                }
                rec.setPrimaryCoefficient(pc);
                if (this.isSIEnabled(oe.getOppEntry(), pi) && si != null) {
                    int sc;
                    rec.setItemFlag(ItemFlag.BOTH);
                    AccountViewInfo acc = oe.getOppEntry().getAccount();
                    boolean isPnL = AccountProperty.SUNYI.equals((Object)acc.getAccountTypeID().getProperty());
                    if (isPnL) {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)oe.getOppEntry().getEntryDC())) {
                            sc = 1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = -1;
                            }
                        } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        rec.setSupplementaryCoefficient(sc);
                        continue;
                    }
                    sc = -1;
                    if (EntryDC.DEBIT.equals((Object)entryDC)) {
                        sc = 1;
                    }
                    rec.setSupplementaryCoefficient(sc);
                    continue;
                }
                rec.setItemFlag(ItemFlag.PRIMARY);
                rec.setSupplementaryCoefficient(0);
            }
        }
        return result;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        if (this.checkDataObject()) {
            this.setResult(this.buildResult());
            this.setReturnValue(0);
            this.vch.setCashflowRecords(this.getResult());
            this.vch.setCashflowFlag(CashflowFlag.FINISHED);
            this.destroyWindow();
        }
    }

    private void saveCashflow() throws Exception {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("vchid", this.vch.getId().toString());
        mapParam.put("vch", (String)this.vch);
        this.vch.setCashflowRecords(this.cfCol);
        ICashflowRecord item = CashflowRecordFactory.getRemoteInstance();
        item.saveCashflowCols((IObjectCollection)this.cfCol, mapParam);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setResult(null);
        this.setReturnValue(1);
        this.destroyWindow();
    }

    @Override
    public void actionRecalc_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblOppEntries.getRow(this.curCfOppEntryIndex);
        IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
        CfVoucherEntryWrapper entryWrapper = (CfVoucherEntryWrapper)row.getCell(CF_OPP_ENTRY).getValue();
        if (entryWrapper != null) {
            CfOppEntryData oe = new CfOppEntryData(entryWrapper.getEntry());
            BigDecimal[] amnt = this.computeAmnt(cfEntryRow, oe, this.curCfOppEntryIndex);
            Object value = row.getCell(CF_OPP_PI).getValue();
            if (value instanceof Object[]) {
                value = ((Object[])value)[0];
            }
            oe.setPrimaryItem((CashFlowItemInfo)value);
            value = row.getCell(CF_OPP_SI).getValue();
            if (value instanceof Object[]) {
                value = ((Object[])value)[0];
            }
            oe.setSupplementaryItem((CashFlowItemInfo)value);
            oe.setAmount(amnt[0]);
            oe.setLocalAmount(amnt[1]);
            oe.setReportingAmount(amnt[2]);
            this.loadCfOppEntry(oe, row);
        }
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setResult(TemplateCashflowRecordCollection cf) {
        this.cfCol = cf;
    }

    public TemplateCashflowRecordCollection getResult() {
        return this.cfCol;
    }

    protected String getCfEntryIllegalProp(CfEntryData ed) {
        BigDecimal zero;
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return null;
        }
        Vector oppEntries = ed.getOppEntries();
        BigDecimal amntTotal = zero = new BigDecimal("0");
        BigDecimal laTotal = zero;
        BigDecimal raTotal = zero;
        Iterator itr = oppEntries.iterator();
        int count = 0;
        while (itr.hasNext()) {
            CfOppEntryData oe = (CfOppEntryData)itr.next();
            String prop = this.getCfOppEntryIllegalProp(oe);
            if (prop != null) {
                this.illegalCfOppEntryIndex = count;
                return prop;
            }
            amntTotal = amntTotal.add(oe.getAmount());
            laTotal = laTotal.add(oe.getLocalAmount());
            raTotal = raTotal.add(oe.getReportingAmount());
            ++count;
        }
        TemplateVoucherEntryInfo entry = ed.getEntry();
        if (entry.getOriginalAmount().compareTo(amntTotal) != 0) {
            String amountNotBalance = EASResource.getString((String)RESOURCE_PATH, (String)"amountNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)amountNotBalance);
            if (!this.foreignCurrencySU) {
                return CF_AMNT;
            }
            return CF_LA;
        }
        if (entry.getLocalAmount().compareTo(laTotal) != 0) {
            String localNotBalance = EASResource.getString((String)RESOURCE_PATH, (String)"localNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)localNotBalance);
            return CF_LA;
        }
        if (this.useReportingCurrency & entry.getReportingAmount().compareTo(raTotal) != 0) {
            String reportingNotBalance = EASResource.getString((String)RESOURCE_PATH, (String)"reportingNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)reportingNotBalance);
            return CF_RA;
        }
        return null;
    }

    protected String getCfOppEntryIllegalProp(CfOppEntryData oe) {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return null;
        }
        CashFlowItemInfo pi = oe.getPrimaryItem();
        if (!CashflowFlag.ONLY_PNLACCOUNT.equals((Object)this.cfFlag) && pi == null) {
            String missingPI = EASResource.getString((String)RESOURCE_PATH, (String)"missingPI");
            MsgBox.showWarning((Component)((Object)this), (String)missingPI);
            return CF_OPP_PI;
        }
        if ((CashflowFlag.ONLY_PNLACCOUNT.equals((Object)this.cfFlag) || this.isSIEnabled(oe.getOppEntry(), pi)) && this.mustInputBothItem && oe.getSupplementaryItem() == null) {
            String missingSI = EASResource.getString((String)RESOURCE_PATH, (String)"missingSI");
            MsgBox.showWarning((Component)((Object)this), (String)missingSI);
            return CF_OPP_SI;
        }
        if (oe.getAmount() == null) {
            String missingAmount = EASResource.getString((String)RESOURCE_PATH, (String)"missingAmount");
            MsgBox.showWarning((Component)((Object)this), (String)missingAmount);
            if (!this.foreignCurrencySU) {
                return CF_OPP_AMNT;
            }
            return CF_OPP_LA;
        }
        if (oe.getLocalAmount() == null) {
            String missingLocal = EASResource.getString((String)RESOURCE_PATH, (String)"missingLocal");
            MsgBox.showWarning((Component)((Object)this), (String)missingLocal);
            return CF_OPP_LA;
        }
        if (oe.getReportingAmount() == null) {
            String missingReporting = EASResource.getString((String)RESOURCE_PATH, (String)"missingReporting");
            MsgBox.showWarning((Component)((Object)this), (String)missingReporting);
            return CF_OPP_RA;
        }
        return null;
    }

    protected void goBackToCell(KDTable table, int rowIndex, String colKey) {
        table.getSelectManager().removeAll(false);
        table.getEditManager().editCellAt(rowIndex, table.getColumnIndex(colKey));
    }

    protected void afterSelectCfEntry(CfEntryData ed) {
        IRow row;
        this.tblOppEntries.removeRows();
        this.curCfOppEntryIndex = -1;
        this.illegalCfOppEntryIndex = -1;
        for (CfOppEntryData oe : ed.getOppEntries()) {
            row = this.tblOppEntries.addRow();
            this.loadCfOppEntry(oe, row);
        }
        if (this.tblOppEntries.getRowCount() == 0) {
            IRow cfRow = this.tblEntries.getRow(this.curCfEntryIndex);
            row = this.tblOppEntries.addRow();
            this.loadCfOppEntry(this.createNewOppEntry(cfRow), row);
        }
        this.actionRecalc.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
    }

    protected void afterSelectCfOppEntry(CfOppEntryData oe) {
        if (oe == null) {
            this.actionRecalc.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        } else if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.actionRecalc.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        }
    }

    protected boolean isCellEditable(IRow cfOppEntryRow, String colKey) {
        if (CF_OPP_SI.equals(colKey)) {
            boolean siEnabled = false;
            if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)this.cfFlag)) {
                siEnabled = true;
            } else {
                CashFlowItemInfo pi = (CashFlowItemInfo)cfOppEntryRow.getCell(CF_OPP_PI).getValue();
                if (pi != null) {
                    TemplateVoucherEntryInfo entry = ((CfVoucherEntryWrapper)cfOppEntryRow.getCell(CF_OPP_ENTRY).getValue()).getEntry();
                    return this.isSIEnabled(entry, pi);
                }
            }
            return siEnabled;
        }
        return true;
    }

    protected boolean isSIEnabled(TemplateVoucherEntryInfo entry, CashFlowItemInfo pi) {
        boolean isPnL = AccountProperty.SUNYI.equals((Object)entry.getAccount().getAccountTypeID().getProperty());
        boolean isAct = pi.isIsDealActivity();
        return isPnL && !isAct || !isPnL && isAct;
    }

    protected CfOppEntryData createNewOppEntry(IRow cfEntryRow) {
        CfOppEntryData oe = new CfOppEntryData(((CfVoucherEntryWrapper)this.vecOppEntries.get(0)).getEntry());
        BigDecimal[] amnt = this.computeAmnt(cfEntryRow, oe, -1);
        oe.setAmount(amnt[0]);
        oe.setLocalAmount(amnt[1]);
        oe.setReportingAmount(amnt[2]);
        return oe;
    }

    public TemplateCashflowRecordCollection getTemplateResult() {
        return this.cfCol;
    }

    private BigDecimal[] computeAmnt(IRow cfEntryRow, CfOppEntryData oe, int curCfOppEntryIndex) {
        BigDecimal newLa;
        BigDecimal zero;
        int rowCount = this.tblOppEntries.getRowCount();
        BigDecimal amntTotal = zero = new BigDecimal("0");
        BigDecimal laTotal = zero;
        BigDecimal raTotal = zero;
        BigDecimal curcoefficient = GlUtils.one;
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal la;
            IRow row = this.tblOppEntries.getRow(i);
            BigDecimal amnt = (BigDecimal)row.getCell(CF_OPP_AMNT).getValue();
            if (amnt == null) {
                amnt = zero;
            }
            if ((la = (BigDecimal)row.getCell(CF_OPP_LA).getValue()) == null) {
                la = zero;
            }
            BigDecimal coefficient = GlUtils.one;
            if (this.cashflowByDirection) {
                CashFlowItemInfo pi;
                cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
                TemplateVoucherEntryInfo entry = ((CfVoucherEntryWrapper)cfEntryRow.getCell(CF_ENTRY).getValue()).getEntry();
                coefficient = entry.getEntryDC().getValue() == 1 ? GlUtils.one : GlUtils.negone;
                Object value = row.getCell(CF_OPP_PI).getValue();
                if (value instanceof Object[]) {
                    value = ((Object[])value)[0];
                }
                if ((pi = (CashFlowItemInfo)value) != null && pi.getDirection().equals((Object)CashFlowDirection.OUT)) {
                    coefficient = GlUtils.negone;
                }
            }
            if (curCfOppEntryIndex == i) continue;
            amntTotal = amntTotal.add(amnt.multiply(coefficient));
            laTotal = laTotal.add(la.multiply(coefficient));
            if (!this.useReportingCurrency) continue;
            BigDecimal ra = (BigDecimal)row.getCell(CF_OPP_RA).getValue();
            if (ra == null) {
                ra = zero;
            }
            raTotal = raTotal.add(ra.multiply(coefficient));
        }
        BigDecimal newAmnt = ((BigDecimal)cfEntryRow.getCell(CF_AMNT).getValue()).subtract(amntTotal);
        BigDecimal newRa = newLa = ((BigDecimal)cfEntryRow.getCell(CF_LA).getValue()).subtract(laTotal);
        if (this.useReportingCurrency) {
            newRa = ((BigDecimal)cfEntryRow.getCell(CF_RA).getValue()).subtract(raTotal);
        }
        return new BigDecimal[]{newAmnt.multiply(curcoefficient), newLa.multiply(curcoefficient), newRa.multiply(curcoefficient)};
    }

    static class CfVoucherEntryWrapper {
        private TemplateVoucherEntryInfo entry;

        public CfVoucherEntryWrapper(TemplateVoucherEntryInfo ent) {
            this.entry = ent;
        }

        public TemplateVoucherEntryInfo getEntry() {
            return this.entry;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("(");
            sb.append(this.entry.getSeq());
            sb.append(")");
            AccountViewInfo acc = this.entry.getAccount();
            sb.append(acc.getNumber());
            sb.append(" - ");
            sb.append(acc.getLongName());
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CfVoucherEntryWrapper)) {
                return false;
            }
            CfVoucherEntryWrapper entryWrapper = (CfVoucherEntryWrapper)obj;
            return this.entry == entryWrapper.getEntry();
        }
    }

    static class CfOppEntryData {
        private TemplateVoucherEntryInfo oppEntry;
        private CashFlowItemInfo primaryItem;
        private CashFlowItemInfo supplementaryItem;
        private BigDecimal amount;
        private BigDecimal localAmount;
        private BigDecimal reportingAmount;
        private boolean amntEverChanged = false;
        private boolean ramntEverChanged = false;

        public CfOppEntryData(TemplateVoucherEntryInfo ent) {
            this(ent, null, null, null, null, null);
        }

        public CfOppEntryData(TemplateVoucherEntryInfo ent, CashFlowItemInfo pi, CashFlowItemInfo si, BigDecimal amnt, BigDecimal la, BigDecimal ra) {
            this.oppEntry = ent;
            this.primaryItem = pi;
            this.supplementaryItem = si;
            this.amount = amnt;
            this.localAmount = la;
            this.reportingAmount = ra;
        }

        public void setOppEntrys(TemplateVoucherEntryInfo ent) {
            this.oppEntry = ent;
        }

        public TemplateVoucherEntryInfo getOppEntry() {
            return this.oppEntry;
        }

        public void setPrimaryItem(CashFlowItemInfo item) {
            this.primaryItem = item;
        }

        public CashFlowItemInfo getPrimaryItem() {
            return this.primaryItem;
        }

        public void setSupplementaryItem(CashFlowItemInfo item) {
            this.supplementaryItem = item;
        }

        public CashFlowItemInfo getSupplementaryItem() {
            return this.supplementaryItem;
        }

        public void setAmount(BigDecimal amnt) {
            this.amount = amnt;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setLocalAmount(BigDecimal la) {
            this.localAmount = la;
        }

        public BigDecimal getLocalAmount() {
            return this.localAmount;
        }

        public void setReportingAmount(BigDecimal ra) {
            this.reportingAmount = ra;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setAmntEverChanged(boolean changed) {
            this.amntEverChanged = changed;
        }

        public boolean getAmntEverChanged() {
            return this.amntEverChanged;
        }

        public void setRamntEverChanged(boolean changed) {
            this.ramntEverChanged = changed;
        }

        public boolean getRamntEverChanged() {
            return this.ramntEverChanged;
        }
    }

    static class CfEntryData {
        private TemplateVoucherEntryInfo entry;
        private Vector oppEntries;

        public CfEntryData(TemplateVoucherEntryInfo ent) {
            this.entry = ent;
            this.oppEntries = new Vector();
        }

        public CfEntryData(TemplateVoucherEntryInfo ent, Vector oe) {
            this.entry = ent;
            this.oppEntries = oe;
        }

        public void setEntry(TemplateVoucherEntryInfo ent) {
            this.entry = ent;
        }

        public TemplateVoucherEntryInfo getEntry() {
            return this.entry;
        }

        public void setOppEntries(Vector oe) {
            this.oppEntries = oe;
        }

        public Vector getOppEntries() {
            return this.oppEntries;
        }
    }

    class CfOppEntrySwitchListener
    implements KDTActiveCellListener {
        CfOppEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            if (TemplateCashflowEditUI.this.illegalCfOppEntryIndex >= 0) {
                TemplateCashflowEditUI.this.illegalCfOppEntryIndex = -1;
                return;
            }
            int preLine = TemplateCashflowEditUI.this.curCfOppEntryIndex;
            int line = evt.getRowIndex();
            if (preLine != line) {
                CfOppEntryData oe;
                IRow row;
                int rowCount = TemplateCashflowEditUI.this.tblOppEntries.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine >= 0) {
                    row = TemplateCashflowEditUI.this.tblOppEntries.getRow(preLine);
                    oe = (CfOppEntryData)row.getUserObject();
                    TemplateCashflowEditUI.this.storeCfOppEntry(oe, row);
                }
                TemplateCashflowEditUI.this.curCfOppEntryIndex = line;
                if (line >= 0) {
                    row = TemplateCashflowEditUI.this.tblOppEntries.getRow(line);
                    oe = (CfOppEntryData)row.getUserObject();
                    TemplateCashflowEditUI.this.afterSelectCfOppEntry(oe);
                } else {
                    TemplateCashflowEditUI.this.afterSelectCfOppEntry(null);
                }
            }
        }
    }

    class CfEntrySwitchListener
    implements KDTActiveCellListener {
        CfEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            if (TemplateCashflowEditUI.this.illegalCfEntryIndex >= 0) {
                TemplateCashflowEditUI.this.illegalCfEntryIndex = -1;
                return;
            }
            int preLine = TemplateCashflowEditUI.this.curCfEntryIndex;
            int line = evt.getRowIndex();
            if (preLine != line) {
                int rowCount = TemplateCashflowEditUI.this.tblEntries.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine >= 0) {
                    KDTEditManager em = TemplateCashflowEditUI.this.tblOppEntries.getEditManager();
                    if (em.isEditing()) {
                        em.stopEditing();
                    }
                    IRow row = TemplateCashflowEditUI.this.tblEntries.getRow(preLine);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    TemplateCashflowEditUI.this.storeCfEntry(ed, row);
                }
                TemplateCashflowEditUI.this.curCfEntryIndex = line;
                if (line >= 0) {
                    IRow row = TemplateCashflowEditUI.this.tblEntries.getRow(line);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    TemplateCashflowEditUI.this.afterSelectCfEntry(ed);
                } else {
                    TemplateCashflowEditUI.this.afterSelectCfEntry(null);
                }
            }
        }
    }

    class CfFocusListener
    extends KDTFocusChangeAction {
        CfFocusListener(KDTable table, short dirCode, boolean isReverse) {
            super(table, dirCode, isReverse);
        }

        public void actionPerformed(ActionEvent evt) {
            KDTEditManager em = this.table.getEditManager();
            int result = em.stopEditing();
            if (0 != result) {
                return;
            }
            KDTSelectManager sm = this.table.getSelectManager();
            int rowIndex = sm.getActiveRowIndex();
            int colIndex = sm.getActiveColumnIndex();
            int rowCount = this.table.getRowCount();
            int colCount = this.table.getColumnCount();
            if (rowIndex < 0) {
                return;
            }
            if (this.reverse) {
                IRow row = this.table.getRow(rowIndex);
                for (int i = colIndex - 1; i >= 0; --i) {
                    String colKey = this.table.getColumnKey(i);
                    StyleAttributes sa = row.getCell(i).getStyleAttributes();
                    if (sa.isHided() || sa.isLocked() || !TemplateCashflowEditUI.this.isCellEditable(row, colKey)) continue;
                    sm.removeAll(false);
                    em.editCellAt(rowIndex, i);
                    return;
                }
                sm.removeAll(false);
                em.editCellAt(rowIndex, colIndex);
            } else {
                int nextRowIndex = rowIndex;
                do {
                    sm.removeAll(false);
                    sm.select(nextRowIndex, 0);
                    if (TemplateCashflowEditUI.this.curCfOppEntryIndex != nextRowIndex) {
                        return;
                    }
                    IRow row = this.table.getRow(nextRowIndex);
                    for (int i = colIndex + 1; i < colCount; ++i) {
                        String colKey = this.table.getColumnKey(i);
                        StyleAttributes sa = row.getCell(i).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked() || !TemplateCashflowEditUI.this.isCellEditable(row, colKey)) continue;
                        sm.removeAll(false);
                        em.editCellAt(nextRowIndex, i);
                        return;
                    }
                    String state = TemplateCashflowEditUI.this.getOprtState();
                    if (nextRowIndex == rowCount - 1 && !OprtState.VIEW.equals(state)) {
                        try {
                            TemplateCashflowEditUI.this.actionAddLine_actionPerformed(null);
                            if (TemplateCashflowEditUI.this.curCfOppEntryIndex != rowCount) {
                                return;
                            }
                            ++rowCount;
                        }
                        catch (Exception ex) {
                            TemplateCashflowEditUI.this.handUIException(ex);
                            return;
                        }
                    }
                    colIndex = -1;
                } while (++nextRowIndex < rowCount);
                if (nextRowIndex == rowCount) {
                    sm.removeAll(false);
                    em.editCellAt(rowIndex, colIndex);
                }
            }
        }
    }

    class CfExitListener
    extends KDTFocusChangeAction {
        CfExitListener(KDTable table, short dirCode, boolean isReverse) {
            super(table, dirCode, isReverse);
        }

        public void actionPerformed(ActionEvent evt) {
            KDTEditManager em = TemplateCashflowEditUI.this.tblOppEntries.getEditManager();
            int result = em.stopEditing();
            if (0 != result) {
                return;
            }
            int entryCount = TemplateCashflowEditUI.this.tblEntries.getRowCount();
            if (TemplateCashflowEditUI.this.curCfEntryIndex < entryCount - 1) {
                KDTSelectManager smEntries = TemplateCashflowEditUI.this.tblEntries.getSelectManager();
                smEntries.removeAll(false);
                smEntries.select(TemplateCashflowEditUI.this.curCfEntryIndex + 1, 0);
                int rowCount = TemplateCashflowEditUI.this.tblOppEntries.getRowCount();
                int colCount = TemplateCashflowEditUI.this.tblOppEntries.getColumnCount();
                KDTSelectManager sm = TemplateCashflowEditUI.this.tblOppEntries.getSelectManager();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        IRow row = TemplateCashflowEditUI.this.tblOppEntries.getRow(i);
                        String colKey = TemplateCashflowEditUI.this.tblOppEntries.getColumnKey(j);
                        StyleAttributes sa = row.getCell(j).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked() || !TemplateCashflowEditUI.this.isCellEditable(row, colKey)) continue;
                        sm.removeAll(false);
                        em.editCellAt(i, j);
                        return;
                    }
                }
            }
        }
    }

    class CfOppEntryEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        CfOppEntryEditAdapter() {
        }

        public void editStarting(KDTEditEvent evt) {
            String colKey;
            if (evt.getRowIndex() != TemplateCashflowEditUI.this.curCfOppEntryIndex) {
                evt.setCancel(true);
                return;
            }
            IRow curRow = TemplateCashflowEditUI.this.tblOppEntries.getRow(evt.getRowIndex());
            if (!TemplateCashflowEditUI.this.isCellEditable(curRow, colKey = TemplateCashflowEditUI.this.tblOppEntries.getColumnKey(evt.getColIndex()))) {
                evt.setCancel(true);
                return;
            }
            super.editStarting(evt);
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            this.oldValue = table.getRow(rowIndex).getCell(colIndex).getValue();
            String colKey2 = table.getColumnKey(colIndex);
            ICellEditor editor = table.getEditManager().getEditor();
            Component component = editor.getComponent();
            if (editor == TemplateCashflowEditUI.this.numberEditor) {
                KDFormattedTextField numberField = (KDFormattedTextField)TemplateCashflowEditUI.this.numberEditor.getComponent();
                if (TemplateCashflowEditUI.CF_OPP_AMNT.equals(colKey2)) {
                    int prec = TemplateCashflowEditUI.this.getOriginalCurrency(TemplateCashflowEditUI.this.curCfEntryIndex).getPrecision();
                    numberField.setPrecision(prec);
                } else if (TemplateCashflowEditUI.CF_OPP_LA.equals(colKey2)) {
                    numberField.setPrecision(TemplateCashflowEditUI.this.localCurrency.getPrecision());
                } else if (TemplateCashflowEditUI.CF_OPP_RA.equals(colKey2)) {
                    numberField.setPrecision(TemplateCashflowEditUI.this.reportingCurrency.getPrecision());
                }
            } else if (component instanceof KDBizPromptBox) {
                KDBizPromptBox bizPromptBox = (KDBizPromptBox)component;
                if (TemplateCashflowEditUI.CF_OPP_PI.equals(colKey2)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    FilterItemCollection fic = filter.getFilterItems();
                    fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.MASTER_TABLE_ITEM.getValue())));
                    fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("direction", (Object)new Integer(0), CompareType.NOTEQUALS));
                    fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
                    CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPromptBox, (FilterInfo)filter, (CoreUIObject)TemplateCashflowEditUI.this);
                    filter.setMaskString("#0 AND #1 AND #2 AND #3 and #4");
                    bizPromptBox.setEntityViewInfo(view);
                } else if (TemplateCashflowEditUI.CF_OPP_SI.equals(colKey2)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    FilterItemCollection fic = filter.getFilterItems();
                    fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.SECONDARY_TABLE_ITEM.getValue())));
                    fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
                    CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPromptBox, (FilterInfo)filter, (CoreUIObject)TemplateCashflowEditUI.this);
                    filter.setMaskString("#0 AND #1 AND #2 and #3");
                    bizPromptBox.setEntityViewInfo(view);
                }
            }
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getValue();
            if (!GlUtils.isEqual(newValue, oldValue)) {
                KDTable table = (KDTable)evt.getSource();
                int row = evt.getRowIndex();
                int col = evt.getColIndex();
                String colKey = table.getColumnKey(col);
                IRow curRow = table.getRow(row);
                CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
                int index = TemplateCashflowEditUI.this.tblEntries.getSelectManager().get().getTop();
                if (!TemplateCashflowEditUI.this.isPiEdited || !TemplateCashflowEditUI.this.isSiEdited) {
                    String acctid = oe.getOppEntry().getAccount().getId().toString();
                    if (!TemplateCashflowEditUI.this.isPiEdited && TemplateCashflowEditUI.CF_OPP_PI.equals(colKey)) {
                        TemplateCashflowEditUI.this.piItem = (CashFlowItemInfo)newValue;
                        TemplateCashflowEditUI.this.construtsEntries(TemplateCashflowEditUI.this.piItem, colKey, oe.getOppEntry());
                        TemplateCashflowEditUI.this.isPiEdited = true;
                        TemplateCashflowEditUI.this.piEditedMap.put(acctid, TemplateCashflowEditUI.this.piItem.getId().toString());
                    }
                    if (!TemplateCashflowEditUI.this.isSiEdited && TemplateCashflowEditUI.CF_OPP_SI.equals(colKey)) {
                        TemplateCashflowEditUI.this.siItem = (CashFlowItemInfo)newValue;
                        TemplateCashflowEditUI.this.siEditedMap.put(acctid, TemplateCashflowEditUI.this.siItem.getId().toString());
                        TemplateCashflowEditUI.this.construtsEntries(TemplateCashflowEditUI.this.siItem, colKey, oe.getOppEntry());
                        TemplateCashflowEditUI.this.isSiEdited = true;
                    }
                }
                if (TemplateCashflowEditUI.CF_OPP_PI.equals(colKey)) {
                    CashFlowItemInfo olditem = (CashFlowItemInfo)oldValue;
                    CashFlowItemInfo newitem = (CashFlowItemInfo)newValue;
                    if (olditem != null) {
                        if (newitem != null && !olditem.getDirection().equals((Object)newitem.getDirection()) && curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT).getValue() != null) {
                            BigDecimal amnt = (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT).getValue();
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT).setValue((Object)amnt.multiply(GlUtils.negone));
                            BigDecimal lamnt = (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).getValue();
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).setValue((Object)lamnt.multiply(GlUtils.negone));
                            BigDecimal ramnt = null;
                            ramnt = TemplateCashflowEditUI.this.useReportingCurrency ? (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).getValue() : lamnt;
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).setValue((Object)ramnt.multiply(GlUtils.negone));
                        }
                    } else {
                        BigDecimal amnt;
                        IRow cfEntryRow = TemplateCashflowEditUI.this.tblEntries.getRow(TemplateCashflowEditUI.this.curCfEntryIndex);
                        TemplateVoucherEntryInfo entry = ((CfVoucherEntryWrapper)cfEntryRow.getCell(TemplateCashflowEditUI.CF_ENTRY).getValue()).getEntry();
                        BigDecimal coefficient = GlUtils.one;
                        if (newitem.getDirection().equals((Object)CashFlowDirection.OUT)) {
                            coefficient = coefficient.multiply(GlUtils.negone);
                        }
                        if ((amnt = (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT).getValue()) != null) {
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT).setValue((Object)amnt.multiply(coefficient));
                            BigDecimal lamnt = (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).getValue();
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).setValue((Object)lamnt.multiply(coefficient));
                            BigDecimal ramnt = null;
                            ramnt = TemplateCashflowEditUI.this.useReportingCurrency ? (BigDecimal)curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).getValue() : lamnt;
                            curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).setValue((Object)ramnt.multiply(coefficient));
                        }
                    }
                }
                if (TemplateCashflowEditUI.CF_OPP_ENTRY.equals(colKey) || TemplateCashflowEditUI.CF_OPP_PI.equals(colKey)) {
                    if (!TemplateCashflowEditUI.this.isCellEditable(curRow, TemplateCashflowEditUI.CF_OPP_SI)) {
                        curRow.getCell(TemplateCashflowEditUI.CF_OPP_SI).setValue(null);
                    }
                } else if (TemplateCashflowEditUI.CF_OPP_AMNT.equals(colKey)) {
                    oe.setAmntEverChanged(true);
                    if (newValue == null) {
                        curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).setValue(null);
                        curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).setValue(null);
                    } else {
                        VoucherInfo.ExchangeRateWithValue lexObj = TemplateCashflowEditUI.this.getLocalExDefinition(TemplateCashflowEditUI.this.curCfEntryIndex);
                        VoucherInfo.ExchangeRateWithValue rexObj = TemplateCashflowEditUI.this.getReportingExDefinition(TemplateCashflowEditUI.this.curCfEntryIndex);
                        BigDecimal lex = TemplateCashflowEditUI.this.getLocalExValue(TemplateCashflowEditUI.this.curCfEntryIndex);
                        BigDecimal rex = TemplateCashflowEditUI.this.getReportingExValue(TemplateCashflowEditUI.this.curCfEntryIndex);
                        BigDecimal la = null;
                        BigDecimal ra = null;
                        BigDecimal amnt = (BigDecimal)newValue;
                        la = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)lexObj.getConvertMode()) ? amnt.multiply(lex).setScale(TemplateCashflowEditUI.this.localCurrency.getPrecision(), TemplateCashflowEditUI.this.amountRoundMode) : amnt.divide(lex, TemplateCashflowEditUI.this.localCurrency.getPrecision(), TemplateCashflowEditUI.this.amountRoundMode);
                        ra = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rexObj.getConvertMode()) ? amnt.multiply(rex).setScale(TemplateCashflowEditUI.this.reportingCurrency.getPrecision(), TemplateCashflowEditUI.this.amountRoundMode) : amnt.divide(rex, TemplateCashflowEditUI.this.reportingCurrency.getPrecision(), TemplateCashflowEditUI.this.amountRoundMode);
                        curRow.getCell(TemplateCashflowEditUI.CF_OPP_LA).setValue((Object)la);
                        curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA).setValue((Object)ra);
                    }
                } else if (TemplateCashflowEditUI.CF_OPP_RA.equals(colKey)) {
                    oe.setRamntEverChanged(true);
                } else if (TemplateCashflowEditUI.CF_OPP_LA.equals(colKey)) {
                    ICell raCell;
                    CurrencyInfo cur = TemplateCashflowEditUI.this.getOriginalCurrency(TemplateCashflowEditUI.this.curCfEntryIndex);
                    ICell amntCell = curRow.getCell(TemplateCashflowEditUI.CF_OPP_AMNT);
                    if ((amntCell.getValue() == null || !oe.getAmntEverChanged()) && GlUtils.isEqual(cur, TemplateCashflowEditUI.this.localCurrency)) {
                        amntCell.setValue(newValue);
                    }
                    if (((raCell = curRow.getCell(TemplateCashflowEditUI.CF_OPP_RA)).getValue() == null || !oe.getRamntEverChanged()) && GlUtils.isEqual(cur, TemplateCashflowEditUI.this.reportingCurrency)) {
                        raCell.setValue(newValue);
                    }
                }
            }
        }
    }
}

