/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ITemplateCashflowRecord;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordCollection;
import com.kingdee.eas.fi.gl.TemplateCashflowRecordFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherAsstRecordInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryCollection;
import com.kingdee.eas.fi.gl.TemplateVoucherEntryInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherGroupFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherGroupInfo;
import com.kingdee.eas.fi.gl.TemplateVoucherImpFacadeFactory;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.client.AbstractTemplateVoucherListUI;
import com.kingdee.eas.fi.gl.client.TemplateVoucherEditUI;
import com.kingdee.eas.fi.gl.client.TemplateVoucherGroupEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.validator.AssistCuSuStatusValidator;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TemplateVoucherListUI
extends AbstractTemplateVoucherListUI {
    private static final long serialVersionUID = 3901289123843164833L;
    private static final Logger logger = CoreUIObject.getLogger(TemplateVoucherListUI.class);
    String resClassName = "com.kingdee.eas.fi.gl.TemplateVoucherRes";
    public static final String VOUCHER_IMPORT = "VOUCHER_IMPORT";
    protected CompanyOrgUnitInfo currentCompany = null;
    protected TemplateVoucherInfo vch = null;
    protected int returnValue = 1;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog dialog = null;
    protected boolean useGovAccSystem = false;
    protected boolean isVoucherEditUIImport = false;

    public TemplateVoucherListUI() throws Exception {
        this.setUITitle(EASResource.getString((String)this.resClassName, (String)"TemplateVoucherList"));
    }

    public void onLoad() throws Exception {
        Map ctx = this.getUIContext();
        CompanyOrgUnitInfo vchCompany = (CompanyOrgUnitInfo)ctx.get("COMPANY");
        if (vchCompany != null) {
            this.isVoucherEditUIImport = true;
        }
        if (!this.isVoucherEditUIImport) {
            this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("CurrentCompany");
            if (this.currentCompany == null) {
                this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            }
        } else {
            this.currentCompany = vchCompany;
        }
        RptClientUtil.checkFIUnit(ctx, this.currentCompany, false);
        String str = ParamControlFactory.getRemoteInstance().getParamValue(null, AccountConstant.GovermentAccountingSystem);
        try {
            this.useGovAccSystem = Boolean.valueOf(str);
            if (this.useGovAccSystem) {
                TemplateVoucherGroupFactory.getRemoteInstance().preset(this.currentCompany);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onLoad();
        this.isFirstDefaultQuery = false;
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        String voucherImp = (String)ctx.get(VOUCHER_IMPORT);
        if (voucherImp != null) {
            this.toolBar.setVisible(false);
            this.btnGroupAddNew.setVisible(false);
            this.btnGroupEdit.setVisible(false);
            this.btnGroupMoveTree.setVisible(false);
            this.btnGroupRemove.setVisible(false);
            this.btnGroupView.setVisible(false);
            this.setUIToolBar(null);
            this.kbConfirm.setVisible(true);
            this.kbCancel.setVisible(true);
            this.setPreferredSize(new Dimension(800, 480));
        }
        if (this.currentCompany == null && !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        this.getMainStatusBar().setPerTitle(GlUtils.getSysStatusBarTitle(this.currentCompany));
        this.menuEdit.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow wnd = fy.create("com.kingdee.eas.fi.gl.client.HGRepairToolUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.currentCompany != null) {
            return new ObjectUuidPK(this.currentCompany.getId());
        }
        return super.getOrgPK(action);
    }

    @Override
    public void loadFields() {
        Map ctx = this.getUIContext();
        String voucherImp = (String)ctx.get(VOUCHER_IMPORT);
        if (voucherImp != null) {
            this.pnlMain.setBounds(new Rectangle(10, 10, 996, 584));
            this.add((Component)this.pnlMain, new KDLayout.Constraints(10, 10, 996, 584, 15));
        } else {
            super.loadFields();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.vch = this.getVoucher();
        this.setResult(this.vch);
        this.setReturnValue(0);
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setResult(null);
        this.setReturnValue(1);
        this.destroyWindow();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        if (this.useGovAccSystem && this.tblMain.getSelectManager().get() != null && e.getTargetTreeBaseInfo() != null && e.getTargetTreeBaseInfo() instanceof TemplateVoucherGroupInfo) {
            TemplateVoucherGroupInfo targetGroup = (TemplateVoucherGroupInfo)e.getTargetTreeBaseInfo();
            EntityViewInfo view = new EntityViewInfo();
            ArrayList selectList = this.getSelectedIdValues();
            HashSet ids = new HashSet();
            ids.addAll(selectList);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("category", (Object)targetGroup.getCategory().getValue(), CompareType.NOTEQUALS));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            view.setSelector(selector);
            try {
                TemplateVoucherCollection coll = TemplateVoucherFactory.getRemoteInstance().getTemplateVoucherCollection(view);
                if (coll.size() > 0) {
                    StringBuffer numbers = new StringBuffer();
                    for (int i = 0; i < coll.size() && i < 3; ++i) {
                        numbers.append(coll.get(i).getNumber()).append(",");
                    }
                    if (coll.size() < 3) {
                        numbers.deleteCharAt(numbers.length() - 1);
                    } else {
                        numbers.append("...");
                    }
                    throw new GLException(GLException.TEMVCH_CATEGORY_NOTEQUAL, new String[]{numbers.toString()});
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
                super.abort();
            }
        }
        super.moveTreeNode(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"COMPANY", (Object)this.currentCompany);
        uiContext.put((Object)"AccountTable", (Object)this.currentCompany.getAccountTable());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.TemplateVoucherImpWizardUI", (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        this.refresh(e);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    protected boolean canMoveDetailToRoot() {
        return true;
    }

    protected String getRootName() {
        return EASResource.getString((String)this.resClassName, (String)"TemplateVoucherGroup");
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            TemplateVoucherInfo treeInfo = (TemplateVoucherInfo)this.getBizInterface().getValue((IObjectPK)detail);
            if (treeInfo != null && treeInfo.getTemplateVoucherGroup() != null) {
                ObjectUuidPK tree = new ObjectUuidPK(treeInfo.getTemplateVoucherGroup().getId());
                return tree;
            }
            return null;
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getGroupEditUIName() {
        return TemplateVoucherGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "templateVoucherGroup.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TemplateVoucherGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return TemplateVoucherEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TemplateVoucherFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getSelectDetailTreeName() {
        return "templateVoucherGroup";
    }

    private TemplateVoucherInfo getVoucher() throws Exception {
        TemplateVoucherInfo info = null;
        KDTSelectManager sm = this.tblMain.getSelectManager();
        if (sm == null || sm.get() == null) {
            return null;
        }
        int index = this.tblMain.getSelectManager().get().getTop();
        if (index == -1) {
            return null;
        }
        int keyField = this.tblMain.getColumnIndex(this.getKeyFieldName());
        String temVchid = (String)this.tblMain.getRow(index).getCell(keyField).getValue();
        ObjectUuidPK pk = new ObjectUuidPK(temVchid);
        info = (TemplateVoucherInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.checkAssFreezed(info);
        this.lazyLoadCashflow(info);
        return info;
    }

    private void checkAssFreezed(TemplateVoucherInfo info) {
        TemplateVoucherEntryCollection entryCollection = info.getEntries();
        int result = 0;
        int size = entryCollection.size();
        block2: for (int i = 0; i < size && result != 1; ++i) {
            TemplateVoucherEntryInfo entry = entryCollection.get(i);
            TemplateVoucherAsstRecordCollection asstRecordCollection = entry.getAssistRecords();
            int asstSize = asstRecordCollection.size();
            for (int j = 0; j < asstSize; ++j) {
                TemplateVoucherAsstRecordInfo asstRecordInfo = asstRecordCollection.get(j);
                AssistantHGInfo assGrp = asstRecordInfo.getAssGrp();
                if (assGrp == null) continue;
                AssistCuSuStatusValidator cusuValidator = null;
                try {
                    assGrp = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)assGrp.get("id").toString())));
                }
                catch (Exception e1) {
                    logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"369_TemplateVoucherListUI"), (Throwable)e1);
                }
                if (assGrp.get("customer") != null) {
                    ObjectBaseInfo customerDBInfo = (ObjectBaseInfo)assGrp.get("customer");
                    if (cusuValidator == null) {
                        cusuValidator = new AssistCuSuStatusValidator(null);
                    }
                    if ((result = cusuValidator.validator(customerDBInfo.getString("id"), this.currentCompany.getId().toString(), 0)) == 1) {
                        MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"asstFreezed"));
                        SysUtil.abort();
                        continue block2;
                    }
                }
                if (assGrp.get("provider") == null) continue;
                ObjectBaseInfo prividerDBInfo = (ObjectBaseInfo)assGrp.get("provider");
                if (cusuValidator == null) {
                    cusuValidator = new AssistCuSuStatusValidator(null);
                }
                if ((result = cusuValidator.validator(prividerDBInfo.getString("id"), this.currentCompany.getId().toString(), 1)) != 1) continue;
                MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"asstFreezed"));
                SysUtil.abort();
                continue block2;
            }
        }
    }

    protected void lazyLoadCashflow(TemplateVoucherInfo editData) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)editData.getId().toString()));
        TemplateCashflowRecordCollection cfCol = null;
        try {
            ITemplateCashflowRecord recCtrl = TemplateCashflowRecordFactory.getRemoteInstance();
            cfCol = recCtrl.getTemplateCashflowRecordCollection(view);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        editData.setCashflowRecords(cfCol);
    }

    protected String getEditUIModal() {
        return TemplateVoucherEditUI.getEditUIMode((CoreUIObject)this);
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getItemActionFromActionEvent(e);
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
        if (!action.equals(this.actionGroupAddNew) && !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
    }

    protected ItemAction getItemActionFromActionEvent(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof AbstractButton) {
            IItemAction act = (IItemAction)((AbstractButton)obj).getAction();
            ItemAction action = act.getItemAction();
            return action;
        }
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    public void setResult(TemplateVoucherInfo cf) {
        this.vch = cf;
    }

    public TemplateVoucherInfo getResult() {
        return this.vch;
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    protected FilterInfo getDefaultFilterForTree() {
        Map ctx;
        VoucherCategoryEnum category;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        if (this.useGovAccSystem && this.isVoucherEditUIImport && (VoucherCategoryEnum.FINANCE.equals((Object)(category = (VoucherCategoryEnum)((Object)(ctx = this.getUIContext()).get("voucherCategory")))) || VoucherCategoryEnum.BUDGET.equals((Object)category))) {
            fic.add(new FilterItemInfo("category", (Object)category.getValue()));
        }
        return filter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Map ctx;
        VoucherCategoryEnum category;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        if (this.useGovAccSystem && this.isVoucherEditUIImport && (VoucherCategoryEnum.FINANCE.equals((Object)(category = (VoucherCategoryEnum)((Object)(ctx = this.getUIContext()).get("voucherCategory")))) || VoucherCategoryEnum.BUDGET.equals((Object)category))) {
            fic.add(new FilterItemInfo("category", (Object)category.getValue()));
        }
        return filter;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected void buildTreeFilter() {
        super.buildTreeFilter();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"COMPANY", (Object)this.currentCompany);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        String filePath = this.getFilePath();
        if (StringUtils.isEmpty((String)filePath)) {
            return;
        }
        FileOutputStream fos = null;
        ByteArrayInputStream byis = null;
        try {
            fos = new FileOutputStream(new File(filePath));
            byte[] bytes = TemplateVoucherImpFacadeFactory.getRemoteInstance().exportTemplate("templateVchData");
            byis = new ByteArrayInputStream(bytes);
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)byis);
            wb.write((OutputStream)fos);
            fos.flush();
            if (filePath != null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"templatefilepath", (Object[])new Object[]{filePath}));
            }
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"exporttemplatefilefail", (Object[])new Object[]{e1.getMessage()}));
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected String getFilePath() {
        String defFileName = EASResource.getString((String)"com.kingdee.eas.fi.gl.VoucherImpWizardUI", (String)"TempVchExpTitle");
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName(defFileName);
        fselector.show();
        if (fselector.isCanceled()) {
            return null;
        }
        return fselector.getData().toString();
    }
}

