/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CreateVoucherModeEnum;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.ITransPLFacade;
import com.kingdee.eas.fi.gl.ITransPLProgram;
import com.kingdee.eas.fi.gl.PLAccountRangeEnum;
import com.kingdee.eas.fi.gl.PL_VoucherDataEnum;
import com.kingdee.eas.fi.gl.TransPLFacadeFactory;
import com.kingdee.eas.fi.gl.TransPLProgramAsstAccountInfo;
import com.kingdee.eas.fi.gl.TransPLProgramEntryCollection;
import com.kingdee.eas.fi.gl.TransPLProgramEntryInfo;
import com.kingdee.eas.fi.gl.TransPLProgramFactory;
import com.kingdee.eas.fi.gl.TransPLProgramInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.VoucherTransPeriodEnum;
import com.kingdee.eas.fi.gl.client.AbstractTransPLProgramEditUI;
import com.kingdee.eas.fi.gl.client.GLEditUIUtil;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TransPLProgramEditUI
extends AbstractTransPLProgramEditUI
implements IMultiOrgSupport {
    private static final long serialVersionUID = -6194044739633471963L;
    private static final Logger logger = CoreUIObject.getLogger(TransPLProgramEditUI.class);
    private static final String PermissionItem = "gl_transPnL";
    public static final String CWGXRESOURCE = "com.kingdee.eas.fi.gl.client.CWGXResource";
    private static final String COLUMN_ISSELECT = "IsSelected";
    private static final String COLUMN_ACCTID = "accountView";
    private static final String COLUMN_ACCTNUMBER = "accountNumber";
    private static final String COLUMN_ACCTNAME = "accountViewName";
    private static final String COLUMN_SELECT = "select";
    private static final String COLUMN_AsstType = "asstType";
    private static final String COLUMN_AsstNumberFrom = "asstNumberFrom";
    private static final String COLUMN_AsstasstNumberTo = "asstasstNumberTo";
    protected Map<String, Map> initDataMap;
    protected CompanyOrgUnitInfo vchCompany;
    private GLPeriodEndFilter filter;
    private Map initData;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    protected ChangeListener rdAllPLAccount_changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                TransPLProgramEditUI.this.rdAllPLAccount_stateChanged(e);
            }
            catch (Exception exc) {
                TransPLProgramEditUI.this.handUIException(exc);
            }
        }
    };
    protected ChangeListener rdByAsstAccount_changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                TransPLProgramEditUI.this.rdByAsstAccount_stateChanged(e);
            }
            catch (Exception exc) {
                TransPLProgramEditUI.this.handUIException(exc);
            }
        }
    };
    protected FilterInfo filterVT = null;
    protected VoucherTypeCollection voucherTypeCol = null;
    private boolean isSelect = true;
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private Map<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
    private Map<String, AsstActTypeCollection> cAACache = new HashMap<String, AsstActTypeCollection>();
    private DefaultF7ContextManager F7ContextManager = null;

    public void onLoad() throws Exception {
        this.kdtAsstAccounts.checkParsed();
        this.rdByAsstAccount.addChangeListener(this.rdByAsstAccount_changeListener);
        this.initCompany();
        super.onLoad();
        this.initCompanyF7();
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.prmtYearProfitAcct.setEditFormat("$number$");
        this.prmtYearProfitAcct.setCommitFormat("$number$");
        this.prmtYearProfitAcct.setCommitParser((IParser)new AccountViewParser(this.prmtYearProfitAcct));
        this.prmtYearProfitAcct.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherAccountQuery");
        this.prmtYearProfitAcct.setSelectorCollection(this.getAccountSelector());
        if (!this.chkIsSplit.isSelected()) {
            this.kdSpSplitSize.setEnabled(false);
        }
        this.chkIsSplit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (TransPLProgramEditUI.this.chkIsSplit.isSelected() && (Integer)TransPLProgramEditUI.this.kdSpSplitSize.getValue() == 0) {
                    TransPLProgramEditUI.this.kdSpSplitSize.setValue((Object)100);
                } else if (TransPLProgramEditUI.this.chkIsSplit.isSelected()) {
                    TransPLProgramEditUI.this.kdSpSplitSize.setEnabled(true);
                } else {
                    TransPLProgramEditUI.this.kdSpSplitSize.setEnabled(false);
                }
            }
        });
        this.kdSpSplitSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)TransPLProgramEditUI.this.kdSpSplitSize.getValue() < 100) {
                    TransPLProgramEditUI.this.kdSpSplitSize.setValue((Object)100);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setIncludeNoPostVoucher(this.chkIncludeNoPostVoucher.isSelected());
        this.editData.setYearProfitAcct((AccountViewInfo)this.prmtYearProfitAcct.getValue());
        Object voucherType = this.cbxVoucherType.getSelectedItem();
        this.editData.setVoucherType((VoucherTypeInfo)voucherType);
        Object voucherStatus = this.cbxVoucherStatus.getSelectedItem();
        this.editData.setVoucherStatus((VoucherStatusEnum)voucherStatus);
        if (this.rdAllPLAccount.isSelected()) {
            this.editData.setPLAccountRange(PLAccountRangeEnum.ALLPLACCOUNT);
        } else if (this.rdSpecifyPLAccount.isSelected()) {
            this.editData.setPLAccountRange(PLAccountRangeEnum.SPECIFYPLACCOUNT);
        }
        this.editData.getEntries().clear();
        IRow row1 = null;
        int i = 1;
        int size = this.kdtEntries.getRowCount();
        while (size - i >= 0) {
            row1 = this.kdtEntries.getRow(size - i);
            Boolean isSelect = (Boolean)row1.getCell(COLUMN_ISSELECT).getValue();
            if (isSelect.booleanValue()) {
                TransPLProgramEntryInfo entryInfo = new TransPLProgramEntryInfo();
                entryInfo.setParent(this.editData);
                entryInfo.setAccountView((AccountViewInfo)row1.getCell(COLUMN_ACCTID).getValue());
                this.editData.getEntries().add(entryInfo);
            }
            ++i;
        }
        if (this.rdCurperiod.isSelected()) {
            this.editData.setVoucherTransPeriod(VoucherTransPeriodEnum.CURPERIOD);
        } else if (this.rdAloneTrans.isSelected()) {
            this.editData.setVoucherTransPeriod(VoucherTransPeriodEnum.ALONETRANS);
        }
        if (this.rdByCommonMode.isSelected()) {
            this.editData.setCreateVoucherMode(CreateVoucherModeEnum.COMMONMODE);
        } else if (this.rdByAsstAccount.isSelected()) {
            this.editData.setCreateVoucherMode(CreateVoucherModeEnum.ASSTACCOUNT);
            this.editData.getAsstAccounts().clear();
            String accTypeNumberFrom = null;
            String accTypeNumberTo = null;
            TransPLProgramAsstAccountInfo programAsstAccountInfo = null;
            IRow row = null;
            int size2 = this.kdtAsstAccounts.getRowCount();
            for (int i2 = 0; i2 < size2; ++i2) {
                row = this.kdtAsstAccounts.getRow(i2);
                programAsstAccountInfo = new TransPLProgramAsstAccountInfo();
                Boolean isSelect = (Boolean)row.getCell(COLUMN_SELECT).getValue();
                if (isSelect.booleanValue()) {
                    AsstActTypeInfo asstActInfo = (AsstActTypeInfo)row.getCell(COLUMN_AsstType).getValue();
                    accTypeNumberFrom = this.getNumber(row.getCell(COLUMN_AsstNumberFrom).getValue(), asstActInfo.isUseLongNumber());
                    accTypeNumberTo = this.getNumber(row.getCell(COLUMN_AsstasstNumberTo).getValue(), asstActInfo.isUseLongNumber());
                    if (accTypeNumberFrom == null) {
                        accTypeNumberFrom = "";
                    }
                    if (accTypeNumberTo == null) {
                        accTypeNumberTo = "";
                    }
                    programAsstAccountInfo.setAsstAccount(asstActInfo);
                    programAsstAccountInfo.setAcctTypeNumberFromTo(accTypeNumberFrom);
                    programAsstAccountInfo.put("fromObject", row.getCell(COLUMN_AsstNumberFrom).getValue());
                    programAsstAccountInfo.setActTypeNumberTo(accTypeNumberTo);
                    programAsstAccountInfo.put("toObject", row.getCell(COLUMN_AsstasstNumberTo).getValue());
                    programAsstAccountInfo.setParent(this.editData);
                    this.editData.getAsstAccounts().add(programAsstAccountInfo);
                    continue;
                }
                accTypeNumberFrom = null;
                accTypeNumberTo = null;
            }
        }
        this.editData.setIsSplit(this.chkIsSplit.isSelected());
        this.editData.setSplitSize((Integer)this.kdSpSplitSize.getValue());
    }

    protected ITransPLProgram getBizInterface() throws Exception {
        return TransPLProgramFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TransPLProgramInfo transPLProgramInfo = new TransPLProgramInfo();
        transPLProgramInfo.setCompany(this.vchCompany);
        transPLProgramInfo.setPLAccountRange(PLAccountRangeEnum.ALLPLACCOUNT);
        transPLProgramInfo.setVoucherDate(PL_VoucherDataEnum.PERIOD_END);
        transPLProgramInfo.setVoucherTransPeriod(VoucherTransPeriodEnum.CURPERIOD);
        transPLProgramInfo.setCreateVoucherMode(CreateVoucherModeEnum.COMMONMODE);
        transPLProgramInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        transPLProgramInfo.setVDescription(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"370_TransPLProgramEditUI"));
        transPLProgramInfo.setYearProfitByOriginal(true);
        return transPLProgramInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table == this.kdtEntries) {
            TransPLProgramEntryInfo programEntryInfo = new TransPLProgramEntryInfo();
            return programEntryInfo;
        }
        if (table == this.kdtAsstAccounts) {
            TransPLProgramAsstAccountInfo asstAccountInfo = new TransPLProgramAsstAccountInfo();
            return asstAccountInfo;
        }
        return new TransPLProgramEntryInfo();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    public void loadFields() {
        int i;
        this.rdAllPLAccount.removeChangeListener(this.rdAllPLAccount_changeListener);
        super.loadFields();
        if (this.editData.getVoucherType() != null) {
            GlUtils.setSelectedItem(this.cbxVoucherType, (CoreBaseInfo)this.editData.getVoucherType());
        }
        if (this.editData.getVoucherStatus() == null) {
            this.cbxVoucherStatus.setSelectedItem((Object)VoucherStatusEnum.TEMP);
        } else {
            this.cbxVoucherStatus.setSelectedItem((Object)this.editData.getVoucherStatus());
        }
        if (this.editData.getYearProfitAcct() != null) {
            this.prmtYearProfitAcct.setData((Object)this.editData.getYearProfitAcct());
        }
        if (PLAccountRangeEnum.ALLPLACCOUNT.equals((Object)this.editData.getPLAccountRange())) {
            int size = this.kdtEntries.getRowCount();
            for (int i2 = 0; i2 < size; ++i2) {
                this.kdtEntries.getRow(i2).getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
        } else {
            int j;
            int size = this.kdtEntries.getRowCount();
            for (int i3 = 0; i3 < size; ++i3) {
                this.kdtEntries.getRow(i3).getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
            TransPLProgramEntryCollection entryColl = this.editData.getEntries();
            HashSet<String> rptCurIDSet = new HashSet<String>();
            if (entryColl != null && entryColl.size() > 0) {
                j = entryColl.size();
                for (i = 0; i < j; ++i) {
                    rptCurIDSet.add(entryColl.get(i).getAccountView().getId().toString());
                }
            }
            j = this.kdtEntries.getRowCount();
            for (i = 0; i < j; ++i) {
                AccountViewInfo rowAcc = (AccountViewInfo)this.kdtEntries.getRow(i).getCell(COLUMN_ACCTID).getValue();
                if (rptCurIDSet.contains(rowAcc.getId().toString())) continue;
                this.kdtEntries.getRow(i).getCell(COLUMN_ISSELECT).setValue((Object)Boolean.FALSE);
            }
        }
        if (PLAccountRangeEnum.SPECIFYPLACCOUNT.equals((Object)this.editData.getPLAccountRange())) {
            this.rdSpecifyPLAccount.setSelected(true);
            this.rdAllPLAccount.setSelected(false);
        } else {
            this.rdAllPLAccount.setSelected(true);
            this.btnSelectAll.setEnabled(false);
            this.btnUnSelectAll.setEnabled(false);
            this.rdSpecifyPLAccount.setSelected(false);
            this.kdtEntries.getColumn(COLUMN_ISSELECT).getStyleAttributes().setLocked(true);
        }
        if (VoucherTransPeriodEnum.CURPERIOD.equals((Object)this.editData.getVoucherTransPeriod())) {
            this.rdCurperiod.setSelected(true);
            this.rdAloneTrans.setSelected(false);
        } else if (VoucherTransPeriodEnum.ALONETRANS.equals((Object)this.editData.getVoucherTransPeriod())) {
            this.rdCurperiod.setSelected(false);
            this.rdAloneTrans.setSelected(true);
        }
        if (CreateVoucherModeEnum.COMMONMODE.equals((Object)this.editData.getCreateVoucherMode())) {
            this.rdByCommonMode.setSelected(true);
            this.rdByAsstAccount.setSelected(false);
        } else if (CreateVoucherModeEnum.ASSTACCOUNT.equals((Object)this.editData.getCreateVoucherMode())) {
            int i4;
            this.rdByCommonMode.setSelected(false);
            this.rdByAsstAccount.setSelected(true);
            if (this.editData.getAsstAccounts() != null && this.editData.getAsstAccounts().size() > 0) {
                HashMap<String, TransPLProgramAsstAccountInfo> assMap = new HashMap<String, TransPLProgramAsstAccountInfo>();
                int j = this.editData.getAsstAccounts().size();
                for (i4 = 0; i4 < j; ++i4) {
                    TransPLProgramAsstAccountInfo assEntryInfo = this.editData.getAsstAccounts().get(i4);
                    assMap.put(assEntryInfo.getAsstAccount().getId().toString(), assEntryInfo);
                }
                int rowCount = this.kdtAsstAccounts.getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    IRow row = this.kdtAsstAccounts.getRow(i);
                    AsstActTypeInfo asstActInfo = (AsstActTypeInfo)row.getCell(COLUMN_AsstType).getValue();
                    if (assMap.containsKey(asstActInfo.getId().toString())) {
                        TransPLProgramAsstAccountInfo assEntryInfo = (TransPLProgramAsstAccountInfo)assMap.get(asstActInfo.getId().toString());
                        row.getCell(COLUMN_SELECT).setValue((Object)true);
                        row.getCell(COLUMN_AsstNumberFrom).setValue(assEntryInfo.get("fromObject"));
                        row.getCell(COLUMN_AsstasstNumberTo).setValue(assEntryInfo.get("toObject"));
                        continue;
                    }
                    row.getCell(COLUMN_SELECT).setValue((Object)false);
                }
            } else {
                int rowCount = this.kdtAsstAccounts.getRowCount();
                for (i4 = 0; i4 < rowCount; ++i4) {
                    IRow row = this.kdtAsstAccounts.getRow(i4);
                    row.getCell(COLUMN_SELECT).setValue((Object)false);
                }
            }
        }
        this.rdAllPLAccount.addChangeListener(this.rdAllPLAccount_changeListener);
        this.chkIncludeNoPostVoucher.setSelected(this.editData.isIncludeNoPostVoucher());
        this.chkIsSplit.setSelected(this.editData.isIsSplit());
        this.kdSpSplitSize.setValue((Object)this.editData.getSplitSize());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected String getAddNewPermItemName() {
        return "";
    }

    protected String getViewPermItemName() {
        return "";
    }

    protected boolean isSupportUnAudit() {
        return false;
    }

    protected String getOnloadPermItemName() {
        return "";
    }

    protected IGLPeriodEndFacade getTransPLBizInterface() throws Exception {
        return GLPeriodEndFacadeFactory.getRemoteInstance();
    }

    protected ITransPLFacade getTransPLFacade() throws Exception {
        return TransPLFacadeFactory.getRemoteInstance();
    }

    protected void fetchInitData(String companyID) throws Exception {
        if (companyID == null) {
            return;
        }
        if (this.initDataMap == null) {
            this.initDataMap = new HashMap<String, Map>();
            this.filter = new GLPeriodEndFilter();
        }
        if (this.initDataMap.get(companyID) != null) {
            this.initData = this.initDataMap.get(companyID);
            this.filter = (GLPeriodEndFilter)this.initData.get("initData");
        } else {
            this.initData = this.getBizInterface().fetchInitData(companyID);
            this.filter = (GLPeriodEndFilter)this.initData.get("initData");
            this.initDataMap.put(companyID, this.initData);
        }
        this.vchCompany = this.filter.getCurCompany();
        this.initPlAccountF7(this.vchCompany);
        this.filterVT = (FilterInfo)this.initData.get("filterVT");
        this.voucherTypeCol = this.getVoucherTypeCollection();
        VoucherTypeInfo vtDefault = this.voucherTypeCol.get(0);
        for (VoucherTypeInfo vt : this.voucherTypeCol) {
            if (!vt.isPretermit()) continue;
            vtDefault = vt;
        }
        this.cbxVoucherType.removeAllItems();
        this.cbxVoucherType.addItems(this.voucherTypeCol.toArray());
        GlUtils.setSelectedItem(this.cbxVoucherType, (CoreBaseInfo)vtDefault);
        this.cbxVoucherStatus.removeAllItems();
        this.cbxVoucherStatus.addItems(new Object[]{VoucherStatusEnum.TEMP, VoucherStatusEnum.SUBMITTED});
        this.cbxVoucherStatus.setSelectedItem((Object)VoucherStatusEnum.TEMP);
        if (this.initData.get("GL_010") != null) {
            this.prmtYearProfitAcct.setValue(this.initData.get("GL_010"));
            if (this.prmtYearProfitAcct.getPreChangeListeners().length == 0) {
                this.prmtYearProfitAcct.addPreChangeListener(new PreChangeListener(){

                    public void preChange(PreChangeEvent e) {
                        AccountViewInfo paramAcct = (AccountViewInfo)TransPLProgramEditUI.this.initData.get("GL_010");
                        AccountViewInfo oldInfo = (AccountViewInfo)e.getOldData();
                        AccountViewInfo newInfo = (AccountViewInfo)e.getData();
                        if (paramAcct != null && oldInfo != null && paramAcct.getId().toString().equals(oldInfo.getId().toString()) && !oldInfo.equals((Object)newInfo)) {
                            int confirm = MsgBox.showConfirm2New((Component)((Object)TransPLProgramEditUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"371_TransPLProgramEditUI"));
                            if (confirm == 0) {
                                e.setResult(1);
                            } else if (confirm == 1) {
                                e.setResult(0);
                            }
                        }
                    }
                });
            }
        }
    }

    private VoucherTypeCollection getVoucherTypeCollection() throws Exception {
        VoucherTypeCollection vtCol = null;
        Context mainOrgContext = this.getMainOrgContext();
        vtCol = this.getCurrentCompany() == null ? VoucherTypeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext).getVoucherTypeCollection() : GlUtils.getVoucherTypeCollection(null, this.filterVT, this.vchCompany.getCU().getId().toString(), mainOrgContext);
        if (vtCol.size() == 0) {
            throw new GLException(GLException.NOVOUCHERTYPE);
        }
        return vtCol;
    }

    private void fillVoucherTypeList(VoucherTypeCollection vtCol, VoucherTypeInfo vtDefault) {
        this.cbxVoucherType.removeAllItems();
        this.cbxVoucherType.addItems(vtCol.toArray());
        GlUtils.setSelectedItem(this.cbxVoucherType, (CoreBaseInfo)vtDefault);
    }

    private void initPlAccountF7(CompanyOrgUnitInfo newOrg) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)newOrg.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("PLType", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)newOrg.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("category", (Object)2, CompareType.NOTEQUALS));
        this.prmtYearProfitAcct.setEntityViewInfo(view);
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)newOrg.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("PLType", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)newOrg.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("category", (Object)2, CompareType.NOTEQUALS));
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, newOrg, filter, false, true);
        HashSet<Integer> budgets = new HashSet<Integer>();
        budgets.add(12);
        budgets.add(13);
        budgets.add(14);
        FilterInfo treeNodefilter = new FilterInfo();
        treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.NOTINCLUDE));
        apb.setTreeNodefilter(treeNodefilter);
        this.prmtYearProfitAcct.setSelector((KDPromptSelector)apb);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String missingHName;
        String fName;
        String fNumber;
        super.verifyInput(e);
        this.mltName.getSelectedItem();
        this.mltName.getSelectedItemData();
        this.mltName.getUserObject();
        if (this.prmtCompany.getValue() == null || this.prmtCompany.getText() == null || this.prmtCompany.getText().length() == 0) {
            String missingHName2 = EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"372_TransPLProgramEditUI");
            MsgBox.showWarning((Component)((Object)this), (String)missingHName2);
            this.prmtCompany.requestFocus();
            SysUtil.abort();
        }
        if ((fNumber = this.txtNumber.getText()) == null || fNumber.trim().length() == 0) {
            String missingHNumber = EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"373_TransPLProgramEditUI");
            MsgBox.showWarning((Component)((Object)this), (String)missingHNumber);
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if ((fName = (String)this.mltName.getSelectedItemData()) == null || fName.trim().length() == 0) {
            missingHName = EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"374_TransPLProgramEditUI");
            MsgBox.showWarning((Component)((Object)this), (String)missingHName);
            this.mltName.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtYearProfitAcct.getValue() == null || this.prmtYearProfitAcct.getText() == null || this.prmtYearProfitAcct.getText().length() == 0) {
            missingHName = EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"375_TransPLProgramEditUI");
            MsgBox.showWarning((Component)((Object)this), (String)missingHName);
            this.prmtYearProfitAcct.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getEntries() == null || this.editData.getEntries().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"376_TransPLProgramEditUI"));
            SysUtil.abort();
        }
        if (CreateVoucherModeEnum.ASSTACCOUNT.equals((Object)this.editData.getCreateVoucherMode()) && (this.editData.getAsstAccounts() == null || this.editData.getAsstAccounts().size() == 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"377_TransPLProgramEditUI"));
            SysUtil.abort();
        }
    }

    private void initCompanyF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setShowAssistantOrg(false);
        f7.setIsCUFilter(false);
        f7.setShowVirtual(false);
        f7.setContainSealUp(false);
        f7.setNeedAddAssistant(true);
        f7.setPermissionItem(this.getPermissionItem());
        FilterInfo filterSel = new FilterInfo();
        StringBuffer periodFilterSql = new StringBuffer();
        periodFilterSql.append("select 1 from T_BD_SystemStatusCtrol  AS sysctrl ");
        periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
        periodFilterSql.append(" where sysstatus.FName = 6 ");
        periodFilterSql.append(" and sysctrl.FCompanyID = \"UNIT\".fid ");
        periodFilterSql.append(" and sysctrl.fisstart=1 and sysctrl.fstartperiodid is not null ");
        filterSel.getFilterItems().add(new FilterItemInfo("unit.id", (Object)periodFilterSql.toString(), CompareType.EXISTS));
        f7.setOuterFilterInfo(filterSel);
        this.prmtCompany.setSelector((KDPromptSelector)f7);
        this.prmtCompany.setValue((Object)this.getCurrentCompany());
        this.prmtCompany.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                CompanyOrgUnitInfo oldCompany = (CompanyOrgUnitInfo)e.getOldData();
                CompanyOrgUnitInfo newCompany = (CompanyOrgUnitInfo)e.getData();
                if (oldCompany == null || newCompany == null) {
                    return;
                }
                String companyID = newCompany.getId().toString();
                if (companyID.equals(oldCompany.getId().toString())) {
                    return;
                }
                if ((TransPLProgramEditUI.this.getOprtState().equals(OprtState.ADDNEW) || TransPLProgramEditUI.this.getOprtState().equals(OprtState.COPYADDNEW) || TransPLProgramEditUI.this.getOprtState().equals(OprtState.EDIT)) && TransPLProgramEditUI.this.isModify()) {
                    int confirm = MsgBox.showConfirm3((Component)((Object)TransPLProgramEditUI.this), (String)EASResource.getString((String)TransPLProgramEditUI.CWGXRESOURCE, (String)"isSaveBill"));
                    if (confirm == 0) {
                        try {
                            TransPLProgramEditUI.this.actionSubmit_actionPerformed(null);
                        }
                        catch (Exception e1) {
                            logger.error((Object)"", (Throwable)e1);
                            TransPLProgramEditUI.this.handUIException(e1);
                        }
                    } else if (confirm == 2) {
                        SysUtil.abort();
                    }
                }
            }
        });
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        return (CompanyOrgUnitInfo)this.getUIContext().get("company");
    }

    private void initCompany() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        TransPLProgramInfo info = (TransPLProgramInfo)this.getUIContext().get("InitDataObject");
        if (info != null) {
            company = info.getCompany();
        } else if (this.getUIContext().get("ID") != null) {
            company = this.getBillCompany(this.getUIContext().get("ID").toString());
            if (this.getUIContext().get("FINDVIEW") != null && ((Boolean)this.getUIContext().get("FINDVIEW")).booleanValue() || this.getUIContext().get("WORKFLOW.CONTEXT") != null) {
                this.getUIContext().put("VIEWSTATUS", "FINDVIEW");
            }
        } else if (this.oprtState.equals(OprtState.ADDNEW) && this.vchCompany == null) {
            FilterInfo filter = new FilterInfo();
            StringBuffer periodFilterSql = new StringBuffer();
            periodFilterSql.append("select sysctrl.FCompanyID  from T_BD_SystemStatusCtrol  AS sysctrl ");
            periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
            periodFilterSql.append(" where sysstatus.FName = 6 ");
            periodFilterSql.append(" and sysctrl.FISSTART=1  and  sysctrl.fstartperiodid is not null ");
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)periodFilterSql.toString(), CompareType.INNER));
            company = GLEditUIUtil.getFirstCompany(PermissionItem, filter);
            if (company == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"hasNotAvailableCompany"));
                SysUtil.abort();
            }
        }
        this.getUIContext().put("company", company);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        CompanyOrgUnitInfo oldOrg = (CompanyOrgUnitInfo)chgVo.getOldOrg();
        CompanyOrgUnitInfo newOrg = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        if (oldOrg != null && newOrg != null && oldOrg.getId().equals((Object)newOrg.getId())) {
            return;
        }
        if (!this.checkSelectedCompany(newOrg)) {
            this.prmtCompany.setValue(chgVo.getOldOrg());
            return;
        }
        this.vchCompany = newOrg;
        GlUtils.updateBalance();
        this.clearEditData();
        try {
            this.fetchInitData(newOrg.getId().toString());
        }
        catch (Exception e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
            return;
        }
        this.getUIContext().put("company", newOrg);
        this.getUIContext().put("companyId", newOrg.getId().toString());
        this.fillPLAccountEntry(newOrg);
        try {
            this.loadData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handUIException(e);
        }
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        if (this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.EDIT) || this.oprtState.equals(OprtState.VIEW)) {
            return PermissionItem;
        }
        return null;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK orgPK = null;
        if (this.prmtCompany != null && this.prmtCompany.getValue() != null) {
            orgPK = new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId());
            return orgPK;
        }
        return super.getOrgPK(action);
    }

    private boolean checkSelectedCompany(CompanyOrgUnitInfo newOrg) {
        if (newOrg == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyIsNull"));
            return false;
        }
        try {
            CompanyOrgUnitInfo com = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(newOrg.getId().toString()), GlUtils.getCompanySic());
            if (!com.isIsBizUnit()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"mustSelectCompany"));
                return false;
            }
            if (com.isIsOUSealUp()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyIsSealUp"));
                return false;
            }
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)com);
            if (startPeriod == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyHasNotStartPeriod"));
                return false;
            }
            if (com.getAccountTable() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyAccounttableIsNull"));
                return false;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    private CompanyOrgUnitInfo getBillCompany(String voucherId) throws EASBizException, BOSException {
        TransPLProgramInfo info = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("company.accountTable.id"));
        info = (TransPLProgramInfo)TransPLProgramFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.getUIContext().get("ID").toString()), selector);
        if (info != null) {
            return info.getCompany();
        }
        return null;
    }

    private void clearEditData() {
        this.prmtYearProfitAcct.setValue(null);
        this.kdtAsstAccounts.removeRows();
        this.editData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rdByAsstAccount_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdByAsstAccount.isSelected() && this.isSelect) {
            this.isSelect = false;
            AccountViewInfo gainAccount = (AccountViewInfo)this.prmtYearProfitAcct.getValue();
            AsstAccountInfo caa = this.getCAA(gainAccount);
            if (gainAccount != null && caa != null) {
                AsstActTypeCollection asstCol = null;
                if (this.cAACache.get(gainAccount.getId().toString()) != null) {
                    asstCol = this.cAACache.get(gainAccount.getId().toString());
                } else {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fasstacttypeid from t_bd_asstactgroupdetail where fasstaccountid ='" + caa.getId().toString() + "'"), CompareType.INNER));
                    try {
                        asstCol = AsstActTypeFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getAsstActTypeCollection(EntityViewInfo.getInstance((FilterInfo)filter, null, null));
                        this.cAACache.put(gainAccount.getId().toString(), asstCol);
                    }
                    catch (Exception exc) {
                        this.rdByAsstAccount.setSelected(false);
                        this.rdByCommonMode.setSelected(true);
                        MsgBox.showWarning((Component)((Object)this), (String)exc.getMessage());
                    }
                    finally {
                        this.isSelect = false;
                    }
                }
                this.kdtAsstAccounts.checkParsed();
                this.kdtAsstAccounts.getStyleAttributes().setLocked(false);
                this.kdtAsstAccounts.removeRows();
                if (asstCol != null) {
                    TransPLProgramAsstAccountInfo programAsstAccountInfo = null;
                    int size = asstCol.size();
                    for (int i = 0; i < size; ++i) {
                        IRow row = this.kdtAsstAccounts.addRow();
                        AsstActTypeInfo asstActInfo = asstCol.get(i);
                        programAsstAccountInfo = new TransPLProgramAsstAccountInfo();
                        row.setUserObject((Object)programAsstAccountInfo);
                        row.getCell(COLUMN_SELECT).setValue((Object)Boolean.TRUE);
                        row.getCell(COLUMN_AsstType).setValue((Object)asstActInfo);
                        row.getCell(COLUMN_AsstNumberFrom).setEditor(GLEditor.getCellEditor(asstActInfo, (CoreUIObject)this, false));
                        row.getCell(COLUMN_AsstasstNumberTo).setEditor(GLEditor.getCellEditor(asstActInfo, (CoreUIObject)this, false));
                    }
                    this.kdtAsstAccounts.getColumn(COLUMN_AsstType).getStyleAttributes().setLocked(true);
                }
            }
        } else {
            this.isSelect = true;
            this.kdtAsstAccounts.checkParsed();
            this.kdtAsstAccounts.getStyleAttributes().setLocked(true);
            this.kdtAsstAccounts.removeRows();
        }
    }

    private AsstAccountInfo getCAA(AccountViewInfo account) {
        if (account == null) {
            return null;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company == null) {
            return null;
        }
        try {
            String companyId = company.getId().toString();
            PeriodInfo current = this.periods.get(companyId);
            if (current == null) {
                current = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
                this.periods.put(companyId, current);
            }
            if (current == null) {
                return account.getCAA();
            }
            return GLAsstAccountUtils.getCAA(null, account.getId().toString(), current.getId().toString(), this.caas);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    protected void setFilter(GLPeriodEndFilter filter) {
        int count = this.kdtAsstAccounts.getColumnCount();
        HashMap<String, String> baseNumberFrom = new HashMap<String, String>();
        HashMap<String, String> baseNumberTo = new HashMap<String, String>();
        ArrayList<AsstActTypeInfo> asstActInfoList = new ArrayList<AsstActTypeInfo>();
        for (int i = 0; i < count; ++i) {
            boolean isSelect;
            IRow row = this.kdtAsstAccounts.getRow(i);
            if (row == null || !(isSelect = ((Boolean)row.getCell(COLUMN_SELECT).getValue()).booleanValue())) continue;
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)row.getUserObject();
            asstActInfoList.add(asstActInfo);
            if (row.getCell(COLUMN_AsstNumberFrom).getValue() != null) {
                baseNumberFrom.put(asstActInfo.getAsstHGAttribute(), this.getNumber(row.getCell(COLUMN_AsstNumberFrom).getValue(), asstActInfo.isUseLongNumber()));
            }
            if (row.getCell(COLUMN_AsstasstNumberTo).getValue() == null) continue;
            baseNumberTo.put(asstActInfo.getAsstHGAttribute(), this.getNumber(row.getCell(COLUMN_AsstasstNumberTo).getValue(), asstActInfo.isUseLongNumber()));
        }
        if (asstActInfoList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"LastOneAcct"));
            SysUtil.abort();
        }
        filter.setBaseNumberFrom(baseNumberFrom);
        filter.setBaseNumberTo(baseNumberTo);
        filter.setAsstActInfoList(asstActInfoList);
    }

    private String getNumber(Object cellValue, boolean isUseLongNumber) {
        String result = null;
        if (cellValue == null) {
            return null;
        }
        if (cellValue instanceof GeneralAsstActTypeInfo && isUseLongNumber) {
            return (String)((GeneralAsstActTypeInfo)cellValue).get("originallongnumber");
        }
        if (cellValue instanceof CurrencyInfo && isUseLongNumber) {
            return (String)((CurrencyInfo)cellValue).get("longNumber");
        }
        if (cellValue instanceof CurrencyInfo) {
            result = (String)((CurrencyInfo)cellValue).get("fnumber");
        }
        if (result == null) {
            result = ((DataBaseInfo)cellValue).getNumber();
        }
        return result;
    }

    protected void rdAllPLAccount_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdAllPLAccount.isSelected()) {
            int j = this.kdtEntries.getRowCount();
            for (int i = 0; i < j; ++i) {
                this.kdtEntries.getRow(i).getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
            this.kdtEntries.getColumn(COLUMN_ISSELECT).getStyleAttributes().setLocked(true);
            this.btnSelectAll.setEnabled(false);
            this.btnUnSelectAll.setEnabled(false);
        } else {
            int size = this.kdtEntries.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.kdtEntries.getRow(i).getCell(COLUMN_ISSELECT).setValue((Object)false);
            }
            this.kdtEntries.getColumn(COLUMN_ISSELECT).getStyleAttributes().setLocked(false);
            this.btnSelectAll.setEnabled(true);
            this.btnUnSelectAll.setEnabled(true);
        }
    }

    protected void initListener() {
        super.initListener();
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowCount = TransPLProgramEditUI.this.kdtEntries.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    TransPLProgramEditUI.this.kdtEntries.getRow(i).getCell(TransPLProgramEditUI.COLUMN_ISSELECT).setValue((Object)true);
                }
            }
        });
        this.btnUnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowCount = TransPLProgramEditUI.this.kdtEntries.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    TransPLProgramEditUI.this.kdtEntries.getRow(i).getCell(TransPLProgramEditUI.COLUMN_ISSELECT).setValue((Object)false);
                }
            }
        });
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnCopy.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnTraceUp.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.menuItemTraceUp.setVisible(false);
        this.btnTraceDown.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.menuItemTraceDown.setVisible(false);
        this.btnCreateFrom.setEnabled(false);
        this.btnCreateFrom.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.menuItemCreateFrom.setVisible(false);
        this.btnAddLine.setEnabled(false);
        this.btnAddLine.setVisible(false);
        this.actionAddLine.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.btnInsertLine.setVisible(false);
        this.actionInsertLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.btnRemoveLine.setVisible(false);
        this.actionRemoveLine.setEnabled(false);
        this.menuItemAddLine.setVisible(false);
        this.menuItemInsertLine.setVisible(false);
        this.menuItemRemoveLine.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.btnWorkFlowG.setEnabled(false);
        this.btnWorkFlowG.setVisible(false);
        this.actionWorkFlowG.setEnabled(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.btnMultiapprove.setEnabled(false);
        this.btnMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.btnNextPerson.setEnabled(false);
        this.btnNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    protected void doChangeCompany(CompanyOrgUnitInfo company) throws Exception {
    }

    private void initHeaderStyle() throws Exception {
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSave_actionPerformed(e);
        }
        catch (EASBizException e1) {
            if ("8800001".equals(e1.getSubCode())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"OperateFail"), (String)e1.getMessage(), (int)2);
                SysUtil.abort();
            }
            throw e1;
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public IF7ContextChange getF7ContextManager() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    private void fillPLAccountEntry(CompanyOrgUnitInfo companyInfo) {
        this.kdtEntries.checkParsed();
        this.kdtEntries.removeRows();
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)companyInfo.getAccountTable().getId().toString()));
            fic.add(new FilterItemInfo("PLType", (Object)0, CompareType.NOTEQUALS));
            fic.add(new FilterItemInfo("isLeaf", (Object)1));
            fic.add(new FilterItemInfo("isGFreeze", (Object)0));
            fic.add(new FilterItemInfo("isCFreeze", (Object)0));
            fic.add(new FilterItemInfo("category", (Object)2, CompareType.NOTEQUALS));
            fic.add(new FilterItemInfo("isProfitCenter", (Object)0));
            ev.setFilter(filter);
            SorterItemCollection sorter = ev.getSorter();
            sorter.add(new SorterItemInfo("number"));
            AccountViewCollection accColl = AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev);
            int j = accColl.size();
            for (int i = 0; i < j; ++i) {
                AccountViewInfo acct = accColl.get(i);
                IRow row = this.kdtEntries.addRow();
                acct.setDisplayFormat("$number$");
                row.getCell(COLUMN_ACCTNUMBER).setValue((Object)acct.getNumber());
                row.getCell(COLUMN_ACCTID).setValue((Object)acct);
                row.getCell(COLUMN_ACCTNAME).setValue((Object)(acct.getName() != null ? acct.getName().toString() : ""));
                row.getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
            this.destroyWindow();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorItemCollection = super.getSelectors();
        selectorItemCollection.add(new SelectorItemInfo("PLAccountRange"));
        selectorItemCollection.add(new SelectorItemInfo("voucherTransPeriod"));
        selectorItemCollection.add(new SelectorItemInfo("createVoucherMode"));
        selectorItemCollection.add(new SelectorItemInfo("entries.*"));
        selectorItemCollection.add(new SelectorItemInfo("yearProfitAcct.*"));
        selectorItemCollection.add(new SelectorItemInfo("asstAccounts.*"));
        selectorItemCollection.add(new SelectorItemInfo("*"));
        return selectorItemCollection;
    }

    private SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Name"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("currencyID.number"));
        sic.add(new SelectorItemInfo("currencyID.name"));
        sic.add(new SelectorItemInfo("currencyID.precision"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        return sic;
    }
}

