/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ITransPLProgram;
import com.kingdee.eas.fi.gl.TransPLProgramFactory;
import com.kingdee.eas.fi.gl.TransPlProgramFilter;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractTransPLProgramListUI;
import com.kingdee.eas.fi.gl.client.GLLicenseUtils;
import com.kingdee.eas.fi.gl.client.TransPlProgramFilterUI;
import com.kingdee.eas.fi.gl.client.TransPlProgramQueryProcessor;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.client.VoucherListUI;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class TransPLProgramListUI
extends AbstractTransPLProgramListUI {
    private static final long serialVersionUID = -2108229470978366793L;
    private static final Logger logger = CoreUIObject.getLogger(TransPLProgramListUI.class);
    private static final String TRANSPLPROGRAM_RESOURCE_PATH = "com.kingdee.eas.fi.gl.TransPlProgramResource";
    private PeriodChangeListener periodChangeListener = new PeriodChangeListener();
    private Set lastCompanyIdSet;

    public void onLoad() throws Exception {
        try {
            GLLicenseUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        }
        catch (LicenseException e) {
            logger.error((Object)"release license error", (Throwable)e);
        }
        this.setMergeColumn();
        super.onLoad();
        this.initTableStyle();
        this.initListener();
        this.getMainStatusBar().setPerTitle(GlUtils.getSysStatusBarTitle(SysContext.getSysContext().getCurrentFIUnit()));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCreateVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.btnCreateVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        Icon icon = EASResource.getIcon((String)"imgTbtn_credence");
        this.menuItemJoinVoucher.setIcon(icon);
        this.btnJoinVoucher.setIcon(icon);
        this.menuItemJoinHistoryVoucher.setIcon(icon);
        this.btnJoinHistoryVoucher.setIcon(icon);
        this.btnCleanAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    private String[] getMergeColumnKeys() {
        String[] columnKeys = new String[]{"id", "selected", "company.name", "currPeriod", "number", "name", "voucherType", "voucherStatus"};
        return columnKeys;
    }

    protected void initTableStyle() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("selected").setSortable(false);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        this.actionJoinVoucher.setEnabled(row.getCell("voucher.id").getValue() != null);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        StringBuffer periodFilterSql = new StringBuffer();
        FilterItemInfo companyIdFilter = this.getCompanyFilter(this.mainQuery.getFilter());
        SystemStatusCtrolCollection sscColl = this.getSystemStatusCtrolCollection(companyIdFilter);
        if (!sscColl.isEmpty()) {
            PeriodInfo currentPeriod = sscColl.get(0).getCurrentPeriod();
            periodFilterSql.append("select vch.fid from t_gl_voucher vch");
            periodFilterSql.append(" inner join T_GL_TransPlProgramVoucher rf on vch.fid=rf.fvoucherid ");
            periodFilterSql.append(" inner join T_BD_Period p on p.fid = vch.fperiodid ");
            periodFilterSql.append(" where rf.FTransplID = '").append(row.getCell("id").getValue()).append("' ");
            periodFilterSql.append(" and p.FPERIODYEAR = " + currentPeriod.getPeriodYear());
            periodFilterSql.append(" and p.fperiodnumber >= 1 ");
            periodFilterSql.append(" and p.fperiodnumber < " + currentPeriod.getPeriodNumber());
        } else {
            periodFilterSql.append("select vch.fid from t_gl_voucher vch");
            periodFilterSql.append(" inner join T_GL_TransPlProgramVoucher rf on vch.fid=rf.fvoucherid ");
            periodFilterSql.append(" inner join T_ORG_BaseUnit com on vch.FCompanyID=com.fid ");
            periodFilterSql.append(" inner join T_BD_SystemStatusCtrol AS sysctrl on sysctrl.FCompanyID = com.fid");
            periodFilterSql.append(" INNER JOIN T_BD_Period AS curperiod ON sysctrl.FCurrentPeriodID =curperiod.FID");
            periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
            periodFilterSql.append(" INNER JOIN T_BD_Period AS vchperiod ON vch.FPeriodID =vchperiod.FID");
            periodFilterSql.append(" where rf.FTransplID = '").append(row.getCell("id").getValue()).append("' ");
            periodFilterSql.append(" and sysstatus.FName = 6 ");
            periodFilterSql.append(" and vchperiod.fperiodyear = curperiod.fperiodyear ");
            periodFilterSql.append(" and vchperiod.fperiodnumber>=1");
            periodFilterSql.append(" and vchperiod.fperiodnumber< curperiod.fperiodnumber ");
        }
        fic.add(new FilterItemInfo("id", (Object)periodFilterSql.toString(), CompareType.INNER));
        boolean isEnable = VoucherFactory.getRemoteInstance().exists(filter);
        this.actionJoinHistoryVoucher.setEnabled(isEnable);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.setHeight(250);
        queryDlg.setWidth(380);
        try {
            queryDlg.addUserPanel((KDPanel)new TransPlProgramFilterUI((String)this.getUIContext().get("UIClassParam")));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        queryDlg.setProcessor((IProcessor)new TransPlProgramQueryProcessor());
        return queryDlg;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        try {
            IQueryExecutor exec = this.getQueryExecutorInstance(queryPK);
            this.setCurCompanyFilter(viewInfo);
            this.setSorter(viewInfo);
            exec.setEntityView("TransPLProgram", viewInfo);
            FilterInfo filter = viewInfo.getFilter();
            EntityViewInfo sscQueryView = new EntityViewInfo();
            FilterInfo sscFilterInfo = new FilterInfo();
            sscFilterInfo.getFilterItems().add(this.getCompanyFilter(filter));
            sscQueryView.setFilter(sscFilterInfo);
            exec.setEntityView("sysStatusCtrl", sscQueryView);
            EntityViewInfo vchQueryView = new EntityViewInfo();
            FilterInfo filterInfov = new FilterInfo();
            filterInfov.getFilterItems().add(this.getCompanyFilter(filter));
            filterInfov.getFilterItems().add(this.getPeriodFilter(filter));
            vchQueryView.setFilter(filterInfov);
            exec.setEntityView("transplpVchRef", vchQueryView);
            exec.option().isAutoTranslateEnum = true;
            return exec;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private IQueryExecutor getQueryExecutorInstance(IMetaDataPK queryPK) {
        if (this.getMainOrgContext() != null && FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext()) != null) {
            return QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        }
        return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
    }

    private void setSorter(EntityViewInfo viewInfo) {
        if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("company.number"));
            viewInfo.getSorter().add(new SorterItemInfo("number"));
            viewInfo.getSorter().add(new SorterItemInfo("id"));
        } else {
            boolean existIdSorter = false;
            for (int i = 0; i < viewInfo.getSorter().size(); ++i) {
                SorterItemInfo item = viewInfo.getSorter().get(i);
                if (!"id".equals(item.getPropertyName())) continue;
                existIdSorter = true;
                break;
            }
            if (!existIdSorter) {
                SorterItemCollection sorter = new SorterItemCollection();
                boolean existVoucherNumberSorter = false;
                for (int i = 0; i < viewInfo.getSorter().size(); ++i) {
                    SorterItemInfo item = viewInfo.getSorter().get(i);
                    if ("voucherNumber".equals(item.getPropertyName())) {
                        existVoucherNumberSorter = true;
                        sorter.add(new SorterItemInfo("id"));
                    }
                    sorter.add(item);
                }
                if (!existVoucherNumberSorter) {
                    sorter.add(new SorterItemInfo("id"));
                }
                viewInfo.setSorter(sorter);
            }
        }
        if (!viewInfo.getSorter().containsKey((Object)"voucherNumber")) {
            viewInfo.getSorter().add(new SorterItemInfo("voucherNumber"));
        }
    }

    private void setCurCompanyFilter(EntityViewInfo viewInfo) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filterInfo);
        } else {
            FilterItemCollection filters = viewInfo.getFilter().getFilterItems();
            boolean existCompanyFilter = false;
            for (int i = 0; i < filters.size(); ++i) {
                if (!"company.id".equals(filters.get(i).getPropertyName())) continue;
                existCompanyFilter = true;
                break;
            }
            if (!existCompanyFilter) {
                viewInfo.getFilter().mergeFilter(filterInfo, "and");
            }
        }
    }

    private FilterItemInfo getCompanyFilter(FilterInfo filterInfo) {
        if (filterInfo != null) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo item = filterInfo.getFilterItems().get(i);
                if (!"company.id".equals(item.getPropertyName())) continue;
                return item;
            }
        }
        return new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
    }

    private FilterItemInfo getPeriodFilter(FilterInfo filterInfo) throws EASBizException, BOSException {
        FilterItemInfo companyFilteritem = this.getCompanyFilter(filterInfo);
        PeriodInfo period = (PeriodInfo)this.bizPromptVoucherPeriod.getValue();
        if (this.lastCompanyIdSet == null || !this.lastCompanyIdSet.equals(companyFilteritem.getCompareValue())) {
            this.lastCompanyIdSet = (Set)companyFilteritem.getCompareValue();
            this.initMainBizOrg(new ArrayList(this.lastCompanyIdSet));
            SystemStatusCtrolCollection sscColl = this.getSystemStatusCtrolCollection(companyFilteritem);
            if (!sscColl.isEmpty()) {
                this.setPeirodFilter(sscColl);
            }
            if (!sscColl.isEmpty()) {
                period = sscColl.get(0).getCurrentPeriod();
            }
            this.bizPromptVoucherPeriod.removeDataChangeListener((DataChangeListener)this.periodChangeListener);
            this.bizPromptVoucherPeriod.setValue((Object)period);
            this.bizPromptVoucherPeriod.addDataChangeListener((DataChangeListener)this.periodChangeListener);
        }
        return new FilterItemInfo("period.number", (Object)period.getNumber());
    }

    private SystemStatusCtrolCollection getSystemStatusCtrolCollection(FilterItemInfo companyFilteritem) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("currentPeriod.id"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodYear"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodNumber"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        view.getSelector().add(new SelectorItemInfo("startPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("startPeriod.periodType.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(companyFilteritem);
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("currentPeriod.number");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        return SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(view);
    }

    private void setPeirodFilter(SystemStatusCtrolCollection sscColl) {
        int minPeriodNumber = this.getMinPeriodNumber(sscColl);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)minPeriodNumber, CompareType.GREATER_EQUALS));
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < sscColl.size(); ++i) {
            idSet.add(sscColl.get(i).getStartPeriod().getPeriodType().getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodType.number"));
        evi.getSorter().add(new SorterItemInfo("number"));
        this.bizPromptVoucherPeriod.setEntityViewInfo(evi);
    }

    private int getMinPeriodNumber(SystemStatusCtrolCollection sscColl) {
        int minPeriodNumber = -1;
        for (int i = 0; i < sscColl.size(); ++i) {
            PeriodInfo period = sscColl.get(i).getStartPeriod();
            if (minPeriodNumber != -1 && period.getNumber() >= minPeriodNumber) continue;
            minPeriodNumber = period.getNumber();
        }
        return minPeriodNumber;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void actionCreateVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTEditManager editor;
        KDTEditManager em = this.tblMain.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
        }
        if ((editor = this.tblMain.getEditManager()).isEditing()) {
            editor.stopEditing();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int j = this.tblMain.getRowCount3();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)row.getCell("selected").getValue();
            if (!isSelected) continue;
            String id = (String)row.getCell("id").getValue();
            set.add(id);
        }
        ArrayList idList = new ArrayList(set);
        if (idList.size() == 0) {
            String missingSelectProduceLine = EASResource.getString((String)TRANSPLPROGRAM_RESOURCE_PATH, (String)"missingSelectProduceLine");
            MsgBox.showWarning((String)missingSelectProduceLine);
            return;
        }
        if (this.checkDataObject()) {
            ITransPLProgram iTransPLProgram = (ITransPLProgram)this.getBizInterface();
            TransPlProgramFilter rtnFilter = iTransPLProgram.generalVoucherCollection(idList);
            ArrayList produceInfos = (ArrayList)rtnFilter.getProduceList();
            UIContext uiContext = new UIContext();
            uiContext.put((Object)"MAKEINFO", (Object)produceInfos);
            uiContext.put((Object)"ISHIDE", (Object)true);
            uiContext.put((Object)"Owner", (Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.AutoTransMakeVhInfoUI", (Map)uiContext);
            uiWindow.show();
            this.refreshList();
        }
    }

    protected ArrayList getSelectedIdValues() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int j = this.tblMain.getRowCount3();
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)row.getCell("selected").getValue();
            if (!isSelected) continue;
            String id = (String)row.getCell("id").getValue();
            set.add(id);
        }
        ArrayList idList = new ArrayList(set);
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionJoinVoucher_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow();
        String voucherId = null;
        if (row == null) {
            return;
        }
        if (null != row.getCell("voucher.id")) {
            voucherId = (String)row.getCell("voucher.id").getValue();
        }
        if (voucherId != null) {
            try {
                this.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                IIDList voucherIdList = this.getVoucherIDList(this.tblMain, "voucher.id");
                voucherIdList.setCurrentID(voucherId);
                uiContext.put((Object)"IDList", (Object)voucherIdList);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    private IRow getSelectedRow() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return null;
        }
        return this.tblMain.getRow(rowIndex);
    }

    private IIDList getVoucherIDList(KDTable tblMain, String voucherColKey) {
        RealModeIDList idList = new RealModeIDList(){

            public void setCurrentID(String id) {
                if (this.newIdList.contains(id)) {
                    this.setCurrentIndex(this.newIdList.indexOf(id));
                }
            }
        };
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            String voucherId = (String)tblMain.getRow(i).getCell(voucherColKey).getValue();
            if (voucherId == null || voucherId.trim().length() <= 0 || idList.contains(voucherId)) continue;
            idList.add(voucherId);
        }
        return idList;
    }

    @Override
    public void actionJoinHistoryVoucher_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IRow row = this.getSelectedRow();
        if (row == null) {
            return;
        }
        String id = (String)row.getCell("id").getValue();
        if (id != null) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            StringBuffer oql = new StringBuffer();
            oql.append("id in(select fvoucherid from  t_gl_transplprogramvoucher where ftransplid ='");
            oql.append(id);
            oql.append("') \r\n");
            fic.add(new FilterItemInfo(oql.toString()));
            StringBuffer periodFilterSql = new StringBuffer();
            periodFilterSql.append("select 1 from t_gl_voucher vch");
            periodFilterSql.append(" inner join T_ORG_BaseUnit com on vch.FCompanyID=com.fid ");
            periodFilterSql.append(" inner join T_BD_SystemStatusCtrol AS sysctrl on sysctrl.FCompanyID = com.fid");
            periodFilterSql.append(" INNER JOIN T_BD_Period AS curperiod ON sysctrl.FCurrentPeriodID =curperiod.FID");
            periodFilterSql.append(" INNER JOIN T_BD_SystemStatus AS  sysstatus ON  sysctrl.FSystemStatusID = sysstatus.FID");
            periodFilterSql.append(" INNER JOIN T_BD_Period AS vchperiod ON vch.FPeriodID =vchperiod.FID");
            periodFilterSql.append(" where sysstatus.FName = 6 ");
            periodFilterSql.append(" and vch.fid = \"VOUCHER\".FID ");
            periodFilterSql.append(" and vchperiod.fperiodyear = curperiod.fperiodyear ");
            periodFilterSql.append(" and vchperiod.fperiodnumber>=1");
            periodFilterSql.append(" and vchperiod.fperiodnumber< curperiod.fperiodnumber ");
            fic.add(new FilterItemInfo("id", (Object)periodFilterSql.toString(), CompareType.EXISTS));
            VoucherListUI.showVouchers(EntityViewInfo.getInstance((FilterInfo)filter, null, null), (Map)uiContext);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblMain.getRow(i) == null) continue;
            this.tblMain.getRow(i).getCell("selected").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionCleanAll_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblMain.getRow(i) == null) continue;
            this.tblMain.getRow(i).getCell("selected").setValue((Object)Boolean.FALSE);
        }
    }

    protected boolean checkDataObject() {
        return true;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.gl.client.TransPLProgramEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TransPLProgramFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
            String s = EASResource.getString((String)resFullName, (String)"periodformat");
            MessageFormat mf = new MessageFormat(s);
            while (rowSet.next()) {
                rowSet.updateString("CURRPERIOD", mf.format(new String[]{rowSet.getString("CURRPERIODYEAR"), rowSet.getString("CURRPERIODNUMBER")}));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    private class PeriodChangeListener
    implements DataChangeListener {
        private PeriodChangeListener() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (eventObj.getNewValue() == null) {
                TransPLProgramListUI.this.bizPromptVoucherPeriod.setValue(eventObj.getOldValue());
                SysUtil.abort();
            } else {
                TransPLProgramListUI.this.execQuery();
            }
        }
    }
}

