/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.ITransPLFacade;
import com.kingdee.eas.fi.gl.TransPLFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractTransPLWizardUI;
import com.kingdee.eas.fi.gl.common.GLEditor;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class TransPLWizardUI
extends AbstractTransPLWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(TransPLWizardUI.class);
    protected CompanyOrgUnitInfo curCompany;
    protected UserInfo curUser;
    protected PeriodInfo curPeriod;
    private IGLPeriodEndFacade periodEndCtrl;
    private GLPeriodEndFilter filter;
    private AsstActTypeInfo asstActInfo;
    private int minPage = 1;
    private int maxPage = 2;
    private int currentStep = 1;
    protected int illegalEntryIndex = -1;
    protected int curEntryIndex = -1;
    private static final String COLUMN_INDEX = "Index";
    private static final String COLUMN_ACCTID = "AcctID";
    private static final String COLUMN_ACCTNUMBER = "AcctNumber";
    private static final String COLUMN_ACCTNAME = "AcctName";
    private static final String COLUMN_YEARPROFITACCT = "YearProfitAcct";
    private static final String COLUMN_ISSELECT = "IsSelected";
    protected KDBizPromptBox bizAccountPromptBox;
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected String lexTableId;
    protected String accttableid;
    private ICellEditor rateEditor;
    private AccountViewInfo paramPnLAccount = null;
    private int iSuccess = 0;
    private String strUITitle = "";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    private static boolean isInTimeVerify = false;
    protected VoucherEntrySwitchListener entrySwitchLs = new VoucherEntrySwitchListener();
    protected DataChangeListener vchDateChangeLs = new DataChangeListener(){

        public void dataChanged(DataChangeEvent evt) {
            PeriodInfo prd = TransPLWizardUI.this.filter.getCurPeriod();
            Date vchDate = (Date)TransPLWizardUI.this.dtpVchDate.getValue();
            if (vchDate.before(TransPLWizardUI.this.curPeriod.getBeginDate()) || vchDate.after(TransPLWizardUI.this.curPeriod.getEndDate())) {
                String adjInvalidVchDate = EASResource.getString((String)TransPLWizardUI.RESOURCE_PATH, (String)"adjInvalidVchDate");
                MsgBox.showInfo((Component)((Object)TransPLWizardUI.this), (String)adjInvalidVchDate);
                TransPLWizardUI.this.dtpVchDate.removeDataChangeListener((DataChangeListener)this);
                TransPLWizardUI.this.dtpVchDate.setValue((Object)TransPLWizardUI.this.curPeriod.getBeginDate());
                TransPLWizardUI.this.dtpVchDate.addDataChangeListener((DataChangeListener)this);
            }
        }
    };
    boolean isSelect = true;

    public TransPLWizardUI() throws Exception {
        GlUtils.updateBalance();
    }

    public void onLoad() throws Exception {
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        super.onLoad();
        this.fetchInitData();
        this.initHeaderStyle();
        this.initTableStyle();
        this.loadFields();
        this.initCtrl();
        HelpUtils.addCSHelp((JComponent)((Object)this));
    }

    private void initCtrl() {
        HelpUtils.addCSHelp((JComponent)((Object)this));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowCount = TransPLWizardUI.this.tblAccount.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    TransPLWizardUI.this.tblAccount.getRow(i).getCell(TransPLWizardUI.COLUMN_ISSELECT).setValue((Object)true);
                }
            }
        });
        this.btnUnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowCount = TransPLWizardUI.this.tblAccount.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    TransPLWizardUI.this.tblAccount.getRow(i).getCell(TransPLWizardUI.COLUMN_ISSELECT).setValue((Object)false);
                }
            }
        });
        HelpUtils.addCSHelpforBtn((JButton)this.btnHelp);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initHeaderStyle() throws Exception {
        this.strUITitle = this.getUITitle();
        this.kdlblPic.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.chkVchProfitLoss.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TransPLWizardUI.this.chkVchProfit.setSelected(false);
                    TransPLWizardUI.this.chkVchLoss.setSelected(false);
                } else if (!TransPLWizardUI.this.chkVchProfit.isSelected() && !TransPLWizardUI.this.chkVchLoss.isSelected()) {
                    TransPLWizardUI.this.chkVchProfitLoss.setSelected(true);
                }
            }
        });
        this.chkVchProfit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TransPLWizardUI.this.chkVchProfitLoss.setSelected(false);
                } else if (!TransPLWizardUI.this.chkVchLoss.isSelected() && !TransPLWizardUI.this.chkVchProfitLoss.isSelected()) {
                    TransPLWizardUI.this.chkVchProfit.setSelected(true);
                }
            }
        });
        this.chkVchLoss.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TransPLWizardUI.this.chkVchProfitLoss.setSelected(false);
                } else if (!TransPLWizardUI.this.chkVchProfit.isSelected() && !TransPLWizardUI.this.chkVchProfitLoss.isSelected()) {
                    TransPLWizardUI.this.chkVchLoss.setSelected(true);
                }
            }
        });
        this.currentStep = 1;
        this.setWizardPage();
        this.kdAsst.setEditable(true);
        this.kdAsst.setEditFormat("$number$");
        this.kdAsst.setDisplayFormat("$number$");
        this.kdAsst.setCommitFormat("$number$;$name$");
    }

    private void initTableStyle() {
        this.tblAccount.checkParsed();
        this.tblAccount.getSelectManager().setSelectMode(2);
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        IColumn accCol = this.tblAccount.getColumn(COLUMN_YEARPROFITACCT);
        this.bizAccountPromptBox = new KDBizPromptBox();
        this.bizAccountPromptBox.setEditable(true);
        this.bizAccountPromptBox.setEditFormat("$number$ $name$");
        this.bizAccountPromptBox.setDisplayFormat("$nubmer$ $name$");
        this.bizAccountPromptBox.setCommitFormat("$number$;$name$");
        this.bizAccountPromptBox.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherAccountQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currencyID.number"));
        sic.add(new SelectorItemInfo("currencyID.name"));
        sic.add(new SelectorItemInfo("currencyID.precision"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.id"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.defaultUnit.coefficient"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        this.bizAccountPromptBox.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.accttableid));
        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4");
        this.bizAccountPromptBox.setEntityViewInfo(view);
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.accttableid));
        filter.setMaskString("#0 AND #1 AND #2 AND #3 ");
        this.bizAccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.curCompany, filter, false, true));
        accCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizAccountPromptBox));
        ObjectValueRender accRender = new ObjectValueRender();
        accRender.setFormat((IDataFormat)new BizDataFormat("$number$  $longName$"));
        accCol.setRenderer((IBasicRender)accRender);
        this.tblAccount.getColumn(COLUMN_INDEX).getStyleAttributes().setLocked(true);
        this.tblAccount.getColumn(COLUMN_ACCTID).getStyleAttributes().setHided(true);
        this.tblAccount.getColumn(COLUMN_ACCTNUMBER).getStyleAttributes().setLocked(true);
        this.tblAccount.getColumn(COLUMN_ACCTNAME).getStyleAttributes().setLocked(true);
        this.tblAccount.getColumn(COLUMN_YEARPROFITACCT).getStyleAttributes().setLocked(false);
    }

    @Override
    public void loadFields() {
        this.detachListeners();
        super.loadFields();
        this.tblAccount.checkParsed();
        this.tblAccount.removeRows();
        Vector vec = new Vector();
        try {
            vec = this.getBizInterface().getTransPLAcct();
            int vecSize = vec.size();
            for (int i = 0; i < vecSize; ++i) {
                AccountViewInfo acct = (AccountViewInfo)vec.elementAt(i);
                IRow row = this.tblAccount.addRow();
                row.setUserObject((Object)acct);
                row.getCell(COLUMN_INDEX).setValue((Object)new Integer(i + 1));
                row.getCell(COLUMN_ACCTID).setValue((Object)acct.getId().toString());
                row.getCell(COLUMN_ACCTNUMBER).setValue((Object)acct.getNumber().toString());
                row.getCell(COLUMN_ACCTNAME).setValue((Object)acct.getName().toString());
                if (this.paramPnLAccount != null) {
                    row.getCell(COLUMN_YEARPROFITACCT).setValue((Object)this.paramPnLAccount);
                }
                row.getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
            this.destroyWindow();
        }
        this.dtpVchDate.setValue((Object)this.curPeriod.getEndDate());
        this.dtpVchDate.setSupportedEmpty(false);
        this.txtVchDescription.setText(EASResource.getString((String)RESOURCE_PATH, (String)"VchDescTransPL"));
        this.attachListeners();
        this.kdTransByVoucher.setSelected(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void doOK() throws Exception {
        if (this.checkDataObject()) {
            int result;
            this.setCursorOfWair();
            int vchPLType = 0;
            int vchProfitLoss = 0;
            boolean isTransDC = this.chkTransDC.isSelected();
            this.filter.setFilterTransPLByBalOppDC(isTransDC);
            int countVch = 0;
            if (this.chkVchProfit.isSelected()) {
                ++countVch;
                vchPLType = 1;
                vchProfitLoss = 1;
            }
            if (this.chkVchLoss.isSelected()) {
                ++countVch;
                vchPLType = 1;
                int n = vchProfitLoss = 1 == vchProfitLoss ? 3 : 2;
            }
            if (this.chkVchProfitLoss.isSelected()) {
                ++countVch;
                vchPLType = 2;
            }
            this.filter.setFilterVchPLType(vchPLType);
            this.filter.setFilterVchProfitLoss(vchProfitLoss);
            this.filter.setFilterCountVch(countVch);
            VoucherTypeInfo vchTypeInfo = (VoucherTypeInfo)this.cmbVchType.getSelectedItem();
            this.filter.setFilterVchType(vchTypeInfo);
            java.sql.Date dtVch = this.dtpVchDate.getSqlDate();
            this.filter.setFilterVchDate((Date)dtVch);
            String vchDesc = this.txtVchDescription.getText();
            if (vchDesc == null) {
                vchDesc = "";
            }
            if (vchDesc.length() == 0) {
                vchDesc = EASResource.getString((String)RESOURCE_PATH, (String)"TransPL");
            }
            this.filter.setFilterVchDesc(vchDesc);
            if (!this.chkVchCurrency.isSelected()) {
                this.filter.setParamCheckCurrency(true);
            }
            this.tblAccount.checkParsed();
            HashMap<String, AccountViewInfo> hmGainAccount = new HashMap<String, AccountViewInfo>();
            HashMap<String, String> hmUnSelectedAccount = new HashMap<String, String>();
            int rowCount = this.tblAccount.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAccount.getRow(i);
                Boolean isSelect = (Boolean)row.getCell(COLUMN_ISSELECT).getValue();
                AccountViewInfo gainAccount = (AccountViewInfo)row.getCell(COLUMN_YEARPROFITACCT).getValue();
                String acctID = (String)row.getCell(COLUMN_ACCTID).getValue();
                if (isSelect.booleanValue()) {
                    hmGainAccount.put(acctID, gainAccount);
                    continue;
                }
                hmUnSelectedAccount.put(acctID, acctID);
            }
            this.filter.setHmPLAccount(hmGainAccount);
            this.filter.setHmUnSelectedAccount(hmUnSelectedAccount);
            GlUtils.updateBalance();
            GLPeriodEndFilter filterNew = null;
            boolean transMethod = this.kdTransByVoucher.isSelected();
            if (!transMethod) {
                this.filter.setTransMethodByAsst(true);
                this.setFilter(this.filter);
                filterNew = this.getTransPLFacade().transPLByAsst(this.filter);
            } else {
                this.filter.setTransMethodByAsst(false);
                IUIActionPostman clientHanlder = this.prepareInit();
                if (clientHanlder != null) {
                    RequestContext request = new RequestContext();
                    request.setClassName("com.kingdee.eas.fi.gl.app.TransPLWizardUIHandler");
                    request.setMethodName("handleActionGenVchTransPnL");
                    request.put("FILTER", (Object)this.filter);
                    clientHanlder.setRequestContext((Serializable)request);
                }
                clientHanlder.callHandler();
                filterNew = this.getBizInterface().genVchTransPnL(this.filter);
                if (filterNew.getReturnVchCount() != 0) {
                    if (filterNew.getReturnVch1() != null) {
                        this.resetEntryMeasureUnit(filterNew.getReturnVch1(), this.filter);
                    }
                    if (filterNew.getReturnVch2() != null) {
                        this.resetEntryMeasureUnit(filterNew.getReturnVch2(), this.filter);
                    }
                }
            }
            if (filterNew.getReturnVchCount() != 0) {
                if (filterNew.getReturnVch1() != null) {
                    // empty if block
                }
                if (filterNew.getReturnVch2() != null) {
                    // empty if block
                }
            }
            if ((result = filterNew.getReturnVchCount()) == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"TransPLGenNoVch"));
            } else {
                VoucherInfo vch2;
                if (filterNew.getReturnVch1() == null && filterNew.getReturnVch2() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"succTransPL"), new Integer(filterNew.getReturnVchCount())));
                    this.setCursorOfDefault();
                    this.destroyWindow();
                    return;
                }
                VoucherInfo vch1 = filterNew.getReturnVch1();
                if (vch1 != null) {
                    vch1.setVoucherType(this.filter.getFilterVchType());
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"GLEND", (Object)"GLEND");
                    uiContext.put((Object)"InitDataObject", (Object)vch1);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
                    this.setCursorOfDefault();
                    uiWindow.show();
                }
                if ((vch2 = filterNew.getReturnVch2()) != null) {
                    vch2.setVoucherType(this.filter.getFilterVchType());
                    UIContext uiContext2 = new UIContext((Object)this);
                    uiContext2.put((Object)"GLEND", (Object)"GLEND");
                    uiContext2.put((Object)"InitDataObject", (Object)vch2);
                    IUIWindow uiWindow2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)uiContext2, null, OprtState.ADDNEW);
                    this.setCursorOfDefault();
                    uiWindow2.show();
                }
                this.setBtnOKOK();
            }
        }
    }

    private void resetEntryMeasureUnit(VoucherInfo voucher, GLPeriodEndFilter filter) throws EASBizException, BOSException, Exception {
        VoucherEntryCollection entries = voucher.getEntries();
        int priceScale = new Integer(filter.getHmGLParam().get("GL_003").toString());
        for (VoucherEntryInfo entry : entries) {
            MeasureUnitInfo measure;
            if (!entry.getAccount().isIsQty() || entry.getAssistRecords() != null && entry.getAssistRecords().size() != 0 || (measure = this.getAccountMeasure(entry.getAccount().getMeasureUnitGroupID())) == null || entry.getMeasureUnit() != null || measure.getId() == null) continue;
            entry.setMeasureUnit(measure);
            if (entry.getPrice() != null) continue;
            entry.setPrice(entry.getOriginalAmount().divide(entry.getQuantity(), priceScale, 4));
        }
    }

    private MeasureUnitInfo getAccountMeasure(MeasureUnitGroupInfo measureUnitGroup) throws EASBizException, BOSException, Exception {
        if (measureUnitGroup != null && measureUnitGroup.getId() != null) {
            return (MeasureUnitInfo)this.getTransPLFacade().getAccountMU(measureUnitGroup.getId().toString());
        }
        return null;
    }

    private void resetMeasureUnit(VoucherInfo voucher, GLPeriodEndFilter filter) throws EASBizException, BOSException, Exception {
        VoucherEntryCollection entries = voucher.getEntries();
        int priceScale = new Integer(filter.getHmGLParam().get("GL_003").toString());
        for (VoucherEntryInfo entry : entries) {
            VoucherAssistRecordCollection asstRecords = entry.getAssistRecords();
            for (VoucherAssistRecordInfo asstRecord : asstRecords) {
                MeasureUnitGroupInfo mgroup;
                MeasureUnitInfo mu;
                if (asstRecord.getAssGrp() == null) continue;
                if (asstRecord.getAssGrp().getMaterial() != null) {
                    mu = this.getMaterialMeasureUnit(asstRecord.getAssGrp().getMaterial().getId().toString());
                    if (mu != null && mu.getId() != null) {
                        asstRecord.setMeasureUnit(mu);
                        if (asstRecord.getPrice() != null || asstRecord.getOriginalAmount() == null || asstRecord.getQuantity() == null || GlUtils.zero.compareTo(asstRecord.getQuantity()) == 0) continue;
                        asstRecord.setPrice(asstRecord.getOriginalAmount().divide(asstRecord.getQuantity(), priceScale, 4).abs());
                        continue;
                    }
                    if (!isInTimeVerify || entry.getAccount().getMeasureUnitGroupID() == null || (mgroup = entry.getAccount().getMeasureUnitGroupID()).getDefaultUnit() == null) continue;
                    asstRecord.setMeasureUnit(mgroup.getDefaultUnit());
                    continue;
                }
                mu = this.getSelfMeasureUnit(asstRecord.getAssGrp());
                if (mu != null && mu.getId() != null) {
                    asstRecord.setMeasureUnit(mu);
                    if (asstRecord.getPrice() != null || asstRecord.getOriginalAmount() == null || asstRecord.getQuantity() == null || GlUtils.zero.compareTo(asstRecord.getQuantity()) == 0) continue;
                    asstRecord.setPrice(asstRecord.getOriginalAmount().divide(asstRecord.getQuantity(), priceScale, 4).abs());
                    continue;
                }
                if (!isInTimeVerify || entry.getAccount().getMeasureUnitGroupID() == null || (mgroup = entry.getAccount().getMeasureUnitGroupID()).getDefaultUnit() == null) continue;
                asstRecord.setMeasureUnit(mgroup.getDefaultUnit());
            }
        }
    }

    private MeasureUnitInfo getMaterialMeasureUnit(String id) throws EASBizException, BOSException, Exception {
        return this.getTransPLFacade().getSelfMU(null, id);
    }

    private MeasureUnitInfo getSelfMeasureUnit(AssistantHGInfo asstHG) throws EASBizException, BOSException, Exception {
        return this.getTransPLFacade().getSelfMU(asstHG, null);
    }

    protected boolean checkDataObjectStep1() {
        if (this.tblAccount.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"noPLBalToTrans"));
            return false;
        }
        boolean isUnSelectAll = true;
        for (int i = 0; i < this.tblAccount.getRowCount(); ++i) {
            IRow row = this.tblAccount.getRow(i);
            Boolean isSelect = (Boolean)row.getCell(COLUMN_ISSELECT).getValue();
            if (isSelect == null || !isSelect.booleanValue()) continue;
            isUnSelectAll = false;
            AccountViewInfo plAcct = (AccountViewInfo)row.getCell(COLUMN_YEARPROFITACCT).getValue();
            if (plAcct != null) continue;
            String acctNumber = row.getCell(COLUMN_ACCTNUMBER).getValue().toString();
            String errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"noPLAcctForTrans");
            MsgBox.showInfo((Component)((Object)this), (String)acctNumber.concat(" ").concat(errMsg));
            return false;
        }
        if (isUnSelectAll) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"mustSelectOneAcct"));
            return false;
        }
        return true;
    }

    protected boolean checkDataObject() {
        String errMsg;
        int rows = this.tblAccount.getRowCount();
        this.tblAccount.checkParsed();
        for (int i = 0; i < rows; ++i) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"missingYearGainAccount");
            int rowIndex = i + 1;
            IRow curRow = this.tblAccount.getRow(i);
            Boolean isSelect = (Boolean)curRow.getCell(COLUMN_ISSELECT).getValue();
            if (!isSelect.booleanValue()) continue;
            if (curRow.getCell(COLUMN_YEARPROFITACCT).toString().length() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)errMsg);
                this.goBackToCell(this.tblAccount, rowIndex, COLUMN_YEARPROFITACCT);
                return false;
            }
            AccountViewInfo gainAccount = (AccountViewInfo)curRow.getCell(COLUMN_YEARPROFITACCT).getValue();
            if (gainAccount != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.goBackToCell(this.tblAccount, rowIndex, COLUMN_YEARPROFITACCT);
            return false;
        }
        int countVch = 0;
        if (this.chkVchProfit.isSelected()) {
            ++countVch;
        }
        if (this.chkVchLoss.isSelected()) {
            ++countVch;
        }
        if (this.chkVchProfitLoss.isSelected()) {
            ++countVch;
        }
        if (countVch < 1) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"mustSelectVchProfitLoss");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.chkVchProfitLoss.requestFocus(true);
            return false;
        }
        if (countVch > 2) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"mustSelectVchProfitLoss");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.chkVchProfitLoss.requestFocus();
            return false;
        }
        if (this.cmbVchType.getSelectedItem() == null) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"mustSelectVchType");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.cmbVchType.requestFocus();
            return false;
        }
        Date dtVch = (Date)this.dtpVchDate.getValue();
        Timestamp tsVch = this.dtpVchDate.getTimestamp();
        if (dtVch.compareTo(this.curPeriod.getBeginDate()) < 0 || tsVch.compareTo(this.curPeriod.getEndDate()) > 0) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"adjInvalidVchDate");
            MsgBox.showInfo((Component)((Object)this), (String)errMsg);
            this.dtpVchDate.requestFocus();
            return false;
        }
        return true;
    }

    protected void setWizardPage() throws Exception {
        StringBuffer strTitleStep = new StringBuffer("WizardStepTitle").append(new Integer(this.currentStep).toString()).append("of2");
        String strStepTitle = EASResource.getString((String)RESOURCE_PATH, (String)strTitleStep.toString());
        this.setUITitle(this.strUITitle.concat("_").concat(strStepTitle));
        switch (this.currentStep) {
            case 1: {
                this.kDPanel1.setVisible(true);
                this.kDPanel2.setVisible(false);
                this.btnPrev.setEnabled(false);
                this.btnNext.setEnabled(true);
                this.btnOK.setEnabled(false);
                break;
            }
            case 2: {
                this.kDPanel1.setVisible(false);
                this.kDPanel2.setVisible(true);
                this.btnPrev.setEnabled(true);
                this.btnNext.setEnabled(false);
                this.btnOK.setEnabled(true);
                if (this.foreignCurrencySU) {
                    this.chkVchCurrency.setVisible(false);
                    break;
                }
                this.chkVchCurrency.setVisible(true);
            }
        }
    }

    protected IGLPeriodEndFacade getBizInterface() throws Exception {
        this.periodEndCtrl = GLPeriodEndFacadeFactory.getRemoteInstance();
        return this.periodEndCtrl;
    }

    protected ITransPLFacade getTransPLFacade() throws Exception {
        return TransPLFacadeFactory.getRemoteInstance();
    }

    private void fetchInitData() throws EASBizException, Exception {
        String cuid;
        IGLPeriodEndFacade ctrl = this.getBizInterface();
        int iCheckCanTransPL = ctrl.checkCanTransPL(cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (iCheckCanTransPL != 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"errCheckCanTransPL"));
            this.destroyWindow();
        }
        this.filter = new GLPeriodEndFilter();
        this.filter = ctrl.fetchInitData();
        this.curUser = this.filter.getCurUser();
        this.curCompany = this.filter.getCurCompany();
        this.accttableid = this.curCompany.getAccountTable().getId().toString();
        this.curPeriod = this.filter.getCurPeriod();
        VoucherTypeCollection vtCol = this.filter.getVoucherTypeColl();
        VoucherTypeInfo vtDefault = this.filter.getDefaultVoucherType();
        this.fillVoucherTypeList(vtCol, vtDefault);
        HashMap hmGLParam = new HashMap();
        hmGLParam = this.filter.getHmGLParam();
        Object pa = hmGLParam.get("GL_010");
        int ctype = 0;
        if (hmGLParam.get("GL_052") != null) {
            ctype = Integer.parseInt(hmGLParam.get("GL_052").toString());
        }
        boolean bl = isInTimeVerify = ctype == 0;
        if (pa == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"errParamPnLAccount"));
        } else if (pa.toString().length() > 0) {
            String acctID = pa.toString();
            IAccountView acctCtrl = AccountViewFactory.getRemoteInstance();
            AccountViewInfo acct = null;
            ObjectUuidPK acctPK = null;
            try {
                acctPK = new ObjectUuidPK(BOSUuid.read((String)acctID));
                acct = (AccountViewInfo)acctCtrl.getValue((IObjectPK)acctPK, GlUtils.getTransPLAccountSelectors());
            }
            catch (Exception ex) {
                acct = null;
            }
            if (acct == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"errParamPnLAccount"));
            }
            this.paramPnLAccount = acct;
        }
        this.foreignCurrencySU = this.filter.isParamForeignCurrencySU();
        this.useReportingCurrency = this.filter.isParamUseReportCurrency();
        if (!this.foreignCurrencySU) {
            this.localCurrency = this.curCompany.getBaseCurrency();
            if (this.curCompany.getBaseExchangeTable() != null) {
                this.lexTableId = this.curCompany.getBaseExchangeTable().get("id").toString();
            }
        }
    }

    private void fillVoucherTypeList(VoucherTypeCollection vtCol, VoucherTypeInfo vtDefault) {
        this.cmbVchType.addItems(vtCol.toArray());
        GlUtils.setSelectedItem(this.cmbVchType, (CoreBaseInfo)vtDefault);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    public void actionPrev_actionPerformed(ActionEvent e) throws Exception {
        if (this.minPage == this.currentStep) {
            return;
        }
        --this.currentStep;
        this.setWizardPage();
        this.kdTrans.setSelected(false);
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentStep == 1) {
            if (this.maxPage == this.currentStep) {
                return;
            }
            if (!this.checkDataObjectStep1()) {
                return;
            }
            ++this.currentStep;
            this.setWizardPage();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentStep == 2) {
            if (this.iSuccess == 0) {
                this.doOK();
            } else {
                this.destroyWindow();
            }
        }
    }

    protected void attachListeners() {
        this.tblAccount.addKDTActiveCellListener((KDTActiveCellListener)this.entrySwitchLs);
        this.dtpVchDate.addDataChangeListener(this.vchDateChangeLs);
    }

    protected void detachListeners() {
        this.tblAccount.removeKDTActiveCellListener((KDTActiveCellListener)this.entrySwitchLs);
        this.dtpVchDate.removeDataChangeListener(this.vchDateChangeLs);
    }

    protected boolean tellEquals(Object objA, Object objB) {
        if (objA == objB) {
            return true;
        }
        if (objA == null && objB != null || objA != null && objB == null) {
            return false;
        }
        if (objA instanceof IObjectValue && objB instanceof IObjectValue) {
            IObjectValue obj1 = (IObjectValue)objA;
            IObjectValue obj2 = (IObjectValue)objB;
            return obj1.get("id").equals(obj2.get("id"));
        }
        return objA.equals(objB);
    }

    protected BigDecimal dealWithScale(BigDecimal val, int scale, int roundingMode) {
        if (val == null) {
            return val;
        }
        return val.setScale(scale, roundingMode);
    }

    protected boolean isEntryCellEditable(IRow entryRow, String colKey) {
        if (COLUMN_INDEX.equals(colKey)) {
            return false;
        }
        if (COLUMN_ACCTNUMBER.equals(colKey)) {
            return false;
        }
        return !COLUMN_ACCTNAME.equals(colKey);
    }

    protected void goBackToCell(KDTable table, int rowIndex, String colKey) {
        ICell cell = table.getRow(rowIndex).getCell(colKey);
        StyleAttributes sa = cell.getStyleAttributes();
        if (sa.isHided()) {
            sa.setHided(false);
        }
        table.getSelectManager().removeAll(false);
        table.getEditManager().editCellAt(rowIndex, table.getColumnIndex(colKey));
    }

    protected void refreshTableAccount() {
        IRow row = this.tblAccount.getRow(0);
        AccountViewInfo acc = (AccountViewInfo)row.getCell(COLUMN_YEARPROFITACCT).getValue();
        AccountViewInfo accCur = null;
        int rowCount = this.tblAccount.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            row = this.tblAccount.getRow(i);
            accCur = (AccountViewInfo)row.getCell(COLUMN_YEARPROFITACCT).getValue();
            if (accCur != null) continue;
            row.getCell(COLUMN_YEARPROFITACCT).setValue((Object)acc);
        }
    }

    private void setBtnOKOK() {
        this.iSuccess = 1;
        this.btnOK.setText(EASResource.getString((String)RESOURCE_PATH, (String)"btnOKText"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kdTrans_stateChanged(ChangeEvent e) throws Exception {
        if (this.kdTrans.isSelected() && this.isSelect) {
            this.isSelect = false;
            HashMap<String, AccountViewInfo> hmGainAccount = new HashMap<String, AccountViewInfo>();
            int rowCount = this.tblAccount.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAccount.getRow(i);
                Boolean isSelect = (Boolean)row.getCell(COLUMN_ISSELECT).getValue();
                if (!isSelect.booleanValue()) continue;
                AccountViewInfo gainAccount = (AccountViewInfo)row.getCell(COLUMN_YEARPROFITACCT).getValue();
                String acctID = (String)row.getCell(COLUMN_ACCTID).getValue();
                hmGainAccount.put(acctID, gainAccount);
            }
            this.filter.setHmPLAccount(hmGainAccount);
            this.tblAsst.checkParsed();
            this.tblAsst.getStyleAttributes().setLocked(false);
            AsstActTypeCollection asstCol = null;
            try {
                asstCol = (AsstActTypeCollection)this.getTransPLFacade().getAsstactTypeCol(this.filter);
            }
            catch (Exception exc) {
                this.kdTrans.setSelected(false);
                this.kdTransByVoucher.setSelected(true);
                MsgBox.showWarning((Component)((Object)this), (String)exc.getMessage());
            }
            finally {
                this.isSelect = false;
            }
            if (asstCol != null) {
                int size = asstCol.size();
                for (int i = 0; i < size; ++i) {
                    IRow row = this.tblAsst.addRow();
                    AsstActTypeInfo asstActInfo = asstCol.get(i);
                    row.setUserObject((Object)asstActInfo);
                    row.getCell(0).setValue((Object)Boolean.TRUE);
                    row.getCell(1).setValue((Object)asstActInfo.getName());
                    row.getCell(2).setEditor(GLEditor.getCellEditor(asstActInfo, (CoreUIObject)this, false));
                    row.getCell(3).setEditor(GLEditor.getCellEditor(asstActInfo, (CoreUIObject)this, false));
                }
            }
        } else {
            this.isSelect = true;
            this.kDLabelContainer4.setVisible(false);
            this.tblAsst.checkParsed();
            this.tblAsst.getStyleAttributes().setLocked(true);
            this.tblAsst.removeRows();
        }
    }

    protected void setFilter(GLPeriodEndFilter filter) {
        int count = this.tblAsst.getColumnCount();
        HashMap<String, String> baseNumberFrom = new HashMap<String, String>();
        HashMap<String, String> baseNumberTo = new HashMap<String, String>();
        ArrayList<AsstActTypeInfo> asstActInfoList = new ArrayList<AsstActTypeInfo>();
        for (int i = 0; i < count; ++i) {
            boolean isSelect;
            IRow row = this.tblAsst.getRow(i);
            if (row == null || !(isSelect = ((Boolean)row.getCell(0).getValue()).booleanValue())) continue;
            AsstActTypeInfo asstActInfo = (AsstActTypeInfo)row.getUserObject();
            asstActInfoList.add(asstActInfo);
            if (row.getCell(2).getValue() != null) {
                baseNumberFrom.put(asstActInfo.getAsstHGAttribute(), this.getNumber(row.getCell(2).getValue(), asstActInfo.isUseLongNumber()));
            }
            if (row.getCell(3).getValue() == null) continue;
            baseNumberTo.put(asstActInfo.getAsstHGAttribute(), this.getNumber(row.getCell(3).getValue(), asstActInfo.isUseLongNumber()));
        }
        if (asstActInfoList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"LastOneAcct"));
            SysUtil.abort();
        }
        filter.setBaseNumberFrom(baseNumberFrom);
        filter.setBaseNumberTo(baseNumberTo);
        filter.setAsstActInfoList(asstActInfoList);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private String getNumber(Object cellValue, boolean isUseLongNumber) {
        if (cellValue instanceof GeneralAsstActTypeInfo && isUseLongNumber) {
            return ((GeneralAsstActTypeInfo)cellValue).getLongNumber();
        }
        return ((DataBaseInfo)cellValue).getNumber();
    }

    class VoucherEntrySwitchListener
    implements KDTActiveCellListener {
        VoucherEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            if (TransPLWizardUI.this.illegalEntryIndex >= 0) {
                TransPLWizardUI.this.illegalEntryIndex = -1;
                return;
            }
            int preLine = TransPLWizardUI.this.curEntryIndex;
            int line = evt.getRowIndex();
            if (preLine != line) {
                int rowCount = TransPLWizardUI.this.tblAccount.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine == 0) {
                    IRow row = TransPLWizardUI.this.tblAccount.getRow(preLine);
                    AccountViewInfo acc = (AccountViewInfo)row.getCell(TransPLWizardUI.COLUMN_YEARPROFITACCT).getValue();
                    if (acc == null) {
                        TransPLWizardUI.this.illegalEntryIndex = preLine;
                        TransPLWizardUI.this.goBackToCell(TransPLWizardUI.this.tblAccount, TransPLWizardUI.this.illegalEntryIndex, TransPLWizardUI.COLUMN_YEARPROFITACCT);
                    } else {
                        TransPLWizardUI.this.refreshTableAccount();
                    }
                }
            }
        }
    }
}

