/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TreeTAccount
implements Comparable {
    private static final Logger logger = Logger.getLogger(TreeTAccount.class);
    public static final String ROOT_NUMBER = "root";
    public static final String DEBIT_CASH = "dc";
    public static final String DEBIT_NOT_CASH = "dnc";
    public static final String CREDIT_CASH = "cc";
    public static final String CREDIT_NOT_CASH = "cnc";
    public static final String DEBIT = "debit";
    public static final String CREDIT = "credit";
    public static final String NUMBER_NOT_CFI = "NCFI";
    public static final String NUMBER_NOT_ASSIST = "NASSIST";
    public static final int CREATE_CRITERIA_ACCOUNT = 1;
    public static final int CREATE_CRITERIA_CFI = 2;
    public static final int CREATE_CRITERIA_ACCOUNT_ASSIST = 3;
    public static final int CREATE_CRITERIA_CFI_ASSIST = 4;
    public static final int TYPE_DEFAULT_ROOT = 0;
    public static final int TYPE_DEFAULT_DEBIT = 1;
    public static final int TYPE_DEFAULT_CREDIT = 2;
    public static final int TYPE_ACCOUNT = 3;
    public static final int TYPE_CFI_ACCOUNT = 4;
    public static final int TYPE_ASSIST_ACCOUNT = 5;
    public static final int TYPE_CFI = 6;
    public static final int TYPE_ACCOUNT_ASSIST = 7;
    public static final int TYPE_CFI_ASSIST = 8;
    public static final int TYPE_UNASSIGNED_CFI = 9;
    private String number = null;
    private String longNumber = null;
    private String name = null;
    private int type = -1;
    private BigDecimal amount = GlUtils.zero;
    private boolean isDebit = false;
    private boolean isCash = false;
    private int level = 0;
    private TreeTAccount parent = null;
    private Map children = new HashMap();
    private Map cashflowRecords = new HashMap();

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void addAmount(BigDecimal amount) {
        this.amount = this.amount.add(amount);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public TreeTAccount getParent() {
        return this.parent;
    }

    public void setParent(TreeTAccount parent) {
        this.parent = parent;
    }

    public Map getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public void addChild(TreeTAccount child) {
        this.children.put(child.getNumber(), child);
        child.setParent(this);
    }

    public TreeTAccount removeChild(String number) {
        return (TreeTAccount)this.children.remove(number);
    }

    public TreeTAccount searchChild(String number) {
        return (TreeTAccount)this.children.get(number);
    }

    public TreeTAccount recursiveSearchChild(String number) {
        Object obj = this.children.get(number);
        if (obj != null) {
            return (TreeTAccount)obj;
        }
        for (TreeTAccount info : this.children.values()) {
            TreeTAccount result = info.recursiveSearchChild(number);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public boolean isDebit() {
        return this.isDebit;
    }

    public void setDebit(boolean isDebit) {
        this.isDebit = isDebit;
    }

    public boolean isCash() {
        return this.isCash;
    }

    public void setCash(boolean isCash) {
        this.isCash = isCash;
    }

    public Map getCashflowRecords() {
        return Collections.unmodifiableMap(this.cashflowRecords);
    }

    public TAccountCashflowInfo getCashflowRecord(String id) {
        return (TAccountCashflowInfo)this.cashflowRecords.get(id);
    }

    public void addCashflowRecord(TAccountCashflowInfo info) {
        this.cashflowRecords.put(info.getId(), info);
    }

    public void addCashflowRecord(List infos) {
        TAccountCashflowInfo info = null;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            info = (TAccountCashflowInfo)infos.get(i);
            this.cashflowRecords.put(info.getId(), info);
        }
    }

    public TAccountCashflowInfo removeCashflowRecord(String id) {
        return (TAccountCashflowInfo)this.cashflowRecords.remove(id);
    }

    public void clearCashflowRecords() {
        this.cashflowRecords.clear();
    }

    public List getContainedVoucher() {
        ArrayList<String> result = new ArrayList<String>();
        for (TAccountCashflowInfo info : this.cashflowRecords.values()) {
            result.add(info.getVoucherId());
        }
        return result;
    }

    public void recreateChildren(int createCriteria, Map params) {
        this.clearChildren();
        if (1 == createCriteria) {
            this.recreateChildrenByAccount(params);
        } else if (2 == createCriteria) {
            this.recreateChildrenByCFI(params);
        } else if (3 == createCriteria) {
            this.recreateChildrenByAccountAssist(params);
        } else if (4 == createCriteria) {
            this.recreateChildrenByCFIAssist(params);
        }
    }

    private void recreateChildrenByCFIAssist(Map params) {
        Object obj = params.get("AsstActType");
        if (obj == null) {
            return;
        }
        AsstActTypeInfo asst = (AsstActTypeInfo)obj;
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        TreeTAccount child = null;
        String asstName = null;
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            if (!StringUtils.isEmpty((String)info.getCfiAssistDisplayNameGroup())) {
                int start = info.getCfiAssistDisplayNameGroup().indexOf(asst.getName() + ":");
                if (start >= 0) {
                    int end = info.getCfiAssistDisplayNameGroup().indexOf(";", start);
                    asstName = info.getCfiAssistDisplayNameGroup().substring(start, end);
                } else {
                    asstName = NUMBER_NOT_ASSIST;
                }
            } else {
                asstName = NUMBER_NOT_ASSIST;
            }
            child = this.searchChild(asstName);
            if (child == null) {
                child = new TreeTAccount();
                child.setNumber(asstName);
                if (NUMBER_NOT_ASSIST.equals(asstName)) {
                    child.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"188_TreeTAccount"));
                    child.setType(8);
                } else {
                    child.setName(info.getCfiAssistDisplayNameGroup());
                    child.setType(8);
                }
                child.setLevel(this.level + 1);
                child.setDebit(this.isDebit);
                child.setCash(this.isCash);
            }
            child.addCashflowRecord(info);
            child.addAmount(info.getAmount());
            this.addChild(child);
        }
    }

    private void recreateChildrenByAccountAssist(Map params) {
        Object obj = params.get("AsstActType");
        if (obj == null) {
            return;
        }
        AsstActTypeInfo asst = (AsstActTypeInfo)obj;
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        TreeTAccount child = null;
        String asstName = null;
        String assistGroup = null;
        String prefix = null;
        boolean isShowLongName = false;
        try {
            Object objIsShowLongName = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_066");
            if (objIsShowLongName != null) {
                isShowLongName = Boolean.valueOf(objIsShowLongName.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        boolean isShowNumber = false;
        try {
            Object objIsShowNumber = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_004");
            if (objIsShowNumber != null) {
                isShowNumber = Boolean.valueOf(objIsShowNumber.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            assistGroup = "";
            prefix = "";
            if (isShowNumber) {
                if (isShowLongName) {
                    if (!StringUtils.isEmpty((String)info.getAccountAssistDisplayNameGroup())) {
                        assistGroup = info.getAccountAssistDisplayNameGroup().replaceAll("_!", " ");
                        prefix = asst.getName() + ":";
                    }
                } else if (!StringUtils.isEmpty((String)info.getAccountAssistNumberGroup())) {
                    assistGroup = info.getAccountAssistNumberGroup().replaceAll("_!", " ");
                    prefix = asst.getNumber() + " " + asst.getName() + ":";
                }
            } else if (isShowLongName) {
                if (!StringUtils.isEmpty((String)info.getAccountAssistDisplayNameGroup())) {
                    assistGroup = info.getAccountAssistDisplayNameGroup().replaceAll("_!", " ");
                    prefix = asst.getName() + ":";
                }
            } else if (!StringUtils.isEmpty((String)info.getAccountAssistLongNameGroup())) {
                assistGroup = info.getAccountAssistLongNameGroup().replaceAll("_!", " ");
                prefix = asst.getName() + ":";
            }
            if (!StringUtils.isEmpty((String)assistGroup)) {
                int start = assistGroup.indexOf(prefix);
                if (start >= 0) {
                    int end = assistGroup.indexOf(";", start);
                    asstName = assistGroup.substring(start, end);
                } else {
                    asstName = NUMBER_NOT_ASSIST;
                }
            } else {
                asstName = NUMBER_NOT_ASSIST;
            }
            child = this.searchChild(asstName);
            if (child == null) {
                child = new TreeTAccount();
                child.setNumber(asstName);
                if (NUMBER_NOT_ASSIST.equals(asstName)) {
                    child.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"188_TreeTAccount"));
                    child.setType(7);
                } else {
                    child.setName(asstName);
                    child.setType(7);
                }
                child.setLevel(this.level + 1);
                child.setDebit(this.isDebit);
                child.setCash(this.isCash);
            }
            child.addCashflowRecord(info);
            child.addAmount(info.getAmount());
            this.addChild(child);
        }
    }

    private void recreateChildrenByAccount(Map params) {
        Map accounts = (Map)params.get("account");
        TreeTAccount tAccount = this;
        while (!tAccount.isExpandedAccount() && tAccount.getLevel() != 0) {
            tAccount = tAccount.getParent();
        }
        String expandedNumber = null;
        expandedNumber = tAccount.getLevel() != 0 ? tAccount.getNumber() : "";
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        String longNumber = null;
        String infoNumber = null;
        int beginIndex = 0;
        int endIndex = 0;
        TreeTAccount child = null;
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            longNumber = info.getOpposingEntryAccountLongNumber();
            beginIndex = "".equals(expandedNumber) ? 0 : longNumber.indexOf(expandedNumber) + expandedNumber.length() + 1;
            if (beginIndex >= longNumber.length()) continue;
            endIndex = longNumber.substring(beginIndex).indexOf("!");
            if (endIndex == -1) {
                infoNumber = longNumber.substring(beginIndex);
            } else {
                endIndex = beginIndex + endIndex;
                infoNumber = longNumber.substring(beginIndex, endIndex);
            }
            child = this.searchChild(infoNumber);
            if (child == null) {
                child = new TreeTAccount();
                child.setNumber(infoNumber);
                AccountViewInfo av = (AccountViewInfo)accounts.get(infoNumber);
                child.setName(av == null ? infoNumber : infoNumber + "_" + av.getName());
                int childType = this.type == 6 || this.type == 9 || this.type == 4 || this.type == 8 ? 4 : 3;
                child.setType(childType);
                child.setLevel(this.level + 1);
                child.setDebit(this.isDebit);
                child.setCash(this.isCashAccount(av));
            }
            child.addCashflowRecord(info);
            child.addAmount(info.getAmount());
            this.addChild(child);
        }
    }

    private boolean isExpandedAccount() {
        return this.type == 3 || this.type == 4 || this.type == 5;
    }

    private void recreateChildrenByCFI(Map params) {
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        TreeTAccount child = null;
        String infoNumber = null;
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            infoNumber = info.getCashflowItemNumber();
            if (infoNumber == null || infoNumber.trim().length() == 0) {
                infoNumber = NUMBER_NOT_CFI;
            }
            if ((child = this.searchChild(infoNumber)) == null) {
                child = new TreeTAccount();
                child.setNumber(infoNumber);
                if (NUMBER_NOT_CFI.equals(infoNumber)) {
                    child.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"189_TreeTAccount"));
                    child.setType(9);
                } else {
                    child.setName(info.getCashflowItemNumber() + "_" + info.getCashflowItemName());
                    child.setType(6);
                }
                child.setLevel(this.level + 1);
                child.setDebit(this.isDebit);
                child.setCash(this.isCash);
            }
            child.addCashflowRecord(info);
            if (NUMBER_NOT_CFI.equals(infoNumber)) {
                child.addAmount(info.getAmount());
            } else if (info.isEntryDebit() && CashFlowDirection.OUT == info.getDirection() || !info.isEntryDebit() && CashFlowDirection.IN == info.getDirection()) {
                child.addAmount(info.getAmount().negate());
            } else {
                child.addAmount(info.getAmount());
            }
            this.addChild(child);
        }
    }

    public Map getUnAssignedCashflowRecords() {
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        HashMap<String, TAccountCashflowInfo> result = new HashMap<String, TAccountCashflowInfo>();
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            if (info.getSourceType() != 2) continue;
            result.put(info.getId(), info);
        }
        return result;
    }

    public Map getAssignedCashflowRecords() {
        Iterator it = this.cashflowRecords.values().iterator();
        TAccountCashflowInfo info = null;
        HashMap<String, TAccountCashflowInfo> result = new HashMap<String, TAccountCashflowInfo>();
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            if (info.getSourceType() != 1) continue;
            result.put(info.getId(), info);
        }
        return result;
    }

    public void replaceCashflowRecords(Map newRecords) {
        Iterator it = newRecords.keySet().iterator();
        String oldKey = null;
        TAccountCashflowInfo oldObj = null;
        while (it.hasNext()) {
            oldKey = (String)it.next();
            oldObj = this.removeCashflowRecord(oldKey);
            if (oldObj == null) continue;
            this.addCashflowRecord((TAccountCashflowInfo)newRecords.get(oldKey));
        }
        Map children = this.getChildren();
        Iterator itChildren = children.values().iterator();
        TreeTAccount child = null;
        while (itChildren.hasNext()) {
            child = (TreeTAccount)itChildren.next();
            child.replaceCashflowRecords(newRecords);
        }
    }

    public int compareTo(Object anotherObj) {
        if (!(anotherObj instanceof TreeTAccount)) {
            return 1;
        }
        String anotherNumber = ((TreeTAccount)anotherObj).getNumber();
        if (anotherNumber == null || NUMBER_NOT_CFI.equals(anotherNumber) || NUMBER_NOT_ASSIST.equals(anotherNumber)) {
            return -1;
        }
        if (this.number == null) {
            return -1;
        }
        return this.number.compareTo(anotherNumber);
    }

    private boolean isCashAccount(AccountViewInfo acct) {
        if (acct == null) {
            return false;
        }
        return acct.isIsCash() || acct.isIsBank() || acct.isIsCashEquivalent();
    }
}

