/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.gl.client.AbstractTryBalanceUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;

public class TryBalanceUI
extends AbstractTryBalanceUI {
    private static final long serialVersionUID = 184980649770064737L;
    private static final String COLUMN_ITEM = "Item";
    private static final String COLUMN_DEBIT = "Debit";
    private static final String COLUMN_CREDIT = "Credit";
    private static final String COLUMN_BALANCE = "Balance";
    public final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.TryBalanceResource";
    private int amountScale;

    public TryBalanceUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() {
        this.setPreferredSize(new Dimension(556, 359));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.amountScale = (Integer)this.getUIContext().get("amountScale");
        HashMap results = (HashMap)this.getUIContext().get("data");
        String currencyid = (String)this.getUIContext().get("currencyid");
        Boolean succeed = (Boolean)results.get("succeed");
        String title_MonthBegin = null;
        String title_BeginDebit = null;
        String title_BeginCredit = null;
        String title_Year = null;
        String title_YearDebit = null;
        String title_YearCredit = null;
        if (currencyid.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            title_MonthBegin = "MonthBeginLocal";
            title_BeginDebit = "beginDebitLocal";
            title_BeginCredit = "beginCreditLocal";
            title_Year = "YearLocal";
            title_YearDebit = "yearDebitLocal";
            title_YearCredit = "yearCreditLocal";
        } else if (currencyid.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
            title_MonthBegin = "MonthBeginReport";
            title_BeginDebit = "beginDebitReport";
            title_BeginCredit = "beginCreditReport";
            title_Year = "YearReport";
            title_YearDebit = "yearDebitReport";
            title_YearCredit = "yearCreditReport";
        } else {
            title_MonthBegin = "MonthBeginOrigin";
            title_BeginDebit = "beginDebitFor";
            title_BeginCredit = "beginCreditFor";
            title_Year = "YearOrigin";
            title_YearDebit = "yearDebitFor";
            title_YearCredit = "yearCreditFor";
        }
        String monthBegin = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TryBalanceResource", (String)title_MonthBegin);
        this.tblMain.getColumn(COLUMN_DEBIT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.amountScale));
        this.tblMain.getColumn(COLUMN_CREDIT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.amountScale));
        this.tblMain.getColumn(COLUMN_BALANCE).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.amountScale));
        IRow row = this.tblMain.addRow();
        BigDecimal beginDebit = (BigDecimal)results.get(title_BeginDebit);
        BigDecimal beginCredit = (BigDecimal)results.get(title_BeginCredit);
        BigDecimal balance1 = beginDebit.subtract(beginCredit);
        row.getCell(COLUMN_ITEM).setValue((Object)monthBegin);
        row.getCell(COLUMN_DEBIT).setValue((Object)this.getScaleBigDecimal(beginDebit));
        row.getCell(COLUMN_CREDIT).setValue((Object)this.getScaleBigDecimal(beginCredit));
        row.getCell(COLUMN_BALANCE).setValue((Object)this.getScaleBigDecimal(balance1));
        PeriodInfo currentPeriod = (PeriodInfo)results.get("currentPeriod");
        if (currentPeriod.getPeriodNumber() != 1) {
            String year = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TryBalanceResource", (String)title_Year);
            row = this.tblMain.addRow();
            beginDebit = (BigDecimal)results.get(title_YearDebit);
            beginCredit = (BigDecimal)results.get(title_YearCredit);
            BigDecimal balance2 = beginDebit.subtract(beginCredit);
            row.getCell(COLUMN_ITEM).setValue((Object)year);
            row.getCell(COLUMN_DEBIT).setValue((Object)this.getScaleBigDecimal(beginDebit));
            row.getCell(COLUMN_CREDIT).setValue((Object)this.getScaleBigDecimal(beginCredit));
            row.getCell(COLUMN_BALANCE).setValue((Object)this.getScaleBigDecimal(balance2));
        }
        if (succeed.booleanValue()) {
            this.lblBalance.setVisible(true);
            this.lblNotBalance.setVisible(false);
        } else {
            this.lblBalance.setVisible(false);
            this.lblNotBalance.setVisible(true);
        }
    }

    @Override
    public void closeAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private BigDecimal getScaleBigDecimal(BigDecimal bd) {
        if (bd == null) {
            return bd;
        }
        return bd.setScale(this.amountScale, 4);
    }
}

