/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VchAmortSchemeFactory;
import com.kingdee.eas.fi.gl.client.AbstractVchAmortSchemeFilterPanel;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.client.GLEditUIUtil;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class VchAmortSchemeFilterPanel
extends AbstractVchAmortSchemeFilterPanel {
    private static final Logger logger = CoreUIObject.getLogger(VchAmortSchemeFilterPanel.class);
    private CurrencyCollection currencys = null;
    private String uiParam = null;
    private Map initData = null;
    private CompanyOrgUnitInfo curCompany = null;

    public VchAmortSchemeFilterPanel(String uiParam) throws Exception {
        this.uiParam = uiParam;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws BOSException, EASBizException, Exception {
        if (this.curCompany == null) {
            this.curCompany = GLEditUIUtil.getFirstCompany(this.getPermissionItem());
        }
        if (this.curCompany == null) {
            this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        this.initData = VchAmortSchemeFactory.getRemoteInstance().fetchInitFilterData(this.curCompany.getId().toString());
        this.currencys = (CurrencyCollection)this.initData.get("Currency");
        this.initCompanyF7();
        this.initAccountTableComboBox(this.initData);
        this.initAccountF7();
        ClientHelper.refreshCurrency(this.cbxCurrency, this.currencys);
    }

    private void initAccountF7() throws EASBizException, BOSException {
        this.pbxTargetAccountFrom.setEditFormat("$number$");
        this.pbxTargetAccountFrom.setCommitFormat("$helpCode$;$name$;$number$");
        this.pbxTargetAccountFrom.setDisplayFormat("$number$ - $name$");
        this.pbxTargetAccountFrom.setCommitParser((IParser)new AccountViewParser(this.pbxTargetAccountFrom));
        this.pbxTargetAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxTargetAccountFrom.setEnabledMultiSelection(false);
        this.pbxTargetAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    VchAmortSchemeFilterPanel.this.pbxTargetAccountFrom_dataChanged(e);
                }
                catch (Exception exc) {
                    VchAmortSchemeFilterPanel.this.handUIException(exc);
                }
            }
        });
        this.pbxTargetAccountTo.setEditFormat("$number$");
        this.pbxTargetAccountTo.setCommitFormat("$helpCode$;$name$;$number$");
        this.pbxTargetAccountTo.setDisplayFormat("$number$ - $name$");
        this.pbxTargetAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxTargetAccountTo.setEnabledMultiSelection(false);
        this.pbxDestAccountFrom.setEditFormat("$number$");
        this.pbxDestAccountFrom.setCommitFormat("$helpCode$;$name$;$number$");
        this.pbxDestAccountFrom.setDisplayFormat("$number$ - $name$");
        this.pbxDestAccountFrom.setCommitParser((IParser)new AccountViewParser(this.pbxDestAccountFrom));
        this.pbxDestAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxDestAccountFrom.setEnabledMultiSelection(false);
        this.pbxDestAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    VchAmortSchemeFilterPanel.this.pbxDestAccountFrom_dataChanged(e);
                }
                catch (Exception exc) {
                    VchAmortSchemeFilterPanel.this.handUIException(exc);
                }
            }
        });
        this.pbxDestAccountTo.setEditFormat("$number$");
        this.pbxDestAccountTo.setCommitFormat("$helpCode$;$name$;$number$");
        this.pbxDestAccountTo.setDisplayFormat("$number$ - $name$");
        this.pbxDestAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxDestAccountTo.setEnabledMultiSelection(false);
    }

    protected void pbxDestAccountFrom_dataChanged(DataChangeEvent e) {
        Object accountFrom = this.pbxDestAccountFrom.getValue();
        Object accountTo = this.pbxDestAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.pbxDestAccountTo.setValue(accountFrom);
        }
    }

    @Override
    protected void pbxTargetAccountFrom_dataChanged(DataChangeEvent e) {
        Object accountFrom = this.pbxTargetAccountFrom.getValue();
        Object accountTo = this.pbxTargetAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.pbxTargetAccountTo.setValue(accountFrom);
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("SchemeName", this.txtName.getText());
        if (this.bpCompany.getValue() != null) {
            params.put("company", this.bpCompany.getValue());
        }
        params.put("accountTable", this.bpAccount.getSelectedItem());
        if (this.pbxTargetAccountFrom.getValue() != null) {
            params.put("TargetFrom", this.pbxTargetAccountFrom.getValue());
        }
        if (this.pbxTargetAccountTo.getValue() != null) {
            params.put("TargetTo", this.pbxTargetAccountTo.getValue());
        }
        if (this.pbxDestAccountFrom.getValue() != null) {
            params.put("DestFrom", this.pbxDestAccountFrom.getValue());
        }
        if (this.pbxDestAccountTo.getValue() != null) {
            params.put("DestTo", this.pbxDestAccountTo.getValue());
        }
        if (this.cbxCurrency.getSelectedItem() instanceof CurrencyInfo) {
            params.put("Currency", ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString());
        }
        if (this.chkUnused.isSelected()) {
            params.put("Unused", Boolean.TRUE.toString());
        }
        if (this.chkUsed.isSelected()) {
            params.put("Used", Boolean.TRUE.toString());
        }
        if (this.chkFinished.isSelected()) {
            params.put("Finished", Boolean.TRUE.toString());
        }
        if (this.chkClosed.isSelected()) {
            params.put("Closed", Boolean.TRUE.toString());
        }
        return params;
    }

    public void setParam(Object param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        Map params = (Map)param;
        if (params.containsKey("company")) {
            CompanyOrgUnitInfo[] companys = null;
            if (params.get("company") instanceof CompanyOrgUnitInfo) {
                companys = new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)params.get("company")};
            } else if (params.get("company") instanceof CompanyOrgUnitInfo[]) {
                companys = (CompanyOrgUnitInfo[])params.get("company");
            } else {
                Object[] obj = (Object[])params.get("company");
                companys = new CompanyOrgUnitInfo[obj.length];
                System.arraycopy(obj, 0, companys, 0, obj.length);
            }
            companys = this.filterCompany(companys);
            this.bpCompany.setValue((Object)companys);
        } else {
            this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{GLEditUIUtil.getFirstCompany("gl_vchamort_query")});
        }
        if (params.get("accountTable") != null) {
            this.bpAccount.setSelectedItem(params.get("accountTable"));
        } else {
            this.setSelectedItem(this.bpAccount, null);
        }
        if (params.get("SchemeName") != null) {
            this.txtName.setText(params.get("SchemeName").toString());
        }
        if (params.get("TargetFrom") != null) {
            this.pbxTargetAccountFrom.setValue(params.get("TargetFrom"));
        }
        if (params.get("TargetTo") != null) {
            this.pbxTargetAccountTo.setValue(params.get("TargetTo"));
        }
        if (params.get("DestFrom") != null) {
            this.pbxDestAccountFrom.setValue(params.get("DestFrom"));
        }
        if (params.get("DestTo") != null) {
            this.pbxDestAccountTo.setValue(params.get("DestTo"));
        }
        if (params.get("Currency") != null) {
            String currencyId = params.get("Currency").toString();
            boolean found = false;
            for (int i = 0; i < this.cbxCurrency.getItemCount(); ++i) {
                CurrencyInfo currencyInfo;
                Object object = this.cbxCurrency.getItemAt(i);
                if (!(object instanceof CurrencyInfo) || (currencyInfo = (CurrencyInfo)object) == null || !currencyId.equals(currencyInfo.getId().toString())) continue;
                this.cbxCurrency.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                this.cbxCurrency.setSelectedIndex(0);
            }
        } else {
            this.cbxCurrency.setSelectedIndex(0);
        }
        if (params.get("Unused") != null) {
            this.chkUnused.setSelected(true);
        }
        if (params.get("Used") != null) {
            this.chkUsed.setSelected(true);
        }
        if (params.get("Finished") != null) {
            this.chkFinished.setSelected(true);
        }
        if (params.get("Closed") != null) {
            this.chkClosed.setSelected(true);
        }
    }

    public void clear() {
        CompanyOrgUnitInfo firstCompany = null;
        try {
            firstCompany = GLEditUIUtil.getFirstCompany("gl_vchamort_query");
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (firstCompany != null) {
            this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
        } else {
            this.bpCompany.setValue(null);
        }
        this.bpAccount.setSelectedIndex(0);
        this.txtName.setText(null);
        this.pbxTargetAccountFrom.setValue(null);
        this.pbxTargetAccountTo.setValue(null);
        this.pbxDestAccountFrom.setValue(null);
        this.pbxDestAccountTo.setValue(null);
        this.cbxCurrency.setSelectedIndex(0);
        this.chkUnused.setSelected(false);
        this.chkUsed.setSelected(false);
        this.chkFinished.setSelected(false);
        this.chkClosed.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        Set companyIdSet = this.getCompanyIdSet();
        if (companyIdSet.size() == 0) {
            companyIdSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            filterItems.add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        } else {
            filterItems.add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
        }
        mask.append("#").append(index++);
        if (this.cbxCurrency.getSelectedItem() instanceof CurrencyInfo) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getId().toString(), CompareType.EQUALS));
            mask.append(" and #").append(index++);
        }
        if (this.bpAccount.getSelectedItem() != null) {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            filterItems.add(new FilterItemInfo("tAccount.accountTableID.id", (Object)accountTable.getId().toString(), CompareType.EQUALS));
            mask.append(" and #").append(index++);
            filterItems.add(new FilterItemInfo("dAccount.accountTableID.id", (Object)accountTable.getId().toString(), CompareType.EQUALS));
            mask.append(" and #").append(index++);
        }
        if (!StringUtils.isEmpty((String)this.txtName.getText())) {
            String value = this.txtName.getText().trim();
            filterItems.add(new FilterItemInfo("name", (Object)("%" + value + "%"), CompareType.LIKE));
            filterItems.add(new FilterItemInfo("number", (Object)("%" + value + "%"), CompareType.LIKE));
            mask.append(" and (#").append(index++).append(" or #");
            mask.append(index++).append(")");
        }
        if (this.pbxTargetAccountFrom.getValue() != null) {
            filterItems.add(new FilterItemInfo("tAccount.number", (Object)((AccountViewInfo)this.pbxTargetAccountFrom.getValue()).getNumber(), CompareType.GREATER_EQUALS));
            mask.append(" and #").append(index++);
        }
        if (this.pbxTargetAccountTo.getValue() != null) {
            filterItems.add(new FilterItemInfo("tAccount.number", (Object)(((AccountViewInfo)this.pbxTargetAccountTo.getValue()).getNumber() + "z"), CompareType.LESS_EQUALS));
            mask.append(" and #").append(index++);
        }
        if (this.pbxDestAccountFrom.getValue() != null) {
            filterItems.add(new FilterItemInfo("dAccount.number", (Object)((AccountViewInfo)this.pbxDestAccountFrom.getValue()).getNumber(), CompareType.GREATER_EQUALS));
            mask.append(" and #").append(index++);
        }
        if (this.pbxDestAccountTo.getValue() != null) {
            filterItems.add(new FilterItemInfo("dAccount.number", (Object)(((AccountViewInfo)this.pbxDestAccountTo.getValue()).getNumber() + "z"), CompareType.LESS_EQUALS));
            mask.append(" and #").append(index++);
        }
        StringBuffer statusMask = new StringBuffer();
        if (this.chkUnused.isSelected()) {
            filterItems.add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
            statusMask.append("(#").append(index++);
        }
        if (this.chkUsed.isSelected()) {
            filterItems.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS));
            if (statusMask.length() > 0) {
                statusMask.append(" or #").append(index++);
            } else {
                statusMask.append("(#").append(index++);
            }
        }
        if (this.chkFinished.isSelected()) {
            filterItems.add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.EQUALS));
            if (statusMask.length() > 0) {
                statusMask.append(" or #").append(index++);
            } else {
                statusMask.append("(#").append(index++);
            }
        }
        if (this.chkClosed.isSelected()) {
            filterItems.add(new FilterItemInfo("status", (Object)new Integer(4), CompareType.EQUALS));
            if (statusMask.length() > 0) {
                statusMask.append(" or #").append(index++);
            } else {
                statusMask.append("(#").append(index++);
            }
        }
        if (statusMask.length() > 0) {
            statusMask.append(")");
            filter.setMaskString(mask.append(" and ").append(statusMask).toString());
        } else {
            filter.setMaskString(mask.toString());
        }
        return filter;
    }

    private void initCompanyF7() throws Exception {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.bpCompany.setEntityViewInfo(companyView);
        this.bpCompany.setSelector(this.getCompanySelector());
        this.bpCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                if (VchAmortSchemeFilterPanel.this.isCompanyChanged(event)) {
                    VchAmortSchemeFilterPanel.this.companyChanged();
                }
            }
        });
    }

    protected KDPromptSelector getCompanySelector() {
        if (!GlUtils.isEmpty(this.uiParam) && "FSSC".equalsIgnoreCase(this.uiParam)) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.bpCompany, this.getPermissionItem(), true);
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        companySelector.setExtraTreeFilters("\"STRUCTURE\".FUnitID in (" + this.getCompanyIdFilter() + ")");
        return companySelector;
    }

    private String getPermissionItem() {
        return "gl_vchamort_query";
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getCompanyIdFilter() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void initAccountTableComboBox(Map initData) throws Exception {
        AccountTableCollection accountTables = (AccountTableCollection)initData.get("accountTable");
        Vector accountTableList = this.toVector((AbstractObjectCollection)accountTables);
        accountTableList.add(0, null);
        this.bpAccount.setModel(new DefaultComboBoxModel(accountTableList));
        this.bpAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1 || VchAmortSchemeFilterPanel.this.bpAccount.getSelectedItem() == null) {
                        VchAmortSchemeFilterPanel.this.accountTableChanged();
                    }
                }
                catch (Exception e) {
                    VchAmortSchemeFilterPanel.this.handUIException(e);
                }
            }
        });
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    protected void companyChanged() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        boolean isEnable = companys != null;
        Object accountTable = this.bpAccount.getSelectedItem();
        this.pbxTargetAccountFrom.setEnabled(isEnable && accountTable != null);
        this.pbxTargetAccountTo.setEnabled(isEnable && accountTable != null);
        this.pbxDestAccountFrom.setEnabled(isEnable && accountTable != null);
        this.pbxDestAccountTo.setEnabled(isEnable && accountTable != null);
        this.setAccountF7Filter();
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.bpCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.bpCompany.getValue();
        }
        if (this.bpCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.bpCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    protected void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (accountTable == null || companys == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            for (int i = 0; i < companys.length; ++i) {
                companyColl.add(companys[i]);
            }
            HashSet<Integer> budgets = new HashSet<Integer>();
            budgets.add(12);
            budgets.add(13);
            budgets.add(14);
            FilterInfo treeNodefilter = new FilterInfo();
            treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.NOTINCLUDE));
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
            fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("control", null));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)this.curCompany.getAccountTable().getId().toString()));
            fic.add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            filter.setMaskString("#0 AND #1 AND #2 AND #3 AND ( #4 or  #5)  AND #6 AND #7");
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            apb.setTreeNodefilter(treeNodefilter);
            this.pbxTargetAccountFrom.setSelector((KDPromptSelector)apb);
            apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            apb.setTreeNodefilter(treeNodefilter);
            this.pbxTargetAccountTo.setSelector((KDPromptSelector)apb);
            apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            apb.setTreeNodefilter(treeNodefilter);
            this.pbxDestAccountFrom.setSelector((KDPromptSelector)apb);
            apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            apb.setTreeNodefilter(treeNodefilter);
            this.pbxDestAccountTo.setSelector((KDPromptSelector)apb);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    public boolean verify() {
        if (this.getCompanys() == null) {
            this.bpCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"104_HGReplaceToolUI"));
            return false;
        }
        if (!this.verifyViewPermission()) {
            return false;
        }
        return super.verify();
    }

    private boolean verifyViewPermission() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        StringBuffer errOrg = new StringBuffer();
        try {
            Map mapOrgWithPerm = GLGeneralFacadeFactory.getRemoteInstance().getOrgWithPerm(this.getPermissionItem(), companys);
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company = companys[i];
                if (mapOrgWithPerm.containsKey(company.getId().toString())) continue;
                if (errOrg.length() > 0) {
                    errOrg.append(",");
                }
                errOrg.append(company.getName());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (errOrg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CWGXResource", (String)"solutionNotValid"), errOrg.toString()));
            return false;
        }
        return true;
    }

    private CompanyOrgUnitInfo[] filterCompany(CompanyOrgUnitInfo[] companys) {
        HashSet<String> companyIdSet = new HashSet<String>();
        if (companys == null || companys.length <= 0) {
            return null;
        }
        for (int i = 0; i < companys.length; ++i) {
            companyIdSet.add(companys[i].getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        fic.add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(GlUtils.getCompanySic());
        CompanyOrgUnitCollection collection = null;
        try {
            collection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (collection.size() == 0) {
            return null;
        }
        Object[] obj = collection.toArray();
        CompanyOrgUnitInfo[] companyArray = new CompanyOrgUnitInfo[obj.length];
        System.arraycopy(obj, 0, companyArray, 0, obj.length);
        return companyArray;
    }

    protected void setSelectedItem(KDComboBox comboBox, Object value) {
        if (value == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (value == object) {
                comboBox.setSelectedIndex(i);
                break;
            }
            if (!(value instanceof DataBaseInfo) || !(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !((DataBaseInfo)value).getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    protected void accountTableChanged() throws Exception {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        boolean b = account != null && this.getCompanys() != null;
        this.pbxTargetAccountFrom.setEnabled(b);
        this.pbxTargetAccountFrom.setValue(null);
        this.pbxTargetAccountTo.setEnabled(b);
        this.pbxTargetAccountTo.setValue(null);
        this.pbxDestAccountFrom.setEnabled(b);
        this.pbxDestAccountFrom.setValue(null);
        this.pbxDestAccountTo.setEnabled(b);
        this.pbxDestAccountTo.setValue(null);
        this.setAccountF7Filter();
    }
}

