/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.formbrowser2.ClientForm;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.DefaultPreviewFrame;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherRowSetProvider;
import com.kingdee.eas.fi.gl.client.AbstractVchPrintTplSelectUI;
import com.kingdee.eas.fi.gl.client.VchTplException;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class VchPrintTplSelectUI
extends AbstractVchPrintTplSelectUI {
    public static final String ROOT_PATH = "user.dir";
    public static final String SUBDIR_VOUCHER = "voucher";
    public static final String LIST_FILE = "list.xml";
    public static final String TPL_NODE = "tpl";
    public static final String TPL_ID_NODE = "id";
    public static final String TPL_ALIAS_NODE = "alias";
    public static final String TPL_DESC_NODE = "desc";
    public static final String TPL_FILE_NODE = "file";
    static final String PARENT = "VCH_PREVIEW_PARENT";
    static final String VCHCOL = "VCH_PREVIEW_VCHCOL";
    static final String NOPREVIEW = "VCH_PREVIEW_NOPREVIEW";
    private Object parentUI;
    private boolean noPreview;
    private VoucherCollection vchCol;
    private String workDir;

    public VchPrintTplSelectUI() throws Exception {
        this.txtDesc.setLineWrap(true);
        Dimension size = new Dimension(410, 260);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.initTplList();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() {
        Map map = this.getUIContext();
        this.parentUI = map.get("Owner");
        this.vchCol = (VoucherCollection)map.get(VCHCOL);
        this.noPreview = (Boolean)map.get(NOPREVIEW);
    }

    public void initTplList() throws Exception {
        String path = System.getProperty(ROOT_PATH);
        if (path == null) {
            throw new VchTplException(VchTplException.NOSYSPROP, new Object[]{ROOT_PATH});
        }
        this.workDir = path + File.separator + SUBDIR_VOUCHER;
        String listFile = this.workDir + File.separator + LIST_FILE;
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(listFile);
        }
        catch (IOException ex) {
            throw new VchTplException(VchTplException.NOLISTFILE, ex, new Object[]{listFile});
        }
        catch (JDOMException ex) {
            throw new VchTplException(VchTplException.INVALIDLISTFORMAT, ex);
        }
        Element root = doc.getRootElement();
        List tplList = XPath.selectNodes((Object)root, (String)TPL_NODE);
        if (tplList.size() == 0) {
            throw new VchTplException(VchTplException.NOTPL);
        }
        Iterator itrTpl = tplList.iterator();
        Vector<TplInfo> tplInfoList = new Vector<TplInfo>();
        int count = 0;
        while (itrTpl.hasNext()) {
            Element tplNode = (Element)itrTpl.next();
            ++count;
            TplInfo ti = new TplInfo();
            tplInfoList.add(ti);
            Element idNode = (Element)XPath.selectSingleNode((Object)tplNode, (String)TPL_ID_NODE);
            Element aliasNode = (Element)XPath.selectSingleNode((Object)tplNode, (String)TPL_ALIAS_NODE);
            Element descNode = (Element)XPath.selectSingleNode((Object)tplNode, (String)TPL_DESC_NODE);
            Element fileNode = (Element)XPath.selectSingleNode((Object)tplNode, (String)TPL_FILE_NODE);
            if (idNode != null) {
                ti.id = idNode.getText();
            }
            if (aliasNode != null) {
                ti.alias = aliasNode.getText();
            }
            if (descNode != null) {
                ti.desc = descNode.getText();
            }
            if (fileNode != null) {
                ti.file = fileNode.getText();
            }
            if (ti.id == null || ti.id.trim().length() == 0) {
                throw new VchTplException(VchTplException.NOTPLATTRID, new Object[]{new Integer(count)});
            }
            if (ti.alias == null || ti.alias.trim().length() == 0) {
                throw new VchTplException(VchTplException.NOTPLATTRALIAS, new Object[]{new Integer(count)});
            }
            if (ti.file != null && ti.file.trim().length() != 0) continue;
            throw new VchTplException(VchTplException.NOTPLATTRFILE, new Object[]{new Integer(count)});
        }
        this.cbxTpl.addItems(tplInfoList);
    }

    @Override
    protected void cbxTpl_actionPerformed(ActionEvent e) throws Exception {
        TplInfo ti = (TplInfo)this.cbxTpl.getSelectedItem();
        this.txtDesc.setText(ti.desc);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
        String vchType = ((TplInfo)this.cbxTpl.getSelectedItem()).file;
        String file = this.workDir + File.separator + vchType;
        String file1 = file + "_" + SysContext.getSysContext().getLocale().getLanguage() + ".kdf";
        if (!new File(file1).exists() && !new File(file1 = file + ".kdf").exists()) {
            throw new VchTplException(VchTplException.NOTPLFILE, new Object[]{file1});
        }
        ClientForm cf = new ClientForm();
        final VoucherRowSetProvider rsprv = new VoucherRowSetProvider(this.vchCol, null);
        IServerPluginParam sp = new IServerPluginParam(){

            public String getClassName() {
                return "com.kingdee.eas.fi.gl.client.VoucherServerPlugin";
            }

            public Object getUserParam() {
                return rsprv;
            }

            public void notify(Object userResult) {
            }
        };
        cf.setPlugins(new IServerPluginParam[]{sp});
        cf.setTemplate(file1);
        Thread worker = cf.startRetriveData();
        if (!this.noPreview) {
            DefaultPreviewFrame previewFrame = new DefaultPreviewFrame(false, cf);
            previewFrame.setVisible(true);
            worker.join();
        } else {
            worker.join();
            cf.getPrintService().print();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    static class TplInfo {
        public String id;
        public String alias;
        public String desc;
        public String file;

        TplInfo() {
        }

        public String toString() {
            return this.alias;
        }
    }
}

